unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, nUsbDevice, ImgList;

type
  TMainForm = class(TForm)
    Label1: TLabel;
    UsbList: TListView;
    ImageList: TImageList;
    DriveCheck: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure UsbListDblClick(Sender: TObject);
    procedure DriveCheckClick(Sender: TObject);
  private
    { Private 錾 }
    procedure SetUsbList;
  public
    { Public 錾 }
    procedure WMDeviceChange(var Msg: TMessage); message WM_DEVICECHANGE;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.SetUsbList;
var
  no, count, itype: Integer;
  li: TListItem;
  name: array [0..255] of Char;
  description: array [0..255] of Char;
  str: String;
begin
  UsbList.Items.Clear;
  itype := NUSB_GET_USB_DEVICE;
  if DriveCheck.Checked then
    itype := NUSB_GET_DRIVE_DEVICE;
  count := NUsbGetDeviceData(itype);
  if ImageList.Tag = 0 then
  begin
    ImageList.Tag := 1;
    ImageList.Handle := NUsbGetImageListHandle;
  end;
  for no := 0 to count - 1 do
  begin
    NUsbGetFriendlyName(no, name, 256);
    NUsbGetDescription(no, description, 256);
    li := UsbList.Items.Add;
    if name[0] = #0 then
      li.Caption := StrPas(description)
    else
      li.Caption := StrPas(name);
    NUsbGetDeviceId(no, name, 256);
    li.SubItems.Add(StrPas(name));
    li.SubItems.Add(StrPas(description));
    NUsbGetManufacturerName(no, name, 256);
    li.SubItems.Add(StrPas(name));
    NUsbGetDriveLetter(no, name, 256);
    li.SubItems.Add(StrPas(name));
    str := '';
    if NUsbCheckRemovableNo(no) then
      str := '';
    li.SubItems.Add(str);
    str := '';
    itype := NUsbGetInterface(no);
    if itype = NUSB_INTERFACE_USB then
      str := 'USB'
    else if itype = NUSB_INTERFACE_ATA then
      str := 'ATA'
    else if itype = NUSB_INTERFACE_SCSI then
      str := 'SCSI'
    else if itype = NUSB_INTERFACE_IEEE1394 then
      str := 'IEEE1394';
    li.SubItems.Add(str);
    li.Data := Pointer(NUsbGetDeviceHandle(no));
    li.ImageIndex := NUsbGetImageListIndex(no);
  end;
  NUsbReleaseDeviceData;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  w: Integer;
begin
  w := (UsbList.ClientWidth - GetSystemMetrics(SM_CXVSCROLL)) div 10;
  UsbList.Columns[0].Width := W * 2;
  UsbList.Columns[1].Width := W * 2;
  UsbList.Columns[2].Width := W * 2;
  UsbList.Columns[3].Width := W;
  UsbList.Columns[4].Width := W;
  UsbList.Columns[5].Width := W;
  UsbList.Columns[6].Width := W;

  SetUsbList;
end;

procedure TMainForm.WMDeviceChange(var Msg: TMessage);
begin
  SetUsbList;
end;

procedure TMainForm.UsbListDblClick(Sender: TObject);
begin
  if UsbList.SelCount > 0 then
    NUsbEjectDeviceHandle(Integer(UsbList.Selected.Data));
end;

procedure TMainForm.DriveCheckClick(Sender: TObject);
begin
  SetUsbList;
end;

end.
