Imports System
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Windows.Forms

Namespace nUsb

	Class Device
        Implements IDisposable

		''' <summary>
		''' foCXłB
		''' </summary>
		''' <remarks>
		''' <see cref="GetData"/>A<see cref="GetDrive"/>̌ʂi[\̂łB
		''' </remarks>
        Public Structure Status
			''' <summary>
			''' foCX̂łBfoCXɂĂ͋̕ɂȂꍇ܂B
			''' </summary>
            Public FriendlyName As String
			''' <summary>
			''' foCX ID łB
			''' </summary>
            Public DeviceId As String
			''' <summary>
			''' n[hEFA ID łB
			''' </summary>
            Public HardwareId As String
			''' <summary>
			''' ẽfoCX ID łB
			''' </summary>
            Public ParentDeviceId As String
			''' <summary>
			''' ҖłB
			''' </summary>
            Public Manufacturer As String
			''' <summary>
			''' foCX̐łB
			''' </summary>
            Public Description As String
			''' <summary>
			''' NXłB
			''' </summary>
            Public ClassName As String
			''' <summary>
			''' T[rXłB
			''' </summary>
            Public ServiceName As String
			''' <summary>
			''' foCXɑΉhCu^[łB
			''' </summary>
            Public DriveLetter As String
			''' <summary>
			''' C[WXg̃CfbNXԍłB
			''' </summary>
            Public ImageIndex As Integer
			''' <summary>
			''' foCXnhłB
			''' <see cref="EjectDevice"/><see cref="CheckInsert"/>Ŏgp܂B
			''' </summary>
            Public DeviceHandle As IntPtr
            ''' <summary>
            ''' ỎۂłB
            ''' </summary>
            Public Removable As Boolean
			''' <summary>
			''' ڑC^[tF[X̎ʂłB
			''' </summary>
            Public InterfaceType As Integer
        End Structure
        ''' <summary>
        ''' ɐ܂B
        ''' </summary>
        Public Const Success As Integer = 0
        ''' <summary>
        ''' foCX݂܂B
        ''' </summary>
        Public Const ErrorNoData As Integer = -1
        ''' <summary>
        ''' OɎs܂B
        ''' </summary>
        Public Const ErrorEject As Integer = -2
        ''' <summary>
        ''' p[^słB
        ''' </summary>
        Public Const ErrorParameter As Integer = -3
        ''' <summary>
        ''' C^[tF[X͕słB
        ''' </summary>
		Public Const InterfaceUnknown  As Integer = 0
        ''' <summary>
        ''' C^[tF[X USB łB
        ''' </summary>
		Public Const InterfaceUSB  As Integer = 1
        ''' <summary>
        ''' C^[tF[X ATA łB
        ''' </summary>
		Public Const InterfaceATA As Integer = 2
        ''' <summary>
        ''' C^[tF[X SCSI łB
        ''' </summary>
		Public Const InterfaceSCSI As Integer = 3
        ''' <summary>
        ''' C^[tF[X IEEE1394 łB
        ''' </summary>
        Public Const InterfaceIEEE1394 As Integer = 4
        ''' <summary>
        ''' USB foCX̃f[^擾܂B
        ''' </summary>
		Public Const ModeUSB As Integer = 0
        ''' <summary>
        ''' hCufoCX̃f[^擾܂B
        ''' </summary>
		Public Const ModeDrive As Integer = 1

        Protected Const BufferSize As Integer = 256

        ''' <summary>
        ''' foCX̐łB
        ''' </summary>
        Protected _usb_count As Integer
		''' <summary>
		''' foCXɑΉACRi[ĂC[WXgłB
		''' </summary>
        Protected _image_list As ImageList = Nothing
		''' <summary>
		''' foCX̔złB
		''' </summary>
        Protected _usb_list As Status() = Nothing
		''' <summary>
		''' Dispose sǂ̃tOłB
		''' </summary>
        Protected _disposed As Boolean = false

        Protected Overrides Sub Finalize()
            MyBase.Finalize()
            Dispose(False)
        End Sub

		''' <summary>
		''' <see cref="Device"/>ɂĎgpĂ邷ׂẴ\[X܂B
		''' </summary>
        Overridable Overloads Sub Dispose() Implements IDisposable.Dispose
            Dispose(True)
            GC.SuppressFinalize(Me)
        End Sub

		''' <summary>
		''' <see cref="Device"/>ɂĎgpĂ邷ׂẴ\[X܂B
		''' </summary>
		''' <param name="disposing">
		''' }l[W\[XƃA}l[W\[X̗ꍇ<c>true</c>B
		''' A}l[W\[Xꍇ<c>false</c>B
		''' </param>
        Protected Overloads Sub Dispose(ByVal disposing As Boolean)
            If Not _disposed Then
                If disposing Then
                End If
                ReleaseImageListHandle()
                _disposed = True
            End If
        End Sub

        ''' <summary>
        ''' foCXɑΉACRi[ĂC[WXg擾܂B
        ''' </summary>
        ''' <returns>C[WXg</returns>
        Public Function GetImageList() As ImageList
            Return _image_list
        End Function

        ''' <summary>
        ''' foCX擾܂B
        ''' </summary>
        ''' <returns>foCX</returns>
        Protected Function GetDeviceDataList(mode as Integer) As Integer
            Dim no As Integer
            Dim count As Integer

            _usb_count = GetDeviceData(mode)
            _usb_list = New Status(_usb_count - 1) {}
            For no = 0 To _usb_count - 1
                Dim name As StringBuilder = New StringBuilder(BufferSize)

                GetFriendlyName(no, name, BufferSize)
                _usb_list(no).FriendlyName = name.ToString()

                GetDeviceId(no, name, BufferSize)
                _usb_list(no).DeviceId = name.ToString()

                GetHardwareId(no, name, BufferSize)
                _usb_list(no).HardwareId = name.ToString()

                GetParentDeviceId(no, name, BufferSize)
                _usb_list(no).ParentDeviceId = name.ToString()

                GetManufacturerName(no, name, BufferSize)
                _usb_list(no).Manufacturer = name.ToString()

                GetDescription(no, name, BufferSize)
                _usb_list(no).Description = name.ToString()

                GetClassName(no, name, BufferSize)
                _usb_list(no).ClassName = name.ToString()

                GetServiceName(no, name, BufferSize)
                _usb_list(no).ServiceName = name.ToString()

                GetDriveLetter(no, name, BufferSize)
                _usb_list(no).DriveLetter = name.ToString()

                _usb_list(no).ImageIndex = GetImageListIndex(no)
                _usb_list(no).DeviceHandle = GetDeviceHandle(no)
                _usb_list(no).Removable = CheckRemovable(_usb_list(no).DeviceHandle)
                _usb_list(no).InterfaceType = GetInterface(no)
            Next no

            If _image_list Is Nothing Then
                Dim Handle As IntPtr = GetImageListHandle()
                count = GetImageCount(Handle)
                _image_list = New ImageList()
                _image_list.ColorDepth = ColorDepth.Depth32Bit
                For no = 0 To count - 1
                    Dim icon_handle As IntPtr = GetIcon(Handle, no, 0)
                    Dim icon As System.Drawing.Icon = System.Drawing.Icon.FromHandle(icon_handle)
                    _image_list.Images.Add(icon)
                    DestroyIcon(icon_handle)
                    icon.Dispose()
                    DestroyIcon(icon.Handle)
                Next no
            End if
            ReleaseDeviceData()
            Return _usb_count
        End Function

        ''' <summary>
        ''' USB foCX擾܂B
        ''' </summary>
        ''' <returns>USB foCX</returns>
        Public Function GetData() As Integer
            GetDeviceDataList(ModeUSB)
        End Function

        ''' <summary>
        ''' hCufoCX擾܂B
        ''' </summary>
        ''' <returns>hCufoCX</returns>
        Public Function GetDrive() As Integer
            GetDeviceDataList(ModeDrive)
        End Function

        ''' <summary>
        ''' foCX\̂̔zԂ܂B
        ''' </summary>
        ''' <returns>foCX\̔z</returns>
        Public Function GetStatusList() As Status()
            Return CType(_usb_list.Clone(), Status())
        End Function

        ''' <summary>
        ''' foCXACR̃C[WXgXV܂
        ''' </summary>
        Public Sub RefreshImageList()
            RefreshImageListHandle()
            If Not (_image_list Is Nothing) Then
                _image_list.Images.Clear()
                _image_list.Dispose()
                _image_list = Nothing
            End If
        End Sub

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetDeviceData")> _
        Protected Shared Function GetDeviceData(ByVal Reserved As Integer) As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbReleaseDeviceData")> _
        Protected Shared Function ReleaseDeviceData() As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetFriendlyName", CharSet:=CharSet.Auto)> _
        Protected Shared Function GetFriendlyName(ByVal No As Integer, ByVal Name As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetDeviceId", CharSet:=CharSet.Auto)> _
        Protected Shared Function GetDeviceId(ByVal No As Integer, ByVal Name As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetHardwareId", CharSet:=CharSet.Auto)> _
        Protected Shared Function GetHardwareId(ByVal No As Integer, ByVal Name As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetParentDeviceId", CharSet:=CharSet.Auto)> _
        Protected Shared Function GetParentDeviceId(ByVal No As Integer, ByVal Name As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetManufacturerName", CharSet:=CharSet.Auto)> _
        Protected Shared Function GetManufacturerName(ByVal No As Integer, ByVal Name As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetDescription", CharSet:=CharSet.Auto)> _
        Protected Shared Function GetDescription(ByVal No As Integer, ByVal Name As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetClassName", CharSet:=CharSet.Auto)> _
        Protected Shared Function GetClassName(ByVal No As Integer, ByVal Name As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetServiceName", CharSet:=CharSet.Auto)> _
        Protected Shared Function GetServiceName(ByVal No As Integer, ByVal Name As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetDriveLetter", CharSet:=CharSet.Auto)> _
        Protected Shared Function GetDriveLetter(ByVal No As Integer, ByVal Name As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetImageListIndex")> _
        Protected Shared Function GetImageListIndex(ByVal No As Integer) As Integer
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetDeviceHandle")> _
        Protected Shared Function GetDeviceHandle(ByVal No As Integer) As IntPtr
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetImageListHandle")> _
        Protected Shared Function GetImageListHandle() As IntPtr
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbGetInterface")> _
        Protected Shared Function GetInterface(ByVal No As Integer) As Integer
        End Function

        ''' <summary>
        ''' USB foCXO邩ׂ܂B
        ''' </summary>
        ''' <param name="Handle">foCXnh</param>
        ''' <returns>true ŎO\</returns>
        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbCheckRemovableHandle")> _
        Public Shared Function CheckRemovable(ByVal Handle As IntPtr) As Boolean
        End Function

        ''' <summary>
        ''' foCXnhw肵 USB foCXO܂B
        ''' </summary>
        ''' <param name="Handle">foCXnh</param>
        ''' <returns>0 ̏ꍇ</returns>
        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbEjectDeviceHandle")> _
        Public Shared Function EjectDevice(ByVal Handle As IntPtr) As Integer
        End Function

        ''' <summary>
        ''' hCuw肵 USB foCXO܂B
        ''' </summary>
        ''' <param name="Drive">hCu</param>
        ''' <returns>0 ̏ꍇ</returns>
        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbEjectDeviceDriveName")> _
        Public Shared Function EjectDrive(ByVal Drive As String) As Integer
        End Function

        ''' <summary>
        ''' USB foCX̐ڑԂ𒲂ׂ܂B
        ''' </summary>
        ''' <param name="Handle">foCXnh</param>
        ''' <returns>true ŐڑAfalse ŐڑĂȂ</returns>
        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbCheckInsertDeviceHandle")> _
        Public Shared Function CheckInsert(ByVal Handle As IntPtr) As Boolean
        End Function

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbReleaseImageListHandle")> _
        Protected Shared Sub ReleaseImageListHandle()
        End Sub

        <DllImport("nUsbDevice.DLL", EntryPoint:="NUsbRefreshImageListHandle")> _
        Protected Shared Function RefreshImageListHandle() As IntPtr
        End Function

        <DllImport("user32.dll", EntryPoint:="DestroyIcon")> _
        Protected Shared Function DestroyIcon(ByVal Handle As IntPtr) As Integer
        End Function

        <DllImport("comctl32.dll", EntryPoint:="ImageList_GetImageCount")> _
        Protected Shared Function GetImageCount(ByVal Handle As IntPtr) As Integer
        End Function

        <DllImport("comctl32.dll", EntryPoint:="ImageList_GetIcon")> _
        Protected Shared Function GetIcon(ByVal Handle As IntPtr, ByVal No As Integer, ByVal Flag As Integer) As IntPtr
        End Function
    End Class
End Namespace
