// nUsbTestVCDlg.cpp : t@C
//

#include "stdafx.h"
#include "nUsbTestVC.h"
#include "nUsbTestVCDlg.h"
#include "nUsbDevice.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

enum {
	itemFriendlyName,
	itemDeviceId,
	itemDescription,
	itemManufacturer,
	itemDriveLetter,
	itemRemovable,
	itemInterface,
};

// CnUsbTestVCDlg _CAO
CnUsbTestVCDlg::CnUsbTestVCDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CnUsbTestVCDlg::IDD, pParent)
	, m_usb_count(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CnUsbTestVCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_USB, m_cusb);
	DDX_Control(pDX, IDC_LIST_USB, m_cusb);
	DDX_Control(pDX, IDC_CHECK_DRIVE, m_cdrive);
}

BEGIN_MESSAGE_MAP(CnUsbTestVCDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_DEVICECHANGE()
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_USB, &CnUsbTestVCDlg::OnNMDblclkListUsb)
	ON_BN_CLICKED(IDC_CHECK_DRIVE, &CnUsbTestVCDlg::OnBnClickedCheckDrive)
END_MESSAGE_MAP()


// CnUsbTestVCDlg bZ[W nh

BOOL CnUsbTestVCDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	CRect rc;
	m_cusb.GetClientRect(&rc);
	double w = (double)(rc.right - ::GetSystemMetrics(SM_CXVSCROLL) - ::GetSystemMetrics(SM_CXEDGE) * 2) / 10;
	m_cusb.InsertColumn(itemFriendlyName, _T(""), LVCFMT_LEFT, (int)(w * 2));
	m_cusb.InsertColumn(itemDeviceId, _T("foCX ID"), LVCFMT_LEFT, (int)(w * 2));
	m_cusb.InsertColumn(itemDescription, _T(""), LVCFMT_LEFT, (int)(w * 2));
	m_cusb.InsertColumn(itemManufacturer, _T(""), LVCFMT_LEFT, (int)(w));
	m_cusb.InsertColumn(itemDriveLetter, _T("hCu"), LVCFMT_LEFT, (int)(w));
	m_cusb.InsertColumn(itemRemovable, _T("O"), LVCFMT_LEFT, (int)(w));
	m_cusb.InsertColumn(itemInterface, _T("C^[tF[X"), LVCFMT_LEFT, (int)(w));

	m_cusb.SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);

	SetUsbList();

	return TRUE;
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CnUsbTestVCDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CnUsbTestVCDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

//
//	foCXԕύXbZ[W
//
BOOL CnUsbTestVCDlg::OnDeviceChange(UINT nEventType, DWORD_PTR dwData)
{
	SetUsbList();
	return TRUE;
}

void CnUsbTestVCDlg::OnNMDblclkListUsb(NMHDR *pNMHDR, LRESULT *pResult)
{
	int no = m_cusb.GetNextItem(-1, LVIS_SELECTED);
	if(no != -1) {
		DWORD di = (DWORD)m_cusb.GetItemData(no);
		// foCXO\H
		if(NUsbCheckRemovableHandle(di)) {
			// foCXO
			NUsbEjectDeviceHandle(di);
		} else {
			AfxMessageBox(_T("O͂ł܂"));
		}
	}
	*pResult = 0;
}

void CnUsbTestVCDlg::SetUsbList()
{
	m_cusb.DeleteAllItems();

	m_usb_count = NUsbGetDeviceData(m_cdrive.GetCheck() ? NUSB_GET_DRIVE_DEVICE : NUSB_GET_USB_DEVICE);
	m_image_list.Detach();
	m_image_list.Attach(NUsbGetImageListHandle());
	m_cusb.SetImageList(&m_image_list, LVSIL_SMALL);

	for(int no = 0 ; no < m_usb_count ; no++) {
		CString str, description;
		int index = NUsbGetImageListIndex(no);

		NUsbGetDescription(no, description.GetBuffer(MAX_PATH), MAX_PATH);
		description.ReleaseBuffer();
		NUsbGetFriendlyName(no, str.GetBuffer(MAX_PATH), MAX_PATH);
		str.ReleaseBuffer();
		if(str.IsEmpty()) {
			str = description;
		}
		m_cusb.InsertItem(no, str, index);

		NUsbGetDeviceId(no, str.GetBuffer(MAX_PATH), MAX_PATH);
		str.ReleaseBuffer();
		m_cusb.SetItemText(no, itemDeviceId, str);

		m_cusb.SetItemText(no, itemDescription, description);

		NUsbGetManufacturerName(no, str.GetBuffer(MAX_PATH), MAX_PATH);
		str.ReleaseBuffer();
		m_cusb.SetItemText(no, itemManufacturer, str);

		NUsbGetDriveLetter(no, str.GetBuffer(MAX_PATH), MAX_PATH);
		str.ReleaseBuffer();
		m_cusb.SetItemText(no, itemDriveLetter, str);

		if(NUsbCheckRemovableNo(no)) {
			m_cusb.SetItemText(no, itemRemovable, _T(""));
		}
		str.Empty();
		int type = NUsbGetInterface(no);
		if(type == NUSB_INTERFACE_USB) {
			str = _T("USB");
		} else if(type == NUSB_INTERFACE_ATA) {
			str = _T("ATA");
		} else if(type == NUSB_INTERFACE_SCSI) {
			str = _T("SCSI");
		} else if(type == NUSB_INTERFACE_IEEE1394) {
			str = _T("IEEE1394");
		}
		m_cusb.SetItemText(no, itemInterface, str);

		DWORD_PTR di = NUsbGetDeviceHandle(no);
		m_cusb.SetItemData(no, di);
	}
	NUsbReleaseDeviceData();
}

void CnUsbTestVCDlg::OnBnClickedCheckDrive()
{
	SetUsbList();
}
