﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace nUsbTestCs
{
    public partial class mainForm : Form
    {
        public mainForm()
        {
            InitializeComponent();
        }

        private nUsb.Device.Status [] StatusList;

        private void SetUsbList()
        {
            usbList.Items.Clear();
            using (nUsb.Device usb = new nUsb.Device())
            {
                if (checkDrive.Checked)
                {
                    usb.GetDrive();
                }
                else
                {
                    usb.GetData();
                }
                usbList.SmallImageList = usb.GetImageList();
                StatusList = usb.GetStatusList();
                foreach (nUsb.Device.Status status in StatusList)
                {
                    string name = status.FriendlyName;
                    if (name.Length == 0)
                    {
                        name = status.Description;
                    }
                    string removable = "";
                    if (status.Removable)
                    {
                        removable = "可";
                    }
                    string type = "";
                    if (status.InterfaceType == nUsb.Device.InterfaceUSB)
                    {
                        type = "USB";
                    }
                    else if (status.InterfaceType == nUsb.Device.InterfaceATA)
                    {
                        type = "ATA";
                    }
                    else if (status.InterfaceType == nUsb.Device.InterfaceSCSI)
                    {
                        type = "SCSI";
                    }
                    else if (status.InterfaceType == nUsb.Device.InterfaceIEEE1394)
                    {
                        type = "IEEE1394";
                    }
                    string[] item = { name, status.DeviceId, status.Description, status.Manufacturer, status.DriveLetter, removable, type };
                    ListViewItem new_item = usbList.Items.Add(new ListViewItem(item));
                    new_item.ImageIndex = status.ImageIndex;
                }
            }
            Debug.WriteLine(GC.GetTotalMemory(true));
        }

        private void mainForm_Load(object sender, EventArgs e)
        {
            usbList.ShowItemToolTips = true;
            SetUsbList();
        }
        protected override void WndProc(ref Message m)
        {
            const int WM_DEVICECHANGE = 0x0219;
            base.WndProc(ref m);
            if(m.Msg == WM_DEVICECHANGE)
            {
                SetUsbList();
            }
        }

        private void usbList_DoubleClick(object sender, EventArgs e)
        {
            if(usbList.SelectedItems.Count > 0) {
                int no = usbList.SelectedItems[0].Index;
                if(StatusList[no].Removable) {
                    nUsb.Device.EjectDevice(StatusList[no].DeviceHandle);
                }
            }
        }

        private void checkDrive_CheckedChanged(object sender, EventArgs e)
        {
            SetUsbList();
        }
   }
}