//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Main.h"
#include "nUsbDevice.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
    int w;

    w = (UsbList->ClientWidth - GetSystemMetrics(SM_CXVSCROLL)) / 10;
    UsbList->Columns->Items[0]->Width = w * 2;
    UsbList->Columns->Items[1]->Width = w * 2;
    UsbList->Columns->Items[2]->Width = w * 2;
    UsbList->Columns->Items[3]->Width = w;
    UsbList->Columns->Items[4]->Width = w;
    UsbList->Columns->Items[5]->Width = w;
    UsbList->Columns->Items[6]->Width = w;
    SetUsbList();
}
//---------------------------------------------------------------------------
void TMainForm::SetUsbList()
{
    int no, count;
    TListItem *li;
    char name[256];
    char description[256];

    UsbList->Items->Clear();
    count = NUsbGetDeviceData(DriveCheck->Checked ? NUSB_GET_DRIVE_DEVICE : NUSB_GET_USB_DEVICE);
    ImageList->Handle = (unsigned int)NUsbGetImageListHandle();
    for(no = 0 ; no < count ; no++) {
        NUsbGetFriendlyName(no, name, 256);
        NUsbGetDescription(no, description, 256);
        li = UsbList->Items->Add();
        if(name[0] == '\0') {
            li->Caption = description;
        } else {
            li->Caption = name;
        }
        NUsbGetDeviceId(no, name, 256);
        li->SubItems->Add(name);
        li->SubItems->Add(description);
        NUsbGetManufacturerName(no, name, 256);
        li->SubItems->Add(name);
        NUsbGetDriveLetter(no, name, 256);
        li->SubItems->Add(name);
        AnsiString str = "";
        if(NUsbCheckRemovableNo(no)) {
            str = "";
        }
        li->SubItems->Add(str.c_str());
        int type = NUsbGetInterface(no);
        str = "";
        if(type == NUSB_INTERFACE_USB) {
            str = "USB";
        } else if(type == NUSB_INTERFACE_ATA) {
            str = "ATA";
        } else if(type == NUSB_INTERFACE_SCSI) {
            str = "SCSI";
        } else if(type == NUSB_INTERFACE_IEEE1394) {
            str = "IEEE1394";
        }
        li->SubItems->Add(str.c_str());
        li->Data = reinterpret_cast<void *>(NUsbGetDeviceHandle(no));
        li->ImageIndex = NUsbGetImageListIndex(no);
    }
    NUsbReleaseDeviceData();
}



void __fastcall TMainForm::UsbListDblClick(TObject *Sender)
{
    if(UsbList->SelCount > 0) {
        NUsbEjectDeviceHandle(reinterpret_cast<DWORD_PTR>(UsbList->Selected->Data));
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::WMDeviceChange(TMessage& Message)
{
    SetUsbList();
}

void __fastcall TMainForm::DriveCheckClick(TObject *Sender)
{
    SetUsbList();
}
//---------------------------------------------------------------------------

