
Public Class mainForm

    Private StatusList() As nUsb.Device.Status

    Private Sub SetUsbList()
        Using usb As nUsb.Device = New nUsb.Device
            usbList.Items.Clear()
            If CheckDrive.Checked Then
                usb.GetDrive()
            Else
                usb.GetData()
            End If
            If usbList.SmallImageList Is Nothing Then
                usbList.SmallImageList = usb.GetImageList()
            End If
            StatusList = usb.GetStatusList()
            For Each status As nUsb.Device.Status In StatusList
                Dim name As String
                name = status.FriendlyName
                If name.Length = 0 Then
                    name = status.Description
                End If
                Dim removable As String = ""
                If status.Removable Then
                    removable = ""
                End If
                Dim type As String = ""
                If status.InterfaceType = nUsb.Device.InterfaceUSB Then
                    type = "USB"
                ElseIf status.InterfaceType = nUsb.Device.InterfaceATA Then
                    type = "ATA"
                ElseIf status.InterfaceType = nUsb.Device.InterfaceSCSI Then
                    type = "SCSI"
                ElseIf status.InterfaceType = nUsb.Device.InterfaceIEEE1394 Then
                    type = "IEEE1394"
                End If
                Dim item() As String = {name, status.DeviceId, status.Description, status.Manufacturer, status.DriveLetter, removable, type}
                Dim new_item As ListViewItem = usbList.Items.Add(New ListViewItem(item))
                new_item.ImageIndex = status.ImageIndex
            Next
        End Using
        Debug.WriteLine(GC.GetTotalMemory(True))
    End Sub

    Private Sub mainForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        usbList.ShowItemToolTips = True
        SetUsbList()
    End Sub

    Private Const WM_DEVICECHANGE As Integer = &H219
    Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)
        MyBase.WndProc(m)
        If m.Msg = WM_DEVICECHANGE Then
            SetUsbList()
        End If
    End Sub

    Private Sub usbList_DoubleClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles usbList.DoubleClick
        If usbList.SelectedItems.Count > 0 Then
            Dim no As Integer = usbList.SelectedItems(0).Index
            If StatusList(no).Removable Then
                nUsb.Device.EjectDevice(StatusList(no).DeviceHandle)
            End If
        End If
    End Sub

    Private Sub CheckDrive_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckDrive.CheckedChanged
        SetUsbList()
    End Sub

End Class
