using System;
using System.Text;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace nUsb
{
	/// <summary>
	/// USB foCX擾ENX
	/// </summary>
	public class Device : IDisposable
	{
		/// <summary>
		/// <c>Device</c>NX̐VKCX^X܂B
		/// </summary>
		public Device()
		{
		}
		/// <summary>
		/// foCXłB
		/// </summary>
		/// <remarks>
		/// <see cref="GetData"/>A<see cref="GetDrive"/>̌ʂi[\̂łB
		/// </remarks>
		public struct Status
		{
			/// <summary>
			/// foCX̂łBfoCXɂĂ͋̕ɂȂꍇ܂B
			/// </summary>
			public string FriendlyName;
			/// <summary>
			/// foCX ID łB
			/// </summary>
			public string DeviceId;
			/// <summary>
			/// n[hEFA ID łB
			/// </summary>
			public string HardwareId;
			/// <summary>
			/// ẽfoCX ID łB
			/// </summary>
			public string ParentDeviceId;
			/// <summary>
			/// ҖłB
			/// </summary>
			public string Manufacturer;
			/// <summary>
			/// foCX̐łB
			/// </summary>
			public string Description;
			/// <summary>
			/// NXłB
			/// </summary>
			public string ClassName;
			/// <summary>
			/// T[rXłB
			/// </summary>
			public string ServiceName;
			/// <summary>
			/// foCXɑΉhCu^[łB
			/// </summary>
			public string DriveLetter;
			/// <summary>
			/// C[WXg̃CfbNXԍłB
			/// </summary>
			public int ImageIndex;
			/// <summary>
			/// foCXnhłB
			/// <see cref="EjectDevice"/><see cref="CheckInsert"/>Ŏgp܂B
			/// </summary>
			public IntPtr DeviceHandle;
            /// <summary>
            /// ỎۂłB
            /// </summary>
            public bool Removable;
            /// <summary>
            /// ڑC^[tF[X̎ʂłB
            /// </summary>
			public int InterfaceType;
		}
        /// <summary>
        /// ɐ܂B
        /// </summary>
		public const int Success = 0;
        /// <summary>
        /// foCX݂܂B
        /// </summary>
		public const int ErrorNoData = -1;
        /// <summary>
        /// OɎs܂B
        /// </summary>
		public const int ErrorEject = -2;
        /// <summary>
        /// p[^słB
        /// </summary>
		public const int ErrorParameter = -3;
        /// <summary>
        /// C^[tF[X͕słB
        /// </summary>
		public const int InterfaceUnknown = 0;
        /// <summary>
        /// C^[tF[X USB łB
        /// </summary>
		public const int InterfaceUSB = 1;
        /// <summary>
        /// C^[tF[X ATA łB
        /// </summary>
		public const int InterfaceATA = 2;
        /// <summary>
        /// C^[tF[X SCSI łB
        /// </summary>
		public const int InterfaceSCSI = 3;
        /// <summary>
        /// C^[tF[X IEEE1394 łB
        /// </summary>
		public const int InterfaceIEEE1394 = 4;
        /// <summary>
        /// USB foCX̃f[^擾܂B
        /// </summary>
		public const int ModeUSB = 0;
        /// <summary>
        /// hCufoCX̃f[^擾܂B
        /// </summary>
		public const int ModeDrive = 1;

		protected const int BufferSize = 256;

		/// <summary>
		/// foCX̐łB
		/// </summary>
		protected int _usb_count;
		/// <summary>
		/// foCXɑΉACRi[ĂC[WXgłB
		/// </summary>
		protected ImageList _image_list = null;
		/// <summary>
		/// foCX̔złB
		/// </summary>
		protected Status[] _usb_list = null;
		/// <summary>
		/// Dispose sǂ̃tOłB
		/// </summary>
		private bool _disposed = false;

		/// <summary>
		/// 
		/// </summary>
		~Device()
		{
			Dispose(false);
		}
		/// <summary>
		/// <see cref="Device"/>ɂĎgpĂ邷ׂẴ\[X܂B
		/// </summary>
		public void Dispose()
		{
			Dispose(true);
			GC.SuppressFinalize(this);
		}
		/// <summary>
		/// <see cref="Device"/>ɂĎgpĂ邷ׂẴ\[X܂B
		/// </summary>
		/// <param name="disposing">
		/// }l[W\[XƃA}l[W\[X̗ꍇ<c>true</c>B
		/// A}l[W\[Xꍇ<c>false</c>B
		/// </param>
		protected virtual void Dispose(bool disposing)
		{
			if(!_disposed) {
				if(disposing)
				{
				}
				ReleaseImageListHandle();
				_disposed = true;
			}
		}

        /// <summary>
        /// foCXɑΉACRi[ĂC[WXg擾܂B
        /// </summary>
        /// <returns>C[WXg</returns>
		public ImageList GetImageList()
		{
			return _image_list;
		}

        /// <summary>
        /// foCX擾܂B
        /// </summary>
        /// <param name="mode">擾foCX</param>
        /// <returns>foCX</returns>
		public int GetDeviceDataList(int mode)
		{
			int no, count;
			_usb_count = GetDeviceData(mode);
			_usb_list = new Status[_usb_count];
			for(no = 0 ; no < _usb_count ; no++) {
				StringBuilder name = new StringBuilder(BufferSize);

				GetFriendlyName(no, name, BufferSize);
				_usb_list[no].FriendlyName = name.ToString();

				GetDeviceId(no, name, BufferSize);
				_usb_list[no].DeviceId = name.ToString();

				GetHardwareId(no, name, BufferSize);
				_usb_list[no].HardwareId = name.ToString();

				GetParentDeviceId(no, name, BufferSize);
				_usb_list[no].ParentDeviceId = name.ToString();

				GetManufacturerName(no, name, BufferSize);
				_usb_list[no].Manufacturer = name.ToString();

				GetDescription(no, name, BufferSize);
				_usb_list[no].Description = name.ToString();

				GetClassName(no, name, BufferSize);
				_usb_list[no].ClassName = name.ToString();

				GetServiceName(no, name, BufferSize);
				_usb_list[no].ServiceName = name.ToString();

				GetDriveLetter(no, name, BufferSize);
				_usb_list[no].DriveLetter = name.ToString();

				_usb_list[no].ImageIndex = GetImageListIndex(no);
				_usb_list[no].DeviceHandle = GetDeviceHandle(no);
				_usb_list[no].Removable = CheckRemovable(_usb_list[no].DeviceHandle);
				_usb_list[no].InterfaceType = GetInterface(no);
			}
			if(_image_list == null) {
				IntPtr Handle = GetImageListHandle();
				count = GetImageCount(Handle);
				_image_list = new ImageList();
				_image_list.ColorDepth = ColorDepth.Depth32Bit;
				for(no = 0 ; no < count ; no++) {
					IntPtr icon_handle = GetIcon(Handle, no, 0);
					System.Drawing.Icon icon = System.Drawing.Icon.FromHandle(icon_handle);
					_image_list.Images.Add(icon);
					DestroyIcon(icon_handle);
                    icon.Dispose();
					DestroyIcon(icon.Handle);
				}
			}
			ReleaseDeviceData();
			return _usb_count;
		}
        /// <summary>
        /// USB foCX擾܂B
        /// </summary>
        /// <returns>USB foCX</returns>
		public int GetData()
		{
			return GetDeviceDataList(ModeUSB);
		}
        /// <summary>
        /// hCufoCX擾܂B
        /// </summary>
        /// <returns>hCufoCX</returns>
		public int GetDrive()
		{
			return GetDeviceDataList(ModeDrive);
		}
        /// <summary>
        /// foCX\̂̔zԂ܂B
        /// </summary>
        /// <returns>USB foCX\̔z</returns>
		public Status[] GetStatusList()
		{
			return (Status[])_usb_list.Clone();
		}

        /// <summary>
        /// foCXACR̃C[WXgXV܂
        /// </summary>
		public void RefreshImageList()
        {
			RefreshImageListHandle();
			if(_image_list != null) {
				_image_list.Images.Clear();
				_image_list.Dispose();
				_image_list = null;
			}
		}


		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetDeviceData")]
		protected static extern int GetDeviceData(int reserved);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbReleaseDeviceData")]
		protected static extern int ReleaseDeviceData();

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetFriendlyName", CharSet=CharSet.Auto)]
		protected static extern int GetFriendlyName(int No, StringBuilder Name, int Size);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetDeviceId", CharSet=CharSet.Auto)]
		protected static extern int GetDeviceId(int No, StringBuilder Name, int Size);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetHardwareId", CharSet=CharSet.Auto)]
		protected static extern int GetHardwareId(int No, StringBuilder Name, int Size);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetParentDeviceId", CharSet=CharSet.Auto)]
		protected static extern int GetParentDeviceId(int No, StringBuilder Name, int Size);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetManufacturerName", CharSet=CharSet.Auto)]
		protected static extern int GetManufacturerName(int No, StringBuilder Name, int Size);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetDescription", CharSet=CharSet.Auto)]
		protected static extern int GetDescription(int No, StringBuilder Name, int Size);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetClassName", CharSet=CharSet.Auto)]
		protected static extern int GetClassName(int No, StringBuilder Name, int Size);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetServiceName", CharSet=CharSet.Auto)]
		protected static extern int GetServiceName(int No, StringBuilder Name, int Size);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetDriveLetter", CharSet=CharSet.Auto)]
		protected static extern int GetDriveLetter(int No, StringBuilder Name, int Size);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetImageListIndex")]
		protected static extern int GetImageListIndex(int No);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetImageListHandle")]
		protected static extern IntPtr GetImageListHandle();

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetDeviceHandle")]
		protected static extern IntPtr GetDeviceHandle(int No);

		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbGetInterface")]
		protected static extern int GetInterface(int No);

        /// <summary>
        /// USB foCXO邩ׂ܂B
        /// </summary>
        /// <param name="Handle">foCXnh</param>
        /// <returns>true ŎO\</returns>
		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbCheckRemovableHandle")]
		public static extern bool CheckRemovable(IntPtr Handle);
        /// <summary>
        /// USB foCXO܂B
        /// </summary>
        /// <param name="Handle">foCXnh</param>
        /// <returns>0 ̏ꍇ</returns>
		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbEjectDeviceHandle")]
		public static extern int EjectDevice(IntPtr Handle);
        /// <summary>
        /// USB foCX̐ڑԂ𒲂ׂ܂B
        /// </summary>
        /// <param name="Handle">foCXnh</param>
        /// <returns>true ŐڑAfalse ŐڑĂȂ</returns>
		[DllImport("nUsbDevice.DLL", EntryPoint="NUsbCheckInsertDeviceHandle")]
		public static extern bool CheckInsert(IntPtr Handle);

        [DllImport("nUsbDevice.DLL", EntryPoint="NUsbReleaseImageListHandle")]
        protected static extern void ReleaseImageListHandle();

        [DllImport("nUsbDevice.DLL", EntryPoint="NUsbRefreshImageListHandle")]
        protected static extern int RefreshImageListHandle();

        [DllImport("user32.dll", EntryPoint="DestroyIcon")]
        protected static extern int DestroyIcon(IntPtr Handle);

		[DllImport("comctl32.dll", EntryPoint="ImageList_GetImageCount")]
		protected static extern int GetImageCount(IntPtr Handle);

		[DllImport("comctl32.dll", EntryPoint="ImageList_GetIcon")]
		protected static extern IntPtr GetIcon(IntPtr Handle, int No, int Flag);
	}
}
