Imports System
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Collections
Imports System.Collections.Specialized
Imports System.Net.Sockets
Imports System.IO
Imports System.Runtime.Serialization

Namespace nMail

	''' <summary>
	''' nMail.DLL G[ԂĂꍇɔO
	''' </summary>
    Class nMailException
        Inherits ApplicationException

        Private _error_code As Integer

		''' <summary>
		''' G[bZ[WƃG[R[hw肵āA<c>nMailException</c>NX̐VCX^X܂B
		''' </summary>
		''' <param name="message"></param>
		''' <param name="error_code"></param>
        Public Sub New(ByVal message As String, ByVal error_code As Integer)
            MyBase.New(message)
            _error_code = error_code
        End Sub

		''' <summary>
		''' G[R[hłB
		''' </summary>
        Public ReadOnly Property ErrorCode() As Integer
            Get
                Return _error_code
            End Get
        End Property

		''' <summary>
		''' T[o[ԂꂽG[bZ[WłB
		''' </summary>
        Public Overrides ReadOnly Property Message() As String
            Get
                Return MyBase.Message
            End Get
        End Property

    End Class

	''' <summary>
	''' Winsock ֘ANX
	''' </summary>
    Class Winsock

		''' <summary>
		''' Winsock ܂B
		''' </summary>
        <DllImport("nMail.DLL", EntryPoint:="NMailInitializeWinSock")> _
        Public Shared Function Initialize() As Boolean
        End Function

		''' <summary>
		''' Winsock ̎gpI܂B
		''' </summary>
        <DllImport("nMail.DLL", EntryPoint:="NMailEndWinSock")> _
        Public Shared Function Done() As Boolean
        End Function

    End Class

	''' <summary>
	''' POP3[MNX
	''' </summary>
    Class Pop3
        Implements IDisposable

		''' <summary>
		''' wb_̈̃TCYłB
		''' </summary>
        Protected Const HeaderSize As Integer = 32768
		''' <summary>
		''' pX̃TCYłB
		''' </summary>
        Protected Const MaxPath As Integer = 32768
		''' <summary>
		''' g@\pobt@TCYłB
		''' </summary>
        Protected Const AttachmentTempSize As Integer = 2000

		''' <summary>
		''' \PbgG[͖ڑԂłB
		''' </summary>
		''' <remarks>
		''' <para><see cref="Connect"/>Ăяo<see cref="GetMail"/>A</para>
		''' <para>ĂяoAȂ炩̗RŐڑؒfƂ̃G[ƂȂ܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
        Public Const ErrorSocket As Integer = -1
		''' <summary>
		''' F؃G[łB
		''' </summary>
		''' <remarks>
		''' <para><see cref="Authenticate"/>ĂяoŔF؂Ɏsꍇ</para>
		''' <para>̃G[ƂȂ܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
        Public Const ErrorAuthenticate As Integer = -2
		''' <summary>
		''' ԍŎw肳ꂽ[݂܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetMail"/>Ŏw肵ԍ̃[݂ȂƂ̃G[ƂȂ܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
        Public Const ErrorInvalidNo As Integer = -3
		''' <summary>
		''' ^CAEgG[łB
		''' </summary>
		''' <remarks>
		''' <para><see cref="Options.Timeout"/>Ŏw肵l蒷ԃT[o牞</para>
		''' <para>ȂꍇÃG[܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
        Public Const ErrorTimeout As Integer = -4
		''' <summary>
		''' Ytt@CJ܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="Path"/>Ŏw肵tH_ɓYtt@C߂Ȃ</para>
		''' <para>ȂꍇÃG[܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
        Public Const ErrorFileOpen As Integer = -5
		''' <summary>
		''' t@CĂ܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="Flag"/><see cref="PartialAttachmentFile"/> ݒ肵</para>
		''' <para><see cref="GetMail"/>ĂяoۂɁAT[oɕꂽ[ׂ</para>
		''' <para>ĂȂꍇɂ̃G[܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
        Public Const ErrorPartial As Integer = -6
		''' <summary>
		''' Ytt@CƓ̃t@CtH_ɑ݂܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="nMail.Options.AlreadyFile"/>  <see cref="nMail.Options.FileAlreadyError"/></para>
		''' <para>ݒ肵A<see cref="Path"/>Ŏw肵tH_ɓYtt@CƓÕt@C</para>
		''' <para>ꍇɂ̃G[܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
        Public Const ErrorFileAlready As Integer = -7
		''' <summary>
		''' mۃG[łB
		''' </summary>
		''' <remarks>
		''' ŕR[hϊ邽߂̃mۂł܂łB
		''' </remarks>
        Public Const ErrorMemory As Integer = -9
		''' <summary>
		''' ̑̃G[łB
		''' </summary>
        Public Const ErrorEtc As Integer = -10
		''' <summary>
		''' Ytt@CMł܂c肪ԂłB
		''' </summary>
		''' <remarks>
		''' <para><see cref="Flag"/><see cref="SuspendAttachmentFile"/>܂</para>
		''' <para><see cref="SuspendNext"/>w肵<see cref="GetMail"/></para>
		''' <para>ĂяoꍇA܂[̎c肪ꍇA<see cref="nMailException.ErrorCode"/></para>
		''' <para>ɐݒ肳܂B</para>
		''' </remarks>
        Public Const ErrorSuspEndAttachmentFile As Integer = -20
		''' <summary>
		''' Ytt@C݂͑܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetAttachmentFileStatus"/> sAYtt@C݂Ȃꍇ</para>
		''' <para><see cref="PartNo"/> ɐݒ肳܂B</para>
		''' </remarks>
        Public Const NoAttachmentFile As Integer = -1
		''' <summary>
		''' Ytt@C݂͑܂AĂ܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetAttachmentFileStatus"/> sAYtt@C݂Ȃꍇ</para>
		''' <para><see cref="PartNo"/> ɐݒ肳܂B</para>
		''' </remarks>
        Public Const AttachmentFile As Integer = 0
		''' <summary>
		''' s
		''' </summary>
		''' <para>e탁\bhԂꍇA<see cref="nMailException.ErrorCode"/>ɐݒ肳lłB</para>
        Public Const Success As Integer = 1
		''' <summary>
		''' ꂽYtt@C擾܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		''' </remarks>
        Public Const PartialAttachmentFile As Integer = 1
		''' <summary>
		''' [{̂ݎ擾܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		''' </remarks>
        Public Const TextOnly As Integer = 2
		''' <summary>
		''' Ytt@CMňꎞx~̈ڂɎw肵܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		''' </remarks>
        Public Const SuspendAttachmentFile As Integer = 4
		''' <summary>
		''' Ytt@CMňꎞx~̓ڈȍ~Ɏw肵܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		''' </remarks>
        Public Const SuspendNext As Integer = 8
		''' <summary>
		''' UIDL ׂĎ擾܂B
		''' </summary>
		''' <remarks>
		''' <see cref="GetUidl"/>Ŏw肷邱ƂɂđSĂ UIDL 擾ł܂B
		''' </remarks>
        Public Const UidlAll As Integer = 0
		''' <summary>
		''' SSLv3 gp܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const SSL3 As Integer = &H1000
		''' <summary>
		''' TSLv1 gp܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const TLS1 As Integer = &H2000
		''' <summary>
		''' STARTTLS gp܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const STARTTLS As Integer = &H4000
		''' <summary>
		''' T[oؖ؂łG[ɂ܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const IgnoreNotTimeValid As Integer = &H0800
		''' <summary>
		''' [gؖłG[ɂ܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const AllowUnknownCA As Integer = &H0400
		''' <summary>
		''' Common Name vȂĂG[ɂ܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const IgnoreInvalidName As Integer = &H0040
		''' <summary>
		''' POP3 ̕W|[gԍł
		''' </summary>
		Public Const StandardPortNo As Integer = 110
		''' <summary>
		''' POP3 over SSL ̃|[gԍł
		''' </summary>
		Public Const StandardSslPortNo As Integer = 995

		''' <summary>
		''' POP3 |[gԍłB
		''' </summary>
        Protected _port As Integer = 110
		''' <summary>
		''' \PbgnhłB
		''' </summary>
        Protected _socket As IntPtr = IntPtr.op_Explicit(ErrorSocket)
		''' <summary>
		''' [łB
		''' </summary>
        Protected _count As Integer = -1
		''' <summary>
		''' [TCYłB
		''' </summary>
        Protected _size As Integer = -1
		''' <summary>
		''' wb_[TCYłB
		''' </summary>
        Protected _header_size As Integer = -1
		''' <summary>
		''' {̃TCYłB
		''' </summary>
        Protected _body_size As Integer = -1
		''' <summary>
		''' [M̐ݒptOłB
		''' </summary>
        Protected _flag As Integer = 0
		''' <summary>
		''' t@CԍłB
		''' </summary>
        Protected _part_no As Integer = -1
		''' <summary>
		''' G[ԍłB
		''' </summary>
        Protected _err As Integer
		''' <summary>
		''' APOP gp邩ǂ̃tOłB
		''' </summary>
        Protected _apop As Boolean = false
		''' <summary>
		''' POP3 T[ołB
		''' </summary>
        Protected _host As String = ""
		''' <summary>
		''' POP3 [U[łB
		''' </summary>
        Protected _id As String = ""
		''' <summary>
		''' POP3 pX[hłB
		''' </summary>
        Protected _password As String = ""
		''' <summary>
		''' Ytt@Cۑp̃pXłB
		''' </summary>
        Protected _path As String = nothing
		''' <summary>
		''' wb_tB[hłB
		''' </summary>
        Protected _field_name As String = ""
		''' <summary>
		''' {i[obt@łB
		''' </summary>
        Protected _body As StringBuilder
		''' <summary>
		''' i[obt@łB
		''' </summary>
        Protected _subject As StringBuilder
		''' <summary>
		''' tۑobt@łB
		''' </summary>
        Protected _date As StringBuilder
		''' <summary>
		''' oli[obt@łB
		''' </summary>
        Protected _from As StringBuilder
		''' <summary>
		''' wb_i[obt@łB
		''' </summary>
        Protected _header As StringBuilder
		''' <summary>
		''' Ytt@Ci[obt@łB
		''' </summary>
        Protected _filename As StringBuilder
		''' <summary>
		''' Ytt@C̃XgłB
		''' </summary>
        Protected _filename_list As String() = nothing
		''' <summary>
		''' wb_tB[hei[obt@łB
		''' </summary>
        Protected _field As StringBuilder
		''' <summary>
		''' t@C ID łB
		''' </summary>
        Protected _part_id As StringBuilder
		''' <summary>
		''' UIDL i[obt@łB
		''' </summary>
        Protected _uidl As StringBuilder
		''' <summary>
		''' Dispose sǂ̃tOłB
		''' </summary>
        Protected _disposed As Boolean = false
		''' <summary>
		''' HTML p[gۑt@C̖OłB
		''' </summary>
        Protected _html_file As StringBuilder
		''' <summary>
		''' SSL ݒtOłB
		''' </summary>
		Protected _ssl As Integer = 0
		''' <summary>
		''' SSL NCAgؖłB
		''' </summary>
		Protected _cert_name As String = nothing
		''' <summary>
		''' message/rfc822 p[gۑt@C̖OłB
		''' </summary>
        Protected _rfc822_file As StringBuilder

		''' <summary>
		''' <c>Pop3</c>NX̐VKCX^X܂B
		''' </summary>
        Public Sub New()
            Init()
        End Sub

		''' <summary>
		''' <c>Pop3</c>NX̐VKCX^X܂B
		''' <param name="host_name">POP3 T[o[</param>
		''' </summary>
        Public Sub New(ByVal host As String)
            Init()
            _host = host
        End Sub

        Protected Overrides Sub Finalize()
            MyBase.Finalize()
            Dispose(False)
        End Sub

		''' <summary>
		''' <see cref="Pop3"/>ɂĎgpĂ邷ׂẴ\[X܂B
		''' </summary>
        Overridable Overloads Sub Dispose() Implements IDisposable.Dispose
            Dispose(True)
            GC.SuppressFinalize(Me)
        End Sub

		''' <summary>
		''' <see cref="Pop3"/>ɂĎgpĂ邷ׂẴ\[X܂B
		''' </summary>
		''' <param name="disposing">
		''' }l[W\[XƃA}l[W\[X̗ꍇ<c>true</c>B
		''' A}l[W\[Xꍇ<c>false</c>B
		''' </param>
        Protected Overloads Sub Dispose(ByVal disposing As Boolean)
            If Not _disposed Then
                If disposing Then
                End If
                If Not _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                    Pop3Close(_socket)
                    _socket = IntPtr.op_Explicit(ErrorSocket)
                End If
                _disposed = True
            End If
        End Sub

		''' <summary>
		''' łB
		''' </summary>
        Protected Sub Init()
        End Sub

        <DllImport("nMail.DLL", EntryPoint:="NMailPop3ConnectPortNo", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3ConnectPortNo(ByVal Host As String, ByVal Port As Integer) As IntPtr
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailPop3ConnectSsl", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3ConnectSsl(ByVal Host As String, ByVal Port As Integer, ByVal Flag As Integer, ByVal Name As String) As IntPtr
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailPop3Close")> _
        Protected Shared Function Pop3Close(ByVal Socket As IntPtr) As Boolean
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailPop3Authenticate", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3Authenticate(ByVal Socket As IntPtr, ByVal Id As String, ByVal Pass As String, ByVal APopFlag As Boolean) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailPop3GetMailStatus", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3GetMailStatus(ByVal Socket As IntPtr, ByVal No As Integer, ByVal Subject As StringBuilder, ByVal DateStr As StringBuilder, ByVal From As StringBuilder, ByVal Header As StringBuilder, ByVal SizeFlag As Boolean) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailPop3GetMailSize")> _
        Protected Shared Function Pop3GetMailSize(ByVal Socket As IntPtr, ByVal No As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailPop3GetMail", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3GetMail(ByVal Socket As IntPtr, ByVal No As Integer, ByVal Subject As StringBuilder, ByVal DateStr As StringBuilder, ByVal From As StringBuilder, ByVal Header As StringBuilder, ByVal Body As StringBuilder, ByVal Path As String, ByVal FileName As StringBuilder) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailPop3GetMailEx", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3GetMailEx(ByVal Socket As IntPtr, ByVal No As Integer, ByVal Subject As StringBuilder, ByVal DateStr As StringBuilder, ByVal From As StringBuilder, ByVal Header As StringBuilder, ByVal Body As StringBuilder, ByVal Path As String, ByVal FileName As StringBuilder, ByVal Temp As IntPtr, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailPop3DeleteMail")> _
        Protected Shared Function Pop3DeleteMail(ByVal Socket As IntPtr, ByVal No As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailGetHeaderField", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3GetHeaderField(ByVal Field As StringBuilder, ByVal Header As String, ByVal Name As String, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailPop3GetUidl", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3GetUidl(ByVal Socket As IntPtr, ByVal No As Integer, ByVal Id As StringBuilder, ByVal Max As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailPop3GetAttachmentFileStatus", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3GetAttachmentFileStatus(ByVal Socket As IntPtr, ByVal No As Integer, ByVal Id As StringBuilder, ByVal Max As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailDecodeHeaderField", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3DecodeHeaderField(ByVal Dst As StringBuilder, ByVal Src As String, ByVal Size As Integer) As Integer
        End Function

        ''' <summary>
        ''' wb_i[pobt@̃TCY肵܂B
        ''' </summary>
        Protected Sub SetHeaderSize()
            If _header_size < 0 Then
                _header_size = Options.HeaderMax
            End If
            If _header_size <= 0 Then
                _header_size = HeaderSize
                Options.HeaderMax = _header_size
            End If
        End Sub

        ''' <summary>
        ''' POP3 T[oɐڑ܂B
        ''' </summary>
        ''' <remarks>
        ''' POP3 T[oɐڑ܂B
        ''' </remarks>
        Public Sub Connect()
            If (_port < 0) Or (_port > 65536) Then
                Throw New ArgumentOutOfRangeException
            End If
            _socket = Pop3ConnectSsl(_host, _port, _ssl, _cert_name)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                _err = ErrorSocket
                _socket = IntPtr.op_Explicit(ErrorSocket)
                Throw New nMailException("Connect", _err)
            End If
        End Sub

        ''' <summary>
        ''' POP3 T[oɐڑ܂B
        ''' </summary>
        ''' <param name="host_name">POP3 T[o[</param>
        ''' <remarks>
        ''' POP3 T[oɐڑ܂B
        ''' </remarks>
        Public Sub Connect(ByVal host_name As String)
            _host = host_name
            Connect()
        End Sub

        ''' <summary>
        ''' POP3 T[oɐڑ܂B
        ''' </summary>
        ''' <param name="host_name">POP3 T[o</param>
        ''' <param name="port_no">|[gԍ</param>
        ''' <remarks>
        ''' POP3 T[oɐڑ܂B
        ''' </remarks>
        Public Sub Connect(ByVal host_name As String, ByVal port_no As Integer)
            _host = host_name
            _port = port_no
            Connect()
        End Sub

        ''' <summary>
        ''' POP3 T[oɐڑ܂B
        ''' </summary>
        ''' <param name="port_no">|[gԍ</param>
        ''' <remarks>
        ''' POP3 T[oɐڑ܂B
        ''' </remarks>
        Public Sub Connect(ByVal port_no As Integer)
            _port = port_no
            Connect()
        End Sub

        ''' <summary>
        ''' POP3 T[oƂ̐ڑI܂B
        ''' </summary>
        Public Sub Close()
            If Not _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Pop3Close(_socket)
            End If
            _socket = IntPtr.op_Explicit(ErrorSocket)
        End Sub

        ''' <summary>
        ''' POP3 T[oF؂s܂B
        ''' </summary>
        ''' <remarks>
        ''' POP3 T[oF؂s܂B
        ''' </remarks>
        ''' <param name="id_str">POP3 [U[ ID</param>
        ''' <param name="pass_str">POP3 pX[h</param>
        Public Sub Authenticate(ByVal id_str As String, ByVal pass_str As String)
            If (id_str = "") Or (pass_str = "") Then
                Throw New FormatException
            End If
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _id = id_str
            _password = pass_str
            _body_size = -1
            _count = Pop3Authenticate(_socket, _id, _password, _apop)
            If _count < 0 Then
                _err = _count
                Throw New nMailException("Authenticate:" + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' POP3 T[oF؂s܂B
        ''' </summary>
        ''' <remarks>
        ''' POP3 T[oF؂s܂B
        ''' </remarks>
        ''' <param name="id_str">POP3 [U[ ID</param>
        ''' <param name="pass_str">POP3 pX[h</param>
        ''' <param name="apop_flag">APOP gp邩</param>
        Public Sub Authenticate(ByVal id_str As String, ByVal pass_str As String, ByVal apop_flag As Boolean)
            _apop = apop_flag
            Authenticate(id_str, pass_str)
        End Sub

        ''' <summary>
        ''' [̃Xe[^X擾܂B
        ''' </summary>
        ''' <param name="no">[ԍ</param>
        ''' <remarks>
        ''' <paramref name="no"/>p[^ŃXe[^X擾[ԍw肵܂B
        ''' <para><see cref="Subject"/>Ŏ擾ł܂B</para>
        ''' <para>t<see cref="DateString"/>Ŏ擾ł܂B</para>
        ''' <para>ol<see cref="From"/>Ŏ擾ł܂B</para>
        ''' <para>wb_<see cref="Header"/>Ŏ擾ł܂B</para>
        ''' <para>[TCY<see cref="Size"/>Ŏ擾ł܂B</para>
        ''' <para>Xe[^X擾s̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        Public Sub GetStatus(ByVal no As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            SetHeaderSize()
            _subject = New StringBuilder(_header_size)
            _date = New StringBuilder(_header_size)
            _from = New StringBuilder(_header_size)
            _header = New StringBuilder(_header_size)
            _err = Pop3GetMailStatus(_socket, no, _subject, _date, _from, _header, False)
            If _err < 0 Then
                Throw New nMailException("GetStatus:" + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [̃TCY擾܂B
        ''' </summary>
        ''' <param name="no">[ԍ</param>
        ''' <remarks>
        ''' <paramref name="no"/>p[^Ń[TCY擾[ԍw肵܂B
        ''' </remarks>
        ''' <returns>[TCY</returns>
        Public Function GetSize(ByVal no As Integer) As Integer
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _size = Pop3GetMailSize(_socket, no)
            If _size < 0 Then
                _err = _size
                Throw New nMailException("GetSize:" + Options.ErrorMessage, _err)
            Else
                _body_size = _size * 2
            End If
            Return Size
        End Function

        ''' <summary>
        ''' [擾܂B
        ''' </summary>
        ''' <param name="no">[ԍ</param>
        ''' <remarks>
        ''' <paramref name="no"/>p[^Ń[擾[ԍw肵܂B
        ''' <para>Ytt@CWJꍇA<see cref="Path"/>ɓWJtH_w肵Ă܂B</para>
        ''' <para>g@\gpꍇA<see cref="Flag"/>Őݒ肵Ă܂B</para>
        ''' <para><see cref="Subject"/>Ŏ擾ł܂B</para>
        ''' <para>t<see cref="DateString"/>Ŏ擾ł܂B</para>
        ''' <para>ol<see cref="From"/>Ŏ擾ł܂B</para>
        ''' <para>wb_<see cref="Header"/>Ŏ擾ł܂B</para>
        ''' <para>[TCY<see cref="Size"/>Ŏ擾ł܂B</para>
        ''' <para>Ytt@C<see cref="FileName"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        Public Sub GetMail(ByVal no As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            If (Not _path Is Nothing) Then
                If (_path <> "") And (Not Directory.Exists(_path)) Then
                    Throw New DirectoryNotFoundException(_path)
                End If
            End If
            If no <= 0 Then
                Throw New ArgumentOutOfRangeException
            End If
            If (_flag And SuspendNext) <> 0 Then
                _err = Pop3GetMailEx(_socket, no, _subject, _date, _from, _header, _body, _path, _filename, IntPtr.Zero, _flag)
            Else
                SetHeaderSize()
                _subject = New StringBuilder(_header_size)
                _date = New StringBuilder(_header_size)
                _from = New StringBuilder(_header_size)
                _header = New StringBuilder(_header_size)
                Options.FileNameMax = MaxPath
                _filename = New StringBuilder(MaxPath)
                If _body_size < 0 Then
                    GetSize(no)
                End If
                If _body_size > 0 Then
                    _body = New StringBuilder(_body_size)
                    If Flag <> 0 Then
                        _err = Pop3GetMailEx(_socket, no, _subject, _date, _from, _header, _body, _path, _filename, IntPtr.Zero, _flag)
                    Else
                        _err = Pop3GetMail(_socket, no, _subject, _date, _from, _header, _body, _path, _filename)
                    End If
                End If
            End If
            If _err <> ErrorSuspEndAttachmentFile Then
                If _filename.Length > 0 Then
                    _filename_list = _filename.ToString().Split(Options.SplitChar)
                Else
                    _filename_list = Nothing
                End If
                If Options.SaveHtmlFile = Options.SaveHtmlFileOn Then
                    GetHeaderField("X-NMAIL-HTML-FILE:")
                    _html_file = _field
                End If
                If Options.SaveRfc822File <> Options.SaveRfc822FileOff Then
                    GetHeaderField("X-NMAIL-RFC822-FILE:")
                    _rfc822_file = _field
                End If
            End If
            If (_err < 0) And (_err <> ErrorSuspEndAttachmentFile) Then
                Throw New nMailException("GetMail:" + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [폜܂B
        ''' </summary>
        ''' <param name="no">[ԍ</param>
        ''' <remarks>
        ''' <para>[폜s̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        Public Sub Delete(ByVal no As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            If no <= 0 Then
                Throw New ArgumentOutOfRangeException
            End If
            _err = Pop3DeleteMail(_socket, no)
            If _err < 0 Then
                Throw New nMailException("Delete:" + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' Ytt@C̑݃`FbNs܂B
        ''' </summary>
        ''' <param name="no">[ԍ</param>
        ''' <remarks>
        ''' <para>Ytt@C̕<see cref="PartNo"/>Ŏ擾ł܂B</para>
        ''' <para><see cref="NoAttachmentFile"/>̏ꍇYtt@C͂܂B</para>
        ''' <para><see cref="AttachmentFile"/>̏ꍇĂȂYtt@Ct[łB</para>
        ''' <para>1 ȏ̏ꍇĂYtt@CŕԂl̓p[gԍ\܂B</para>
        ''' <para>1 ̏ꍇ́A<see cref="Flag"/><see cref="PartialAttachmentFile"/> ݒ肵
        ''' <see cref="GetMail"/>ĂяoƓYtt@Cĕۑ\łB</para>
        ''' </remarks>
        Public Function GetAttachmentFileStatus(ByVal no As Integer) As Boolean
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            SetHeaderSize()
            _part_id = New StringBuilder(_header_size)
            _part_no = Pop3GetAttachmentFileStatus(_socket, no, _part_id, _header_size)
            If _part_no > 0 Then
                Return True
            Else
                Return False
            End If
        End Function

        ''' <summary>
        ''' [ UIDL 擾܂B
        ''' </summary>
        ''' <param name="no">[ԍ</param>
        ''' <remarks>
        ''' <para>擾 UIDL <see cref="Uidl"/>Ŏ擾ł܂B</para>
        ''' <para><paramref name="no"/><see cref="UidlAll"/>w肷ƁA
        ''' POP3 T[oɂ邷ׂẴ[ UIDL 擾܂B</para>
        ''' </remarks>
        Public Sub GetUidl(ByVal no As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            SetHeaderSize()
            _uidl = New StringBuilder(_header_size)
            _err = Pop3GetUidl(_socket, no, _uidl, _header_size)
            If _err < 0 Then
                Throw New nMailException("GetUild:" + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [wb_w̃tB[h̓e擾܂B
        ''' </summary>
        ''' <param name="field_name">tB[h</param>
        ''' <remarks>
        ''' POP3 T[oƂ̐ڑƂ͖֌WɎgpł܂B
        ''' <para>wb_́A<see cref="Header"/>Őݒ肵Ă܂B
        ''' <see cref="GetMail"/>ŎMɌĂяoꍇA
        ''' M[̃wb_gp܂B</para>
        ''' <para>擾tB[he<see cref="Field"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        ''' <returns>tB[h̓e</returns>
        Public Function GetHeaderField(ByVal field_name As String) As String
            _field_name = field_name
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            _err = Pop3GetHeaderField(_field, _header.ToString(), _field_name, _header_size)
            If _err < 0 Then
                Throw New nMailException("GetHeaderField", _err)
            End If
            Return _field.ToString()
        End Function

        ''' <summary>
        ''' [wb_w̃tB[h̓e擾܂B
        ''' </summary>
        ''' <remarks>
        ''' POP3 T[oƂ̐ڑƂ͖֌WɎgpł܂B
        ''' <para>擾tB[he<see cref="Field"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        ''' <param name="field_name">tB[h</param>
        ''' <param name="header">wb_</param>
        ''' <returns>tB[h̓e</returns>
        Public Function GetHeaderField(ByVal field_name As String, ByVal header As String) As String
            _field_name = field_name
            _header = New StringBuilder(header)
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            _err = Pop3GetHeaderField(_field, _header.ToString(), _field_name, _header_size)
            If _err < 0 Then
                Throw New nMailException("GetHeaderField", _err)
            End If
            Return _field.ToString()
        End Function

        ''' <summary>
        ''' MIME wb_tB[h̕fR[h܂
        ''' </summary>
        ''' <param name="field">tB[h̕</param>
        ''' <returns>fR[htB[he</returns>
        Public Function DecodeHeaderField(ByVal field As String) As String
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            _err = Pop3DecodeHeaderField(_field, field, _header_size)
            If _err < 0 Then
                Throw New nMailException("DecodeHeaderField", _err)
            End If
            Return _field.ToString()
        End Function

        ''' <summary>
        ''' [wb_w̃wb_tB[h̓e擾A
        ''' MIME wb_tB[h̃fR[hsĕԂ܂
        ''' </summary>
        ''' <param name="field_name">tB[h</param>
        ''' <returns>擾fR[hς݂̃tB[he</returns>
        Public Function GetDecodeHeaderField(ByVal field_name As String) As String
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            Dim src As String = GetHeaderField(field_name, _header.ToString())
            _err = Pop3DecodeHeaderField(_field, src, _header_size)
            If _err < 0 Then
                Throw New nMailException("DecodeHeaderField", _err)
            End If
            Return _field.ToString()
        End Function

        ''' <summary>
        ''' [wb_w̃wb_tB[h̓e擾A
        ''' MIME wb_tB[h̃fR[hsĕԂ܂
        ''' </summary>
        ''' <param name="field_name">tB[h</param>
        ''' <param name="header">wb_</param>
        ''' <returns>擾fR[hς݂̃tB[he</returns>
        Public Function GetDecodeHeaderField(ByVal field_name As String, ByVal header As String) As String
            SetHeaderSize()
            _err = Pop3DecodeHeaderField(_field, GetHeaderField(field_name, header), _header_size)
            If _err < 0 Then
                Throw New nMailException("DecodeHeaderField", _err)
            End If
            Return _field.ToString()
        End Function

        ''' <summary>
        ''' Ytt@C̔z擾܂B
        ''' </summary>
        ''' <returns>Ytt@C̔z</returns>
        Public Function GetFileNameList() As String()
            If _filename_list Is Nothing Then
                Return New String() {}
            Else
                Return CType(_filename_list.Clone(), String())
            End If
        End Function

        ''' <summary>
        ''' POP3 |[gԍłB
        ''' </summary>
        ''' <value>POP3 |[gԍ</value>
        Public Property Port() As Integer
            Get
                Return _port
            End Get
            Set(ByVal Value As Integer)
                _port = Value
            End Set
        End Property

        ''' <summary>
        ''' \PbgnhłB
        ''' </summary>
        ''' <value>\Pbgnh</value>
        Public ReadOnly Property Handle() As IntPtr
            Get
                Return _socket
            End Get
        End Property

        ''' <summary>
        ''' POP3 T[õ[łB
        ''' </summary>
        ''' <value>POP3 T[õ[</value>
        Public ReadOnly Property Count() As Integer
            Get
                Return _count
            End Get
        End Property

        ''' <summary>
        ''' [̃TCYTCYłB
        ''' </summary>
        ''' <value>[̃TCY</value>
        Public ReadOnly Property Size() As Integer
            Get
                Return _size
            End Get
        End Property

        ''' <summary>
        ''' POP3 T[ołB
        ''' </summary>
        ''' <value>POP3 T[o</value>
        Public Property HostName() As String
            Get
                Return _host
            End Get
            Set(ByVal Value As String)
                _host = Value
            End Set
        End Property

        ''' <summary>
        ''' POP3 [U[łB
        ''' </summary>
        ''' <value>POP3 [U[</value>
        Public Property Id() As String
            Get
                Return _id
            End Get
            Set(ByVal Value As String)
                _id = Value
            End Set
        End Property

        ''' <summary>
        ''' POP3 pX[hłB
        ''' </summary>
        ''' <value>POP3 pX[h</value>
        Public Property Password() As String
            Get
                Return _password
            End Get
            Set(ByVal Value As String)
                _password = Value
            End Set
        End Property

        ''' <summary>
        ''' Ytt@CۑtH_łB
        ''' </summary>
        ''' <remarks>
        ''' Nothing ̏ꍇۑ܂B
        ''' </remarks>
        ''' <value>Ytt@CۑtH_</value>
        Public Property Path() As String
            Get
                Return _path
            End Get
            Set(ByVal Value As String)
                _path = Value
            End Set
        End Property

        ''' <summary>
        ''' [̖{łB
        ''' </summary>
        ''' <value>[{</value>
        Public ReadOnly Property Body() As String
            Get
                Return _body.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [̌łB
        ''' </summary>
        ''' <value>[̌</value>
        Public ReadOnly Property Subject() As String
            Get
                Return _subject.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [̑M̕łB
        ''' </summary>
        ''' <value>[M</value>
        Public ReadOnly Property DateString() As String
            Get
                Return _date.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [̍olłB
        ''' </summary>
        ''' <value>[̍ol</value>
        Public ReadOnly Property From() As String
            Get
                Return _from.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [̃wb_łB
        ''' </summary>
        ''' <value>[̃wb_</value>
        Public Property Header() As String
            Get
                Return _header.ToString()
            End Get
            Set(ByVal Value As String)
                _header = New StringBuilder(Value)
            End Set
        End Property

        ''' <summary>
        ''' Ytt@CłB
        ''' </summary>
        ''' <remarks>
        ''' ̓Ytt@CꍇA"," ŋ؂Ċi[܂B
        ''' <see cref="Options.SplitChar"/>ŋ؂蕶ύXł܂B
        ''' </remarks>
        ''' <value>Ytt@C</value>
        Public ReadOnly Property FileName() As String
            Get
                Return _filename.ToString()
            End Get
        End Property

        ''' <summary>
        ''' Ytt@C̔złB
        ''' </summary>
        ''' <value>Ytt@C</value>
        Public ReadOnly Property FileNameList() As String()
            Get
                Return _filename_list
            End Get
        End Property

        ''' <summary>
        ''' wb_̃tB[hłB
        ''' </summary>
        ''' <value>wb_̃tB[h</value>
        Public ReadOnly Property FieldName() As String
            Get
                Return _field_name
            End Get
        End Property

        ''' <summary>
        ''' wb_tB[h̓ełB
        ''' </summary>
        ''' <value>wb_tB[h̓e</value>
        Public ReadOnly Property Field() As String
            Get
                Return _field.ToString()
            End Get
        End Property

        ''' <summary>
        ''' Ytt@C̕łB
        ''' </summary>
        ''' <value>Ytt@C̕</value>
        Public ReadOnly Property PartNo() As Integer
            Get
                Return _part_no
            End Get
        End Property

        ''' <summary>
        ''' Ytt@C ID łB
        ''' </summary>
        ''' <value>Ytt@C ID </value>
        Public ReadOnly Property PartId() As String
            Get
                Return _part_id.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [ UIDL łB
        ''' </summary>
        ''' <value>[ UIDL</value>
        Public ReadOnly Property Uidl() As String
            Get
                Return _uidl.ToString()
            End Get
        End Property

        ''' <summary>
        ''' APOP gp邩ǂ̃tOłB
        ''' </summary>
        ''' <remarks>
        ''' true  APOP gp܂B
        ''' </remarks>
        ''' <value>APOP gp邩ǂ̃tO</value>
        Public Property APop() As Boolean
            Get
                Return _apop
            End Get
            Set(ByVal Value As Boolean)
                _apop = Value
            End Set
        End Property

        ''' <summary>
        ''' [g@\wtOłB
        ''' </summary>
        ''' <remarks>
        ''' <para><see cref="PartialAttachmentFile"/>ꂽYtt@C擾܂B</para>
        ''' <para><see cref="TextOnly"/>[{̂ݎ擾܂B</para>
        ''' <para><see cref="SuspendAttachmentFile"/>Ytt@CMňꎞx~̈ڂɎw肵܂B</para>
        ''' <para><see cref="SuspendNext"/>Ytt@CMňꎞx~̓ڈȍ~Ɏw肵܂B</para>
        ''' </remarks>
        Public Property Flag() As Integer
            Get
                Return _flag
            End Get
            Set(ByVal Value As Integer)
                _flag = Value
            End Set
        End Property

        ''' <summary>
        ''' G[ԍłB
        ''' </summary>
        ''' <value>G[ԍ</value>
        Public ReadOnly Property ErrorCode() As Integer
            Get
                Return _err
            End Get
        End Property
        ''' <summary>
        ''' HTML p[gۑt@C̖OłB
        ''' </summary>
        ''' <value>t@C</value>
        Public ReadOnly Property HtmlFile() As String
            Get
                If _html_file Is Nothing Then
                    Return ""
                Else
                    Return _html_file.ToString()
                End If
            End Get
        End Property
        ''' <summary>
        ''' SSL ݒtOłB
        ''' </summary>
        ''' <value>SSL ݒtO</value>
        Public Property SSL() As Integer
            Get
                Return _ssl
            End Get
            Set(ByVal Value As Integer)
                _ssl = Value
            End Set
        End Property
        ''' <summary>
        ''' SSL NCAgؖłB
        ''' </summary>
        ''' <remarks>
        ''' nothing ̏ꍇw肵܂B
        ''' </remarks>
        ''' <value>SSL NCAgؖ</value>
        Public Property CertName() As String
            Get
                Return _cert_name
            End Get
            Set(ByVal Value As String)
                _cert_name = Value
            End Set
        End Property
        ''' <summary>
        ''' message/rfc822 p[gۑt@C̖OłB
        ''' </summary>
        ''' <value>t@C</value>
        Public ReadOnly Property Rfc822File() As String
            Get
                If _rfc822_file Is Nothing Then
                    Return ""
                Else
                    Return _rfc822_file.ToString()
                End If
            End Get
        End Property
    End Class

    ''' <summary>
    ''' SMTP [MNX
    ''' </summary>
    Class Smtp
        Implements IDisposable

        ''' <summary>
        ''' g@\pobt@̃TCYłB
        ''' </summary>
        Protected Const AttachmentTempSize As Integer = 2000

        ''' <summary>
        ''' \PbgG[͔ڑԂłB
        ''' </summary>
        Public Const ErrorSocket As Integer = -1
        ''' <summary>
        ''' F؎sG[łB
        ''' </summary>
        Public Const ErrorAuthenticate As Integer = -2
        ''' <summary>
        ''' ^CAEgG[łB
        ''' </summary>
        Public Const ErrorTimeout As Integer = -4
        ''' <summary>
        ''' Ytt@CI[vsG[łB
        ''' </summary>
        Public Const ErrorFileOpen As Integer = -5
        ''' <summary>
        ''' T[ow肵F،`ɑΉĂ܂B
        ''' </summary>
        Public Const ErrorAuthenticateNoSupport As Integer = -8
        ''' <summary>
        ''' mۃG[łB
        ''' </summary>
        Public Const ErrorMemory As Integer = -9
        ''' <summary>
        ''' ̑̃G[łB
        ''' </summary>
        Public Const ErrorEtc As Integer = -10
        ''' <summary>
        ''' [M̈ꎞx~ԂłB
        ''' </summary>
        Public Const ErrorSuspendAttachmentFile As Integer = -20
        ''' <summary>
        ''' T[rXpł܂B
        ''' </summary>
        Public Const ErrorServiceNotAvaliable As Integer = -421
        ''' <summary>
        ''' [{bNXgpł܂Bigpj
        ''' </summary>
        Public Const ErrorMailboxUnavalable As Integer = -450
        ''' <summary>
        ''' T[oG[łB
        ''' </summary>
        Public Const ErrorLocal As Integer = -451
        ''' <summary>
        ''' VXeeʕsG[łB
        ''' </summary>
        Public Const ErrorInsufficientSystemStorage As Integer = -452
        ''' <summary>
        ''' R}h̕@G[łB
        ''' </summary>
        Public Const ErrorSyntax As Integer = -500
        ''' <summary>
        ''' p[^̕@G[łB
        ''' </summary>
        Public Const ErrorParameter As Integer = -501
        ''' <summary>
        ''' R}hłB
        ''' </summary>
        Public Const ErrorCommandNotImplemented As Integer = -502
        ''' <summary>
        ''' R}h̃V[PXُłB
        ''' </summary>
        Public Const ErrorBadSequence As Integer = -503
        ''' <summary>
        ''' SMTP F؎słB
        ''' </summary>
        Public Const ErrorSmtpAuthenticate As Integer = -535
        ''' <summary>
        ''' M悪܂B
        ''' </summary>
        Public Const ErrorUserUnkown As Integer = -550
        ''' <summary>
        ''' [U[݂ȂA]悪܂B
        ''' </summary>
        Public Const ErrorUserNotLocal As Integer = -551
        ''' <summary>
        ''' eʃI[o[G[łB
        ''' </summary>
        Public Const ErrorExceededStorageAllocation As Integer = -552
        ''' <summary>
        ''' [{bNX܂B
        ''' </summary>
        Public Const ErrorMailboxNameNotAllowed As Integer = -553
        ''' <summary>
        ''' [h~G[łB
        ''' </summary>
        Public Const ErrorRelayOperationRejected As Integer = -553
        ''' <summary>
        ''' gUNVɎs܂B
        ''' </summary>
        Public Const ErrorTransactionFailed As Integer = -554
        ''' <summary>
        ''' MtB[h nMail.DLL Ő܂B
        ''' </summary>
        Public Const AddDateField As Integer = 1
        ''' <summary>
        ''' Message-ID tB[h nMail.DLL Ő܂B
        ''' </summary>
        Public Const AddMessageId As Integer = 2
        ''' <summary>
        ''' 傫ȃTCY̓Ytt@CMɈU߂܂B
        ''' </summary>
        Public Const SuspendAttachmentFile As Integer = 4
        ''' <summary>
        ''' 傫ȃTCY̓Ytt@CMڈȍ~łB
        ''' </summary>
        Public Const SuspendNext As Integer = 8
        ''' <summary>
        ''' RFC2231 œYtt@CGR[h܂B
        ''' </summary>
        Public Const FileNameRfc2231 As Integer = 16
        ''' <summary>
        ''' UTF-8 Ń[GR[h܂iBASE64ŃGR[h܂j
        ''' </summary>
        Public Const EncodeUtf8 As Integer = 32
        ''' <summary>
        ''' HTML [𑗐M܂B
        ''' </summary>
        Public Const HtmlMail As Integer = 64
        ''' <summary>
        ''' text/html p[gt@CŎw肵܂B
        ''' </summary>
        Public Const HtmlUseFile As Integer = 128
        ''' <summary>
        ''' HTML [̈̃hC݂ multipart ̍\肵܂B
        ''' </summary>
        Public Const HtmlAutoPart As Integer = 256
        ''' <summary>
        ''' text/html p[gŎgp摜t@CYtꍇAmultipart/mixed ȂőM܂B
        ''' </summary>
        Public Const HtmlNoMixedPart As Integer = 512
        ''' <summary>
        ''' Softbank gьIvViHtmlNoMixedPartƓj
        ''' </summary>
        Public Const HtmlSoftbank As Integer = 512
        ''' <summary>
        ''' EMOBILE gьIvViHtmlNoMixedPartƓj
        ''' </summary>
        Public Const HtmlEmobile As Integer = 512
        ''' <summary>
        ''' WILLCOM gьIvViHtmlNoMixedPartƓj
        ''' </summary>
        Public Const HtmlWillcom As Integer = 512
        ''' <summary>
        ''' text/html p[gŎgp摜t@CYtꍇAmultipart/related ȂőM܂B
        ''' </summary>
        Public Const HtmlNoRelatedPart As Integer = 1024
        ''' <summary>
        ''' au gьIvViHtmlNoRelatedPartƓj
        ''' </summary>
        Public Const HtmlAu As Integer = 1024
        ''' <summary>
        ''' text/html p[ĝ݁itext/plain p[gȂj HTML [𑗐M܂B
        ''' </summary>
        Public Const HtmlNoPlainPart As Integer = 2048
        ''' <summary>
        ''' text/plain p[gŎgp镶 Body Ŏw肵܂B
        ''' </summary>
        Public Const HtmlSetPlainBody As Integer = 4096
        ''' <summary>
        ''' łB
        ''' </summary>
        Public Const Success As Integer = 1
        ''' <summary>
        ''' SMTP AUTH ͎gp܂B
        ''' </summary>
        Public Const AuthNotUse As Integer = 0
        ''' <summary>
        ''' SMTP AUTH PLAIN gp܂B
        ''' </summary>
        Public Const AuthPlain As Integer = 1
        ''' <summary>
        ''' SMTP AUTH LOGIN gp܂B
        ''' </summary>
        Public Const AuthLogin As Integer = 2
        ''' <summary>
        ''' SMTP AUTH CRAM MD5 gp܂B
        ''' </summary>
        Public Const AuthCramMd5 As Integer = 4
        ''' <summary>
        ''' SMTP AUTH DIGEST MD5 gp܂B
        ''' </summary>
        Public Const AuthDigestMd5 As Integer = 8
        ''' <summary>
        ''' SSLv3 gp܂B
        ''' </summary>
        ''' <remarks>
        ''' <see cref="SSL"/>Ŏw肵܂B
        ''' </remarks>
        Public Const SSL3 As Integer = &H1000
        ''' <summary>
        ''' TSLv1 gp܂B
        ''' </summary>
        ''' <remarks>
        ''' <see cref="SSL"/>Ŏw肵܂B
        ''' </remarks>
        Public Const TLS1 As Integer = &H2000
        ''' <summary>
        ''' STARTTLS gp܂B
        ''' </summary>
        ''' <remarks>
        ''' <see cref="SSL"/>Ŏw肵܂B
        ''' </remarks>
        Public Const STARTTLS As Integer = &H4000
        ''' <summary>
        ''' T[oؖ؂łG[ɂ܂B
        ''' </summary>
        ''' <remarks>
        ''' <see cref="SSL"/>Ŏw肵܂B
        ''' </remarks>
        Public Const IgnoreNotTimeValid As Integer = &H800
        ''' <summary>
        ''' [gؖłG[ɂ܂B
        ''' </summary>
        ''' <remarks>
        ''' <see cref="SSL"/>Ŏw肵܂B
        ''' </remarks>
        Public Const AllowUnknownCA As Integer = &H400
        ''' <summary>
        ''' Common Name vȂĂG[ɂ܂B
        ''' </summary>
        ''' <remarks>
        ''' <see cref="SSL"/>Ŏw肵܂B
        ''' </remarks>
        Public Const IgnoreInvalidName As Integer = &H40
        ''' <summary>
        ''' SMTP ̕W|[gԍł
        ''' </summary>
        Public Const StandardPortNo As Integer = 25
        ''' <summary>
        ''' SMTP over SSL ̃|[gԍł
        ''' </summary>
        Public Const StandardSslPortNo As Integer = 465
        ''' <summary>
        ''' SMTP Tu~bV|[gԍł
        ''' </summary>
        Public Const StandardSubmissionPortNo As Integer = 587

        ''' <summary>
        ''' SMTP |[gԍłB
        ''' </summary>
        Protected _port As Integer = 25
        ''' <summary>
        ''' \PbgnhłB
        ''' </summary>
        Protected _socket As IntPtr = IntPtr.op_Explicit(ErrorSocket)
        ''' <summary>
        ''' [Mg@\̎włB
        ''' </summary>
        Protected _flag As Integer = 0
        ''' <summary>
        ''' G[ԍłB
        ''' </summary>
        Protected _err As Integer
        ''' <summary>
        ''' SMTP AUTH ̃[hłB
        ''' </summary>
        Protected _mode As Integer = AuthNotUse
        ''' <summary>
        ''' SMTP T[ołB
        ''' </summary>
        Protected _host As String = ""
        ''' <summary>
        ''' SMTP AUTH [U[łB
        ''' </summary>
        Protected _id As String = ""
        ''' <summary>
        ''' SMTP AUTH pX[hłB
        ''' </summary>
        Protected _password As String = ""
        ''' <summary>
        ''' [̈łB
        ''' </summary>
        Protected _to As String = ""
        ''' <summary>
        ''' [ CC łB
        ''' </summary>
        Protected _cc As String = ""
        ''' <summary>
        ''' [ BCC łB
        ''' </summary>
        Protected _bcc As String = ""
        ''' <summary>
        ''' [̍olłB
        ''' </summary>
        Protected _from As String = ""
        ''' <summary>
        ''' [̌łB
        ''' </summary>
        Protected _subject As String = ""
        ''' <summary>
        ''' [̖{łB
        ''' </summary>
        Protected _body As String = ""
        ''' <summary>
        ''' [̒ǉwb_łB
        ''' </summary>
        Protected _header As String = ""
        ''' <summary>
        ''' [ɓYtt@CłB
        ''' </summary>
        Protected _filename As String = ""
        ''' <summary>
        ''' Ytt@C̃XgłB
        ''' </summary>
        Protected _filename_list As String() = Nothing
        ''' <summary>
        ''' Connect() gǂ̃tOłB
        ''' </summary>
        Protected _connect_flag As Boolean = False
        ''' <summary>
        ''' Dispose sǂ̃tOłB
        ''' </summary>
        Protected _disposed As Boolean = False
        ''' <summary>
        ''' SSL ݒtOłB
        ''' </summary>
        Protected _ssl As Integer = 0
        ''' <summary>
        ''' SSL NCAgؖłB
        ''' </summary>
        Protected _cert_name As String = Nothing

        <DllImport("nMail.DLL", EntryPoint:="NMailSmtpSendMailPortNo", CharSet:=CharSet.Auto)> _
        Protected Shared Function SmtpSendMailPortNo(ByVal HostName As String, ByVal ToStr As String, ByVal Cc As String, ByVal Bcc As String, ByVal From As String, ByVal Subject As String, ByVal Body As String, ByVal Header As String, ByVal Path As String, ByVal Flag As Integer, ByVal PortNo As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailSmtpSendMailSsl", CharSet:=CharSet.Auto)> _
        Protected Shared Function SmtpSendMailSsl(ByVal HostName As String, ByVal ToStr As String, ByVal Cc As String, ByVal Bcc As String, ByVal From As String, ByVal Subject As String, ByVal Body As String, ByVal Header As String, ByVal Path As String, ByVal Flag As Integer, ByVal PortNo As Integer, ByVal SslFlag As Integer, ByVal Name As String) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailSmtpConnect", CharSet:=CharSet.Auto)> _
        Protected Shared Function SmtpConnect(ByVal Host As String) As IntPtr
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailSmtpConnectSsl", CharSet:=CharSet.Auto)> _
        Protected Shared Function SmtpConnectSsl(ByVal Host As String, ByVal Port As Integer, ByVal Flag As Integer, ByVal Name As String) As IntPtr
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailSmtpConnectPortNo", CharSet:=CharSet.Auto)> _
        Protected Shared Function SmtpConnectPortNo(ByVal Host As String, ByVal PortNo As Integer) As IntPtr
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailSmtpAuthenticate", CharSet:=CharSet.Auto)> _
        Protected Shared Function SmtpAuthenticate(ByVal Socket As IntPtr, ByVal HostName As String, ByVal Id As String, ByVal Pass As String, ByVal Mode As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailSmtpSendMailEx", CharSet:=CharSet.Auto)> _
        Protected Shared Function SmtpSendMailEx(ByVal Socket As IntPtr, ByVal ToStr As String, ByVal Cc As String, ByVal Bcc As String, ByVal From As String, ByVal Subject As String, ByVal Body As String, ByVal Header As String, ByVal Path As String, ByVal Temp As IntPtr, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailSmtpClose")> _
        Protected Shared Function SmtpClose(ByVal Socket As IntPtr) As Boolean
        End Function

        ''' <summary>
        ''' łB
        ''' </summary>
        Protected Sub Init()
            _filename_list = Nothing
        End Sub

        ''' <summary>
        ''' <c>Smtp</c>NX̐VKCX^X܂B
        ''' </summary>
        Public Sub New()
            Init()
        End Sub

        ''' <summary>
        ''' <c>Smtp</c>NX̐VKCX^X܂B
        ''' </summary>
        ''' <param name="host_name">SMTP T[o</param>
        Public Sub New(ByVal host_name As String)
            Init()
            _host = host_name
        End Sub

        ''' <summary>
        ''' 
        ''' </summary>
        Protected Overrides Sub Finalize()
            MyBase.Finalize()
            Dispose(False)
        End Sub

        ''' <summary>
        ''' <see cref="Smtp"/>ɂĎgpĂ邷ׂẴ\[X܂B
        ''' </summary>
        Overridable Overloads Sub Dispose() Implements IDisposable.Dispose
            Dispose(True)
            GC.SuppressFinalize(Me)
        End Sub

        ''' <summary>
        ''' <see cref="Smtp"/>ɂĎgpĂ邷ׂẴ\[X܂B
        ''' </summary>
        ''' <param name="disposing">
        ''' }l[W\[XƃA}l[W\[X̗ꍇ<c>true</c>B
        ''' A}l[W\[Xꍇ<c>false</c>B
        ''' </param>
        Protected Overloads Sub Dispose(ByVal disposing As Boolean)
            If Not _disposed Then
                If disposing Then
                End If
                If _connect_flag And (Not _socket.Equals(IntPtr.op_Explicit(ErrorSocket))) Then
                    SmtpClose(_socket)
                End If
                _socket = IntPtr.op_Explicit(ErrorSocket)
                _connect_flag = False
                _disposed = True
            End If
        End Sub

        ''' <summary>
        ''' [𑗐M܂B
        ''' </summary>
        ''' <remarks>
        '''	ꎞx~@\̓ڈȍ~̌ĂяoŎgp܂B
        ''' </remarks>
        Public Sub SendMail()
            Dim no As Integer

            _filename = ""
            If Not _filename_list Is Nothing Then
                If _filename_list.Length > 0 Then
                    For no = 0 To _filename_list.Length - 1
                        If Not File.Exists(_filename_list(no)) Then
                            Throw New FileNotFoundException(_filename_list(no))
                        End If
                    Next no
                    _filename = String.Join(Options.SplitChar, _filename_list)
                End If
            End If
            If _connect_flag Then
                _err = SmtpSendMailEx(_socket, _to, _cc, _bcc, _from, _subject, _body, _header, _filename, IntPtr.Zero, _flag)
            Else
                _err = SmtpSendMailSsl(_host, _to, _cc, _bcc, _from, _subject, _body, _header, _filename, _flag, _port, _ssl, _cert_name)
            End If
            If (_err < 0) And (_err <> ErrorSuspendAttachmentFile) Then
                Throw New nMailException("SendMail:" + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [𑗐M܂B
        ''' </summary>
        ''' <param name="to_str"></param>
        ''' <param name="from_str">ol</param>
        ''' <param name="subject_str"></param>
        ''' <param name="body_str">{</param>
        ''' <remarks>
        ''' <paramref name="to_str"/>p[^Ń[̈w肵܂B
        ''' <paramref name="from_str"/>p[^ōolw肵܂B
        ''' <paramref name="subject_str"/>p[^Ōw肵܂B
        ''' <paramref name="body_str"/>p[^Ŗ{w肵܂B
        ''' <para>CC w肵ꍇA<see cref="Cc"/>Ɏw肵Ă܂B</para>
        ''' <para>BCC w肵ꍇA<see cref="Bcc"/>Ɏw肵Ă܂B</para>
        ''' <para>t@CYtꍇA<see cref="FileName"/>Ɏw肵Ă܂B</para>
        ''' </remarks>
        Public Sub SendMail(ByVal to_str As String, ByVal from_str As String, ByVal subject_str As String, ByVal body_str As String)
            _to = to_str
            _from = from_str
            _subject = subject_str
            _body = body_str
            SendMail()
        End Sub

        ''' <summary>
        ''' SMTP T[oɐڑ܂B
        ''' </summary>
        ''' <remarks>
        '''	SMTP AUTH шꎞx~@\gꍇɎgp܂B
        ''' </remarks>
        Public Sub Connect()
            If _host = "" Then
                Throw New FormatException
            End If
            If (_port < 0) Or (_port > 65536) Then
                Throw New ArgumentOutOfRangeException
            End If
            _socket = SmtpConnectSsl(_host, _port, _ssl, _cert_name)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                _err = ErrorSocket
                _socket = IntPtr.op_Explicit(ErrorSocket)
                Throw New nMailException("Connect", _err)
            Else
                _connect_flag = True
            End If
        End Sub

        ''' <summary>
        ''' SMTP T[oɐڑ
        ''' </summary>
        ''' <param name="host_name">SMTP T[o</param>
        ''' <remarks>
        '''	SMTP AUTH шꎞx~@\gꍇɎgp܂B
        ''' </remarks>
        Public Sub Connect(ByVal host_name As String)
            _host = host_name
            Connect()
        End Sub

        ''' <summary>
        ''' SMTP T[oɐڑ
        ''' </summary>
        ''' <param name="host_name">SMTP T[o</param>
        ''' <param name="port_no">|[gԍ</param>
        ''' <remarks>
        '''	SMTP AUTH шꎞx~@\gꍇɎgp܂B
        ''' </remarks>
        Public Sub Connect(ByVal host_name As String, ByVal port_no As Integer)
            _host = host_name
            _port = port_no
            Connect()
        End Sub

        ''' <summary>
        ''' SMTP T[oɐڑ
        ''' </summary>
        ''' <param name="port_no">|[gԍ</param>
        ''' <remarks>
        '''	SMTP AUTH шꎞx~@\gꍇɎgp܂B
        ''' </remarks>
        Public Sub Connect(ByVal port_no As Integer)
            _port = port_no
            Connect()
        End Sub

        ''' <summary>
        ''' SMTP T[oƂ̐ڑI
        ''' </summary>
        Public Sub Close()
            If Not _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                SmtpClose(_socket)
            End If
            _socket = IntPtr.op_Explicit(ErrorSocket)
            _connect_flag = False
        End Sub

        ''' <summary>
        ''' SMTP AUTH F
        ''' </summary>
        Public Sub Authenticate()
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = SmtpAuthenticate(_socket, _host, _id, _password, _mode)
            If _err < 0 Then
                Throw New nMailException("Authenticate:" + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' SMTP AUTH F
        ''' </summary>
        ''' <param name="id_str">[U[ ID</param>
        ''' <param name="pass_str">pX[h</param>
        ''' <param name="mode">AUTH </param>
        ''' <remarks>
        ''' AUTH ʂ̐ݒ\Ȓl͉L̒ʂłB
        ''' <see cref="AuthPlain"/>  PLAIN gp܂B
        ''' <see cref="AuthLogin"/>  LOGIN gp܂B
        ''' <see cref="AuthCramMd5"/> CRAM MD5 gp܂B
        ''' AuthNotUse ȊO Or ŕw\łB
        ''' CRAM MD5LOGINPLAIN ̗D揇ʂŔF؂݂܂B
        ''' </remarks>
        Public Sub Authenticate(ByVal id_str As String, ByVal pass_str As String, ByVal mode As Integer)
            _id = id_str
            _password = pass_str
            _mode = mode
            Authenticate()
        End Sub

        ''' <summary>
        ''' SMTP |[gԍłB
        ''' </summary>
        ''' <value>SMTP |[gԍ</value>
        Public Property Port() As Integer
            Get
                Return _port
            End Get
            Set(ByVal Value As Integer)
                _port = Value
            End Set
        End Property

        ''' <summary>
        ''' \PbgnhłB
        ''' </summary>
        ''' <value>SMTP \Pbgnh</value>
        Public ReadOnly Property Handle() As IntPtr
            Get
                Return _socket
            End Get
        End Property

        ''' <summary>
        ''' SMTP T[ołB
        ''' </summary>
        ''' <value>SMTP T[o</value>
        Public Property HostName() As String
            Get
                Return _host
            End Get
            Set(ByVal Value As String)
                _host = Value
            End Set
        End Property

        ''' <summary>
        ''' SMTP AUTH p̃[U[łB
        ''' </summary>
        ''' <value>SMTP AUTH [U[</value>
        Public Property Id() As String
            Get
                Return _id
            End Get
            Set(ByVal Value As String)
                _id = Value
            End Set
        End Property

        ''' <summary>
        ''' SMTP AUTH p̃pX[hłB
        ''' </summary>
        ''' <value>SMTP AUTH pX[h</value>
        Public Property Password() As String
            Get
                Return _password
            End Get
            Set(ByVal Value As String)
                _password = Value
            End Set
        End Property

        ''' <summary>
        ''' [̈łB
        ''' </summary>
        ''' <value>[ </value>
        Public Property MailTo() As String
            Get
                Return _to
            End Get
            Set(ByVal Value As String)
                _to = Value
            End Set
        End Property

        ''' <summary>
        ''' [ CC łB
        ''' </summary>
        ''' <value>[ CC</value>
        Public Property Cc() As String
            Get
                Return _cc
            End Get
            Set(ByVal Value As String)
                _cc = Value
            End Set
        End Property

        ''' <summary>
        ''' [ BCC łB
        ''' </summary>
        ''' <value>[ BCC</value>
        Public Property Bcc() As String
            Get
                Return _bcc
            End Get
            Set(ByVal Value As String)
                _bcc = Value
            End Set
        End Property

        ''' <summary>
        ''' [̍olłB
        ''' </summary>
        ''' <value>[ol</value>
        Public Property From() As String
            Get
                Return _from
            End Get
            Set(ByVal Value As String)
                _from = Value
            End Set
        End Property

        ''' <summary>
        ''' [̌łB
        ''' </summary>
        ''' <value>[</value>
        Public Property Subject() As String
            Get
                Return _subject
            End Get
            Set(ByVal Value As String)
                _subject = Value
            End Set
        End Property

        ''' <summary>
        ''' [̖{łB
        ''' </summary>
        ''' <value>[{</value>
        Public Property Body() As String
            Get
                Return _body
            End Get
            Set(ByVal Value As String)
                _body = Value
            End Set
        End Property

        ''' <summary>
        ''' [̓Ytt@CłB
        ''' </summary>
        ''' <remarks>
        ''' ̓Ytt@C𑗐MꍇA"," ŋ؂܂B
        ''' <see cref="Options.SplitChar"/>ŋ؂蕶ύXł܂B
        ''' </remarks>
        ''' <value>Ytt@C</value>
        Public Property FileName() As String
            Get
                _filename = String.Join(Options.SplitChar, _filename_list)
                Return _filename
            End Get
            Set(ByVal Value As String)
                _filename = Value
                If _filename.Length > 0 Then
                    _filename_list = _filename.ToString().Split(Options.SplitChar)
                Else
                    _filename_list = New String() {}
                End If
            End Set
        End Property

        ''' <summary>
        ''' Ytt@C̔złB
        ''' </summary>
        ''' <value>Ytt@C</value>
        Public Property FileNameList() As String()
            Get
                Return _filename_list
            End Get
            Set(ByVal Value As String())
                _filename_list = Value
            End Set
        End Property

        ''' <summary>
        ''' [̒ǉwb_łB
        ''' </summary>
        ''' <remarks>
        ''' ̃wb_ǉꍇAC# ł '\r\n'AVisual Basic ł vbCrLf
        ''' ŘAĂB
        ''' </remarks>
        ''' <value>ǉwb_</value>
        Public Property Header() As String
            Get
                Return _header
            End Get
            Set(ByVal Value As String)
                _header = Value
            End Set
        End Property

        ''' <summary>
        ''' [M̃IvVwłB
        ''' </summary>
        ''' <value>MIvV</value>
        ''' <remarks>
        ''' <para><see cref="AddDateField"/>MtB[h nMail.DLL Ő܂B</para>
        ''' <para><see cref="AddMessageId"/>Message-ID tB[h nMail.DLL Ő܂B</para>
        ''' <para><see cref="SuspendAttachmentFile"/>Ytt@CMňꎞx~̈ڂɎw肵܂B</para>
        ''' <para><see cref="SuspendNext"/>Ytt@CMňꎞx~̓ڈȍ~Ɏw肵܂B</para>
        '''	<para><see cref="FileNameRfc2231"/>RFC2231 œYtt@CGR[h܂B</para>
        ''' <para><see cref="EncodeUtf8"/>UTF-8 Ń[GR[h܂iBASE64ŃGR[h܂j</para>
        ''' <para>C# ̏ꍇ |AVB.NET ̏ꍇ Or ŕ̎w肪\łB SuspendAttachmentFile  SuspendNext ͓Ɏwł܂B</para>
        ''' </remarks>
        Public Property Flag() As Integer
            Get
                Return _flag
            End Get
            Set(ByVal Value As Integer)
                _flag = Value
            End Set
        End Property

        ''' <summary>
        ''' SMTP AUTH ̎ʂłB
        ''' </summary>
        ''' <remarks>
        ''' <see cref="AuthNotUse"/>  SMTP AUTH ͎gp܂B
        ''' <see cref="AuthPlain"/>  PLAIN gp܂B
        ''' <see cref="AuthLogin"/>  LOGIN gp܂B
        ''' <see cref="AuthCramMd5"/> CRAM MD5 gp܂B
        ''' AuthNotUse ȊO C#  | AVisual Basic ł or ŕݒ\łB
        ''' CRAM MD5LOGINPLAIN ̏ԂŔF؂݂܂B
        '''	ftHgl AuthNotUse łB
        ''' </remarks>
        ''' <value>M[h</value>
        Public Property AuthMode() As Integer
            Get
                Return _mode
            End Get
            Set(ByVal Value As Integer)
                _mode = Value
            End Set
        End Property

        ''' <summary>
        ''' [M̃G[ԍłB
        ''' </summary>
        ''' <value>G[ԍ</value>
        Public ReadOnly Property ErrorCode() As Integer
            Get
                Return _err
            End Get
        End Property

        ''' <summary>
        ''' SSL ݒtOłB
        ''' </summary>
        ''' <value>SSL ݒtO</value>
        Public Property SSL() As Integer
            Get
                Return _ssl
            End Get
            Set(ByVal Value As Integer)
                _ssl = Value
            End Set
        End Property
        ''' <summary>
        ''' SSL NCAgؖłB
        ''' </summary>
        ''' <remarks>
        ''' nothing ̏ꍇw肵܂B
        ''' </remarks>
        ''' <value>SSL NCAgؖ</value>
        Public Property CertName() As String
            Get
                Return _cert_name
            End Get
            Set(ByVal Value As String)
                _cert_name = Value
            End Set
        End Property
    End Class

    ''' <summary>
    ''' Ytt@CWJNX
    ''' </summary>
    Class Attachment
        Implements IDisposable
        ''' <summary>
        ''' wb_̈̃TCYłB
        ''' </summary>
        Protected Const HeaderSize As Integer = 32768
        ''' <summary>
        ''' pX̃TCYłB
        ''' </summary>
        Protected Const MaxPath As Integer = 32768
        ''' <summary>
        ''' Ytt@CWJpobt@̃TCYłB
        ''' </summary>
        Protected Const AttachmentTempSize As Integer = 2000

        ''' <summary>
        ''' ꂽYtt@C̏Ԃ܂B
        ''' </summary>
        Public Const ErrorInvalidNo As Integer = -3
        ''' <summary>
        ''' Ytt@C쐬ł܂łB
        ''' </summary>
        Public Const ErrorFileOpen As Integer = -5
        ''' <summary>
        ''' Ytt@C̓WJIĂ܂B
        ''' </summary>
        Public Const ErrorPartial As Integer = -6
        ''' <summary>
        ''' Ytt@CƓ̃t@CtH_ɑ݂܂B
        ''' </summary>
        ''' <remarks>
        ''' <para><see cref="nMail.Options.AlreadyFile"/>  <see cref="nMail.Options.FileAlreadyError"/></para>
        ''' <para>ݒ肵A<see cref="Path"/>Ŏw肵tH_ɓYtt@CƓÕt@C</para>
        ''' <para>ꍇɂ̃G[܂B</para>
        ''' </remarks>
        Public Const ErrorFileAlready As Integer = -7
        ''' <summary>
        ''' mۃG[łB
        ''' </summary>
        Public Const ErrorMemory As Integer = -9
        ''' <summary>
        ''' ̑̃G[łB
        ''' </summary>
        Public Const ErrorEtc As Integer = -10
        ''' <summary>
        ''' Ytt@C݂͑܂B
        ''' </summary>
        Public Const NoAttachmentFile As Integer = -1

        ''' <summary>
        ''' wb_f[^̃Xg
        ''' </summary>
        Protected _header_list As ArrayList
        ''' <summary>
        ''' {f[^̃Xg
        ''' </summary>
        Protected _body_list As ArrayList

        ''' <summary>
        ''' wb_[TCYłB
        ''' </summary>
        Protected _header_size As Integer = -1
        ''' <summary>
        ''' G[ԍłB
        ''' </summary>
        Protected _err As Integer
        ''' <summary>
        ''' Ytt@CۑpXłB
        ''' </summary>
        Protected _path As String = Nothing
        ''' <summary>
        ''' [̌łB
        ''' </summary>
        Protected _subject As StringBuilder
        ''' <summary>
        ''' [̑MłB
        ''' </summary>
        Protected _date As StringBuilder
        ''' <summary>
        ''' [̍olłB
        ''' </summary>
        Protected _from As StringBuilder
        ''' <summary>
        ''' [̃wb_łB
        ''' </summary>
        Protected _header As StringBuilder
        ''' <summary>
        ''' [̖{łB
        ''' </summary>
        Protected _body As StringBuilder
        ''' <summary>
        ''' WJYtt@CłB
        ''' </summary>
        Protected _filename As StringBuilder
        ''' <summary>
        ''' Ytt@C̃XgłB
        ''' </summary>
        Protected _filename_list As String() = Nothing
        ''' <summary>
        ''' t@C ID łB
        ''' </summary>
        Protected _id As StringBuilder
        ''' <summary>
        ''' WJJnǂ̃tOłB
        ''' </summary>
        Private _attachment_flag As Boolean = False
        ''' <summary>
        ''' Dispose sǂ̃tOłB
        ''' </summary>
        Private _disposed As Boolean = False
        ''' <summary>
        ''' HTML p[gۑt@C̖OłB
        ''' </summary>
        Protected _html_file As StringBuilder
        ''' <summary>
        ''' wb_tB[hłB
        ''' </summary>
        Protected _field_name As String
        ''' <summary>
        ''' wb_tB[hei[obt@łB
        ''' </summary>
        Protected _field As StringBuilder
        ''' <summary>
        ''' message/rfc822 p[gۑt@C̖OłB
        ''' </summary>
        Protected _rfc822_file As StringBuilder

        <DllImport("nMail.DLL", EntryPoint:="NMailAttachmentFileFirst", CharSet:=CharSet.Auto)> _
        Protected Shared Function AttachmentFileFirst(ByVal Temp As IntPtr, ByVal Subject As StringBuilder, ByVal DateStr As StringBuilder, ByVal From As StringBuilder, ByVal Header As StringBuilder, ByVal Body As StringBuilder, ByVal Path As String, ByVal FileName As StringBuilder, ByVal FirstHeader As String, ByVal FirstBody As String) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailAttachmentFileNextVB", CharSet:=CharSet.Auto)> _
        Protected Shared Function AttachmentFileNextVB(ByVal Temp As IntPtr, ByVal Subject As StringBuilder, ByVal DateStr As StringBuilder, ByVal From As StringBuilder, ByVal Header As StringBuilder, ByVal Body As StringBuilder, ByVal Path As String, ByVal FileName As StringBuilder, ByVal NextHeader As String, ByVal NextBody As String) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailAttachmentFileClose")> _
        Protected Shared Function AttachmentFileClose(ByVal Temp As IntPtr) As Boolean
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailAttachmentFileStatus", CharSet:=CharSet.Auto)> _
        Protected Shared Function AttachmentFileStatus(ByVal Header As String, ByVal Id As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailGetHeaderField", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3GetHeaderField(ByVal Field As StringBuilder, ByVal Header As String, ByVal Name As String, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailDecodeHeaderField", CharSet:=CharSet.Auto)> _
        Protected Shared Function Pop3DecodeHeaderField(ByVal Dst As StringBuilder, ByVal Src As String, ByVal Size As Integer) As Integer
        End Function

        ''' <summary>
        ''' wb_i[pobt@̃TCY肵܂B
        ''' </summary>
        Protected Sub SetHeaderSize()
            If _header_size < 0 Then
                _header_size = Options.HeaderMax
            End If
            If _header_size <= 0 Then
                _header_size = HeaderSize
                Options.HeaderMax = _header_size
            End If
        End Sub

        ''' <summary>
        ''' <c>Attachment</c>NX̐VKCX^X܂B
        ''' </summary>
        Public Sub New()
            _header_list = New ArrayList
            _body_list = New ArrayList
        End Sub

        ''' <summary>
        ''' 
        ''' </summary>
        Protected Overrides Sub Finalize()
            MyBase.Finalize()
            Dispose(False)
        End Sub

        ''' <summary>
        ''' <see cref="Attachment"/>ɂĎgpĂ邷ׂẴ\[X܂B
        ''' </summary>
        Overridable Overloads Sub Dispose() Implements IDisposable.Dispose
            Dispose(True)
            GC.SuppressFinalize(Me)
        End Sub

        ''' <summary>
        ''' <see cref="Attachment"/>ɂĎgpĂ邷ׂẴ\[X܂B
        ''' </summary>
        ''' <param name="disposing">
        ''' }l[W\[XƃA}l[W\[X̗ꍇ<c>true</c>B
        ''' A}l[W\[Xꍇ<c>false</c>B
        ''' </param>
        Protected Overloads Sub Dispose(ByVal disposing As Boolean)
            If Not _disposed Then
                If disposing Then
                End If
                If _attachment_flag Then
                    AttachmentFileClose(IntPtr.Zero)
                    _attachment_flag = False
                End If
                _disposed = True
            End If
        End Sub

        Public Sub Close()
            If _attachment_flag Then
                AttachmentFileClose(IntPtr.Zero)
                _attachment_flag = False
            End If
        End Sub

        ''' <summary>
        ''' [{̍vTCY擾܂B
        ''' </summary>
        ''' <returns>[{̍vTCY</returns>
        Protected Function GetBodySize() As Integer
            Dim size As Integer = 0
            Dim str As String
            Dim no As Integer

            For no = 0 To _header_list.Count - 1
                If no < _body_list.Count Then
                    str = CStr(_body_list(no))
                    size += str.Length
                End If
                str = CStr(_header_list(no))
                size += str.Length
            Next no
            Return size
        End Function

        ''' <summary>
        ''' Ytt@CWJĕۑ܂B
        ''' </summary>
        '''	<see cref="Add"/>ŌƂȂ镶iwb_,{)ǉĂ܂B
        Public Sub Save()
            Dim read_body As String
            Dim read_header As String
            Dim keep_id As String = ""
            Dim no As Integer
            Dim id_no As Integer = -1

            If Not _path Is Nothing Then
                If (_path <> "") And (Not Directory.Exists(_path)) Then
                    Throw New DirectoryNotFoundException(_path)
                End If
            End If

            SetHeaderSize()

            _subject = New StringBuilder(_header_size)
            _date = New StringBuilder(_header_size)
            _from = New StringBuilder(_header_size)
            _header = New StringBuilder(_header_size)
            _body = New StringBuilder(GetBodySize())
            Options.FileNameMax = MaxPath
            _filename = New StringBuilder(MaxPath)

            If (_header_list.Count <> _body_list.Count) And (_body_list.Count > 0) Then
                Throw New FormatException
            End If
            For no = 0 To _header_list.Count - 1
                If no < _body_list.Count Then
                    read_body = CStr(_body_list(no))
                Else
                    read_body = ""
                End If
                read_header = CStr(_header_list(no))
                If no = 0 Then
                    id_no = GetId(read_header)
                    If id_no > 1 Then
                        Throw New nMailException("Save", ErrorInvalidNo)
                    End If
                    keep_id = PartId
                    _attachment_flag = True
                    _err = AttachmentFileFirst(IntPtr.Zero, _subject, _date, _from, _header, _body, _path, _filename, read_header, read_body)
                Else
                    If (GetId(read_header) <> no + 1) Or (keep_id <> PartId) Then
                        Throw New nMailException("Save", ErrorInvalidNo)
                    End If
                    _err = AttachmentFileNextVB(IntPtr.Zero, _subject, _date, _from, _header, _body, _path, _filename, read_header, read_body)
                End If
                If (_err < 0) And (_err <> ErrorPartial) Then
                    Throw New nMailException("Save", _err)
                End If
            Next no
            If Options.SaveHtmlFile = Options.SaveHtmlFileOn Then
                _html_file = New StringBuilder(_header_size)
                Pop3GetHeaderField(_html_file, _header.ToString(), "X-NMAIL-HTML-FILE:", _header_size)
            End If
            If Options.SaveRfc822File <> Options.SaveRfc822FileOff Then
                _rfc822_file = New StringBuilder(_header_size)
                Pop3GetHeaderField(_rfc822_file, _header.ToString(), "X-NMAIL-RFC822-FILE:", _header_size)
            End If
            AttachmentFileClose(IntPtr.Zero)
            _attachment_flag = False
        End Sub

        ''' <summary>
        ''' WJƂȂ镪t@Cf[^Xgɒǉ܂B
        ''' </summary>
        ''' <param name="header_body">wb_[{{̕</param>
        ''' <remarks>
        '''	wb_Ɩ{̊Ԃɂ͈s̋sKvłB
        ''' </remarks>
        Public Sub Add(ByVal header_body As String)
            _header_list.Add(header_body)
        End Sub

        ''' <summary>
        ''' WJƂȂ镪t@Cf[^Xgɒǉ܂B
        ''' </summary>
        ''' <param name="header">wb_[̕</param>
        ''' <param name="body">{̕</param>
        Public Sub Add(ByVal header As String, ByVal body As String)
            _header_list.Add(header)
            _body_list.Add(body)
        End Sub

        ''' <summary>
        ''' t@C ID 擾܂B
        ''' </summary>
        ''' <param name="header">wb_[̕</param>
        ''' <returns><see cref="NoAttachmentFile"/>̏ꍇĂȂYtt@Ct[łB
        ''' 1 ȏ̏ꍇAt@C̔ԍƂȂ܂B
        ''' </returns>
        Public Function GetId(ByVal header As String) As Integer
            _id = New StringBuilder(header.Length)
            Return AttachmentFileStatus(header, _id, header.Length)
        End Function

        ''' <summary>
        ''' [wb_w̃tB[h̓e擾܂B
        ''' </summary>
        ''' <param name="field_name">tB[h</param>
        ''' <returns>tB[h̓e
        ''' </returns>
        Public Function GetHeaderField(ByVal field_name As String) As String
            _field_name = field_name
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            _err = Pop3GetHeaderField(_field, _header.ToString(), _field_name, _header_size)
            If _err < 0 Then
                Throw New nMailException("GetHeaderField", _err)
            End If
            Return _field.ToString()
        End Function

        ''' <summary>
        ''' [wb_w̃tB[h̓e擾܂B
        ''' </summary>
        ''' <param name="field_name">tB[h</param>
        ''' <returns>tB[h̓e
        ''' </returns>
        Public Function GetHeaderField(ByVal field_name As String, ByVal header As String) As String
            _field_name = field_name
            _header = New StringBuilder(header)
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            _err = Pop3GetHeaderField(_field, _header.ToString(), _field_name, _header_size)
            If _err < 0 Then
                Throw New nMailException("GetHeaderField", _err)
            End If
            Return _field.ToString()
        End Function

        ''' <summary>
        ''' MIME wb_tB[h̕fR[h܂
        ''' </summary>
        ''' <param name="field">tB[h̕</param>
        ''' <returns>fR[htB[he</returns>
        Public Function DecodeHeaderField(ByVal field As String) As String
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            _err = Pop3DecodeHeaderField(_field, field, _header_size)
            If _err < 0 Then
                Throw New nMailException("DecodeHeaderField", _err)
            End If
            Return _field.ToString()
        End Function

        ''' <summary>
        ''' [wb_w̃wb_tB[h̓e擾A
        ''' MIME wb_tB[h̃fR[hsĕԂ܂
        ''' </summary>
        ''' <param name="field_name">tB[h</param>
        ''' <returns>擾fR[hς݂̃tB[he</returns>
        Public Function GetDecodeHeaderField(ByVal field_name As String) As String
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            Dim src As String = GetHeaderField(field_name, _header.ToString())
            _err = Pop3DecodeHeaderField(_field, src, _header_size)
            If _err < 0 Then
                Throw New nMailException("DecodeHeaderField", _err)
            End If
            Return _field.ToString()
        End Function

        ''' <summary>
        ''' [wb_w̃wb_tB[h̓e擾A
        ''' MIME wb_tB[h̃fR[hsĕԂ܂
        ''' </summary>
        ''' <param name="field_name">tB[h</param>
        ''' <param name="header">wb_</param>
        ''' <returns>擾fR[hς݂̃tB[he</returns>
        Public Function GetDecodeHeaderField(ByVal field_name As String, ByVal header As String) As String
            SetHeaderSize()
            _err = Pop3DecodeHeaderField(_field, GetHeaderField(field_name, header), _header_size)
            If _err < 0 Then
                Throw New nMailException("DecodeHeaderField", _err)
            End If
            Return _field.ToString()
        End Function

        ''' <summary>
        ''' 
        ''' </summary>
        ''' <value>[</value>
        Public ReadOnly Property Subject() As String
            Get
                Return _subject.ToString()
            End Get

        End Property
        ''' <summary>
        ''' [̑M̕łB
        ''' </summary>
        ''' <value>[M</value>
        Public ReadOnly Property DateString() As String
            Get
                Return _date.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [̍olłB
        ''' </summary>
        ''' <value>[ol</value>
        Public ReadOnly Property From() As String
            Get
                Return _from.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [̖{łB
        ''' </summary>
        ''' <value>[{</value>
        Public ReadOnly Property Body() As String
            Get
                Return _body.ToString()
            End Get
        End Property

        ''' <summary>
        ''' Ytt@CۑtH_łB
        ''' </summary>
        ''' <remarks>
        ''' Nothing ̏ꍇۑ܂B
        ''' </remarks>
        ''' <value>Ytt@CۑtH_</value>
        Public Property Path() As String
            Get
                Return _path
            End Get
            Set(ByVal Value As String)
                _path = Value
            End Set
        End Property

        ''' <summary>
        ''' t@C ID łB
        ''' </summary>
        ''' <value>t@C ID</value>
        Public ReadOnly Property PartId() As String
            Get
                Return _id.ToString()
            End Get
        End Property

        ''' <summary>
        ''' Ytt@CłB
        ''' </summary>
        ''' <remarks>
        ''' ̓Ytt@CꍇA"," ŋ؂Ċi[܂B
        ''' <see cref="Options.SplitChar"/>ŋ؂蕶ύXł܂B
        ''' </remarks>
        ''' <value>Ytt@C</value>
        Public ReadOnly Property FileName() As String
            Get
                Return _filename.ToString()
            End Get
        End Property

        ''' <summary>
        ''' Ytt@C̔złB
        ''' </summary>
        ''' <value>Ytt@C</value>
        Public ReadOnly Property FileNameList() As String()
            Get
                If _filename.Length > 0 Then
                    _filename_list = _filename.ToString().Split(Options.SplitChar)
                Else
                    _filename_list = New String() {}
                End If
                Return _filename_list
            End Get
        End Property

        ''' <summary>
        ''' G[ԍ
        ''' </summary>
        ''' <value>G[ԍ</value>
        Public ReadOnly Property ErrorCode() As Integer
            Get
                Return _err
            End Get
        End Property

        ''' <summary>
        ''' HTML p[gۑt@C̖OłB
        ''' </summary>
        ''' <value>t@C</value>
        Public ReadOnly Property HtmlFile() As String
            Get
                If _html_file Is Nothing Then
                    Return ""
                Else
                    Return _html_file.ToString()
                End If
            End Get
        End Property

        ''' <summary>
        ''' wb_̃tB[hłB
        ''' </summary>
        ''' <value>wb_̃tB[h</value>
        Public ReadOnly Property FieldName() As String
            Get
                Return _field_name
            End Get
        End Property

        ''' <summary>
        ''' wb_tB[h̓ełB
        ''' </summary>
        ''' <value>wb_tB[h̓e</value>
        Public ReadOnly Property Field() As String
            Get
                Return _field.ToString()
            End Get
        End Property

        ''' <summary>
        ''' message/rfc822 p[gۑt@C̖OłB
        ''' </summary>
        ''' <value>t@C</value>
        Public ReadOnly Property Rfc822File() As String
            Get
                If _rfc822_file Is Nothing Then
                    Return ""
                Else
                    Return _rfc822_file.ToString()
                End If
            End Get
        End Property
    End Class

    Class Options
		''' <summary>
		''' 
		''' </summary>
        Protected Const MessageSize As Integer = 32768

		''' <summary>
		''' IvVF^CAEg
		''' </summary>
        Protected Const OptionTimeout As Integer = 0
		''' <summary>
		''' IvVFwb_TCY
		''' </summary>
        Protected Const OptionHeaderMax As Integer = 1
		''' <summary>
		''' IvVF{TCY
		''' </summary>
        Protected Const OptionBodyMax As Integer = 2
		''' <summary>
		''' IvVF㏑[h
		''' </summary>
        Protected Const OptionAlreadyFile As Integer = 3
		''' <summary>
		''' IvVFfobN[h
		''' </summary>
        Protected Const OptionDebugMode As Integer = 4
		''' <summary>
		''' IvVFڑ^CAEg
		''' </summary>
        Protected Const OptionConnectTimeout As Integer = 5
		''' <summary>
		''' IvVF؂蕶
		''' </summary>
        Protected Const OptionSplitChar As Integer = 6
		''' <summary>
		''' IvVFꎞx~TCY
		''' </summary>
        Protected Const OptionSuspendSize As Integer = 7
		''' <summary>
		''' IvVFSleep 
		''' </summary>
        Protected Const OptionSleepTime As Integer = 8
		''' <summary>
		''' IvVFtB[hTCY
		''' </summary>
        Protected Const OptionFieldMax As Integer = 9
		''' <summary>
		''' IvVFHTML p[gۑ
		''' </summary>
		Protected Const OptionSaveHtmlFile As Integer = 10
		''' <summary>
		''' IvVF{fR[h
		''' </summary>
		Protected Const OptionDecodeBody As Integer = 11
		''' <summary>
		''' IvVFwb_fR[h
		''' </summary>
		Protected Const OptionDecodeHeader As Integer = 12
		''' <summary>
		''' IvVFYtt@Ci[obt@TCY
		''' </summary>
		Protected Const OptionFileNameMax As Integer = 13
		''' <summary>
		''' IvVFYtt@CɎgpłȂu镶
		''' </summary>
		Protected Const OptionChangeChar As Integer = 14
		''' <summary>
		''' IvVFYtt@Cu
		''' </summary>
		Protected Const OptionChangeCharMode As Integer = 15
		''' <summary>
		''' IvVFmessage/rfc822 p[gۑ
		''' </summary>
		Protected Const OptionSaveRfc822File As Integer = 16

		''' <summary>
		''' t@C㏑܂B
		''' </summary>
        Public Const FileOverwrite As Integer = 0
		''' <summary>
		''' t@C̖(gq̑O)ɐǉĕۑ܂B
		''' </summary>
        Public Const FileRename As Integer = 1
		''' <summary>
		''' t@C쐬G[Ƃ܂B
		''' </summary>
        Public Const FileAlreadyError As Integer = 2

		''' <summary>
		''' G[bZ[W擾܂B
		''' </summary>
        Public Const MessageError As Integer = 0
		''' <summary>
		''' fobOp̃T[oƂ̌M擾܂B
		''' </summary>
        Public Const MessageDebug As Integer = 1

		''' <summary>
		''' fobN[hLłB
		''' </summary>
        Public Const DebugStart As Integer = 1
		''' <summary>
		''' fobN[hłB(l)
		''' </summary>
        Public Const DebugEnd As Integer = 0

		''' <summary>
		''' ڑ^CAEgLłB
		''' </summary>
        Public Const ConnectTimeoutOn As Integer = 1
		''' <summary>
		''' ڑ^CAEgłB(l)
		''' </summary>
        Public Const ConnectTimeoutOff As Integer = 0

		''' <summary>
		''' HTML p[gt@Cɕۑ܂B
		''' </summary>
		Public Const SaveHtmlFileOn As Integer = 1
		''' <summary>
		''' HTML p[gt@Cɕۑ܂B
		''' </summary>
		Public Const SaveHtmlFileOff As Integer = 0
		''' <summary>
		''' {͑SăfR[h܂B
		''' </summary>
        Public Const DecodeBodyOn As Integer = 0
		''' <summary>
		''' {͑SăfR[h܂B
		''' </summary>
        Public Const DecodeBodyAllOff As Integer = 1
		''' <summary>
		''' eLXgp[g Content-Transfer-Encoding (Quoted-Printable  BASE64) ̂݃fR[h܂B
		''' </summary>
        Public Const DecodeBodyTextOff As Integer = 2
		''' <summary>
		''' wb_͑SăfR[h܂B
		''' </summary>
        Public Const DecodeHeaderOn As Integer = 0
		''' <summary>
		''' wb_͑SăfR[h܂񂪁As̘A͍s܂B
		''' </summary>
        Public Const DecodeHeaderOff As Integer = 1
		''' <summary>
		''' wb_͑SăfR[hAs̘As܂B
		''' </summary>
        Public Const DecodeHeaderAllOff As Integer = 2

		''' <summary>
		''' gpsȕƋ؂蕶u܂B(l)
		''' </summary>
		Public Const ChangeSplitChar As Integer = 0
		''' <summary>
		''' pXy[Xu܂B
		''' </summary>
		Public Const ChangeHalfSpace As Integer = 1
		''' <summary>
		''' SpXy[Xu܂B
		''' </summary>
		Public Const ChangeFullSpace As Integer = 2
		''' <summary>
		''' pESpXy[Xu܂B
		''' </summary>
		Public Const ChangeAllSpace As Integer = 3
		''' <summary>
		''' ؂蕶u܂B
		''' </summary>
		Public Const ChangeNoSplitChar As Integer = 4

		''' <summary>
		''' message/rfc822 p[g܂Ƃ߂ăt@Cɕۑ܂B
		''' </summary>
		Public Const SaveRfc822FileAllOn As Integer = 2
		''' <summary>
		''' message/rfc822 p[g̃eLXgt@Cɕۑ܂B
		''' </summary>
		Public Const SaveRfc822FileBodyOn As Integer = 1
		''' <summary>
		''' message/rfc822 p[gt@Cɕۑ܂B
		''' </summary>
		Public Const SaveRfc822FileOff As Integer = 0

        <DllImport("nMail.DLL", EntryPoint:="NMailGetVersion")> _
        Public Shared Function GetVersion() As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailGetOption")> _
        Public Shared Function GetOption(ByVal opt As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailSetOption")> _
        Public Shared Function SetOption(ByVal opt As Integer, ByVal value As Integer) As Boolean
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailGetMessage", CharSet:=CharSet.Auto)> _
        Public Shared Sub GetMessage(ByVal Type As Integer, ByVal Message As StringBuilder, ByVal Size As Integer)
        End Sub

        <DllImport("nMail.DLL", EntryPoint:="NMailGetSuspendNumber", CharSet:=CharSet.Auto)> _
        Public Shared Function GetSuspendNumber(ByVal Path As String) As Integer
        End Function

        ''' <summary>
        ''' fobN[hJn܂B
        ''' </summary>
        ''' <remarks>
        ''' <see cref="EndDebug"/>Ăяo <see cref="DebugMessage"/>
        ''' QƂ邱ƂɂăT[oƂ̌M擾ł܂B
        ''' </remarks>
        Public Shared Sub StartDebug()
            SetOption(OptionDebugMode, DebugStart)
        End Sub

        ''' <summary>
        ''' fobN[hI܂B
        ''' </summary>
        ''' <remarks>
        ''' Ăяo <see cref="DebugMessage"/> QƂ邱ƂɂăT[o
        ''' Ƃ̌M擾ł܂B
        ''' </remarks>
        Public Shared Sub EndDebug()
            SetOption(OptionDebugMode, DebugEnd)
        End Sub

        ''' <summary>
        ''' ڑ^CAEgݒLɂ܂B
        ''' </summary>
        Public Shared Sub EnableConnectTimeout()
            SetOption(OptionConnectTimeout, ConnectTimeoutOn)
        End Sub

        ''' <summary>
        ''' ڑ^CAEgݒ𖳌ɂ܂B
        ''' </summary>
        Public Shared Sub DisableConnectTimeout()
            SetOption(OptionConnectTimeout, ConnectTimeoutOff)
        End Sub
		''' <summary>
		''' HTML p[gt@Cɕۑ܂B
		''' </summary>
		Public Shared Sub EnableSaveHtmlFile()
			SetOption(OptionSaveHtmlFile, SaveHtmlFileOn)
		End Sub
		''' <summary>
		''' HTML p[gt@Cɕۑ܂B
		''' </summary>
		Public Shared Sub DisableSaveHtmlFile()
			SetOption(OptionSaveHtmlFile, SaveHtmlFileOff)
		End Sub
		''' <summary>
		''' {fR[h܂B
		''' </summary>
		Public Shared Sub EnableDecodeBody()
            SetOption(OptionDecodeBody, DecodeBodyOn)
		End Sub
		''' <summary>
		''' {fR[h܂B
		''' </summary>
		Public Shared Sub DisableDecodeBodyAll()
            SetOption(OptionDecodeBody, DecodeBodyAllOff)
		End Sub
		''' <summary>
		''' eLXgp[g Content-Transfer-Encoding (Quoted-Printable  BASE64) fR[h܂B
		''' </summary>
		Public Shared Sub DisableDecodeBodyText()
            SetOption(OptionDecodeBody, DecodeBodyTextOff)
		End Sub
		''' <summary>
		''' wb_fR[h܂B
		''' </summary>
		Public Shared Sub EnableDecodeHeader()
            SetOption(OptionDecodeHeader, DecodeHeaderOn)
		End Sub
		''' <summary>
		''' wb_fR[h܂񂪁As̘A͍s܂B
		''' </summary>
		Public Shared Sub DisableDecodeHeader()
            SetOption(OptionDecodeHeader, DecodeHeaderOff)
		End Sub
		''' <summary>
		''' wb_fR[hAs̘As܂B
		''' </summary>
		Public Shared Sub DisableDecodeHeaderAll()
            SetOption(OptionDecodeHeader, DecodeHeaderAllOff)
		End Sub
		''' <summary>
		''' message/rfc822 p[g܂Ƃ߂ăt@Cɕۑ܂B
		''' </summary>
		Public Shared Sub EnableSaveRfc822FileAll()
			SetOption(OptionSaveRfc822File, SaveRfc822FileAllOn)
		End Sub
		''' <summary>
		''' message/rfc822 p[g̃eLXgt@Cɕۑ܂B
		''' </summary>
		Public Shared Sub EnableSaveRfc822FileBody()
			SetOption(OptionSaveRfc822File, SaveRfc822FileBodyOn)
		End Sub
		''' <summary>
        ''' message/rfc822 p[gt@Cɕۑ܂B
		''' </summary>
        Public Shared Sub DisableSaveRfc822File()
            SetOption(OptionSaveRfc822File, SaveRfc822FileOff)
        End Sub

        ''' <summary>
        ''' w肳ꂽt@CYt[𑗐Mꍇ̋x~񐔂𓾂
        ''' </summary>
        ''' <param name="file_name">Ytt@C</param>
        ''' <returns>w肳ꂽt@CYt[𑗐Mꍇ̋x~񐔂𓾂</returns>
        Public Shared Function SuspendCount(ByVal file_name As String) As Integer
            If Not File.Exists(file_name) Then
                Throw New FileNotFoundException
            End If
            Return GetSuspendNumber(file_name)
        End Function

        ''' <summary>
        ''' o[W̐lłB
        ''' </summary>
        ''' <remarks>
        ''' nMail.DLL ̃o[W̐lłB
        ''' Version 1.23 ̏ꍇ 123 ƂȂ܂B
        ''' </remarks>
        ''' <value>o[Wl</value>
        Public Shared ReadOnly Property VersionInt() As Integer
            Get
                Return GetVersion()
            End Get
        End Property

        ''' <summary>
        ''' o[W̕łB
        ''' </summary>
        ''' <remarks>
        ''' nMail.DLL ̃o[W̕łB
        ''' Version 1.23 ̏ꍇ "1.23" ƂȂ܂B
        ''' </remarks>
        ''' <value>o[W</value>
        Public Shared ReadOnly Property Version() As String
            Get
                Dim str As String
                Dim ver As Integer
                ver = GetVersion()
                str = String.Format("{0:d}.{1:d}", ver / 100, ver Mod 100)
                Return str
            End Get
        End Property

        ''' <summary>
        ''' G[bZ[WłB
        ''' </summary>
        ''' <remarks>
        ''' G[ɃT[oԂĂG[bZ[WłB
        ''' </remarks>
        ''' <value>G[bZ[W</value>
        Public Shared ReadOnly Property ErrorMessage() As String
            Get
                Dim message As StringBuilder
                message = New StringBuilder(MessageSize)
                GetMessage(MessageError, message, MessageSize)
                Return message.ToString()
            End Get
        End Property

        ''' <summary>
        ''' fobNpłB
        ''' </summary>
        ''' <remarks>
        ''' <see cref="StartDebug"/>ĂяoɃ[̑MsA
        ''' <see cref="EndDebug"/>Ăяoɂ̃vpeBQƂ邱
        ''' ɂăT[oƂ̌M擾邱Ƃł܂B
        ''' </remarks>
        ''' <value>fobNp</value>
        Public Shared ReadOnly Property DebugMessage() As String
            Get
                Dim message As StringBuilder
                message = New StringBuilder(MessageSize)
                GetMessage(MessageDebug, message, MessageSize)
                Return message.ToString()
            End Get
        End Property

        ''' <summary>
        ''' ^CAEglłB
        ''' </summary>
        ''' <remarks>
        ''' ̐ݒl蒷ԃT[o牞ꍇA
        ''' ^CAEgG[ƂďԂ܂B
        ''' Pʂ͕błB
        ''' ڑ̃^CAEg͒ʏ͖łB
        ''' LɂꍇA<see cref="EnableConnectTimeout"/>
        ''' ĂяoĂB
        ''' </remarks>
        ''' <value>^CAEgl</value>
        Public Shared Property Timeout() As Integer
            Get
                Return GetOption(OptionTimeout)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionTimeout, Value)
            End Set
        End Property

        ''' <summary>
        ''' wb_obt@TCYłB
        ''' </summary>
        ''' <remarks>
        ''' [MYtt@CWJɃwb_f[^i[
        ''' obt@̃TCYłB
        ''' {I<see cref="Pop3"/>NXŃ[̎MsꍇA
        ''' obt@TCY̐ݒs܂̂ŁÃvpeB
        ''' gpKv͂܂B
        ''' </remarks>
        ''' <value>wb_obt@TCY</value>
        Public Shared Property HeaderMax() As Integer
            Get
                Return GetOption(OptionHeaderMax)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionHeaderMax, Value)
            End Set
        End Property

        ''' <summary>
        ''' {obt@TCYłB
        ''' </summary>
        ''' <remarks>
        ''' [MYtt@CWJɃwb_f[^i[
        ''' {̃TCYłB
        ''' {I<see cref="Pop3"/>NXŃ[̎MsꍇA
        ''' [TCYɉobt@TCY̎ws܂̂ŁA
        ''' ̃vpeBgpKv͂܂B
        ''' </remarks>
        ''' <value>{obt@TCY</value>
        Public Shared Property BodyMax() As Integer
            Get
                Return GetOption(OptionBodyMax)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionBodyMax, Value)
            End Set
        End Property

        ''' <summary>
        ''' Ytt@Cۑɓt@Cꍇ̏@łB
        ''' </summary>
        ''' <remarks>
        ''' <see cref="FileOverwrite"/>t@C㏑܂B
        ''' <see cref="FileRename"/>t@C̖(gq̑O)ɐǉ܂B
        ''' <see cref="FileAlreadyError"/>t@C쐬G[Ƃ܂B
        ''' </remarks>
        ''' <value>Ytt@Cۑ̓t@C@</value>
        Public Shared Property AlreadyFile() As Integer
            Get
                Return GetOption(OptionAlreadyFile)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionAlreadyFile, Value)
            End Set
        End Property

        ''' <summary>
        ''' fobN[h
        ''' </summary>
        ''' <remarks>
        ''' <see cref="DebugStart"/>fobN[hLłB
        ''' <see cref="DebugEnd"/>fobN[hłB
        ''' </remarks>
        ''' <value>fobN[h</value>
        Public Shared Property DebugMode() As Integer
            Get
                Return GetOption(OptionDebugMode)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionDebugMode, Value)
            End Set
        End Property

        ''' <summary>
        ''' T[oڑ̃^CAEglłB
        ''' </summary>
        ''' <remarks>
        ''' <see cref="ConnectTimeoutOn"/>ڑ^CAEgLłB
        ''' <see cref="ConnectTimeoutOff"/>ڑ^CAEgłB
        ''' </remarks>
        ''' <value>T[oڑ̃^CAEgl</value>
        Public Shared Property ConnectTimeout() As Integer
            Get
                Return GetOption(OptionConnectTimeout)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionConnectTimeout, Value)
            End Set
        End Property

        ''' <summary>
        ''' Ytt@C̋؂蕶łB
        ''' </summary>
        ''' <remarks>
        ''' Ytt@Cꍇ̋؂蕶łB
        '''	ftHgl , łB
        ''' </remarks>
        ''' <value>Ytt@C؂蕶</value>
        Public Shared Property SplitChar() As Char
            Get
                Return Chr(GetOption(OptionSplitChar))
            End Get
            Set(ByVal Value As Char)
                SetOption(OptionSplitChar, Val(Value))
            End Set
        End Property

        ''' <summary>
        ''' M̍ۂɈU߂f[^TCYłB
        ''' </summary>
        ''' <remarks>
        ''' Ytt@CꍇAŎw肵TCỸf[^
        ''' MƁAU߂܂B
        ''' </remarks>
        ''' <value>M̍ۂɈU߂f[^TCY</value>
        Public Shared Property SuspendSize() As Integer
            Get
                Return GetOption(OptionSuspendSize)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionSuspendSize, Value)
            End Set
        End Property

        ''' <summary>
        ''' T[o̕ԓ҂̍ۂɓ Sleep() ̎ԂłB
        ''' </summary>
        ''' <value>T[o̕ԓ҂̍ۂɓ Sleep() ̎</value>
        Public Shared Property SleepTime() As Integer
            Get
                Return GetOption(OptionSleepTime)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionSleepTime, Value)
            End Set
        End Property

        ''' <summary>
        ''' tB[hobt@̃TCYłB
        ''' </summary>
        ''' <value>tB[hobt@̃TCY</value>
        Public Shared Property FieldMax() As Integer
            Get
                Return GetOption(OptionFieldMax)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionFieldMax, Value)
            End Set
        End Property

        ''' <summary>
        ''' HTML [ HTML p[gt@Cɕۑ邩ǂ̐ݒłB
        ''' </summary>
        ''' <remarks>
        ''' <see cref="SaveHtmlFileOff"/>HTML p[gt@CɕۑȂB(l)
        ''' <see cref="SaveHtmlFileOn"/>HTML p[gt@CɕۑB
        ''' Attachment NXg HTML p[gt@CɕۑꍇA
        ''' EnableSaveHtmlFile() Ăяo <see cref="Pop3.GetMail"/> 
        ''' œǂݏo[f[^gpKv܂B
        ''' </remarks>
        ''' <value>HTML p[gt@Cɕۑ邩ǂ̐ݒl</value>
        Public Shared Property SaveHtmlFile() As Integer
            Get
                Return GetOption(OptionSaveHtmlFile)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionSaveHtmlFile, Value)
            End Set
        End Property
        ''' <summary>
        ''' {̃fR[h̐ݒłB
        ''' </summary>
        ''' <remarks>
        ''' <see cref="DecodeBodyOn"/>SăfR[h܂B(l)
        ''' <see cref="DecodeBodyAllOff"/>SăfR[h܂B{̃eLXg iso-2022-jp ̂܂܂ƂȂ܂B
        ''' <see cref="DecodeBodyTextOff"/>eLXgp[g Content-Transfer-Encoding (Quoted-Printable  BASE64) ̂݃fR[h܂B
        ''' </remarks>
        ''' <value>{fR[h邩ǂ̐ݒl</value>
        Public Shared Property DecodeBody() As Integer
            Get
                Return GetOption(OptionDecodeBody)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionDecodeBody, Value)
            End Set
        End Property
        ''' <summary>
        ''' wb_̃fR[h̐ݒłB
        ''' </summary>
        ''' <remarks>
        ''' <see cref="DecodeHeaderOn"/>SăfR[h܂B(l)
        ''' <see cref="DecodeHeaderOff"/>SăfR[h܂񂪁As̘A͍s܂B
        ''' <see cref="DecodeHeaderAllOff"/>SăfR[hAs̘As܂B
        ''' </remarks>
        ''' <value>wb_fR[h邩ǂ̐ݒl</value>
        Public Shared Property DecodeHeader() As Integer
            Get
                Return GetOption(OptionDecodeHeader)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionDecodeHeader, Value)
            End Set
        End Property
        ''' <summary>
        ''' Ytt@Ci[obt@TCYłB
        ''' </summary>
        ''' <remarks>
        ''' Ytt@Ci[obt@̃TCYłB
        ''' <see cref="Pop3"/><see cref="Imap4"/>NXŃ[̎MsA
        ''' <see cref="Attachment"/>NXœYtt@C̓WJsꍇA
        ''' Ńobt@TCY̐ݒs܂̂ŁA
        ''' ̃vpeBgpKv͂܂B
        ''' </remarks>
        ''' <value>Ytt@Ci[obt@TCY</value>
        Public Shared Property FileNameMax() As Integer
            Get
                Return GetOption(OptionFileNameMax)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionFileNameMax, Value)
            End Set
        End Property

        ''' <summary>
        ''' Ytt@CɎgpłȂu镶
        ''' </summary>
        ''' <remarks>
        ''' Ytt@CɎgpłȂu镶łB
        '''	ftHgl _ łB
        ''' </remarks>
        ''' <value>u</value>
        Public Shared Property ChangeChar() As Char
            Get
                Return Chr(GetOption(OptionChangeChar))
            End Get
            Set(ByVal Value As Char)
                SetOption(OptionChangeChar, Val(Value))
            End Set
        End Property

        ''' <summary>
        ''' Ytt@Cu
        ''' </summary>
        ''' <remarks>
        ''' Ytt@CułB
        ''' ftHgl<see cref="ChangeSplitChar"/>ŁA
        ''' Windows Ńt@CɎgpłȂƁA؂蕶
        ''' gpĂ镶u܂B
        ''' </remarks>
        ''' <value>u</value>
        Public Shared Property ChangeCharMode() As Integer
            Get
                Return GetOption(OptionChangeCharMode)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionChangeCharMode, Value)
            End Set
        End Property

        ''' <summary>
        ''' message/rfc822 p[gt@Cɕۑ邩ǂ̐ݒłB
        ''' </summary>
        ''' <remarks>
        ''' <see cref="SaveRfc822FileOff"/>message/rfc822 p[gt@CɕۑȂB(l)
        ''' <see cref="SaveRfc822FileBodyOn"/>message/rfc822 p[g̃eLXgt@CɕۑB
        ''' <see cref="SaveRfc822FileAllOn"/>message/rfc822 p[gSăt@CɕۑB
        ''' SaveRfc822FileAllOn  message/rfc822 p[gSăt@CɕۑꍇA
        ''' Attachment NXgēYtt@Coł܂B
        ''' </remarks>
        ''' <value>message/rfc822 p[gt@Cɕۑ邩ǂ̐ݒl</value>
        Public Shared Property SaveRfc822File() As Integer
            Get
                Return GetOption(OptionSaveRfc822File)
            End Get
            Set(ByVal Value As Integer)
                SetOption(OptionSaveRfc822File, Value)
            End Set
        End Property
    End Class

	''' <summary>
	''' IMAP4rev1 [MNX
	''' </summary>
	Class Imap4
        Implements IDisposable
		''' <summary>
		''' wb_̈̃TCYłB
		''' </summary>
		Protected Const HeaderSize As Integer = 32768
		''' <summary>
		''' pX̃TCYłB
		''' </summary>
		Protected Const MaxPath As Integer = 32768
		''' <summary>
		''' \PbgG[͖ڑԂłB
		''' </summary>
		''' <remarks>
		''' <para><see cref="Connect"/>Ăяo<see cref="GetMail"/>A</para>
		''' <para>ĂяoAȂ炩̗RŐڑؒfƂ̃G[ƂȂ܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
		Public Const ErrorSocket As Integer = -1
        ''' <summary>
		''' F؃G[łB
		''' </summary>
		''' <remarks>
		''' <para><see cref="Authenticate"/>ĂяoŔF؂Ɏsꍇ</para>
		''' <para>̃G[ƂȂ܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
		Public Const ErrorAuthenticate As Integer = -2
		''' <summary>
		''' ԍŎw肳ꂽ[݂܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetMail"/>Ŏw肵ԍ̃[݂ȂƂ̃G[ƂȂ܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
		Public Const ErrorInvalidNo As Integer = -3
		''' <summary>
		''' ^CAEgG[łB
		''' </summary>
		''' <remarks>
		''' <para><see cref="Options.Timeout"/>Ŏw肵l蒷ԃT[o牞</para>
		''' <para>ȂꍇÃG[܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
		Public Const ErrorTimeout As Integer = -4
		''' <summary>
		''' Ytt@CJ܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="Path"/>Ŏw肵tH_ɓYtt@C߂Ȃ</para>
		''' <para>ȂꍇÃG[܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
		Public Const ErrorFileOpen As Integer = -5
		''' <summary>
		''' Ytt@CƓ̃t@CtH_ɑ݂܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="nMail.Options.AlreadyFile"/>  <see cref="nMail.Options.FileAlreadyError"/></para>
		''' <para>ݒ肵A<see cref="Path"/>Ŏw肵tH_ɓYtt@CƓÕt@C</para>
		''' <para>ꍇɂ̃G[܂B</para>
		''' <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		''' </remarks>
		Public Const ErrorFileAlready As Integer = -7
		''' <summary>
		''' T[ow肵F،`ɑΉĂ܂B
		''' </summary>
		Public Const ErrorAuthenticateNoSupport As Integer = -8
		''' <summary>
		''' mۃG[łB
		''' </summary>
		''' <remarks>
		''' ŕR[hϊ邽߂̃mۂł܂łB
		''' </remarks>
		Public Const ErrorMemory As Integer = -9
		''' <summary>
		''' ̑̃G[łB
		''' </summary>
		Public Const ErrorEtc As Integer = -10
		''' <summary>
		''' p[^܂B
		''' </summary>
		''' <remarks>
		''' p[^܂B
		''' </remarks>
		Public Const ErrorInvalidParameter As Integer = -11
		''' <summary>
		''' IMAP4 T[oG[ NO
		''' </summary>
		''' <remarks>
		''' IMAP4 T[o NO Ԃ܂B
		''' </remarks>
		Public Const ErrorResponseNo As Integer = -12
		''' <summary>
		''' IMAP4 T[oG[ BAD
		''' </summary>
		''' <remarks>
		''' IMAP4 T[o Bad Ԃ܂B
		''' </remarks>
		Public Const ErrorResponseBad As Integer = -13
		''' <summary>
		''' OԂ݂܂
		''' </summary>
		Public Const ErrorNoNameSpace As Integer = -14
		''' <summary>
		''' Ytt@CMł܂c肪ԂłB
		''' </summary>
		''' <remarks>
		''' <para><see cref="Flag"/><see cref="SuspendAttachmentFile"/>܂</para>
		''' <para><see cref="SuspendNext"/>w肵<see cref="GetMail"/></para>
		''' <para>ĂяoꍇA܂[̎c肪ꍇA<see cref="nMailException.ErrorCode"/></para>
		''' <para>ɐݒ肳܂B</para>
		''' </remarks>
		Public Const ErrorSuspendAttachmentFile As Integer = -20
		''' <summary>
		''' Y鍀ڂ܂B
		''' </summary>
		''' <remarks>
		''' Y鍀ڂ݂͑܂B
		''' </remarks>
		Public Const ErrorNoResult As Integer = -21
		''' <summary>
		''' F؂ PLAIN gp܂B
		''' </summary>
		Public Const AuthPlain As Integer = 1
		''' <summary>
		''' F؂ LOGIN gp܂B
		''' </summary>
		Public Const AuthLogin As Integer = 2
		''' <summary>
		''' F؂ CRAM MD5 gp܂B
		''' </summary>
		Public Const AuthCramMd5 As Integer = 4
		''' <summary>
		''' F؂ DIGEST MD5 gp܂B
		''' </summary>
		Public Const AuthDigestMd5 As Integer = 8
		''' <summary>
		''' s
		''' </summary>
		''' <para>e탁\bhԂꍇA<see cref="nMailException.ErrorCode"/>ɐݒ肳lłB</para>
		Public Const Success As Integer = 1
		''' <summary>
		''' Ytt@CMňꎞx~̈ڂɎw肵܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		''' </remarks>
		Public Const SuspendAttachmentFile As Integer = 4
		''' <summary>
		''' Ytt@CMňꎞx~̓ڈȍ~Ɏw肵܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		''' </remarks>
		Public Const SuspendNext As Integer = 8
		''' <summary>
		''' [ǉɓtB[h nMail.DLL Ő܂B
		''' </summary>
		Public Const AddDateField As Integer = 1
		''' <summary>
		''' [ǉMessage-ID tB[h nMail.DLL Ő܂B
		''' </summary>
		Public Const AddMessageId As Integer = 2
		''' <summary>
		''' MIME p[gۑň̃pXŃt@Cw肵܂B
		''' </summary>
		Private Const MimeSaveAsFile As Integer = &H0800
		''' <summary>
		''' MIME p[g擾ŊǃtO𗧂Ă܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetMimePart"/>̑OɁA<see cref="MimeFlag"/>ɐݒ肵Ă܂B</para>
		''' </remarks>
		Public Const MimePeek As Integer = &H1000
		''' <summary>
		''' MIME p[g擾ŃfR[h܂B
		''' </summary>
		''' <remarks>
		''' <para><see cref="GetMimePart"/>̑OɁA<see cref="MimeFlag"/>ɐݒ肵Ă܂B</para>
		''' </remarks>
		Public Const MimeNoDecode As Integer = &H2000
		''' <summary>
		''' MIME p[g擾Ńwb_̂ݎ擾܂B
		''' </summary>
		Private Const MimeHeader As Integer = &H4000
		''' <summary>
		''' [ԍł͂Ȃ UID gp܂B
		''' </summary>
		Public Const UseUidValue As Integer = &H8000
		''' <summary>
		''' [{bNXtO@IłȂ[{bNXłB
		''' </summary>
		Public Const MailBoxNoSelect As Integer = 1
		''' <summary>
		''' [{bNXtO@q[{bNX쐬ł܂B
		''' </summary>
		Public Const MailBoxNoInferious As Integer = 2
		''' <summary>
		''' [{bNXtO@bZ[WǉĂ\܂B
		''' </summary>
		Public Const MailBoxMarked As Integer = 4
		''' <summary>
		''' [{bNXtO@bZ[WǉĂ܂B
		''' </summary>
		Public Const MailBoxUnMarked As Integer = 8
		''' <summary>
		''' [{bNXtO@q[{bNX݂܂B
		''' </summary>
		Public Const MailBoxChildren As Integer = 16
		''' <summary>
		''' [{bNXtO@q[{bNX݂܂B
		''' </summary>
		Public Const MailBoxNoChildren As Integer = 32
		''' <summary>
		''' [bZ[WtO@ԐMς݃tOtłB
		''' </summary>
		Public Const MessageAnswerd As Integer = 1
		''' <summary>
		''' [bZ[WtO@}[NtłB
		''' </summary>
		Public Const MessageDeleted As Integer = 2
		''' <summary>
		''' [bZ[WtO@etOtłB
		''' </summary>
		Public Const MessageDraft As Integer = 4
		''' <summary>
		''' [bZ[WtO@dvtOtłB
		''' </summary>
		Public Const MessageFlagged As Integer = 8
		''' <summary>
		''' [bZ[WtO@tOtłB
		''' </summary>
		Public Const MessageRecent As Integer = 16
		''' <summary>
		''' [bZ[WtO@ǃtOtłB
		''' </summary>
		Public Const MessageSeen As Integer = 32
		''' <summary>
		''' [@ԐMς
		''' </summary>
		Public Const SearchAnswered As Integer = 1
		''' <summary>
		''' [@ԐMς݂łȂ
		''' </summary>
		Public Const SearchUnAnswered As Integer = 2
		''' <summary>
		''' [@}[Nt
		''' </summary>
		Public Const SearchDeleted As Integer = 3
		''' <summary>
		''' [@}[NȂ
		''' </summary>
		Public Const SearchUnDeleted As Integer = 4
		''' <summary>
		''' [@etO
		''' </summary>
		Public Const SearchDraft As Integer = 5
		''' <summary>
		''' [@etOȂ
		''' </summary>
		Public Const SearchUnDraft As Integer = 6
		''' <summary>
		''' [@dvtO
		''' </summary>
		Public Const SearchFlagged As Integer = 7
		''' <summary>
		''' [@dvtOȂ
		''' </summary>
		Public Const SearchUnFlagged As Integer = 8
		''' <summary>
		''' [@tO
		''' </summary>
		Public Const SearchRecent As Integer = 9
		''' <summary>
		''' [@tOȂ
		''' </summary>
		Public Const SearchUnRecent As Integer = 10
		''' <summary>
		''' [@ǃtO
		''' </summary>
		Public Const SearchSeen As Integer = 11
		''' <summary>
		''' [@ǃtOȂ
		''' </summary>
		Public Const SearchUnSeen As Integer = 12
		''' <summary>
		''' [@tO肩ǃtOȂ
		''' </summary>
		Public Const SearchNew As Integer = 13
		''' <summary>
		''' [@SẴ[
		''' </summary>
		Public Const SearchAll As Integer = 14
		''' <summary>
		''' [@w肳ꂽL[[h
		''' </summary>
		Public Const SearchKeyword As Integer = 15
		''' <summary>
		''' [@w肳ꂽL[[hȂ
		''' </summary>
		Public Const SearchUnKeyword As Integer = 16
		''' <summary>
		''' [@From wb_Ɏw̕񂠂
		''' </summary>
		Public Const SearchFrom As Integer = 17
		''' <summary>
		''' [@To wb_Ɏw̕񂠂
		''' </summary>
		Public Const SearchTo As Integer = 18
		''' <summary>
		''' [@CC wb_Ɏw̕񂠂
		''' </summary>
		Public Const SearchCc As Integer = 19
		''' <summary>
		''' [@BCC wb_Ɏw̕񂠂
		''' </summary>
		Public Const SearchBcc As Integer = 20
		''' <summary>
		''' [@SUBJECT wb_Ɏw̕񂠂
		''' </summary>
		Public Const SearchSubject As Integer = 21
		''' <summary>
		''' [@DATE wb_w肳ꂽNȑO
		''' </summary>
		Public Const SearchSentBefore As Integer = 22
		''' <summary>
		''' [@DATE wb_w肳ꂽN
		''' </summary>
		Public Const SearchSentOn As Integer = 23
		''' <summary>
		''' [@DATE wb_w肳ꂽNȍ~
		''' </summary>
		Public Const SearchSentSince As Integer = 24
		''' <summary>
		''' [@w肳ꂽNȑOɓ
		''' </summary>
		Public Const SearchBefore As Integer = 25
		''' <summary>
		''' [@w肳ꂽNɓ
		''' </summary>
		Public Const SearchOn As Integer = 26
		''' <summary>
		''' [@w肳ꂽNȍ~ɓ
		''' </summary>
		Public Const SearchSince As Integer = 27
		''' <summary>
		''' [@w肳ꂽwb_tB[hɕ܂ "wb_tB[h "Ǝw肵Ă
		''' </summary>
		Public Const SearchHeader As Integer = 28
		''' <summary>
		''' [@{ɕ܂
		''' </summary>
		Public Const SearchBody As Integer = 29
		''' <summary>
		''' [@wb_і{ɕ܂
		''' </summary>
		Public Const SearchText As Integer = 30
		''' <summary>
		''' [@wTCY傫ȃ[
		''' </summary>
		Public Const SearchLager As Integer = 31
		''' <summary>
		''' [@wTCY菬ȃ[
		''' </summary>
		Public Const SearchSmaller As Integer = 32
		''' <summary>
		''' [@w UID ̃[
		''' </summary>
		Public Const SearchUid As Integer = 33
		''' <summary>
		''' [@𒼐ڎw
		''' </summary>
		Public Const SearchCommand As Integer = &H0100
		''' <summary>
		''' [@ NOT
		''' </summary>
		Public Const SearchNot As Integer = &H0200
		''' <summary>
		''' [@ OR
		''' </summary>
		Public Const SearchOr As Integer = &H0400
		''' <summary>
		''' [@ AND
		''' </summary>
		Public Const SearchAnd As Integer = &H0800
		''' <summary>
		''' [@[N
		''' </summary>
		Public Const SearchFirst As Integer = &H1000
		''' <summary>
		''' [@R}hsシɖ߂
		''' </summary>
		Public Const SearchNoWait As Integer = &H2000
		''' <summary>
		''' [@ʃ`FbN
		''' </summary>
		Public Const SearchCheck As Integer = &H4000
		''' <summary>
		''' lO
		''' </summary>
		Public Const NameSpacePersonal As Integer = 0
		''' <summary>
		''' lO
		''' </summary>
		Public Const NameSpaceOther As Integer = 1
		''' <summary>
		''' LO
		''' </summary>
		Public Const NameSpaceShared As Integer = 2
		''' <summary>
		''' OԐ
		''' </summary>
		Public Const NameSpaceMax As Integer = 3
		''' <summary>
		''' lOԁ@擾
		''' </summary>
		Public Const NameSpacePersonalCount As Integer = &H1000
		''' <summary>
		''' lOԁ@擾
		''' </summary>
		Public Const NameSpaceOtherCount As Integer = &H2000
		''' <summary>
		''' LOԁ@擾
		''' </summary>
		Public Const NameSpaceSharedCount As Integer = &H3000
		''' <summary>
		''' lOԁ@ʎ擾
		''' </summary>
		Public Const NameSpacePersonalNo As Integer = &H0100
		''' <summary>
		''' lOԁ@ʎ擾
		''' </summary>
		Public Const NameSpaceOtherNo As Integer = &H0200
		''' <summary>
		''' LOԁ@ʎ擾
		''' </summary>
		Public Const NameSpaceSharedNo As Integer = &H0300
		''' <summary>
		''' [bZ[WtOǉ܂B
		''' </summary>
		Private Const AddMessage As Integer = 1
		''' <summary>
		''' [bZ[WtO폜܂B
		''' </summary>
		Private Const DeleteMessage As Integer = 2
		''' <summary>
		''' [bZ[WtOu܂B
		''' </summary>
		Private Const ReplaceMessage As Integer = 3
		''' <summary>
		''' [{bNX̑bZ[W擾܂B
		''' </summary>
		Private Const MailBoxMessage As Integer = 1
		''' <summary>
		''' [{bNX̐VbZ[W擾܂B
		''' </summary>
		Private Const MailBoxRecent As Integer = 2
		''' <summary>
		''' [{bNX̐VbZ[W UID 擾܂B
		''' </summary>
		Private Const MailBoxNextUid As Integer = 3
		''' <summary>
		''' [{bNX UID Validity l擾܂B
		''' </summary>
		Private Const MailBoxUidValidity As Integer = 4
		''' <summary>
		''' [{bNX̖ǃbZ[W擾܂B
		''' </summary>
		Private Const MailBoxUnSeen As Integer = 5
		''' <summary>
		''' {fB\ ԍ
		''' </summary>
		Private Const ContentPart As Integer = 0
		''' <summary>
		''' {fB\ Content-Type ^Cv
		''' </summary>
		Private Const ContentType As Integer = 1
		''' <summary>
		''' {fB\ Content-Type Tu^Cv
		''' </summary>
		Private Const ContentSubType As Integer = 2
		''' <summary>
		''' {fB\ Content-Id
		''' </summary>
		Private Const ContentId As Integer = 3
		''' <summary>
		''' {fB\ Content-Description
		''' </summary>
		Private Const ContentDescription As Integer = 4
		''' <summary>
		''' {fB\ Content-Transfer-Encoding
		''' </summary>
		Private Const ContentTransferEncoding As Integer = 5
		''' <summary>
		''' {fB\ t@C
		''' </summary>
		Private Const ContentFileName As Integer = 6
		''' <summary>
		''' {fB\ Content-Type ^CvTu^Cv
		''' </summary>
		Private Const ContentTypeAndSubType As Integer = 7
		''' <summary>
		''' {fB\ {fBTCY
		''' </summary>
		Private Const ContentSize As Integer = 8
		''' <summary>
		''' {fB\ {fBs
		''' </summary>
		Private Const ContentLine As Integer = 9
		''' <summary>
		''' {fB\ Content-Type p[^
		''' </summary>
		Private Const ContentParameterCount As Integer = 10
		''' <summary>
		''' {fB\ Content-Type p[^
		''' </summary>
		Private Const ContentParameter As Integer = 11
		''' <summary>
		''' SMTP 
		''' </summary>
		Private Const MakeDateSmtp As Integer = &H00000
		''' <summary>
		''' IMAP4 
		''' </summary>
		Private Const MakeDateImap4 As Integer = &H10000
		''' <summary>
		''' ݓ
		''' </summary>
		Private Const MakeDateNow As Integer = &H20000
		''' <summary>
		''' ^C][w {
		''' </summary>
		Private Const MakeDateTimeZonePlus As Integer = &H40000
		''' <summary>
		''' ^C][w [
		''' </summary>
		Private Const MakeDateTimeZoneMinus As Integer = &H80000
		''' <summary>
		''' SMTP(RFC2822)擾܂B: "Fri, 9 Jul 2009 15:10:30 +0900
		''' </summary>
		Private Const DateTimeSmtp As Integer = &H0000
		''' <summary>
		''' IMAP4t(RFC2060)擾܂Bp : "09-Jul-2009"
		''' </summary>
		Private Const DateImap4 As Integer = &H8000
		''' <summary>
		''' IMAP4(RFC2060)擾܂BAppendp : "09-Jul-2009 15:10:30"
		''' </summary>
		Private Const DateTimeImap4 As Integer = &H8000
		''' <summary>
		''' ̃obt@TCYłB
		''' </summary>
		Private Const DateStringSize As Integer = 34
		''' <summary>
		''' SSLv3 gp܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const SSL3 As Integer = &H1000
		''' <summary>
		''' TSLv1 gp܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const TLS1 As Integer = &H2000
		''' <summary>
		''' STARTTLS gp܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const STARTTLS As Integer = &H4000
		''' <summary>
		''' T[oؖ؂łG[ɂ܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const IgnoreNotTimeValid As Integer = &H0800
		''' <summary>
		''' [gؖłG[ɂ܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const AllowUnknownCA As Integer = &H0400
		''' <summary>
		''' Common Name vȂĂG[ɂ܂B
		''' </summary>
		''' <remarks>
		''' <see cref="SSL"/>Ŏw肵܂B
		''' </remarks>
		Public Const IgnoreInvalidName As Integer = &H0040
		''' <summary>
		''' IMAP4 ̕W|[gԍł
		''' </summary>
		Public Const StandardPortNo As Integer = 143
		''' <summary>
		''' IMAP4 over SSL ̃|[gԍł
		''' </summary>
		Public Const StandardSslPortNo As Integer = 993

		''' <summary>
		''' IMAP4 |[gԍłB
		''' </summary>
		Protected _port As Integer = 143
		''' <summary>
		''' \PbgnhłB
		''' </summary>
		Protected _socket As IntPtr = IntPtr.op_Explicit(ErrorSocket)
		''' <summary>
		''' [łB
		''' </summary>
		Protected _count As Integer = -1
		''' <summary>
		''' [TCYłB
		''' </summary>
		Protected _size As Integer = -1
		''' <summary>
		''' wb_[TCYłB
		''' </summary>
		Protected _header_size As Integer = -1
		''' <summary>
		''' {̃TCYłB
		''' </summary>
		Protected _body_size As Integer = -1
		''' <summary>
		''' [M̐ݒptOłB
		''' </summary>
		Protected _flag As Integer = 0
		''' <summary>
		''' [bZ[W̃tOłB
		''' </summary>
		Protected _message_flag As Integer = 0
		''' <summary>
		''' [w肷ۂ UID gp܂B
		''' </summary>
		protected _useuid_flag As Boolean = false
		''' <summary>
		''' MIME p[g擾͕ۑ̍ۂ̐ݒtOłB
		''' </summary>
		Protected _mime_flag As Integer = 0
		''' <summary>
		''' [w肷ۂ UID gp܂B
		''' </summary>
		Protected _useuid As Integer = 0
		''' <summary>
		''' G[ԍłB
		''' </summary>
		Protected _err As Integer = 0
		''' <summary>
		''' IMAP4 F،`
		''' </summary>
		Protected _mode As Integer = AuthLogin
		''' <summary>
		''' IMAP4 T[ołB
		''' </summary>
		Protected _host As String = ""
		''' <summary>
		''' IMAP4 [U[łB
		''' </summary>
		Protected _id As String = ""
		''' <summary>
		''' IMAP4 pX[hłB
		''' </summary>
		Protected _password As String = ""
		''' <summary>
		''' [{bNXłB
		''' </summary>
		Protected _mailbox As String = ""
		''' <summary>
		''' Ytt@Cۑp̃pXłB
		''' </summary>
		Protected _path As String = Nothing
		''' <summary>
		''' wb_tB[hłB
		''' </summary>
		Protected _field_name As String = ""
		''' <summary>
		''' {i[obt@łB
		''' </summary>
		Protected _body As StringBuilder = Nothing
		''' <summary>
		''' i[obt@łB
		''' </summary>
		Protected _subject As StringBuilder = Nothing
		''' <summary>
		''' tۑobt@łB
		''' </summary>
		Protected _date As StringBuilder = Nothing
		''' <summary>
		''' oli[obt@łB
		''' </summary>
		Protected _from As StringBuilder = Nothing
		''' <summary>
		''' wb_i[obt@łB
		''' </summary>
		Protected _header As StringBuilder = Nothing
		''' <summary>
		''' Ytt@Ci[obt@łB
		''' </summary>
		Protected _filename As StringBuilder = Nothing
		''' <summary>
		''' Ytt@C̃XgłB
		''' </summary>
		Protected _filename_list As String() = Nothing
		''' <summary>
		''' wb_tB[hei[obt@łB
		''' </summary>
		Protected _field As StringBuilder = Nothing
		''' <summary>
		''' UID łB
		''' </summary>
		Protected _uid As Integer = 0
		''' <summary>
		''' Dispose sǂ̃tOłB
		''' </summary>
		Private _disposed As Boolean = False
		''' <summary>
		''' HTML p[gۑt@C̖OłB
		''' </summary>
		Protected _html_file As StringBuilder = Nothing
		''' <summary>
		''' SSL ݒtOłB
		''' </summary>
		Protected _ssl As Integer = 0
		''' <summary>
		''' SSL NCAgؖłB
		''' </summary>
		Protected _cert_name As String = nothing
		''' <summary>
		''' message/rfc822 p[gۑt@C̖OłB
		''' </summary>
		Protected _rfc822_file As StringBuilder = Nothing

		''' <summary>
		''' [{bNXłB
		''' </summary>
		''' <remarks>
		''' <see cref="GetMailBoxList"/><see cref="GetMailBoxListSubscribe"/>̌ʂi[\̂łB
		''' </remarks>
		Public Structure MailBoxStatus
			''' <summary>
			''' [{bNXtOłB
			''' </summary>
			''' <remarks>
			''' <para><see cref="MailBoxNoSelect"/>IłȂ[{bNXł</para>
			''' <para><see cref="MailBoxNoInferious"/>q[{bNX쐬ł܂</para>
			''' <para><see cref="MailBoxMarked"/>bZ[WǉĂ\܂</para>
			''' <para><see cref="MailBoxUnMarked"/>bZ[WǉĂ܂</para>
			''' <para><see cref="MailBoxChildren"/>q[{bNX݂܂</para>
			''' <para><see cref="MailBoxNoChildren"/>q[{bNX݂܂</para>
			''' </remarks>
			Public Flag As Integer
			''' <summary>
			''' [{bNXłB
			''' </summary>
			Public Name As String
			''' <summary>
			''' [{bNX؂蕶łB
			''' </summary>
			Public Separate As Char
		End Structure
		''' <summary>
		''' [{bNX񃊃XgłB
		''' </summary>
		''' <remarks>
		''' <see cref="GetMailBoxList"/><see cref="GetMailBoxListSubscribe"/>sɌʂi[܂B
		''' </remarks>
		Protected _mailbox_list As MailBoxStatus() = Nothing
		''' <summary>
		''' MIME \ Content-Type tB[h̃p[^łB
		''' </summary>
		''' <remarks>
		''' MIME \ Content-Type tB[h̃p[^łB
		''' MIME \ <see cref="MimeStructureStatus"/> Ɋ܂܂܂B
		''' </remarks>
		Public Structure MimeParameterStatus
			''' <summary>
			''' p[^̂łB
			''' </summary>
			Public Name As String
			''' <summary>
			''' p[^̒lłB
			''' </summary>
			Public Value As String
		End Structure
		''' <summary>
		''' MIME \łB
		''' </summary>
		''' <remarks>
		''' <see cref="GetMimeStructure"/>̌ʂi[\̂łB
		''' </remarks>
		Public Structure MimeStructureStatus
			''' <summary>
			''' MIME p[gԍłB
			''' </summary>
			''' <remarks>
			''' <see cref="GetMimePart"/><see cref="SaveMimePart"/> part_no Ŏw肷lłB
			''' </remarks>
			Public PartNo As Integer
			''' <summary>
			''' MIME \\łB
			''' </summary>
			Public Part As String
			''' <summary>
			''' Content-Type tB[h̃^CvłB
			''' </summary>
			Public Type As String
			''' <summary>
			''' Content-Type tB[h̃Tu^CvłB
			''' </summary>
			Public SubType As String
			''' <summary>
			''' Contetn-ID tB[h̒lłB
			''' </summary>
			Public Id As String
			''' <summary>
			''' Content-Description tB[h̒lłB
			''' </summary>
			Public Description As String
			''' <summary>
			''' Content-Transfer-Encoding tB[h̒lłB
			''' </summary>
			Public Encoding As String
			''' <summary>
			''' Ytt@CłB(fR[hς)
			''' </summary>
			Public FileName As String
			''' <summary>
			''' MIME p[g̃TCYłB
			''' </summary>
			Public Size As Integer
			''' <summary>
			''' MIME p[g̍słB^Cv text ̏ꍇ̂ݐl܂B
			''' </summary>
			Public Line As Integer
			''' <summary>
			''' Content-Type ̃p[^XgłB
			''' </summary>
			Public Parameter As MimeParameterStatus()
		End Structure
		''' <summary>
		''' MIME \񃊃XgłB
		''' </summary>
		''' <remarks>
		''' <see cref="GetMimeStructure"/>sɌʂi[܂B
		''' </remarks>
		Protected _mime_list As MimeStructureStatus() = Nothing
		''' <summary>
		''' ʂ̃XgłB
		''' </summary>
		''' <remarks>
		''' <see cref="Search"/>sɌʂi[܂B
		''' </remarks>
		Protected _search_list As Integer() = Nothing
		''' <summary>
		''' ŏ̌ǂ̃tOłB
		''' </summary>
		Protected _search_first_flag As Boolean = true
		''' <summary>
		''' OԏłB
		''' </summary>
		''' <remarks>
		''' <see cref="GetNameSpace"/>̌ʂi[\̂łB
		''' </remarks>
		Public Structure NameSpaceStatus
			''' <summary>
			''' OԂ̖̂łB
			''' </summary>
			Public Name As String
			''' <summary>
			''' OԂ̋؂蕶łB
			''' </summary>
			Public Separate As Char
		End Structure
		''' <summary>
		''' Oԏ񃊃XgłB
		''' </summary>
		''' <remarks>
		''' <see cref="GetNameSpace"/>sɌʂi[܂B
		''' </remarks>
        Protected _namespace_list As NameSpaceStatus()() = New NameSpaceStatus(NameSpaceMax)() {}

		''' <summary>
		''' <c>Imap4</c>NX̐VKCX^X܂B
		''' </summary>
        Public Sub New()
            Init()
        End Sub

		''' <summary>
		''' <c>Imap4</c>NX̐VKCX^X܂B
		''' <param name="host_name">POP3 T[o[</param>
		''' </summary>
        Public Sub New(ByVal host As String)
            Init()
            _host = host
        End Sub

        Protected Overrides Sub Finalize()
            MyBase.Finalize()
            Dispose(False)
        End Sub

		''' <summary>
		''' <see cref="Imap4"/>ɂĎgpĂ邷ׂẴ\[X܂B
		''' </summary>
        Overridable Overloads Sub Dispose() Implements IDisposable.Dispose
            Dispose(True)
            GC.SuppressFinalize(Me)
        End Sub

		''' <summary>
		''' <see cref="Imap4"/>ɂĎgpĂ邷ׂẴ\[X܂B
		''' </summary>
		''' <param name="disposing">
		''' }l[W\[XƃA}l[W\[X̗ꍇ<c>true</c>B
		''' A}l[W\[Xꍇ<c>false</c>B
		''' </param>
        Protected Overloads Sub Dispose(ByVal disposing As Boolean)
            If Not _disposed Then
                If disposing Then
                End If
                If not _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                    Imap4Close(_socket)
                    _socket = IntPtr.op_Explicit(ErrorSocket)
                End If
                _disposed = True
            End If
        End Sub

        ''' <summary>
		''' łB
		''' </summary>
		Protected Sub Init()
		End Sub

        <DllImport("nMail.DLL", EntryPoint:="NMailGetSuspendNumber", CharSet:=CharSet.Auto)> _
        Public Shared Function GetSuspendNumber(ByVal Path As String) As Integer
        End Function

		<DllImport("nMail.DLL", EntryPoint:="NMailImap4ConnectPortNo", CharSet:=CharSet.Auto)> _
		Protected Shared Function Imap4ConnectPortNo(ByVal Host As String, ByVal Port As Integer) As IntPtr
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4ConnectSsl", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4ConnectSsl(ByVal Host As String, ByVal Port As Integer, ByVal Flag As Integer, ByVal Name As String) As IntPtr
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4Close")> _
        Protected Shared Function Imap4Close(ByVal Socket As IntPtr) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4Authenticate", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4Authenticate(ByVal Socket As IntPtr, ByVal Id As String, ByVal Pass As String, ByVal Mode As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4SelectMailBox", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4SelectMailBox(ByVal Socket As IntPtr, ByVal MailBox As String, ByVal ReadOnlyFlag As Boolean) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetMailStatus", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4GetMailStatus(ByVal Socket As IntPtr, ByVal MailNo As Integer, ByVal Subject As StringBuilder, ByVal DateString As StringBuilder, ByVal From As StringBuilder, ByVal Header As StringBuilder, ByRef MessageFlag As Integer, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetMailSize")> _
        Protected Shared Function Imap4GetMailSize(ByVal Socket As IntPtr, ByVal MailNo As Integer, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetMail", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4GetMail(ByVal Socket As IntPtr, ByVal MailNo As Integer, ByVal Subject As StringBuilder, ByVal DateString As StringBuilder, ByVal From As StringBuilder, ByVal Header As StringBuilder, ByVal Body As StringBuilder, ByVal Path As String, ByVal FileName As StringBuilder, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetMailBoxList", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4GetMailBoxList(ByVal Socket As IntPtr, ByVal Refer As String, ByVal MailBox As String, ByVal SubscribeFlag As Boolean) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetMailBoxListStatus", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4GetMailBoxListStatus(ByVal Socket As IntPtr, ByVal No As Integer, ByRef MailBoxFlag As Integer, ByVal Separate As StringBuilder, ByVal MailBox As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4DeleteMail")> _
        Protected Shared Function Imap4DeleteMail(ByVal Socket As IntPtr, ByVal MailNo As Integer, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4ChangeMessageFlag")> _
        Protected Shared Function Imap4ChangeMessageFlag(ByVal Socket As IntPtr, ByVal MailNo As Integer, ByVal MessageFlag As Integer, ByVal Command As Integer, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4ExpungeMail")> _
        Protected Shared Function Imap4ExpungeMail(ByVal Socket As IntPtr) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4CloseMailBox")> _
        Protected Shared Function Imap4CloseMailBox(ByVal Socket As IntPtr) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4CreateMailBox", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4CreateMailBox(ByVal Socket As IntPtr, ByVal MailBox As String) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4DeleteMailBox", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4DeleteMailBox(ByVal Socket As IntPtr, ByVal MailBox As String) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4RenameMailBox", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4RenameMailBox(ByVal Socket As IntPtr, ByVal OldMailBox As String, ByVal NewMailBox As String) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4SubscribeMailBox", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4SubscribeMailBox(ByVal Socket As IntPtr, ByVal MailBox As String) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4UnsubscribeMailBox", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4UnsubscribeMailBox(ByVal Socket As IntPtr, ByVal MailBox As String) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetMailBoxStatus", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4GetMailBoxStatus(ByVal Socket As IntPtr, ByVal MailBox As String, ByVal type As Integer, ByRef Data As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4CopyMail", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4CopyMail(ByVal Socket As IntPtr, ByVal MailNo As Integer, ByVal MailBox As String, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetUid", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4GetUid(ByVal Socket As IntPtr, ByVal MailNo As Integer, ByRef Uid As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4SearchMail", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4SearchMail(ByVal Socket As IntPtr, ByVal Type As Integer, ByVal Text As String, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetSearchMailResult", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4GetSearchMailResult(ByVal Socket As IntPtr, ByVal No As Integer, ByRef MailNo As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4AppendMail", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4AppendMail(ByVal Socket As IntPtr, ByVal MailBox As String, ByVal Header As String, ByVal Body As String, ByVal Path As String, ByVal MessageFlag As Integer, ByVal DateString As String, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailMakeDateString", CharSet:=CharSet.Auto)> _
        Protected Shared Function MakeDateString(ByVal DateString As StringBuilder, ByVal Year As Integer, ByVal Month As Integer, ByVal Day As Integer, ByVal Hour As Integer, ByVal Minute As Integer, ByVal Second As Integer, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetNameSpace")> _
        Protected Shared Function Imap4GetNameSpace(ByVal Socket As IntPtr) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetNameSpaceStatus", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4GetNameSpaceStatus(ByVal Socket As IntPtr, ByVal Type As Integer, ByVal Separate As StringBuilder, ByVal Name As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetMimeStructure")> _
        Protected Shared Function Imap4GetMimeStructure(ByVal Socket As IntPtr, ByVal MailNo As Integer, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetMimeStructureStatus", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4GetMimeStructureStatus(ByVal Socket As IntPtr, ByVal Type As Integer, ByVal PartNo As Integer, ByVal SubNo As Integer, ByVal Name As StringBuilder, ByVal Value As StringBuilder, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4GetMimePart", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4GetMimePart(ByVal Socket As IntPtr, ByVal MailNo As Integer, ByVal PartNo As Integer, ByVal Body As StringBuilder, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4SaveMimePart", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4SaveMimePart(ByVal Socket As IntPtr, ByVal MailNo As Integer, ByVal PartNo As Integer, ByVal Path As String, ByVal FileName As StringBuilder, ByVal Flag As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailImap4NoOperation")> _
        Protected Shared Function Imap4NoOperation(ByVal Socket As IntPtr) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailGetHeaderField", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4GetHeaderField(ByVal Field As StringBuilder, ByVal Header As String, ByVal Name As String, ByVal Size As Integer) As Integer
        End Function

        <DllImport("nMail.DLL", EntryPoint:="NMailDecodeHeaderField", CharSet:=CharSet.Auto)> _
        Protected Shared Function Imap4DecodeHeaderField(ByVal Destination As StringBuilder, ByVal Source As String, ByVal Size As Integer) As Integer
        End Function

        ''' <summary>
        ''' wb_i[pobt@̃TCY肵܂B
        ''' </summary>
        Protected Sub SetHeaderSize()
            If _header_size < 0 Then
                _header_size = Options.HeaderMax
            End If
            If _header_size <= 0 Then
                _header_size = HeaderSize
                Options.HeaderMax = _header_size
            End If
        End Sub
        ''' <summary>
        ''' T[oɐڑ肷
        ''' </summary>
        ''' <returns>true ŃT[oɐڑ</returns>
        Public Function IsConnected() As Boolean
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Return False
            Else
                Return True
            End If
        End Function
        ''' <summary>
        ''' IMAP4 T[oɐڑ܂B
        ''' </summary>
        ''' <remarks>
        ''' IMAP4 T[oɐڑ܂B
        ''' </remarks>
        '''	<exception cref="ArgumentOutOfRangeException">
        '''	|[gԍ܂B
        ''' </exception>
        '''	<exception cref="nMailException">
        '''	IMAP4 T[o[Ƃ̐ڑɎs܂B
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub Connect()
            If (_port < 0) Or (_port > 65536) Then
                Throw New ArgumentOutOfRangeException
            End If
            _socket = Imap4ConnectSsl(_host, _port, _ssl, _cert_name)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                _err = ErrorSocket
                _socket = IntPtr.op_Explicit(ErrorSocket)
                Throw New nMailException("Connect", _err)
            End If
        End Sub
        ''' <summary>
        ''' IMAP4 T[oɐڑ܂B
        ''' </summary>
        ''' <param name="host_name">IMAP4 T[o[</param>
        ''' <remarks>
        ''' T[ow肵 IMAP4 T[oɐڑ܂B
        ''' </remarks>
        '''	<exception cref="ArgumentOutOfRangeException">
        '''	|[gԍ܂B
        ''' </exception>
        '''	<exception cref="nMailException">
        '''	IMAP4 T[oƂ̐ڑɎs܂B
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub Connect(ByVal host_name As String)
            _host = host_name
            Connect()
        End Sub
        ''' <summary>
        ''' IMAP4 T[oɐڑ܂B
        ''' </summary>
        ''' <param name="host_name">IMAP4 T[o</param>
        ''' <param name="port_no">|[gԍ</param>
        ''' <remarks>
        ''' T[oƃ|[gԍw肵 IMAP4 T[oɐڑ܂B
        ''' </remarks>
        '''	<exception cref="ArgumentOutOfRangeException">
        '''	|[gԍ܂B
        ''' </exception>
        '''	<exception cref="nMailException">
        '''	IMAP4 T[oƂ̐ڑɎs܂B
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub Connect(ByVal host_name As String, ByVal port_no As Integer)
            _host = host_name
            _port = port_no
            Connect()
        End Sub
        ''' <summary>
        ''' IMAP4 T[oɐڑ܂B
        ''' </summary>
        ''' <param name="port_no">|[gԍ</param>
        ''' <remarks>
        ''' |[gԍw肵 IMAP4 T[oɐڑ܂B
        ''' </remarks>
        '''	<exception cref="ArgumentOutOfRangeException">
        '''	|[gԍ܂B
        ''' </exception>
        '''	<exception cref="nMailException">
        '''	IMAP4 T[oƂ̐ڑɎs܂B
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub Connect(ByVal port_no As Integer)
            _port = port_no
            Connect()
        End Sub
        ''' <summary>
        ''' IMAP4 T[oƂ̐ڑI܂B
        ''' </summary>
        Public Sub Close()
            If Not _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Imap4Close(_socket)
            End If
            _socket = IntPtr.op_Explicit(ErrorSocket)
        End Sub
        ''' <summary>
        ''' IMAP4 T[oF؂s܂B
        ''' </summary>
        ''' <remarks>
        ''' ID ƃpX[hw肵 IMAP4 T[oF؂s܂B
        ''' </remarks>
        ''' <param name="id_str">IMAP4 [U[ ID</param>
        ''' <param name="pass_str">IMAP4 pX[h</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="FormatException">
        '''	ID ̓pX[hɕ񂪓Ă܂B
        ''' </exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub Authenticate(ByVal id_str As String, ByVal pass_str As String)
            If (id_str = "") Or (pass_str = "") Then
                Throw New FormatException
            End If
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _id = id_str
            _password = pass_str
            _body_size = -1
            _count = Imap4Authenticate(_socket, _id, _password, _mode)
            If _count < 0 Then
                _err = _count
                Throw New nMailException("Authenticate: " + Options.ErrorMessage, _err)
            End If
        End Sub
        ''' <summary>
        ''' IMAP4 T[oF؂s܂B
        ''' </summary>
        ''' <remarks>
        ''' IDApX[hєF،`w肵 IMAP4 T[oF؂s܂B
        ''' </remarks>
        ''' <param name="id_str">IMAP4 [U[ ID</param>
        ''' <param name="pass_str">IMAP4 pX[h</param>
        ''' <param name="mode">F،`
        ''' <para>F،`̐ݒ\Ȓl͉L̒ʂłB</para>
        ''' <para><see cref="AuthLogin"/>  LOGIN gp܂B</para>
        ''' <para><see cref="AuthPlain"/>  PLAIN gp܂B</para>
        ''' <para><see cref="AuthCramMd5"/> CRAM MD5 gp܂B</para>
        ''' <para><see cref="AuthDigestMd5"/> DIGEST MD5 gp܂B</para>
        ''' <para>C#  | AVB.NET ł Or ŕw\łB</para>
        ''' <para>DIGEST MD5CRAM MD5PLAINLOGIN ̗D揇ʂŔF؂݂܂B</para>
        ''' </param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="FormatException">
        '''	ID ̓pX[hɕ񂪓Ă܂B
        ''' </exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub Authenticate(ByVal id_str As String, ByVal pass_str As String, ByVal mode As Integer)
            _mode = mode
            Authenticate(id_str, pass_str)
        End Sub

        ''' <summary>
        ''' wǍς݃[{bNẌꗗ擾܂B
        ''' </summary>
        ''' <param name="refer">KwʒułB</param>
        ''' <param name="mailbox">ChJ[hłB"*" őSāA"%" œKw̃[{bNX܂B</param>
        ''' <remarks>
        ''' wǍς݃[{bNẌꗗ擾܂Bꗗ<see cref="GetMailBoxList"/> Ŏ擾ł܂BB
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub GetMailBoxListSubscribe(ByVal refer As String, ByVal mailbox As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4GetMailBoxList(_socket, refer, mailbox, True)
            If _err < 0 Then
                _mailbox_list = New MailBoxStatus() {}
                Throw New nMailException("GetMailBoxListSubscribe: " + Options.ErrorMessage, _err)
            Else
                Dim no As Integer
                SetHeaderSize()
                _mailbox_list = New MailBoxStatus(_err - 1) {}
                For no = 0 To _err - 1
                    Dim separate As StringBuilder = New StringBuilder(_header_size)
                    Dim name As StringBuilder = New StringBuilder(_header_size)
                    Imap4GetMailBoxListStatus(_socket, no, _mailbox_list(no).Flag, separate, name, _header_size)
                    _mailbox_list(no).Name = name.ToString()
                    _mailbox_list(no).Separate = separate(0)
                Next no
            End If
        End Sub
        ''' <summary>
        ''' [{bNẌꗗ擾܂B
        ''' </summary>
        ''' <remarks>
        ''' [{bNẌꗗ擾܂Bꗗ<see cref="GetMailBoxList"/> Ŏ擾ł܂B
        ''' </remarks>
        ''' <param name="refer">KwʒułB</param>
        ''' <param name="mailbox">ChJ[hłB"*" őSāA"%" œKw̃[{bNX܂B</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub GetMailBoxList(ByVal refer As String, ByVal mailbox As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4GetMailBoxList(_socket, refer, mailbox, False)
            If _err < 0 Then
                _mailbox_list = New MailBoxStatus() {}
                Throw New nMailException("GetMailBoxList: " + Options.ErrorMessage, _err)
            Else
                Dim no As Integer
                SetHeaderSize()
                _mailbox_list = New MailBoxStatus(_err - 1) {}
                For no = 0 To _err - 1
                    Dim separate As StringBuilder = New StringBuilder(_header_size)
                    Dim name As StringBuilder = New StringBuilder(_header_size)
                    Imap4GetMailBoxListStatus(_socket, no, _mailbox_list(no).Flag, separate, name, _header_size)
                    _mailbox_list(no).Name = name.ToString()
                    _mailbox_list(no).Separate = separate(0)
                Next no
            End If
        End Sub
        ''' <summary>
        ''' [{bNX̃bZ[W擾܂B
        ''' </summary>
        ''' <remarks>
        ''' <paramref name="mailbox"/>p[^ŃbZ[W擾[{bNXw肵܂B
        ''' </remarks>
        ''' <param name="mailbox">bZ[W擾[{bNXłB</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        ''' <returns>bZ[W</returns>
        Public Function GetMailBoxMessageCount(ByVal mailbox As String) As Integer
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            Dim data As Integer = 0
            _err = Imap4GetMailBoxStatus(_socket, mailbox, MailBoxMessage, data)
            If _err < 0 Then
                Throw New nMailException("GetMailBoxMessageCount: " + Options.ErrorMessage, _err)
            End If
            Return data
        End Function
        ''' <summary>
        ''' [{bNX̐VbZ[W擾܂B
        ''' </summary>
        ''' <remarks>
        ''' <paramref name="mailbox"/>p[^ŐVbZ[W擾[{bNXw肵܂B
        ''' </remarks>
        ''' <param name="mailbox">VbZ[W擾[{bNXłB</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        ''' <returns>VbZ[W</returns>
        Public Function GetMailBoxRecentCount(ByVal mailbox As String) As Integer
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            Dim data As Integer = 0
            _err = Imap4GetMailBoxStatus(_socket, mailbox, MailBoxRecent, data)
            If _err < 0 Then
                Throw New nMailException("GetMailBoxRecentCount: " + Options.ErrorMessage, _err)
            End If
            Return data
        End Function
        ''' <summary>
        ''' [{bNX̐VbZ[W UID 擾܂B
        ''' </summary>
        ''' <remarks>
        ''' <paramref name="mailbox"/>p[^ŐVbZ[W UID l擾[{bNXw肵܂B
        ''' </remarks>
        ''' <param name="mailbox">VbZ[W UID l擾[{bNXłB</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        ''' <returns>VbZ[W UID</returns>
        Public Function GetMailBoxNextUid(ByVal mailbox As String) As Integer
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            Dim data As Integer = 0
            _err = Imap4GetMailBoxStatus(_socket, mailbox, MailBoxNextUid, data)
            If _err < 0 Then
                Throw New nMailException("GetMailBoxNextUid: " + Options.ErrorMessage, _err)
            End If
            Return data
        End Function
        ''' <summary>
        ''' [{bNX UID Validity l擾܂B
        ''' </summary>
        ''' <remarks>
        ''' <paramref name="mailbox"/>p[^ UID Validity l擾[{bNXw肵܂B
        ''' </remarks>
        ''' <param name="mailbox">UID Validity l擾[{bNXłB</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        ''' <returns>[{bNX UID Validity</returns>
        Public Function GetMailBoxUidValidity(ByVal mailbox As String) As Integer
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            Dim data As Integer = 0
            _err = Imap4GetMailBoxStatus(_socket, mailbox, MailBoxUidValidity, data)
            If _err < 0 Then
                Throw New nMailException("GetMailBoxUidValidity: " + Options.ErrorMessage, _err)
            End If
            Return data
        End Function
        ''' <summary>
        ''' [{bNX̖ǃbZ[W擾܂B
        ''' </summary>
        ''' <remarks>
        ''' <paramref name="mailbox"/>p[^ŖǃbZ[W擾[{bNXw肵܂B
        ''' </remarks>
        ''' <param name="mailbox">ǃbZ[W擾[{bNXłB</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        ''' <returns>ǃbZ[W</returns>
        Public Function GetMailBoxUnSeen(ByVal mailbox As String) As Integer
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            Dim data As Integer = 0
            _err = Imap4GetMailBoxStatus(_socket, mailbox, MailBoxUnSeen, data)
            If _err < 0 Then
                Throw New nMailException("GetMailBoxUnSeen: " + Options.ErrorMessage, _err)
            End If
            Return data
        End Function

        ''' <summary>
        ''' [{bNXI܂B
        ''' </summary>
        ''' <remarks>
        ''' <paramref name="mailbox"/>p[^őI[{bNXw肵܂B
        ''' </remarks>
        ''' <param name="mailbox">I郁[{bNXłB</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub SelectMailBox(ByVal mailbox As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _mailbox = mailbox
            _err = Imap4SelectMailBox(_socket, _mailbox, False)
            If _err < 0 Then
                Throw New nMailException("SelectMailBox: " + Options.ErrorMessage, _err)
            Else
                _count = _err
            End If
        End Sub
        ''' <summary>
        ''' [{bNXǂݏopőI܂B
        ''' </summary>
        ''' <remarks>
        ''' <paramref name="mailbox"/>p[^œǂݏopőI[{bNXw肵܂B
        ''' </remarks>
        ''' <param name="mailbox">I郁[{bNXłB</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub SelectMailBoxReadOnly(ByVal mailbox As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _mailbox = mailbox
            _err = Imap4SelectMailBox(_socket, _mailbox, True)
            If _err < 0 Then
                Throw New nMailException("SelectMailBoxReadOnly: " + Options.ErrorMessage, _err)
            Else
                _count = _err
            End If
        End Sub

        ''' <summary>
        ''' [̃Xe[^X擾܂B
        ''' </summary>
        ''' <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <remarks>
        ''' <paramref name="no"/>p[^ŃXe[^X擾[ԍw肵܂B
        ''' <para><see cref="Subject"/>Ŏ擾ł܂B</para>
        ''' <para>t<see cref="DateString"/>Ŏ擾ł܂B</para>
        ''' <para>ol<see cref="From"/>Ŏ擾ł܂B</para>
        ''' <para>wb_<see cref="Header"/>Ŏ擾ł܂B</para>
        ''' <para>bZ[WtO<see cref="MessageFlag"/>Ŏ擾ł܂B</para>
        ''' <para>Xe[^X擾s̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub GetStatus(ByVal no As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            SetHeaderSize()
            _subject = New StringBuilder(_header_size)
            _date = New StringBuilder(_header_size)
            _from = New StringBuilder(_header_size)
            _header = New StringBuilder(_header_size)
            _err = Imap4GetMailStatus(_socket, no, _subject, _date, _from, _header, _message_flag, _useuid)
            If _err < 0 Then
                Throw New nMailException("GetStatus: " + Options.ErrorMessage, _err)
            Else
                _size = _err
                _body_size = _size * 2
            End If
        End Sub
        ''' <summary>
        ''' [̃TCY擾܂B
        ''' </summary>
        ''' <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <remarks>
        ''' <paramref name="no"/>p[^Ń[TCY擾[ԍw肵܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        ''' <exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        ''' <returns>[TCY</returns>
        Public Function GetSize(ByVal no As Integer) As Integer
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _size = Imap4GetMailSize(_socket, no, _useuid)
            If _size < 0 Then
                _err = _size
                Throw New nMailException("GetSize: " + Options.ErrorMessage, _err)
            Else
                _body_size = _size * 2
            End If
            Return _size
        End Function

        ''' <summary>
        ''' [擾܂B
        ''' </summary>
        ''' <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <remarks>
        ''' <paramref name="no"/>p[^Ń[擾[ԍw肵܂B
        ''' <para>Ytt@CۑꍇA<see cref="Path"/>ɕۑtH_w肵Ă܂B</para>
        ''' <para>g@\gpꍇA<see cref="Flag"/>Őݒ肵Ă܂B</para>
        ''' <para><see cref="Subject"/>Ŏ擾ł܂B</para>
        ''' <para>t<see cref="DateString"/>Ŏ擾ł܂B</para>
        ''' <para>ol<see cref="From"/>Ŏ擾ł܂B</para>
        ''' <para>wb_<see cref="Header"/>Ŏ擾ł܂B</para>
        ''' <para>[TCY<see cref="Size"/>Ŏ擾ł܂B</para>
        ''' <para>Ytt@C<see cref="FileName"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        ''' <exception cref="DirectoryNotFoundException">
        '''	<see cref="Path"/>Ŏw肵tH_݂܂B
        ''' </exception>
        ''' <exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub GetMail(ByVal no As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            If Not _path Is Nothing Then
                If (_path <> "") And (Not Directory.Exists(_path)) Then
                    Throw New DirectoryNotFoundException(_path)
                End If
            End If
            If (_flag And SuspendNext) <> 0 Then
                _err = Imap4GetMail(_socket, no, _subject, _date, _from, _header, _body, _path, _filename, _flag Or _useuid)
            Else
                SetHeaderSize()
                _subject = New StringBuilder(_header_size)
                _date = New StringBuilder(_header_size)
                _from = New StringBuilder(_header_size)
                _header = New StringBuilder(_header_size)
                Options.FileNameMax = MaxPath
                _filename = New StringBuilder(MaxPath)
                If _body_size < 0 Then
                    GetSize(no)
                End If
                If _body_size > 0 Then
                    _body = New StringBuilder(_body_size)
                    If _flag <> 0 Then
                        _err = Imap4GetMail(_socket, no, _subject, _date, _from, _header, _body, _path, _filename, _flag Or _useuid)
                    Else
                        _err = Imap4GetMail(_socket, no, _subject, _date, _from, _header, _body, _path, _filename, _flag Or _useuid)
                    End If
                End If
                If _err <> ErrorSuspendAttachmentFile Then
                    _body_size = -1
                    If _filename.Length > 0 Then
                        _filename_list = _filename.ToString().Split(Options.SplitChar)
                    Else
                        _filename_list = Nothing
                    End If
                    If Options.SaveHtmlFile = Options.SaveHtmlFileOn Then
                        GetHeaderField("X-NMAIL-HTML-FILE:")
                        _html_file = _field
                    End If
                    If Options.SaveRfc822File <> Options.SaveRfc822FileOff Then
                        GetHeaderField("X-NMAIL-RFC822-FILE:")
                        _rfc822_file = _field
                    End If
                End If
                If (_err < 0) And (_err <> ErrorSuspendAttachmentFile) Then
                    Throw New nMailException("GetMail: " + Options.ErrorMessage, _err)
                End If
            End If
        End Sub
        ''' <summary>
        ''' [̍폜}[Nt܂B
        '''	ۂ̍폜<see cref="Expunge"/>\bhĂяoۂɍs܂B
        ''' </summary>
        ''' <param name="no">폜}[Nt郁[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        ''' <exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub Delete(ByVal no As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4DeleteMail(_socket, no, _useuid)
            If _err < 0 Then
                Throw New nMailException("Delete: " + Options.ErrorMessage, _err)
            End If
        End Sub
        ''' <summary>
        ''' 폜}[N̂Ă郁[폜܂B
        ''' </summary>
        ''' <remarks>
        ''' <para>폜}[N̂Ă郁[폜܂B</para>
        ''' <para>[폜s̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        ''' <exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub Expunge()
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4ExpungeMail(_socket)
            If _err < 0 Then
                Throw New nMailException("Expunge: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [{bNX̑II܂B
        ''' </summary>
        ''' <remarks>
        ''' <para>[{bNX̑II܂B</para>
        ''' <para>[{bNX̑IIs̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        ''' <exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub CloseMailBox()
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4CloseMailBox(_socket)
            If _err < 0 Then
                Throw New nMailException("CloseMailBox: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [bZ[WtOt܂B
        ''' </summary>
        ''' <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <param name="message_flag">bZ[WtO
        ''' <para><see cref="MessageAnswerd"/>ԐMς݃tO</para>
        ''' <para><see cref="MessageDeleted"/>}[N</para>
        ''' <para><see cref="MessageDraft"/>etO</para>
        ''' <para><see cref="MessageFlagged"/>dvtO</para>
        ''' <para><see cref="MessageRecent"/>tO</para>
        ''' <para><see cref="MessageSeen"/>ǃtO</para>
        ''' <para>C#  | AVB.NET ł Or ŕw\łB</para>
        '''	</param>
        ''' <remarks>
        ''' w肵bZ[WtOt܂Bw肵ĂȂtȌԂ͂̂܂܂łB
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        ''' <exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub AddMessageFlag(ByVal no As Integer, ByVal message_flag As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4ChangeMessageFlag(_socket, no, message_flag, AddMessage, _useuid)
            If _err < 0 Then
                Throw New nMailException("AddMessageFlag: " + Options.ErrorMessage, _err)
            End If
        End Sub
        ''' <summary>
        ''' [bZ[WtO폜܂B
        ''' </summary>
        ''' <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <param name="message_flag">bZ[WtO
        ''' <para><see cref="MessageAnswerd"/>ԐMς݃tO</para>
        ''' <para><see cref="MessageDeleted"/>}[N</para>
        ''' <para><see cref="MessageDraft"/>etO</para>
        ''' <para><see cref="MessageFlagged"/>dvtO</para>
        ''' <para><see cref="MessageRecent"/>tO</para>
        ''' <para><see cref="MessageSeen"/>ǃtO</para>
        ''' <para>C#  | AVB.NET ł Or ŕw\łB</para>
        '''	</param>
        ''' <remarks>
        ''' w肵bZ[WtO폜܂Bw肵ĂȂtȌԂ͂̂܂܂łB
        ''' <para>[bZ[WtOts̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        ''' <exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub DeleteMessageFlag(ByVal no As Integer, ByVal message_flag As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4ChangeMessageFlag(_socket, no, message_flag, DeleteMessage, _useuid)
            If _err < 0 Then
                Throw New nMailException("DeleteMessageFlag: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [bZ[WtOu܂B
        ''' </summary>
        ''' <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <param name="message_flag">bZ[WtO
        ''' <para><see cref="MessageAnswerd"/>ԐMς݃tO</para>
        ''' <para><see cref="MessageDeleted"/>}[N</para>
        ''' <para><see cref="MessageDraft"/>etO</para>
        ''' <para><see cref="MessageFlagged"/>dvtO</para>
        ''' <para><see cref="MessageRecent"/>tO</para>
        ''' <para><see cref="MessageSeen"/>ǃtO</para>
        ''' <para>C#  | AVB.NET ł Or ŕw\łB</para>
        '''	</param>
        ''' <remarks>
        ''' w肵bZ[WtOŒu܂B
        ''' <para>[bZ[WtOus̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        ''' <exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub ReplaceMessageFlag(ByVal no As Integer, ByVal message_flag As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4ChangeMessageFlag(_socket, no, message_flag, ReplaceMessage, _useuid)
            If _err < 0 Then
                Throw New nMailException("ReplaceMessageFlag: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' Ytt@C̑݃`FbNs܂B
        ''' </summary>
        ''' <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <remarks>
        '''	Ă郁[ɂĂ͈xMAAttachment NXŌĂB
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        ''' <returns>true œYtt@C</returns>
        Public Function GetAttachmentFileStatus(ByVal no As Integer) As Boolean
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            SetHeaderSize()
            _err = Imap4GetMimeStructure(_socket, no, _useuid)
            If _err < 0 Then
                Throw New nMailException("GetAttachmentFileStatus: " + Options.ErrorMessage, _err)
            Else
                If _err > 1 Then
                    Return True
                Else
                    Return False
                End If
            End If
        End Function

        ''' <summary>
        ''' [ UID 擾܂B
        ''' </summary>
        ''' <param name="no">[ԍ</param>
        ''' <remarks>
        ''' <para>擾 UID ͕Ԓl <see cref="Uid"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        ''' <exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        ''' <returns>[ UID</returns>
        Public Function GetUid(ByVal no As Integer) As Integer
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            SetHeaderSize()
            _err = Imap4GetUid(_socket, no, _uid)
            If _err < 0 Then
                Throw New nMailException("GetUid: " + Options.ErrorMessage, _err)
            End If
            Return _uid
        End Function
        ''' <summary>
        ''' [wb_w̃tB[h̓e擾܂B
        ''' </summary>
        ''' <param name="field_name">tB[h</param>
        ''' <returns>tB[h̓e</returns>
        ''' <remarks>
        ''' IMAP4 T[oƂ̐ڑƂ͖֌WɎgpł܂B
        ''' <para>wb_́A<see cref="Header"/>Őݒ肵Ă܂B
        ''' <see cref="GetMail"/>ŎMɌĂяoꍇA
        ''' M[̃wb_gp܂B</para>
        ''' <para>擾tB[he<see cref="Field"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        ''' <exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Function GetHeaderField(ByVal field_name As String) As String
            _field_name = field_name
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            _err = Imap4GetHeaderField(_field, _header.ToString(), _field_name, _header_size)
            If _err < 0 Then
                Throw New nMailException("GetHeaderField", _err)
            End If
            Return _field.ToString()
        End Function
        ''' <summary>
        ''' [wb_w̃tB[h̓e擾܂B
        ''' </summary>
        ''' <param name="field_name">tB[h</param>
        ''' <param name="header">wb_</param>
        ''' <returns>tB[h̓e</returns>
        Public Function GetHeaderField(ByVal field_name As String, ByVal header As String) As String
            _field_name = field_name
            _header = New StringBuilder(header)
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            _err = Imap4GetHeaderField(_field, _header.ToString(), _field_name, _header_size)
            If _err < 0 Then
                Throw New nMailException("GetHeaderField", _err)
            End If
            Return _field.ToString()
        End Function
        ''' <summary>
        ''' MIME wb_tB[h̕fR[h܂
        ''' </summary>
        ''' <param name="field">tB[h̕</param>
        ''' <returns>fR[htB[he</returns>
        Public Function DecodeHeaderField(ByVal field As String) As String
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            _err = Imap4DecodeHeaderField(_field, field, _header_size)
            If _err < 0 Then
                Throw New nMailException("DecodeHeaderField", _err)
            End If
            Return _field.ToString()
        End Function
        ''' <summary>
        ''' [wb_w̃wb_tB[h̓e擾A
        ''' MIME wb_tB[h̃fR[hsĕԂ܂
        ''' </summary>
        ''' <param name="field_name">tB[h</param>
        ''' <returns>擾fR[hς݂̃tB[he</returns>
        Public Function GetDecodeHeaderField(ByVal field_name As String) As String
            SetHeaderSize()
            _field = New StringBuilder(_header_size)
            Dim src As String = GetHeaderField(field_name, _header.ToString())
            _err = Imap4DecodeHeaderField(_field, src, _header_size)
            If _err < 0 Then
                Throw New nMailException("DecodeHeaderField", _err)
            End If
            Return _field.ToString()
        End Function
        ''' <summary>
        ''' [wb_w̃wb_tB[h̓e擾A
        ''' MIME wb_tB[h̃fR[hsĕԂ܂
        ''' </summary>
        ''' <param name="field_name">tB[h</param>
        ''' <param name="header">wb_</param>
        ''' <returns>擾fR[hς݂̃tB[he</returns>
        Public Function GetDecodeHeaderField(ByVal field_name As String, ByVal header As String) As String
            SetHeaderSize()
            _err = Imap4DecodeHeaderField(_field, GetHeaderField(field_name, header), _header_size)
            If _err < 0 Then
                Throw New nMailException("DecodeHeaderField", _err)
            End If
            Return _field.ToString()
        End Function

        ''' <summary>
        ''' [{bNX쐬܂B
        ''' </summary>
        ''' <param name="mailbox">쐬郁[{bNX</param>
        ''' <remarks>
        ''' [{bNX쐬܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub CreateMailBox(ByVal mailbox As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4CreateMailBox(_socket, mailbox)
            If _err < 0 Then
                Throw New nMailException("CreateMailBox: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [{bNX폜܂B
        ''' </summary>
        ''' <remarks>
        ''' [{bNX폜܂B
        ''' </remarks>
        ''' <param name="mailbox">폜郁[{bNX</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub DeleteMailBox(ByVal mailbox As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4DeleteMailBox(_socket, mailbox)
            If _err < 0 Then
                Throw New nMailException("DeleteMailBox: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [{bNXύX܂B
        ''' </summary>
        ''' <param name="old_name">ύXÕ[{bNX</param>
        ''' <param name="new_name">ύX̃[{bNX</param>
        ''' <remarks>
        ''' [{bNXύX܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub RenameMailBox(ByVal old_name As String, ByVal new_name As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4RenameMailBox(_socket, old_name, new_name)
            If _err < 0 Then
                Throw New nMailException("RenameMailBox: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [{bNXwǂ܂B
        ''' </summary>
        ''' <param name="mailbox">wǂ郁[{bNX</param>
        ''' <remarks>
        ''' [{bNXwǂ܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub SubscribeMailBox(ByVal mailbox As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4SubscribeMailBox(_socket, mailbox)
            If _err < 0 Then
                Throw New nMailException("SubscribeMailBox: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [{bNX̍wǂ܂B
        ''' </summary>
        ''' <param name="mailbox">wǉ郁[{bNX</param>
        ''' <remarks>
        ''' [{bNX̍wǂ܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub UnsubscribeMailBox(ByVal mailbox As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4UnsubscribeMailBox(_socket, mailbox)
            If _err < 0 Then
                Throw New nMailException("UnsubscribeMailBox: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [Rs[܂B
        ''' </summary>
        ''' <param name="no">Rs[郁[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <param name="mailbox">Rs[̃[{bNX</param>
        ''' <remarks>
        ''' ݑIĂ郁[{bNX̃[w̃[{bNXɃRs[܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub Copy(ByVal no As Integer, ByVal mailbox As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4CopyMail(_socket, no, mailbox, _useuid)
            If _err < 0 Then
                Throw New nMailException("Copy: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' MIME \擾܂B
        ''' </summary>
        ''' <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <remarks>
        ''' <para>MIME \<see cref="GetMimeStructureStatusList"/>Ŏ擾ł܂B</para>
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub GetMimeStructure(ByVal no As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4GetMimeStructure(_socket, no, _flag Or _useuid)
            If _err < 0 Then
                _mime_list = New MimeStructureStatus() {}
                Throw New nMailException("GetMimeStructure: " + Options.ErrorMessage, _err)
            Else
                Dim part_no As Integer
                Dim param_no As Integer
                Dim param_count As Integer
                SetHeaderSize()
                _mime_list = New MimeStructureStatus(_err - 1) {}
                For part_no = 0 To _err - 1
                    _mime_list(part_no).PartNo = part_no
                    Dim name As StringBuilder = New StringBuilder(_header_size)
                    Dim value As StringBuilder = New StringBuilder(_header_size)
                    Imap4GetMimeStructureStatus(_socket, ContentTypeAndSubType, part_no, 0, name, value, _header_size)
                    _mime_list(part_no).Type = name.ToString()
                    _mime_list(part_no).SubType = value.ToString()
                    Imap4GetMimeStructureStatus(_socket, ContentPart, part_no, 0, name, Nothing, _header_size)
                    _mime_list(part_no).Part = name.ToString()
                    Imap4GetMimeStructureStatus(_socket, ContentId, part_no, 0, name, Nothing, _header_size)
                    _mime_list(part_no).Id = name.ToString()
                    Imap4GetMimeStructureStatus(_socket, ContentDescription, part_no, 0, name, Nothing, _header_size)
                    _mime_list(part_no).Description = name.ToString()
                    Imap4GetMimeStructureStatus(_socket, ContentTransferEncoding, part_no, 0, name, Nothing, _header_size)
                    _mime_list(part_no).Encoding = name.ToString()
                    Imap4GetMimeStructureStatus(_socket, ContentFileName, part_no, 0, name, Nothing, _header_size)
                    _mime_list(part_no).FileName = name.ToString()
                    _mime_list(part_no).Size = Imap4GetMimeStructureStatus(_socket, ContentSize, part_no, 0, name, Nothing, _header_size)
                    If _mime_list(part_no).Size < 0 Then
                        _mime_list(part_no).Size = 0
                    End If
                    _mime_list(part_no).Line = Imap4GetMimeStructureStatus(_socket, ContentLine, part_no, 0, name, Nothing, _header_size)
                    If _mime_list(part_no).Line < 0 Then
                        _mime_list(part_no).Line = 0
                    End If
                    param_count = Imap4GetMimeStructureStatus(_socket, ContentParameterCount, part_no, 0, name, Nothing, _header_size)
                    If param_count < 0 Then
                        param_count = 0
                    End If
                    _mime_list(part_no).Parameter = New MimeParameterStatus(param_count - 1) {}
                    For param_no = 0 To param_count - 1
                        Imap4GetMimeStructureStatus(_socket, ContentParameter, part_no, param_no, name, value, _header_size)
                        _mime_list(part_no).Parameter(param_no).Name = name.ToString()
                        _mime_list(part_no).Parameter(param_no).Value = value.ToString()
                    Next param_no
                Next part_no
            End If
        End Sub

        ''' <summary>
        ''' MIME p[g擾
        ''' </summary>
        ''' <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <param name="part_no">MIME p[gԍ</param>
        ''' <remarks>
        ''' <para>ǃtO𗧂ĂȂꍇAfR[hȂꍇ́A<see cref="MimeFlag"/>Őݒ肵Ă܂B</para>
        ''' <para>擾p[g{<see cref="Body"/>Ŏ擾ł܂B</para>
        ''' <para>Tv <see cref="GetMimeStructure"/>QƂĂB</para>
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub GetMimePart(ByVal no As Integer, ByVal part_no As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            Dim size As Integer = _mime_list(part_no).Size
            If size < 0 Then
                GetSize(no)
                size = _size
            End If
            _body = New StringBuilder(size * 2)
            _err = Imap4GetMimePart(_socket, no, part_no, _body, _mime_flag Or _useuid)
            If _err < 0 Then
                Throw New nMailException("GetMimePart: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' MIME p[gwb_擾
        ''' </summary>
        ''' <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <param name="part_no">MIME p[gԍ</param>
        ''' <remarks>
        ''' <para>ǃtO𗧂ĂȂꍇAfR[hȂꍇ́A<see cref="MimeFlag"/>Őݒ肵Ă܂B</para>
        ''' <para>擾p[gwb_<see cref="Header"/>Ŏ擾ł܂B</para>
        ''' <para>Tv <see cref="GetMimeStructure"/>QƂĂB</para>
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub GetMimePartHeader(ByVal no As Integer, ByVal part_no As Integer)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            Dim size As Integer = _mime_list(part_no).Size
            If size < 0 Then
                GetSize(no)
                size = _size
            End If
            _body = New StringBuilder(size * 2)
            _err = Imap4GetMimePart(_socket, no, part_no, _header, MimeHeader Or _mime_flag Or _useuid)
            If _err < 0 Then
                Throw New nMailException("GetMimePartHeader: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' MIME p[gۑ
        ''' </summary>
        ''' <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
        ''' <param name="part_no">MIME p[gԍ</param>
        ''' <param name="path">ۑt@C</param>
        ''' <remarks>
        ''' <para>ǃtO𗧂ĂȂꍇAfR[hȂꍇ́A<see cref="MimeFlag"/>Őݒ肵Ă܂B</para>
        ''' <para>ۑt@C<see cref="FileName"/>Ŏ擾ł܂B</para>
        ''' <para>Tv <see cref="GetMimeStructure"/>QƂĂB</para>
        ''' <para>Content-Type ̃^Cv "multipart"  MIME p[gw肵ꍇAG[ɂȂ܂̂łӉB</para>
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub SaveMimePart(ByVal no As Integer, ByVal part_no As Integer, ByVal path As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            Options.FileNameMax = MaxPath
            _filename = New StringBuilder(MaxPath)
            _err = Imap4SaveMimePart(_socket, no, part_no, path, _filename, MimeSaveAsFile Or _mime_flag Or _useuid)
            If _err < 0 Then
                Throw New nMailException("SaveMimePart: " + Options.ErrorMessage, _err)
            End If
        End Sub

        ''' <summary>
        ''' [̌s(L)
        ''' </summary>
        ''' <param name="type">
        ''' <para>̐ݒ\Ȓl͉L̒ʂłB</para>
        ''' <para><see cref="SearchKeyword"/>w肳ꂽL[[h</para>
        ''' <para><see cref="SearchUnKeyword"/>w肳ꂽL[[hȂ</para>
        ''' <para><see cref="SearchFrom"/>From wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchTo"/>To wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchCc"/>CC wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchBcc"/>BCC wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchSubject"/>SUBJECT wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchSentBefore"/>DATE wb_w肳ꂽtȑO</para>
        ''' <para><see cref="SearchSentOn"/>DATE wb_w肳ꂽt</para>
        ''' <para><see cref="SearchSentSince"/>DATE wb_w肳ꂽtȍ~</para>
        ''' <para><see cref="SearchBefore"/>w肳ꂽtȑOɓ</para>
        ''' <para><see cref="SearchOn"/>w肳ꂽtɓ</para>
        ''' <para><see cref="SearchSince"/>w肳ꂽtȍ~ɓ</para>
        ''' <para><see cref="SearchHeader"/>w肳ꂽwb_tB[hɕ܂ "wb_tB[h "Ǝw肵Ă</para>
        ''' <para><see cref="SearchBody"/>{ɕ܂</para>
        ''' <para><see cref="SearchText"/>wb_і{ɕ܂</para>
        ''' <para><see cref="SearchLager"/>wTCY傫ȃ[ TCY͕ɕϊĂ</para>
        ''' <para><see cref="SearchSmaller"/>wTCY菬ȃ[ TCY͕ɕϊĂ</para>
        ''' <para><see cref="SearchUid"/>w UID ̃[</para>
        ''' <para><see cref="SearchCommand"/>𒼐ڎw</para>
        ''' <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
        ''' </param>
        ''' <param name="text"></param>
        ''' <remarks>
        '''	ʂ <see cref="GetSearchMailResultList"/> Ŏ擾ł܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub Search(ByVal type As Integer, ByVal text As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            If _search_first_flag Then
                type = type Or SearchFirst
                _search_first_flag = False
            End If
            _err = Imap4SearchMail(_socket, type, text, _useuid)
            _search_first_flag = True
            If _err < 0 Then
                _search_list = New Integer() {}
                Throw New nMailException("Search: " + Options.ErrorMessage, _err)
            Else
                Dim no As Integer
                _search_list = New Integer(_err - 1) {}
                For no = 0 To _err - 1
                    Imap4GetSearchMailResult(_socket, no, _search_list(no))
                Next no
            End If
        End Sub
        ''' <summary>
        ''' [̌s()
        ''' </summary>
        ''' <param name="type">
        ''' <para>̐ݒ\Ȓl͉L̒ʂłB</para>
        ''' <para><see cref="SearchAnswered"/>ԐMς</para>
        ''' <para><see cref="SearchUnAnswered"/>ԐMς݂łȂ</para>
        ''' <para><see cref="SearchDeleted"/>}[N</para>
        ''' <para><see cref="SearchUnDeleted"/>}[NȂ</para>
        ''' <para><see cref="SearchDraft"/>etO</para>
        ''' <para><see cref="SearchUnDraft"/>etOȂ</para>
        ''' <para><see cref="SearchFlagged"/>dvtO</para>
        ''' <para><see cref="SearchUnFlagged"/>dvtOȂ</para>
        ''' <para><see cref="SearchRecent"/>tO</para>
        ''' <para><see cref="SearchUnRecent"/>tOȂ</para>
        ''' <para><see cref="SearchSeen"/>ǃtO</para>
        ''' <para><see cref="SearchUnSeen"/>ǃtOȂ</para>
        ''' <para><see cref="SearchNew"/>tO肩ǃtOȂ</para>
        ''' <para><see cref="SearchAll"/>SẴ[</para>
        ''' <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
        ''' </param>
        ''' <remarks>
        '''	ʂ <see cref="GetSearchMailResultList"/> Ŏ擾ł܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub Search(ByVal type As Integer)
            Search(type, Nothing)
        End Sub

        ''' <summary>
        ''' [̌ AND (L)
        ''' </summary>
        ''' <param name="type">
        ''' <para>̐ݒ\Ȓl͉L̒ʂłB</para>
        ''' <para><see cref="SearchKeyword"/>w肳ꂽL[[h</para>
        ''' <para><see cref="SearchUnKeyword"/>w肳ꂽL[[hȂ</para>
        ''' <para><see cref="SearchFrom"/>From wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchTo"/>To wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchCc"/>CC wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchBcc"/>BCC wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchSubject"/>SUBJECT wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchSentBefore"/>DATE wb_w肳ꂽtȑO</para>
        ''' <para><see cref="SearchSentOn"/>DATE wb_w肳ꂽt</para>
        ''' <para><see cref="SearchSentSince"/>DATE wb_w肳ꂽtȍ~</para>
        ''' <para><see cref="SearchBefore"/>w肳ꂽtȑOɓ</para>
        ''' <para><see cref="SearchOn"/>w肳ꂽtɓ</para>
        ''' <para><see cref="SearchSince"/>w肳ꂽtȍ~ɓ</para>
        ''' <para><see cref="SearchHeader"/>w肳ꂽwb_tB[hɕ܂ "wb_tB[h "Ǝw肵Ă</para>
        ''' <para><see cref="SearchBody"/>{ɕ܂</para>
        ''' <para><see cref="SearchText"/>wb_і{ɕ܂</para>
        ''' <para><see cref="SearchLager"/>wTCY傫ȃ[ TCY͕ɕϊĂ</para>
        ''' <para><see cref="SearchSmaller"/>wTCY菬ȃ[ TCY͕ɕϊĂ</para>
        ''' <para><see cref="SearchUid"/>w UID ̃[</para>
        ''' <para><see cref="SearchCommand"/>𒼐ڎw</para>
        ''' <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
        ''' </param>
        ''' <param name="text"></param>
        ''' <remarks>
        '''	AND Ōw肵܂B<see cref="Search"/>Ōs܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub AddSearchAnd(ByVal type As Integer, ByVal text As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            If _search_first_flag Then
                type = type Or SearchFirst
                _search_first_flag = False
            End If
            _err = Imap4SearchMail(_socket, type Or SearchAnd, text, _useuid)
            If _err < 0 Then
                Throw New nMailException("Search: " + Options.ErrorMessage, _err)
            End If
        End Sub
        ''' <summary>
        ''' [̌ AND ()
        ''' </summary>
        ''' <param name="type">
        ''' <para>̐ݒ\Ȓl͉L̒ʂłB</para>
        ''' <para><see cref="SearchAnswered"/>ԐMς</para>
        ''' <para><see cref="SearchUnAnswered"/>ԐMς݂łȂ</para>
        ''' <para><see cref="SearchDeleted"/>}[N</para>
        ''' <para><see cref="SearchUnDeleted"/>}[NȂ</para>
        ''' <para><see cref="SearchDraft"/>etO</para>
        ''' <para><see cref="SearchUnDraft"/>etOȂ</para>
        ''' <para><see cref="SearchFlagged"/>dvtO</para>
        ''' <para><see cref="SearchUnFlagged"/>dvtOȂ</para>
        ''' <para><see cref="SearchRecent"/>tO</para>
        ''' <para><see cref="SearchUnRecent"/>tOȂ</para>
        ''' <para><see cref="SearchSeen"/>ǃtO</para>
        ''' <para><see cref="SearchUnSeen"/>ǃtOȂ</para>
        ''' <para><see cref="SearchNew"/>tO肩ǃtOȂ</para>
        ''' <para><see cref="SearchAll"/>SẴ[</para>
        ''' <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
        ''' </param>
        ''' <remarks>
        '''	AND Ōw肵܂B<see cref="Search"/>Ōs܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub AddSearchAnd(ByVal type As Integer)
            AddSearchAnd(type, Nothing)
        End Sub
        ''' <summary>
        ''' [̌ OR (L)
        ''' </summary>
        ''' <param name="type">
        ''' <para>̐ݒ\Ȓl͉L̒ʂłB</para>
        ''' <para><see cref="SearchKeyword"/>w肳ꂽL[[h</para>
        ''' <para><see cref="SearchUnKeyword"/>w肳ꂽL[[hȂ</para>
        ''' <para><see cref="SearchFrom"/>From wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchTo"/>To wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchCc"/>CC wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchBcc"/>BCC wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchSubject"/>SUBJECT wb_Ɏw̕񂠂</para>
        ''' <para><see cref="SearchSentBefore"/>DATE wb_w肳ꂽtȑO</para>
        ''' <para><see cref="SearchSentOn"/>DATE wb_w肳ꂽt</para>
        ''' <para><see cref="SearchSentSince"/>DATE wb_w肳ꂽtȍ~</para>
        ''' <para><see cref="SearchBefore"/>w肳ꂽtȑOɓ</para>
        ''' <para><see cref="SearchOn"/>w肳ꂽtɓ</para>
        ''' <para><see cref="SearchSince"/>w肳ꂽtȍ~ɓ</para>
        ''' <para><see cref="SearchHeader"/>w肳ꂽwb_tB[hɕ܂ "wb_tB[h "Ǝw肵Ă</para>
        ''' <para><see cref="SearchBody"/>{ɕ܂</para>
        ''' <para><see cref="SearchText"/>wb_і{ɕ܂</para>
        ''' <para><see cref="SearchLager"/>wTCY傫ȃ[ TCY͕ɕϊĂ</para>
        ''' <para><see cref="SearchSmaller"/>wTCY菬ȃ[ TCY͕ɕϊĂ</para>
        ''' <para><see cref="SearchUid"/>w UID ̃[</para>
        ''' <para><see cref="SearchCommand"/>𒼐ڎw</para>
        ''' <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
        ''' </param>
        ''' <param name="text"></param>
        ''' <remarks>
        '''	OR Ōw肵܂B<see cref="Search"/>Ōs܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub AddSearchOr(ByVal type As Integer, ByVal text As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            If _search_first_flag Then
                type = type Or SearchFirst
                _search_first_flag = False
            End If
            _err = Imap4SearchMail(_socket, type Or SearchOr, text, _useuid)
            If _err < 0 Then
                Throw New nMailException("Search: " + Options.ErrorMessage, _err)
            End If
        End Sub
        ''' <summary>
        ''' [̌ OR ()
        ''' </summary>
        ''' <param name="type">
        ''' <para>̐ݒ\Ȓl͉L̒ʂłB</para>
        ''' <para><see cref="SearchAnswered"/>ԐMς</para>
        ''' <para><see cref="SearchUnAnswered"/>ԐMς݂łȂ</para>
        ''' <para><see cref="SearchDeleted"/>}[N</para>
        ''' <para><see cref="SearchUnDeleted"/>}[NȂ</para>
        ''' <para><see cref="SearchDraft"/>etO</para>
        ''' <para><see cref="SearchUnDraft"/>etOȂ</para>
        ''' <para><see cref="SearchFlagged"/>dvtO</para>
        ''' <para><see cref="SearchUnFlagged"/>dvtOȂ</para>
        ''' <para><see cref="SearchRecent"/>tO</para>
        ''' <para><see cref="SearchUnRecent"/>tOȂ</para>
        ''' <para><see cref="SearchSeen"/>ǃtO</para>
        ''' <para><see cref="SearchUnSeen"/>ǃtOȂ</para>
        ''' <para><see cref="SearchNew"/>tO肩ǃtOȂ</para>
        ''' <para><see cref="SearchAll"/>SẴ[</para>
        ''' <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
        ''' </param>
        ''' <remarks>
        '''	OR Ōw肵܂B<see cref="Search"/>Ōs܂B
        ''' </remarks>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub AddSearchOr(ByVal type As Integer)
            AddSearchOr(type, Nothing)
        End Sub

        ''' <summary>
        ''' [{bNXɃ[Abv[h܂B
        ''' </summary>
        ''' <param name="mailbox">Abv[h郁[{bNX</param>
        ''' <param name="header">[wb_
        ''' <para>Date,Message-ID,Mime-Version,Content-Type,Content-Transfer-Encode tB[h</para>
        ''' <para>͎Iɕt܂BDate tB[hɂ͌ݓݒ肳܂B</para>
        ''' <para>Date  Message-ID tB[h͈ header ɋLq΂炪D悳܂B</para>
        ''' </param>
        ''' <param name="body">[{</param>
        ''' <param name="message_flag">bZ[WtO
        ''' <para><see cref="MessageAnswerd"/>ԐMς݃tO</para>
        ''' <para><see cref="MessageDeleted"/>}[N</para>
        ''' <para><see cref="MessageDraft"/>etO</para>
        ''' <para><see cref="MessageFlagged"/>dvtO</para>
        ''' <para><see cref="MessageRecent"/>tO</para>
        ''' <para><see cref="MessageSeen"/>ǃtO</para>
        ''' <para>C#  | AVB.NET ł Or ŕw\łB</para>
        ''' </param>
        ''' <param name="path">Ytt@C</param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub AppendMail(ByVal mailbox As String, ByVal header As String, ByVal body As String, ByVal message_flag As Integer, ByVal path As String)
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4AppendMail(_socket, mailbox, header, body, path, message_flag, Nothing, AddDateField Or AddMessageId)
            If _err < 0 Then
                Throw New nMailException("AppendMail: " + Options.ErrorMessage, _err)
            End If
        End Sub
        ''' <summary>
        ''' [{bNXɃ[Abv[h܂B
        ''' </summary>
        ''' <param name="mailbox">Abv[h郁[{bNX</param>
        ''' <param name="header">[wb_
        ''' <para>Date,Message-ID,Mime-Version,Content-Type,Content-Transfer-Encode tB[h</para>
        ''' <para>͎Iɕt܂BDate tB[hɂ͌ݓݒ肳܂B</para>
        ''' <para>Date  Message-ID tB[h͈ header ɋLq΂炪D悳܂B</para>
        ''' </param>
        ''' <param name="body">[{</param>
        ''' <param name="message_flag">bZ[WtO
        ''' <para><see cref="MessageAnswerd"/>ԐMς݃tO</para>
        ''' <para><see cref="MessageDeleted"/>}[N</para>
        ''' <para><see cref="MessageDraft"/>etO</para>
        ''' <para><see cref="MessageFlagged"/>dvtO</para>
        ''' <para><see cref="MessageRecent"/>tO</para>
        ''' <para><see cref="MessageSeen"/>ǃtO</para>
        ''' <para>C#  | AVB.NET ł Or ŕw\łB</para>
        ''' </param>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub AppendMail(ByVal mailbox As String, ByVal header As String, ByVal body As String, ByVal message_flag As Integer)
            AppendMail(mailbox, header, body, message_flag, Nothing)
        End Sub

        Private Sub SetNameSpaceList(ByRef list As NameSpaceStatus(), ByVal command1 As Integer, ByVal command2 As Integer)
            Dim count As Integer
            Dim no As Integer
            Dim separate As StringBuilder = New StringBuilder(_header_size)
            Dim name As StringBuilder = New StringBuilder(_header_size)

            count = Imap4GetNameSpaceStatus(_socket, command1, Nothing, Nothing, 0)
            list = New NameSpaceStatus(count - 1) {}
            For no = 0 To count - 1
                If Imap4GetNameSpaceStatus(_socket, command2 Or no, separate, name, _header_size) = Success Then
                    list(no).Name = name.ToString()
                    list(no).Separate = separate(0)
                End If
            Next no
        End Sub

        ''' <summary>
        ''' OԂ擾܂B
        ''' </summary>
        ''' <exception cref="InvalidOperationException">
        '''	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
        '''	</exception>
        '''	<exception cref="nMailException">
        '''	T[oƂ̌MɃG[܂B
        ''' <see cref="nMailException.Message"/>ɃG[bZ[WA
        ''' <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
        ''' </exception>
        Public Sub GetNameSpace()
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4GetNameSpace(_socket)
            If _err < 0 Then
                Throw New nMailException("GetNameSpace: " + Options.ErrorMessage, _err)
            Else
                Dim count As Integer
                Dim no As Integer
                Dim name_no As Integer
                Dim c1 As Integer() = {NameSpacePersonalCount, NameSpaceOtherCount, NameSpaceSharedCount}
                Dim c2 As Integer() = {NameSpacePersonalNo, NameSpaceOtherNo, NameSpaceSharedNo}

                SetHeaderSize()
                For name_no = NameSpacePersonal To NameSpaceShared
                    count = Imap4GetNameSpaceStatus(_socket, c1(name_no), Nothing, Nothing, 0)
                    _namespace_list(name_no) = New NameSpaceStatus(count - 1) {}
                    For no = 0 To count - 1
                        Dim separate As StringBuilder = New StringBuilder(_header_size)
                        Dim name As StringBuilder = New StringBuilder(_header_size)
                        If Imap4GetNameSpaceStatus(_socket, c2(name_no) Or no, separate, name, _header_size) = Success Then
                            _namespace_list(name_no)(no).Name = name.ToString()
                            _namespace_list(name_no)(no).Separate = separate(0)
                        End If
                    Next no
                Next name_no
            End If
        End Sub

        ''' <summary>
        ''' ptw蕶쐬܂B
        ''' </summary>
        ''' <remarks>
        ''' tw蕶쐬܂B
        ''' <para>p : "09-Jul-2009"</para>
        ''' </remarks>
        ''' <returns>쐬tw蕶</returns>
        Public Function MakeSearchDateString(ByVal tm As DateTime) As String
            Dim _datestring As StringBuilder = New StringBuilder(DateStringSize)
            MakeDateString(_datestring, tm.Year, tm.Month, tm.Day, tm.Hour, tm.Minute, tm.Second, DateImap4)
            Return _datestring.ToString()
        End Function
        ''' <summary>
        ''' AppenMailpw蕶쐬܂B
        ''' </summary>
        ''' <remarks>
        ''' w蕶쐬܂B
        ''' <para>AppendMailp : "09-Jul-2009 15:10:30"</para>
        ''' <para>̂Ƃ AppendMail ŃAbv[hۂ̃T[oIɎwɂ</para>
        ''' <para>@Imap4 NX̃\bhł͑ΉĂ܂B</para>
        ''' <para>@Date wb_tB[h̒l <see cref="MakeFieldDateString"/> ō쐬ĕt邱Ƃł܂B</para>
        ''' </remarks>
        ''' <returns>쐬w蕶</returns>
        Public Function MakeAppendDateString(ByVal tm As DateTime) As String
            Dim _datestring As StringBuilder = New StringBuilder(DateStringSize)
            MakeDateString(_datestring, tm.Year, tm.Month, tm.Day, tm.Hour, tm.Minute, tm.Second, DateTimeImap4)
            Return _datestring.ToString()
        End Function
        ''' <summary>
        ''' Date wb_tB[hpw蕶쐬܂B
        ''' </summary>
        ''' <remarks>
        ''' w蕶쐬܂B
        ''' <para>Date wb_tB[hp : "Thu, 9 Jul 2009 15:10:30 +09:00"</para>
        ''' <para><see cref="AppendMail"/> Ŏw̓ Date wb_tB[htꍇɎgp܂B</para>
        ''' </remarks>
        ''' <returns>쐬w蕶</returns>
        Public Function MakeFieldDateString(ByVal tm As DateTime) As String
            Dim _datestring As StringBuilder = New StringBuilder(DateStringSize)
            MakeDateString(_datestring, tm.Year, tm.Month, tm.Day, tm.Hour, tm.Minute, tm.Second, DateTimeSmtp)
            Return _datestring.ToString()
        End Function
        ''' <summary>
        ''' Ȃɂs܂
        ''' </summary>
        ''' <remarks>
        ''' T[oƂ̐ڑ^CAEgh~Ɏgp܂B
        ''' </remarks>
        Public Sub NoOperation()
            If _socket.Equals(IntPtr.op_Explicit(ErrorSocket)) Then
                Throw New InvalidOperationException
            End If
            _err = Imap4NoOperation(_socket)
            If _err < 0 Then
                Throw New nMailException("NoOperation: " + Options.ErrorMessage, _err)
            End If
        End Sub
        ''' <summary>
        ''' Ytt@C̔z擾܂B
        ''' </summary>
        ''' <returns>Ytt@C̔z</returns>
        Public Function GetFileNameList() As String()
            If _filename_list Is Nothing Then
                Return New String() {}
            Else
                Return CType(_filename_list.Clone(), String())
            End If
        End Function
        ''' <summary>
        ''' [{bNX̔z擾܂B
        ''' </summary>
        ''' <returns>[{bNX̔z</returns>
        Public Function GetMailBoxStatusList() As MailBoxStatus()
            Return CType(_mailbox_list.Clone(), MailBoxStatus())
        End Function
        ''' <summary>
        ''' MIME \̔z擾܂B
        ''' </summary>
        ''' <returns>MIME \̔z</returns>
        Public Function GetMimeStructureStatusList() As MimeStructureStatus()
            Return CType(_mime_list.Clone(), MimeStructureStatus())
        End Function
        ''' <summary>
        ''' ʏ̔z擾܂B
        ''' </summary>
        ''' <returns>ʂ̔z</returns>
        Public Function GetSearchMailResultList() As Integer()
            Return CType(_search_list.Clone(), Integer())
        End Function
        ''' <summary>
        ''' lOԏ̔z擾܂B
        ''' </summary>
        ''' <remarks>
        '''	<para><see cref="GetNameSpace"/>sɌĂяoĂB</para>
        ''' </remarks>
        ''' <returns>Oԏ̔z</returns>
        Public Function GetNameSpacePersonalStatusList() As NameSpaceStatus()
            Return CType(_namespace_list(NameSpacePersonal).Clone(), NameSpaceStatus())
        End Function
        ''' <summary>
        ''' lOԏ̔z擾܂B
        ''' </summary>
        ''' <remarks>
        '''	<para><see cref="GetNameSpace"/>sɌĂяoĂB</para>
        ''' </remarks>
        ''' <returns>Oԏ̔z</returns>
        Public Function GetNameSpaceOtherStatusList() As NameSpaceStatus()
            Return CType(_namespace_list(NameSpaceOther).Clone(), NameSpaceStatus())
        End Function
        ''' <summary>
        ''' LOԏ̔z擾܂B
        ''' </summary>
        ''' <remarks>
        '''	<para><see cref="GetNameSpace"/>sɌĂяoĂB</para>
        ''' </remarks>
        ''' <returns>Oԏ̔z</returns>
        Public Function GetNameSpaceSharedStatusList() As NameSpaceStatus()
            Return CType(_namespace_list(NameSpaceShared).Clone(), NameSpaceStatus())
        End Function

        ''' <summary>
        ''' IMAP4 |[gԍłB
        ''' </summary>
        ''' <value>IMAP4 |[gԍ</value>
        Public Property Port() As Integer
            Get
                Return _port
            End Get
            Set(ByVal Value As Integer)
                _port = Value
            End Set
        End Property

        ''' <summary>
        ''' \PbgnhłB
        ''' </summary>
        ''' <value>SMTP \Pbgnh</value>
        Public ReadOnly Property Handle() As IntPtr
            Get
                Return _socket
            End Get
        End Property

        ''' <summary>
        ''' [{bNXɂ郁[łB
        ''' </summary>
        ''' <value>ݑIĂ郁[{bNXɂ郁[</value>
        Public ReadOnly Property Count() As Integer
            Get
                Return _count
            End Get
        End Property

        ''' <summary>
        ''' [̃TCYłB
        ''' </summary>
        ''' <value>[̃TCY</value>
        Public ReadOnly Property Size() As Integer
            Get
                Return _size
            End Get
        End Property

        ''' <summary>
        ''' IMAP4 T[ołB
        ''' </summary>
        ''' <value>IMAP4 T[o</value>
        Public Property HostName() As String
            Get
                Return _host
            End Get
            Set(ByVal Value As String)
                _host = Value
            End Set
        End Property

        ''' <summary>
        ''' IMAP4 [U[łB
        ''' </summary>
        ''' <value>IMAP4 [U[</value>
        Public Property Id() As String
            Get
                Return _id
            End Get
            Set(ByVal Value As String)
                _id = Value
            End Set
        End Property

        ''' <summary>
        ''' IMAP4 pX[hłB
        ''' </summary>
        ''' <value>IMAP4 pX[h</value>
        Public Property Password() As String
            Get
                Return _password
            End Get
            Set(ByVal Value As String)
                _password = Value
            End Set
        End Property

        ''' <summary>
        ''' Ytt@CۑtH_łB
        ''' </summary>
        ''' <remarks>
        ''' Nothing (VB.Net  Nothing) ̏ꍇۑ܂B
        ''' </remarks>
        ''' <value>Ytt@CۑtH_</value>
        Public Property Path() As String
            Get
                Return _path
            End Get
            Set(ByVal Value As String)
                _path = Value
            End Set
        End Property

        ''' <summary>
        ''' [̖{łB
        ''' </summary>
        ''' <value>[{</value>
        Public ReadOnly Property Body() As String
            Get
                Return _body.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [̌łB
        ''' </summary>
        ''' <value>[̌</value>
        Public ReadOnly Property Subject() As String
            Get
                Return _subject.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [̑M̕łB
        ''' </summary>
        ''' <value>[M</value>
        Public ReadOnly Property DateString() As String
            Get
                Return _date.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [̍olłB
        ''' </summary>
        ''' <value>[̍ol</value>
        Public ReadOnly Property From() As String
            Get
                Return _from.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [̃wb_łB
        ''' </summary>
        ''' <value>[̃wb_</value>
        Public Property Header() As String
            Get
                Return _header.ToString()
            End Get
            Set(ByVal Value As String)
                _header = New StringBuilder(Value)
            End Set
        End Property

        ''' <summary>
        ''' Ytt@CłB
        ''' </summary>
        ''' <remarks>
        ''' ̓Ytt@CꍇA"," ŋ؂Ċi[܂B
        ''' <see cref="Options.SplitChar"/>ŋ؂蕶ύXł܂B
        ''' </remarks>
        ''' <value>Ytt@C</value>
        Public ReadOnly Property FileName() As String
            Get
                Return _filename.ToString()
            End Get
        End Property

        ''' <summary>
        ''' Ytt@C̔złB
        ''' </summary>
        '''	<remarks>
        ''' ̃vpeB͌݊̂߂ɎcĂ܂B
        '''	<see cref="GetFileNameList"/>Ŕz擾Ďgp悤ɂĂB
        '''	</remarks>
        ''' <value>Ytt@C̔z</value>
        Public ReadOnly Property FileNameList() As String()
            Get
                Return _filename_list
            End Get
        End Property

        ''' <summary>
        ''' [{bNX̔złB
        ''' </summary>
        '''	<remarks>
        '''	<see cref="GetMailBoxStatusList"/>Ŕz擾Ďgp̂𐄑E܂B
        '''	</remarks>
        ''' <value>[{bNX̔z</value>
        Public ReadOnly Property MailBoxStatusList() As MailBoxStatus()
            Get
                Return _mailbox_list
            End Get
        End Property

        ''' <summary>
        ''' MIME \̔złB
        ''' </summary>
        '''	<remarks>
        '''	<see cref="GetMimeStructureStatusList"/>Ŕz擾Ďgp̂𐄑E܂B
        '''	</remarks>
        ''' <value>MIME \̔z</value>
        Public ReadOnly Property MimeStructureStatusList() As MimeStructureStatus()
            Get
                Return _mime_list
            End Get
        End Property

        ''' <summary>
        ''' lOԏ̔złB
        ''' </summary>
        '''	<remarks>
        '''	<see cref="GetNameSpacePersonalStatusList"/>Ŕz擾Ďgp̂𐄑E܂B
        '''	</remarks>
        ''' <value>lOԏ̔z</value>
        Public ReadOnly Property NameSpacePersonalStatusList() As NameSpaceStatus()
            Get
                Return _namespace_list(NameSpacePersonal)
            End Get
        End Property
        ''' <summary>
        ''' lOԏ̔złB
        ''' </summary>
        '''	<remarks>
        '''	<see cref="GetNameSpaceOtherStatusList"/>Ŕz擾Ďgp̂𐄑E܂B
        '''	</remarks>
        ''' <value>lOԏ̔z</value>
        Public ReadOnly Property NameSpaceOtherStatusList() As NameSpaceStatus()
            Get
                Return _namespace_list(NameSpaceOther)
            End Get
        End Property
        ''' <summary>
        ''' LOԏ̔złB
        ''' </summary>
        '''	<remarks>
        '''	<see cref="GetNameSpaceSharedStatusList"/>Ŕz擾Ďgp̂𐄑E܂B
        '''	</remarks>
        ''' <value>LOԏ̔z</value>
        Public ReadOnly Property NameSpaceSharedStatusList() As NameSpaceStatus()
            Get
                Return _namespace_list(NameSpaceShared)
            End Get
        End Property

        ''' <summary>
        ''' ʏ̔z擾܂B
        ''' </summary>
        '''	<remarks>
        '''	<see cref="GetSearchMailResultList"/>Ŕz擾Ďgp̂𐄑E܂B
        '''	</remarks>
        ''' <returns>ʂ̔z</returns>
        Public ReadOnly Property SearchMailResultList() As Integer()
            Get
                Return _search_list
            End Get
        End Property

        ''' <summary>
        ''' wb_̃tB[hłB
        ''' </summary>
        ''' <value>wb_̃tB[h</value>
        Public ReadOnly Property FieldName() As String
            Get
                Return _field_name
            End Get
        End Property

        ''' <summary>
        ''' wb_tB[h̓ełB
        ''' </summary>
        ''' <value>wb_tB[h̓e</value>
        Public ReadOnly Property Field() As String
            Get
                Return _field.ToString()
            End Get
        End Property

        ''' <summary>
        ''' [ UID łB
        ''' </summary>
        ''' <value>[ UID</value>
        Public ReadOnly Property Uid() As Integer
            Get
                Return _uid
            End Get
        End Property

        ''' <summary>
        ''' IMAP4 Fؕ@łB
        ''' </summary>
        ''' <remarks>
        ''' <para><see cref="AuthLogin"/>  LOGIN gp܂B</para>
        ''' <para><see cref="AuthPlain"/>  PLAIN gp܂B</para>
        ''' <para><see cref="AuthCramMd5"/> CRAM MD5 gp܂B</para>
        ''' <para><see cref="AuthDigestMd5"/> DIGEST MD5 gp܂B</para>
        ''' <para>C#  | AVisual Basic ł or ŕݒ\łB</para>
        ''' <para>DIGEST MD5->CRAM MD5PLAINLOGIN ̏ԂŔF؂݂܂B</para>
        '''	<para>ftHgl AuthLogin łB</para>
        ''' </remarks>
        ''' <value>IMAP4 ̔Fؕ@</value>
        Public Property AuthMode() As Integer
            Get
                Return _mode
            End Get
            Set(ByVal Value As Integer)
                _mode = Value
            End Set
        End Property

        ''' <summary>
        ''' [g@\wtOłB
        ''' </summary>
        ''' <remarks>
        ''' <para><see cref="SuspendAttachmentFile"/>Ytt@CMňꎞx~̈ڂɎw肵܂B</para>
        ''' <para><see cref="SuspendNext"/>Ytt@CMňꎞx~̓ڈȍ~Ɏw肵܂B</para>
        ''' </remarks>
        Public Property Flag() As Integer
            Get
                Return _flag
            End Get
            Set(ByVal Value As Integer)
                _flag = Value
            End Set
        End Property

        ''' <summary>
        ''' MIME p[g擾͕ۑ̐ݒtOłB
        ''' </summary>
        ''' <remarks>
        ''' <para><see cref="MimePeek"/>ǃtO𗧂Ă܂B</para>
        ''' <para><see cref="MimeNoDecode"/>fR[h܂B</para>
        ''' </remarks>
        Public Property MimeFlag() As Integer
            Get
                Return _mime_flag
            End Get
            Set(ByVal Value As Integer)
                _mime_flag = Value
            End Set
        End Property

        ''' <summary>
        ''' [bZ[W̃tOłB
        ''' </summary>
        ''' <remarks>
        ''' <para><see cref="MessageAnswerd"/>ԐMς݃tOtĂ܂B</para>
        ''' <para><see cref="MessageDeleted"/>}[NtĂ܂B</para>
        ''' <para><see cref="MessageDraft"/>etOtĂ܂B</para>
        ''' <para><see cref="MessageFlagged"/>dvtOtĂ܂B</para>
        ''' <para><see cref="MessageRecent"/>tOtĂ܂B</para>
        ''' <para><see cref="MessageSeen"/>ǃtOtĂ܂B</para>
        ''' </remarks>
        Public ReadOnly Property MessageFlag() As Integer
            Get
                Return _message_flag
            End Get
        End Property

        ''' <summary>
        ''' [w肷ۂ UID gp邩ǂ̃tOłB
        ''' </summary>
        Public Property UseUid() As Boolean
            Get
                Return _useuid_flag
            End Get
            Set(ByVal Value As Boolean)
                _useuid_flag = Value
                If _useuid_flag Then
                    _useuid = UseUidValue
                Else
                    _useuid = 0
                End If
            End Set
        End Property
        ''' <summary>
        ''' G[ԍłB
        ''' </summary>
        ''' <value>G[ԍ</value>
        Public ReadOnly Property ErrorCode() As Integer
            Get
                Return _err
            End Get
        End Property

        ''' <summary>
        ''' HTML p[gۑt@C̖OłB
        ''' </summary>
        ''' <value>t@C</value>
        Public ReadOnly Property HtmlFile() As String
            Get
                If _html_file Is Nothing Then
                    Return ""
                Else
                    Return _html_file.ToString()
                End If
            End Get
        End Property

        ''' <summary>
        ''' SSL ݒtOłB
        ''' </summary>
        ''' <value>SSL ݒtO</value>
        Public Property SSL() As Integer
            Get
                Return _ssl
            End Get
            Set(ByVal Value As Integer)
                _ssl = Value
            End Set
        End Property
        ''' <summary>
        ''' SSL NCAgؖłB
        ''' </summary>
        ''' <remarks>
        ''' nothing ̏ꍇw肵܂B
        ''' </remarks>
        ''' <value>SSL NCAgؖ</value>
        Public Property CertName() As String
            Get
                Return _cert_name
            End Get
            Set(ByVal Value As String)
                _cert_name = Value
            End Set
        End Property

        ''' <summary>
        ''' message/rfc822 p[gۑt@C̖OłB
        ''' </summary>
        ''' <value>t@C</value>
        Public ReadOnly Property Rfc822File() As String
            Get
                If _rfc822_file Is Nothing Then
                    Return ""
                Else
                    Return _rfc822_file.ToString()
                End If
            End Get
        End Property
    End Class
End Namespace

