class CStrSplit
{
	private:
	static int WidthOf(TCHAR c)
	{
#ifdef _UNICODE
		return 1;
#else
		byte cb = (byte)c;
		return((( 0x80 < cb ) && ( cb < 0xA0 ) || ( 0xE0 <= cb ) && ( cb < 0xFD )) ? 2 : 1 );
#endif
	}
	public:
		CString m_div;
		CStringArray m_list;

		CStrSplit(const TCHAR *src = NULL, const TCHAR *div = NULL)
		{
			m_div = div ? div : _T("");
			if(src != NULL) {
				Split(src);
			}
		}
		void Split(const TCHAR *s, const TCHAR *div = NULL, BOOL flag = FALSE)
		{
			if(div != NULL) {
				m_div = div;
			}
			m_list.SetSize( 0 );
			if(m_div.IsEmpty()) {
				m_list.SetAtGrow(0, s);
			} else {
				CString cs = s;
				int pos, w, c = 0;
				if(flag) {
					BOOL cflag = TRUE;
					int start = 0;
					w = 0;
					for(pos = 0 ; pos < cs.GetLength() ; pos++) {
					if(cs[pos] == _T('"')) {
						cflag = !cflag;
					} else {
						if(cflag) {
							if(cs[pos] == m_div[0]) {
								m_list.SetAtGrow(c++, cs.Mid(start, w));
								start = pos + 1;
								w = -1;
							}
						}
					}
					w++;
				}
				m_list.SetAtGrow(c++, cs.Mid(start));
			} else {
				int sw = m_div.GetLength();
				while((pos = cs.FindOneOf(m_div.Left(1))) >= 0) {
					if(m_div.GetLength() > 1) {
						w = 0;
						if(cs.Mid(pos, sw) == m_div) {
							w = sw;
						} else {
							while(pos < cs.GetLength()) {
								if(cs.Mid(pos, sw) == m_div) {
									w = sw;
									break;
								}
								pos++;
							}
						}
					} else {
	  					w = WidthOf(cs[pos]);
					}
					if(w == 0) {
						break;
					}
					m_list.SetAtGrow(c++, cs.Left(pos));
					cs.Delete(0, pos + w);
				}
				m_list.SetAtGrow(c++, cs);
			}
		}
	}
	int GetSize()
	{
		return m_list.GetSize();
	}
	CString operator[](int n)
	{
		if(n < m_list.GetSize()) {
			return m_list.GetAt(n);
		} else {
			return _T("");
		}
	}
};
