//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "testmain.h"
#include "Write.h"
#include "Name.h"
#include "Input.h"
#include "MimeList.h"
#include "Option.h"

#include "nMail.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
//	񕪊
void SplitString(TStringList *list, AnsiString str, AnsiString separate)
{
	int len, p;

	list->Clear();
	if(str != "") {
		len = separate.Length() - 1;
		p = str.Pos(separate);
		while(p > 0) {
			list->Add(str.SubString(1, p - 1));
			str.Delete(1, p + len);
			p = str.Pos(separate);
		}
		list->Add(str);
	} else {
		list->Add("");
	}
}

//---------------------------------------------------------------------------
//	񌋍
AnsiString JoinString(TStringList *list, AnsiString separate, int count)
{
	int no;
	AnsiString result;

	for(no = 0 ; no < count ; no++) {
		result += list->Strings[no] + separate;
	}
	if(count >= 0) {
	    result += list->Strings[count];
	}
	return result;
}

//---------------------------------------------------------------------------
//	c[m[ȟ
TTreeNode *SearchNode(TTreeNode *node, AnsiString path)
{
	TMailBoxData *bdata;
	TTreeNode *result;

	while(node != NULL) {
		result = SearchNode(node->getFirstChild(), path);
		if(result != NULL) {
			return result;
		}
		if(node->Data != NULL) {
			bdata = (TMailBoxData *)node->Data;;
			if(CompareText(bdata->Path, path) == 0) {
				return node;
			}
		}
		node = node->getNextSibling();
	}
	return NULL;
}

//---------------------------------------------------------------------------
//	c[Ɏw蕶ǉ
void AddPath(TTreeView *tree, AnsiString name, AnsiString separate, int flag, AnsiString text)
{
	int no, ino, index;
	TTreeNode *node, *pnode;
	AnsiString path;
	TStringList *list;
	TMailBoxData *bdata;

	// O𕪊ŕ
	list = new TStringList;
	SplitString(list, name, separate);

	pnode = tree->TopItem;
	for(no = 0 ; no < list->Count ; no++) {
		// āAłɃm[h݂邩`FbN
		path = JoinString(list, separate, no);
		node = SearchNode(tree->TopItem, path);
		// ݂ĂȂΒǉ
		if(node == NULL) {
			index = iconFolder;
			if(text == "") {
				text = list->Strings[no];
				// IłȂ[{bNX
				if((flag & NMAIL_IMAP4_MAILBOX_NO_SELECT) != 0) {
					index = iconNoSelect;
				}
				if(no == 0) {
					if(!stricmp(text.c_str(), MailboxInbox)) {
						// INBOX
						text = MailboxTreeNameInbox;
						index = iconInbox;
					} else if(!stricmp(text.c_str(), MailboxSent)) {
						// M
						text = MailboxTreeNameSent;
						index = iconSent;
					} else if(!stricmp(text.c_str(), MailboxTrash)) {
						// S~
						text = MailboxTreeNameTrash;
						index = iconTrash;
					}
				}
			}
			// m[h̑}ʒu𓾂
			if(pnode != NULL) {
				ino = 0;
				while(ino < pnode->Count) {
					if(index < pnode->Item[ino]->ImageIndex) {
						break;
					}
					ino++;
				}
				if(ino < pnode->Count) {
					node = tree->Items->Insert(pnode->Item[ino], text);
				} else {
					node = tree->Items->AddChild(pnode, text);
				}
			} else {
				node = tree->Items->AddChild(NULL, text);
			}
			node->ImageIndex = index;
			node->SelectedIndex = index;
			bdata = new TMailBoxData;
			bdata->Path = path;
			bdata->Separate = separate;
			bdata->Flag = flag;
			node->Data = bdata;
		}
		pnode = node;
	}
	list->Free();
}

__fastcall TMainForm::TMainForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
// [{bNXIύX
void __fastcall TMainForm::MailBoxTreeChange(TObject *Sender,
      TTreeNode *Node)
{
	TMailBoxData *bdata = (TMailBoxData *)Node->Data;
	MailBox = bdata->Path;
	GetMailList();
}
//---------------------------------------------------------------------------
// [{bNXIO
void __fastcall TMainForm::MailBoxTreeChanging(TObject *Sender,
      TTreeNode *Node, bool &AllowChange)
{
	// IłȂtH_̏ꍇ͖
	if(Node->ImageIndex == iconNoSelect) {
		AllowChange = FALSE;
	}
}
//---------------------------------------------------------------------------
// [ꗗ̃hbOhbv
void __fastcall TMainForm::MailBoxTreeDragDrop(TObject *Sender,
      TObject *Source, int X, int Y)
{
	TTreeNode *node;
	TMailData *mdata;
	TMailBoxData *bdata;
	char msg[MAX_PATH];

    if(MailList == dynamic_cast<TListView *>(Source) && MailList->Selected != NULL) {
		node = MailBoxTree->GetNodeAt(X, Y);
		if(node != NULL) {
			// IMAP4 F
			if(Authenticate()) {
				mdata = (TMailData *)MailList->Selected->Data;
				bdata = (TMailBoxData *)node->Data;
				// [[{bNXɃRs[
				if(NMailImap4CopyMail(Socket, mdata->Uid, bdata->Path.c_str(), NMAIL_IMAP4_USE_UID) == NMAIL_SUCCESS) {
					// 猳̃[ɍ폜}[N
					if(NMailImap4DeleteMail(Socket, mdata->Uid, NMAIL_IMAP4_USE_UID) == NMAIL_SUCCESS) {
						// 烁[ꗗXV
						GetMailList();
					} else {
						// G[\
						NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
						MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
					}
				} else {
					// G[\
					NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
					MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
				}
			}
		}
	}
}
//---------------------------------------------------------------------------
// [ꗗ̃hbO
void __fastcall TMainForm::MailBoxTreeDragOver(TObject *Sender,
      TObject *Source, int X, int Y, TDragState State, bool &Accept)
{
	Accept = False;
    if(MailList == dynamic_cast<TListView *>(Source) && MailList->Selected != NULL) {
		TTreeNode *node;
		node = MailBoxTree->GetNodeAt(X, Y);
		if(node != NULL) {
			// hbvłtH_H
			if(node->ImageIndex > iconUser && node->ImageIndex < iconNoSelect) {
				Accept = True;
			}
		}
	}
}
//---------------------------------------------------------------------------
// [{bNXύX
void __fastcall TMainForm::MailBoxTreeEdited(TObject *Sender,
      TTreeNode *Node, AnsiString &S)
{
	TStringList *list;
	AnsiString path;
	TMailBoxData *bdata;
	char msg[MAX_PATH];

	// IMAP4 F
	if(Authenticate()) {
		// V[{bNX쐬
		list = new TStringList();
		bdata = (TMailBoxData *)Node->Data;
		SplitString(list, bdata->Path, bdata->Separate);
		path = JoinString(list, bdata->Separate, list->Count - 2);
		if(path != "") {
			path = path + bdata->Separate;
		}
		path += S;
		// [{bNXύX
		if(NMailImap4RenameMailBox(Socket, bdata->Path.c_str(), path.c_str()) == NMAIL_SUCCESS) {
			// Ȃq[{bNX̃f[^XV
			ChangeChildItemString(Node, bdata->Path, path, True);
		} else {
			// G[\
			NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
			MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
			// \ɖ߂
            S = Node->Text;
		}
		list->Free();
	}
}
//---------------------------------------------------------------------------
// [{bNXύXO
void __fastcall TMainForm::MailBoxTreeEditing(TObject *Sender,
      TTreeNode *Node, bool &AllowEdit)
{
	// ʏ̃[{bNXȊO͕ύXs
	if(Node->ImageIndex != iconFolder) {
		AllowEdit = False;
	}
}
//---------------------------------------------------------------------------
// [ꗗIύX
void __fastcall TMainForm::MailListChange(TObject *Sender, TListItem *Item,
      TItemChange Change)
{
	if(MailList->Selected != NULL) {
		// I΃|bvAbvj[L
		MailPopupMenu->AutoPopup = True;
	} else {
		// IȂ΃|bvAbvj[
		MailPopupMenu->AutoPopup = False;
		// {\̃NA
		BodyMemo->Lines->Clear();
		AttachList->Visible = False;
	}
}
//---------------------------------------------------------------------------
// [ꗗhbOhbvI
void __fastcall TMainForm::MailListEndDrag(TObject *Sender,
      TObject *Target, int X, int Y)
{
	DragFlag = False;
}
//---------------------------------------------------------------------------
// [ꗗ}EX
void __fastcall TMainForm::MailListMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
	if(Button == mbLeft) {
		// }EXWۑ
		DragX = X;
		DragY = Y;
	}
}
//---------------------------------------------------------------------------
// [ꗗ}EXړ
void __fastcall TMainForm::MailListMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
	if(DragX != -1) {
		// }EXȂ苗ړŃhbOJn
		if(abs(DragX - X) + abs(DragY - Y) > 5) {
			DragX = -1;
			DragFlag = True;
			MailList->BeginDrag(True);
		}
	}
}
//---------------------------------------------------------------------------
// [ꗗ}EXI
void __fastcall TMainForm::MailListMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
	if(Button == mbLeft) {
		if(!DragFlag) {
			DragX = -1;
			// [擾
			GetMail();
		}
	}
}
//---------------------------------------------------------------------------
// Ytt@Cꗗ_uNbN
void __fastcall TMainForm::AttachListDblClick(TObject *Sender)
{
	OpenAttachFile();
}
//---------------------------------------------------------------------------
// [쐬
void __fastcall TMainForm::CreateItemClick(TObject *Sender)
{
	int no, ret;
	AnsiString body;
	char msg[MAX_PATH];

	// ͗NA
	WriteForm->ToEdit->Text = "";
	WriteForm->SubjectEdit->Text = "";
	WriteForm->AttachEdit->Text = "";
	WriteForm->BodyMemo->Lines->Clear();
	// [̈e
	if(WriteForm->ShowModal() == mrOk) {
		SOCKET ss;
		int ret = NMAIL_ERROR;
        // ͓e body ɓ
        body = "";
        for(no = 0 ; no < WriteForm->BodyMemo->Lines->Count ; no++) {
            body = body + WriteForm->BodyMemo->Lines->Strings[no] + "\r\n";
        }
		// [M
       	if((ss = NMailSmtpConnectSsl(SmtpName.c_str(), SmtpPort, SmtpSsl, NULL)) != INVALID_SOCKET) {
			if(NMailSmtpAuthenticate(ss, SmtpName.c_str(), Id.c_str(), Password.c_str(), SmtpAuth) == NMAIL_SUCCESS) {
				if(FileExists(WriteForm->AttachEdit->Text)) {
					ret = NMailSmtpSendMailEx(ss, WriteForm->ToEdit->Text.c_str(), NULL, NULL, MailAddress.c_str(), WriteForm->SubjectEdit->Text.c_str(), body.c_str(), NULL, WriteForm->AttachEdit->Text.c_str(), NULL, 0);
				} else {
					ret = NMailSmtpSendMailEx(ss, WriteForm->ToEdit->Text.c_str(), NULL, NULL, MailAddress.c_str(), WriteForm->SubjectEdit->Text.c_str(), body.c_str(), NULL, NULL, NULL, 0);
				}
			}
			NMailSmtpClose(ss);
		}
		if(ret < 0) {
            NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, HEADER_MAX);
            MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
		}
	}
}
//---------------------------------------------------------------------------
// I
void __fastcall TMainForm::ExitItemClick(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
// ݒ
void __fastcall TMainForm::OptionItemClick(TObject *Sender)
{
	TFileName IniFileName;
	TIniFile *IniFile;

	//ݒ_CAOɐݒeZbg
	OptionForm->SmtpEdit->Text = SmtpName;
	OptionForm->SmtpPortEdit->Text = IntToStr(SmtpPort);
	OptionForm->SmtpSsl = SmtpSsl;
	OptionForm->SmtpAuth = SmtpAuth;
	OptionForm->Imap4Edit->Text = Imap4Name;
	OptionForm->Imap4PortEdit->Text = IntToStr(Imap4Port);
	OptionForm->Imap4Ssl = Imap4Ssl;
	OptionForm->Imap4Auth = Imap4Auth;
	OptionForm->MailEdit->Text = MailAddress;
	if(OptionForm->ShowModal() == mrOk) {
		// ݒeXV
		SmtpName = OptionForm->SmtpEdit->Text;
		SmtpPort = StrToInt(OptionForm->SmtpPortEdit->Text);
		SmtpSsl = OptionForm->SmtpSsl;
		SmtpAuth = OptionForm->SmtpAuth;
		Imap4Name = OptionForm->Imap4Edit->Text;
		Imap4Port = StrToInt(OptionForm->Imap4PortEdit->Text);
		Imap4Ssl = OptionForm->Imap4Ssl;
		Imap4Auth = OptionForm->Imap4Auth;
		MailAddress = OptionForm->MailEdit->Text;
		// bcbimap4.ini ɐݒeۑ
		IniFileName = ChangeFileExt(Application->ExeName, ".INI");
		IniFile = new TIniFile(IniFileName);
		try {
			IniFile->WriteString(OPTION_SECTION, OPTION_SMTP_NAME, SmtpName);
			IniFile->WriteInteger(OPTION_SECTION, OPTION_SMTP_PORT, SmtpPort);
			IniFile->WriteInteger(OPTION_SECTION, OPTION_SMTP_SSL, SmtpSsl);
			IniFile->WriteInteger(OPTION_SECTION, OPTION_SMTP_AUTH, SmtpAuth);
			IniFile->WriteString(OPTION_SECTION, OPTION_IMAP4_NAME, Imap4Name);
			IniFile->WriteInteger(OPTION_SECTION, OPTION_IMAP4_PORT, Imap4Port);
			IniFile->WriteInteger(OPTION_SECTION, OPTION_IMAP4_SSL, Imap4Ssl);
			IniFile->WriteInteger(OPTION_SECTION, OPTION_IMAP4_AUTH, Imap4Auth);
			IniFile->WriteString(OPTION_SECTION, OPTION_MAIL_ADDRESS, MailAddress);
		}
		catch (...) {
			delete IniFile;
		}
		delete IniFile;
	}
}
//---------------------------------------------------------------------------
// [{bNX쐬
void __fastcall TMainForm::CreateMailBoxItemClick(TObject *Sender)
{
	TTreeNode *node, *cnode;
	TMailBoxData *bdata, *mdata;
	AnsiString path;
	char msg[MAX_PATH];

	if(MailBoxTree->Selected != NULL) {
		node = MailBoxTree->Selected;
		bdata = (TMailBoxData *)node->Data;
		// q[{bNX쐬\H
		if((bdata->Flag & NMAIL_IMAP4_MAILBOX_NO_INFERIOUS) == 0) {
			// [{bNX̓
			NameForm->NameEdit->Text = "";
			if(NameForm->ShowModal() == mrOk) {
				if(NameForm->NameEdit->Text != "") {
					// IMAP4 F
					if(Authenticate()) {
						// 쐬郁[{bNX쐬
						if(bdata->Path == "") {
							path = NameForm->NameEdit->Text;
						} else {
							path = bdata->Path + bdata->Separate + NameForm->NameEdit->Text;
						}
						// [{bNX쐬
						if(NMailImap4CreateMailBox(Socket, path.c_str()) == NMAIL_SUCCESS) {
							// Ȃw
							NMailImap4SubscribeMailBox(Socket, path.c_str());
							// qm[h쐬
							cnode = MailBoxTree->Items->AddChild(node, NameForm->NameEdit->Text);
							cnode->ImageIndex = iconFolder;
							cnode->SelectedIndex = iconFolder;
							node->Expand(False);
							mdata = new TMailBoxData;
							mdata->Path = path;
							mdata->Separate = bdata->Separate;
							mdata->Flag = bdata->Flag;
							cnode->Data = mdata;
						} else {
							// G[\
							NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
							MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
						}
					}
				}
			}
		}
	}
}
//---------------------------------------------------------------------------
// [{bNXOύXJn
void __fastcall TMainForm::RenameMailBoxItemClick(TObject *Sender)
{
	MailBoxTree->Selected->EditText();
}
//---------------------------------------------------------------------------
// [{bNX폜
void __fastcall TMainForm::DeleteMailBoxItemClick(TObject *Sender)
{
	char msg[MAX_PATH];

    if(MessageDlg(MailBoxTree->Selected->Text + " 폜܂H", mtConfirmation, TMsgDlgButtons() << mbYes << mbNo, 0) == mrYes) {
		// IMAP4 F
    	if(Authenticate()) {
			// q[{bNX܂߂č폜
	    	if(DeleteChildMailBox(MailBoxTree->Selected, True)) {
				// Ȃm[h폜
		    	MailBoxTree->Items->Delete(MailBoxTree->Selected);
    		} else {
				// G[\
	    		NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
		    	MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
    		}
        }
    }
}
//---------------------------------------------------------------------------
// [ԐM
void __fastcall TMainForm::ReplyMailItemClick(TObject *Sender)
{
	int no, ret;
	AnsiString body;
	TMailData *mdata;
	char msg[MAX_PATH];

	// IĂ邩H
	if(MailList->Selected != NULL) {
		mdata = (TMailData *)MailList->Selected->Data;
		// ɍol Reply-To Ă
		if(NMailGetHeaderField(msg, mdata->Header.c_str(), "Reply-To:", MAX_PATH)) {
			WriteForm->ToEdit->Text = msg;
		} else {
			WriteForm->ToEdit->Text = MailList->Selected->SubItems->Strings[columnFrom - 1];
		}
		//  Re: ēĂ
		WriteForm->SubjectEdit->Text = "Re: " + MailList->Selected->SubItems->Strings[columnSubject - 1];
		WriteForm->BodyMemo->Lines->Clear();
		// [̈e
		if(WriteForm->ShowModal() == mrOk) {
			SOCKET ss;
			int ret = NMAIL_ERROR;
			// ͓e body ɓ
			body = "";
			for(no = 0 ; no < WriteForm->BodyMemo->Lines->Count ; no++) {
				body = body + WriteForm->BodyMemo->Lines->Strings[no] + "\r\n";
			}
			// [M
			if((ss = NMailSmtpConnectSsl(SmtpName.c_str(), SmtpPort, SmtpSsl, NULL)) != INVALID_SOCKET) {
				if(NMailSmtpAuthenticate(ss, SmtpName.c_str(), Id.c_str(), Password.c_str(), SmtpAuth) == NMAIL_SUCCESS) {
					if(FileExists(WriteForm->AttachEdit->Text)) {
						ret = NMailSmtpSendMailEx(ss, WriteForm->ToEdit->Text.c_str(), NULL, NULL, MailAddress.c_str(), WriteForm->SubjectEdit->Text.c_str(), body.c_str(), NULL, WriteForm->AttachEdit->Text.c_str(), NULL, 0);
					} else {
						ret = NMailSmtpSendMailEx(ss, WriteForm->ToEdit->Text.c_str(), NULL, NULL, MailAddress.c_str(), WriteForm->SubjectEdit->Text.c_str(), body.c_str(), NULL, NULL, NULL, 0);
					}
				}
				NMailSmtpClose(ss);
			}
			if(ret < 0) {
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, HEADER_MAX);
				MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
			}
		}
	}
}
//---------------------------------------------------------------------------
// [폜
void __fastcall TMainForm::DeleteMailItemClick(TObject *Sender)
{
	bool flag;
	char msg[MAX_PATH];
	TMailData *mdata;

	// IMAP4 F
	if(Authenticate()) {
		flag = True;
        mdata = (TMailData *)MailList->Selected->Data;
		// S~A݂̃[{bNXS~ȊOH
		if(TrashMailBox != "" && TrashMailBox != MailBox) {
			// [S~ɃRs[
			if(NMailImap4CopyMail(Socket, mdata->Uid, TrashMailBox.c_str(), NMAIL_IMAP4_USE_UID) != NMAIL_SUCCESS) {
				// G[\
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
				MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
				flag = False;
			}
		}
		if(flag) {
			// [ɍ폜}[N
			if(NMailImap4DeleteMail(Socket, mdata->Uid, NMAIL_IMAP4_USE_UID) == NMAIL_SUCCESS) {
				GetMailList();
			} else {
				// G[\
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
				MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
			}
		}
	}
}
//---------------------------------------------------------------------------
// [vpeB
void __fastcall TMainForm::PropertyMailItemClick(TObject *Sender)
{
	int no, count;
	int param_count, param_no;
	char name[HEADER_MAX];
	char value[HEADER_MAX];
	AnsiString path, text, param;
	TMailData *mdata;

	if(MailList->Selected != NULL) {
		// IMAP4 F
		if(Authenticate()) {
			if(NMailImap4SelectMailBox(Socket, MailBox.c_str(), False) >= 0) {
				mdata = (TMailData *)MailList->Selected->Data;
				// [wb_ݒ
				MimeListForm->HeaderMemo->Text = mdata->Header;
				MimeListForm->MimeTree->Items->Clear();
				// MIME \擾
				count = NMailImap4GetMimeStructure(Socket, mdata->Uid, NMAIL_IMAP4_USE_UID);
				if(count >= 0) {
					for(no = 0 ; no < count ; no++) {
						// MIME \擾
						NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_PART, no, 0, name, NULL, HEADER_MAX);
						path = name;
						// Content-Type ^CvƃTu^Cv쐬
						NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_TYPE_AND_SUBTYPE, no, 0, name, value, HEADER_MAX);
						text = name;
                        text += "/";
                        text += value;
                        text += ";";
                        // Content-Type p[^쐬
						param_count = NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_PARAMETER_COUNT, no, 0, NULL, NULL, 0);
						for(param_no = 0 ; param_no < param_count ; param_no++) {
							NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_PARAMETER, no, param_no, name, value, HEADER_MAX);
							param = name;
                            param += "=\"";
                            param += value;
                            param += "\"";
							if(param_no < param_count - 1) {
								param += "; ";
							}
							text += param;
						}
						// MIME \c[Ƀm[hǉ
						AddPath(MimeListForm->MimeTree, path, ".", 0, text);
					}
				}
				MimeListForm->MimeTree->FullExpand();
				// vpeB\
				MimeListForm->ShowModal();
			}
		}
	}
}
//---------------------------------------------------------------------------
// Ytt@CJ
void __fastcall TMainForm::OpenAttachItemClick(TObject *Sender)
{
	OpenAttachFile();
}
//---------------------------------------------------------------------------
// Ytt@Cۑ
void __fastcall TMainForm::SaveAttachItemClick(TObject *Sender)
{
	char temp[MAX_PATH];
	TMailData *mdata;

	// ۑt@C_CAO\
	SaveDialog->FileName = AttachList->Selected->Caption;
	if(SaveDialog->Execute()) {
		mdata = (TMailData *)MailList->Selected->Data;
		// MIME p[gۑ
		if(NMailImap4SaveMimePart(Socket, mdata->Uid, (int)AttachList->Selected->Data, SaveDialog->FileName.c_str(), temp, NMAIL_IMAP4_USE_UID | NMAIL_IMAP4_MIME_PART_SAVE_AS_FILE) == NMAIL_SUCCESS) {
            AnsiString msg = SaveDialog->FileName;
            msg += " ۑ܂";
			ShowMessage(msg.c_str());
		} else {
			// G[\
			NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, temp, MAX_PATH);
			MessageDlg(temp, mtError, TMsgDlgButtons() << mbOK, 0);
		}
	}
}

//---------------------------------------------------------------------------
// [ꗗ擾
void TMainForm::GetMailList()
{
	int no, count, flag;
    DWORD uid;
	char subject[HEADER_MAX];
	char date[HEADER_MAX];
	char from[HEADER_MAX];
	char header[HEADER_MAX];
	TListItem *item;
	TMailData *mdata;
	AnsiString str;
	// IMAP4 ݒ肨 ID & pX[h̃`FbN
	if(!CheckSetting()) {
		return;
	}
	// [{\NA
	BodyMemo->Lines->Clear();
	// ListView NA
	MailListDataClear();
	MailList->Items->Clear();
	// Ytt@Cꗗ
	AttachList->Visible = False;

	// [{bNXIĂȂΏI
	if(MailBox == "") {
		return;
	}

	// IMAP4 F
	if(Authenticate()) {
		// [{bNX̑I
		if(NMailImap4SelectMailBox(Socket, MailBox.c_str(), False) >= 0) {
			// [̈ꗗ UID 擾
			count = NMailImap4SearchMail(Socket, NMAIL_IMAP4_SEARCH_UNDELETED, NULL, NMAIL_IMAP4_USE_UID);
			if(count >= 0) {
				for(no = 0 ; no < count ; no++) {
					NMailImap4GetSearchMailResult(Socket, no, &uid);
					// ԂɃwb_̓eǂ݁AListView ɒǉ
					if(NMailImap4GetMailStatus(Socket, uid, subject, date, from, header, &flag, NMAIL_IMAP4_USE_UID) >= 0) {
						item = MailList->Items->Add();
						str = "";
						if(NMailImap4GetMimeStructure(Socket, uid, NMAIL_IMAP4_USE_UID) > 1) {
							str = "Y";
						}
						item->Caption = str;
						item->SubItems->Add(subject);
						item->SubItems->Add(from);
						item->SubItems->Add(date);
						mdata = new TMailData;
						mdata->Uid = uid;
						mdata->Flag = flag;
						mdata->Header = header;
						item->Data = mdata;
					}
				}
			} else {
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, subject, HEADER_MAX);
				MessageDlg(subject, mtError, TMsgDlgButtons() << mbOK, 0);
			}
		}
	}
}

//---------------------------------------------------------------------------
// [ꗗ̃f[^NA
void TMainForm::MailListDataClear()
{
	int no;
	for(no = 0 ; no < MailList->Items->Count ; no++) {
		delete MailList->Items->Item[no]->Data;
	}
}

//---------------------------------------------------------------------------
// IMAP4 F
bool TMainForm::Authenticate()
{
    bool ret = True;
	char msg[MAX_PATH];

    TimerCount = CONTINUE_TIMER_COUNT;
	// F؍ς݁H
	if(Socket == INVALID_SOCKET) {
        ret = False;
		// ڑĂȂΐڑ
		Socket = NMailImap4ConnectSsl(Imap4Name.c_str(), Imap4Port, Imap4Ssl, NULL);
		if(Socket != INVALID_SOCKET) {
			// IMAP4 F
			if(NMailImap4Authenticate(Socket, Id.c_str(), Password.c_str(), Imap4Auth) == NMAIL_SUCCESS) {
				return True;
			} else {
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
				MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
				Socket = INVALID_SOCKET;
			}
		}
	}
	return ret;
}

//---------------------------------------------------------------------------
// [e\
void TMainForm::GetMail()
{
	char name[HEADER_MAX];
	char value[HEADER_MAX];
	char *body;
	TMailData *mdata;
	int count, list_count, no, size;
	TListItem *item;
	SHFILEINFO sf;
	TIcon *icon;

	// IĂ邩H
	if(MailList->SelCount > 0) {
		// IMAP4 F
		if(Authenticate()) {
			if(NMailImap4SelectMailBox(Socket, MailBox.c_str(), False) >= 0) {
				mdata = (TMailData *)MailList->Selected->Data;
				AttachList->Items->Clear();
				AttachImageList->Clear();
				// MIME \擾
				count = NMailImap4GetMimeStructure(Socket, mdata->Uid, NMAIL_IMAP4_USE_UID);
				if(count >= 0) {
					list_count = 0;
					for(no = 0 ; no < count ; no++) {
						// Content-Type  SubType 擾
						NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_TYPE_AND_SUBTYPE, no, 0, name, value, HEADER_MAX);
						// {ȂΕ\
						if(!stricmp(name, "text") && !stricmp(value, "plain")) {
							// {TCY擾
							size = NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_SIZE, no, 0, NULL, NULL, 0);
							body = new char[size * 2];
							// {擾
							NMailImap4GetMimePart(Socket, mdata->Uid, no, body, NMAIL_IMAP4_USE_UID);
							// \p Memo NAĎMeǉB
							BodyMemo->Lines->Clear();
							BodyMemo->Lines->Add(body);
							// J[\擪Ɉړ
							BodyMemo->SelStart = 0;
							BodyMemo->SelLength = 0;
							// mۂJ
							delete body;
						} else if(stricmp(name, "multipart")) {
							// Ytt@CȂΓYtt@Cꗗɒǉ
							// t@C擾
							NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_FILE_NAME, no, 0, name, NULL, HEADER_MAX);
							if(!stricmp(name, "noname.html")) {
								lstrcpy(name, "{.html");
							}
							// ΉACR擾
							SHGetFileInfo(name, FILE_ATTRIBUTE_NORMAL, &sf, sizeof(sf), SHGFI_ICON | SHGFI_SMALLICON | SHGFI_USEFILEATTRIBUTES);
							// C[WXgɃACRǉ
							icon = new TIcon;
							icon->Handle = sf.hIcon;
							AttachImageList->AddIcon(icon);
							DestroyIcon(sf.hIcon);
							icon->Free();
							// Ytt@Cꗗɒǉ
							item = AttachList->Items->Add();
							item->Caption = name;
							item->ImageIndex = list_count;
							// MIME \̔ԍf[^Ƃĕۑ
							item->Data = (void *)no;
							list_count++;
						}
					}
					// Ytt@CΕ\
					if(list_count > 0) {
						AttachList->Visible = True;
					} else {
						AttachList->Visible = False;
					}
				}
			}
		}
	}
}

//---------------------------------------------------------------------------
// ݒ肨 ID  pX[h̓`FbN
bool TMainForm::CheckSetting()
{
	// IMAP4 ̐ݒ肪邩
	if(Imap4Name == "") {
		OptionItemClick(NULL);
		if(Imap4Name == NULL) {
			return False;
		}
	}
	if(Id == "" || Password == "") {
		// ID ƃpX[h
		if(InputForm->ShowModal() == mrOk) {
			Id = InputForm->IdEdit->Text;
			Password = InputForm->PasswordEdit->Text;
		} else {
			return False;
		}
	}
	// c[\Ȃ΃[{bNXXg
	// 擾ăc[\
	if(MailBoxTree->TopItem == NULL) {
		GetMailBoxTree();
	}
	return True;
}

//---------------------------------------------------------------------------
// Ytt@CJ
void TMainForm::OpenAttachFile()
{
	TMailData *mdata;
	char path[MAX_PATH];
	char temp[MAX_PATH];

	if(AttachList->Selected != NULL) {
		// IMAP4 F
		if(Authenticate()) {
			// e|tH_擾
			GetTempPath(MAX_PATH, path);
			lstrcat(path, AttachList->Selected->Caption.c_str());
			mdata = (TMailData *)MailList->Selected->Data;
			// MIME p[gۑ
			if(NMailImap4SaveMimePart(Socket, mdata->Uid, (int)AttachList->Selected->Data, path, temp, NMAIL_IMAP4_USE_UID | NMAIL_IMAP4_MIME_PART_SAVE_AS_FILE) == NMAIL_SUCCESS) {
				// ۑt@CN
				ShellExecute(Handle, "open", path, NULL, NULL, SW_SHOW);
			} else {
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, temp, MAX_PATH);
				MessageDlg(temp, mtError, TMsgDlgButtons() << mbOK, 0);
			}
		}
	}
}

//---------------------------------------------------------------------------
// [{bNXꗗ擾
void TMainForm::GetMailBoxTree()
{
	int no, count, flag;
	TTreeNode *node;
	char separate[2];
	char name[HEADER_MAX];
	TMailBoxData *bdata;

	MailBoxTree->Items->Clear();
	node = MailBoxTree->Items->Add(NULL, MailAddress);
	node->ImageIndex = iconUser;
	node->SelectedIndex = iconUser;
	// IMAP4 F
	if(Authenticate()) {
		// [{bNXꗗ擾
		count = NMailImap4GetMailBoxList(Socket, "", "*", False);
		for(no = 0 ; no < count ; no++) {
			// [{bNX擾
			NMailImap4GetMailBoxListStatus(Socket, no, &flag, separate, name, HEADER_MAX);
			if(!stricmp(name, MailboxSent)) {
				// M
				SentMailBox = name;
			} else if(!stricmp(name, MailboxTrash)) {
				// S~
				TrashMailBox = name;
			}
			if(node->Data == NULL) {
				// [AhXm[hɃ_~[̃f[^i[
				bdata = new TMailBoxData;
				bdata->Path = "";
				bdata->Separate = separate;
				bdata->Flag = 0;
				node->Data = bdata;
			}
			// [{bNXm[hǉ
			AddPath(MailBoxTree, name, separate, flag, "");
		}
		MailBoxTree->Selected = SearchNode(MailBoxTree->TopItem, MailBox);
		MailBoxTree->FullExpand();
	}
}

//---------------------------------------------------------------------------
// m[hɕۑĂ郁[{bNXXV
void TMainForm::ChangeChildItemString(TTreeNode *node, AnsiString old_path, AnsiString new_path, bool flag)
{
	TMailBoxData *bdata;

	while(node != NULL) {
		if(node->Data != NULL) {
			bdata = (TMailBoxData *)node->Data;
			if(CompareText(bdata->Path.SubString(1, old_path.Length()), old_path) == 0) {
				bdata->Path = new_path + bdata->Path.SubString(old_path.Length() + 1, bdata->Path.Length());
			}
		}
		ChangeChildItemString(node->getFirstChild(), old_path, new_path, False);
		if(flag) {
			break;
		}
		node = node->getNextSibling();
	}
}

//---------------------------------------------------------------------------
// Mσ[{bNXɊi[
void TMainForm::AppendSent(AnsiString tostr, AnsiString subject, AnsiString body, AnsiString attach)
{
	AnsiString header;
	char msg[MAX_PATH];

	if(SentMailBox != "") {
		// IMAP4 F
		if(Authenticate()) {
			// wb_[ɐݒ
			header = "Subject: " + subject + "\r\n";
			// M҂wb_[ɕt
			header += "From: " + MailAddress + "\r\n";
			// Mwb_[ɕt
			header += "To: " + tostr + "\r\n";
			// [Abv[h
			//  Messsage-ID  nMail.DLL ŕt
			// Mime-Version, Content-Type, Content-Transfer-Encoding ͎Iɕt܂
			if(NMailImap4AppendMail(Socket, SentMailBox.c_str(), header.c_str(), body.c_str(), attach.c_str(), 0, NULL, NMAIL_ADD_DATE_FIELD | NMAIL_ADD_MESSAGEID_FIELD) == NMAIL_SUCCESS) {
				if(MailBox == SentMailBox) {
					GetMailList();
				}
			} else {
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
				MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
			}
		}
	}
}

//---------------------------------------------------------------------------
// q[{bNX폜
bool TMainForm::DeleteChildMailBox(TTreeNode *node, bool flag)
{
	TMailBoxData *mdata;
	while(node != NULL) {
		if(!DeleteChildMailBox(node->getFirstChild(), False)) {
			return False;
		}
		if(node->Data != NULL) {
			mdata = (TMailBoxData *)node->Data;
			if(NMailImap4DeleteMailBox(Socket, mdata->Path.c_str()) == NMAIL_SUCCESS) {
				NMailImap4UnsubscribeMailBox(Socket, mdata->Path.c_str());
				delete node->Data;
			} else {
				return False;
			}
		}
		if(flag) {
			break;
		}
		node = node->getNextSibling();
	}
	return True;
}

//---------------------------------------------------------------------------
// I
void __fastcall TMainForm::FormClose(TObject *Sender, TCloseAction &Action)
{
    if(Socket != INVALID_SOCKET) {
		NMailImap4Close(Socket);
	}
    // Winsock gpI
    NMailEndWinSock();
}

//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
	int w;
	TFileName IniFileName;
	TIniFile *IniFile;

    IniFileName = ChangeFileExt(Application->ExeName, ".INI");
    IniFile = new TIniFile(IniFileName);
    try {
        SmtpName = IniFile->ReadString(OPTION_SECTION, OPTION_SMTP_NAME, "");
        SmtpPort = IniFile->ReadInteger(OPTION_SECTION, OPTION_SMTP_PORT, NMAIL_SMTP_PORT);
        SmtpSsl = IniFile->ReadInteger(OPTION_SECTION, OPTION_SMTP_SSL, 0);
        SmtpAuth = IniFile->ReadInteger(OPTION_SECTION, OPTION_SMTP_AUTH, 0);
        Imap4Name = IniFile->ReadString(OPTION_SECTION, OPTION_IMAP4_NAME, "");
        Imap4Port = IniFile->ReadInteger(OPTION_SECTION, OPTION_IMAP4_PORT, NMAIL_IMAP4_PORT);
        Imap4Ssl = IniFile->ReadInteger(OPTION_SECTION, OPTION_IMAP4_SSL, 0);
        Imap4Auth = IniFile->ReadInteger(OPTION_SECTION, OPTION_IMAP4_AUTH, NMAIL_IMAP4_AUTH_LOGIN);
        MailAddress = IniFile->ReadString(OPTION_SECTION, OPTION_MAIL_ADDRESS, "");
    }
    catch ( ... ) {
        delete IniFile;
    }
    delete IniFile;

    // ListView ̍ڕݒ
    w = MailList->ClientWidth - GetSystemMetrics(SM_CXVSCROLL);
    MailList->Columns->Items[columnAttach]->Width = 16;
    w = w - 16;
    MailList->Columns->Items[columnSubject]->Width = w / 2;
    MailList->Columns->Items[columnFrom]->Width = w / 4;
    MailList->Columns->Items[columnDate]->Width = w / 4;

    // Winsock 
    NMailInitializeWinSock();

    // ^CAEg̓ftHg(30b)
    // wb_ől 8192
    // {ől͖
    //NMailSetParameter(0, HEADER_MAX, 0);
    NMailSetOption(NMAIL_OPTION_HEADER_MAX, HEADER_MAX);

    // \Pbgϐ
    Socket = INVALID_SOCKET;

    MailBox = "INBOX";
    DragX = -1;
    DragFlag = False;

    TimerCount = 0;
}

//---------------------------------------------------------------------------
void __fastcall TMainForm::FormActivate(TObject *Sender)
{
    // [ꗗ擾
    GetMailList();
}

//---------------------------------------------------------------------------
// [{bNXꗗł̃}EX
void __fastcall TMainForm::MailBoxTreeMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
	TTreeNode *node;
	TMailBoxData *bdata;

	if(Button == mbRight) {
        MailBoxPopupMenu->AutoPopup = False;
		node = MailBoxTree->GetNodeAt(X, Y);
		if(node != NULL) {
            MailBoxTree->Selected = node;
			bdata = (TMailBoxData *)node->Data;
			if(node->ImageIndex != iconNoSelect) {
				// I\ȃ[{bNXł
				// |bvAbvj[L
				MailBoxTree->Selected = node;
				DeleteMailBoxItem->Enabled = False;
				RenameMailBoxItem->Enabled = False;
				if(node->ImageIndex == iconFolder) {
					if((bdata->Flag & NMAIL_IMAP4_MAILBOX_NO_INFERIOUS) == 0) {
						CreateMailBoxItem->Enabled = True;
					}
					DeleteMailBoxItem->Enabled = True;
					RenameMailBoxItem->Enabled = True;
				}
				MailBoxPopupMenu->AutoPopup = True;
			}
        }
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::AttachListChange(TObject *Sender,
      TListItem *Item, TItemChange Change)
{
	if(AttachList->Selected != NULL) {
		// I΃|bvAbvj[L
		AttachPopupMenu->AutoPopup = True;
	} else {
		// IȂ΃|bvAbvj[
		AttachPopupMenu->AutoPopup = False;
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::NoopTimerTimer(TObject *Sender)
{
    if(TimerCount > 0) {
        TimerCount--;
        if(TimerCount == 0 && Socket != INVALID_SOCKET) {
            if(NMailImap4NoOperation(Socket) == NMAIL_SUCCESS) {
                TimerCount = CONTINUE_TIMER_COUNT;
            } else {
                NMailImap4Close(Socket);
                Socket = INVALID_SOCKET;
            }
        }
    }
}
//---------------------------------------------------------------------------

