#pragma once

class CTreeDropTarget :public COleDropTarget
{
	public:
		CWnd *m_parent;
		static CWnd *m_swnd;
		virtual DROPEFFECT OnDragEnter(CWnd *pWnd, COleDataObject *pDataObject, DWORD dwKeyState, CPoint point);
		virtual DROPEFFECT OnDragOver(CWnd *pWnd, COleDataObject *pDataObject, DWORD dwKeyState, CPoint point);
		virtual void OnDragLeave(CWnd *pWnd);
		virtual BOOL OnDrop(CWnd *pWnd, COleDataObject *pDataObject, DROPEFFECT dropEffect, CPoint point);
		BOOL CheckDrag(CWnd *pWnd, COleDataObject *pDataObject, CPoint point);
		CTreeDropTarget();
};

// CTreeEx
struct TreeItemData {
	CString name;
	CString separate;
	int flag;
};

class CTreeEx : public CTreeCtrl
{
	DECLARE_DYNAMIC(CTreeEx)

public:
	CTreeDropTarget m_tree_drop;
	CString GetFolderSeparate(HTREEITEM ht);
	int GetFolderFlag(CString name);
	int GetFolderFlag(HTREEITEM ht);
	void SelectFolder(CString name);
	void SetItemString(HTREEITEM ht, CString name, CString separate, int flag);
	void ChangeChildItemString(HTREEITEM ht, CString old_name, CString new_name);
	void ChangeItemString(CString old_folder, CString new_folder);
	CString GetFolderName(HTREEITEM ht);
	HTREEITEM SearchItem(HTREEITEM ht, CString name);
	HTREEITEM NameToItem(CString name);
	void AddPathItem(CString name, CString separate, int flag, CString text = _T(""));
	void ReleaseItemData(HTREEITEM ht);
	void ReleaseAllItemData();

	CTreeEx();
	virtual ~CTreeEx();

protected:
	afx_msg void OnKeydown(NMHDR* pNMHDR, LRESULT* pResult);

	DECLARE_MESSAGE_MAP()
};


