// TreeEx.cpp : t@C
//

#include "stdafx.h"
#include "Vcnetimap4.h"
#include "TreeEx.h"

#include "StrSplit.h"

#include "nMail.h"

CWnd *CTreeDropTarget::m_swnd = NULL;

//
//	hbOhbvp OLE NX
//
CTreeDropTarget::CTreeDropTarget()
{
}

//
//	hbvł邩ǂ̔
//
BOOL CTreeDropTarget::CheckDrag(CWnd *pWnd, COleDataObject *pDataObject, CPoint point)
{
	if(pDataObject->IsDataAvailable(CF_TEXT) && m_swnd != NULL) {
		CTreeEx *tree = (CTreeEx *)pWnd;
		HTREEITEM ht = tree->HitTest(point);
		if(ht != NULL) {
			CString name = tree->GetFolderName(ht);
			if(name.IsEmpty() || (tree->GetFolderFlag(ht) & NMAIL_IMAP4_MAILBOX_NO_SELECT)) {
				return FALSE;
			}
		}
		return TRUE;
	}
	return FALSE;
}

//
//	^[QbgEChEɓĂۂ̏
//
DROPEFFECT CTreeDropTarget::OnDragEnter(CWnd *pWnd, COleDataObject *pDataObject, DWORD dwKeyState, CPoint point)
{
	DROPEFFECT dropeffectRet = DROPEFFECT_NONE;
	if(CheckDrag(pWnd, pDataObject, point)) {
		if(m_swnd != NULL) {
			dropeffectRet = DROPEFFECT_MOVE;
		}
	}
	return dropeffectRet;
}

//
//	^[QbgEChEňړ
//
DROPEFFECT CTreeDropTarget::OnDragOver(CWnd *pWnd, COleDataObject *pDataObject, DWORD dwKeyState, CPoint point)
{
	DROPEFFECT dropeffectRet = DROPEFFECT_NONE;
	if(CheckDrag(pWnd, pDataObject, point)) {
		CTreeEx *tree = (CTreeEx *)pWnd;
		HTREEITEM ht = tree->HitTest(point);
		if(ht != NULL) {
			if(m_swnd != NULL) {
				dropeffectRet = DROPEFFECT_MOVE;
			}
			tree->SelectDropTarget(ht);
		}
	}
	return dropeffectRet;
}

//
//	^[QbgEChEoۂ̏
//
void CTreeDropTarget::OnDragLeave(CWnd* pWnd)
{
	CTreeEx *tree;
	tree = (CTreeEx *)pWnd;
	tree->SelectDropTarget(NULL);

	COleDropTarget:: OnDragLeave(pWnd);
}

//
//	hbvꂽۂ̏
//
BOOL CTreeDropTarget::OnDrop(CWnd *pWnd, COleDataObject *pDataObject, DROPEFFECT dropEffect, CPoint point)
{
	if(CheckDrag(pWnd, pDataObject, point)) {
		CTreeEx *tree = (CTreeEx *)pWnd;

		HGLOBAL hglb = pDataObject->GetGlobalData(CF_TEXT);
		TCHAR *ptr = (TCHAR *)GlobalLock(hglb);
		GlobalUnlock(hglb);

		if(!DragDropText.Compare(ptr)) {
			HTREEITEM htsrc = tree->GetSelectedItem();
			HTREEITEM htdst = tree->GetDropHilightItem();
			tree->SelectDropTarget(NULL);
			if(htsrc != htdst) {
				if(m_parent != NULL) {
					if(m_parent->SendMessage(WM_COPY_MAILBOX, (WPARAM)htdst)) {
						tree->GetParent()->PostMessage(WM_COMMAND, IDM_READ);
						return TRUE;
					}
				}
			}
		}
	}
	return FALSE;
}

// CTreeEx

IMPLEMENT_DYNAMIC(CTreeEx, CTreeCtrl)
CTreeEx::CTreeEx()
{
}

CTreeEx::~CTreeEx()
{
}


BEGIN_MESSAGE_MAP(CTreeEx, CTreeCtrl)
	ON_NOTIFY_REFLECT(TVN_KEYDOWN, OnKeydown)
END_MESSAGE_MAP()



// CTreeEx bZ[W nh
//
//	tpXɓK؂ȈʒuɃACe𐶐
//
void CTreeEx::AddPathItem(CString name, CString separate, int flag, CString text)
{
	CString path;
	HTREEITEM item, pitem;
	int no, add;
	CStrSplit sp(name, separate);

	pitem = GetRootItem();
	for(no = 0 ; no < sp.GetSize() ; no++) {
		path = sp[0];
		for(add = 1 ; add <= no ; add++) {
			path += separate + sp[add];
		}
		if((item = NameToItem(path)) == NULL) {
			CString folder = sp[no];
			if(text.IsEmpty()) {
				int index = iconFolder;
				if(flag & NMAIL_IMAP4_MAILBOX_NO_SELECT) {
					index = iconNoSelect;
				}
				if(no == 0) {
					if(!_tcsicmp(folder, MailboxInbox)) {
						folder = MailboxTreeNameInbox;
						index = iconInbox;
					} else if(!_tcsicmp(folder, MailboxTrash)) {
						folder = MailboxTreeNameTrash;
						index = iconTrash;
					} else if(!_tcsicmp(folder, MailboxSent)) {
						folder = MailboxTreeNameSent;
						index = iconSent;
					}
				}
				item = GetChildItem(pitem);
				while(item != NULL) {
					int image, select;
					GetItemImage(item, image, select);
					if(index < image)
					{
						item = GetPrevSiblingItem(item);
						if(item == NULL) {
							item = TVI_FIRST;
						}
						break;
					}
					item = GetNextSiblingItem(item);
				}
				item = InsertItem(folder, index, index, pitem, item);
			} else {
				item = InsertItem(text, 0, 0, pitem, item);
			}
			if(item != NULL) {
				SetItemString(item, path, separate, flag);
			}
			Expand(pitem, TVE_EXPAND);
		} else {
			if(name == GetFolderName(item) && flag != GetFolderFlag(item)) {
				if(flag & NMAIL_IMAP4_MAILBOX_NO_SELECT) {
					SetItemImage(item, iconNoSelect, iconNoSelect);
				}
				SetItemString(item, name, separate, flag);
			}
		}
		pitem = item;
	}
}

//
//	tpXɑΉACenh
//
HTREEITEM CTreeEx::SearchItem(HTREEITEM ht, CString name)
{
	HTREEITEM htc;

	while(ht != NULL) {
		if(GetFolderName(ht) == name) {
			return ht;
		}
		htc = GetChildItem(ht);
		if(htc != NULL) {
			htc = SearchItem(htc, name);
			if(htc != NULL) {
				return htc;
			}
		}
		ht = GetNextSiblingItem(ht);
	}
	return NULL;
}

//
//	tpXɑΉACenh擾
//
HTREEITEM CTreeEx::NameToItem(CString name)
{
	return SearchItem(GetRootItem(), name);
}

//
//	݂̃tpX擾
//
CString CTreeEx::GetFolderName(HTREEITEM ht)
{
	TreeItemData *item = reinterpret_cast<TreeItemData *>(GetItemData(ht));
	if(item != NULL) {
		return item->name;
	}
	return _T("");
}

//
//	tH_ύXɂȂۂɁAqACẽtpXύX
//	ċAőSĂ̎qACeύX
//
void CTreeEx::ChangeChildItemString(HTREEITEM ht, CString old_name, CString new_name)
{
	HTREEITEM htc;

	while(ht != NULL) {
		CString name = GetFolderName(ht);
		CString separate = GetFolderSeparate(ht);
		int folder_flag = GetFolderFlag(ht);

		if(name.Left(old_name.GetLength()) == old_name) {
			name = new_name + name.Mid(old_name.GetLength());
			SetItemString(ht, name, separate, folder_flag);
		}
		htc = GetChildItem(ht);
		if(htc != NULL) {
			ChangeChildItemString(htc, old_name, new_name);
		}
		ht = GetNextSiblingItem(ht);
	}
}

//
//	tH_ύXɂȂۂɁAqACẽtpXύX
//
void CTreeEx::ChangeItemString(CString old_name, CString new_name)
{
	HTREEITEM ht = NameToItem(old_name);
	if(ht != NULL) {
		CString separate = GetFolderSeparate(ht);
		int folder_flag = GetFolderFlag(ht);

		SetItemString(ht, new_name, separate, folder_flag);

		ChangeChildItemString(GetChildItem(ht), old_name, new_name);
	}
}

//
//	ċAɂSẴACẽf[^폜
//
void CTreeEx::ReleaseItemData(HTREEITEM ht)
{
	HTREEITEM htc;
	TreeItemData *item;

	while(ht != NULL) {
		if((item = reinterpret_cast<TreeItemData *>(GetItemData(ht))) != NULL) {
			delete item;
			SetItemData(ht, (DWORD)NULL);
		}
		htc = GetChildItem(ht);
		if(htc != NULL) {
			ReleaseItemData(htc);
		}
		ht = GetNextSiblingItem(ht);
	}
}

//
//	SẴACẽf[^폜
//
void CTreeEx::ReleaseAllItemData()
{
	HTREEITEM ht = GetRootItem();
	while(ht != NULL) {
		ReleaseItemData(ht);
		ht = GetNextItem(ht, TVGN_NEXT);
	}
}

//
//	tpXZbg
//
void CTreeEx::SetItemString(HTREEITEM ht, CString name, CString separate, int flag)
{
	TreeItemData *item;

	if((item = reinterpret_cast<TreeItemData *>(GetItemData(ht))) != NULL) {
		delete item;
	}
	item = new TreeItemData;
	item->name = name;
	item->separate = separate;
	item->flag = flag;
	SetItemData(ht, reinterpret_cast<DWORD_PTR>(item));
}

//
//	tpXɉACeI
//
void CTreeEx::SelectFolder(CString name)
{
	HTREEITEM ht = NameToItem(name);
	if(ht != NULL) {
		SelectItem(ht);
	}
}

//
//	tpXɉtO擾
//
int CTreeEx::GetFolderFlag(CString name)
{
	return GetFolderFlag(NameToItem(name));
}

//
//	ACẽf[^񂩂tO擾
//
int CTreeEx::GetFolderFlag(HTREEITEM ht)
{
	if(ht != NULL) {
		TreeItemData *item = reinterpret_cast<TreeItemData *>(GetItemData(ht));
		if(item != NULL) {
			return item->flag;
		}
	}
	return 0;
}

//
//	ACẽf[^񂩂番擾
//
CString CTreeEx::GetFolderSeparate(HTREEITEM ht)
{
	if(ht != NULL) {
		TreeItemData *item = reinterpret_cast<TreeItemData *>(GetItemData(ht));
		if(item != NULL) {
			return item->separate;
		}
	}
	return _T("");
}

//
//	F2 ŖOύXJn
//
void CTreeEx::OnKeydown(NMHDR* pNMHDR, LRESULT* pResult)
{
	TV_KEYDOWN* pTVKeyDown = (TV_KEYDOWN*)pNMHDR;

	if(pTVKeyDown->wVKey == VK_F2){
		GetParent()->SendMessage(WM_COMMAND, IDM_RENAME_MAILBOX);
	}
	*pResult = 0;
}

