//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <IniFiles.hpp>
#include <Classes.hpp>

#include "TestMain.h"
#include "Write.h"
#include "Input.h"
#include "Option.h"
#include "Unite.h"

#include "nMail.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
    int w;

    // ListView ̍ڕݒ
    w = MailListView->ClientWidth;
    MailListView->Columns->Items[0]->Width = w / 2;
    MailListView->Columns->Items[1]->Width = w / 4;
    MailListView->Columns->Items[2]->Width = w / 4;

    // Winsock 
    NMailInitializeWinSock();

    // ^CAEg̓ftHg(30b)
    // wb_ől 8192
    // {ől͖
    //NMailSetParameter(0, HEADER_MAX, 0);
    NMailSetOption(NMAIL_OPTION_HEADER_MAX, HEADER_MAX);

    PostMessage(Handle, WM_START_APP, 0, 0);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormClose(TObject *Sender, TCloseAction &Action)
{
    // Winsock gpI
    NMailEndWinSock();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::WMStartApp(TMessage& Message)
{
    mRenewalClick(NULL);
}

void __fastcall TMainForm::mCreateClick(TObject *Sender)
{
    int no, ret;
    AnsiString body;
    char msg[HEADER_MAX];

    // ͗NA
    WriteForm->ToEdit->Text = "";
    WriteForm->SubjectEdit->Text = "";
    WriteForm->BodyMemo->Lines->Clear();
    // [̈e
    if (WriteForm->ShowModal() == mrOk) {
		SOCKET ss;
		int ret = NMAIL_ERROR;
        // ͓e body ɓ
        body = "";
        for(no = 0 ; no < WriteForm->BodyMemo->Lines->Count ; no++) {
            body = body + WriteForm->BodyMemo->Lines->Strings[no] + "\r\n";
        }
		// [M
       	if((ss = NMailSmtpConnectSsl(SmtpName.c_str(), SmtpPort, SmtpSsl, NULL)) != INVALID_SOCKET) {
			if(NMailSmtpAuthenticate(ss, SmtpName.c_str(), Id.c_str(), Password.c_str(), SmtpAuth) == NMAIL_SUCCESS) {
				if(FileExists(WriteForm->AttachEdit->Text)) {
					ret = NMailSmtpSendMailEx(ss, WriteForm->ToEdit->Text.c_str(), NULL, NULL, MailAddress.c_str(), WriteForm->SubjectEdit->Text.c_str(), body.c_str(), NULL, WriteForm->AttachEdit->Text.c_str(), NULL, 0);
				} else {
					ret = NMailSmtpSendMailEx(ss, WriteForm->ToEdit->Text.c_str(), NULL, NULL, MailAddress.c_str(), WriteForm->SubjectEdit->Text.c_str(), body.c_str(), NULL, NULL, NULL, 0);
				}
			}
			NMailSmtpClose(ss);
		}
		if(ret < 0) {
            NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, HEADER_MAX);
            MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
		}
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::mRenewalClick(TObject *Sender)
{
    ReadIni();
    // ݒ肪ĂȂꍇ͐ݒ_CAO\
    if(Pop3Name == "") {
        mSettingClick(Sender);
    }
    // 薼ꗗǂݍ
    AddMailList();
}

//---------------------------------------------------------------------------

void __fastcall TMainForm::mExitClick(TObject *Sender)
{
    Close();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::mSettingClick(TObject *Sender)
{
    TFileName IniFileName;
    TIniFile *IniFile;

    //ݒ_CAOɐݒeZbg
    OptionForm->SmtpEdit->Text = SmtpName;
    OptionForm->SmtpPortEdit->Text = IntToStr(SmtpPort);
    OptionForm->SmtpSsl = SmtpSsl;
    OptionForm->SmtpAuth = SmtpAuth;
    OptionForm->Pop3Edit->Text = Pop3Name;
    OptionForm->Pop3PortEdit->Text = IntToStr(Pop3Port);
    OptionForm->Pop3Ssl = Pop3Ssl;
    OptionForm->MailEdit->Text = MailAddress;
    if(OptionForm->ShowModal() == mrOk) {
        // ݒeXV
        SmtpName = OptionForm->SmtpEdit->Text;
        SmtpPort = StrToInt(OptionForm->SmtpPortEdit->Text);
        SmtpAuth = OptionForm->SmtpAuth;
        SmtpSsl = OptionForm->SmtpSsl;
        Pop3Name = OptionForm->Pop3Edit->Text;
        Pop3Port = StrToInt(OptionForm->Pop3PortEdit->Text);
        Pop3Ssl = OptionForm->Pop3Ssl;
        MailAddress = OptionForm->MailEdit->Text;
        APopFlag = OptionForm->ApopCheck->Checked;
        // bcbmail.ini ɐݒeۑ
        IniFileName = ChangeFileExt(Application->ExeName, ".INI");
        IniFile = new TIniFile(IniFileName);
        try {
            IniFile->WriteString(OPTION_SECTION, OPTION_SMTP_NAME, SmtpName);
            IniFile->WriteInteger(OPTION_SECTION, OPTION_SMTP_PORT, SmtpPort);
            IniFile->WriteInteger(OPTION_SECTION, OPTION_SMTP_AUTH, SmtpAuth);
            IniFile->WriteInteger(OPTION_SECTION, OPTION_SMTP_SSL, SmtpSsl);
            IniFile->WriteString(OPTION_SECTION, OPTION_POP3_NAME, Pop3Name);
            IniFile->WriteInteger(OPTION_SECTION, OPTION_POP3_PORT, Pop3Port);
            IniFile->WriteInteger(OPTION_SECTION, OPTION_POP3_SSL, Pop3Ssl);
            IniFile->WriteString(OPTION_SECTION, OPTION_MAIL_ADDRESS, MailAddress);
            IniFile->WriteBool(OPTION_SECTION, OPTION_APOP_FLAG, APopFlag);
        }
        catch (...) {
            delete IniFile;
        }
        delete IniFile;
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::mPopupReplyClick(TObject *Sender)
{
    int no, ret;
    char msg[HEADER_MAX];
    AnsiString body;

    // IĂ邩H
    if(MailListView->SelCount > 0) {
        // ɍol Reply-To Ă
        if(NMailGetHeaderField(msg, (char *)MailListView->Selected->Data, "Reply-To:", HEADER_MAX)) {
            WriteForm->ToEdit->Text = msg;
        } else {
            WriteForm->ToEdit->Text = MailListView->Selected->SubItems->Strings[1];
        }
        // ͗NA
        if(NMailGetHeaderField(msg, (char *)MailListView->Selected->Data, "Subject:", HEADER_MAX)) {
            WriteForm->SubjectEdit->Text = "Re: " + (AnsiString)msg;
        } else {
            WriteForm->SubjectEdit->Text = "";
        }
        WriteForm->BodyMemo->Lines->Clear();
        // [̈e
        if(WriteForm->ShowModal() == mrOk) {
			SOCKET ss;
			int ret = NMAIL_ERROR;
			// ͓e body ɓ
			body = "";
			for(no = 0 ; no < WriteForm->BodyMemo->Lines->Count ; no++) {
				body = body + WriteForm->BodyMemo->Lines->Strings[no] + "\r\n";
			}
			// [M
			if((ss = NMailSmtpConnectSsl(SmtpName.c_str(), SmtpPort, SmtpSsl, NULL)) != INVALID_SOCKET) {
				if(NMailSmtpAuthenticate(ss, SmtpName.c_str(), Id.c_str(), Password.c_str(), SmtpAuth) == NMAIL_SUCCESS) {
					if(FileExists(WriteForm->AttachEdit->Text)) {
						ret = NMailSmtpSendMailEx(ss, WriteForm->ToEdit->Text.c_str(), NULL, NULL, MailAddress.c_str(), WriteForm->SubjectEdit->Text.c_str(), body.c_str(), NULL, WriteForm->AttachEdit->Text.c_str(), NULL, 0);
					} else {
						ret = NMailSmtpSendMailEx(ss, WriteForm->ToEdit->Text.c_str(), NULL, NULL, MailAddress.c_str(), WriteForm->SubjectEdit->Text.c_str(), body.c_str(), NULL, NULL, NULL, 0);
					}
				}
				NMailSmtpClose(ss);
			}
			if(ret < 0) {
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, HEADER_MAX);
				MessageDlg(msg, mtError, TMsgDlgButtons() << mbOK, 0);
			}
        }
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::mPopupDeleteClick(TObject *Sender)
{
    // IĂ邩H
    if(MailListView->SelCount > 0) {
        // POP3 T[o[ɐڑ
        SOCKET S;
        if((S = NMailPop3ConnectSsl(Pop3Name.c_str(), Pop3Port, Pop3Ssl, NULL)) != INVALID_SOCKET) {
            // [IԍH
            if(MailListView->Selected->Index < NMailPop3Authenticate(S, Id.c_str(), Password.c_str(), APopFlag)) {
                // [폜
                NMailPop3DeleteMail(S, MailListView->Selected->Index + 1);
            }
            // ڑI
            NMailPop3Close(S);
        }
    }
    // 薼ꗗ\
    AddMailList();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormResize(TObject *Sender)
{
    int w;

    // Form ̃TCYύXŁAListView ̍ڕύX
    w = MailListView->ClientWidth;
    MailListView->Columns->Items[0]->Width = w / 2;
    MailListView->Columns->Items[1]->Width = w / 4;
    MailListView->Columns->Items[2]->Width = w / 4;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::MailListViewMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    TPoint p;

    // ENbNȂ|bvAbvj[\
    if(Button == mbRight) {
        p = ClientToScreen(Point(X, Y));
        PopupMenu->Popup(p.x, p.y);

    }
}
//---------------------------------------------------------------------------
void TMainForm::HeaderDataClear(void)
{
    int no;

    for(no = 0 ; no < MailListView->Items->Count ; no++) {
        delete MailListView->Items->Item[no]->Data;
    }
}

//---------------------------------------------------------------------------
void TMainForm::AddMailList()
{
    int no, count;
    char subject[HEADER_MAX];
    char date[HEADER_MAX];
    char from[HEADER_MAX];
    char reply_to[HEADER_MAX];
    //char header[HEADER_MAX];
    char *header;
    TListItem *li;
    SOCKET S;

    // [{\NA
    BodyMemo->Lines->Clear();
    // ListView NA
    HeaderDataClear();
    MailListView->Items->Clear();
    // POP3 T[o[ɐڑ
    if((S = NMailPop3ConnectSsl(Pop3Name.c_str(), Pop3Port, Pop3Ssl, NULL)) != INVALID_SOCKET) {
        if(Id == "" || Password == "") {
            // ID ƃpX[h
            if(InputForm->ShowModal() == mrOk) {
                Id = InputForm->IdEdit->Text;
                Password = InputForm->PasswordEdit->Text;
            } else {
                return;
            }
        }
        // [̐𓾂
        if((no = NMailPop3Authenticate(S, Id.c_str(), Password.c_str(), APopFlag)) >= 0) {
            for(count = 1; count <= no ; count++) {
                header = new char[HEADER_MAX];
                // ԂɃwb_̓eǂ݁AListView ɒǉ
                NMailPop3GetMailStatus(S, count, subject, date, from, header, FALSE);
                li = MailListView->Items->Add();
                li->Caption = subject;
                li->SubItems->Add(from);
                li->SubItems->Add(date);
                NMailGetHeaderField(reply_to, header, "Reply-To:", HEADER_MAX);
                li->SubItems->Add(reply_to);
                strcat(header, "\r\n");
                li->Data = header;
            }
        } else {
            NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, subject, HEADER_MAX);
            MessageDlg(subject, mtError, TMsgDlgButtons() << mbOK, 0);
            Id = "";
            Password = "";
        }
        NMailPop3Close(S);
        S = INVALID_SOCKET;
    }
}



void __fastcall TMainForm::MailListViewClick(TObject *Sender)
{
    char subject[HEADER_MAX];
    char date[HEADER_MAX];
    char from[HEADER_MAX];
    char header[HEADER_MAX];
    char *body;
    int size;
    SOCKET S;

    mSave->Enabled = False;
    mReply->Enabled = False;
    // IĂ邩H
    if(MailListView->SelCount > 0) {
        // Ă킩܂AM̂тɐڑĂ܂B
        // {ł ID pX[h͌AxɎMA
        // T[o[ォM[폜At@C
        // ۑĂA薼ꗗNbNł́AۑĂ郁[
        // ǂݍޏׂł傤B

        // POP3 T[o[ɐڑ
        if((S = NMailPop3ConnectSsl(Pop3Name.c_str(), Pop3Port, Pop3Ssl, NULL)) != INVALID_SOCKET) {
            // IĂԍA[̐菭ȂH
            if(MailListView->Selected->Index < NMailPop3Authenticate(S, Id.c_str(), Password.c_str(), APopFlag)) {
                // [̃TCY𓾂āAm
                size = NMailPop3GetMailSize(S, MailListView->Selected->Index + 1);
                body = new char[size * 2];
                // [̓ǂݍ
                NMailPop3GetMail(S, MailListView->Selected->Index + 1, subject, date, from, header, body, NULL, NULL);
                // \p Memo NAĎMeǉ
                BodyMemo->Lines->Clear();
                BodyMemo->Lines->Add(body);
                // J[\擪Ɉړ
                BodyMemo->SelStart = 0;
                BodyMemo->SelLength = 0;
                // mۂ
                delete body;
            }
            // ڑI
            NMailPop3Close(S);
            S = INVALID_SOCKET;

            mSave->Enabled = True;
            mReply->Enabled = True;
        }
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::mSaveClick(TObject *Sender)
{
    TFileStream *fs;

    if(MailListView->Selected != NULL) {
        if(SaveDialog->Execute()) {
            fs = new TFileStream(SaveDialog->FileName, fmCreate);
            fs->WriteBuffer(MailListView->Selected->Data, strlen((char *)MailListView->Selected->Data));
            BodyMemo->Lines->SaveToStream(fs);
            delete fs;
        }
    }
}
//---------------------------------------------------------------------------


void __fastcall TMainForm::mAttachmentClick(TObject *Sender)
{
    // WJۑ̃_CAO\
    UniteForm->ShowModal();
}
//---------------------------------------------------------------------------



void TMainForm::ReadIni()
{
    TFileName IniFileName;
    TIniFile *IniFile;

    IniFileName = ChangeFileExt(Application->ExeName, ".INI");
    IniFile = new TIniFile(IniFileName);
    try {
        APopFlag = IniFile->ReadBool(OPTION_SECTION, OPTION_APOP_FLAG, FALSE);
        SmtpName = IniFile->ReadString(OPTION_SECTION, OPTION_SMTP_NAME, "");
        SmtpPort = IniFile->ReadInteger(OPTION_SECTION, OPTION_SMTP_PORT, NMAIL_SMTP_PORT);
        SmtpAuth = IniFile->ReadInteger(OPTION_SECTION, OPTION_SMTP_AUTH, 0);
        SmtpSsl = IniFile->ReadInteger(OPTION_SECTION, OPTION_SMTP_SSL, 0);
        Pop3Name = IniFile->ReadString(OPTION_SECTION, OPTION_POP3_NAME, "");
        Pop3Port = IniFile->ReadInteger(OPTION_SECTION, OPTION_POP3_PORT, NMAIL_POP3_PORT);
        Pop3Ssl = IniFile->ReadInteger(OPTION_SECTION, OPTION_POP3_SSL, 0);
        MailAddress = IniFile->ReadString(OPTION_SECTION, OPTION_MAIL_ADDRESS, "");
    }
    catch ( ... ) {
        delete IniFile;
    }
    delete IniFile;
}
