// Splitter.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "Splitter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSplitter

CSplitter::CSplitter()
{
	m_control[0] = NULL;
	m_control[1] = NULL;
	m_edge[0] = NULL;
	m_edge[1] = NULL;
	m_base.y = -1;
	m_thick = 2;
	m_min = 10;
	m_mode = modeHorizontal;
}

CSplitter::~CSplitter()
{
}


BEGIN_MESSAGE_MAP(CSplitter, CWnd)
	//{{AFX_MSG_MAP(CSplitter)
	ON_WM_PAINT()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSplitter bZ[W nh

void CSplitter::SetControl(int no, CWnd *wnd)
{
	m_control[no] = wnd;
	AdjustSize();
}

void CSplitter::OnMouseMove(UINT nFlags, CPoint point) 
{
	if(m_mode == modeHorizontal) {
		SetCursor(LoadCursor(NULL, IDC_SIZENS));	
	} else {
		SetCursor(LoadCursor(NULL, IDC_SIZEWE));	
	}
	ClientToScreen(&point);
	if(m_base.y != -1) {
		if(m_last.x != point.x || m_last.y != point.y) {
			m_last = point;

			CRect src, rc;

			GetParent()->GetClientRect(src);
			GetWindowRect(rc);
			GetParent()->ScreenToClient(rc);
			if(m_mode == modeHorizontal) {
				rc.top += point.y - m_base.y;
				if(rc.top <= src.top + m_min) {
					rc.top = src.top + m_min;
					rc.bottom = rc.top + m_thick;
				} else {
					rc.bottom += point.y - m_base.y;
					if(rc.bottom >= src.bottom - m_min) {
						rc.bottom = src.bottom - m_min;
						rc.top = rc.bottom - m_thick;
					}
				}
			} else {
				rc.left += point.x - m_base.x;
				if(rc.left <= src.left + m_min) {
					rc.left = src.left + m_min;
					rc.right = rc.left + m_thick;
				} else {
					rc.right += point.x - m_base.x;
					if(rc.right >= src.right - m_min) {
						rc.right = src.right - m_min;
						rc.left = rc.right - m_thick;
					}
				}
			}
			if(m_last_rc != rc) {
				m_base = point;
				MoveWindow(rc);
				m_last_rc = rc;
//				AdjustSize();
			}
		}
	}
	CWnd::OnMouseMove(nFlags, point);
}

void CSplitter::AdjustSize()
{
	CRect src, erc, rc;
	int x, y, w, h;

	if(m_control[0] != NULL && m_control[1] != NULL) {
		GetWindowRect(rc);
		GetParent()->ScreenToClient(rc);
		GetParent()->GetClientRect(src);

		if(m_mode == modeHorizontal) {
			if(m_edge[0] == NULL) {
				x = rc.left;
			} else {
				m_edge[0]->GetWindowRect(erc);
				GetParent()->ScreenToClient(erc);
				x = erc.right;
			}
			if(m_edge[1] == NULL) {
				w = src.right - x;
			} else {
				m_edge[1]->GetWindowRect(erc);
				GetParent()->ScreenToClient(erc);
				w = erc.left - x;
			}
			if(m_control[0] != NULL) {
				y = src.top;
				h = rc.top - src.top;
				m_control[0]->SetWindowPos(NULL, x, y, w, h, SWP_NOZORDER); 
			}
			if(m_control[1] != NULL) {
				y = rc.bottom;
				h = src.bottom - rc.bottom;
				m_control[1]->SetWindowPos(NULL, x, y, w, h, SWP_NOZORDER); 
			}
			SetWindowPos(NULL, x, rc.top, w, rc.bottom - rc.top, SWP_NOZORDER);
		} else {
			if(m_edge[0] == NULL) {
				y = rc.top;
			} else {
				m_edge[0]->GetWindowRect(erc);
				GetParent()->ScreenToClient(erc);
				y = erc.bottom;
			}
			if(m_edge[1] == NULL) {
				h = src.bottom - y;
			} else {
				m_edge[1]->GetWindowRect(erc);
				GetParent()->ScreenToClient(erc);
				h = erc.top - y;
			}
			if(m_control[0] != NULL) {
				x = src.left;
				w = rc.left - src.left;
				m_control[0]->SetWindowPos(NULL, x, y, w, h, SWP_NOZORDER); 
			}
			if(m_control[1] != NULL) {
				x = rc.right;
				w = src.right - rc.right;
				m_control[1]->SetWindowPos(NULL, x, y, w, h, SWP_NOZORDER); 
			}
			SetWindowPos(NULL, rc.left, y, rc.right - rc.left, h, SWP_NOZORDER);
		}
	}
}

void CSplitter::OnLButtonDown(UINT nFlags, CPoint point) 
{
	SetWindowPos(&CWnd::wndTop, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
	if(m_mode == modeHorizontal) {
		SetCursor(LoadCursor(NULL, IDC_SIZENS));
	} else {
		SetCursor(LoadCursor(NULL, IDC_SIZEWE));
	}
	ClientToScreen(&point);
	m_base = point;	
	m_last = m_base;
	SetCapture();
	CWnd::OnLButtonDown(nFlags, point);
}

void CSplitter::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if(m_base.y != -1) {
		AdjustSize();
	}
	m_base.y = -1;
	ReleaseCapture();
	m_control[1]->Invalidate();
	CWnd::OnLButtonUp(nFlags, point);
}

void CSplitter::SetMode(int mode)
{
	m_mode = mode;
	AdjustSize();
}

void CSplitter::SetMinimumSize(int min)
{
	m_min = min;
}

void CSplitter::SetThick(int thick)
{
	m_thick = thick;
	AdjustSize();
}

void CSplitter::SetEdge(CWnd *c1, CWnd *c2)
{
	m_edge[0] = c1;
	m_edge[1] = c2;
}

void CSplitter::CreateSplitter(int size, CWnd *parent, CWnd *c1, CWnd *c2, bool percent_flag)
{
	parent->GetClientRect(m_last_rc);

	if(m_mode == modeHorizontal) {
		if(percent_flag) {
			m_last_rc.top = ((m_last_rc.bottom - m_last_rc.top) * size * 10) / 1000;
		} else {
			m_last_rc.top = size;
		}
		m_last_rc.bottom = m_last_rc.top + m_thick;
	} else {
		if(percent_flag) {
			m_last_rc.left = ((m_last_rc.right - m_last_rc.left) * size * 10) / 1000;
		} else {
			m_last_rc.left = size;
		}
		m_last_rc.right = m_last_rc.left + m_thick;
	}
	Create(NULL, _T(""), WS_CHILD | WS_VISIBLE, m_last_rc, parent, 0);

	SetControl(0, c1);
	SetControl(1, c2);
}

void CSplitter::OnPaint()
{
	CPaintDC dc(this); // `p̃foCX ReLXg

	if(m_base.y != -1) {
		CRect src;
		GetClientRect(src);
		dc.FillSolidRect(src, RGB(0, 255, 0));
	}
}

