// vcmail6Dlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "vcmail6.h"
#include "vcmail6Dlg.h"
#include "Input.h"
#include "Option.h"
#include "Create.h"
#include "Unite.h"

#include "nMail.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define INI_SECTION			_T("VCMAIL")
#define INI_APOP			_T("APOP")
#define INI_SMTP			_T("SMTP")
#define INI_POP3			_T("POP3")
#define INI_SMTP_PORT		_T("SMTP_PORT")
#define INI_POP3_PORT		_T("POP3_PORT")
#define INI_SMTP_SSL		_T("SMTP_SSL")
#define INI_POP3_SSL		_T("POP3_SSL")
#define INI_SMTP_AUTH		_T("SMTP_AUTH")
#define INI_MAIL_ADDRESS	_T("MAIL_ADDRESS")

/////////////////////////////////////////////////////////////////////////////
// CVcmail6Dlg _CAO

CVcmail6Dlg::CVcmail6Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVcmail6Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVcmail6Dlg)
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_splitter = NULL;
}

void CVcmail6Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVcmail6Dlg)
	DDX_Control(pDX, IDC_EDIT_BODY, m_ebody);
	DDX_Control(pDX, IDC_LIST_MAIL, m_lmail);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVcmail6Dlg, CDialog)
	//{{AFX_MSG_MAP(CVcmail6Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(IDM_CREATE, OnCreate)
	ON_COMMAND(IDM_DELETE, OnDelete)
	ON_COMMAND(IDM_EXIT, OnExit)
	ON_COMMAND(IDM_OPTION, OnOption)
	ON_COMMAND(IDM_RE, OnRe)
	ON_COMMAND(IDM_READ, OnRead)
	ON_COMMAND(IDM_SAVE, OnSave)
	ON_NOTIFY(NM_CLICK, IDC_LIST_MAIL, OnClickListMail)
	ON_WM_INITMENUPOPUP()
	ON_UPDATE_COMMAND_UI(IDM_RE, OnUpdateRe)
	ON_UPDATE_COMMAND_UI(IDM_SAVE, OnUpdateSave)
	ON_UPDATE_COMMAND_UI(IDM_DELETE, OnUpdateDelete)
	ON_WM_CTLCOLOR()
	ON_NOTIFY(NM_RCLICK, IDC_LIST_MAIL, OnRclickListMail)
	ON_WM_SIZE()
	ON_COMMAND(IDM_UNITE, OnUnite)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVcmail6Dlg bZ[W nh

BOOL CVcmail6Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ
	
	// INI t@CǍ
	ReadIni();

	// ݒ
	m_splitter = new CSplitter();
	m_splitter->CreateSplitter(30, this, &m_lmail, &m_ebody, true);
	
	CRect rc;
	GetClientRect(rc);
	// s]ݒ
	m_lmail.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	// XgRg[̃wb_ݒ
	m_lmail.InsertColumn(0, _T(""), LVCFMT_LEFT, (int)(rc.right * 50) / 100);
	m_lmail.InsertColumn(1, _T("ol"), LVCFMT_LEFT, (int)(rc.right * 30) / 100);
	m_lmail.InsertColumn(2, _T("t"), LVCFMT_LEFT, (int)(rc.right * 15) / 100);
	
	m_body_brush.CreateSolidBrush(RGB(255, 255, 255));

    // Winsock 
    NMailInitializeWinSock();

    // ^CAEg̓ftHg(30b)
    // wb_ől 8192
    // {ől͖
    //NMailSetParameter(0, HEADER_MAX, 0);
    NMailSetOption(NMAIL_OPTION_HEADER_MAX, HEADER_MAX);

	// [ꗗǍ
	PostMessage(WM_COMMAND, IDM_READ);

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

void CVcmail6Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CVcmail6Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVcmail6Dlg::OnOK() 
{
//	CDialog::OnOK();
}

void CVcmail6Dlg::OnCancel() 
{
	CDialog::OnCancel();
}

void CVcmail6Dlg::PostNcDestroy() 
{
	delete m_splitter;	
	CDialog::PostNcDestroy();
}

void CVcmail6Dlg::OnCreate() 
{
	CCreate dlg(this);

	if(dlg.DoModal() == IDOK) {
		SOCKET s;
		CFileStatus fs;
		int ret = NMAIL_ERROR;
		// [M
		if((s = NMailSmtpConnectSsl(m_smtp, m_smtp_port, m_smtp_ssl, NULL)) != INVALID_SOCKET) {
			if(NMailSmtpAuthenticate(s, m_smtp, m_id, m_password, m_smtp_auth) == NMAIL_SUCCESS) {
				if(CFile::GetStatus(dlg.m_attach, fs)) {
					ret = NMailSmtpSendMailEx(s, dlg.m_to, NULL, NULL, m_mail_address, dlg.m_subject, dlg.m_body, NULL, dlg.m_attach, NULL, 0);
				} else {
					ret = NMailSmtpSendMailEx(s, dlg.m_to, NULL, NULL, m_mail_address, dlg.m_subject, dlg.m_body, NULL, NULL, NULL, 0);
				}
			}
			NMailSmtpClose(s);
		}
		if(ret < 0) {
			TCHAR msg[HEADER_MAX];
			NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, HEADER_MAX);
			MessageBox(msg);
		}
	}
}

void CVcmail6Dlg::OnDelete() 
{
	int no = m_lmail.GetNextItem(-1, LVNI_SELECTED);

	if(no != -1) {
		SOCKET s;
		// POP3 T[o[ɐڑ
		if((s = NMailPop3ConnectSsl(m_pop3, m_pop3_port, m_pop3_ssl, NULL)) != INVALID_SOCKET) {
			// [IԍH
			if(no < NMailPop3Authenticate(s, m_id, m_password, m_apop)) {
				// [폜
				NMailPop3DeleteMail(s, no + 1);
			}
			// ڑI
			NMailPop3Close(s);
		}
		// [ꗗXV
		OnRead();
	}
}

void CVcmail6Dlg::OnExit() 
{
	CDialog::OnOK();
}

void CVcmail6Dlg::OnUnite() 
{
	CUnite dlg(this);

	dlg.m_folder = m_current_path;
	// WJ
	if(dlg.DoModal() == IDOK) {
	    int size, ret, no;
		char temp[NMAIL_ATTACHMENT_TEMP_SIZE];
		TCHAR date[HEADER_MAX], from[HEADER_MAX];
		TCHAR header[HEADER_MAX];
		CString buff, body, subject, file_name;
		CString html_file;
		CFile fi;

		// fR[hL
		NMailSetOption(NMAIL_OPTION_DECODE_BODY, NMAIL_DECODE_BODY_ON);
		NMailSetOption(NMAIL_OPTION_DECODE_HEADER, NMAIL_DECODE_HEADER_ON);
		// HTML p[gۑ
		NMailSetOption(NMAIL_OPTION_SAVE_HTML, NMAIL_SAVE_HTML_ON);

        for(no = 0 ; no < dlg.m_file_list.GetSize() ; no++) {
            // Xg̃t@CԂɓǂݍ
			if(fi.Open(dlg.m_file_list[no], CFile::modeRead)) {
				size = fi.GetLength();
				fi.Read(buff.GetBuffer(size / sizeof(TCHAR)), size);
				buff.ReleaseBuffer();
				fi.Close();
				// ŏ̃f[^H
				if(no == 0) {
					// Ytt@ČAWJJn
					ret = NMailAttachmentFileFirst(temp, subject.GetBuffer(HEADER_MAX), date, from, header, body.GetBuffer(size + 1), dlg.m_folder, file_name.GetBuffer(HEADER_MAX), buff, NULL);
					subject.ReleaseBuffer();
					body.ReleaseBuffer();
					file_name.ReleaseBuffer();
				} else {
		            // Ytt@Č
			        ret = NMailAttachmentFileNext(temp, buff, NULL);
				}
				if(ret == NMAIL_ERROR_FILE_OPEN) {
					break;
				}
			} else {
				ret = NMAIL_ERROR_FILE_OPEN;
				break;
			}
		}
		// Ytt@ČI
		NMailAttachmentFileClose(temp);
		// IH
		if(ret >= 0) {
			NMailGetHeaderField(html_file.GetBuffer(HEADER_MAX), header, _T("X-NMAIL-HTML-FILE:"), HEADER_MAX);
			html_file.ReleaseBuffer();
			if(html_file.IsEmpty()) {
				MessageBox(dlg.m_folder + _T(" ɓYtt@C ") + file_name
				  + _T(" WJ܂B\r\n\r\n:") + subject + _T("\r\n{:\r\n") + body);
			} else {
				if(MessageBox(dlg.m_folder + _T(" ɓYtt@C ") + file_name
				  + _T(" WJ܂B\r\n\r\n:") + subject + _T("\r\n{:\r\n") + body + _T("\r\nHTML t@C ") + html_file + _T("J܂H\r\n(EBXꍇ܂BӉ)"), _T("vcmail6"), MB_YESNO) == IDYES) {
					ShellExecute(m_hWnd, _T("open"), dlg.m_folder + _T("\\") + html_file, NULL, NULL, SW_SHOW);
				}
			}
		} else if(ret == NMAIL_ERROR_FILE_OPEN) {
			MessageBox(_T("Ytt@CI[vł܂B"));
		} else if(ret == NMAIL_ERROR_PARTIAL) {
			MessageBox(_T("ꂽ[SđĂ܂"));
        }
    }
}

void CVcmail6Dlg::OnOption() 
{
	// ݒ_CAO\
	COption dlg(this);

	dlg.m_pop3 = m_pop3;
	dlg.m_pop3_port = m_pop3_port;
	dlg.m_pop3_ssl = 0;
	dlg.m_smtp = m_smtp;
	dlg.m_smtp_port = m_smtp_port;
	dlg.m_smtp_ssl = 0;
	dlg.SetSsl(m_smtp_ssl, m_pop3_ssl);
	dlg.SetAuth(m_smtp_auth);
	dlg.m_mail = m_mail_address;
	dlg.m_apop = m_apop;
	if(dlg.DoModal() == IDOK) {
		m_pop3 = dlg.m_pop3;
		m_pop3_port = dlg.m_pop3_port;
		m_smtp = dlg.m_smtp;
		m_smtp_port = dlg.m_smtp_port;
		dlg.GetSsl(m_smtp_ssl, m_pop3_ssl);
		dlg.GetAuth(m_smtp_auth);
		m_mail_address = dlg.m_mail;
		m_apop = dlg.m_apop;
		// t@Cɕۑ
		WriteIni();
	}
}

void CVcmail6Dlg::OnRe() 
{
	int no = m_lmail.GetNextItem(-1, LVNI_SELECTED);

	if(no != -1) {
		CCreate dlg(this);
		dlg.m_subject = "Re: " + m_lmail.GetItemText(no, 0);  
		dlg.m_to = m_lmail.GetItemText(no, 1);  
		if(dlg.DoModal() == IDOK) {
			SOCKET s;
			CFileStatus fs;
			int ret = NMAIL_ERROR;
			// [M
			if((s = NMailSmtpConnectSsl(m_smtp, m_smtp_port, m_smtp_ssl, NULL)) != INVALID_SOCKET) {
				if(NMailSmtpAuthenticate(s, m_smtp, m_id, m_password, m_smtp_auth) == NMAIL_SUCCESS) {
					if(CFile::GetStatus(dlg.m_attach, fs)) {
						ret = NMailSmtpSendMailEx(s, dlg.m_to, NULL, NULL, m_mail_address, dlg.m_subject, dlg.m_body, NULL, dlg.m_attach, NULL, 0);
					} else {
						ret = NMailSmtpSendMailEx(s, dlg.m_to, NULL, NULL, m_mail_address, dlg.m_subject, dlg.m_body, NULL, NULL, NULL, 0);
					}
				}
				NMailSmtpClose(s);
			}
			if(ret < 0) {
				TCHAR msg[HEADER_MAX];
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, HEADER_MAX);
				MessageBox(msg);
			}
		}
	}
}

void CVcmail6Dlg::OnRead() 
{
	int no, count;
	SOCKET s;
	TCHAR header[HEADER_MAX];
	TCHAR subject[HEADER_MAX];
	TCHAR date[HEADER_MAX];
	TCHAR from[HEADER_MAX];

	// POP3 ̐ݒ肪邩
	if(m_pop3.IsEmpty()) {
		OnOption();
		if(m_pop3.IsEmpty()) {
			return;
		}
	}
	// {\NA
	m_ebody.SetWindowText(_T(""));
	// ꗗ\NA
	DeleteListItem();
    
	if(m_id.IsEmpty() || m_password.IsEmpty()) {
		CInput idlg(this);
		// ID ƃpX[h
		if(idlg.DoModal() == IDOK) {
			m_id = idlg.m_id;
			m_password = idlg.m_password;
		} else {
			return;
		}
	}
	if((s = NMailPop3ConnectSsl(m_pop3, m_pop3_port, m_pop3_ssl, NULL)) != INVALID_SOCKET) {
		// [̐𓾂
		if((no = NMailPop3Authenticate(s, m_id, m_password, m_apop)) >= 0) {
			for(count = 1; count <= no ; count++) {
				// ԂɃwb_̓eǂ݁AListView ɒǉ
				NMailPop3GetMailStatus(s, count, subject, date, from, header, FALSE);
				m_lmail.InsertItem(count - 1, subject);
				m_lmail.SetItem(count - 1, 1, LVIF_TEXT, from, 0, 0, 0, 0);
				m_lmail.SetItem(count - 1, 2, LVIF_TEXT, date, 0, 0, 0, 0);
				CString *pstr = new CString(header);
				m_lmail.SetItemData(count - 1, (DWORD)pstr);
			}
		} else {
			NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, subject, HEADER_MAX);
			MessageBox(subject);
			m_id = "";
		}
		NMailPop3Close(s);
	} else {
		NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, subject, HEADER_MAX);
		MessageBox(subject);
		m_id = "";
	}
}

void CVcmail6Dlg::OnSave() 
{
	int no = m_lmail.GetNextItem(-1, LVNI_SELECTED);

	if(no != -1) {
		CString name;

		name.Format(_T("mail%d.txt"), no);
		CFileDialog dlg(FALSE, _T("txt"), name, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, _T("eLXgt@C(*.txt)|*.txt||"), this);
		if(dlg.DoModal() == IDOK) {
			// eLXgp[gуwb_̃fR[h
			NMailSetOption(NMAIL_OPTION_DECODE_BODY, NMAIL_DECODE_BODY_ALL_OFF);
			NMailSetOption(NMAIL_OPTION_DECODE_HEADER, NMAIL_DECODE_HEADER_OFF);
			// HTML p[g̓t@CɕۑȂ
			NMailSetOption(NMAIL_OPTION_SAVE_HTML, NMAIL_SAVE_HTML_OFF);
			// POP3 T[o[ɐڑ
			SOCKET s;
			if((s = NMailPop3ConnectSsl(m_pop3, m_pop3_port, m_pop3_ssl, NULL)) != INVALID_SOCKET) {
				// IĂԍA[̐菭ȂH
				if(no < NMailPop3Authenticate(s, m_id, m_password, m_apop)) {//
					TCHAR subject[HEADER_MAX];
					TCHAR date[HEADER_MAX];
					TCHAR from[HEADER_MAX];
					TCHAR header[HEADER_MAX];
					CString body;
					int size;
					// [̃TCY𓾂āAm
					size = NMailPop3GetMailSize(s, no + 1) * 2;
					// [̓ǂݍ
					NMailPop3GetMail(s, no + 1, subject, date, from, header, body.GetBuffer(size + 1), NULL, NULL);
					body.ReleaseBuffer();
					CFile fi;
					if(fi.Open(dlg.GetPathName(), CFile::modeCreate | CFile::modeWrite)) {
						fi.Write(header, _tcslen(header) * sizeof(TCHAR));
						fi.Write(_T("\r\n"), 2 * sizeof(TCHAR));
						fi.Write(body, body.GetLength() * sizeof(TCHAR));

						fi.Close();
					}
				}
			}
			// ڑI
			NMailPop3Close(s);
		}
	}	
}

void CVcmail6Dlg::OnClickListMail(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW *pNMListView = (NM_LISTVIEW *)pNMHDR;
	int no = pNMListView->iItem;

	if(no != -1) {
		TCHAR subject[HEADER_MAX];
		TCHAR date[HEADER_MAX];
		TCHAR from[HEADER_MAX];
		TCHAR header[HEADER_MAX];
		CString body;
		int size;

		// Ă킩邩Ǝv܂AM̂тɐڑĂ܂B
		// {ł ID pX[h͌AxɎMA
		// T[o[ォM[폜At@C
		// ۑĂA薼ꗗNbNł́AۑĂ郁[
		// ǂݍޏׂł傤B

		// fR[hL
		NMailSetOption(NMAIL_OPTION_DECODE_BODY, NMAIL_DECODE_BODY_ON);
		NMailSetOption(NMAIL_OPTION_DECODE_HEADER, NMAIL_DECODE_HEADER_ON);
		// HTML p[g͕ۑȂ
		NMailSetOption(NMAIL_OPTION_SAVE_HTML, NMAIL_SAVE_HTML_OFF);

		// POP3 T[o[ɐڑ
		SOCKET s;
		if((s = NMailPop3ConnectSsl(m_pop3, m_pop3_port, m_pop3_ssl, NULL)) != INVALID_SOCKET) {
			// IĂԍA[̐菭ȂH
			if(no < NMailPop3Authenticate(s, m_id, m_password, m_apop)) {//
				// [̃TCY𓾂āAm
				size = NMailPop3GetMailSize(s, no + 1) * 2;
				// [̓ǂݍ
				NMailPop3GetMail(s, no + 1, subject, date, from, header, body.GetBuffer(size + 1), NULL, NULL);
				body.ReleaseBuffer();
				// \p Memo NAĎMeǉ
				m_ebody.SetWindowText(body);
			}
			// ڑI
			NMailPop3Close(s);
		}
	}
	*pResult = 0;
}

void CVcmail6Dlg::ReadIni()
{
	TCHAR name[_MAX_PATH];
	TCHAR drive[_MAX_DRIVE];
	TCHAR directory[_MAX_DIR];
	TCHAR extension[_MAX_EXT];
	TCHAR fname[_MAX_FNAME];
	TCHAR temp[_MAX_PATH];

	GetModuleFileName(NULL, name, sizeof(name));
	GetCurrentDirectory(_MAX_PATH, m_current_path.GetBuffer(_MAX_PATH));
	m_current_path.ReleaseBuffer();
#ifdef _UNICODE
	_wsplitpath(name, drive, directory, fname, extension);
#else
	_splitpath(name, drive, directory, fname, extension);
#endif
	m_ini_path.Format(_T("%s\\%s.ini"), m_current_path, fname);

	m_apop = GetPrivateProfileInt(INI_SECTION, INI_APOP, 0, m_ini_path);
	GetPrivateProfileString(INI_SECTION, INI_POP3, _T(""), temp, MAX_PATH, m_ini_path);
	m_pop3 = temp;
	m_pop3_port = GetPrivateProfileInt(INI_SECTION, INI_POP3_PORT, NMAIL_POP3_PORT, m_ini_path);
	m_pop3_ssl = GetPrivateProfileInt(INI_SECTION, INI_POP3_SSL, 0, m_ini_path);
	GetPrivateProfileString(INI_SECTION, INI_SMTP, _T(""), temp, MAX_PATH, m_ini_path);
	m_smtp = temp;
	m_smtp_port = GetPrivateProfileInt(INI_SECTION, INI_SMTP_PORT, NMAIL_SMTP_PORT, m_ini_path);
	m_smtp_ssl = GetPrivateProfileInt(INI_SECTION, INI_SMTP_SSL, 0, m_ini_path);
	m_smtp_auth = GetPrivateProfileInt(INI_SECTION, INI_SMTP_AUTH, 0, m_ini_path);
	GetPrivateProfileString(INI_SECTION, INI_MAIL_ADDRESS, _T(""), temp, MAX_PATH, m_ini_path);
	m_mail_address = temp;
}

void CVcmail6Dlg::WriteIni()
{
	TCHAR temp[_MAX_PATH];

	wsprintf(temp, _T("%d"), m_apop);
	WritePrivateProfileString(INI_SECTION, INI_APOP, temp, m_ini_path);
	WritePrivateProfileString(INI_SECTION, INI_POP3, m_pop3, m_ini_path);
	wsprintf(temp, _T("%d"), m_pop3_port);
	WritePrivateProfileString(INI_SECTION, INI_POP3_PORT, temp, m_ini_path);
	wsprintf(temp, _T("%d"), m_pop3_ssl);
	WritePrivateProfileString(INI_SECTION, INI_POP3_SSL, temp, m_ini_path);
	WritePrivateProfileString(INI_SECTION, INI_SMTP, m_smtp, m_ini_path);
	wsprintf(temp, _T("%d"), m_smtp_port);
	WritePrivateProfileString(INI_SECTION, INI_SMTP_PORT, temp, m_ini_path);
	wsprintf(temp, _T("%d"), m_smtp_ssl);
	WritePrivateProfileString(INI_SECTION, INI_SMTP_SSL, temp, m_ini_path);
	wsprintf(temp, _T("%d"), m_smtp_auth);
	WritePrivateProfileString(INI_SECTION, INI_SMTP_AUTH, temp, m_ini_path);
	WritePrivateProfileString(INI_SECTION, INI_MAIL_ADDRESS, m_mail_address, m_ini_path);
}

void CVcmail6Dlg::DeleteListItem()
{
	CString *pstr;

	for(int no = 0 ; no < m_lmail.GetItemCount() ; no++) {
		pstr = (CString *)m_lmail.GetItemData(no);
		if(pstr != NULL) {
			delete pstr;
		}
	}
	m_lmail.DeleteAllItems();
}

BOOL CVcmail6Dlg::DestroyWindow() 
{
	DeleteListItem();
	// ݒۑ
	WriteIni();
	return CDialog::DestroyWindow();
}

void CVcmail6Dlg::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu) 
{
	CDialog::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);

	CCmdUI cmdUI;
	cmdUI.m_pMenu = pPopupMenu;
	cmdUI.m_nIndexMax = pPopupMenu->GetMenuItemCount();
	for (cmdUI.m_nIndex = 0 ; cmdUI.m_nIndex < pPopupMenu->GetMenuItemCount() ; cmdUI.m_nIndex++) {
		if(!(cmdUI.m_nID = pPopupMenu->GetMenuItemID(cmdUI.m_nIndex))) {
			continue;
		} else if(cmdUI.m_nID == (UINT)-1) {
			cmdUI.m_pSubMenu = pPopupMenu->GetSubMenu(cmdUI.m_nIndex);
			if(!cmdUI.m_pSubMenu || !(cmdUI.m_nID = cmdUI.m_pSubMenu->GetMenuItemID(0)) || (cmdUI.m_nID == (UINT)-1)) {
				continue;
			}
			cmdUI.DoUpdate(this, FALSE);
		} else {
			cmdUI.m_pSubMenu = NULL;
			cmdUI.DoUpdate(this, cmdUI.m_nID < 0xF000);
		}
	}
}

void CVcmail6Dlg::OnUpdateRe(CCmdUI* pCmdUI) 
{
	if(m_lmail.GetSelectedCount() == 0) {
		pCmdUI->Enable(FALSE);
	}
}

void CVcmail6Dlg::OnUpdateSave(CCmdUI* pCmdUI) 
{
	if(m_lmail.GetSelectedCount() == 0) {
		pCmdUI->Enable(FALSE);
	}
}

void CVcmail6Dlg::OnUpdateDelete(CCmdUI* pCmdUI) 
{
	if(m_lmail.GetSelectedCount() == 0) {
		pCmdUI->Enable(FALSE);
	}
}

HBRUSH CVcmail6Dlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	if(pWnd == &m_ebody) {
		pDC->SetBkMode(OPAQUE);
		pDC->SetBkColor(RGB(255, 255, 255));
		return (HBRUSH)m_body_brush;
	}
	return hbr;
}

void CVcmail6Dlg::OnRclickListMail(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CMenu pm, *sm;
	POINT pt;

	if(m_lmail.GetSelectedCount() > 0) {
		pm.LoadMenu(IDR_MENU_POPUP);
		sm = pm.GetSubMenu(0);
		GetCursorPos(&pt);
		sm->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, this);
	}
	*pResult = 0;
}


void CVcmail6Dlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	if(m_splitter) {
		m_splitter->AdjustSize();
	}
}

