unit testmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Winsock, ExtCtrls, ComCtrls, Menus, IniFiles, ShellApi;

const
  WM_START_APP = (WM_APP + $0001);

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    File1: TMenuItem;
    CreateItem: TMenuItem;
    ExitItem: TMenuItem;
    S1: TMenuItem;
    OptionItem: TMenuItem;
    PopupMenu: TPopupMenu;
    ReplyMailItem: TMenuItem;
    N3: TMenuItem;
    DeleteMailItem: TMenuItem;
    N5: TMenuItem;
    MailBoxTree: TTreeView;
    Splitter2: TSplitter;
    RightPanel: TPanel;
    BodyMemo: TMemo;
    MailList: TListView;
    Splitter1: TSplitter;
    N1: TMenuItem;
    PropertyMailItem: TMenuItem;
    AttachList: TListView;
    MailBoxImageList: TImageList;
    AttachImageList: TImageList;
    MailBoxPopupMenu: TPopupMenu;
    CreateMailBoxItem: TMenuItem;
    N4: TMenuItem;
    RenameMailBoxItem: TMenuItem;
    N6: TMenuItem;
    DeleteMailBoxItem: TMenuItem;
    AttachPopupMenu: TPopupMenu;
    OpenAttachItem: TMenuItem;
    SaveAttachItem: TMenuItem;
    SaveDialog: TSaveDialog;
    NoopTimer: TTimer;
    mRenewal: TMenuItem;
    N2: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure CreateItemClick(Sender: TObject);
    procedure ExitItemClick(Sender: TObject);
    procedure OptionItemClick(Sender: TObject);
    procedure MailListMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mRenewalClick(Sender: TObject);
    procedure MailBoxTreeChanging(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
    procedure MailBoxTreeChange(Sender: TObject; Node: TTreeNode);
    procedure MailBoxTreeDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure MailBoxTreeDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure MailListMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MailListMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure MailListEndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure MailBoxTreeEditing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure MailBoxTreeEdited(Sender: TObject; Node: TTreeNode;
      var S: String);
    procedure ReplyMailItemClick(Sender: TObject);
    procedure DeleteMailItemClick(Sender: TObject);
    procedure CreateMailBoxItemClick(Sender: TObject);
    procedure DeleteMailBoxItemClick(Sender: TObject);
    procedure RenameMailBoxItemClick(Sender: TObject);
    procedure PropertyMailItemClick(Sender: TObject);
    procedure AttachListDblClick(Sender: TObject);
    procedure MailListChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure AttachListChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure OpenAttachItemClick(Sender: TObject);
    procedure SaveAttachItemClick(Sender: TObject);
    procedure MailBoxTreeMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure NoopTimerTimer(Sender: TObject);
  private
    { Private 錾 }
    Socket: TSocket;       // \Pbg
    Id: String;       // ID
    Password: String; // pX[h
    Imap4Name: String; // POP3T[o[
    Imap4AuthMode: Integer; // IMAP4 F،`
    Imap4Ssl: Integer;
    Imap4Port: Integer;
    MailBox: String; // I𒆂̃[{bNX
    TrashMailBox: String; // S~
    SentMailBox: String; // M
    DragX, DragY: Integer;
    DragFlag: Boolean;
    TimerCount: Integer;
    procedure GetMailList;  // 薼ꗗListViewɕ\
    procedure MailListDataClear;
    function Authenticate: Boolean;
    function CheckSetting: Boolean;
    procedure GetMailBoxTree;
    procedure GetMail;
    procedure ChangeChildItemString(node: TTreeNode; old_path: string; new_path: string; flag: boolean);
    procedure OpenAttachFile;
    procedure AppendSent(tostr: string; subject: string; body: string; attach: string);
    function DeleteChildMailBox(node: TTreeNode; flag: Boolean): Boolean;
  public
    { Public 錾 }
    SmtpName: String;    // SMTPT[o[
    MailAddress: String; // [AhX
    SmtpPort: Integer;
    SmtpSsl: Integer;
    SmtpAuthMode: Integer;
    procedure WMStartApp(var Msg: TMessage); message WM_START_APP;
  end;

 PMailData = ^TMailData;
 TMailData = record
   Uid: integer;		// [ UID
   Flag: integer;		// [bZ[WtO
   Header : string;		// [wb_
 end;
 PMailBoxData = ^TMailBoxData;
 TMailBoxData = record
   Path : string;		// [{bNXtpX
   Separate : string;	// [{bNX
   Flag : integer;		// [{bNXtO
 end;

const
  OptionSection = 'DPIMAP4';
  OptionSmtpAuthMode = 'SmtpAuthMode';
  OptionSmtpName = 'SmtpName';
  OptionSmtpPort = 'SmtpPort';
  OptionSmtpSsl = 'SmtpSsl';
  OptionImap4Name = 'Imap4Name';
  OptionImap4Port = 'Imap4Port';
  OptionImap4Ssl = 'Imap4Ssl';
  OptionImap4AuthMode = 'Imap4AuthMode';
  OptionMailAddress = 'MailAddress';
  MailboxInbox = 'inbox';
  MailboxTrash = 'trash';
  MailboxSent = 'sent';
  MailboxTreeNameInbox = 'M';
  MailboxTreeNameTrash = 'S~';
  MailboxTreeNameSent = 'M';
  iconUser = 0;
  iconInbox = 1;
  iconSent = 2;
  iconTrash = 3;
  iconFolder = 4;
  iconNoSelect = 5;
  columnAttach = 0;
  columnSubject = 1;
  columnFrom = 2;
  columnDate = 3;

  HEADER_MAX = 8192;
  CONTINUE_TIMER_COUNT = 60*25;

var
  MainForm: TMainForm;

implementation

uses nMail, Input, Write, Option, Name, MimeList;

{$R *.DFM}

//	񕪊
procedure SplitString(list: TStringList; str: string; separate: string);
var
  len, p: Integer;
begin
  list.Clear;
  if str <> '' then
  begin
    len := Length(separate) - 1;
    p := Pos(separate, str);
    while p > 0 do
    begin
      list.Add(Copy(str, 1, p - 1));
      Delete(str, 1, p + len);
      p := Pos(separate, str)
    end;
    list.Add(str);
  end
  else
    list.Add('');
end;

//	񌋍
function JoinString(list: TStringList; separate: string; count: Integer): string;
var
  no: Integer;
begin
  Result := '';
  for no := 0 to count - 1 do
    Result := Result + list[no] + separate;
  if count >= 0 then
    Result := Result + list[count];
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  W: integer;
  IniFileName: TFileName;
  IniFile: TIniFile;
begin
    // dpmail.ini ݒǂݍ
    IniFileName := ChangeFileExt(Application.ExeName, '.INI');
    IniFile := TIniFile.Create(IniFileName);
    try
        with IniFile do
        begin
            SmtpName := ReadString(OptionSection, OptionSmtpName, '');
            SmtpPort := ReadInteger(OptionSection, OptionSmtpPort, NMAIL_SMTP_PORT);
            SmtpAuthMode := ReadInteger(OptionSection, OptionSmtpAuthMode, NMAIL_SMTP_AUTH_NOT_USE);
            SmtpSsl := ReadInteger(OptionSection, OptionSmtpSsl, 0);
            Imap4Name := ReadString(OptionSection, OptionImap4Name, '');
            Imap4Port := ReadInteger(OptionSection, OptionImap4Port, NMAIL_IMAP4_PORT);
            Imap4AuthMode := ReadInteger(OptionSection, OptionImap4AuthMode, NMAIL_IMAP4_AUTH_LOGIN);
            Imap4Ssl := ReadInteger(OptionSection, OptionImap4Ssl, 0);
            MailAddress := ReadString(OptionSection, OptionMailAddress, '');
        end;
        finally
            IniFile.Free;
    end;
    // ListView ̍ڕݒ
    W := MailList.ClientWidth - GetSystemMetrics(SM_CXVSCROLL);
    MailList.Columns[columnAttach].Width := 16;
    W := W - 16;
    MailList.Columns[columnSubject].Width := W div 2;
    MailList.Columns[columnFrom].Width := W div 4;
    MailList.Columns[columnDate].Width := W div 4;

    // Winsock 
    NMailInitializeWinSock;

    // ^CAEg̓ftHg(30b)
    // wb_ől 8192
    // {ől͖
    NMailSetParameter(0, HEADER_MAX, 0);

    // \Pbgϐ
    Socket := INVALID_SOCKET;

	// I[{bNX
    MailBox := 'INBOX';
	// hbOhbvϐ
    DragX := -1;
    DragFlag := false;
    // ڑێp^C}
    TimerCount := 0;

    PostMessage(Handle, WM_START_APP, 0, 0);
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    if Socket <> INVALID_SOCKET then
       NMailImap4Close(Socket);
    // Winsock gpI
    NMailEndWinsock;
end;

// ݒ肨 ID  pX[h̓`FbN
function TMainForm.CheckSetting: Boolean;
begin
  Result := false;
  // IMAP4 ̐ݒ肪邩
  if Imap4Name = '' Then
  begin
    OptionItemClick(nil);
    if Imap4Name = '' Then
    begin
      Exit;
    end;
  end;
  if (Id = '') or (Password = '') then
  begin
    // ID ƃpX[h
    if InputForm.ShowModal = mrOk then
    begin
      Id := InputForm.IdEdit.Text;
      Password := InputForm.PasswordEdit.Text;
    end
    else
    begin
      Exit;
    end;
  end;
  // c[\Ȃ΃[{bNXXg
  // 擾ăc[\
  if MailBoxTree.TopItem = nil Then
  begin
    GetMailBoxTree;
  end;
  Result := True;
end;

//	c[m[ȟ
function SearchNode(node: TTreeNode; path: string): TTreeNode;
begin
  while node <> nil do
  begin
    Result := SearchNode(node.GetFirstChild, path);
    if Result <> nil Then
    begin
      Exit;
    end;
    if node.Data <> nil Then
    begin
      if CompareText(TMailBoxData(node.Data^).Path, path) = 0 Then
      begin
        Result := node;
        Exit;
      end;
    end;
    node := node.GetNextSibling;
  end;
  Result := nil;
end;

//	c[Ɏw蕶ǉ
procedure AddPath(Tree: TTreeView; name: String; separate: String; flag: Integer; text: String);
var
  no, ino, index: Integer;
  node, pnode: TTreeNode;
  path: String;
  list: TStringList;
  mdata: PMailBoxData;
begin
  list := TStringList.Create;
  SplitString(list, name, separate);

  pnode := Tree.TopItem;
  for no := 0 to list.Count - 1 do
  begin
    path := JoinString(list, separate, no);
    node := SearchNode(Tree.TopItem, path);
    if node = nil then
    begin
      index := iconFolder;
      if text = '' then
      begin
        text := list[no];
        // IłȂ[{bNX
        if (flag And NMAIL_IMAP4_MAILBOX_NO_SELECT) <> 0 Then
          index := iconNoSelect;

        if no = 0 then
        begin
          if CompareText(text, MailboxInbox) = 0 then
          begin
            text := MailBoxTreeNameInbox;
            index := iconInbox;
          end
          else if CompareText(text, MailboxSent) = 0 then
          begin
            text := MailboxTreeNameSent;
            index := iconSent;
          end
          else if CompareText(text, MailboxTrash) = 0 then
          begin
            text := MailboxTreeNameTrash;
            index := iconTrash;
          end;
        end;
      end;
      if pnode <> nil then
      begin
        ino := 0;
        while ino < pnode.Count do
        begin
          if index < pnode.Item[ino].ImageIndex Then
            break;
          inc(ino);
        end;
        if ino < pnode.Count then
          node := Tree.Items.Insert(pnode.Item[ino], text)
        else
          node := Tree.Items.AddChild(pnode, text);
      end
      else
          node := Tree.Items.AddChild(nil, text);
      node.ImageIndex := index;
      node.SelectedIndex := index;
      New(mdata);
      mdata^.Path := path;
      mdata^.Separate := separate;
      mdata^.Flag := flag;
      node.Data := Pointer(mdata);
    end;
    pnode := node;
  end;
  list.Free;
end;

// [{bNXꗗ擾
procedure TMainForm.GetMailBoxTree;
var
  no, count, flag: Integer;
  node: TTreeNode;
  separate: array [0..1] of Char;
  name: array [0..HEADER_MAX] of Char;
  mdata: PMailBoxData;
begin
  MailBoxTree.Items.Clear;
  node := MailBoxTree.Items.Add(nil, MailAddress);
  node.ImageIndex := iconUser;
  node.SelectedIndex := iconUser;
  // IMAP4 F
  if Authenticate Then
  begin
    // [{bNXꗗ擾
    count := NMailImap4GetMailBoxList(Socket, '', '*', False);
    For no := 0 to count - 1 do
    begin
      // [{bNX擾
      NMailImap4GetMailBoxListStatus(Socket, no, flag, separate, name, HEADER_MAX);
      if CompareText(StrPas(name), MailboxSent) = 0 then
          SentMailBox := StrPas(name)
      else if CompareText(StrPas(name), MailboxTrash) = 0 then
          TrashMailBox := StrPas(name);
      if node.Data = nil then
      begin
           // [AhXm[hɃ_~[̃f[^i[
           New(mdata);
           mdata^.Path := '';
           mdata^.Separate := StrPas(separate);
           mdata^.Flag := 0;
           node.Data := Pointer(mdata);
      end;
      // [{bNXm[hǉ
      AddPath(MailBoxTree, StrPas(name), StrPas(separate), flag, '');
    end;
  end;
  MailBoxTree.Selected := SearchNode(MailBoxTree.TopItem, MailBox);
  MailBoxTree.FullExpand;
end;

// IMAP4 F łɔF؍ς݂ȂȂɂ߂
function TMainForm.Authenticate: Boolean;
var
  msg: array [0..HEADER_MAX] of Char;
begin
  TimerCount := CONTINUE_TIMER_COUNT;
  Result := True;
  if Socket = INVALID_SOCKET Then
  begin
    // ڑĂȂΐڑ
    Socket := NMailImap4ConnectSsl(PChar(Imap4Name), Imap4Port, Imap4Ssl, nil);
    if Socket <> INVALID_SOCKET Then
    begin
      // IMAP4 F
      if NMailImap4Authenticate(Socket, PChar(Id), PChar(Password), Imap4AuthMode) <> NMAIL_SUCCESS Then
      begin
        // G[\
        NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
        MessageDlg(StrPas(msg), mtError, [mbOk], 0);

        NMailImap4Close(Socket);
        Socket := INVALID_SOCKET;
        Result := False;
      end;
    end;
  end;
end;

// [\
procedure TMainForm.GetMail;
var
  name: array [0..HEADER_MAX] of Char;
  value: array [0..HEADER_MAX] of Char;
  body: PChar;
  count, uid, list_count, no, size: Integer;
  item: TListItem;
  sf: TSHFileinfo;
  icon: TIcon;
begin
  // IĂ邩H
  if MailList.SelCount > 0 then
  begin
    // IMAP4 F
    if Authenticate Then
    begin
      if NMailImap4SelectMailBox(Socket, PChar(MailBox), False) >= 0 Then
      begin
        uid := TMailData(MailList.Selected.Data^).Uid;
        AttachList.Items.Clear;
        AttachImageList.Clear;
        // MIME \擾
        count := NMailImap4GetMimeStructure(Socket, uid, NMAIL_IMAP4_USE_UID);
        if count >= 0 Then
        begin
          list_count := 0;
          for no := 0 To count - 1 do
          begin
            // Content-Type  SubType 擾
            NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_TYPE_AND_SUBTYPE, no, 0, name, value, HEADER_MAX);
            // {ȂΕ\
            if (CompareText(StrPas(name), 'text') = 0) And (CompareText(StrPas(value), 'plain') = 0) Then
            begin
              // {TCY擾
              size := NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_SIZE, no, 0, nil, nil, 0);
              GetMem(body, size * 2);
              // {擾
              NMailImap4GetMimePart(Socket, uid, no, body, NMAIL_IMAP4_USE_UID);
              // \p Memo NAĎMeǉB
              BodyMemo.Lines.Clear;
              BodyMemo.Lines.Add(Strpas(body));
              // J[\擪Ɉړ
              BodyMemo.SelStart := 0;
              BodyMemo.SelLength := 0;
              // mۂJ
              FreeMem(body);
            end
            else
            if CompareText(StrPas(name), 'multipart') <> 0 Then
            begin
              // Ytt@CȂΓYtt@Cꗗɒǉ
              // t@C擾
              NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_FILE_NAME, no, 0, name, nil, HEADER_MAX);
              if CompareText(StrPas(name), 'noname.html') = 0 Then
              begin
                StrCopy(name, '{.html');
              end;
              // ΉACR擾
              SHGetFileInfo(name, FILE_ATTRIBUTE_NORMAL, sf, SizeOf(sf), SHGFI_ICON Or SHGFI_SMALLICON Or SHGFI_USEFILEATTRIBUTES);
              // C[WXgɃACRǉ
              icon := TIcon.Create;
              icon.Handle := sf.hIcon;
              AttachImageList.AddIcon(icon);
              DestroyIcon(sf.hIcon);
              icon.Free;
              // Ytt@Cꗗɒǉ
              item := AttachList.Items.Add;
              item.Caption := StrPas(name);
              item.ImageIndex := list_count;
              // MIME \̔ԍf[^Ƃĕۑ
              item.Data := Pointer(no);
              Inc(list_count);
            end;
          end;
          // Ytt@CΕ\
          if list_count > 0 Then
            AttachList.Visible := True
          else
            AttachList.Visible := False;
        end;
      end;
    end;
  end;
end;

// [ꗗ̃f[^NA
procedure TMainForm.MailListDataClear;
var
  No: Integer;
begin
  for No := 0 to MailList.Items.Count - 1 do
    Dispose(MailList.Items[No].Data);
end;

// [ꗗ擾
procedure TMainForm.GetMailList;
var
  no, count, uid, flag: integer;
  subject: array [0..HEADER_MAX] of Char;
  date: array [0..HEADER_MAX] of Char;
  from: array [0..HEADER_MAX] of Char;
  header: array [0..HEADER_MAX] of Char;
  item: TListItem;
  mdata: PMailData;
  str: String;
begin
  // IMAP4 ݒ肨 ID & pX[h̃`FbN
  if Not CheckSetting Then
    Exit;

  // [{\NA
  BodyMemo.Lines.Clear;
  // ListView NA
  MailListDataClear;
  MailList.Items.Clear;
  // Ytt@Cꗗ
  AttachList.Visible := False;

  // [{bNXIĂȂΏI
  if MailBox = '' Then
    Exit;

  // IMAP4 F
  if Authenticate() Then
  begin
    // [{bNX̑I
    if NMailImap4SelectMailBox(Socket, PChar(MailBox), False) >= 0 Then
    begin
      // [̈ꗗ UID 擾
      count := NMailImap4SearchMail(Socket, NMAIL_IMAP4_SEARCH_UNDELETED, nil, NMAIL_IMAP4_USE_UID);
      if count >= 0 Then
      begin
        for no := 0 To count - 1 do
        begin
          NMailImap4GetSearchMailResult(Socket, no, uid);
          // ԂɃwb_̓eǂ݁AListView ɒǉ
          if NMailImap4GetMailStatus(Socket, uid, subject, date, from, header, flag, NMAIL_IMAP4_USE_UID) >= 0 Then
          begin
            item := MailList.Items.Add;
            str := '';
            if NMailImap4GetMimeStructure(Socket, uid, NMAIL_IMAP4_USE_UID) > 1 then
                str := 'Y';
            item.Caption := str;
            item.SubItems.Add(StrPas(Subject));
            item.SubItems.Add(StrPas(From));
            item.SubItems.Add(StrPas(Date));
            New(mdata);
            mdata^.Uid := uid;
            mdata^.Flag := flag;
            mdata^.Header := StrPas(header);
            item.Data := Pointer(mdata);
          end;
        end;
      end
      else
      begin
        // G[\
        NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, Subject, HEADER_MAX);
        MessageDlg(StrPas(subject), mtError, [mbOk], 0);
      end;
    end;
  end;
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
end;

// Mσ[{bNXɊi[
procedure TMainForm.AppendSent(tostr: string; subject: string; body: string; attach: string);
var
  header: string;
  msg: array [0..MAX_PATH] of Char;
begin
  if SentMailBox <> '' then
  begin
    // IMAP4 F
    if Authenticate then
    begin
      // wb_[ɐݒ
      header := 'Subject: ' + subject + #13#10;
      // M҂wb_[ɕt
      header := header + 'From: ' + MailAddress + #13#10;
      // Mwb_[ɕt
      header := header + 'To: ' + tostr + #13#10;
      // [Abv[h
      //  Messsage-ID  nMail.DLL ŕt
      // Mime-Version, Content-Type, Content-Transfer-Encoding ͎Iɕt܂
      if NMailImap4AppendMail(Socket, PChar(SentMailBox), PChar(header), PChar(body), PChar(attach), 0, nil, NMAIL_ADD_DATE_FIELD Or NMAIL_ADD_MESSAGEID_FIELD) = NMAIL_SUCCESS then
      begin
        if MailBox = SentMailBox then
           GetMailList;
      end
      else
      begin
        // G[\
        NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
        MessageDlg(StrPas(msg), mtError, [mbOk], 0);
      end;
    end;
  end;
end;

// [{bNX쐬
procedure TMainForm.CreateItemClick(Sender: TObject);
var
  SS: TSocket;
  no, ret: integer;
  body: String;
  msg: array [0..MAX_PATH] of Char;
begin
    // ͗NA
    WriteForm.ToEdit.Text := '';
    WriteForm.SubjectEdit.Text := '';
    WriteForm.AttachEdit.Text := '';
    WriteForm.BodyMemo.Lines.Clear;
    // [̈e
    if WriteForm.ShowModal = mrOk then
    begin
        // ͓e Body ɓ
        Body := '';
        for no := 0 to WriteForm.BodyMemo.Lines.Count - 1 do
            Body := Body + WriteForm.BodyMemo.Lines.Strings[no] + #13#10;

        if not FileExists(WriteForm.AttachEdit.Text) then
            WriteForm.AttachEdit.Text := '';
        // [M
        Ret := NMAIL_ERROR;
        SS := NMailSmtpConnectSsl(PChar(SmtpName), SmtpPort, SmtpSsl, nil);
        if SS <> INVALID_SOCKET Then
        begin
            Ret := NMailSmtpAuthenticate(SS, PChar(SmtpName), PChar(Id), PChar(Password), SmtpAuthMode);
            if Ret >= 0 Then
            begin
                Ret := NMailSmtpSendMailEx(SS, PChar(WriteForm.ToEdit.Text), nil, nil
                  , PChar(MailAddress), PChar(WriteForm.SubjectEdit.Text)
                  , PChar(Body), nil, PChar(WriteForm.AttachEdit.Text), nil, 0);
            end;
            NMailSmtpClose(SS);
        end;
        if ret >= 0 then
        begin
            // MȂ瑗Mσ[{bNXɊi[
            AppendSent(WriteForm.ToEdit.Text, WriteForm.SubjectEdit.Text, body, WriteForm.AttachEdit.Text);
        end
        else
        begin
            // G[\
            NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
            MessageDlg(StrPas(msg), mtError, [mbOk], 0);
        end;
    end;
end;

// I
procedure TMainForm.ExitItemClick(Sender: TObject);
begin
    Close;
end;

// ݒ
procedure TMainForm.OptionItemClick(Sender: TObject);
var
  IniFileName: TFileName;
  IniFile: TIniFile;
begin
    // ݒ_CAOɐݒeZbg
    OptionForm.SmtpEdit.Text := SmtpName;
    OptionForm.SmtpPort := SmtpPort;
    OptionForm.SmtpAuth := SmtpAuthMode;
    OptionForm.SmtpSsl := SmtpSsl;
    OptionForm.Imap4Edit.Text := Imap4Name;
    OptionForm.Imap4Port := Imap4Port;
    OptionForm.Imap4Auth := Imap4AuthMode;
    OptionForm.Imap4Ssl := Imap4Ssl;
    OptionForm.MailEdit.text := MailAddress;
    if OptionForm.ShowModal = mrOk then
    begin
        // ݒeXV
        SmtpName := OptionForm.SmtpEdit.Text;
        SmtpPort := OptionForm.SmtpPort;
        SmtpAuthMode := OptionForm.SmtpAuth;
        SmtpSsl := OptionForm.Imap4Ssl;
        Imap4Name := OptionForm.Imap4Edit.Text;
        Imap4Port := OptionForm.Imap4Port;
        Imap4AuthMode := OptionForm.Imap4Auth;
        Imap4Ssl := OptionForm.Imap4Ssl;
        MailAddress := OptionForm.MailEdit.Text;
        // dpmail.ini ɐݒeۑ
        IniFileName := ChangeFileExt(Application.ExeName, '.INI');
        IniFile := TIniFile.Create(IniFileName);
        try
            with IniFile do
            begin
                WriteString(OptionSection, OptionSmtpName, SmtpName);
                WriteInteger(OptionSection, OptionSmtpPort, SmtpPort);
                WriteInteger(OptionSection, OptionSmtpAuthMode, SmtpAuthMode);
                WriteInteger(OptionSection, OptionSmtpSsl, SmtpSsl);
                WriteString(OptionSection, OptionImap4Name, Imap4Name);
                WriteInteger(OptionSection, OptionImap4Port, Imap4Port);
                WriteInteger(OptionSection, OptionImap4AuthMode, Imap4AuthMode);
                WriteInteger(OptionSection, OptionImap4Ssl, Imap4Ssl);
                WriteString(OptionSection, OptionMailAddress, MailAddress);
            end;
        finally
            IniFile.Free;
        end;
    end;
end;

// [ꗗ}EXI
procedure TMainForm.MailListMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    if Button = mbLeft then
    begin
      if not DragFlag Then
      begin
        DragX := -1;
        GetMail;
      end;
    end;
end;

procedure TMainForm.mRenewalClick(Sender: TObject);
begin
    // 薼ꗗ\
    GetMailList;
end;

// [{bNXIO
procedure TMainForm.MailBoxTreeChanging(Sender: TObject; Node: TTreeNode;
  var AllowChange: Boolean);
begin
  if Node.ImageIndex = iconNoSelect then
    AllowChange := False;
end;

// [{bNXIύX
procedure TMainForm.MailBoxTreeChange(Sender: TObject; Node: TTreeNode);
begin
  if Node.Data <> nil then
  begin
    MailBox := TMailBoxData(Node.Data^).Path;
    GetMailList;
  end;
end;

// [ꗗ̃hbO
procedure TMainForm.MailBoxTreeDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var
   node: TTreeNode;
begin
   if(((Source is TTreeView) or (Source is TListView)) and (MailList.SelCount > 0)) then
   begin
     Accept := false;
     node := MailBoxTree.GetNodeAt(X, Y);
     if node <> nil then
     begin
       // hbvłtH_H
       if (Node.ImageIndex > iconUser) and (Node.ImageIndex < iconNoSelect) then
         Accept := True;
     end;
   end;
end;

// [ꗗ̃hbOhbv
procedure TMainForm.MailBoxTreeDragDrop(Sender, Source: TObject; X, Y: Integer);
var
  node: TTreeNode;
  msg: array [0..MAX_PATH] of Char;
begin
   if((Source is TListView) and (MailList.SelCount > 0)) then
   begin
     node := MailBoxTree.GetNodeAt(X, Y);
     if node <> nil then
     begin
       // IMAP4 F
       if Authenticate then
       begin
         // [[{bNXɃRs[
         if NMailImap4CopyMail(Socket, TMailData(MailList.Selected.Data^).Uid, PChar(TMailBoxData(node.Data^).Path), NMAIL_IMAP4_USE_UID) = NMAIL_SUCCESS Then
         begin
           // 猳̃[ɍ폜}[N
           if NMailImap4DeleteMail(Socket, TMailData(MailList.Selected.Data^).Uid, NMAIL_IMAP4_USE_UID) = NMAIL_SUCCESS Then
           begin
             // 烁[ꗗXV
             GetMailList;
           end
           else
           begin
             // G[\
             NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
             MessageDlg(StrPas(msg), mtError, [mbOk], 0);
           end;
         end
         else
         begin
           // G[\
           NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
           MessageDlg(StrPas(msg), mtError, [mbOk], 0);
         end;
       end;
     end;
   end;
end;

// [ꗗ}EX
procedure TMainForm.MailListMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then
  begin
    DragX := X;
    DragY := Y;
  end;
end;

// [ꗗ}EXړ
procedure TMainForm.MailListMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  if DragX <> -1 then
  begin
    if Abs(DragX - X) + Abs(DragY - Y) > 5 Then
    begin
       // }EXȂ苗ړŃhbOJn
       DragX := -1;
       DragFlag := true;
       MailList.BeginDrag(True);
    end;
  end;
end;

// [ꗗhbOhbvI
procedure TMainForm.MailListEndDrag(Sender, Target: TObject; X,
  Y: Integer);
begin
     DragFlag := false;
end;

// [{bNXύXO
procedure TMainForm.MailBoxTreeEditing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
   // ʏ̃[{bNXȊO͕ύXs
   if Node.ImageIndex <> iconFolder Then
     AllowEdit := false;
end;

// m[hɕۑĂ郁[{bNXXV
procedure TMainForm.ChangeChildItemString(node: TTreeNode; old_path: string; new_path: string; flag: boolean);
begin
  while node <> nil do
  begin
    if node.Data <> nil Then
    begin
      if CompareText(Copy(TMailBoxData(node.Data^).Path, 1, Length(old_path)), old_path) = 0 then
      begin
         TMailBoxData(node.Data^).Path := new_path + Copy(TMailBoxData(node.Data^).Path, Length(old_path) + 1, Length(TMailBoxData(node.Data^).Path));
      end;
    end;
    ChangeChildItemString(node.GetFirstChild, old_path, new_path, false);
    if flag then
      break;
    node := node.GetNextSibling;
  end;
end;

// [{bNXύX
procedure TMainForm.MailBoxTreeEdited(Sender: TObject; Node: TTreeNode;
  var S: String);
var
  list: TStringList;
  path: String;
  msg: array [0..MAX_PATH] of Char;
begin
   // IMAP4 F
   if Authenticate then
   begin
     // V[{bNX쐬
     list := TStringList.Create;
     SplitString(list, TMailBoxData(Node.Data^).Path, TMailBoxData(Node.Data^).Separate);
     path := JoinString(list, TMailBoxData(Node.Data^).Separate, list.Count - 2);
     if Path <> '' then
       path := path + TMailBoxData(Node.Data^).Separate;
     path := path + S;
     // [{bNXύX
     if NMailImap4RenameMailBox(Socket, PChar(TMailBoxData(Node.Data^).Path), PChar(path)) = NMAIL_SUCCESS then
     begin
       // Ȃq[{bNX̃f[^XV
       ChangeChildItemString(node, TMailBoxData(Node.Data^).Path, path, true);
     end
     else
     begin
       // G[\
       NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
       MessageDlg(StrPas(msg), mtError, [mbOk], 0);
       // \ɖ߂
       S := Node.Text;
     end;
     list.Free;
   end;
end;

// [ԐM
procedure TMainForm.ReplyMailItemClick(Sender: TObject);
var
  SS: TSocket;
  no, ret: Integer;
  body: String;
  temp: array [0..MAX_PATH] of Char;
begin
    with MailList do
    begin
        // IĂ邩H
        if SelCount > 0 then
        begin
            // ɍol Reply-To Ă
            if NMailGetHeaderField(temp, PChar(TMailData(Selected.Data^).Header), 'Reply-To:', MAX_PATH) then
                WriteForm.ToEdit.Text := StrPas(temp)
            else
                WriteForm.ToEdit.Text := Selected.SubItems[columnFrom - 1];
            //  Re: ēĂ
            WriteForm.SubjectEdit.Text := 'Re: ' + Selected.SubItems[columnSubject - 1];
            WriteForm.BodyMemo.Lines.Clear;
            // [̈e
            if WriteForm.ShowModal = mrOk then
            begin
                // ͓e Body ɓ
                body := '';
                for no := 0 to WriteForm.BodyMemo.Lines.Count - 1 do
                    body := body + WriteForm.BodyMemo.Lines.Strings[no] + #13#10;
                if not FileExists(WriteForm.AttachEdit.Text) then
			        WriteForm.AttachEdit.Text := '';

                // [M
                Ret := NMAIL_ERROR;
                SS := NMailSmtpConnectSsl(PChar(SmtpName), SmtpPort, SmtpSsl, nil);
                if SS <> INVALID_SOCKET Then
                begin
                   Ret := NMailSmtpAuthenticate(SS, PChar(SmtpName), PChar(Id), PChar(Password), SmtpAuthMode);
                   if Ret >= 0 Then
                   begin
                     Ret := NMailSmtpSendMailEx(SS, PChar(WriteForm.ToEdit.Text), nil, nil
                	   , PChar(MailAddress), PChar(WriteForm.SubjectEdit.Text)
                       , PChar(Body), nil, PChar(WriteForm.AttachEdit.Text), nil, 0);
                   end;
                   NMailSmtpClose(SS);
                end;
                if ret >= 0 then
                begin
                   // MȂ瑗Mσ[{bNXɊi[
                   AppendSent(WriteForm.ToEdit.Text, WriteForm.SubjectEdit.Text, body, WriteForm.AttachEdit.Text);
                end
                else
                begin
                    // G[\
                    NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, temp, MAX_PATH);
                    MessageDlg(StrPas(temp), mtError, [mbOk], 0);
                end;
            end;
        end;
    end;
end;

// [폜
procedure TMainForm.DeleteMailItemClick(Sender: TObject);
var
  flag: Boolean;
  msg: array [0..MAX_PATH] of Char;
begin
  // IMAP4 F
  if Authenticate then
  begin
    flag := true;
    // S~A݂̃[{bNXS~ȊOH
    if (TrashMailBox <> '') And (TrashMailBox <> MailBox) then
    begin
      // [S~ɃRs[
      if NMailImap4CopyMail(Socket, TMailData(MailList.Selected.Data^).Uid, PChar(TrashMailBox), NMAIL_IMAP4_USE_UID) <> NMAIL_SUCCESS Then
      begin
        // G[\
        NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
        MessageDlg(StrPas(msg), mtError, [mbOk], 0);
        flag := false;
      end;
    end;
    if flag then
    begin
      // [ɍ폜}[N
      if NMailImap4DeleteMail(Socket, TMailData(MailList.Selected.Data^).Uid, NMAIL_IMAP4_USE_UID) = NMAIL_SUCCESS Then
      begin
        GetMailList;
      end
      else
      begin
        // G[\
        NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
        MessageDlg(StrPas(msg), mtError, [mbOk], 0);
      end;
    end;
  end;
end;

// [{bNX쐬
procedure TMainForm.CreateMailBoxItemClick(Sender: TObject);
var
  node, cnode: TTreeNode;
  mdata: PMailBoxData;
  path: string;
  msg: array[0..MAX_PATH] of Char;
begin
  if MailBoxTree.Selected <> nil then
  begin
    node := MailBoxTree.Selected;
    // q[{bNX쐬\H
    if (TMailBoxData(node.Data^).Flag and NMAIL_IMAP4_MAILBOX_NO_INFERIOUS) = 0 then
    begin
      // [{bNX̓
      NameForm.NameEdit.Text := '';
      if NameForm.ShowModal = mrOk then
      begin
        if NameForm.NameEdit.Text <> '' then
        begin
          // IMAP4 F
          if Authenticate then
          begin
            // 쐬郁[{bNX쐬
            if TMailBoxData(node.Data^).Path = '' then
              path := NameForm.NameEdit.Text
            else
              path := TMailBoxData(node.Data^).Path + TMailBoxData(node.Data^).Separate + NameForm.NameEdit.Text;
            // [{bNX쐬
            if NMailImap4CreateMailBox(Socket, PChar(path)) = NMAIL_SUCCESS then
            begin
              // Ȃw
              NMailImap4SubscribeMailBox(Socket, PChar(path));
              // qm[h쐬
              cnode := MailBoxTree.Items.AddChild(node, NameForm.NameEdit.Text);
              cnode.ImageIndex := iconFolder;
              cnode.SelectedIndex := iconFolder;
              node.Expand(False);
              New(mdata);
              mdata^.Path := path;
              mdata^.Separate := TMailBoxData(node.Data^).Separate;
              mdata^.Flag := TMailBoxData(node.Data^).Flag;
              cnode.Data := Pointer(mdata);
            end
            else
            begin
              // G[\
              NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
              MessageDlg(StrPas(msg), mtError, [mbOk], 0);
            end;
          end;
        end;
      end;
    end;
  end;
end;

// q[{bNX폜
function TMainForm.DeleteChildMailBox(node: TTreeNode; flag: Boolean): Boolean;
begin
  while node <> nil do
  begin
    if not DeleteChildMailbox(node.GetFirstChild, false) then
    begin
      Result := false;
      Exit;
    end;
    if node.Data <> nil Then
    begin
      if NMailImap4DeleteMailBox(Socket, PChar(TMailBoxData(node.Data^).Path)) = NMAIL_SUCCESS then
      begin
        NMailImap4UnsubscribeMailBox(Socket, PChar(TMailBoxData(node.Data^).Path));
        Dispose(node.Data);
      end
      else
      begin
        Result := false;
        Exit;
      end;
    end;
    if flag then
      break;
    node := node.GetNextSibling;
  end;
  Result := True;
end;

// [{bNX폜
procedure TMainForm.DeleteMailBoxItemClick(Sender: TObject);
var
  msg: array [0..MAX_PATH] of Char;
begin
  if MessageDlg(MailBoxTree.Selected.Text + ' 폜܂?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
    // IMAP4 F
    if Authenticate then
    begin
      // q[{bNX܂߂č폜
      if DeleteChildMailBox(MailBoxTree.Selected, true) then
      begin
        // Ȃm[h폜
        MailBoxTree.Items.Delete(MailBoxTree.Selected);
      end
      else
      begin
        // G[\
        NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, MAX_PATH);
        MessageDlg(StrPas(msg), mtError, [mbOk], 0);
      end;
    end;
  end;
end;

// [{bNXOύXJn
procedure TMainForm.RenameMailBoxItemClick(Sender: TObject);
begin
   MailBoxTree.Selected.EditText;
end;

// [vpeB
procedure TMainForm.PropertyMailItemClick(Sender: TObject);
var
  uid, no, count: Integer;
  param_count, param_no: integer;
  name: array [0..HEADER_MAX] of Char;
  value: array [0..HEADER_MAX] of Char;
  path, text, param: string;
begin
  if MailList.SelCount > 0 then
  begin
    // IMAP4 F
    if Authenticate Then
    begin
      if NMailImap4SelectMailBox(Socket, PChar(MailBox), False) >= 0 Then
      begin
        uid := TMailData(MailList.Selected.Data^).Uid;
        // [wb_ݒ
        MimeListForm.HeaderMemo.Text := TMailData(MailList.Selected.Data^).Header;
        MimeListForm.MimeTree.Items.Clear;
        // MIME \擾
        count := NMailImap4GetMimeStructure(Socket, uid, NMAIL_IMAP4_USE_UID);
        if count >= 0 Then
        begin
          for no := 0 to count - 1 do
          begin
            // MIME \擾
            NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_PART, no, 0, name, nil, HEADER_MAX);
            path := name;
            // Content-Type ^CvƃTu^Cv쐬
            NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_TYPE_AND_SUBTYPE, no, 0, name, value, HEADER_MAX);
            text := StrPas(name) + '/' + StrPas(value) + ';';
            // Content-Type p[^쐬
            param_count := NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_PARAMETER_COUNT, no, 0, nil, nil, 0);
            for param_no := 0 to param_count - 1 do
            begin
              NMailImap4GetMimeStructureStatus(Socket, NMAIL_IMAP4_MIME_CONTENT_PARAMETER, no, param_no, name, value, HEADER_MAX);
              param := StrPas(name) + '="' + StrPas(value) + '"';
              if param_no < param_count - 1 then
                 param := param + '; ';
              text := text + param;
            end;
            // MIME \c[Ƀm[hǉ
            AddPath(MimeListForm.MimeTree, path, '.', 0, text);
          end;
        end;
        MimeListForm.MimeTree.FullExpand;
        // vpeB\
        MimeListForm.ShowModal;
      end;
    end;
  end;
end;

// Ytt@CJ
procedure TMainForm.OpenAttachFile;
var
  path: string;
  temp: array[0..MAX_PATH] of Char;
begin
  if AttachList.Selected <> nil then
  begin
    // IMAP4 F
    if Authenticate then
    begin
      // e|tH_擾
      GetTempPath(MAX_PATH, temp);
      path := StrPas(temp) + AttachList.Selected.Caption;
      // MIME p[gۑ
      if NMailImap4SaveMimePart(Socket, TMailData(MailList.Selected.Data^).Uid, Integer(AttachList.Selected.Data), PChar(path), temp, NMAIL_IMAP4_USE_UID Or NMAIL_IMAP4_MIME_PART_SAVE_AS_FILE) = NMAIL_SUCCESS then
      begin
        // ۑt@CN
        ShellExecute(handle, 'open', PChar(path), nil, nil, SW_SHOW);
      end
      else
      begin
        // G[\
        NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, temp, MAX_PATH);
        MessageDlg(StrPas(temp), mtError, [mbOk], 0);
      end;
    end;
  end;
end;

// Ytt@Cꗗ_uNbN
procedure TMainForm.AttachListDblClick(Sender: TObject);
begin
   OpenAttachFile;
end;

// [ꗗIύX
procedure TMainForm.MailListChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  if MailList.Selected <> nil then
     // I΃|bvAbvj[L
     PopupMenu.AutoPopup := true
  else
  begin
     // IȂ΃|bvAbvj[
     PopupMenu.AutoPopup := false;
     // {\̃NA
     BodyMemo.Lines.Clear;
     AttachList.Visible := false;
  end;
end;

// Ytt@CꗗIύX
procedure TMainForm.AttachListChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  if AttachList.Selected <> nil then
     // I΃|bvAbvj[L
     AttachPopupMenu.AutoPopup := true
  else
     // IȂ΃|bvAbvj[
     AttachPopupMenu.AutoPopup := false
end;

// Ytt@CJ
procedure TMainForm.OpenAttachItemClick(Sender: TObject);
begin
  OpenAttachFile;
end;

// Ytt@Cۑ
procedure TMainForm.SaveAttachItemClick(Sender: TObject);
var
  temp: array [0..MAX_PATH] of Char;
begin
  // ۑt@C_CAO\
  SaveDialog.FileName := AttachList.Selected.Caption;
  if SaveDialog.Execute then
  begin
    // MIME p[gۑ
    if NMailImap4SaveMimePart(Socket, TMailData(MailList.Selected.Data^).Uid, Integer(AttachList.Selected.Data), PChar(SaveDialog.FileName), temp, NMAIL_IMAP4_USE_UID Or NMAIL_IMAP4_MIME_PART_SAVE_AS_FILE) = NMAIL_SUCCESS then
    begin
      ShowMessage(SaveDialog.FileName + ' ۑ܂');
    end
    else
    begin
       // G[\
       NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, temp, MAX_PATH);
       MessageDlg(StrPas(temp), mtError, [mbOk], 0);
    end;
  end;
end;

// [{bNXꗗł̃}EX
procedure TMainForm.MailBoxTreeMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  node: TTreeNode;
begin
  if Button = mbRight then
  begin
    MailBoxPopupMenu.AutoPopup := False;
    node := MailBoxTree.GetNodeAt(X, Y);
    if node <> nil then
    begin
      if node.ImageIndex <> iconNoSelect then
      begin
        // I\ȃ[{bNXł
        // |bvAbvj[L
        MailBoxTree.Selected := node;
        DeleteMailBoxItem.Enabled := false;
        RenameMailBoxItem.Enabled := false;
        if node.ImageIndex = iconFolder then
        begin
          if (TMailBoxData(node.Data^).Flag and NMAIL_IMAP4_MAILBOX_NO_INFERIOUS) = 0 then
            CreateMailBoxItem.Enabled := true;
          DeleteMailBoxItem.Enabled := true;
          RenameMailBoxItem.Enabled := true;
        end;
        MailBoxPopupMenu.AutoPopup := true;
      end;
    end;
  end;
end;

procedure TMainForm.NoopTimerTimer(Sender: TObject);
begin
  if TimerCount > 0 then
  begin
    Dec(TimerCount);
    if (TimerCount = 0) And (Socket <> INVALID_SOCKET) then
    begin
      if NMailImap4NoOperation(Socket) = NMAIL_SUCCESS then
        TimerCount := CONTINUE_TIMER_COUNT
      else
      begin
        NMailImap4Close(Socket);
        Socket := INVALID_SOCKET;
      end;
    end;
  end;
end;

procedure TMainForm.WMStartApp(var Msg: TMessage);
begin
  GetMailList;
end;

end.
