// vc6imap4Dlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "vc6imap4.h"
#include "vc6imap4Dlg.h"
#include "Input.h"
#include "Option.h"
#include "Create.h"
#include "Name.h"
#include "MimeList.h"
#include "StrSplit.h"

#include "nMail.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define INI_SECTION			_T("VCMAIL")
#define INI_IMAP4_AUTH		_T("IMAP4_AUTH")
#define INI_IMAP4_PORT		_T("IMAP4_PORT")
#define INI_IMAP4_SSL		_T("IMAP4_SSL")
#define INI_IMAP4			_T("IMAP4")
#define INI_SMTP_AUTH		_T("SMTP_AUTH")
#define INI_SMTP_PORT		_T("SMTP_PORT")
#define INI_SMTP_SSL		_T("SMTP_SSL")
#define INI_SMTP			_T("SMTP")
#define INI_MAIL_ADDRESS	_T("MAIL_ADDRESS")

/////////////////////////////////////////////////////////////////////////////
// CVc6imap4Dlg _CAO

CVc6imap4Dlg::CVc6imap4Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVc6imap4Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVc6imap4Dlg)
		// : ̈ʒu ClassWizard ɂăȍǉ܂B
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_splitter = NULL;
	m_socket = INVALID_SOCKET;
	m_timer = 0;
}

void CVc6imap4Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVc6imap4Dlg)
	DDX_Control(pDX, IDC_TREE_MAILBOX, m_tree_mailbox);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVc6imap4Dlg, CDialog)
	//{{AFX_MSG_MAP(CVc6imap4Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(IDM_CREATE, OnCreate)
	ON_COMMAND(IDM_DELETE, OnDelete)
	ON_COMMAND(IDM_EXIT, OnExit)
	ON_COMMAND(IDM_OPTION, OnOption)
	ON_COMMAND(IDM_RE, OnRe)
	ON_COMMAND(IDM_READ, OnRead)
	ON_WM_INITMENUPOPUP()
	ON_UPDATE_COMMAND_UI(IDM_RE, OnUpdateRe)
	ON_UPDATE_COMMAND_UI(IDM_DELETE, OnUpdateDelete)
	ON_WM_SIZE()
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE_MAILBOX, OnSelchangedTreeMailbox)
	ON_NOTIFY(NM_RCLICK, IDC_TREE_MAILBOX, OnRclickTreeMailbox)
	ON_COMMAND(IDM_CREATE_MAILBOX, OnCreateMailbox)
	ON_UPDATE_COMMAND_UI(IDM_CREATE_MAILBOX, OnUpdateCreateMailbox)
	ON_COMMAND(IDM_DELETE_MAILBOX, OnDeleteMailbox)
	ON_UPDATE_COMMAND_UI(IDM_DELETE_MAILBOX, OnUpdateDeleteMailbox)
	ON_COMMAND(IDM_RENAME_MAILBOX, OnRenameMailbox)
	ON_UPDATE_COMMAND_UI(IDM_RENAME_MAILBOX, OnUpdateRenameMailbox)
	ON_NOTIFY(TVN_ENDLABELEDIT, IDC_TREE_MAILBOX, OnEndlabeleditTreeMailbox)
	ON_NOTIFY(TVN_BEGINLABELEDIT, IDC_TREE_MAILBOX, OnBeginlabeleditTreeMailbox)
	ON_WM_TIMER()
	ON_COMMAND(IDM_PROPERTY, OnProperty)
	ON_UPDATE_COMMAND_UI(IDM_PROPERTY, OnUpdateProperty)
	ON_COMMAND(IDM_OPEN_FILE, OnOpenFile)
	ON_UPDATE_COMMAND_UI(IDM_OPEN_FILE, OnUpdateOpenFile)
	ON_COMMAND(IDM_SAVE_FILE, OnSaveFile)
	ON_UPDATE_COMMAND_UI(IDM_SAVE_FILE, OnUpdateSaveFile)
	ON_NOTIFY(NM_CLICK, IDC_TREE_MAILBOX, OnClickTreeMailbox)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_PANEL_COMMAND, OnPanelCommand)
	ON_MESSAGE(WM_COPY_MAILBOX, OnCopyMailbox)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVc6imap4Dlg bZ[W nh

BOOL CVc6imap4Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ
	
	// INI t@CǍ
	ReadIni();

	m_panel = new CPanel();
	m_panel->Create(this);

	// ݒ
	m_splitter = new CSplitter();
	m_splitter->SetMode(CSplitter::modeVertical);
	m_splitter->CreateSplitter(20, this, &m_tree_mailbox, m_panel, true);

	// c[\pC[WXg쐬
	m_image_list.Create(16, 16, ILC_COLOR32|ILC_MASK, 6, 6);
	HICON icon;
	icon = (HICON)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_USER), IMAGE_ICON, 16, 16, 0);
	m_image_list.Add(icon);
	DestroyIcon(icon);
	icon = (HICON)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_INBOX), IMAGE_ICON, 16, 16, 0);
	m_image_list.Add(icon);
	DestroyIcon(icon);
	icon = (HICON)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_SENT), IMAGE_ICON, 16, 16, 0);
	m_image_list.Add(icon);
	DestroyIcon(icon);
	icon = (HICON)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_TRASH), IMAGE_ICON, 16, 16, 0);
	m_image_list.Add(icon);
	DestroyIcon(icon);
	icon = (HICON)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_FOLDER), IMAGE_ICON, 16, 16, 0);
	m_image_list.Add(icon);
	DestroyIcon(icon);
	icon = (HICON)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_NOSELECT), IMAGE_ICON, 16, 16, 0);
	m_image_list.Add(icon);
	DestroyIcon(icon);
	m_tree_mailbox.SetImageList(&m_image_list, TVSIL_NORMAL);

	// c[ւ̃hbOhbvLɂ
	m_tree_mailbox.m_tree_drop.Register(&m_tree_mailbox);
	m_tree_mailbox.m_tree_drop.m_parent = this;

    // Winsock 
    NMailInitializeWinSock();

    // ^CAEg̓ftHg(30b)
    // wb_ől 8192
    // {ől͖
    NMailSetOption(NMAIL_OPTION_HEADER_MAX, HEADER_MAX);
NMailSetOption(NMAIL_OPTION_CONNECT_TIMEOUT, 1);
	// NoOperation sp^C}
	SetTimer(1, 1000, NULL);

	// [ꗗǍJn
	PostMessage(WM_COMMAND, IDM_READ);

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CVc6imap4Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CVc6imap4Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVc6imap4Dlg::OnOK() 
{
//	CDialog::OnOK();
}

void CVc6imap4Dlg::OnCancel() 
{
	CDialog::OnCancel();
}

void CVc6imap4Dlg::PostNcDestroy() 
{
	delete m_panel;
	delete m_splitter;	
	CDialog::PostNcDestroy();
}

//
//	[̐VK쐬
//
void CVc6imap4Dlg::OnCreate() 
{
	CCreate dlg(this);

	if(dlg.DoModal() == IDOK) {
		SOCKET s;
		CFileStatus fs;
		int ret = NMAIL_ERROR;
		// [M
       	if((s = NMailSmtpConnectSsl(m_smtp, m_smtp_port, m_smtp_ssl, NULL)) != INVALID_SOCKET) {
			if(NMailSmtpAuthenticate(s, m_smtp, m_id, m_password, m_smtp_auth) == NMAIL_SUCCESS) {
				if(CFile::GetStatus(dlg.m_attach, fs)) {
					ret = NMailSmtpSendMailEx(s, dlg.m_to, NULL, NULL, m_mail_address, dlg.m_subject, dlg.m_body, NULL, dlg.m_attach, NULL, 0);
				} else {
					ret = NMailSmtpSendMailEx(s, dlg.m_to, NULL, NULL, m_mail_address, dlg.m_subject, dlg.m_body, NULL, NULL, NULL, 0);
				}
			}
			NMailSmtpClose(s);
		}
		if(ret < 0) {
			TCHAR msg[HEADER_MAX];
			// MsŃG[bZ[W\
			NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, HEADER_MAX);
			MessageBox(msg);
		} else {
			// MσtH_΃[Abv[h
			AppendSent(dlg.m_to, dlg.m_subject, dlg.m_body, dlg.m_attach);
		}
	}
}

//
//	[̍폜(폜tOtāAS~΃Rs[)
//
void CVc6imap4Dlg::OnDelete() 
{
	int no = m_panel->m_list_mail.GetNextItem(-1, LVNI_SELECTED);

	if(no != -1) {
		// F
		if(Authenticate()) {
			// ݂̃[{bNXI
			if(NMailImap4SelectMailBox(m_socket, m_mailbox, FALSE) >= 0) {
				BOOL flag = TRUE;
				DWORD uid = m_panel->m_list_mail.GetUid(no);
				// S~tH_݂邩H
				if(!m_trash.IsEmpty() && m_trash != m_mailbox) {
					// [S~ɃRs[
					if(NMailImap4CopyMail(m_socket, uid, m_trash, NMAIL_IMAP4_USE_UID) != NMAIL_SUCCESS) {
						CString str, err;
						NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, err.GetBuffer(MAX_PATH), MAX_PATH);
						err.ReleaseBuffer();
						str.Format(_T("S~ւړł܂łB\r\n[%s]"), err);
						AfxMessageBox(str);
					    flag = FALSE;
					}
				}
				if(flag) {
					// [폜(폜tOt)
					if(NMailImap4DeleteMail(m_socket, uid, NMAIL_IMAP4_USE_UID) != NMAIL_SUCCESS) {
						CString str, err;
						NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, err.GetBuffer(MAX_PATH), MAX_PATH);
						err.ReleaseBuffer();
						str.Format(_T("[폜ł܂łB\r\n[%s]"), err);
						AfxMessageBox(str);
					}
				}
			}
		}
		// [ꗗXV
		PostMessage(WM_COMMAND, IDM_READ);
	}
}

//
//	t@Cj[ŏII
//
void CVc6imap4Dlg::OnExit() 
{
	CDialog::OnOK();
}

//
//	ݒ胁j[I
//
void CVc6imap4Dlg::OnOption() 
{
	COption dlg(this);

	dlg.m_imap4 = m_imap4;
	dlg.m_imap4_port = m_imap4_port;
	dlg.m_smtp = m_smtp;
	dlg.m_smtp_port = m_smtp_port;
	dlg.m_mail = m_mail_address;
	dlg.SetSsl(m_smtp_ssl, m_imap4_ssl);
	dlg.SetAuth(m_smtp_auth, m_imap4_auth);
	// CRAM-MD5 ̏ꍇ
	if(dlg.m_imap4_auth == 3) {
		dlg.m_imap4_auth = 2;
	}
	// ݒ_CAO\
	if(dlg.DoModal() == IDOK) {
		m_imap4 = dlg.m_imap4;
		m_imap4_port = dlg.m_imap4_port;
		m_smtp = dlg.m_smtp;
		m_smtp_port = dlg.m_smtp_port;
		m_mail_address = dlg.m_mail;
		dlg.GetSsl(m_smtp_ssl, m_imap4_ssl);
		dlg.GetAuth(m_smtp_auth, m_imap4_auth);
		// ݒt@Cɕۑ
		WriteIni();
	}
}

//
//	MσtH_Ƀ[Abv[h
//
void CVc6imap4Dlg::AppendSent(CString to, CString subject, CString body, CString attach)
{
	if(!m_sent.IsEmpty()) {
		if(Authenticate()) {
			CString header;

			// wb_[ɐݒ
			header = _T("Subject: ") + subject + "\r\n";
			// M҂wb_[ɕt
			header += _T("From: " )+ m_mail_address + "\r\n";
			// Mwb_[ɕt
			header += _T("To: ") + to + "\r\n";
			// [Abv[h
			//  Messsage-ID  nMail.DLL ŕt
			// Mime-Version, Content-Type, Content-Transfer-Encoding ͎Iɕt܂
			if(NMailImap4AppendMail(m_socket, m_sent, header, body, attach, 0, NULL, NMAIL_ADD_DATE_FIELD | NMAIL_ADD_MESSAGEID_FIELD) != NMAIL_SUCCESS) {
				TCHAR msg[HEADER_MAX];
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, HEADER_MAX);
		        AfxMessageBox(msg);
			} else {
				// ݑMσtH_JĂȂ\XV
				if(m_mailbox == m_sent) {
					PostMessage(WM_COMMAND, IDM_READ);
				}
			}
		}
	}
}

//
//	[ԐM
//
void CVc6imap4Dlg::OnRe() 
{
	int no = m_panel->m_list_mail.GetNextItem(-1, LVNI_SELECTED);

	if(no != -1) {
		CCreate dlg(this);
		// ԐMpɌݒ
		dlg.m_subject = _T("Re: ") + m_panel->m_list_mail.GetItemText(no, 0);  
		// ԐMp To ݒ
		dlg.m_to = m_panel->m_list_mail.GetItemText(no, 1);  

		if(dlg.DoModal() == IDOK) {
			SOCKET s;
			CFileStatus fs;
			int ret = NMAIL_ERROR;
			// [M
       		if((s = NMailSmtpConnectSsl(m_smtp, m_smtp_port, m_smtp_ssl, NULL)) != INVALID_SOCKET) {
				if(NMailSmtpAuthenticate(s, m_smtp, m_id, m_password, m_smtp_auth) == NMAIL_SUCCESS) {
					if(CFile::GetStatus(dlg.m_attach, fs)) {
						ret = NMailSmtpSendMailEx(s, dlg.m_to, NULL, NULL, m_mail_address, dlg.m_subject, dlg.m_body, NULL, dlg.m_attach, NULL, 0);
					} else {
						ret = NMailSmtpSendMailEx(s, dlg.m_to, NULL, NULL, m_mail_address, dlg.m_subject, dlg.m_body, NULL, NULL, NULL, 0);
					}
				}
				NMailSmtpClose(s);
			}
			if(ret < 0) {
				TCHAR msg[HEADER_MAX];
				// MsŃG[bZ[W\
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, msg, HEADER_MAX);
				MessageBox(msg);
			} else {
				// MσtH_΃[Abv[h
				AppendSent(dlg.m_to, dlg.m_subject, dlg.m_body, dlg.m_attach);
			}
		}
	}
}

//
//	IMAP4 ̐ݒ肪邩ǂ
//	ID ƃpX[h͍ς݂ǂ
//
BOOL CVc6imap4Dlg::CheckSetting()
{
	// IMAP4 ̐ݒ肪邩
	if(m_imap4.IsEmpty()) {
		OnOption();
		if(m_imap4.IsEmpty()) {
			return FALSE;
		}
	}
	if(m_id.IsEmpty() || m_password.IsEmpty()) {
		CInput dlg(this);
		// ID ƃpX[h
		if(dlg.DoModal() == IDOK) {
			m_id = dlg.m_id;
			m_password = dlg.m_password;
		} else {
			return FALSE;
		}
	}
	// c[\Ȃ΃[{bNXXg
	// 擾ăc[\
	if(m_tree_mailbox.GetRootItem() == NULL) {
		return GetMailBoxTree();
	}
	return TRUE;
}

//
//	[ꗗ̎擾
//
void CVc6imap4Dlg::OnRead() 
{
	int no, count, list_no, flag;
	DWORD uid;
	TCHAR header[HEADER_MAX];
	TCHAR subject[HEADER_MAX];
	TCHAR date[HEADER_MAX];
	TCHAR from[HEADER_MAX];
	CString str;

	// IMAP4 ݒ肨 ID & pX[h̃`FbN
	if(!CheckSetting()) {
		return;
	}

	// {\NA
	m_panel->m_edit_body.SetWindowText(_T(""));
	// ꗗ\NA
	m_panel->m_list_mail.ReleaseAllItemData();
	m_panel->m_list_mail.DeleteAllItems();
	// Ytt@Cꗗ
	m_panel->m_list_attach.ShowWindow(SW_HIDE);
	m_panel->AdjustSize();

	// [{bNXIĂȂΏI
	if(m_mailbox.IsEmpty()) {
		return;
	}
	// F
	if(Authenticate()) {
		// [{bNX̑I
		if(NMailImap4SelectMailBox(m_socket, m_mailbox, FALSE) >= 0) {
			// 폜}[NȂ[̈ꗗ UID 擾
			if((count = NMailImap4SearchMail(m_socket, NMAIL_IMAP4_SEARCH_UNDELETED, NULL, NMAIL_IMAP4_USE_UID)) >= 0) {
				list_no = 0;
				for(no = 0 ; no < count ; no++) {
					NMailImap4GetSearchMailResult(m_socket, no, &uid);
					// ԂɃwb_̓eǂ݁AListView ɒǉ
					if(NMailImap4GetMailStatus(m_socket, uid, subject, date, from, header, &flag, NMAIL_IMAP4_USE_UID) >= 0) {
						str.Empty();
						if(NMailImap4GetMimeStructure(m_socket, uid, NMAIL_IMAP4_USE_UID) > 1) {
							str = "Y";
						}
						m_panel->m_list_mail.InsertItem(list_no, str);
						m_panel->m_list_mail.SetItem(list_no, columnSubject, LVIF_TEXT, subject, 0, 0, 0, 0);
						m_panel->m_list_mail.SetItem(list_no, columnFrom, LVIF_TEXT, from, 0, 0, 0, 0);
						m_panel->m_list_mail.SetItem(list_no, columnDate, LVIF_TEXT, date, 0, 0, 0, 0);
						// UIDAbZ[WtOAwb_ۑ
						m_panel->m_list_mail.SetListItemData(list_no, uid, flag, header);
						list_no++;
					}
				}
			}
		} else {
			NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, subject, HEADER_MAX);
			AfxMessageBox(subject);
		}
	}
}

//
//	ݒt@Cǂݏo
//
void CVc6imap4Dlg::ReadIni()
{
	TCHAR name[_MAX_PATH];
	TCHAR drive[_MAX_DRIVE];
	TCHAR directory[_MAX_DIR];
	TCHAR extension[_MAX_EXT];
	TCHAR fname[_MAX_FNAME];
	TCHAR temp[_MAX_PATH];

	GetModuleFileName(NULL, name, sizeof(name));
	GetCurrentDirectory(_MAX_PATH, m_current_path.GetBuffer(_MAX_PATH));
	m_current_path.ReleaseBuffer();
#ifdef _UNICODE
	_wsplitpath(name, drive, directory, fname, extension);
#else
	_splitpath(name, drive, directory, fname, extension);
#endif
	m_ini_path.Format(_T("%s\\%s.ini"), m_current_path, fname);

	m_imap4_auth = GetPrivateProfileInt(INI_SECTION, INI_IMAP4_AUTH, NMAIL_IMAP4_AUTH_LOGIN, m_ini_path);
	m_imap4_port = GetPrivateProfileInt(INI_SECTION, INI_IMAP4_PORT, NMAIL_IMAP4_PORT, m_ini_path);
	m_imap4_ssl = GetPrivateProfileInt(INI_SECTION, INI_IMAP4_SSL, 0, m_ini_path);
	GetPrivateProfileString(INI_SECTION, INI_IMAP4, _T(""), temp, MAX_PATH, m_ini_path);
	m_imap4 = temp;
	m_smtp_auth = GetPrivateProfileInt(INI_SECTION, INI_SMTP_AUTH, 0, m_ini_path);
	m_smtp_port = GetPrivateProfileInt(INI_SECTION, INI_SMTP_PORT, NMAIL_SMTP_PORT, m_ini_path);
	m_smtp_ssl = GetPrivateProfileInt(INI_SECTION, INI_SMTP_SSL, 0, m_ini_path);
	GetPrivateProfileString(INI_SECTION, INI_SMTP, _T(""), temp, MAX_PATH, m_ini_path);
	m_smtp = temp;
	GetPrivateProfileString(INI_SECTION, INI_MAIL_ADDRESS, _T(""), temp, MAX_PATH, m_ini_path);
	m_mail_address = temp;
}

void CVc6imap4Dlg::WritePrivateProfileInt(CString section, CString key, int data)
{
	TCHAR temp[_MAX_PATH];

	wsprintf(temp, _T("%d"), data);
	WritePrivateProfileString(section, key, temp, m_ini_path);
}

//
//	ݒt@C
//
void CVc6imap4Dlg::WriteIni()
{
	WritePrivateProfileInt(INI_SECTION, INI_IMAP4_AUTH, m_imap4_auth);
	WritePrivateProfileInt(INI_SECTION, INI_IMAP4_PORT, m_imap4_port);
	WritePrivateProfileInt(INI_SECTION, INI_IMAP4_SSL, m_imap4_ssl);
	WritePrivateProfileString(INI_SECTION, INI_IMAP4, m_imap4, m_ini_path);
	WritePrivateProfileInt(INI_SECTION, INI_SMTP_AUTH, m_smtp_auth);
	WritePrivateProfileInt(INI_SECTION, INI_SMTP_PORT, m_smtp_port);
	WritePrivateProfileInt(INI_SECTION, INI_SMTP_SSL, m_smtp_ssl);
	WritePrivateProfileString(INI_SECTION, INI_SMTP, m_smtp, m_ini_path);
	WritePrivateProfileString(INI_SECTION, INI_MAIL_ADDRESS, m_mail_address, m_ini_path);
}


BOOL CVc6imap4Dlg::DestroyWindow() 
{
	if(m_socket != INVALID_SOCKET) {
		// 폜tO̗Ă郁[폜
		NMailImap4ExpungeMail(m_socket);
		// ڑI
		NMailImap4Close(m_socket);
		m_socket = INVALID_SOCKET;
	}
	// Winsock I
	NMailEndWinSock();
	// c[yуXg̃f[^j
	m_tree_mailbox.ReleaseAllItemData();
	m_panel->m_list_mail.ReleaseAllItemData();
	// ݒۑ
	WriteIni();

	return CDialog::DestroyWindow();
}

void CVc6imap4Dlg::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu) 
{
	CDialog::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);

	CCmdUI cmdUI;
	cmdUI.m_pMenu = pPopupMenu;
	cmdUI.m_nIndexMax = pPopupMenu->GetMenuItemCount();
	for (cmdUI.m_nIndex = 0 ; cmdUI.m_nIndex < pPopupMenu->GetMenuItemCount() ; cmdUI.m_nIndex++) {
		if(!(cmdUI.m_nID = pPopupMenu->GetMenuItemID(cmdUI.m_nIndex))) {
			continue;
		} else if(cmdUI.m_nID == (UINT)-1) {
			cmdUI.m_pSubMenu = pPopupMenu->GetSubMenu(cmdUI.m_nIndex);
			if(!cmdUI.m_pSubMenu || !(cmdUI.m_nID = cmdUI.m_pSubMenu->GetMenuItemID(0)) || (cmdUI.m_nID == (UINT)-1)) {
				continue;
			}
			cmdUI.DoUpdate(this, FALSE);
		} else {
			cmdUI.m_pSubMenu = NULL;
			cmdUI.DoUpdate(this, cmdUI.m_nID < 0xF000);
		}
	}
}

//
//	j[ԐMڗL
//
void CVc6imap4Dlg::OnUpdateRe(CCmdUI* pCmdUI) 
{
	if(m_panel->m_list_mail.GetSelectedCount() == 0) {
		pCmdUI->Enable(FALSE);
	}
}

//
//	j[폜ڗL
//
void CVc6imap4Dlg::OnUpdateDelete(CCmdUI* pCmdUI) 
{
	if(m_panel->m_list_mail.GetSelectedCount() == 0) {
		pCmdUI->Enable(FALSE);
	}
}

//
//	EChETCYύX
//
void CVc6imap4Dlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	if(m_splitter) {
		m_splitter->AdjustSize();
	}
}

//
//	IMAP4 F
//	ڑĂȂΐڑĔF
//
BOOL CVc6imap4Dlg::Authenticate()
{
	m_timer = CONTINUE_TIMER_COUNT;
	if(m_socket == INVALID_SOCKET) {
		// ڑĂȂΐڑ
		if((m_socket = NMailImap4ConnectSsl(m_imap4, m_imap4_port, m_imap4_ssl, NULL)) != INVALID_SOCKET) {
			// IMAP4 F
			if(NMailImap4Authenticate(m_socket, m_id, m_password, m_imap4_auth) == NMAIL_SUCCESS) {
				return TRUE;
			} else {
				CString str, err;
				NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, err.GetBuffer(MAX_PATH), MAX_PATH);
				err.ReleaseBuffer();
				str.Format(_T("IMAP4 F؎sB\r\n[%s]"), err);
				AfxMessageBox(str);
			}
		} else {
			CString str, err;
			NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, err.GetBuffer(MAX_PATH), MAX_PATH);
			err.ReleaseBuffer();
			str.Format(_T("IMAP4 T[oɐڑł܂łB\r\n[%s]"), err);
			AfxMessageBox(str);
		}
		NMailImap4Close(m_socket);
		m_socket = INVALID_SOCKET;
		m_id.Empty();
		m_password.Empty();
		return FALSE;
	}
	return TRUE;
}

//
//	[{bNXꗗ擾Ac[\
//
BOOL CVc6imap4Dlg::GetMailBoxTree()
{
	int no, count, flag;
	HTREEITEM ht;
	TCHAR separate[2], mailbox[MAX_PATH];

	m_tree_mailbox.ReleaseAllItemData();
	m_tree_mailbox.DeleteAllItems();
	if(Authenticate()) {
		ht = m_tree_mailbox.InsertItem(m_mail_address, iconUser, iconUser);
		DoEvents();
		count = NMailImap4GetMailBoxList(m_socket, _T(""), _T("*"), 0);
		for(no = 0 ; no < count ; no++) {
			NMailImap4GetMailBoxListStatus(m_socket, no, &flag, separate, mailbox, MAX_PATH);
			if(!_tcsicmp(mailbox, MailboxInbox)) {
				if(m_mailbox.IsEmpty()) {
					// [{bNXIĂȂ INBOX I
					m_mailbox = mailbox;
				}
			// Trash ΃S~tH_Ƃ
			} else if(!_tcsicmp(mailbox, MailboxTrash)) {
				m_trash = mailbox;
			// Sent ΑMσtH_Ƃ
			} else if(!_tcsicmp(mailbox, MailboxSent)) {
				m_sent = mailbox;
			}
			m_tree_mailbox.AddPathItem(mailbox, separate, flag);
		}
		m_tree_mailbox.Expand(ht, TVE_EXPAND);
		m_tree_mailbox.SelectFolder(m_mailbox);
	}
	return FALSE;
}

//
//	pl(Ejł̃}EX
//
LRESULT CVc6imap4Dlg::OnPanelCommand(WPARAM wParam, LPARAM lParam)
{
	// [ꗗNbN
	if(wParam == NM_CLICK) {
		CString body;
		int no = lParam;

		// F
		if(Authenticate()) {
			// [{bNXI
			if(NMailImap4SelectMailBox(m_socket, m_mailbox, FALSE) >= 0) {
				DWORD uid = m_panel->m_list_mail.GetUid(no);
				int count, list_count;
				CString str;
				CString name, value;
				SHFILEINFO sf;

				m_panel->m_list_attach.DeleteAllItems();
				m_panel->m_icon_list.DeleteImageList();
				m_panel->m_icon_list.Create(16, 16, ILC_COLOR32 | ILC_MASK, 0, 0);
				// MIME \擾
				if((count = NMailImap4GetMimeStructure(m_socket, uid, NMAIL_IMAP4_USE_UID)) > 0) {
					list_count = 0;
					for(int bno = 0 ; bno < count ; bno++) {
						// Content-Type  SubType 擾
						NMailImap4GetMimeStructureStatus(m_socket, NMAIL_IMAP4_MIME_CONTENT_TYPE_AND_SUBTYPE, bno, 0, name.GetBuffer(MAX_PATH), value.GetBuffer(MAX_PATH), MAX_PATH);
						name.ReleaseBuffer();
						value.ReleaseBuffer();
						// {ȂΕ\
						if(!name.CompareNoCase(_T("text")) && !value.CompareNoCase(_T("plain"))) {
							// {TCY擾
							int size = NMailImap4GetMimeStructureStatus(m_socket, NMAIL_IMAP4_MIME_CONTENT_SIZE, bno, 0, NULL, NULL, 0);
							// {擾
							NMailImap4GetMimePart(m_socket, uid, bno, body.GetBuffer(size + 1), NMAIL_IMAP4_USE_UID);
							body.ReleaseBuffer();
							// {\
							m_panel->m_edit_body.SetWindowText(body);
						} else if(name.CompareNoCase(_T("multipart"))) {
							// Ytt@CȂΓYtt@Cꗗɒǉ
							// t@C擾
							NMailImap4GetMimeStructureStatus(m_socket, NMAIL_IMAP4_MIME_CONTENT_FILE_NAME, bno, 0, name.GetBuffer(MAX_PATH), NULL, MAX_PATH);
							name.ReleaseBuffer();
							if(!name.CompareNoCase(_T("noname.html"))) {
								name = _T("{.html");
							}
							// ΉACR擾
							SHGetFileInfo(name, NULL, &sf, sizeof(SHFILEINFO), SHGFI_ICON | SHGFI_SMALLICON | SHGFI_USEFILEATTRIBUTES);
							HICON hicon = sf.hIcon;							
							// C[WXgɃACRǉ
							m_panel->m_icon_list.SetImageCount(list_count + 1);
							m_panel->m_icon_list.Replace(list_count, hicon);
							DestroyIcon(hicon);
							// Ytt@Cꗗɒǉ
							m_panel->m_list_attach.InsertItem(list_count, name, list_count);
							// MIME \̔ԍf[^Ƃĕۑ
							m_panel->m_list_attach.SetItemData(list_count, bno);
							list_count++;
						}
					}
				}
				if(list_count > 0) {
					// Ytt@C݂Έꗗp̃Xgr[\
					m_panel->m_list_attach.SetImageList(&m_panel->m_icon_list, LVSIL_SMALL);
					m_panel->m_list_attach.ShowWindow(SW_SHOW);
				} else {
					m_panel->m_list_attach.ShowWindow(SW_HIDE);
				}
				m_panel->AdjustSize();
			}
		}
	// ENbN
	} else if(wParam == NM_RCLICK) {
		CMenu pm, *sm;
		POINT pt;

		// [ꗗŉENbN
		if((CWnd *)lParam == &m_panel->m_list_mail) {
			if(m_panel->m_list_mail.GetSelectedCount() > 0) {
				pm.LoadMenu(IDR_MENU_POPUP);
				sm = pm.GetSubMenu(0);
				GetCursorPos(&pt);
				sm->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, this);
			}
		// Ytt@CꗗŉENbN
		} else if((CWnd *)lParam == &m_panel->m_list_attach) {
			if(m_panel->m_list_attach.GetSelectedCount() > 0) {
				pm.LoadMenu(IDR_MENU_POPUP);
				sm = pm.GetSubMenu(2);
				GetCursorPos(&pt);
				sm->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, this);
			}
		}
	} else if(wParam == NM_DBLCLK) {
		// Ytt@CJ
		OpenAttachFile();
	}
	return 0;
}

//
//	[{bNXc[\̑IύX
//
void CVc6imap4Dlg::OnSelchangedTreeMailbox(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	if(pNMTreeView->itemNew.hItem != NULL) {
		// c[ڂɑΉ郁[{bNX擾
		m_mailbox = m_tree_mailbox.GetFolderName(pNMTreeView->itemNew.hItem);
		// [ꗗXV
		PostMessage(WM_COMMAND, IDM_READ);
	}
	*pResult = 0;
}

//
//	[{bNXc[\ŉENbN
//
void CVc6imap4Dlg::OnRclickTreeMailbox(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CPoint pt, hpt;
	CMenu pm, *sm = NULL;

	GetCursorPos(&pt);
	hpt = pt;
	m_tree_mailbox.ScreenToClient(&hpt);
	HTREEITEM ht = m_tree_mailbox.HitTest(hpt);
	if(ht != NULL) {
		m_tree_mailbox.SelectItem(ht);
		DoEvents();
		CString folder = m_tree_mailbox.GetFolderName(ht);
		pm.LoadMenu(IDR_MENU_POPUP);
		sm = pm.GetSubMenu(1);
		sm->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, this);
	}
	*pResult = 0;
}

//
//	[{bNX쐬
//
void CVc6imap4Dlg::OnCreateMailbox() 
{
	HTREEITEM ht = m_tree_mailbox.GetSelectedItem();
	if(ht != NULL) {
		CName dlg(this);
		// [{bNX
		if(dlg.DoModal() == IDOK) {
			CString name = m_tree_mailbox.GetFolderName(ht);
			CString separate = m_tree_mailbox.GetFolderSeparate(ht);
			int folder_flag = m_tree_mailbox.GetFolderFlag(ht);
			// ݑIĂ郁[{bNX{͂
			// ̕쐬
			name += separate + dlg.m_mailbox;
			// F
			if(Authenticate()) {
				// [{bNX쐬
				if(NMailImap4CreateMailBox(m_socket, name) == NMAIL_SUCCESS) {
					m_tree_mailbox.AddPathItem(name, separate, folder_flag);
					m_tree_mailbox.Expand(ht, TVE_EXPAND);
				} else {
					CString str, err;
					NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, err.GetBuffer(MAX_PATH), MAX_PATH);
					err.ReleaseBuffer();
					str.Format(_T("[{bNX %s 쐬ł܂łB\r\n[%s]"), dlg.m_mailbox, err);
					AfxMessageBox(str);
				}
			}
		}
	}
}

//
//	[{bNX쐬ڂ̗L
//
void CVc6imap4Dlg::OnUpdateCreateMailbox(CCmdUI* pCmdUI) 
{
	BOOL flag = FALSE;
	HTREEITEM ht = m_tree_mailbox.GetSelectedItem();
	if(ht != NULL) {
		int folder_flag = m_tree_mailbox.GetFolderFlag(ht);
		if(folder_flag != -1 && (folder_flag & NMAIL_IMAP4_MAILBOX_NO_INFERIOUS) == 0) {
			flag = TRUE;
		}
	}
	pCmdUI->Enable(flag);
}

//
//	q[{bNX폜
//
BOOL CVc6imap4Dlg::DeleteChildMailbox(HTREEITEM ht, BOOL flag)
{
	HTREEITEM htc;

	// F
	while(ht != NULL) {
		htc = m_tree_mailbox.GetChildItem(ht);
		if(htc != NULL) {
			// q[{bNX폜
			if(!DeleteChildMailbox(htc, FALSE)) {
				return FALSE;
			}
		}
		// [{bNX擾
		CString name = m_tree_mailbox.GetFolderName(ht);
		// [{bNX폜
		if(NMailImap4DeleteMailBox(m_socket, name) != NMAIL_SUCCESS) {
			return FALSE;
		}
		// f[^j
		TreeItemData *item = reinterpret_cast<TreeItemData *>(m_tree_mailbox.GetItemData(ht));
		if(item != NULL) {
			delete item;
		}
		if(flag) {
			break;
		}
		ht = m_tree_mailbox.GetNextSiblingItem(ht);
	}
	return TRUE;
}

//
//	[{bNX̍폜
//
void CVc6imap4Dlg::OnDeleteMailbox() 
{
	HTREEITEM ht = m_tree_mailbox.GetSelectedItem();
	if(ht != NULL) {
		CString str;
		str.Format(_T("[{bNX %s 폜܂H"), m_tree_mailbox.GetItemText(ht));
		if(AfxMessageBox(str, MB_YESNO) == IDYES) {
			if(Authenticate()) {
				if(DeleteChildMailbox(ht, TRUE)) {
					m_tree_mailbox.DeleteItem(ht);
				} else {
					CString err;
					NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, err.GetBuffer(MAX_PATH), MAX_PATH);
					err.ReleaseBuffer();
					str.Format(_T("[{bNX %s ͍폜ł܂łB\r\n[%s]"), m_tree_mailbox.GetItemText(ht), err);
					AfxMessageBox(str);
				}
			}
		}
	}
}

//
//	[{bNX폜̗L
//
void CVc6imap4Dlg::OnUpdateDeleteMailbox(CCmdUI* pCmdUI) 
{
	BOOL flag = FALSE;
	HTREEITEM ht = m_tree_mailbox.GetSelectedItem();
	if(ht != NULL) {
		CString name = m_tree_mailbox.GetFolderName(ht);
		if(!name.IsEmpty() && name.CompareNoCase(MailboxInbox) && name.CompareNoCase(MailboxTrash) && name.CompareNoCase(MailboxSent)) {
			flag = TRUE;
		}
	}
	pCmdUI->Enable(flag);
}

//
//	[{bNXύXJn
//
void CVc6imap4Dlg::OnRenameMailbox() 
{
	HTREEITEM ht = m_tree_mailbox.GetSelectedItem();
	if(ht != NULL) {
		m_tree_mailbox.SetFocus();
		m_tree_mailbox.EditLabel(ht);
	}
}

//
//	[{bNXύX̗L
//
void CVc6imap4Dlg::OnUpdateRenameMailbox(CCmdUI* pCmdUI) 
{
	BOOL flag = FALSE;
	HTREEITEM ht = m_tree_mailbox.GetSelectedItem();
	if(ht != NULL) {
		CString name = m_tree_mailbox.GetFolderName(ht);
		if(!name.IsEmpty() && name.CompareNoCase(MailboxInbox) && name.CompareNoCase(MailboxTrash) && name.CompareNoCase(MailboxSent)) {
			flag = TRUE;
		}
	}
	pCmdUI->Enable(flag);
}

//
//	bZ[W
//
void CVc6imap4Dlg::DoEvents()
{
	MSG msg;

	while(::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
		if(!::IsDialogMessage(m_hWnd, &msg)) {
			::TranslateMessage(&msg);
			::DispatchMessage(&msg);
		}
	}
}


//
//	[{bNXύXI
//
void CVc6imap4Dlg::OnEndlabeleditTreeMailbox(NMHDR* pNMHDR, LRESULT* pResult) 
{
	TV_DISPINFO* pTVDispInfo = (TV_DISPINFO*)pNMHDR;
	*pResult = 0;
	if(pTVDispInfo->item.hItem != NULL) {
		// ύXꂽ̂擾
		CString new_name = pTVDispInfo->item.pszText;
		if(!new_name.IsEmpty()) {
			// F
			if(Authenticate()) {
				CString old_name = m_tree_mailbox.GetItemText(pTVDispInfo->item.hItem);
				CString old_mailbox, new_mailbox, separate;

				// [{bNXV[{bNX쐬
				old_mailbox = m_tree_mailbox.GetFolderName(pTVDispInfo->item.hItem);
				separate = m_tree_mailbox.GetFolderSeparate(pTVDispInfo->item.hItem);
				CStrSplit sp(old_mailbox, separate);
				if(sp.GetSize() == 1) {
					new_mailbox = new_name;
				} else {
					new_mailbox = sp[0];
					for(int no = 1 ; no < sp.GetSize() - 1 ; no++) {
						new_mailbox += separate + sp[no];
					}
					new_mailbox += separate + new_name;
				}
				// [{bNX̕ύX
				if(NMailImap4RenameMailBox(m_socket, old_mailbox, new_mailbox) == NMAIL_SUCCESS) {
					// tH_̍XV
					m_tree_mailbox.ChangeItemString(old_mailbox, new_mailbox);
					*pResult = 1;
				} else {
					CString str, err;
					NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, err.GetBuffer(MAX_PATH), MAX_PATH);
					err.ReleaseBuffer();
					str.Format(_T("[{bNX %s  %s ɖ̕ύXł܂łB\r\n[%s]"), old_name, new_name, err);
					AfxMessageBox(str);
				}
			}
		}
	}
}

//
//	[{bNXύXJn
//
void CVc6imap4Dlg::OnBeginlabeleditTreeMailbox(NMHDR* pNMHDR, LRESULT* pResult) 
{
	TV_DISPINFO* pTVDispInfo = (TV_DISPINFO*)pNMHDR;
	*pResult = 1;
	if(pTVDispInfo->item.hItem != NULL) {
		CString name = m_tree_mailbox.GetFolderName(pTVDispInfo->item.hItem);
		// MAS~AMς͕ύXs
		if(!name.IsEmpty() && name.CompareNoCase(MailboxInbox) && name.CompareNoCase(MailboxTrash) && name.CompareNoCase(MailboxSent)) {
			*pResult = 0;
		}
	}
}

BOOL CVc6imap4Dlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message == WM_KEYDOWN) {
		if(pMsg->wParam == 0x0d || pMsg->wParam == 0x1b) {
			CEdit *edit = m_tree_mailbox.GetEditControl();
			if(edit != NULL) {
				// c[\̕ύX Enter/Esc L
				if(pMsg->hwnd == edit->m_hWnd) {
					return FALSE;
				}
			}
			if(pMsg->wParam == VK_ESCAPE) {
				return TRUE;
			}
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

//
//	[̈ړ
//
LRESULT CVc6imap4Dlg::OnCopyMailbox(WPARAM wParam, LPARAM lParam)
{
	HTREEITEM htdst;
	CString dst;
	BOOL flag = FALSE;

	// Rs[̃[{bNX擾
	htdst = (HTREEITEM)wParam;
	dst = m_tree_mailbox.GetFolderName(htdst);

	int no = m_panel->m_list_mail.GetNextItem(-1, LVNI_SELECTED);
	if(no != -1) {
		// F
		if(Authenticate()) {
			// Rs[[{bNXI
			if(NMailImap4SelectMailBox(m_socket, m_mailbox, FALSE) >= 0) {
				DWORD uid = m_panel->m_list_mail.GetUid(no);
				// [Rs[
				if(NMailImap4CopyMail(m_socket, uid, dst, NMAIL_IMAP4_USE_UID) == NMAIL_SUCCESS) {
					// 烁[폜(폜tOt)
					if(NMailImap4DeleteMail(m_socket, uid, NMAIL_IMAP4_USE_UID) == NMAIL_SUCCESS) {
						flag = TRUE;
					}
				}
			}
		}
	}
	return flag;
}

//
//	^C}
//
void CVc6imap4Dlg::OnTimer(UINT nIDEvent) 
{
	if(m_timer > 0) {
		m_timer--;
		if(m_timer == 0 && m_socket != INVALID_SOCKET) {
			// 莞ԒʐM̏ꍇ No Operation R}h𔭍s
			if(NMailImap4NoOperation(m_socket) == NMAIL_SUCCESS) {
				m_timer = CONTINUE_TIMER_COUNT;
			} else {
				NMailImap4Close(m_socket);
				m_socket = INVALID_SOCKET;
			}
		}
	}
	CDialog::OnTimer(nIDEvent);
}

//
//	vpeB\
//
void CVc6imap4Dlg::OnProperty() 
{
	int no = m_panel->m_list_mail.GetNextItem(-1, LVNI_SELECTED);
	if(no != -1) {
		// F
		if(Authenticate()) {
			// [{bNXI
			if(NMailImap4SelectMailBox(m_socket, m_mailbox, FALSE) >= 0) {
				DWORD uid = m_panel->m_list_mail.GetUid(no);
				int count;
				// MIME \擾
				if((count = NMailImap4GetMimeStructure(m_socket, uid, NMAIL_IMAP4_USE_UID)) > 0) {
					CMimeList dlg(this);
					// wb_ݒ
					dlg.m_header = m_panel->m_list_mail.GetHeader(no);
					// MIME \_CAOŕ\邽߂ɒln
					dlg.SetSocket(m_socket, uid, count);
					dlg.DoModal();
				}
			}
		}
	}
}

//
//	vpeB\̗L
//
void CVc6imap4Dlg::OnUpdateProperty(CCmdUI *pCmdUI) 
{
	if(m_panel->m_list_mail.GetSelectedCount() == 0) {
		pCmdUI->Enable(FALSE);
	}
}

//
//	Ytt@CۑAJ
//
void CVc6imap4Dlg::OpenAttachFile()
{
	int no = m_panel->m_list_mail.GetNextItem(-1, LVNI_SELECTED);
	if(no != -1) {
		DWORD uid = m_panel->m_list_mail.GetUid(no);
		no = m_panel->m_list_attach.GetNextItem(-1, LVNI_SELECTED);
		if(no != -1) {
			// F
			if(Authenticate()) {
				int err;
				CString path, name, value;

				// e|tH_擾
				GetTempPath(MAX_PATH, path.GetBuffer(MAX_PATH));
				path.ReleaseBuffer();

				// w MIME p[ge|tH_ɃfR[hĕۑ
				err = NMailImap4SaveMimePart(m_socket, uid, static_cast<int>(m_panel->m_list_attach.GetItemData(no)), path, name.GetBuffer(MAX_PATH), NMAIL_IMAP4_USE_UID);
				name.ReleaseBuffer();
				if(err == NMAIL_SUCCESS) {
					// ۑȂJ
					::ShellExecute(m_hWnd, _T("open"), path + name, NULL, NULL, SW_SHOW);
				}
			}
		}
	}
}

//
//	t@CJ
//
void CVc6imap4Dlg::OnOpenFile() 
{
	OpenAttachFile();
}

//
//	t@CJ̗L
//
void CVc6imap4Dlg::OnUpdateOpenFile(CCmdUI* pCmdUI) 
{
	if(m_panel->m_list_attach.GetSelectedCount() == 0) {
		pCmdUI->Enable(FALSE);
	}
}

//
//	t@C̕ۑ
//
void CVc6imap4Dlg::OnSaveFile() 
{
	int no = m_panel->m_list_mail.GetNextItem(-1, LVNI_SELECTED);
	if(no != -1) {
		DWORD uid = m_panel->m_list_mail.GetUid(no);
		no = m_panel->m_list_attach.GetNextItem(-1, LVNI_SELECTED);
		if(no != -1) {
			// F
			if(Authenticate()) {
				int err;
				CString name, str;

				name = m_panel->m_list_attach.GetItemText(no, 0);
				CFileDialog dlg(FALSE, _T("*.*"), name, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, _T("SẴt@C(*.*)|*.*||"), this);
				if(dlg.DoModal() == IDOK) {
					// t@C̕ۑ
					err = NMailImap4SaveMimePart(m_socket, uid, m_panel->m_list_attach.GetItemData(no), dlg.GetPathName(), name.GetBuffer(MAX_PATH), NMAIL_IMAP4_MIME_PART_SAVE_AS_FILE | NMAIL_IMAP4_USE_UID);
					name.ReleaseBuffer();
					if(err == NMAIL_SUCCESS) {
						str.Format(_T("%s ۑ܂"), name);
					} else {
						str.Format(_T("%s ͕ۑł܂ł"), name);
					}
					AfxMessageBox(str);
				}
			}
		}
	}
}

//
//	t@C̕ۑ̗L
//
void CVc6imap4Dlg::OnUpdateSaveFile(CCmdUI* pCmdUI) 
{
	if(m_panel->m_list_attach.GetSelectedCount() == 0) {
		pCmdUI->Enable(FALSE);
	}
}


void CVc6imap4Dlg::OnClickTreeMailbox(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;
}
