unit unite;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TUniteForm = class(TForm)
    FileListBox: TListBox;
    Label1: TLabel;
    AddButton: TButton;
    UniteButton: TButton;
    CancelButton: TButton;
    OpenDialog: TOpenDialog;
    Label2: TLabel;
    FolderEdit: TEdit;
    procedure AddButtonClick(Sender: TObject);
    procedure UniteButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
	PartialNo: Integer;
	PartialId: String;
  public
    { Public 錾 }
  end;

const
  HEADER_MAX = 8192;

var
  UniteForm: TUniteForm;

implementation

{$R *.DFM}

uses nMail;

procedure TUniteForm.AddButtonClick(Sender: TObject);
var
  Fs: TFileStream;
  No: Integer;
  Buffer: PChar;
  Id: array [0..HEADER_MAX] of Char;
begin
	// t@CI[v_CAO\
	if OpenDialog.Execute then
	begin
		// t@CJēǂݍ
		Fs := TFileStream.Create(OpenDialog.FileName, fmOpenRead);
		GetMem(Buffer, Fs.Size);
		Fs.ReadBuffer(Buffer^, Fs.Size);
		Fs.Free;
		// Ytt@Ct`FbN
		No := NMailAttachmentFileStatus(Buffer, Id, HEADER_MAX);
		// ŏ̃t@CœYtt@CtA
        // [ԍv邩`FbN
        if ((No = 0) and (FileListBox.Items.Count = 0))
          or (No = PartialNo) then
		begin
			// [f[^̈ԖڂȂ ID ۑ
			if No = 1 then
				PartialId := StrPas(Id);
			// ĂȂ[f[^A
			// ID vΐ[f[^Ƃ
            // Xgɒǉ
            if (No = 0) or (PartialId = StrPas(Id)) then
			begin
	      		FileListBox.Items.Add(OpenDialog.FileName);
				// [ԍ{P
				Inc(PartialNo);
				// {^gpɂ
				UniteButton.Enabled := True;
			end
            else
            	ShowMessage('ꂽ[f[^v܂B');
		end
        else
        begin
			if No < 0 then
				ShowMessage('Ytt@C݂܂')
			else
				ShowMessage('ꂽ[f[^̏Ԃ܂B');
		end;
	end;
end;

procedure TUniteForm.UniteButtonClick(Sender: TObject);
var
  Ret, No: Integer;
  Fs: TFileStream;
  Body, Buffer: PChar;
  Temp: array [0..NMAIL_ATTACHMENT_TEMP_SIZE] of Char;
  Subject: array [0..HEADER_MAX] of Char;
  Date: array [0..HEADER_MAX] of Char;
  From: array [0..HEADER_MAX] of Char;
  Header: array [0..HEADER_MAX] of Char;
  FileName: array [0..HEADER_MAX] of Char;
begin
  if FileListBox.Items.Count > 0 then
  begin
     Ret := NMAIL_ERROR;
	 for No := 0 to FileListBox.Items.Count - 1 do
	 begin
    	// Xg̃t@CԂɓǂݍ
		Fs := TFileStream.Create(FileListBox.Items[No], fmOpenRead);
		Buffer := AllocMem(Fs.Size + 1);
        Fs.ReadBuffer(Buffer^, Fs.Size);
		// ŏ̃f[^H
		if No = 0 then
		begin
			// {p̃obt@m
			GetMem(Body, Fs.Size);
			// Ytt@ČAWJJn
			Ret := NMailAttachmentFileFirst(Temp, Subject, Date, From, Header, Body, PChar(FolderEdit.Text), FileName, Buffer, nil);
		end
		else
		begin
			// Ytt@Č
        	Ret := NMailAttachmentFileNext(Temp, Buffer, nil);
		end;
		Fs.Free;
		FreeMem(Buffer);
		if Ret = NMAIL_ERROR_FILE_OPEN then
			break;
	 end;
     // Ytt@ČI
	 NMailAttachmentFileClose(Temp);
 	 // I?
	 if Ret = NMAIL_SUCCESS then
	 begin
		ShowMessage(FolderEdit.Text + ' ɓYtt@C ' + FileName + ' 쐬܂B' + #13#10#13#10 + '{:' + #13#10 + StrPas(Body));
		ModalResult := mrOk;
	 end
	 else if Ret = NMAIL_ERROR_FILE_OPEN then
	  	// 炭o̓tH_ԈĂ
       	ShowMessage('Ytt@CI[vł܂B')
	 else if Ret = NMAIL_ERROR_PARTIAL then
	  	// ǉŏԂ`FbNĂ̂ŁANMAIL_ERROR_INVALID_NO
        // ͔Ȃ͂B
		ShowMessage('ꂽ[SđĂ܂B');
     // [NNA
     FreeMem(Body);
  end;
end;

procedure TUniteForm.FormCreate(Sender: TObject);
begin
	// o̓tH_ɃJgfBNg
	FolderEdit.Text := GetCurrentDir;
end;

procedure TUniteForm.FormActivate(Sender: TObject);
begin
	// ԍ 1 ɏ
	PartialNo := 1;
	// Xg̓NA
	FileListBox.Items.Clear;
	// {^͎gps
	UniteButton.Enabled := False;
end;

end.
