unit testmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Winsock, ExtCtrls, ComCtrls, Menus, IniFiles;

const
  WM_START_APP = (WM_APP + $0001);

type
  TMainForm = class(TForm)
    MailListView: TListView;
    Splitter1: TSplitter;
    BodyMemo: TMemo;
    MainMenu: TMainMenu;
    File1: TMenuItem;
    mCreate: TMenuItem;
    N1: TMenuItem;
    mExit: TMenuItem;
    S1: TMenuItem;
    mSetting: TMenuItem;
    N2: TMenuItem;
    mDelete: TMenuItem;
    PopupMenu: TPopupMenu;
    mPopupReply: TMenuItem;
    N3: TMenuItem;
    mPopupDelete: TMenuItem;
    mReply: TMenuItem;
    N4: TMenuItem;
    mRenewal: TMenuItem;
    mSave: TMenuItem;
    N5: TMenuItem;
    SaveDialog: TSaveDialog;
    mAttachment: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MailListViewClick(Sender: TObject);
    procedure mCreateClick(Sender: TObject);
    procedure mExitClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure mSettingClick(Sender: TObject);
    procedure MailListViewMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mDeleteClick(Sender: TObject);
    procedure mPopupReplyClickClick(Sender: TObject);
    procedure mRenewalClick(Sender: TObject);
    procedure mSaveClick(Sender: TObject);
    procedure mAttachmentClick(Sender: TObject);
  private
    { Private 錾 }
    Id: String;       // ID
    Password: String; // pX[h
    Pop3Name: String; // POP3T[o[
    APopFlag: Boolean; // APOP gp邩
    Pop3Port: Integer; // POP3 |[gԍ
    Pop3Ssl: Integer;    // POP3 SSL
    procedure AddMailList;  // 薼ꗗListViewɕ\
	procedure HeaderDataClear;
  public
    { Public 錾 }
    SmtpName: String;    // SMTPT[o[
    SmtpPort: Integer;   // SMTP |[gԍ
    SmtpAuth: Integer;   // SMTPF
    SmtpSsl: Integer;    // SMTP SSL
    MailAddress: String; // [AhX
    procedure WMStartApp(var Msg: TMessage); message WM_START_APP;
  end;

const
  OptionSection = 'DPMAIL';
  OptionApopFlag = 'ApopFlag';
  OptionSmtpName = 'SmtpName';
  OptionSmtpPortName = 'SmtpPort';
  OptionSmtpSslName = 'SmtpSsl';
  OptionSmtpAuthName = 'SmtpAuth';
  OptionPop3Name = 'Pop3Name';
  OptionPop3PortName = 'Pop3Port';
  OptionPop3SslName = 'Pop3Ssl';
  OptionMailAddress = 'MailAddress';

  HEADER_MAX = 8192;

var
  MainForm: TMainForm;

implementation

uses nMail, Input, write, Option, unite;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
var
  W: integer;
  IniFileName: TFileName;
  IniFile: TIniFile;
begin
    // dpmail.ini ݒǂݍ
    IniFileName := ChangeFileExt(Application.ExeName, '.INI');
    IniFile := TIniFile.Create(IniFileName);
    try
        with IniFile do
        begin
            APopFlag := ReadBool(OptionSection, OptionApopFlag, False);
            SmtpName := ReadString(OptionSection, OptionSmtpName, '');
            SmtpPort := ReadInteger(OptionSection, OptionSmtpPortName, 25);
            SmtpSsl := ReadInteger(OptionSection, OptionSmtpSslName, 0);
            SmtpAuth := ReadInteger(OptionSection, OptionSmtpAuthName, 0);
            Pop3Name := ReadString(OptionSection, OptionPop3Name, '');
            Pop3Port := ReadInteger(OptionSection, OptionPop3PortName, 110);
            Pop3Ssl := ReadInteger(OptionSection, OptionPop3SslName, 0);
            MailAddress := ReadString(OptionSection, OptionMailAddress, '');
        end;
        finally
            IniFile.Free;
    end;
    // ListView ̍ڕݒ
    W := MailListView.ClientWidth - GetSystemMetrics(SM_CXVSCROLL);
    MailListView.Columns[0].Width := W div 2;
    MailListView.Columns[1].Width := W div 4;
	MailListView.Columns[2].Width := W div 4;

    // Winsock 
    NMailInitializeWinSock;

    // ^CAEg̓ftHg(30b)
    // wb_ől 8192
    // {ől͖
    NMailSetParameter(0, HEADER_MAX, 0);

    PostMessage(Handle, WM_START_APP, 0, 0);
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    // Winsock gpI
    NMailEndWinsock;
end;

procedure TMainForm.WMStartApp(var Msg: TMessage);
begin
    // ݒ肪ĂȂꍇ͐ݒ_CAO\
    if (Pop3Name = '') Or (Pop3Port = 0) then
        mSettingClick(nil);

    // 薼ꗗǂݍ
    AddMailList;
end;

procedure TMainForm.MailListViewClick(Sender: TObject);
var
  Subject: array [0..HEADER_MAX] of Char;
  Date: array [0..HEADER_MAX] of Char;
  From: array [0..HEADER_MAX] of Char;
  Header: array [0..HEADER_MAX] of Char;
  Body: PChar;
  Size: Integer;
  S: TSocket;
begin
	mSave.Enabled := False;
	mReply.Enabled := False;
    with MailListView do
    begin
        // IĂ邩H
        if SelCount > 0 then
        begin
            // Ă킩܂AM̂тɐڑĂ܂B
            // {ł ID pX[h͌AxɎMA
            // T[o[ォM[폜At@C
            // ۑĂA薼ꗗNbNł́AۑĂ郁[
            // ǂݍޏׂł傤B

            // POP3 T[o[ɐڑ
            S := NMailPop3ConnectSsl(PChar(Pop3Name), Pop3Port, Pop3Ssl, nil);
            if S <> INVALID_SOCKET then
            begin
                // IĂԍA[̐菭ȂH
                if Selected.Index < NMailPop3Authenticate(S, PChar(Id), PChar(Password), ApopFlag) then
                begin
                    // [̃TCY𓾂āAm
                    Size := NMailPop3GetMailSize(S, Selected.Index + 1);
                    GetMem(Body, Size);
                    // [ǂݍ
                    NMailPop3GetMail(S, Selected.Index + 1, subject, date, from, header, Body, nil, nil);
                    // \p Memo NAĎMeǉB
                    BodyMemo.Lines.Clear;
                    BodyMemo.Lines.Add(Strpas(Body));
                    // J[\擪Ɉړ
                    BodyMemo.SelStart := 0;
                    BodyMemo.SelLength := 0;
                    // mۂJ
                    FreeMem(Body);
                end;
            end;
            // ڑI
            NMailPop3Close(S);
            S := INVALID_SOCKET;

			mSave.Enabled := True;
			mReply.Enabled := True;
		end;
    end;
end;

procedure TMainForm.HeaderDataClear;
var
  No: Integer;
begin
	for No := 0 to MailListView.Items.Count - 1 do
	begin
		FreeMem(MailListView.Items[No].Data);
	end;
end;

procedure TMainForm.AddMailList;
var
  No, Count: integer;
  Subject: array [0..HEADER_MAX] of Char;
  Date: array [0..HEADER_MAX] of Char;
  From: array [0..HEADER_MAX] of Char;
  Header: PChar;
  Msg: String;
  I: TListItem;
  S: TSocket;
begin
    // [{\NA
    BodyMemo.Lines.Clear;
    // ListView NA
	HeaderDataClear;
    MailListView.Items.Clear;
    // POP3 T[oɐڑ
    S := NMailPop3ConnectSsl(PChar(Pop3Name), Pop3Port, Pop3Ssl, nil);
    if S <> INVALID_SOCKET then
    begin
        if (Id = '') or (Password = '') then
        begin
           // ID ƃpX[h
           if InputForm.ShowModal = mrOk then
           begin
                Id := InputForm.IdEdit.Text;
                Password := InputForm.PasswordEdit.Text;
           end
           else
               Exit;
        end;
        // [̐𓾂
        No := NMailPop3Authenticate(S, PChar(Id), PChar(Password), ApopFlag);
        if No >= 0 then
        begin
            for Count := 1 to No do
            begin
				GetMem(Header, HEADER_MAX);
                // ԂɃwb_̓eǂ݁AListView ɒǉ
                NMailPop3GetMailStatus(S, Count, Subject, Date, From, Header, False);
                I := MailListView.Items.Add;
                I.Caption := StrPas(Subject);
                I.SubItems.Add(StrPas(Date));
                I.SubItems.Add(StrPas(From));
				I.Data := Header;
				StrLCat(Header, #13#10, HEADER_MAX - 1);
            end;
        end
        else
		begin
			NMailGetMessage(NMAIL_GET_ERROR_MESSAGE, Subject, HEADER_MAX);
			Msg := 'OCł܂ł' + #13#10 + StrPas(Subject) + ' ' + IntToStr(No);
            MessageDlg(Msg, mtError, [mbOk], 0);
            Id := '';
            Password := '';
		end;
        NMailPop3Close(S);
    end;
end;

procedure TMainForm.mCreateClick(Sender: TObject);
var
  No, Ret: integer;
  Body: String;
  S: TSocket;
begin
	// ͗NA
	WriteForm.ToEdit.Text := '';
	WriteForm.SubjectEdit.Text := '';
	WriteForm.AttachEdit.Text := '';
	WriteForm.BodyMemo.Lines.Clear;
    // [̈e
    if WriteForm.ShowModal = mrOk then
    begin
        // ͓e Body ɓ
        Body := '';
        for No := 0 to WriteForm.BodyMemo.Lines.Count - 1 do
            Body := Body + WriteForm.BodyMemo.Lines.Strings[No] + #13#10;

        // [M
        if not FileExists(WriteForm.AttachEdit.Text) then
            WriteForm.AttachEdit.Text := '';

        Ret := NMAIL_ERROR;
        S := NMailSmtpConnectSsl(PChar(SmtpName), SmtpPort, SmtpSsl, nil);
        if S <> INVALID_SOCKET Then
        begin
            Ret := NMailSmtpAuthenticate(S, PChar(SmtpName), PChar(Id), PChar(Password), SmtpAuth);
            if Ret >= 0 Then
            begin
                Ret := NMailSmtpSendMailEx(S, PChar(WriteForm.ToEdit.Text), nil, nil
                  , PChar(MailAddress), PChar(WriteForm.SubjectEdit.Text)
                  , PChar(Body), nil, PChar(WriteForm.AttachEdit.Text), nil, 0);
            end;
            NMailSmtpClose(S);
        end;
        // MsH
        if Ret < 0 then
            MessageBox(Handle, 'Mł܂ł', 'G[', MB_OK);
    end;
end;

procedure TMainForm.mExitClick(Sender: TObject);
begin
    Close;
end;

procedure TMainForm.FormResize(Sender: TObject);
var
    W: integer;
begin
    // Form ̃TCYύXŁAListView ̍ڕύX
    W := MailListView.ClientWidth;
    MailListView.Columns[0].Width := W div 2;
    MailListView.Columns[1].Width := W div 4;
    MailListView.Columns[2].Width := W div 4;
end;

procedure TMainForm.mSettingClick(Sender: TObject);
var
  IniFileName: TFileName;
  IniFile: TIniFile;
begin
    // ݒ_CAOɐݒeZbg
    OptionForm.SmtpEdit.Text := SmtpName;
    OptionForm.SmtpPort := SmtpPort;
    OptionForm.SmtpSsl := SmtpSsl;
    OptionForm.SmtpAuth := SmtpAuth;
    OptionForm.Pop3Edit.Text := Pop3Name;
    OptionForm.Pop3Port := Pop3Port;
    OptionForm.Pop3Ssl := Pop3Ssl;
    OptionForm.MailEdit.text := MailAddress;
    OptionForm.APopCheck.Checked := APopFlag;
    if OptionForm.ShowModal = mrOk then
    begin
        // ݒeXV
        SmtpName := OptionForm.SmtpEdit.Text;
        SmtpPort := OptionForm.SmtpPort;
        SmtpAuth := OptionForm.SmtpAuth;
        SmtpSsl := OptionForm.SmtpSsl;
        Pop3Name := OptionForm.Pop3Edit.Text;
        Pop3Port := OptionForm.Pop3Port;
        Pop3Ssl := OptionForm.Pop3Ssl;
        MailAddress := OptionForm.MailEdit.Text;
        APopFlag := OptionForm.APopCheck.Checked;
        // dpmail.ini ɐݒeۑ
        IniFileName := ChangeFileExt(Application.ExeName, '.INI');
        IniFile := TIniFile.Create(IniFileName);
        try
            with IniFile do
            begin
                WriteBool(OptionSection, OptionApopFlag, APopFlag);
                WriteString(OptionSection, OptionSmtpName, SmtpName);
                WriteInteger(OptionSection, OptionSmtpPortName, SmtpPort);
                WriteInteger(OptionSection, OptionSmtpSslName, SmtpSsl);
                WriteInteger(OptionSection, OptionSmtpAuthName, SmtpAuth);
                WriteString(OptionSection, OptionPop3Name, Pop3Name);
                WriteInteger(OptionSection, OptionPop3PortName, Pop3Port);
                WriteInteger(OptionSection, OptionPop3SslName, Pop3Ssl);
                WriteString(OptionSection, OptionMailAddress, MailAddress);
            end;
        finally
            IniFile.Free;
        end;
    end;
end;

procedure TMainForm.MailListViewMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    // ENbNȂ|bvAbvj[\
    if Button = mbRight then
    begin
        with ClientToScreen(Point(X, Y)) do
            PopupMenu.Popup(X, Y);
    end;
end;

procedure TMainForm.mDeleteClick(Sender: TObject);
var
  S: TSocket;
begin
    with MailListView do
    begin
        // IĂ邩H
        if SelCount > 0 then
        begin
            // POP3 T[o[ɐڑ
            S := NMailPop3ConnectSsl(PChar(Pop3Name), Pop3Port, Pop3Ssl, nil);
            if S <> INVALID_SOCKET then
            begin
                // [IԍH
                if Selected.Index < NMailPop3Authenticate(S, PChar(Id), PChar(Password), ApopFlag) then
                    // [폜
                    NMailPop3DeleteMail(S, Selected.Index + 1);
                // ڑI
                NMailPop3Close(S);
            end;
        end;
    end;
    // 薼ꗗ\
    AddMailList;
end;

procedure TMainForm.mPopupReplyClickClick(Sender: TObject);
var
  SS: TSocket;
  No, Ret: Integer;
  Body: String;
  Temp: array [0..HEADER_MAX] of Char;
begin
    with MailListView do
    begin
        // IĂ邩H
        if SelCount > 0 then
        begin
            // 2000/5/22
            // ɂɍol Reply-To Ă
			if NMailGetHeaderField(Temp, Selected.Data, 'Reply-To:', HEADER_MAX) then
                WriteForm.ToEdit.Text := StrPas(Temp)
            else
                WriteForm.ToEdit.Text := Selected.SubItems[1];
			//  Re: ēĂ
			if NMailGetHeaderField(Temp, Selected.Data, 'Subject:', HEADER_MAX) then
				WriteForm.SubjectEdit.Text := 'Re: ' + Temp
			else
				WriteForm.SubjectEdit.Text := '';
			WriteForm.BodyMemo.Lines.Clear;
            // [̈e
            if WriteForm.ShowModal = mrOk then
            begin
             	// ͓e Body ɓ
             	Body := '';
             	for No := 0 to WriteForm.BodyMemo.Lines.Count - 1 do
                	Body := Body + WriteForm.BodyMemo.Lines.Strings[No] + #13#10;
                if not FileExists(WriteForm.AttachEdit.Text) then
                    WriteForm.AttachEdit.Text := '';
                // [M
                Ret := NMAIL_ERROR;
                SS := NMailSmtpConnectSsl(PChar(SmtpName), SmtpPort, SmtpSsl, nil);
                if SS <> INVALID_SOCKET Then
                begin
                   Ret := NMailSmtpAuthenticate(SS, PChar(SmtpName), PChar(Id), PChar(Password), SmtpAuth);
                   if Ret >= 0 Then
                   begin
                     Ret := NMailSmtpSendMailEx(SS, PChar(WriteForm.ToEdit.Text), nil, nil
                	   , PChar(MailAddress), PChar(WriteForm.SubjectEdit.Text)
                       , PChar(Body), nil, PChar(WriteForm.AttachEdit.Text), nil, 0);
                   end;
                   NMailSmtpClose(SS);
                end;
                // MsH
                if Ret < 0 then
                	MessageBox(Handle, 'Mł܂ł', 'G[', MB_OK);
            end;
        end;
    end;
end;

procedure TMainForm.mRenewalClick(Sender: TObject);
begin
    // 薼ꗗ\
    AddMailList();
end;

procedure TMainForm.mSaveClick(Sender: TObject);
var
	Fs: TFileStream;
begin
    if MailListView.Selected <> nil then
	begin
		// [eLXgt@Cɕۑ
 		if SaveDialog.Execute then
		begin
			Fs := TFileStream.Create(SaveDialog.FileName, fmCreate);
			// wb_ۑ
			Fs.WriteBuffer(MailListView.Selected.Data^, StrLen(PChar(MailListView.Selected.Data)));
			// [{ۑ
			BodyMemo.Lines.SaveToStream(Fs);
			Fs.Free;
		end;
	end;
end;

procedure TMainForm.mAttachmentClick(Sender: TObject);
begin
	// WJۑp̃_CAO\
	UniteForm.ShowModal;
end;

end.
