// Panel.cpp : t@C
//

#include "stdafx.h"
#include "Vcnetimap4.h"
#include "Panel.h"
#include ".\panel.h"


// CPanel _CAO

IMPLEMENT_DYNAMIC(CPanel, CDialog)
CPanel::CPanel(CWnd* pParent /*=NULL*/)
	: CDialog(CPanel::IDD, pParent)
	, m_splitter(NULL)
	, m_parent(NULL)
{
}

CPanel::~CPanel()
{
}

void CPanel::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_MAIL, m_list_mail);
	DDX_Control(pDX, IDC_EDIT_BODY, m_edit_body);
	DDX_Control(pDX, IDC_LIST_ATTACH, m_list_attach);
}


BEGIN_MESSAGE_MAP(CPanel, CDialog)
	ON_WM_SIZE()
	ON_WM_CTLCOLOR()
	ON_NOTIFY(NM_CLICK, IDC_LIST_MAIL, OnNMClickListMail)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_MAIL, OnNMRclickListMail)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_ATTACH, OnNMDblclkListAttach)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_ATTACH, OnNMRclickListAttach)
END_MESSAGE_MAP()


// CPanel bZ[W nh

void CPanel::AdjustSize(void)
{
	// EChENX݁H
	if(m_splitter) {
		CRect rc;
		// ŏ̃TCYH
		if(m_list_mail.GetHeaderCtrl()->GetItemCount() < 3) {
			int w;
			GetClientRect(rc);
			w = rc.right - GetSystemMetrics(SM_CXVSCROLL) - GetSystemMetrics(SM_CXFRAME) * 2;
			// XgRg[̃wb_ݒ
			m_list_mail.InsertColumn(0, _T(""), LVCFMT_LEFT, 16);
			w -= 16;
			m_list_mail.InsertColumn(1, _T(""), LVCFMT_LEFT, (int)(w * 50) / 100);
			m_list_mail.InsertColumn(2, _T("ol"), LVCFMT_LEFT, (int)(w * 30) / 100);
			m_list_mail.InsertColumn(3, _T("t"), LVCFMT_LEFT, (int)(w * 20) / 100);
		}
		// Ytt@CXg\Ă邩H
		if(m_list_attach.IsWindowVisible()) {
			int h = ::GetSystemMetrics(SM_CYSMICON) + ::GetSystemMetrics(SM_CYEDGE) * 4;
			GetClientRect(rc);
			m_list_attach.SetWindowPos(NULL, 0, rc.bottom - h, rc.right, h, SWP_NOZORDER);
		}
		// EChENXɂTCY
		m_splitter->AdjustSize();
	}
}

BOOL CPanel::Create(CWnd * wnd)
{
	m_parent = wnd;
	if(CDialog::Create(CPanel::IDD, m_parent)) {
		ShowWindow(SW_SHOW);
		return TRUE;
	}
	return FALSE;
}

BOOL CPanel::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_splitter = new CSplitter();
	m_splitter->CreateSplitter(30, this, &m_list_mail, &m_edit_body, true);
	m_splitter->SetEdge(NULL, &m_list_attach);

	// s]ݒ
	m_list_mail.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	m_body_brush.CreateSolidBrush(RGB(255, 255, 255));

	return TRUE;
}

void CPanel::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);
	AdjustSize();
}

HBRUSH CPanel::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	if(pWnd == &m_edit_body) {
		pDC->SetBkMode(OPAQUE);
		pDC->SetBkColor(RGB(255, 255, 255));
		return (HBRUSH)m_body_brush;
	}
	return hbr;
}

void CPanel::OnNMClickListMail(NMHDR *pNMHDR, LRESULT *pResult)
{
	NM_LISTVIEW *pNMListView = (NM_LISTVIEW *)pNMHDR;

	if(pNMListView->iItem != -1) {
		m_parent->PostMessage(WM_PANEL_COMMAND, NM_CLICK, pNMListView->iItem);
	}
	*pResult = 0;
}

void CPanel::OnNMRclickListMail(NMHDR *pNMHDR, LRESULT *pResult)
{
	m_parent->PostMessage(WM_PANEL_COMMAND, NM_RCLICK, reinterpret_cast<LPARAM>(&m_list_mail));
	*pResult = 0;
}

void CPanel::OnNMDblclkListAttach(NMHDR *pNMHDR, LRESULT *pResult)
{
	NM_LISTVIEW *pNMListView = (NM_LISTVIEW *)pNMHDR;

	if(pNMListView->iItem != -1) {
		m_parent->PostMessage(WM_PANEL_COMMAND, NM_DBLCLK, pNMListView->iItem);
	}
	*pResult = 0;
}

void CPanel::OnNMRclickListAttach(NMHDR *pNMHDR, LRESULT *pResult)
{
	m_parent->PostMessage(WM_PANEL_COMMAND, NM_RCLICK, reinterpret_cast<LPARAM>(&m_list_attach));
	*pResult = 0;
}

void CPanel::PostNcDestroy()
{
	delete m_splitter;	
	CDialog::PostNcDestroy();
}
