// MimeList.cpp : t@C
//

#include "stdafx.h"
#include "Vcnetimap4.h"
#include "MimeList.h"
#include ".\mimelist.h"

#include "nMail.h"

// CMimeList _CAO

IMPLEMENT_DYNAMIC(CMimeList, CDialog)
CMimeList::CMimeList(CWnd* pParent /*=NULL*/)
	: CDialog(CMimeList::IDD, pParent)
	, m_uid(0)
	, m_count(0)
	, m_header(_T(""))
{
}

CMimeList::~CMimeList()
{
}

void CMimeList::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TREE_MIME, m_tree_mime);
	DDX_Control(pDX, IDC_EDIT_HEADER, m_edit_header);
	DDX_Text(pDX, IDC_EDIT_HEADER, m_header);
}


BEGIN_MESSAGE_MAP(CMimeList, CDialog)
	ON_WM_CTLCOLOR()
END_MESSAGE_MAP()


// CMimeList bZ[W nh

void CMimeList::SetSocket(SOCKET socket, DWORD uid, int count)
{
	m_socket = socket;
	m_uid = uid;
	m_count = count;
}

BOOL CMimeList::OnInitDialog()
{
	CDialog::OnInitDialog();

	CString str;
	CString name, value;
	int no, pno, pcount;
	for(no = 0 ; no < m_count ; no++) {
		// Content-Type  SubType 擾
		NMailImap4GetMimeStructureStatus(m_socket, NMAIL_IMAP4_MIME_CONTENT_TYPE_AND_SUBTYPE, no, 0, name.GetBuffer(MAX_PATH), value.GetBuffer(MAX_PATH), MAX_PATH);
		name.ReleaseBuffer();
		value.ReleaseBuffer();
		str = name + _T("/") + value;
		// p[^擾
		pcount = NMailImap4GetMimeStructureStatus(m_socket, NMAIL_IMAP4_MIME_CONTENT_PARAMETER_COUNT, no, 0, NULL, NULL, 0);
		for(pno = 0 ; pno < pcount ; pno++) {
			// p[^擾āA\pɒǉ
			NMailImap4GetMimeStructureStatus(m_socket, NMAIL_IMAP4_MIME_CONTENT_PARAMETER, no, pno, name.GetBuffer(MAX_PATH), value.GetBuffer(MAX_PATH), MAX_PATH);
			name.ReleaseBuffer();
			value.ReleaseBuffer();
			str += _T("; ") + name + _T("=") + value;
		}
		// p[g̊Kw\擾AɃc[ɒǉ
		NMailImap4GetMimeStructureStatus(m_socket, NMAIL_IMAP4_MIME_CONTENT_PART, no, 0, name.GetBuffer(MAX_PATH), NULL, MAX_PATH);
		name.ReleaseBuffer();
		m_tree_mime.AddPathItem(name, _T("."), no, str);
	}
	m_tree_mime.Expand(m_tree_mime.GetRootItem(), TVE_EXPAND);

	m_body_brush.CreateSolidBrush(RGB(255, 255, 255));

	return TRUE;
}

BOOL CMimeList::DestroyWindow()
{
	m_tree_mime.ReleaseAllItemData();

	return CDialog::DestroyWindow();
}

HBRUSH CMimeList::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	if(pWnd == &m_edit_header) {
		pDC->SetBkMode(OPAQUE);
		pDC->SetBkColor(RGB(255, 255, 255));
		return (HBRUSH)m_body_brush;
	}
	return hbr;
}
