Imports System.IO

Public Class FormMain
    Inherits System.Windows.Forms.Form

    Private Const XmlFileName As String = "vbmailparam.xml"
    Private Id As String = ""
    Private Password As String = ""
    Private FirstFlag As Boolean = True
    Private MailParam As MailParameter


#Region " Windows tH[ fUCiŐꂽR[h "

    Public Sub New()
        MyBase.New()

        ' ̌Ăяo Windows tH[ fUCiŕKvłB
        InitializeComponent()

        ' InitializeComponent() Ăяǒɏǉ܂B
    End Sub

    ' Form ́AR|[lgꗗɌ㏈s邽߂ dispose I[o[Ch܂B
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    ' Windows tH[ fUCiŕKvłB
    Private components As System.ComponentModel.IContainer

    '  : ȉ̃vV[ẂAWindows tH[ fUCiŕKvłB
    'Windows tH[ fUCigĕύXĂB  
    ' R[h GfB^gĕύXȂłB
    Friend WithEvents ListMail As System.Windows.Forms.ListView
    Friend WithEvents Splitter1 As System.Windows.Forms.Splitter
    Friend WithEvents TextBody As System.Windows.Forms.TextBox
    Friend WithEvents MainMenu As System.Windows.Forms.MainMenu
    Friend WithEvents SaveFileDialog As System.Windows.Forms.SaveFileDialog
    Friend WithEvents MenuRedisp As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem2 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuCreate As System.Windows.Forms.MenuItem
    Friend WithEvents MenuSave As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem3 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem4 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuDelete As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem5 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuExit As System.Windows.Forms.MenuItem
    Friend WithEvents MenuOption As System.Windows.Forms.MenuItem
    Friend WithEvents ColumnSubject As System.Windows.Forms.ColumnHeader
    Friend WithEvents ColumnFrom As System.Windows.Forms.ColumnHeader
    Friend WithEvents ColumnDate As System.Windows.Forms.ColumnHeader
    Friend WithEvents MenuUnite As System.Windows.Forms.MenuItem
    Friend WithEvents MenuFile As System.Windows.Forms.MenuItem
    Friend WithEvents MenuSetting As System.Windows.Forms.MenuItem
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.ListMail = New System.Windows.Forms.ListView
        Me.ColumnSubject = New System.Windows.Forms.ColumnHeader
        Me.ColumnFrom = New System.Windows.Forms.ColumnHeader
        Me.ColumnDate = New System.Windows.Forms.ColumnHeader
        Me.Splitter1 = New System.Windows.Forms.Splitter
        Me.TextBody = New System.Windows.Forms.TextBox
        Me.MainMenu = New System.Windows.Forms.MainMenu
        Me.MenuFile = New System.Windows.Forms.MenuItem
        Me.MenuRedisp = New System.Windows.Forms.MenuItem
        Me.MenuItem2 = New System.Windows.Forms.MenuItem
        Me.MenuCreate = New System.Windows.Forms.MenuItem
        Me.MenuItem3 = New System.Windows.Forms.MenuItem
        Me.MenuSave = New System.Windows.Forms.MenuItem
        Me.MenuUnite = New System.Windows.Forms.MenuItem
        Me.MenuItem4 = New System.Windows.Forms.MenuItem
        Me.MenuDelete = New System.Windows.Forms.MenuItem
        Me.MenuItem5 = New System.Windows.Forms.MenuItem
        Me.MenuExit = New System.Windows.Forms.MenuItem
        Me.MenuSetting = New System.Windows.Forms.MenuItem
        Me.MenuOption = New System.Windows.Forms.MenuItem
        Me.SaveFileDialog = New System.Windows.Forms.SaveFileDialog
        Me.SuspendLayout()
        '
        'ListMail
        '
        Me.ListMail.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.ColumnSubject, Me.ColumnFrom, Me.ColumnDate})
        Me.ListMail.Dock = System.Windows.Forms.DockStyle.Top
        Me.ListMail.FullRowSelect = True
        Me.ListMail.Location = New System.Drawing.Point(0, 0)
        Me.ListMail.Name = "ListMail"
        Me.ListMail.Size = New System.Drawing.Size(528, 120)
        Me.ListMail.TabIndex = 0
        Me.ListMail.View = System.Windows.Forms.View.Details
        '
        'ColumnSubject
        '
        Me.ColumnSubject.Text = ""
        Me.ColumnSubject.Width = 243
        '
        'ColumnFrom
        '
        Me.ColumnFrom.Text = "ol"
        Me.ColumnFrom.Width = 141
        '
        'ColumnDate
        '
        Me.ColumnDate.Text = "t"
        Me.ColumnDate.Width = 118
        '
        'Splitter1
        '
        Me.Splitter1.Cursor = System.Windows.Forms.Cursors.HSplit
        Me.Splitter1.Dock = System.Windows.Forms.DockStyle.Top
        Me.Splitter1.Location = New System.Drawing.Point(0, 120)
        Me.Splitter1.Name = "Splitter1"
        Me.Splitter1.Size = New System.Drawing.Size(528, 5)
        Me.Splitter1.TabIndex = 1
        Me.Splitter1.TabStop = False
        '
        'TextBody
        '
        Me.TextBody.Dock = System.Windows.Forms.DockStyle.Fill
        Me.TextBody.Location = New System.Drawing.Point(0, 125)
        Me.TextBody.Multiline = True
        Me.TextBody.Name = "TextBody"
        Me.TextBody.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
        Me.TextBody.Size = New System.Drawing.Size(528, 332)
        Me.TextBody.TabIndex = 2
        Me.TextBody.Text = ""
        '
        'MainMenu
        '
        Me.MainMenu.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuFile, Me.MenuSetting})
        '
        'MenuFile
        '
        Me.MenuFile.Index = 0
        Me.MenuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuRedisp, Me.MenuItem2, Me.MenuCreate, Me.MenuItem3, Me.MenuSave, Me.MenuUnite, Me.MenuItem4, Me.MenuDelete, Me.MenuItem5, Me.MenuExit})
        Me.MenuFile.Text = "t@C(&F)"
        '
        'MenuRedisp
        '
        Me.MenuRedisp.Index = 0
        Me.MenuRedisp.Text = "XV(&R)"
        '
        'MenuItem2
        '
        Me.MenuItem2.Index = 1
        Me.MenuItem2.Text = "-"
        '
        'MenuCreate
        '
        Me.MenuCreate.Index = 2
        Me.MenuCreate.Text = "쐬(&C)..."
        '
        'MenuItem3
        '
        Me.MenuItem3.Index = 3
        Me.MenuItem3.Text = "-"
        '
        'MenuSave
        '
        Me.MenuSave.Index = 4
        Me.MenuSave.Text = "ۑ(&S)..."
        '
        'MenuUnite
        '
        Me.MenuUnite.Index = 5
        Me.MenuUnite.Text = "ĕۑ(&U)..."
        '
        'MenuItem4
        '
        Me.MenuItem4.Index = 6
        Me.MenuItem4.Text = "-"
        '
        'MenuDelete
        '
        Me.MenuDelete.Index = 7
        Me.MenuDelete.Text = "폜(&D)"
        '
        'MenuItem5
        '
        Me.MenuItem5.Index = 8
        Me.MenuItem5.Text = "-"
        '
        'MenuExit
        '
        Me.MenuExit.Index = 9
        Me.MenuExit.Text = "I(&X)"
        '
        'MenuSetting
        '
        Me.MenuSetting.Index = 1
        Me.MenuSetting.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuOption})
        Me.MenuSetting.Text = "ݒ(&O)"
        '
        'MenuOption
        '
        Me.MenuOption.Index = 0
        Me.MenuOption.Text = "ݒ(&O)..."
        '
        'SaveFileDialog
        '
        Me.SaveFileDialog.DefaultExt = "txt"
        Me.SaveFileDialog.Filter = "eLXgt@C|*.txt|ׂẴt@C|*.*"
        '
        'FormMain
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
        Me.ClientSize = New System.Drawing.Size(528, 457)
        Me.Controls.Add(Me.TextBody)
        Me.Controls.Add(Me.Splitter1)
        Me.Controls.Add(Me.ListMail)
        Me.Menu = Me.MainMenu
        Me.Name = "FormMain"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "vb.net mail"
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub MenuRedisp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuRedisp.Click
		FirstFlag = false
		GetMailList()
    End Sub

    Private Sub MenuCreate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuCreate.Click
		Dim form as FormWrite = new FormWrite

		form.HostName = MailParam.Smtp
        form.From = MailParam.Address
        form.SSL = MailParam.SmtpSsl
        form.PortNo = MailParam.SmtpPort
        form.Auth = MailParam.SmtpAuth
        form.Id = Id
        form.Password = Password
		form.ShowDialog()
    End Sub

    Private Sub MenuSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuSave.Click
		if ListMail.SelectedItems.Count > 0 then
            Dim no As Integer = ListMail.SelectedItems(0).Index + 1
            If SaveFileDialog.ShowDialog() = DialogResult.OK Then
                If SaveFileDialog.FileName <> "" Then
                    If no > 0 Then
                        Dim pop As nMail.Pop3 = New nMail.Pop3(MailParam.Pop3)
                        nMail.Options.DisableDecodeBodyAll()
                        nMail.Options.DisableDecodeHeader()

                        Try
                            pop.SSL = MailParam.Pop3Ssl
                            pop.Connect(MailParam.Pop3Port)
                            pop.Authenticate(Id, Password, MailParam.Apop)
                            pop.GetMail(no)
                            Dim writer As StreamWriter = New StreamWriter(SaveFileDialog.FileName)
                            writer.Write(pop.Header)
                            writer.Write(ControlChars.CrLf)
                            writer.Write(pop.Body)
                            writer.Close()
                        Catch nex As nMail.nMailException
                            If nex.ErrorCode = nMail.Pop3.ErrorAuthenticate Then
                                MessageBox.Show(String.Format("F؃G[łB{0}{1}", ControlChars.NewLine, nex.Message))
                                Id = ""
                                Password = ""
                            Else
                                MessageBox.Show("T[o[ڑɃG[܂B{0}", nex.Message)
                            End If
                        Catch ex As Exception
                            Debug.WriteLine(ex.Message)
                        Finally
                            pop.Dispose()
                        End Try
                    End If
                End If
            End If
        End If
    End Sub


    Private Sub MenuDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuDelete.Click
        If ListMail.SelectedItems.Count > 0 Then
            Dim no As Integer = ListMail.SelectedItems(0).Index + 1
            If no > 0 Then
                Dim pop As nMail.Pop3 = New nMail.Pop3(MailParam.Pop3)
                Try
                    pop.SSL = MailParam.Pop3Ssl
                    pop.Connect(MailParam.Pop3Port)
                    pop.Authenticate(Id, Password, MailParam.Apop)
                    pop.Delete(no)
                    MessageBox.Show("[폜܂B")
                Catch nex As nMail.nMailException
                    If nex.ErrorCode = nMail.Pop3.ErrorAuthenticate Then
                        MessageBox.Show(String.Format("F؃G[łB{0}{1}", ControlChars.NewLine, nex.Message))
                        Id = ""
                        Password = ""
                    Else
                        MessageBox.Show("T[o[ڑɃG[܂B{0}", nex.Message)
                    End If
                Catch ex As Exception
                    Debug.WriteLine(ex.Message)
                Finally
                    pop.Dispose()
                End Try
                GetMailList()
            End If
        End If
    End Sub

    Private Sub MenuExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuExit.Click
        Close()
    End Sub

    Private Sub FormMain_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
        MailParam = New MailParameter
        MailParam.Pop3 = ""
        MailParam.Pop3Port = nMail.Pop3.StandardPortNo
        MailParam.Pop3Ssl = 0
        MailParam.Smtp = ""
        MailParam.SmtpPort = nMail.Smtp.StandardPortNo
        MailParam.SmtpSsl = 0
        MailParam.SmtpAuth = 0
        MailParam.Address = ""
        MailParam.Apop = False
        If File.Exists(XmlFileName) Then
            Dim serializer As System.Xml.Serialization.XmlSerializer = New System.Xml.Serialization.XmlSerializer(GetType(MailParameter))
            Dim fs As FileStream = New FileStream(XmlFileName, FileMode.Open)
            MailParam = CType(serializer.Deserialize(fs), MailParameter)
            fs.Close()
        End If
        nMail.Winsock.Initialize()
        ' HTML p[gt@Cɕۑ
        nMail.Options.EnableSaveHtmlFile()
    End Sub

    Private Sub FormMain_Closed(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Closed
        nMail.Winsock.Done()
    End Sub

    Private Sub GetMailList()
        If Id = "" Then
            If Not InputId() Then
                Return
            End If
            Application.DoEvents()
        End If
        ListMail.Items.Clear()
        Dim pop As nMail.Pop3 = New nMail.Pop3(MailParam.Pop3)
        Try
            pop.SSL = MailParam.Pop3Ssl
            pop.Connect(MailParam.Pop3Port)
            pop.Authenticate(Id, Password, MailParam.Apop)
            ListMail.BeginUpdate()
            Dim no As Integer
            For no = 1 To pop.Count
                pop.GetStatus(no)
                Dim item() As String = {pop.Subject, pop.From, pop.DateString}
                ListMail.Items.Add(New ListViewItem(item))
            Next no
        Catch nex As nMail.nMailException
            If nex.ErrorCode = nMail.Pop3.ErrorAuthenticate Then
                MessageBox.Show(String.Format("F؃G[łB{0}{1}", ControlChars.NewLine, nex.Message))
                Id = ""
                Password = ""
            Else
                MessageBox.Show("T[o[ڑɃG[܂B{0}", nex.Message)
            End If
        Catch ex As Exception
            Debug.WriteLine(ex.Message)
        Finally
            ListMail.EndUpdate()
            pop.Dispose()
        End Try
    End Sub

    Private Sub FormMain_Activated(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Activated
        If FirstFlag Then
            FirstFlag = False
            If (MailParam.Pop3 = "") Or (MailParam.Pop3Port = 0) Then
                MenuOption_Click(sender, e)
            End If
            If MailParam.Pop3 <> "" Then
                GetMailList()
            End If
        End If
    End Sub

    Private Function InputId() As Boolean
        Dim form As FormId = New FormId

        form.Id = Id
        form.Password = Password
        If form.ShowDialog() = DialogResult.OK Then
            Id = form.Id
            Password = form.Password

            Return True
        Else
            Return False
        End If
    End Function

    Private Sub MenuOption_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuOption.Click
        Dim form As FormOption = New FormOption

        form.Pop3 = MailParam.Pop3
        form.Pop3Port = MailParam.Pop3Port
        form.Pop3Ssl = MailParam.Pop3Ssl
        form.Smtp = MailParam.Smtp
        form.SmtpPort = MailParam.SmtpPort
        form.SmtpSsl = MailParam.SmtpSsl
        form.SmtpAuth = MailParam.SmtpAuth
        form.Address = MailParam.Address
        form.Apop = MailParam.Apop
        If form.ShowDialog() = DialogResult.OK Then
            MailParam.Pop3 = form.Pop3
            MailParam.Pop3Port = form.Pop3Port
            MailParam.Pop3Ssl = form.Pop3Ssl
            MailParam.Smtp = form.Smtp
            MailParam.SmtpPort = form.SmtpPort
            MailParam.SmtpSsl = form.SmtpSsl
            MailParam.SmtpAuth = form.SmtpAuth
            MailParam.Address = form.Address
            MailParam.Apop = form.Apop

            Dim serializer As System.Xml.Serialization.XmlSerializer = New System.Xml.Serialization.XmlSerializer(GetType(MailParameter))
            Dim fs As FileStream = New FileStream(XmlFileName, FileMode.Create)
            serializer.Serialize(fs, MailParam)
            fs.Close()
        End If
    End Sub

    Private Sub ListMail_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListMail.SelectedIndexChanged
        If ListMail.SelectedItems.Count > 0 Then
            Dim no As Integer = ListMail.SelectedIndices.Item(0) + 1
            If no > 0 Then
                Dim pop As nMail.Pop3 = New nMail.Pop3(MailParam.Pop3)
                nMail.Options.EnableDecodeBody()
                nMail.Options.EnableDecodeHeader()
                Try
                    pop.SSL = MailParam.Pop3Ssl
                    pop.Connect(MailParam.Pop3Port)
                    pop.Authenticate(Id, Password, MailParam.Apop)
                    pop.GetMail(no)
                    TextBody.Text = pop.Body
                Catch nex As nMail.nMailException
                    If nex.ErrorCode = nMail.Pop3.ErrorAuthenticate Then
                        MessageBox.Show(String.Format("F؃G[łB{0}{1}", ControlChars.NewLine, nex.Message))
                        Id = ""
                        Password = ""
                    Else
                        MessageBox.Show("T[o[ڑɃG[܂B{0}", nex.Message)
                    End If
                Catch ex As Exception
                    Debug.WriteLine(ex.Message)
                Finally
                    pop.Dispose()
                End Try
            End If
        End If
    End Sub

    Private Sub MenuUnite_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuUnite.Click
        Dim form As FormUnite = New FormUnite

        form.ShowDialog()
    End Sub

    Private Sub MenuFile_Popup(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuFile.Popup
        If ListMail.SelectedItems.Count = 0 Then
            MenuSave.Enabled = False
            MenuDelete.Enabled = False
        Else
            MenuSave.Enabled = True
            MenuDelete.Enabled = True
        End If
    End Sub
End Class

Public Class MailParameter
    Public Smtp As String
    Public SmtpPort As Integer
    Public SmtpSsl As Integer
    Public SmtpAuth As Integer
    Public Pop3 As String
    Public Pop3Port As Integer
    Public Pop3Ssl As Integer
    Public Address As String
    Public Apop As Boolean
End Class

