// Option.cpp : t@C
//

#include "stdafx.h"
#include "vcmailnet.h"
#include "Option.h"
#include ".\option.h"
#include "nMail.h"

// COption _CAO

IMPLEMENT_DYNAMIC(COption, CDialog)
COption::COption(CWnd* pParent /*=NULL*/)
	: CDialog(COption::IDD, pParent)
	, m_mail(_T(""))
	, m_pop3(_T(""))
	, m_smtp(_T(""))
	, m_apop(FALSE)
	, m_smtp_ssl(0)
	, m_smtp_port(0)
	, m_smtp_auth(0)
	, m_pop3_port(0)
	, m_pop3_ssl(0)
{
}

COption::~COption()
{
}

void COption::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_MAIL, m_mail);
	DDX_Text(pDX, IDC_EDIT_POP3, m_pop3);
	DDX_Control(pDX, IDC_EDIT_SMTP, m_esmtp);
	DDX_Text(pDX, IDC_EDIT_SMTP, m_smtp);
	DDX_Check(pDX, IDC_CHECK_APOP, m_apop);
	DDX_CBIndex(pDX, IDC_COMBO_SMTP_SSL, m_smtp_ssl);
	DDX_Text(pDX, IDC_EDIT_SMTP_PORT, m_smtp_port);
	DDX_CBIndex(pDX, IDC_COMBO_SMTP_AUTH, m_smtp_auth);
	DDX_Text(pDX, IDC_EDIT_POP3_PORT, m_pop3_port);
	DDX_CBIndex(pDX, IDC_COMBO_POP3_SSL, m_pop3_ssl);
}


BEGIN_MESSAGE_MAP(COption, CDialog)
	ON_CBN_SELCHANGE(IDC_COMBO_SMTP_SSL, OnCbnSelchangeComboSmtpSsl)
	ON_CBN_SELCHANGE(IDC_COMBO_POP3_SSL, OnCbnSelchangeComboPop3Ssl)
END_MESSAGE_MAP()


// COption bZ[W nh

BOOL COption::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_esmtp.SetFocus();

	return FALSE;
}

void COption::OnCbnSelchangeComboSmtpSsl()
{
	CComboBox *combo = (CComboBox *)GetDlgItem(IDC_COMBO_SMTP_SSL);
	if(combo != NULL) {
		UpdateData(TRUE);
		int sel = combo->GetCurSel();
		if(sel == 0 || sel == 3) {
			m_smtp_port = NMAIL_SMTP_PORT;
		} else {
			m_smtp_port =NMAIL_SMTP_SSL_PORT;
		}
		UpdateData(FALSE);
	}
}

void COption::OnCbnSelchangeComboPop3Ssl()
{
	CComboBox *combo = (CComboBox *)GetDlgItem(IDC_COMBO_POP3_SSL);
	if(combo != NULL) {
		UpdateData(TRUE);
		int sel = combo->GetCurSel();
		if(sel == 0 || sel == 3) {
			m_pop3_port = NMAIL_POP3_PORT;
		} else {
			m_pop3_port = NMAIL_POP3_SSL_PORT;
		}
		UpdateData(FALSE);
	}
}

void COption::SetSsl(int smtp, int pop3)
{
	m_smtp_ssl = 0;
	if(smtp == NMAIL_SSL_SSL3) {
		m_smtp_ssl = 1;
	} else if(smtp == NMAIL_SSL_TLS1) {
		m_smtp_ssl = 2;
	} else if(smtp == NMAIL_SSL_STARTTLS) {
		m_smtp_ssl = 3;
	}
	m_pop3_ssl = 0;
	if(pop3 == NMAIL_SSL_SSL3) {
		m_pop3_ssl = 1;
	} else if(pop3 == NMAIL_SSL_TLS1) {
		m_pop3_ssl = 2;
	} else if(pop3 == NMAIL_SSL_STARTTLS) {
		m_pop3_ssl = 3;
	}
}

void COption::GetSsl(int &smtp, int &pop3)
{
	smtp = 0;
	if(m_smtp_ssl == 1) {
		smtp = NMAIL_SSL_SSL3;
	} else if(m_smtp_ssl == 2) {
		smtp = NMAIL_SSL_TLS1;
	} else if(m_smtp_ssl == 3) {
		smtp = NMAIL_SSL_STARTTLS;
	}
	pop3 = 0;
	if(m_pop3_ssl == 1) {
		pop3 = NMAIL_SSL_SSL3;
	} else if(m_pop3_ssl == 2) {
		pop3 = NMAIL_SSL_TLS1;
	} else if(m_pop3_ssl == 3) {
		pop3 = NMAIL_SSL_STARTTLS;
	}
}

void COption::SetAuth(int smtp)
{
	m_smtp_auth = smtp;
	if(m_smtp_auth == NMAIL_SMTP_AUTH_CRAM_MD5) {
		m_smtp_auth = 3;
	}
}

void COption::GetAuth(int &smtp)
{
	smtp = m_smtp_auth;
	if(smtp == 3) {
		smtp = NMAIL_SMTP_AUTH_CRAM_MD5;
	}
}

