unit Option;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, nMail;

type
  TOptionForm = class(TForm)
    OkButton: TButton;
    CancelButton: TButton;
    Label3: TLabel;
    MailEdit: TEdit;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label4: TLabel;
    SmtpPortEdit: TEdit;
    SmtpEdit: TEdit;
    Label5: TLabel;
    SmtpSslCombo: TComboBox;
    Label6: TLabel;
    SmtpAuthCombo: TComboBox;
    Label7: TLabel;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    Pop3Edit: TEdit;
    Label8: TLabel;
    Pop3PortEdit: TEdit;
    Label9: TLabel;
    Pop3SslCombo: TComboBox;
    ApopCheck: TCheckBox;
    procedure Pop3SslComboChange(Sender: TObject);
    procedure SmtpSslComboChange(Sender: TObject);
    procedure SetSmtpAuth(value: Integer);
    function GetSmtpAuth: Integer;
    procedure SetSmtpSsl(value: Integer);
    function GetSmtpSsl: Integer;
    procedure SetSmtpPort(value: Integer);
    function GetSmtpPort: Integer;
    procedure SetPop3Ssl(value: Integer);
    function GetPop3Ssl: Integer;
    procedure SetPop3Port(value: Integer);
    function GetPop3Port: Integer;
  private
    { Private 錾 }
  public
    { Public 錾 }
    property SmtpPort: Integer read GetSmtpPort write SetSmtpPort;
    property SmtpAuth: Integer read GetSmtpAuth write SetSmtpAuth;
    property SmtpSsl: Integer read GetSmtpSsl write SetSmtpSsl;
    property Pop3Port: Integer read GetPop3Port write SetPop3Port;
    property Pop3Ssl: Integer read GetPop3Ssl write SetPop3Ssl;
  end;

var
  OptionForm: TOptionForm;

implementation

{$R *.DFM}

procedure TOptionForm.Pop3SslComboChange(Sender: TObject);
begin
     if (Pop3SslCombo.ItemIndex = 1) or (Pop3SslCombo.ItemIndex = 2) then
        Pop3PortEdit.Text := IntToStr(NMAIL_POP3_SSL_PORT)
     else
        Pop3PortEdit.Text := IntToStr(NMAIL_POP3_PORT);
end;

procedure TOptionForm.SmtpSslComboChange(Sender: TObject);
begin
     if (SmtpSslCombo.ItemIndex = 1) or (SmtpSslCombo.ItemIndex = 2) then
        SmtpPortEdit.Text := IntToStr(NMAIL_SMTP_SSL_PORT)
     else
        SmtpPortEdit.Text := IntToStr(NMAIL_SMTP_PORT);
end;

procedure TOptionForm.SetSmtpPort(value: Integer);
begin
	SmtpPortEdit.Text := IntToStr(value);
end;

function TOptionForm.GetSmtpPort: Integer;
begin
	Result := StrToInt(SmtpPortEdit.Text);
end;

procedure TOptionForm.SetSmtpAuth(value: Integer);
begin
	if value = NMAIL_SMTP_AUTH_CRAM_MD5 Then
		SmtpAuthCombo.ItemIndex := 2
	else
		SmtpAuthCombo.ItemIndex := value;
end;

function TOptionForm.GetSmtpAuth: Integer;
begin
	if SmtpAuthCombo.ItemIndex = 2 then
	   Result := NMAIL_SMTP_AUTH_CRAM_MD5
	else
	   Result := SmtpAuthCombo.ItemIndex;
end;

procedure TOptionForm.SetSmtpSsl(value: Integer);
begin
	if value = NMAIL_SSL_SSL3 Then
		SmtpSslCombo.ItemIndex := 1
	else if value = NMAIL_SSL_TLS1 Then
		SmtpSslCombo.ItemIndex := 2
	else if value = NMAIL_SSL_STARTTLS Then
		SmtpSslCombo.ItemIndex := 3
	else
		SmtpSslCombo.ItemIndex := 0;
end;

function TOptionForm.GetSmtpSsl: Integer;
begin
	if SmtpSslCombo.ItemIndex = 1 Then
	   Result := NMAIL_SSL_SSL3
	else if SmtpSslCombo.ItemIndex = 2 Then
	   Result := NMAIL_SSL_TLS1
	else if SmtpSslCombo.ItemIndex = 3 Then
	   Result := NMAIL_SSL_STARTTLS
	else
	   Result := 0;
end;

procedure TOptionForm.SetPop3Port(value: Integer);
begin
	Pop3PortEdit.Text := IntToStr(value);
end;

function TOptionForm.GetPop3Port: Integer;
begin
	Result := StrToInt(Pop3PortEdit.Text);
end;

procedure TOptionForm.SetPop3Ssl(value: Integer);
begin
	if value = NMAIL_SSL_SSL3 Then
		Pop3SslCombo.ItemIndex := 1
	else if value = NMAIL_SSL_TLS1 Then
		Pop3SslCombo.ItemIndex := 2
	else if value = NMAIL_SSL_STARTTLS Then
		Pop3SslCombo.ItemIndex := 3
	else
		Pop3SslCombo.ItemIndex := 0;
end;

function TOptionForm.GetPop3Ssl: Integer;
begin
	if Pop3SslCombo.ItemIndex = 1 Then
	   Result := NMAIL_SSL_SSL3
	else if Pop3SslCombo.ItemIndex = 2 Then
	   Result := NMAIL_SSL_TLS1
	else if Pop3SslCombo.ItemIndex = 3 Then
	   Result := NMAIL_SSL_STARTTLS
	else
	   Result := 0;
end;

end.
