unit Option;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, nMail;

type
  TOptionForm = class(TForm)
    Label3: TLabel;
    OkButton: TButton;
    CancelButton: TButton;
    MailEdit: TEdit;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    SmtpEdit: TEdit;
    SmtpPortEdit: TEdit;
    SmtpSslCombo: TComboBox;
    SmtpAuthCombo: TComboBox;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Imap4Edit: TEdit;
    Imap4PortEdit: TEdit;
    Imap4SslCombo: TComboBox;
    Label10: TLabel;
    Imap4AuthCombo: TComboBox;
    procedure SetSmtpAuth(value: Integer);
    function GetSmtpAuth: Integer;
    procedure SetSmtpSsl(value: Integer);
    function GetSmtpSsl: Integer;
    procedure SetSmtpPort(value: Integer);
    function GetSmtpPort: Integer;
    procedure SetImap4Ssl(value: Integer);
    function GetImap4Ssl: Integer;
    procedure SetImap4Port(value: Integer);
    function GetImap4Port: Integer;
    procedure SetImap4Auth(value: Integer);
    function GetImap4Auth: Integer;
    procedure SmtpSslComboChange(Sender: TObject);
    procedure Imap4SslComboChange(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    property SmtpPort: Integer read GetSmtpPort write SetSmtpPort;
    property SmtpAuth: Integer read GetSmtpAuth write SetSmtpAuth;
    property SmtpSsl: Integer read GetSmtpSsl write SetSmtpSsl;
    property Imap4Port: Integer read GetImap4Port write SetImap4Port;
    property Imap4Auth: Integer read GetImap4Auth write SetImap4Auth;
    property Imap4Ssl: Integer read GetImap4Ssl write SetImap4Ssl;
  end;

var
  OptionForm: TOptionForm;

implementation

{$R *.DFM}

procedure TOptionForm.SetSmtpPort(value: Integer);
begin
	SmtpPortEdit.Text := IntToStr(value);
end;

function TOptionForm.GetSmtpPort: Integer;
begin
	Result := StrToInt(SmtpPortEdit.Text);
end;

procedure TOptionForm.SetSmtpAuth(value: Integer);
begin
	if value = NMAIL_SMTP_AUTH_CRAM_MD5 Then
		SmtpAuthCombo.ItemIndex := 3
	else
		SmtpAuthCombo.ItemIndex := value;
end;

function TOptionForm.GetSmtpAuth: Integer;
begin
	if SmtpAuthCombo.ItemIndex = 3 then
	   Result := NMAIL_SMTP_AUTH_CRAM_MD5
	else
	   Result := SmtpAuthCombo.ItemIndex;
end;

procedure TOptionForm.SetSmtpSsl(value: Integer);
begin
	if value = NMAIL_SSL_SSL3 Then
		SmtpSslCombo.ItemIndex := 1
	else if value = NMAIL_SSL_TLS1 Then
		SmtpSslCombo.ItemIndex := 2
	else if value = NMAIL_SSL_STARTTLS Then
		SmtpSslCombo.ItemIndex := 3
	else
		SmtpSslCombo.ItemIndex := 0;
end;

function TOptionForm.GetSmtpSsl: Integer;
begin
	if SmtpSslCombo.ItemIndex = 1 Then
	   Result := NMAIL_SSL_SSL3
	else if SmtpSslCombo.ItemIndex = 2 Then
	   Result := NMAIL_SSL_TLS1
	else if SmtpSslCombo.ItemIndex = 3 Then
	   Result := NMAIL_SSL_STARTTLS
	else
	   Result := 0;
end;

procedure TOptionForm.SetImap4Port(value: Integer);
begin
	Imap4PortEdit.Text := IntToStr(value);
end;

function TOptionForm.GetImap4Port: Integer;
begin
	Result := StrToInt(Imap4PortEdit.Text);
end;

procedure TOptionForm.SetImap4Ssl(value: Integer);
begin
	if value = NMAIL_SSL_SSL3 Then
		Imap4SslCombo.ItemIndex := 1
	else if value = NMAIL_SSL_TLS1 Then
		Imap4SslCombo.ItemIndex := 2
	else if value = NMAIL_SSL_STARTTLS Then
		Imap4SslCombo.ItemIndex := 3
	else
		Imap4SslCombo.ItemIndex := 0;
end;

function TOptionForm.GetImap4Ssl: Integer;
begin
	if Imap4SslCombo.ItemIndex = 1 Then
	   Result := NMAIL_SSL_SSL3
	else if Imap4SslCombo.ItemIndex = 2 Then
	   Result := NMAIL_SSL_TLS1
	else if Imap4SslCombo.ItemIndex = 3 Then
	   Result := NMAIL_SSL_STARTTLS
	else
	   Result := 0;
end;

procedure TOptionForm.SetImap4Auth(value: Integer);
begin
	if value = NMAIL_SMTP_AUTH_CRAM_MD5 Then
		Imap4AuthCombo.ItemIndex := 2
	else
		Imap4AuthCombo.ItemIndex := value - 1;
end;

function TOptionForm.GetImap4Auth: Integer;
begin
	if Imap4AuthCombo.ItemIndex = 2 then
	   Result := NMAIL_IMAP4_AUTH_CRAM_MD5
	else
	   Result := Imap4AuthCombo.ItemIndex + 1;
end;

procedure TOptionForm.SmtpSslComboChange(Sender: TObject);
begin
     if (SmtpSslCombo.ItemIndex = 1) or (SmtpSslCombo.ItemIndex = 2) then
        SmtpPortEdit.Text := IntToStr(NMAIL_SMTP_SSL_PORT)
     else
        SmtpPortEdit.Text := IntToStr(NMAIL_SMTP_PORT);
end;

procedure TOptionForm.Imap4SslComboChange(Sender: TObject);
begin
     if (Imap4SslCombo.ItemIndex = 1) or (Imap4SslCombo.ItemIndex = 2) then
        Imap4PortEdit.Text := IntToStr(NMAIL_IMAP4_SSL_PORT)
     else
        Imap4PortEdit.Text := IntToStr(NMAIL_IMAP4_PORT);
end;

end.
