unit nMail;

interface

uses WinSock;

{$IFDEF VER90}
type
  TSocket = Integer;
{$ENDIF}

const
{$IFDEF VER90}
  INVALID_SOCKET = TSocket(NOT(0));
{$ENDIF}
  NMAIL_ATTACHMENT_TEMP_SIZE = 400;

  NMAIL_SMTP_PORT = 25;
  NMAIL_SMTP_SUBMISSION_PORT = 587;
  NMAIL_SMTP_SSL_PORT = 465;
  NMAIL_POP3_PORT = 110;
  NMAIL_POP3_SSL_PORT = 995;
  NMAIL_IMAP4_PORT = 143;
  NMAIL_IMAP4_SSL_PORT = 993;

  NMAIL_ERROR_SOCKET = -1;
  NMAIL_ERROR_AUTHENTICATE = -2;
  NMAIL_ERROR_INVALID_NO = -3;
  NMAIL_ERROR_TIMEOUT = -4;
  NMAIL_ERROR_FILE_OPEN = -5;
  NMAIL_ERROR_PARTIAL = -6;
  NMAIL_ERROR_FILE_ALREADY = -7;
  NMAIL_ERROR_AUTHENTICATE_NO_SUPPORT = -8;
  NMAIL_ERROR_MEMORY = -9;
  NMAIL_ERROR = -10;

  NMAIL_ERROR_INVALID_PARAMETER = -11;
  NMAIL_ERROR_IMAP4_NO = -12;
  NMAIL_ERROR_IMAP4_BAD = -13;
  NMAIL_ERROR_IMAP4_NO_NAMESPACE = -14;

  NMAIL_ERROR_SUSPEND_ATTACHMENT_FILE = -20;
  NMAIL_ERROR_IMAP4_NO_RESULT = -21;

  NMAIL_ERROR_SSL_NO_SUPPORT = -30;
  NMAIL_ERROR_STARTTLS_NO_SUPPORT = -31;

  NMAIL_ERROR_SERVICE_NOT_AVAILABLE = -421;
  NMAIL_ERROR_MAILBOX_UNAVAILABLE = -450;
  NMAIL_ERROR_LOCAL_ERROR = -451;
  NMAIL_ERROR_INSUFFICIENT_SYSTEM_STORAGE = -452;
  NMAIL_ERROR_SYNTAX_ERROR = -500;
  NMAIL_ERROR_PARAMETER = -501;
  NMAIL_ERROR_COMMAND_NOT_IMPLEMENTED = -502;
  NMAIL_ERROR_BAD_SEQUENCE = -503;
  NMAIL_ERROR_USER_UNKOWN = -550;
  NMAIL_ERROR_USER_NOT_LOCAL = -551;
  NMAIL_ERROR_EXCEEDED_STORAGE_ALLOCATION = -552;
  NMAIL_ERROR_MAILBOX_NAME_NOT_ALLOWED = -553;
  NMAIL_ERROR_RELAY_OPERATION_REJECTED = -553;
  NMAIL_ERROR_TRANSACTION_FAILED = -554;

  NMAIL_NO_ATTACHMENT_FILE = -1;
  NMAIL_ATTACHMENT_FILE = 0;

  NMAIL_SUCCESS = 1;

  NMAIL_PARTIAL_ATTACHMENT_FILE = 1;
  NMAIL_GET_TEXT_ONLY = 2;

  NMAIL_ADD_DATE_FIELD = 1;
  NMAIL_ADD_MESSAGEID_FIELD = 2;
  NMAIL_SUSPEND_ATTACHMENT_FILE = 4;
  NMAIL_SUSPEND_NEXT = 8;
  NMAIL_FILE_NAME_RFC2231 = 16;
  NMAIL_ENCODE_UTF8 = 32;

  NMAIL_SMTP_HTML = $40;
  NMAIL_SMTP_HTML_USE_FILE = $80;
  NMAIL_SMTP_HTML_AUTO_PART = $100;
  NMAIL_SMTP_HTML_NO_MIXED_PART = $200;
  NMAIL_SMTP_HTML_SOFTBANK = $200;
  NMAIL_SMTP_HTML_EMOBILE = $200;
  NMAIL_SMTP_HTML_WILLCOM = $200;
  NMAIL_SMTP_HTML_NO_RELATED_PART = $400;
  NMAIL_SMTP_HTML_AU = $400;
  NMAIL_SMTP_HTML_NO_PLAIN_PART = $800;
  NMAIL_SMTP_HTML_SET_PLAIN_BODY = $1000;

  NMAIL_IMAP4_MIME_PART_SAVE_AS_FILE = $800;
  NMAIL_IMAP4_MIME_PART_PEEK = $1000;
  NMAIL_IMAP4_MIME_PART_NO_DECODE = $2000;
  NMAIL_IMAP4_MIME_PART_HEADER = $4000;
  NMAIL_IMAP4_USE_UID = $8000;

  NMAIL_OPTION_TIMEOUT = 0;
  NMAIL_OPTION_HEADER_MAX = 1;
  NMAIL_OPTION_BODY_MAX = 2;
  NMAIL_OPTION_ALREADY_FILE = 3;
  NMAIL_OPTION_DEBUG_MODE = 4;
  NMAIL_OPTION_CONNECT_TIMEOUT = 5;
  NMAIL_OPTION_SPLIT_CHAR = 6;
  NMAIL_OPTION_SUSPEND_SIZE = 7;
  NMAIL_OPTION_SLEEP_TIME = 8;
  NMAIL_OPTION_FIELD_MAX = 9;
  NMAIL_OPTION_SAVE_HTML = 10;
  NMAIL_OPTION_DECODE_BODY = 11;
  NMAIL_OPTION_DECODE_HEADER = 12;
  NMAIL_OPTION_FILENAME_MAX = 13;
  NMAIL_OPTION_CHANGE_CHAR = 14;
  NMAIL_OPTION_CHANGE_CHAR_MODE = 15;
  NMAIL_OPTION_SAVE_RFC822 = 16;

  NMAIL_FILE_OVERWRITE = 0;
  NMAIL_FILE_RENAME = 1;
  NMAIL_FILE_ALREADY_ERROR = 2;

  NMAIL_GET_ERROR_MESSAGE = 0;
  NMAIL_GET_DEBUG_MESSAGE = 1;

  NMAIL_DEBUG_START = 1;
  NMAIL_DEBUG_END = 0;

  NMAIL_GET_UIDL_ALL = 0;

  NMAIL_CONNECT_TIMEOUT_ON = 1;
  NMAIL_CONNECT_TIMEOUT_OFF = 0;

  NMAIL_SMTP_AUTH_NOT_USE = 0;
  NMAIL_SMTP_AUTH_PLAIN = 1;
  NMAIL_SMTP_AUTH_LOGIN = 2;
  NMAIL_SMTP_AUTH_CRAM_MD5 = 4;

  NMAIL_SAVE_HTML_OFF = 0;
  NMAIL_SAVE_HTML_ON = 1;

  NMAIL_DECODE_BODY_ON = 0;
  NMAIL_DECODE_BODY_ALL_OFF = 1;
  NMAIL_DECODE_BODY_TEXT_OFF = 2;

  NMAIL_DECODE_HEADER_ON = 0;
  NMAIL_DECODE_HEADER_OFF = 1;

  NMAIL_CHANGE_SPLIT_CHAR = 0;
  NMAIL_CHANGE_HALF_SPACE = 1;
  NMAIL_CHANGE_FULL_SPACE = 2;
  NMAIL_CHANGE_ALL_SPACE = 3;
  NMAIL_CHANGE_NO_SPLIT_CHAR = 4;

  NMAIL_SAVE_RFC822_OFF = 0;
  NMAIL_SAVE_RFC822_BODY = 1;
  NMAIL_SAVE_RFC822_PART_ALL = 2;

  NMAIL_IMAP4_AUTH_PLAIN = 1;
  NMAIL_IMAP4_AUTH_LOGIN = 2;
  NMAIL_IMAP4_AUTH_CRAM_MD5 = 4;
  NMAIL_IMAP4_AUTH_DIGEST_MD5 = 8;

  NMAIL_IMAP4_MAILBOX_NO_SELECT = 1;
  NMAIL_IMAP4_MAILBOX_NO_INFERIOUS = 2;
  NMAIL_IMAP4_MAILBOX_MARKED = 4;
  NMAIL_IMAP4_MAILBOX_UNMARKED = 8;
  NMAIL_IMAP4_MAILBOX_CHILDREN = 16;
  NMAIL_IMAP4_MAILBOX_NO_CHILDREN = 32;

  NMAIL_IMAP4_MESSAGE_ANSWERED = 1;
  NMAIL_IMAP4_MESSAGE_DELETED = 2;
  NMAIL_IMAP4_MESSAGE_DRAFT = 4;
  NMAIL_IMAP4_MESSAGE_FLAGGED = 8;
  NMAIL_IMAP4_MESSAGE_RECENT = 16;
  NMAIL_IMAP4_MESSAGE_SEEN = 32;

  NMAIL_IMAP4_ADD_MESSAGE_FLAG = 1;
  NMAIL_IMAP4_DELETE_MESSAGE_FLAG = 2;
  NMAIL_IMAP4_REPLACE_MESSAGE_FLAG= 3;

  NMAIL_IMAP4_MAILBOX_MESSAGE = 1;
  NMAIL_IMAP4_MAILBOX_RECENT = 2;
  NMAIL_IMAP4_MAILBOX_UIDNEXT = 3;
  NMAIL_IMAP4_MAILBOX_UIDVALIDITY = 4;
  NMAIL_IMAP4_MAILBOX_UNSEEN = 5;

  NMAIL_IMAP4_SEARCH_ANSWERED = 1;
  NMAIL_IMAP4_SEARCH_UNANSWERED = 2;
  NMAIL_IMAP4_SEARCH_DELETED = 3;
  NMAIL_IMAP4_SEARCH_UNDELETED = 4;
  NMAIL_IMAP4_SEARCH_DRAFT = 5;
  NMAIL_IMAP4_SEARCH_UNDRAFT = 6;
  NMAIL_IMAP4_SEARCH_FLAGGED = 7;
  NMAIL_IMAP4_SEARCH_UNFLAGGED = 8;
  NMAIL_IMAP4_SEARCH_RECENT = 9;
  NMAIL_IMAP4_SEARCH_OLD = 10;
  NMAIL_IMAP4_SEARCH_SEEN = 11;
  NMAIL_IMAP4_SEARCH_UNSEEN = 12;
  NMAIL_IMAP4_SEARCH_NEW = 13;
  NMAIL_IMAP4_SEARCH_ALL = 14;
  NMAIL_IMAP4_SEARCH_KEYWORD = 15;
  NMAIL_IMAP4_SEARCH_UNKEYWORD = 16;
  NMAIL_IMAP4_SEARCH_FROM = 17;
  NMAIL_IMAP4_SEARCH_TO = 18;
  NMAIL_IMAP4_SEARCH_CC = 19;
  NMAIL_IMAP4_SEARCH_BCC = 20;
  NMAIL_IMAP4_SEARCH_SUBJECT = 21;
  NMAIL_IMAP4_SEARCH_SENTBEFORE = 22;
  NMAIL_IMAP4_SEARCH_SENTON = 23;
  NMAIL_IMAP4_SEARCH_SENTSINCE = 24;
  NMAIL_IMAP4_SEARCH_BEFORE = 25;
  NMAIL_IMAP4_SEARCH_ON = 26;
  NMAIL_IMAP4_SEARCH_SINCE = 27;
  NMAIL_IMAP4_SEARCH_HEADER = 28;
  NMAIL_IMAP4_SEARCH_BODY = 29;
  NMAIL_IMAP4_SEARCH_TEXT = 30;
  NMAIL_IMAP4_SEARCH_LARGER = 31;
  NMAIL_IMAP4_SEARCH_SMALLER = 32;
  NMAIL_IMAP4_SEARCH_UID = 33;

  NMAIL_IMAP4_SEARCH_COMMAND = $100;

  NMAIL_IMAP4_SEARCH_NOT = $200;
  NMAIL_IMAP4_SEARCH_OR = $400;
  NMAIL_IMAP4_SEARCH_AND = $800;
  NMAIL_IMAP4_SEARCH_FIRST = $1000;
  NMAIL_IMAP4_SEARCH_NO_WAIT = $2000;
  NMAIL_IMAP4_SEARCH_CHECK = $4000;

  NMAIL_IMAP4_NAMESPACE_PERSONAL_ALL = 0;
  NMAIL_IMAP4_NAMESPACE_OTHER_ALL = 1;
  NMAIL_IMAP4_NAMESPACE_SHARED_ALL = 2;

  NMAIL_IMAP4_NAMESPACE_PERSONAL_NO = $0100;
  NMAIL_IMAP4_NAMESPACE_OTHER_NO = $0200;
  NMAIL_IMAP4_NAMESPACE_SHARED_NO = $0300;

  NMAIL_IMAP4_NAMESPACE_PERSONAL_COUNT = $1000;
  NMAIL_IMAP4_NAMESPACE_OTHER_COUNT = $2000;
  NMAIL_IMAP4_NAMESPACE_SHARED_COUNT = $3000;

  NMAIL_IMAP4_MIME_CONTENT_PART = 0;
  NMAIL_IMAP4_MIME_CONTENT_TYPE = 1;
  NMAIL_IMAP4_MIME_CONTENT_SUBTYPE = 2;
  NMAIL_IMAP4_MIME_CONTENT_ID = 3;
  NMAIL_IMAP4_MIME_CONTENT_DESCRIPTION = 4;
  NMAIL_IMAP4_MIME_CONTENT_TRANSFER_ENCODING = 5;
  NMAIL_IMAP4_MIME_CONTENT_FILE_NAME = 6;
  NMAIL_IMAP4_MIME_CONTENT_TYPE_AND_SUBTYPE = 7;
  NMAIL_IMAP4_MIME_CONTENT_SIZE = 8;
  NMAIL_IMAP4_MIME_CONTENT_LINE = 9;
  NMAIL_IMAP4_MIME_CONTENT_PARAMETER_COUNT = 10;
  NMAIL_IMAP4_MIME_CONTENT_PARAMETER = 11;

  NMAIL_MAKE_DATE_TIME_SMTP = 0;
  NMAIL_MAKE_DATE_IMAP4 = $8000;
  NMAIL_MAKE_DATE_TIME_IMAP4 = $10000;
  NMAIL_MAKE_DATE_NOW = $20000;
  NMAIL_MAKE_DATE_TIMEZONE_PLUS = $40000;
  NMAIL_MAKE_DATE_TIMEZONE_MINUS = $80000;
  NMAIL_MAKE_DATE_SIZE = 32;

  NMAIL_SSL_IGNORE_NOT_TIME_VALID = $0800;
  NMAIL_SSL_ALLOW_UNKNOWN_CA = $0400;

  NMAIL_SSL_SSL3 = $1000;
  NMAIL_SSL_TLS1 = $2000;
  NMAIL_SSL_STARTTLS = $4000;

  NMAIL_SSL_ERROR_UNTRUSTED_ROOT = -2146762487;
  NMAIL_SSL_ERROR_INTERNAL = -2146893052;
  NMAIL_SSL_ERROR_ILLEGAL_MESSAGE = -2146893018;
  NMAIL_SSL_ERROR_EXPIRED = -2146893016;

function NMailGetVersion: Integer; export; stdcall; External 'nMail.dll';
function NMailInitializeWinSock: LongBool; export; stdcall; External 'nMail.dll';
function NMailEndWinSock: LongBool; export; stdcall; External 'nMail.dll';
function NMailPop3Connect(HostName: PChar): TSocket; export; stdcall; External 'nMail.dll';
function NMailPop3ConnectPortNo(HostName: PChar; PortNo: Integer): TSocket; export; stdcall; External 'nMail.dll';
function NMailPop3Authenticate(S: TSocket; ID: PChar; Password: PChar; APopFlag: LongBool): Integer; export; stdcall; External 'nMail.dll';
function NMailPop3Close(S: TSocket): Integer; export; stdcall; External 'nMail.dll';
function NMailPop3GetMailSize(S: TSocket; No: Integer): Integer; export; stdcall; External 'nMail.dll';
function NMailPop3GetMailStatus(S: TSocket; No: Integer; Subject: PChar; Date: PChar; From: PChar; Header: PChar; SizeFlag: LongBool): Integer; export; stdcall; External 'nMail.dll';
function NMailPop3GetMail(S: TSocket; No: Integer; Subject: PChar; Date: PChar; From: PChar; Header: PChar; Body: PChar; Path: PChar; FileName: PChar): Integer; export; stdcall; External 'nMail.dll';
function NMailPop3GetMailEx(S: TSocket; No: Integer; Subject: PChar; Date: PChar; From: PChar; Header: PChar; Body: PChar; Path: PChar; FileName: PChar; Temp: PChar; Flag: Integer): Integer; export; stdcall; External 'nMail.dll';
function NMailPop3GetMailPartial(S: TSocket; No: Integer; Subject: PChar; Date: PChar; From: PChar; Header: PChar; Body: PChar; Path: PChar; FileName: PChar): Integer; export; stdcall; External 'nMail.dll';
function NMailPop3GetAttachmentFileStatus(S: TSocket; No: Integer; Id: PChar; Max: Integer): Integer; export; stdcall; External 'nMail.dll';
function NMailPop3DeleteMail(S: TSocket; No: Integer): Integer; export; stdcall; External 'nMail.dll';
function NMailPop3GetUidl(Socket: TSocket; No: Integer; Uidl: PChar; Max: Integer): Integer; export; stdcall; External 'nMail.dll';
function NMailSmtpSendMail(HostName: PChar; MailTo: PChar; Cc: PChar; Bcc: PChar; From: PChar; Subject: PChar; Body: PChar; Header: PChar; Path: PChar; Flag: Integer): Integer; export; stdcall; External 'nMail.dll';
function NMailSmtpSendMailPortNo(HostName: PChar; MailTo: PChar; Cc: PChar; Bcc: PChar; From: PChar; Subject: PChar; Body: PChar; Header: PChar; Path: PChar; Flag: Integer; PortNo: Integer): Integer; export; stdcall; External 'nMail.dll';
function NMailSmtpConnect(HostName: PChar): TSocket; export; stdcall; External 'nMail.dll';
function NMailSmtpConnectPortNo(HostName: PChar; PortNo: Integer): TSocket; export; stdcall; External 'nMail.dll';
function NMailSmtpAuthenticate(S: TSocket; HostName: PChar; ID: PChar; Password: PChar; Mode: Integer): Integer; export; stdcall; External 'nMail.dll';
function NMailSmtpSendMailEx(S: TSocket; MailTo: PChar; Cc: PChar; Bcc: PChar; From: PChar; Subject: PChar; Body: PChar; Header: PChar; Path: PChar; Temp: PChar; Flag: Integer): Integer; export; stdcall; External 'nMail.dll';
function NMailSmtpClose(S: TSocket): Integer; export; stdcall; External 'nMail.dll';
function NMailGetHeaderField(Field: PChar; Header: PChar; Name: PChar; Size: Integer): LongBool; export; stdcall; External 'nMail.dll';
function NMailDecodeHeaderField(Destination: PChar; Source: PChar; Size: Integer): LongBool; export; stdcall; External 'nMail.dll';
function NMailAttachmentFileFirst(Temp: PChar; Subject: PChar; Date: PChar; From: PChar; Header: PChar; Body: PChar; Path: PChar; FileName: PChar; FirstHeader: PChar; FirstBody: PChar):Integer; export; stdcall; External 'nMail.dll';
function NMailAttachmentFileNext(Temp: PChar; NextHeader: PChar; NextBody: PChar): Integer; export; stdcall; External 'nMail.dll';
function NMailAttachmentFileClose(Temp: PChar): Integer; export; stdcall; External 'nMail.dll';
function NMailAttachmentFileStatus(Header: PChar; Id: PChar; Max: Integer): Integer; export; stdcall; External 'nMail.dll';
function NMailSetOption(Option: Integer; Value: Integer): LongBool; export; stdcall; External 'nMail.dll';
function NMailGetOption(Option: Integer): Integer; export; stdcall; External 'nMail.dll';
function NMailGetSuspendNumber(Path: PChar): Integer; export; stdcall; External 'nMail.dll';
procedure NMailGetMessage(MType: Integer; Msg: PChar; Size: Integer); export; stdcall; External 'nMail.dll';
procedure NMailSetParameter(TimeOutSec: Integer; HeaderMax: Integer; BodyMax: Integer); export; stdcall; External 'nMail.dll';
function NMailImap4Connect(HostName: PChar): TSocket; export; stdcall; External 'nMail.dll';
function NMailImap4ConnectPortNo(HostName: PChar; PortNo: Integer): TSocket; stdcall; External 'nMail.dll';
function NMailImap4Authenticate(S: TSocket; ID: PChar; Password: PChar; AuthMode: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4AppendMail(S: TSocket; MailBox: PChar; Header: PChar; Body: PChar; Path: PChar; MessageFlag: Integer; DateStr: PChar; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4ChangeMessageFlag(S: TSocket; MailNo: Integer; MessageFlag: Integer; Command: Integer; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4Close(S: TSocket): Integer; stdcall; External 'nMail.dll';
function NMailImap4CloseMailBox(S: TSocket): Integer; stdcall; External 'nMail.dll';
function NMailImap4CopyMail(S: TSocket; MailNo: Integer; MailBox: PChar; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4CreateMailBox(S: TSocket; MailBox: PChar): Integer; stdcall; External 'nMail.dll';
function NMailImap4DeleteMail(S: TSocket; No: Integer; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4DeleteMailBox(S: TSocket; MailBox: PChar): Integer; stdcall; External 'nMail.dll';
function NMailImap4ExpungeMail(S: TSocket): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetMail(S: TSocket; MailNo: Integer; Subject: PChar; Date: PChar; From: PChar; Header: PChar; Body: PChar; Path: PChar; FileName: PChar; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetMailBoxList(S: TSocket; Refer: PChar; MailBox: PChar; SubscribeFlag: LongBool): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetMailBoxListStatus(S: TSocket; ListNo: Integer; var MailBoxFlag: Integer; Separate: PChar; MailBox: PChar; Size: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetMailBoxStatus(S: TSocket; MailBox: PChar; StatusType: Integer; var Data: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetMailSize(S: TSocket; MailNo: Integer; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetMailStatus(S: TSocket; MailNo: Integer; Subject: PChar; DateStr: PChar; From: PChar; Header: PChar; var MessageFlag: Integer; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetMimePart(S: TSocket; MailNo: Integer; PartNo: Integer; Body: PChar; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetMimeStructure(S: TSocket; MailNo: Integer; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetMimeStructureStatus(S: TSocket; MimeType: Integer; PartNo: Integer; SubNo: Integer; Name: PChar; Value: PChar; Size: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetNameSpace(S: TSocket): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetNameSpaceStatus(S: TSocket; NameType: Integer; Separate: PChar; Name: PChar; Size: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetSearchMailResult(S: TSocket; ResultNo: Integer; var MailNo: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4GetUid(S: TSocket; MailNo: Integer;  var Uid: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4NoOperation(S: TSocket): Integer; stdcall; External 'nMail.dll';
function NMailImap4RenameMailBox(S: TSocket; OldMailBox: PChar; NewMailBox: PChar): Integer; stdcall; External 'nMail.dll';
function NMailImap4SaveMimePart(S: TSocket; MailNo: Integer; PartNo: Integer; Path: PChar; FileName: PChar; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4SearchMail(S: TSocket; SearchType: Integer; Text: PChar; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailImap4SelectMailBox(S: TSocket; MailBox: PChar; ReadOnlyFlag: LongBool): Integer; stdcall; External 'nMail.dll';
function NMailImap4SubscribeMailBox(S: TSocket; MailBox: PChar): Integer; stdcall; External 'nMail.dll';
function NMailImap4UnsubscribeMailBox(S: TSocket; MailBox: PChar): Integer; stdcall; External 'nMail.dll';
function NMailMakeDateString(DateStr: PChar; Year: Integer; Month: Integer; Day: Integer; Hour: Integer; Minute: Integer; Second: Integer; Flag: Integer): Integer; stdcall; External 'nMail.dll';
function NMailSmtpConnectSsl(HostName: PChar; PortNo: Integer; Flag: Integer; Name: PChar): TSocket; export; stdcall; External 'nMail.dll';
function NMailPop3ConnectSsl(HostName: PChar; PortNo: Integer; Flag: Integer; Name: PChar): TSocket; export; stdcall; External 'nMail.dll';
function NMailImap4ConnectSsl(HostName: PChar; PortNo: Integer; Flag: Integer; Name: PChar): TSocket; export; stdcall; External 'nMail.dll';
function NMailSmtpSendMailSsl(HostName: PChar; MailTo: PChar; Cc: PChar; Bcc: PChar; From: PChar; Subject: PChar; Body: PChar; Header: PChar; Path: PChar; Flag: Integer; PortNo: Integer; SslFlag: Integer; Name: PChar): Integer; export; stdcall; External 'nMail.dll';

implementation

end.
