//
//	nMail.dll wb_
//	  Copyright (c) 1999-2010 Nanshiki corporation
//
//	  1999/ 9/ 1 Version 1.00
//	  2000/11/ 1 Version 1.10
//	  2008/ 7/ 1 Version 1.30
//	  2009/ 9/ 1 Version 2.00
//	  2010/ 5/12 Version 3.00
//

#ifndef _NMAIL_H_
#define _NMAIL_H_

#ifndef _WINSOCKAPI_
#include <winsock.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define NMAIL_ATTACHMENT_TEMP_SIZE	(400)

#define	NMAIL_SMTP_PORT				(25)	// SMTP |[gԍ
#define	NMAIL_SMTP_SUBMISSION_PORT	(587)	// SMTP Tu~bV|[gԍ
#define	NMAIL_SMTP_SSL_PORT			(465)	// SMTP over SSL |[gԍ
#define	NMAIL_POP3_PORT				(110)	// POP3 |[gԍ
#define	NMAIL_POP3_SSL_PORT			(995)	// POP3 over SSL |[gԍ
#define	NMAIL_IMAP4_PORT			(143)	// IMAP4 |[gԍ
#define	NMAIL_IMAP4_SSL_PORT		(993)	// IMAP4 over SSL |[gԍ

#define	NMAIL_ERROR_SOCKET			(-1)	// ڑG[
#define	NMAIL_ERROR_AUTHENTICATE	(-2)	// F؎s
#define NMAIL_ERROR_INVALID_NO		(-3)	// [ԍȂ
#define NMAIL_ERROR_TIMEOUT			(-4)	// ^CAEg
#define NMAIL_ERROR_FILE_OPEN		(-5)	// Ytt@C̃I[vs
#define NMAIL_ERROR_PARTIAL			(-6)	// t@CSĂȂ
#define NMAIL_ERROR_FILE_ALREADY	(-7)	// Ytt@Cłɑ݂
#define NMAIL_ERROR_AUTHENTICATE_NO_SUPPORT	(-8)	// FؔΉ
#define NMAIL_ERROR_MEMORY			(-9)	// ł̃mۃG[
#define NMAIL_ERROR					(-10)	// ̑̃G[
// 2009/7/7
#define NMAIL_ERROR_INVALID_PARAMETER		(-11)	// p[^s
#define NMAIL_ERROR_IMAP4_NO				(-12)	// IMAP4  NO
#define NMAIL_ERROR_IMAP4_BAD				(-13)	// IMAP4  BAD
#define NMAIL_ERROR_IMAP4_NO_NAMESPACE		(-14)	// OԂ݂Ȃ
// 2004/12/28
#define NMAIL_ERROR_SUSPEND_ATTACHMENT_FILE		(-20)
#define NMAIL_ERROR_IMAP4_NO_RESULT				(-21)
// 2009/11/6
#define NMAIL_ERROR_SSL_NO_SUPPORT				(-30)	// OS  SSL ɔΉ
#define NMAIL_ERROR_STARTTLS_NO_SUPPORT			(-31)	// T[o STARTTLS ɔΉ

#define NMAIL_ERROR_SERVICE_NOT_AVAILABLE		(-421)	// T[rXpł
#define NMAIL_ERROR_MAILBOX_UNAVAILABLE			(-450)	// [{bNXgps(gp)
#define NMAIL_ERROR_LOCAL_ERROR					(-451)	// T[o[G[
#define NMAIL_ERROR_INSUFFICIENT_SYSTEM_STORAGE	(-452)	// VXeeʕsG[
#define NMAIL_ERROR_SYNTAX_ERROR				(-500)	// R}h̕@G[
#define NMAIL_ERROR_PARAMETER					(-501)	// p[^̕@G[
#define NMAIL_ERROR_COMMAND_NOT_IMPLEMENTED		(-502)	// R}h
#define NMAIL_ERROR_BAD_SEQUENCE				(-503)	// R}h̃V[PXُ
#define NMAIL_ERROR_SMTP_AUTHENTICATE			(-535)	// SMTP F؎s
#define NMAIL_ERROR_USER_UNKOWN					(-550)	// MȂ
#define NMAIL_ERROR_USER_NOT_LOCAL				(-551)	// [U[݂ȂA]斳
#define NMAIL_ERROR_EXCEEDED_STORAGE_ALLOCATION	(-552)	// eʃI[o[G[
#define NMAIL_ERROR_MAILBOX_NAME_NOT_ALLOWED	(-553)	// [{bNXȂ
#define NMAIL_ERROR_RELAY_OPERATION_REJECTED	(-553)	// [h~G[
#define NMAIL_ERROR_TRANSACTION_FAILED			(-554)	// gUNVs

#define NMAIL_NO_ATTACHMENT_FILE	(-1)	// Ytt@CȂ
#define NMAIL_ATTACHMENT_FILE		(0)		// Ytt@C(ĂȂ)

#define NMAIL_SUCCESS				(1)		// I

// 2004/12/28
#define NMAIL_PARTIAL_ATTACHMENT_FILE	(1)		// Ytt@C擾
#define NMAIL_GET_TEXT_ONLY				(2)		// {̂ݎ擾

#define NMAIL_ADD_DATE_FIELD				(0x0001)	// wb_DatetB[ht
#define NMAIL_ADD_MESSAGEID_FIELD			(0x0002)	// wb_Message-IDtB[ht
// 2004/12/28
#define NMAIL_SUSPEND_ATTACHMENT_FILE		(0x0004)	// Ytt@CMňꎞx~
#define NMAIL_SUSPEND_NEXT					(0x0008)	// ꎞx~̓ڈȍ~
// 2007/8/2
#define NMAIL_FILE_NAME_RFC2231				(0x0010)	// Ytt@C RFC2231 ŃGR[h
#define NMAIL_ENCODE_UTF8					(0x0020)	// [{ UTF-8(BASE64) őM
// 2011/11/25
#define NMAIL_SMTP_HTML						(0x0040)	// HTML [M
#define NMAIL_SMTP_HTML_USE_FILE			(0x0080)	// HTML p[g body ł͂ȂAYt html t@Cgp
#define NMAIL_SMTP_HTML_AUTO_PART			(0x0100)	// [̈̃hCŃp[g̗L𔻒
#define NMAIL_SMTP_HTML_NO_MIXED_PART		(0x0200)	// HTML  multipart/mixed p[g
#define NMAIL_SMTP_HTML_SOFTBANK			(0x0200)	// HTML  multipart/mixed p[g (softbankfR[)
#define NMAIL_SMTP_HTML_EMOBILE				(0x0200)	// HTML  multipart/mixed p[g (emobilefR[)
#define NMAIL_SMTP_HTML_WILLCOM				(0x0200)	// HTML  multipart/mixed p[g (willcomfR[)
#define NMAIL_SMTP_HTML_NO_RELATED_PART		(0x0400)	// HTML  multipart/related p[g
#define NMAIL_SMTP_HTML_AU					(0x0400)	// HTML  multipart/related p[g (aufR[)
#define NMAIL_SMTP_HTML_NO_PLAIN_PART		(0x0800)	// text/plain p[g (fR[nƂ͕ps)
#define NMAIL_SMTP_HTML_SET_PLAIN_BODY		(0x1000)	// text/plain p[g̕ body Ŏw
// 2009/7/7
#define NMAIL_IMAP4_MIME_PART_SAVE_AS_FILE	(0x0800)	// IMAP4 {fBp[gۑň̃pXŃt@Cw
#define NMAIL_IMAP4_MIME_PART_PEEK			(0x1000)	// IMAP4 {fBp[g擾ŊǃtO𗧂ĂȂ
#define NMAIL_IMAP4_MIME_PART_NO_DECODE		(0x2000)	// IMAP4 {fBp[g擾ŃfR[hȂ
#define NMAIL_IMAP4_MIME_PART_HEADER		(0x4000)	// IMAP4 {fBp[g̃wb_擾
#define NMAIL_IMAP4_USE_UID					(0x8000)	// IMAP4 Ń[ԍłȂ UID gp

#define NMAIL_OPTION_TIMEOUT			(0)		// ^CAEg
#define NMAIL_OPTION_HEADER_MAX			(1)		// wb_ől
#define NMAIL_OPTION_BODY_MAX			(2)		// {ől
#define NMAIL_OPTION_ALREADY_FILE		(3)		// t@C݂ꍇ̏
#define NMAIL_OPTION_DEBUG_MODE			(4)		// fobN[h
// 2003/11/4
#define NMAIL_OPTION_CONNECT_TIMEOUT	(5)		// ڑ^CAEgݒ
#define NMAIL_OPTION_SPLIT_CHAR			(6)		// ؂蕶
// 2004/12/28
#define NMAIL_OPTION_SUSPEND_SIZE		(7)		// ꎞx~t@CTCY
#define NMAIL_OPTION_SLEEP_TIME			(8)		// Sleep 
#define NMAIL_OPTION_FIELD_MAX			(9)		// wb_tB[hől
// 2009/1/5
#define NMAIL_OPTION_SAVE_HTML			(10)	// HTML [ HTML t@Cɕۑ邩
// 2009/2/12
#define NMAIL_OPTION_DECODE_BODY		(11)	// {̃eLXgfR[h邩
#define NMAIL_OPTION_DECODE_HEADER		(12)	// wb_fR[h邩
// 2010/7/16
#define NMAIL_OPTION_FILENAME_MAX		(13)	// Ytt@Ci[obt@̃TCY
// 2012/4/4
#define	NMAIL_OPTION_CHANGE_CHAR		(14)	// Ytt@C̎gpsu镶
#define	NMAIL_OPTION_CHANGE_CHAR_MODE	(15)	// Ytt@C̕u
// 2012/5/28
#define	NMAIL_OPTION_SAVE_RFC822		(16)	// RFC822 ǂ邩

#define NMAIL_FILE_OVERWRITE		(0)		// t@C݂ꍇ㏑
#define NMAIL_FILE_RENAME			(1)		// t@C݂ꍇOύXĕۑ
#define NMAIL_FILE_ALREADY_ERROR	(2)		// t@C݂ꍇG[

#define NMAIL_GET_ERROR_MESSAGE		(0)		// G[bZ[W
#define NMAIL_GET_DEBUG_MESSAGE		(1)		// fobNbZ[W

#define NMAIL_DEBUG_START		(1)		// fobNJn
#define NMAIL_DEBUG_END			(0)		// fobNI

#define NMAIL_GET_UIDL_ALL		(0)		// SĂ UIDL 𓾂

// 2003/11/4
#define NMAIL_CONNECT_TIMEOUT_ON		(1)		// ڑ^CAEgݒON
#define NMAIL_CONNECT_TIMEOUT_OFF		(0)		// ڑ^CAEgݒOFF

// 2004/12/28
#define NMAIL_SMTP_AUTH_NOT_USE			(0)		// F؂Ȃ
#define NMAIL_SMTP_AUTH_PLAIN			(1)		// PLAIN
#define NMAIL_SMTP_AUTH_LOGIN			(2)		// LOGIN
#define NMAIL_SMTP_AUTH_CRAM_MD5		(4)		// CRAM-MD5
#define NMAIL_SMTP_AUTH_DIGEST_MD5		(8)		// DIGEST-MD5

// 2009/1/5
#define NMAIL_SAVE_HTML_OFF				(0)		// HTML [ HTML ̓t@CɕۑȂ
#define NMAIL_SAVE_HTML_ON				(1)		// HTML [ HTML t@Cɕۑ (v Path w)

// 2009/2/12
#define NMAIL_DECODE_BODY_ON			(0)		// {͑SăfR[h
#define NMAIL_DECODE_BODY_ALL_OFF		(1)		// {͑SăfR[hȂ
#define NMAIL_DECODE_BODY_TEXT_OFF		(2)		// eLXgp[g Content-Transfer-Encoding w̃GR[ĥ݃fR[hȂ

#define NMAIL_DECODE_HEADER_ON			(0)		// wb_͑SăfR[h
#define NMAIL_DECODE_HEADER_OFF			(1)		// wb_͑SăfR[hȂ

// 2012/4/4
#define NMAIL_CHANGE_SPLIT_CHAR			(0)		// Ytt@C̋؂蕶ϊ
#define NMAIL_CHANGE_HALF_SPACE			(1)		// Ytt@C̔pXy[Xϊ
#define NMAIL_CHANGE_FULL_SPACE			(2)		// Ytt@C̑SpXy[Xϊ
#define NMAIL_CHANGE_ALL_SPACE			(3)		// Ytt@C̃Xy[Xϊ
#define NMAIL_CHANGE_NO_SPLIT_CHAR		(4)		// Ytt@C̋؂蕶ϊȂ

// 2012/5/28
#define NMAIL_SAVE_RFC822_OFF				(0x00)		// RFC822 p[g̃eLXg Body Ɋ܂߁APath w肪ΓYtt@C͕ۑ
#define NMAIL_SAVE_RFC822_BODY				(0x01)		// Path w肪L RFC822 p[g̃eLXgt@Cɕۑ
#define NMAIL_SAVE_RFC822_PART_ALL			(0x02)		// Path w肪L RFC822 p[g܂Ƃ߂ăt@Cɕۑ

// 2009/7/8
// IMAP4 F،`
#define NMAIL_IMAP4_AUTH_PLAIN			(1)		// PLAIN
#define NMAIL_IMAP4_AUTH_LOGIN			(2)		// LOGIN
#define NMAIL_IMAP4_AUTH_CRAM_MD5		(4)		// CRAM-MD5
#define NMAIL_IMAP4_AUTH_DIGEST_MD5		(8)		// DIGEST-MD5

// IMAP4 [{bNX
#define NMAIL_IMAP4_MAILBOX_NO_SELECT	(1)		// SELECT or EXAMINE ŊJȂ
#define NMAIL_IMAP4_MAILBOX_NO_INFERIOUS (2)	// q[{bNX쐬łȂ
#define NMAIL_IMAP4_MAILBOX_MARKED		 (4)	// bZ[WǉĂ\
#define NMAIL_IMAP4_MAILBOX_UNMARKED	 (8)	// bZ[WǉĂȂ
#define NMAIL_IMAP4_MAILBOX_CHILDREN	 (16)	// q[{bNX
#define NMAIL_IMAP4_MAILBOX_NO_CHILDREN	 (32)	// q[{bNX݂Ȃ

// IMAP4 [bZ[WtO
#define NMAIL_IMAP4_MESSAGE_ANSWERED	(1)		// ԐMς
#define NMAIL_IMAP4_MESSAGE_DELETED		(2)		// }[Nt
#define NMAIL_IMAP4_MESSAGE_DRAFT		(4)		// e
#define NMAIL_IMAP4_MESSAGE_FLAGGED		(8)		// dv
#define NMAIL_IMAP4_MESSAGE_RECENT		(16)	// 
#define NMAIL_IMAP4_MESSAGE_SEEN		(32)	// 

#define NMAIL_IMAP4_ADD_MESSAGE_FLAG		(1)		// tOǉ
#define NMAIL_IMAP4_DELETE_MESSAGE_FLAG		(2)		// tO폜
#define NMAIL_IMAP4_REPLACE_MESSAGE_FLAG	(3)		// tOu

#define NMAIL_IMAP4_MAILBOX_MESSAGE			(1)		// bZ[W
#define NMAIL_IMAP4_MAILBOX_RECENT			(2)		// VbZ[W
#define NMAIL_IMAP4_MAILBOX_UIDNEXT			(3)		// VbZ[W UID
#define NMAIL_IMAP4_MAILBOX_UIDVALIDITY		(4)		// [{bNX UID Validity
#define NMAIL_IMAP4_MAILBOX_UNSEEN			(5)		// ǃbZ[W

// IMAP4 p
#define NMAIL_IMAP4_SEARCH_ANSWERED			(1)		// ԐMς
#define NMAIL_IMAP4_SEARCH_UNANSWERED		(2)		// ԐMς݂łȂ
#define NMAIL_IMAP4_SEARCH_DELETED			(3)		// }[N
#define NMAIL_IMAP4_SEARCH_UNDELETED		(4)		// }[NȂ
#define NMAIL_IMAP4_SEARCH_DRAFT			(5)		// etO
#define NMAIL_IMAP4_SEARCH_UNDRAFT			(6)		// etOȂ
#define NMAIL_IMAP4_SEARCH_FLAGGED			(7)		// dvtO
#define NMAIL_IMAP4_SEARCH_UNFLAGGED		(8)		// dvtOȂ
#define NMAIL_IMAP4_SEARCH_RECENT			(9)		// tO
#define NMAIL_IMAP4_SEARCH_OLD				(10)	// tOȂ
#define NMAIL_IMAP4_SEARCH_SEEN				(11)	// ǃtO
#define NMAIL_IMAP4_SEARCH_UNSEEN			(12)	// ǃtOȂ
#define NMAIL_IMAP4_SEARCH_NEW				(13)	// tO肩ǃtOȂ
#define NMAIL_IMAP4_SEARCH_ALL				(14)	// SẴ[
#define NMAIL_IMAP4_SEARCH_KEYWORD			(15)	// w肳ꂽL[[h
#define NMAIL_IMAP4_SEARCH_UNKEYWORD		(16)	// w肳ꂽL[[hȂ
#define NMAIL_IMAP4_SEARCH_FROM				(17)	// FROM wb_tB[hɕ܂
#define NMAIL_IMAP4_SEARCH_TO				(18)	// TO wb_tB[hɕ܂
#define NMAIL_IMAP4_SEARCH_CC				(19)	// CC wb_tB[hɕ܂
#define NMAIL_IMAP4_SEARCH_BCC				(20)	// BCC wb_tB[hɕ܂
#define NMAIL_IMAP4_SEARCH_SUBJECT			(21)	// SUBJECT wb_tB[hɕ܂
#define NMAIL_IMAP4_SEARCH_SENTBEFORE		(22)	// DATEwb_tB[hw肳ꂽNȑO
#define NMAIL_IMAP4_SEARCH_SENTON			(23)	// DATEwb_tB[hw肳ꂽN
#define NMAIL_IMAP4_SEARCH_SENTSINCE		(24)	// DATEwb_tB[hw肳ꂽNȍ~
#define NMAIL_IMAP4_SEARCH_BEFORE			(25)	// w肳ꂽNȑOɓ
#define NMAIL_IMAP4_SEARCH_ON				(26)	// w肳ꂽNɓ
#define NMAIL_IMAP4_SEARCH_SINCE			(27)	// w肳ꂽNȍ~ɓ
#define NMAIL_IMAP4_SEARCH_HEADER			(28)	// w肵wb_tB[hɕ܂("tB[h ")
#define NMAIL_IMAP4_SEARCH_BODY				(29)	// {ɕ܂
#define NMAIL_IMAP4_SEARCH_TEXT				(30)	// wb_і{ɕ܂
#define NMAIL_IMAP4_SEARCH_LARGER			(31)	// wTCY傫ȃ[
#define NMAIL_IMAP4_SEARCH_SMALLER			(32)	// wTCY菬ȃ[
#define NMAIL_IMAP4_SEARCH_UID				(33)	// w UID 

#define NMAIL_IMAP4_SEARCH_COMMAND		(0x0100)	// 𒼐ڎw肷

#define NMAIL_IMAP4_SEARCH_NOT			(0x0200)	//  NOT
#define NMAIL_IMAP4_SEARCH_OR			(0x0400)	//  OR
#define NMAIL_IMAP4_SEARCH_AND			(0x0800)	//  AND
#define NMAIL_IMAP4_SEARCH_FIRST		(0x1000)	// [N
#define NMAIL_IMAP4_SEARCH_NO_WAIT		(0x2000)	// R}hsシɖ߂
#define NMAIL_IMAP4_SEARCH_CHECK		(0x4000)	// ʃ`FbN

#define NMAIL_IMAP4_NAMESPACE_PERSONAL_ALL	(0)			// lOԎ擾(^u؂)
#define NMAIL_IMAP4_NAMESPACE_OTHER_ALL		(1)			// lOԎ擾(^u؂)
#define NMAIL_IMAP4_NAMESPACE_SHARED_ALL	(2)			// LOԎ擾(^u؂)

#define NMAIL_IMAP4_NAMESPACE_PERSONAL_NO	(0x0100)		// lOԎ擾(wԖ)
#define NMAIL_IMAP4_NAMESPACE_OTHER_NO		(0x0200)		// lOԎ擾(wԖ)
#define NMAIL_IMAP4_NAMESPACE_SHARED_NO		(0x0300)		// LOԎ擾(wԖ)

#define NMAIL_IMAP4_NAMESPACE_PERSONAL_COUNT	(0x1000)	// lOԐ
#define NMAIL_IMAP4_NAMESPACE_OTHER_COUNT		(0x2000)	// lOԐ
#define NMAIL_IMAP4_NAMESPACE_SHARED_COUNT		(0x3000)	// LOԐ

#define NMAIL_IMAP4_MIME_CONTENT_PART				(0)			// {fBp[gԍ
#define NMAIL_IMAP4_MIME_CONTENT_TYPE				(1)			// Content-Type ^Cv
#define NMAIL_IMAP4_MIME_CONTENT_SUBTYPE			(2)			// Content-Type Tu^Cv
#define NMAIL_IMAP4_MIME_CONTENT_ID					(3)			// Content-ID
#define NMAIL_IMAP4_MIME_CONTENT_DESCRIPTION		(4)			// Content-Description
#define NMAIL_IMAP4_MIME_CONTENT_TRANSFER_ENCODING	(5)			// Content-Transfer-Encoding
#define NMAIL_IMAP4_MIME_CONTENT_FILE_NAME			(6)			// t@C
#define NMAIL_IMAP4_MIME_CONTENT_TYPE_AND_SUBTYPE	(7)			// Content-Type ^CvTu^Cv
#define NMAIL_IMAP4_MIME_CONTENT_SIZE				(8)			// {fBTCY
#define NMAIL_IMAP4_MIME_CONTENT_LINE				(9)			// {fBs
#define NMAIL_IMAP4_MIME_CONTENT_PARAMETER_COUNT	(10)		// Content-Type p[^
#define NMAIL_IMAP4_MIME_CONTENT_PARAMETER			(11)		// Content-Type p[^

#define NMAIL_MAKE_DATE_TIME_SMTP			(0x00000)	// SMTP(RFC2822)
#define NMAIL_MAKE_DATE_IMAP4				(0x08000)	// IMAP4t(RFC2060) p
#define NMAIL_MAKE_DATE_TIME_IMAP4			(0x10000)	// IMAP4(RFC2060) tp
#define NMAIL_MAKE_DATE_NOW					(0x20000)	// ݓ
#define NMAIL_MAKE_DATE_TIMEZONE_PLUS		(0x40000)	// ^C][w +
#define NMAIL_MAKE_DATE_TIMEZONE_MINUS		(0x80000)	// ^C][w -
#define NMAIL_MAKE_DATE_SIZE				(32)		// pobt@TCY

#define NMAIL_SSL_IGNORE_NOT_TIME_VALID		(0x0800)	// ؖ؂łG[ɂȂ
#define NMAIL_SSL_ALLOW_UNKNOWN_CA			(0x0400)	// MȂؖĂG[ɂȂ

#define NMAIL_SSL_SSL3						(0x1000)	// SSL Version 3
#define NMAIL_SSL_TLS1						(0x2000)	// TLS Version 1
#define NMAIL_SSL_STARTTLS					(0x4000)	// STARTTLS

#define	NMAIL_SSL_ERROR_UNTRUSTED_ROOT		(-2146762487)	// 0x800b0109 ؖ`F[͐ꂽAؖ@ւ̏ؖ̂1MĂȂ
#define	NMAIL_SSL_ERROR_INTERNAL			(-2146893052)	// 0x80090304 G[
#define	NMAIL_SSL_ERROR_ILLEGAL_MESSAGE		(-2146893018)	// 0x80090326 \ȂA܂͊Ԉ`̃f[^M
#define	NMAIL_SSL_ERROR_EXPIRED				(-2146893016)	// 0x80090328 Mؖ̊؂


//	o[W𓾂
//	in:  Ȃ
//	out: o[W (: 1.10 .. 110)
//
int WINAPI NMailGetVersion(VOID);

//
//	p[^ݒ
//	in:  TimeOutSec .. ^CAEg(bP)
//	     HeaderMax  .. wb_̍ől(oCg)
//	     BodyMax    .. [{̍ől(oCg)
//	out: Ȃ
//
VOID WINAPI NMailSetParameter(int TimeOutSec, int HeaderMax, int BodyMax);

//
//	WinSock 
//	in:  Ȃ
//	out: TRUE .. 
//
BOOL WINAPI NMailInitializeWinSock(VOID);

//
//	WinSock I
//	in:  Ȃ
//	out: TRUE .. I
//
BOOL WINAPI NMailEndWinSock(VOID);

//
//	POP3 T[oɐڑ
//	in:  HostName .. POP3 zXg
//	out: \Pbg
//	     INVALID_SOCKET ŃG[
//
SOCKET WINAPI NMailPop3Connect(LPCTSTR HostName);
SOCKET WINAPI NMailPop3ConnectA(LPCSTR HostName);
SOCKET WINAPI NMailPop3ConnectW(LPCWSTR HostName);
#if _MBCS
#define NMailPop3Connect	NMailPop3ConnectA
#endif
#ifdef _UNICODE
#define NMailPop3Connect	NMailPop3ConnectW
#endif

//
//	POP3 T[oɐڑ(|[gԍw)
//	in:  HostName .. POP3 zXg
//       PortNo   .. |[gԍ
//	out: \Pbg
//
SOCKET WINAPI NMailPop3ConnectPortNo(LPCTSTR HostName, int PortNo);
SOCKET WINAPI NMailPop3ConnectPortNoA(LPCSTR HostName, int PortNo);
SOCKET WINAPI NMailPop3ConnectPortNoW(LPCWSTR HostName, int PortNo);
#ifdef _MBCS
#define NMailPop3ConnectPortNo	NMailPop3ConnectPortNoA
#endif
#ifdef _UNICODE
#define NMailPop3ConnectPortNo	NMailPop3ConnectPortNoW
#endif

//
//	POP3 F
//	in:  Socket   .. \Pbg
//	     Id       .. [U[
//	     Password .. pX[h
//	     APopFlag .. APOP gp邩(True Ŏgp)
//	out: [
//	     ̐ŃG[
//
int WINAPI NMailPop3Authenticate(SOCKET Socket, LPCTSTR Id, LPCTSTR Password, BOOL APopFlag);
int WINAPI NMailPop3AuthenticateA(SOCKET Socket, LPCSTR Id, LPCSTR Password, BOOL APopFlag);
int WINAPI NMailPop3AuthenticateW(SOCKET Socket, LPCWSTR Id, LPCWSTR Password, BOOL APopFlag);
#ifdef _MBCS
#define NMailPop3Authenticate	NMailPop3AuthenticateA
#endif
#ifdef _UNICODE
#define NMailPop3Authenticate	NMailPop3AuthenticateW
#endif

//
//	POP3 ڑI
//	in:  Socket   .. \Pbg
//	out: ̐ŃG[
//
int WINAPI NMailPop3Close(SOCKET Socket);

//
//	POP3 [̏𓾂
//	in:  Socket   .. \Pbg
//	     No       .. [ԍ
//	     Subject  .. [̑薼
//	     Date     .. [̑M
//	     From     .. [̍ol
//	     SizeFlag .. TRUE ȂTCYԂ
//	out: SizeFlag  TRUE ȂTCY
//	     ̐ŃG[
//
int WINAPI NMailPop3GetMailStatus(SOCKET Socket, int No, LPTSTR Subject, LPTSTR Date, LPTSTR From, LPTSTR Header, BOOL SizeFlag);
int WINAPI NMailPop3GetMailStatusA(SOCKET Socket, int No, LPSTR Subject, LPSTR Date, LPSTR From, LPSTR Header, BOOL SizeFlag);
int WINAPI NMailPop3GetMailStatusW(SOCKET Socket, int No, LPWSTR Subject, LPWSTR Date, LPWSTR From, LPWSTR Header, BOOL SizeFlag);
#ifdef _MBCS
#define NMailPop3GetMailStatus	NMailPop3GetMailStatusA
#endif
#ifdef _UNICODE
#define NMailPop3GetMailStatus	NMailPop3GetMailStatusW
#endif

//
//	POP3 [̃TCY𓾂
//	in:  Socket   .. \Pbg
//	     No       .. [ԍ
//	out: [̃TCY
//	     ̐ŃG[
//
int WINAPI NMailPop3GetMailSize(SOCKET Socket, int No);

//
//	POP3 [𓾂
//	in:  Socket   .. \Pbg
//	     No       .. [ԍ
//	     Subject  .. [̑薼
//	     Date     .. [̑M
//	     From     .. [̍ol
//	     Header   .. [̃wb_
//	     Body     .. [̖{
//	     Path     .. Ytt@CۑtH_
//	                 NULL ŕۑ
//	     FileName .. Ytt@Ci[obt@
//	                 NULL Ŋi[
//	out: [̃TCY
//	     ̐ŃG[
//
int WINAPI NMailPop3GetMail(SOCKET Socket, int No, LPTSTR Subject, LPTSTR Date, LPTSTR From, LPTSTR Header, LPTSTR Body, LPCTSTR Path, LPTSTR FileName);
int WINAPI NMailPop3GetMailA(SOCKET Socket, int No, LPSTR Subject, LPSTR Date, LPSTR From, LPSTR Header, LPSTR Body, LPCSTR Path, LPSTR FileName);
int WINAPI NMailPop3GetMailW(SOCKET Socket, int No, LPWSTR Subject, LPWSTR Date, LPWSTR From, LPWSTR Header, LPWSTR Body, LPCWSTR Path, LPWSTR FileName);
#ifdef _MBCS
#define NMailPop3GetMail	NMailPop3GetMailA
#endif
#ifdef _UNICODE
#define NMailPop3GetMail	NMailPop3GetMailW
#endif

//
//	POP3 [𓾂(Ytt@CΉ)
//	in:  Socket   .. \Pbg
//	     No       .. [ԍ
//	     Subject  .. [̑薼
//	     Date     .. [̑M
//	     From     .. [̍ol
//	     Header   .. [̃wb_
//	     Body     .. [̖{
//	     Path     .. Ytt@CۑtH_
//	     FileName .. Ytt@Ci[obt@
//	out: ̐ŃG[
//
int WINAPI NMailPop3GetMailPartial(SOCKET Socket, int No, LPTSTR Subject, LPTSTR Date, LPTSTR From, LPTSTR Header, LPTSTR Body, LPCTSTR Path, LPTSTR FileName);
int WINAPI NMailPop3GetMailPartialA(SOCKET Socket, int No, LPSTR Subject, LPSTR Date, LPSTR From, LPSTR Header, LPSTR Body, LPCSTR Path, LPSTR FileName);
int WINAPI NMailPop3GetMailPartialW(SOCKET Socket, int No, LPWSTR Subject, LPWSTR Date, LPWSTR From, LPWSTR Header, LPWSTR Body, LPCWSTR Path, LPWSTR FileName);
#ifdef _MBCS
#define NMailPop3GetMailPartial	NMailPop3GetMailPartialA
#endif
#ifdef _UNICODE
#define NMailPop3GetMailPartial	NMailPop3GetMailPartialW
#endif

//
//	POP3 [𓾂 IvVt ꎞx~
//	in:  Socket   .. \Pbg
//	     No       .. [ԍ
//	     Subject  .. [̑薼
//	     Date     .. [̑M
//	     From     .. [̍ol
//	     Header   .. [̃wb_
//	     Body     .. [̖{
//	     Path     .. Ytt@CۑtH_
//	                 NULL ŕۑ
//	     FileName .. Ytt@Ci[obt@
//	                 NULL Ŋi[
//	     Temp     .. ꎞƃGA
//	                 NMAIL_ATTACHMENT_TEMP_SIZE mۂĂKv
//	                 NULL  nMail.DLL ̃obt@gp
//	     Flag     .. tO
//	out: [̃TCY
//	     ̐ŃG[
//
int WINAPI NMailPop3GetMailEx(SOCKET Socket, int No, LPTSTR Subject, LPTSTR Date, LPTSTR From, LPTSTR Header, LPTSTR Body, LPCTSTR Path, LPTSTR FileName, LPTSTR Temp, int Flag);
int WINAPI NMailPop3GetMailExA(SOCKET Socket, int No, LPSTR Subject, LPSTR Date, LPSTR From, LPSTR Header, LPSTR Body, LPCSTR Path, LPSTR FileName, LPSTR Temp, int Flag);
int WINAPI NMailPop3GetMailExW(SOCKET Socket, int No, LPWSTR Subject, LPWSTR Date, LPWSTR From, LPWSTR Header, LPWSTR Body, LPCWSTR Path, LPWSTR FileName, LPSTR Temp, int Flag);
#ifdef _MBCS
#define NMailPop3GetMailEx	NMailPop3GetMailExA
#endif
#ifdef _UNICODE
#define NMailPop3GetMailEx	NMailPop3GetMailExW
#endif

//
//	POP3 [폜
//	in:  Socket   .. \Pbg
//	     No       .. [ԍ
//	out: ̐ŃG[
//
int WINAPI NMailPop3DeleteMail(SOCKET Socket, int No);

//
//	POP3 [Ytt@Ct`FbN
//	in:  Socket   .. \Pbg
//	     No       .. [ԍ
//	     Id       .. t@C ID i[obt@
//	     Max      .. obt@TCY
//	out: NMAIL_NO_ATTACHMENT_FILE    .. Ytt@CȂ
//	     NMAIL_ATTACHMENT_FILE ȏ  .. Ytt@C
//	                                    NMAIL_ATTACHMENT_FILE(0) ŕ
//	                                    ĂȂYtt@C
//	                                    1 ȏ̏ꍇĂYt
//	                                    t@CŐl̓p[gԍ
//
int WINAPI NMailPop3GetAttachmentFileStatus(SOCKET Socket, int No, LPTSTR Id, int Max);
int WINAPI NMailPop3GetAttachmentFileStatusA(SOCKET Socket, int No, LPSTR Id, int Max);
int WINAPI NMailPop3GetAttachmentFileStatusW(SOCKET Socket, int No, LPWSTR Id, int Max);
#ifdef _MBCS
#define NMailPop3GetAttachmentFileStatus	NMailPop3GetAttachmentFileStatusA
#endif
#ifdef _UNICODE
#define NMailPop3GetAttachmentFileStatus	NMailPop3GetAttachmentFileStatusW
#endif

//
//	POP3 UIDL 𓾂
//	in:  Socket   .. \Pbg
//	     No       .. [ԍ
//	     Uidl     .. UIDL i[obt@
//	     Max      .. obt@TCY
//	out: ̐ŃG[
//
int WINAPI NMailPop3GetUidl(SOCKET Socket, int No, LPTSTR Uidl, int Max);
int WINAPI NMailPop3GetUidlA(SOCKET Socket, int No, LPSTR Uidl, int Max);
int WINAPI NMailPop3GetUidlW(SOCKET Socket, int No, LPWSTR Uidl, int Max);
#ifdef _MBCS
#define NMailPop3GetUidl	NMailPop3GetUidlA
#endif
#ifdef _UNICODE
#define NMailPop3GetUidl	NMailPop3GetUidlW
#endif

//
//	[𑗐M
//	in:  HostName .. SMTP T[o
//	     To       .. 
//	     Cc       .. CC
//	     Bcc      .. BCC
//	     From     .. ol
//	     Subject  .. 薼
//	     Body     .. [{
//	     Header   .. ̃wb_
//	     Path     .. Ytt@C(ȂNULL)
//	     Flag     .. wb_Date/Message-IDt邩
//	out: ̐ŃG[
//
int WINAPI NMailSmtpSendMail(LPCTSTR HostName, LPCTSTR To, LPCTSTR Cc, LPCTSTR Bcc, LPCTSTR From, LPCTSTR Subject, LPCTSTR Body, LPCTSTR Header, LPCTSTR Path, int Flag);
int WINAPI NMailSmtpSendMailA(LPCSTR HostName, LPCSTR To, LPCSTR Cc, LPCSTR Bcc, LPCSTR From, LPCSTR Subject, LPCSTR Body, LPCSTR Header, LPCSTR Path, int Flag);
int WINAPI NMailSmtpSendMailW(LPCWSTR HostName, LPCWSTR To, LPCWSTR Cc, LPCWSTR Bcc, LPCWSTR From, LPCWSTR Subject, LPCWSTR Body, LPCWSTR Header, LPCWSTR Path, int Flag);
#ifdef _MBCS
#define NMailSmtpSendMail	NMailSmtpSendMailA
#endif
#ifdef _UNICODE
#define NMailSmtpSendMail	NMailSmtpSendMailW
#endif

//
//	[𑗐M
//	in:  HostName .. SMTP T[o
//	     To       .. 
//	     Cc       .. CC
//	     Bcc      .. BCC
//	     From     .. ol
//	     Subject  .. 薼
//	     Body     .. [{
//	     Header   .. ̃wb_
//	     Path     .. Ytt@C(ȂNULL)
//	     Flag     .. wb_Date/Message-IDt邩
//	     PortNo   .. SMTP |[gԍ
//	out: ̐ŃG[
//
int WINAPI NMailSmtpSendMailPortNo(LPCTSTR HostName, LPCTSTR To, LPCTSTR Cc, LPCTSTR Bcc, LPCTSTR From, LPCTSTR Subject, LPCTSTR Body, LPCTSTR Header, LPCTSTR Path, int Flag, int PortNo);
int WINAPI NMailSmtpSendMailPortNoA(LPCSTR HostName, LPCSTR To, LPCSTR Cc, LPCSTR Bcc, LPCSTR From, LPCSTR Subject, LPCSTR Body, LPCSTR Header, LPCSTR Path, int Flag, int PortNo);
int WINAPI NMailSmtpSendMailPortNoW(LPCWSTR HostName, LPCWSTR To, LPCWSTR Cc, LPCWSTR Bcc, LPCWSTR From, LPCWSTR Subject, LPCWSTR Body, LPCWSTR Header, LPCWSTR Path, int Flag, int PortNo);
#ifdef _MBCS
#define NMailSmtpSendMailPortNo	NMailSmtpSendMailPortNoA
#endif
#ifdef _UNICODE
#define NMailSmtpSendMailPortNo	NMailSmtpSendMailPortNoW
#endif

// Version 1.25
//
//	SMTP T[oɐڑ
//	in:  HostName .. SMTP zXg
//	out: \Pbg
//	     INVALID_SOCKET ŃG[
//
SOCKET WINAPI NMailSmtpConnect(LPCTSTR HostName);
SOCKET WINAPI NMailSmtpConnectA(LPCSTR HostName);
SOCKET WINAPI NMailSmtpConnectW(LPCWSTR HostName);
#ifdef _MBCS
#define NMailSmtpConnect	NMailSmtpConnectA
#endif
#ifdef _UNICODE
#define NMailSmtpConnect	NMailSmtpConnectW
#endif

//
//	SMTP T[oɐڑ(|[gԍw)
//	in:  HostName .. SMTP zXg
//       PortNo   .. |[gԍ
//	out: \Pbg
//
SOCKET WINAPI NMailSmtpConnectPortNo(LPCTSTR HostName, int PortNo);
SOCKET WINAPI NMailSmtpConnectPortNoA(LPCSTR HostName, int PortNo);
SOCKET WINAPI NMailSmtpConnectPortNoW(LPCWSTR HostName, int PortNo);
#ifdef _MBCS
#define NMailSmtpConnectPortNo	NMailSmtpConnectPortNoA
#endif
#ifdef _UNICODE
#define NMailSmtpConnectPortNo	NMailSmtpConnectPortNoW
#endif

//
//	SMTP F
//	in:  Socket   .. \Pbg
//	     HostName .. SMTP zXg
//	     Id       .. [U[
//	     Password .. pX[h
//	     Mode     .. AUTH 
//	out: ̐ŃG[
//
int WINAPI NMailSmtpAuthenticate(SOCKET Socket, LPCTSTR HostName, LPCTSTR Id, LPCTSTR Password, int Mode);
int WINAPI NMailSmtpAuthenticateA(SOCKET Socket, LPCSTR HostName, LPCSTR Id, LPCSTR Password, int Mode);
int WINAPI NMailSmtpAuthenticateW(SOCKET Socket, LPCWSTR HostName, LPCWSTR Id, LPCWSTR Password, int Mode);
#ifdef _MBCS
#define NMailSmtpAuthenticate	NMailSmtpAuthenticateA
#endif
#ifdef _UNICODE
#define NMailSmtpAuthenticate	NMailSmtpAuthenticateW
#endif

//
//	[𑗐M \Pbgw
//	in:  Socket   .. \Pbg
//	     To       .. 
//	     Cc       .. CC
//	     Bcc      .. BCC
//	     From     .. ol
//	     Subject  .. 薼
//	     Body     .. [{
//	     Header   .. ̃wb_
//	     Path     .. Ytt@C(ȂNULL)
//	     Temp     .. ꎞƃGA
//	                 NMAIL_ATTACHMENT_TEMP_SIZE mۂĂKv
//	                 NULL  nMail.DLL ̃obt@gp
//	     Flag     .. etO
//	out: ̐ŃG[
//	      Flag  NMAIL_SUSPEND_ATTACHMENT_FILE w肵ꍇ
//	     NMAIL_ERROR_SUSPEND_ATTACHMENT_FILE AĂꍇ͑M
//	     ꎞx~Ŗ߂ĂƂɂȂ
//
int WINAPI NMailSmtpSendMailEx(SOCKET Socket, LPCTSTR To, LPCTSTR Cc, LPCTSTR Bcc, LPCTSTR From, LPCTSTR Subject, LPCTSTR Body, LPCTSTR Header, LPCTSTR Path, LPTSTR Temp, int Flag);
int WINAPI NMailSmtpSendMailExA(SOCKET Socket, LPCSTR To, LPCSTR Cc, LPCSTR Bcc, LPCSTR From, LPCSTR Subject, LPCSTR Body, LPCSTR Header, LPCSTR Path, LPSTR Temp, int Flag);
int WINAPI NMailSmtpSendMailExW(SOCKET Socket, LPCWSTR To, LPCWSTR Cc, LPCWSTR Bcc, LPCWSTR From, LPCWSTR Subject, LPCWSTR Body, LPCWSTR Header, LPCWSTR Path, LPSTR Temp, int Flag);
#ifdef _MBCS
#define NMailSmtpSendMailEx	NMailSmtpSendMailExA
#endif
#ifdef _UNICODE
#define NMailSmtpSendMailEx	NMailSmtpSendMailExW
#endif

//
//	SMTP ڑI
//	in:  Socket   .. \Pbg
//	out: ̐ŃG[
//
int WINAPI NMailSmtpClose(SOCKET Socket);

//
//	wb_i[Ăobt@珊̃tB[ho
//	in:  Field    .. tB[hli[obt@
//	     Header   .. wb_i[Ăobt@
//	     Name     .. tB[h
//	     Size     .. i[obt@̃TCY
//	out: TRUE     .. tB[h
//
BOOL WINAPI NMailGetHeaderField(LPTSTR Field, LPCTSTR Header, LPCTSTR Name, int Size);
BOOL WINAPI NMailGetHeaderFieldA(LPSTR Field, LPCSTR Header, LPCSTR Name, int Size);
BOOL WINAPI NMailGetHeaderFieldW(LPWSTR Field, LPCWSTR Header, LPCWSTR Name, int Size);
#ifdef _MBCS
#define NMailGetHeaderField	NMailGetHeaderFieldA
#endif
#ifdef _UNICODE
#define NMailGetHeaderField	NMailGetHeaderFieldW
#endif

//
//	wb_ MIME GR[hfR[h
//	in:  Destination   .. tB[hli[obt@
//	     Source        .. wb_i[Ăobt@
//	     Size          .. i[obt@̃TCY
//
BOOL WINAPI NMailDecodeHeaderField(LPSTR Destination, LPCSTR Source, int Size);
BOOL WINAPI NMailDecodeHeaderFieldA(LPSTR Destination, LPCSTR Source, int Size);
BOOL WINAPI NMailDecodeHeaderFieldW(LPWSTR Destination, LPCWSTR Source, int Size);
#ifdef _MBCS
#define NMailDecodeHeaderField	NMailDecodeHeaderFieldA
#endif
#ifdef _UNICODE
#define NMailDecodeHeaderField	NMailDecodeHeaderFieldW
#endif


//
//	t@CJn
//	in:  Temp        .. ꎞƃGA
//	                    NMAIL_ATTACHMENT_TEMP_SIZE mۂĂKv
//	                    NULL  nMail.DLL ̃obt@gp
//	     Subject     .. [̑薼
//	     Date        .. [̑M
//	     From        .. [̍ol
//	     Header      .. WJ̃wb_i[obt@
//	     Body        .. WJ̖{i[obt@
//	     Path        .. Ytt@CۑtH_
//	     FileName    .. Ytt@Ci[obt@
//	     FirstHeader .. ŏ̃[wb_
//	     FirstBody   .. ŏ̃[{
//	out: ̐ŃG[
//
int WINAPI NMailAttachmentFileFirst(LPSTR Temp, LPTSTR Subject, LPTSTR Date, LPTSTR From, LPTSTR Header, LPTSTR Body, LPCTSTR Path, LPTSTR FileName, LPCTSTR FirstHeader, LPCTSTR FirstBody);
int WINAPI NMailAttachmentFileFirstA(LPSTR Temp, LPSTR Subject, LPSTR Date, LPSTR From, LPSTR Header, LPSTR Body, LPCSTR Path, LPSTR FileName, LPCSTR FirstHeader, LPCSTR FirstBody);
int WINAPI NMailAttachmentFileFirstW(LPSTR Temp, LPWSTR Subject, LPWSTR Date, LPWSTR From, LPWSTR Header, LPWSTR Body, LPCWSTR Path, LPWSTR FileName, LPCWSTR FirstHeader, LPCWSTR FirstBody);
#ifdef _MBCS
#define NMailAttachmentFileFirst	NMailAttachmentFileFirstA
#endif
#ifdef _UNICODE
#define NMailAttachmentFileFirst	NMailAttachmentFileFirstW
#endif

//
//	t@C
//	in:  Temp       .. ꎞƃGA
//	                   NMAIL_ATTACHMENT_TEMP_SIZE mۂĂKv
//	                   NULL  nMail.DLL ̃obt@gp
//	     NextHeader .. Qڈȍ~̃[wb_
//	     NextBody   .. Qڈȍ~̃[{
//	out: ̐ŃG[
//
int WINAPI NMailAttachmentFileNext(LPSTR Temp, LPCTSTR NextHeader, LPCTSTR NextBody);
int WINAPI NMailAttachmentFileNextA(LPSTR Temp, LPCSTR NextHeader, LPCSTR NextBody);
int WINAPI NMailAttachmentFileNextW(LPSTR Temp, LPCWSTR NextHeader, LPCWSTR NextBody);
#ifdef _MBCS
#define NMailAttachmentFileNext	NMailAttachmentFileNextA
#endif
#ifdef _UNICODE
#define NMailAttachmentFileNext	NMailAttachmentFileNextW
#endif

//
//	t@C(VisualBasic p)
//
int WINAPI NMailAttachmentFileNextVB(LPSTR Temp, LPTSTR Subject, LPTSTR Date, LPTSTR From, LPTSTR Header, LPTSTR Body, LPCTSTR Path, LPTSTR FileName, LPCTSTR NextHeader, LPCTSTR NextBody);
int WINAPI NMailAttachmentFileNextVBA(LPSTR Temp, LPSTR Subject, LPSTR Date, LPSTR From, LPSTR Header, LPSTR Body, LPCSTR Path, LPSTR FileName, LPCSTR NextHeader, LPCSTR NextBody);
int WINAPI NMailAttachmentFileNextVBW(LPSTR Temp, LPWSTR Subject, LPWSTR Date, LPWSTR From, LPWSTR Header, LPWSTR Body, LPCWSTR Path, LPWSTR FileName, LPCWSTR NextHeader, LPCWSTR NextBody);
#ifdef _MBCS
#define NMailAttachmentFileNextVB	NMailAttachmentFileNextVBA
#endif
#ifdef _UNICODE
#define NMailAttachmentFileNextVB	NMailAttachmentFileNextVBW
#endif

//
//	t@CI
//	in:  Temp     .. ꎞƃGA
//	                 NMAIL_ATTACHMENT_TEMP_SIZE mۂĂKv
//	out: ̐ŃG[
//
int WINAPI NMailAttachmentFileClose(LPSTR Temp);

//
//	t@C̏𓾂
//	in:  Header   .. wb_i[Ăobt@
//	     Id       .. t@C ID i[obt@
//	     Max      .. obt@TCY
//	out: NMAIL_NO_ATTACHMENT_FILE    .. Ytt@CȂ
//	     NMAIL_ATTACHMENT_FILE ȏ  .. Ytt@C
//	                                    NMAIL_ATTACHMENT_FILE(0) ŕ
//	                                    ĂȂYtt@C
//	                                    1 ȏ̏ꍇĂYt
//	                                    t@CŐl̓p[gԍ
//
int WINAPI NMailAttachmentFileStatus(LPCTSTR Header, LPTSTR Id, int Max);
int WINAPI NMailAttachmentFileStatusA(LPCSTR Header, LPSTR Id, int Max);
int WINAPI NMailAttachmentFileStatusW(LPCWSTR Header, LPWSTR Id, int Max);
#ifdef _MBCS
#define NMailAttachmentFileStatus	NMailAttachmentFileStatusA
#endif
#ifdef _UNICODE
#define NMailAttachmentFileStatus	NMailAttachmentFileStatusW
#endif

//
//	IvVݒ
//	in:  Option  .. IvV
//	     Value   .. IvV̒l
//
BOOL WINAPI NMailSetOption(int Option, int Value);

//
//	IvVl̎擾
//	in:  Option  .. IvV
//  out: IvV̒l
//
int WINAPI NMailGetOption(int Option);

//
//	G[bZ[W𓾂
//	in:  Mtype    .. bZ[W
//		 Message  .. bZ[Wi[obt@
//	     Size     .. obt@TCY
//
VOID WINAPI NMailGetMessage(int Mtype, LPTSTR Message, int Size);
VOID WINAPI NMailGetMessageA(int Mtype, LPSTR Message, int Size);
VOID WINAPI NMailGetMessageW(int Mtype, LPWSTR Message, int Size);
#ifdef _MBCS
#define NMailGetMessage	NMailGetMessageA
#endif
#ifdef _UNICODE
#define NMailGetMessage	NMailGetMessageW
#endif

//
//	݂̒Pʂł̋x~񐔂Zo
//	in:  Path .. Ytt@C
//	out: x~
//	     NMAIL_ERROR_FILE_OPEN .. t@C݂Ȃ
//
int WINAPI NMailGetSuspendNumber(LPCTSTR Path);
int WINAPI NMailGetSuspendNumberA(LPCSTR Path);
int WINAPI NMailGetSuspendNumberW(LPCWSTR Path);
#ifdef _MBCS
#define NMailGetSuspendNumber	NMailGetSuspendNumberA
#endif
#ifdef _UNICODE
#define NMailGetSuspendNumber	NMailGetSuspendNumberW
#endif

//
//	IMAP4 T[oɐڑ
//	in:  HostName .. IMAP4 zXg
//	out: \Pbg
//	     INVALID_SOCKET or NMAIL_ERROR_TIMEOUT ŃG[
//
SOCKET WINAPI NMailImap4Connect(LPCTSTR HostName);
SOCKET WINAPI NMailImap4ConnectA(LPCSTR HostName);
SOCKET WINAPI NMailImap4ConnectW(LPCWSTR HostName);
#if _MBCS
#define NMailImap4Connect	NMailImap4ConnectA
#endif
#ifdef _UNICODE
#define NMailImap4Connect	NMailImap4ConnectW
#endif

//
//	IMAP4 T[oɐڑ(|[gԍw)
//	in:  HostName .. IMAP4 zXg
//       PortNo   .. |[gԍ
//	out: \Pbg
//
SOCKET WINAPI NMailImap4ConnectPortNo(LPCTSTR HostName, int PortNo);
SOCKET WINAPI NMailImap4ConnectPortNoA(LPCSTR HostName, int PortNo);
SOCKET WINAPI NMailImap4ConnectPortNoW(LPCWSTR HostName, int PortNo);
#ifdef _MBCS
#define NMailImap4ConnectPortNo	NMailImap4ConnectPortNoA
#endif
#ifdef _UNICODE
#define NMailImap4ConnectPortNo	NMailImap4ConnectPortNoW
#endif

//
//	IMAP4 F
//	in:  Socket   .. \Pbg
//	     Id       .. [U[
//	     Password .. pX[h
//	     Mode     .. Fؕ
//	out: G[R[h
//
int WINAPI NMailImap4Authenticate(SOCKET Socket, LPCTSTR Id, LPCTSTR Password, int Mode);
int WINAPI NMailImap4AuthenticateA(SOCKET Socket, LPCSTR Id, LPCSTR Password, int Mode);
int WINAPI NMailImap4AuthenticateW(SOCKET Socket, LPCWSTR Id, LPCWSTR Password, int Mode);
#ifdef _MBCS
#define NMailImap4Authenticate	NMailImap4AuthenticateA
#endif
#ifdef _UNICODE
#define NMailImap4Authenticate	NMailImap4AuthenticateW
#endif

//
//	IMAP4 [{bNXI
//	in:  Socket   .. \Pbg
//	     MailBox  .. [{bNX
//	     ReadOnlyFlag .. ǂݏopŊJ
//	out: G[R[h
//
int WINAPI NMailImap4SelectMailBox(SOCKET Socket, LPCTSTR MailBox, BOOL ReadOnlyFlag);
int WINAPI NMailImap4SelectMailBoxA(SOCKET Socket, LPCSTR MailBox, BOOL ReadOnlyFlag);
int WINAPI NMailImap4SelectMailBoxW(SOCKET Socket, LPCWSTR MailBox, BOOL ReadOnlyFlag);
#ifdef _MBCS
#define NMailImap4SelectMailBox	NMailImap4SelectMailBoxA
#endif
#ifdef _UNICODE
#define NMailImap4SelectMailBox	NMailImap4SelectMailBoxW
#endif

//
//	IMAP4 [{bNXII
//	in:  Socket   .. \Pbg
//	out: G[R[h
//
int WINAPI NMailImap4CloseMailBox(SOCKET Socket);

//
//	IMAP4 [𓾂
//	in:  Socket   .. \Pbg
//	     No       .. [ԍ
//	     Subject  .. [̑薼
//	     Date     .. [̑M
//	     From     .. [̍ol
//	     Header   .. [̃wb_
//	     Body     .. [̖{
//	     Path     .. Ytt@CۑtH_
//	     FileName .. Ytt@Ci[obt@
//	     Flag     .. tO
//	out: G[R[h
//
int WINAPI NMailImap4GetMail(SOCKET Socket, DWORD MailNo, LPTSTR Subject, LPTSTR Date, LPTSTR From, LPTSTR Header, LPTSTR Body, LPCTSTR Path, LPTSTR FileName, int Flag);
int WINAPI NMailImap4GetMailA(SOCKET Socket, DWORD MailNo, LPSTR Subject, LPSTR Date, LPSTR From, LPSTR Header, LPSTR Body, LPCSTR Path, LPSTR FileName, int Flag);
int WINAPI NMailImap4GetMailW(SOCKET Socket, DWORD MailNo, LPWSTR Subject, LPWSTR Date, LPWSTR From, LPWSTR Header, LPWSTR Body, LPCWSTR Path, LPWSTR FileName, int Flag);
#ifdef _MBCS
#define NMailImap4GetMail	NMailImap4GetMailA
#endif
#ifdef _UNICODE
#define NMailImap4GetMail	NMailImap4GetMailW
#endif

//
//	IMAP4 [{bNXXgAbv
//	in:  Socket        .. \Pbg
//	     Refer         .. ꏊ
//	     MailBox       .. ChJ[h([{bNX)
//	     SubscribeFlag .. wǍς݃[{bNX̂݌邩
//	out: [{bNX
//	     ̐ŃG[R[h
//
int WINAPI NMailImap4GetMailBoxList(SOCKET Socket, LPCTSTR Refer, LPCTSTR MailBox, BOOL SubscribeFlag);
int WINAPI NMailImap4GetMailBoxListA(SOCKET Socket, LPCSTR Refer, LPCSTR MailBox, BOOL SubscribeFlag);
int WINAPI NMailImap4GetMailBoxListW(SOCKET Socket, LPCWSTR Refer, LPCWSTR MailBox, BOOL SubscribeFlag);
#ifdef _MBCS
#define NMailImap4GetMailBox	NMailImap4GetMailBoxListA
#endif
#ifdef _UNICODE
#define NMailImap4GetMailBox	NMailImap4GetMailBoxListW
#endif

//
//	IMAP4 [{bNXXgAbv擾
//	in:  Socket      .. \Pbg
//	     ListNo      .. [{bNXXgԍ
//		 MailBoxFlag .. [{bNXtOi[ϐւ̃|C^
//	     Separate    .. [{bNX؂蕶i[obt@
//	     MailBox     .. [{bNXi[obt@
//	     Size        .. [{bNXi[obt@̃TCY
//	out: G[R[h
//
int WINAPI NMailImap4GetMailBoxListStatus(SOCKET Socket, int ListNo, int *MailBoxFlag, LPTSTR Separate, LPTSTR MailBox, int Size);
int WINAPI NMailImap4GetMailBoxListStatusA(SOCKET Socket, int ListNo, int *MailBoxFlag, LPSTR Separate, LPSTR MailBox, int Size);
int WINAPI NMailImap4GetMailBoxListStatusW(SOCKET Socket, int ListNo, int *MailBoxFlag, LPWSTR Separate, LPWSTR MailBox, int Size);
#ifdef _MBCS
#define NMailImap4GetMailBoxListStatus	NMailImap4GetMailBoxListStatusA
#endif
#ifdef _UNICODE
#define NMailImap4GetMailBoxListStatus	NMailImap4GetMailBoxListStatusW
#endif

//
//	IMAP4 [̃TCY𓾂
//	in:  Socket   .. \Pbg
//	     MailNo   .. [ԍ
//	     Flag     .. tO(UID)
//	out: [̃TCY
//	     ̐ŃG[
//
int WINAPI NMailImap4GetMailSize(SOCKET Socket, DWORD MailNo, int Flag);

//
//	IMAP4 [̏𓾂
//	in:  Socket      .. \Pbg
//	     MaiNo       .. [ԍ
//	     Subject     .. [̑薼
//	     Date        .. [̑M
//	     From        .. [̍ol
//	     Header      .. wb_
//	     MessageFlag .. bZ[WtOi[ϐ
//	     Flag        .. tO(UID)
//	out: G[R[h
//
int WINAPI NMailImap4GetMailStatus(SOCKET Socket, DWORD MailNo, LPTSTR Subject, LPTSTR Date, LPTSTR From, LPTSTR Header, int *MessageFlag, int Flag);
int WINAPI NMailImap4GetMailStatusA(SOCKET Socket, DWORD MailNo, LPSTR Subject, LPSTR Date, LPSTR From, LPSTR Header, int *MessageFlag, int Flag);
int WINAPI NMailImap4GetMailStatusW(SOCKET Socket, DWORD MailNo, LPWSTR Subject, LPWSTR Date, LPWSTR From, LPWSTR Header, int *MessageFlag, int Flag);
#ifdef _MBCS
#define NMailImap4GetMailStatus	NMailImap4GetMailStatusA
#endif
#ifdef _UNICODE
#define NMailImap4GetMailStatus	NMailImap4GetMailStatusW
#endif

//
//	IMAP4 [폜(폜tOt邾)
//	in:  Socket   .. \Pbg
//	     MailNo   .. [ԍ
//	     Flag     .. tO(UID)
//	out: G[R[h
//
int WINAPI NMailImap4DeleteMail(SOCKET Socket, DWORD MailNo, int Flag);

//
//	IMAP4 [폜s
//	in:  Socket   .. \Pbg
//	out: G[R[h
//
int WINAPI NMailImap4ExpungeMail(SOCKET Socket);

//
//	IMAP4 [bZ[WtOύX
//	in:  Socket      .. \Pbg
//	     MailNo      .. [ԍ
//	     MessageFlag .. tO
//	     Command     .. ǉ/폜
//	     Flag     .. tO(UID)
//	out: G[R[h
//
int WINAPI NMailImap4ChangeMessageFlag(SOCKET Socket, DWORD MailNo, int MessageFlag, int Command, int Flag);

//
//	IMAP4 [{bNX쐬
//	in:  Socket   .. \Pbg
//	     MailBox  .. 쐬郁[{bNX
//	out: G[R[h
//
int WINAPI NMailImap4CreateMailBox(SOCKET Socket, LPCTSTR MailBox);
int WINAPI NMailImap4CreateMailBoxA(SOCKET Socket, LPCSTR MailBox);
int WINAPI NMailImap4CreateMailBoxW(SOCKET Socket, LPCWSTR MailBox);
#ifdef _MBCS
#define NMailImap4CreateMailBox	NMailImap4CreateMailBoxA
#endif
#ifdef _UNICODE
#define NMailImap4CreateMailBox	NMailImap4CreateMailBoxW
#endif

//
//	IMAP4 [{bNX폜
//	in:  Socket   .. \Pbg
//	     MailBox  .. 폜郁[{bNX
//	out: G[R[h
//
int WINAPI NMailImap4DeleteMailBox(SOCKET Socket, LPCTSTR MailBox);
int WINAPI NMailImap4DeleteMailBoxA(SOCKET Socket, LPCSTR MailBox);
int WINAPI NMailImap4DeleteMailBoxW(SOCKET Socket, LPCWSTR MailBox);
#ifdef _MBCS
#define NMailImap4DeleteMailBox	NMailImap4DeleteMailBoxA
#endif
#ifdef _UNICODE
#define NMailImap4DeleteMailBox	NMailImap4DeleteMailBoxW
#endif

//
//	IMAP4 [{bNX̕ύX
//	in:  Socket      .. \Pbg
//	     OldMailBox  .. ̕ύX郁[{bNX
//	     NewMailBox  .. ̕ύX̃[{bNX
//	out: G[R[h
//
int WINAPI NMailImap4RenameMailBox(SOCKET Socket, LPCTSTR OldMailBox, LPCTSTR NewMailBox);
int WINAPI NMailImap4RenameMailBoxA(SOCKET Socket, LPCSTR OldMailBox, LPCSTR NewMailBox);
int WINAPI NMailImap4RenameMailBoxW(SOCKET Socket, LPCWSTR OldMailBox, LPCWSTR NewMailBox);
#ifdef _MBCS
#define NMailImap4RenameMailBox	NMailImap4RenameMailBoxA
#endif
#ifdef _UNICODE
#define NMailImap4RenameMailBox	NMailImap4RenameMailBoxW
#endif

//
//	IMAP4 [{bNXw
//	in:  Socket   .. \Pbg
//	     MailBox  .. wǂ郁[{bNX
//	out: G[R[h
//
int WINAPI NMailImap4SubscribeMailBox(SOCKET Socket, LPCTSTR MailBox);
int WINAPI NMailImap4SubscribeMailBoxA(SOCKET Socket, LPCSTR MailBox);
int WINAPI NMailImap4SubscribeMailBoxW(SOCKET Socket, LPCWSTR MailBox);
#ifdef _MBCS
#define NMailImap4SubscribeMailBox	NMailImap4SubscribeMailBoxA
#endif
#ifdef _UNICODE
#define NMailImap4SubscribeMailBox	NMailImap4SubscribeMailBoxW
#endif

//
//	IMAP4 [{bNXwǉ
//	in:  Socket   .. \Pbg
//	     MailBox  .. wǉ郁[{bNX
//	out: G[R[h
//
int WINAPI NMailImap4UnsubscribeMailBox(SOCKET Socket, LPCTSTR MailBox);
int WINAPI NMailImap4UnsubscribeMailBoxA(SOCKET Socket, LPCSTR MailBox);
int WINAPI NMailImap4UnsubscribeMailBoxW(SOCKET Socket, LPCWSTR MailBox);
#ifdef _MBCS
#define NMailImap4UnsubscribeMailBox	NMailImap4UnsubscribeMailBoxA
#endif
#ifdef _UNICODE
#define NMailImap4UnsubscribeMailBox	NMailImap4UnsubscribeMailBoxW
#endif

//
//	IMAP4 [Rs[
//	in:  Socket   .. \Pbg
//	     MailNo   .. [ԍ
//	     MailBox  .. Rs[̃[{bNX
//	     Flag     .. tO(UID)
//	out: G[R[h
//
int WINAPI NMailImap4CopyMail(SOCKET Socket, DWORD MaiNo, LPCTSTR MailBox, int Flag);
int WINAPI NMailImap4CopyMailA(SOCKET Socket, DWORD MailNo, LPCSTR MailBox, int Flag);
int WINAPI NMailImap4CopyMailW(SOCKET Socket, DWORD MailNo, LPCWSTR MailBox, int Flag);
#ifdef _MBCS
#define NMailImap4CopyMail	NMailImap4CopyMailA
#endif
#ifdef _UNICODE
#define NMailImap4CopyMail	NMailImap4CopyMailW
#endif

//
//	IMAP4 UID 𓾂
//	in:  Socket   .. \Pbg
//	     MailNo   .. [ԍ
//	     Uid      .. UID i[obt@
//	out: NMAIL_SUCCESS .. 
//
int WINAPI NMailImap4GetUid(SOCKET Socket, DWORD No, DWORD *Uid);

//
//	IMAP4 [{bNX擾
//	in:  Socket   .. \Pbg
//	     MailBox  .. [{bNX
//	     Type     .. 
//	     Data     .. i[pobt@
//	out: G[R[h
//
int WINAPI NMailImap4GetMailBoxStatus(SOCKET Socket, LPCTSTR MailBox, int Type, DWORD *Data);
int WINAPI NMailImap4GetMailBoxStatusA(SOCKET Socket, LPCSTR MailBox, int Type, DWORD *Data);
int WINAPI NMailImap4GetMailBoxStatusW(SOCKET Socket, LPCWSTR MailBox, int Type, DWORD *Data);
#ifdef _MBCS
#define NMailImap4GetMailBoxStatus	NMailImap4GetMailBoxStatusA
#endif
#ifdef _UNICODE
#define NMailImap4GetMailBoxStatus	NMailImap4GetMailBoxStatusW
#endif

//
//	IMAP4 [
//	in:  Socket   .. \Pbg
//	     Type     .. 
//	     Text     .. 
//	     Flag     .. tO(UID)
//	out: Ɉv[
//	     ̐ŃG[
//
int WINAPI NMailImap4SearchMail(SOCKET Socket, int Type, LPCTSTR Text, int Flag);
int WINAPI NMailImap4SearchMailA(SOCKET Socket, int Type, LPCSTR Text, int Flag);
int WINAPI NMailImap4SearchMailW(SOCKET Socket, int Type, LPCWSTR Text, int Flag);
#ifdef _MBCS
#define NMailImap4SearchMail	NMailImap4SearchMailA
#endif
#ifdef _UNICODE
#define NMailImap4SearchMail	NMailImap4SearchMailW
#endif

//
//	IMAP4 ʎ擾
//	in:  Socket   .. \Pbg
//	     ResultNo .. ʔԍ
//	     MailNo   .. [ԍi[obt@
//	out: [ԍ
//
int WINAPI NMailImap4GetSearchMailResult(SOCKET Socket, int ResultNo, DWORD *MailNo);

//
//	IMAP4 [[{bNXɊi[
//	in:  Socket      .. \Pbg
//	     MailBox     .. [[{bNX
//	     Header      .. [wb_
//	     Body        .. [{
//	     Path        .. Ytt@C NULL ŒǉȂ
//	     Flag        .. tO
//	     MessageFlag .. bZ[WtO
//	     Date        .. [ǉ(wb_Ƃ͕) NULL Ōݓ
//	out: G[R[h
//
int WINAPI NMailImap4AppendMail(SOCKET Socket, LPCTSTR MailBox, LPCTSTR Header, LPCTSTR Body, LPCSTR Path, int MessageFlag, LPCTSTR Date, int Flag);
int WINAPI NMailImap4AppendMailA(SOCKET Socket, LPCSTR MailBox, LPCSTR Header, LPCSTR Body, LPCSTR Path, int MessageFlag, LPCSTR Date, int Flag);
int WINAPI NMailImap4AppendMailW(SOCKET Socket, LPCWSTR MailBox, LPCWSTR Header, LPCWSTR Body, LPCWSTR Path, int MessageFlag, LPCWSTR Date, int Flag);
#ifdef _MBCS
#define NMailImap4AppendMail	NMailImap4AppendMailA
#endif
#ifdef _UNICODE
#define NMailImap4AppendMail	NMailImap4AppendMailW
#endif

//
//	쐬
//	in: String   .. i[obt@
//	    Year     .. N
//	    Month    .. 
//	    Day      .. 
//	    Hour     .. 
//	    Minute   .. 
//	    Second   .. b
//	out: G[R[h
//
int WINAPI NMailMakeDateString(LPTSTR String, int Year, int Month, int Day, int Hour, int Minute, int Second, int Flag);
int WINAPI NMailMakeDateStringA(LPSTR String, int Year, int Month, int Day, int Hour, int Minute, int Second, int Flag);
int WINAPI NMailMakeDateStringW(LPWSTR String, int Year, int Month, int Day, int Hour, int Minute, int Second, int Flag);
#ifdef _MBCS
#define NMailMakeDateString		NMailMakeDateStringA
#endif
#ifdef _UNICODE
#define NMailMakeDateString		NMailMakeDateStringW
#endif

//
//	IMAP4 OԂ擾
//	in:  Socket           .. \Pbg
//	out: G[R[h
//
int WINAPI NMailImap4GetNameSpace(SOCKET Socket);

//
//	IMAP4 Oԏ擾
//	in:  Socket   .. \Pbg
//	     Type     .. OԎ
//	     Separete .. Oԋ؂蕶i[obt@
//	     Name     .. OԖ̂i[obt@
//	     Size     .. OԖ̂i[obt@̃TCY
//	out: G[R[h
//
int WINAPI NMailImap4GetNameSpaceStatus(SOCKET Socket, int Type, LPSTR Separate, LPSTR Name, int Size);
int WINAPI NMailImap4GetNameSpaceStatusA(SOCKET Socket, int Type, LPSTR Separate, LPSTR Name, int Size);
int WINAPI NMailImap4GetNameSpaceStatusW(SOCKET Socket, int Type, LPWSTR Separate, LPWSTR Name, int Size);
#ifdef _MBCS
#define NMailImap4GetNameSpaceStatus		NMailImap4GetNameSpaceStatusA
#endif
#ifdef _UNICODE
#define NMailImap4GetNameSpaceStatus		NMailImap4GetNameSpaceStatusW
#endif

//
//	IMAP4 [̍\擾
//	in:  Socket .. \Pbg
//	     MailNo .. [ԍ
//	     Flag   .. tO(UID)
//	out: MIME \p[g
//	     ̐ŃG[
//
int WINAPI NMailImap4GetMimeStructure(SOCKET Socket, DWORD MailNo, int Flag);

//
//	IMAP4 [\擾
//	in:  Socket   .. \Pbg
//	     Type     .. 
//	     PartNo   .. \ԍ
//	     SubNo    .. \p[^ԍ
//	     Name     .. \̊i[obt@
//	     Value    .. p[^li[obt@
//	     Size     .. i[obt@̃TCY
//	out: NMAIL_IMAP4_MIME_CONTENT_PARAMETER_COUNT,
//		 NMAIL_IMAP4_MIME_CONTENT_SIZE,
//		 NMAIL_IMAP4_MIME_CONTENT_LINE ̏ꍇ͐l
//		 ̒l̓G[R[h
//
int WINAPI NMailImap4GetMimeStructureStatus(SOCKET Socket, int Type, int PartNo, int SubNo, LPTSTR Name, LPTSTR Value, int Size);
int WINAPI NMailImap4GetMimeStructureStatusA(SOCKET Socket, int Type, int PartNo, int SubNo, LPSTR Name, LPSTR Value, int Size);
int WINAPI NMailImap4GetMimeStructureStatusW(SOCKET Socket, int Type, int PartNo, int SubNo, LPWSTR Name, LPWSTR Value, int Size);
#ifdef _MBCS
#define	NMailImap4GetMimeStructureStatus 	NMailImap4GetMimeStructureStatusA
#endif
#ifdef _UNICODE
#define NMailImap4GetMimeStructureStatus	NMailImap4GetMimeStructureStatusW
#endif

//
//	IMAP4 [{fBʎ擾
//	in:  Socket   .. \Pbg
//	     MailNo   .. [ԍ
//	     PartNo   .. \ԍ
//	     Body     .. {fBi[obt@
//	     Flag     .. tO
//	out: G[R[h
//
int WINAPI NMailImap4GetMimePart(SOCKET Socket, DWORD MailNo, int PartNo, LPTSTR Body, int Flag);
int WINAPI NMailImap4GetMimePartA(SOCKET Socket, DWORD MailNo, int PartNo, LPSTR Body, int Flag);
int WINAPI NMailImap4GetMimePartW(SOCKET Socket, DWORD MailNo, int PartNo, LPWSTR Body, int Flag);
#ifdef _MBCS
#define	NMailImap4GetMimePart 	NMailImap4GetMimePartA
#endif
#ifdef _UNICODE
#define NMailImap4GetMimePart	NMailImap4GetMimePartW
#endif

//
//	IMAP4 [{fBt@Cۑ
//	in:  Socket   .. \Pbg
//	     MailNo   .. [ԍ
//	     PartNo   .. \ԍ
//	     Path     .. Ytt@CۑtH_
//	     FileName .. Ytt@Ci[obt@
//	     Flag     .. tO
//	out: G[R[h
//
int WINAPI NMailImap4SaveMimePart(SOCKET Socket, DWORD MailNo, int PartNo, LPCTSTR Path, LPTSTR FileName, int Flag);
int WINAPI NMailImap4SaveMimePartA(SOCKET Socket, DWORD MailNo, int PartNo, LPCSTR Path, LPTSTR FileName, int Flag);
int WINAPI NMailImap4SaveMimePartW(SOCKET Socket, DWORD MailNo, int PartNo, LPCWSTR Path, LPWSTR FileName, int Flag);
#ifdef _MBCS
#define	NMailImap4SaveMimePart 	NMailImap4SaveMimePartA
#endif
#ifdef _UNICODE
#define NMailImap4SaveMimePart	NMailImap4SaveMimePartW
#endif

//
//	IMAP4 R}hM
//	in:  Socket   .. \Pbg
//	out: ̐ŃG[
//
int WINAPI NMailImap4NoOperation(SOCKET Socket);

//
//	IMAP4 ڑI
//	in:  Socket   .. \Pbg
//	out: ̐ŃG[
//
int WINAPI NMailImap4Close(SOCKET Socket);

//
//	POP3 T[oɐڑ SSL
//	in:  HostName .. POP3 zXg
//	     PortNo   .. POP3 |[gԍ
//	     Flag     .. SSL ݒtO
//	     Name     .. NCAgؖ
//	out: \Pbg
//	     INVALID_SOCKET ŃG[
//
SOCKET WINAPI NMailPop3ConnectSsl(LPCTSTR HostName, int PortNo, int Flag, LPCTSTR Name);
SOCKET WINAPI NMailPop3ConnectSslA(LPCSTR HostName, int PortNo, int Flag, LPCSTR Name);
SOCKET WINAPI NMailPop3ConnectSslW(LPCWSTR HostName, int PortNo, int Flag, LPCWSTR Name);
#ifdef _MBCS
#define NMailPop3ConnectSsl	NMailPop3ConnectSslA
#endif
#ifdef _UNICODE
#define NMailPop3ConnectSsl	NMailPop3ConnectSslW
#endif

//
//	SMTP T[oɐڑ SSL
//	in:  HostName .. SMTP zXg
//	     PortNo   .. SMTP |[gԍ
//	     Flag     .. SSL ݒtO
//	     Name     .. NCAgؖ
//	out: \Pbg
//	     INVALID_SOCKET ŃG[
//
SOCKET WINAPI NMailSmtpConnectSsl(LPCTSTR HostName, int PortNo, int Flag, LPCTSTR Name);
SOCKET WINAPI NMailSmtpConnectSslA(LPCSTR HostName, int PortNo, int Flag, LPCSTR Name);
SOCKET WINAPI NMailSmtpConnectSslW(LPCWSTR HostName, int PortNo, int Flag, LPCWSTR Name);
#ifdef _MBCS
#define NMailSmtpConnectSsl	NMailSmtpConnectSslA
#endif
#ifdef _UNICODE
#define NMailSmtpConnectSsl	NMailSmtpConnectSslW
#endif

//
//	IMAP4 T[oɐڑ SSL
//	in:  HostName .. IMAP4 zXg
//	     PortNo   .. IMAP4 |[gԍ
//	     Flag     .. SSL ݒtO
//	     Name     .. NCAgؖ
//	out: \Pbg
//	     INVALID_SOCKET ŃG[
//
SOCKET WINAPI NMailImap4ConnectSsl(LPCTSTR HostName, int PortNo, int Flag, LPCTSTR Name);
SOCKET WINAPI NMailImap4ConnectSslA(LPCSTR HostName, int PortNo, int Flag, LPCSTR Name);
SOCKET WINAPI NMailImap4ConnectSslW(LPCWSTR HostName, int PortNo, int Flag, LPCWSTR Name);
#ifdef _MBCS
#define NMailImap4ConnectSsl	NMailImap4ConnectSslA
#endif
#ifdef _UNICODE
#define NMailImap4ConnectSsl	NMailImap4ConnectSslW
#endif

//
//	[𑗐M SSL
//	in:  HostName .. SMTP T[o
//	     To       .. 
//	     Cc       .. CC
//	     Bcc      .. BCC
//	     From     .. ol
//	     Subject  .. 薼
//	     Body     .. [{
//	     Header   .. ̃wb_
//	     Path     .. Ytt@C(ȂNULL)
//	     Flag     .. wb_Date/Message-IDt邩
//	     PortNo   .. SMTP |[gԍ
//	     SslFlag  .. SSL ݒtO
//	     Name     .. NCAgؖ
//	out: ̐ŃG[
//
int WINAPI NMailSmtpSendMailSsl(LPCTSTR HostName, LPCTSTR To, LPCTSTR Cc, LPCTSTR Bcc, LPCTSTR From, LPCTSTR Subject, LPCTSTR Body, LPCTSTR Header, LPCTSTR Path, int Flag, int PortNo, int SslFlag, LPCTSTR Name);
int WINAPI NMailSmtpSendMailSslA(LPCSTR HostName, LPCSTR To, LPCSTR Cc, LPCSTR Bcc, LPCSTR From, LPCSTR Subject, LPCSTR Body, LPCSTR Header, LPCSTR Path, int Flag, int PortNo, int SslFlag, LPCSTR Name);
int WINAPI NMailSmtpSendMailSslW(LPCWSTR HostName, LPCWSTR To, LPCWSTR Cc, LPCWSTR Bcc, LPCWSTR From, LPCWSTR Subject, LPCWSTR Body, LPCWSTR Header, LPCWSTR Path, int Flag, int PortNo, int SslFlag, LPCWSTR Name);
#ifdef _MBCS
#define NMailSmtpSendMailSsl	NMailSmtpSendMailSslA
#endif
#ifdef _UNICODE
#define NMailSmtpSendMailSsl	NMailSmtpSendMailSslW
#endif

#ifdef __cplusplus
}
#endif

#endif
