using System;
using System.Text;
using System.Runtime.InteropServices;
using System.Collections;
using System.Collections.Specialized;
using System.Net.Sockets;
using System.IO;
using System.Runtime.Serialization;

namespace nMail
{
	/// <summary>
	/// nMail.DLL G[ԂĂꍇɔO
	/// </summary>
	public class nMailException: ApplicationException, ISerializable
	{
		int _error_code;
		/// <summary>
		/// G[bZ[WƃG[R[hw肵āA<c>nMailException</c>NX̐VCX^X܂B
		/// </summary>
		/// <param name="message"></param>
		/// <param name="error_code"></param>
		public nMailException(string message, int error_code): base(message)
		{
			this._error_code = error_code;
		}
		/// <summary>
		/// VAf[^w肵āA<c>nMailException</c>NX̐VCX^X܂B
		/// </summary>
		/// <param name="info"></param>
		/// <param name="context"></param>
		public nMailException(SerializationInfo info, StreamingContext context): base(info, context)
		{
			_error_code = info.GetInt32("ErrorCode");
		}
		/// <summary>
		/// G[R[hłBl nMail.chm  QA ̃G[R[hꗗQƂĂ݂ĂB
		/// </summary>
		public int ErrorCode
		{
			get
			{
				return _error_code;
			}
		}
		/// <summary>
		/// T[o[ԂꂽG[bZ[WłB
		/// </summary>
		public override string Message
		{
			get
			{
				return base.Message;
			}
		}
		/// <summary>
		/// OɊւgp SerializationInfo ݒ肵܂B
		/// </summary>
		/// <param name="info"></param>
		/// <param name="context"></param>
		public override void GetObjectData(SerializationInfo info, StreamingContext context)
		{
			base.GetObjectData(info, context);
			info.AddValue("ErrorCode", _error_code);
		}
	}

	/// <summary>
	/// Winsock ֘ANX
	/// </summary>
	public class Winsock
	{
		/// <summary>
		/// <c>Winsock</c>NX̐VKCX^X܂B
		/// </summary>
		public Winsock()
		{
		}
		/// <summary>
		/// Winsock ܂B
		/// </summary>
		[DllImport("nMail.DLL", EntryPoint="NMailInitializeWinSock")]
		public static extern bool Initialize();

		/// <summary>
		/// Winsock ̎gpI܂B
		/// </summary>
		[DllImport("nMail.DLL", EntryPoint="NMailEndWinSock")]
		public static extern bool Done();
	}
	/// <summary>
	/// POP3[MNX
	/// </summary>
	/// <remarks>
	/// <example>
	/// <para>
	/// w̃[ԍ(ϐ:no)擾AƖ{\B
	/// ق Attachment NXœYtt@CWJꍇ text/html p[gt@CɕۑꍇA
	/// <see cref="Options.DisableDecodeBodyText()"/>  <see cref="Options.DisableDecodeBodyAll()"/>Ăł<see cref="GetMail"/>Ŏ擾wb_і{f[^gpKv܂B
	/// <code lang="cs">
	///	using(nMail.Pop3 pop = new nMail.Pop3("mail.example.com")) {
	///		try {
	///			pop.Connect();
	///			pop.Authenticate("pop3_id", "password");
	///			pop.GetMail(no);
	///			MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}\r\n{2:s}", no, pop.Subject, pop.Body));
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	/// Dim pop As nMail.Pop3 = New nMail.Pop3("mail.example.com")
	/// Try
	/// 	pop.Connect()
	/// 	pop.Authenticate("pop3_id", "password")
	///		pop.GetMail(no)
	///		MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}" + ControlChars.CrLf + "{2:s}", no, pop.Subject, pop.Body))
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		pop.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// <para>
	/// SSL Version 3 gpAw̃[ԍ(ϐ:no)擾AƖ{\B
	/// <code lang="cs">
	///	using(nMail.Pop3 pop = new nMail.Pop3("mail.example.com")) {
	///		try {
	///			pop.SSL = nMail.Pop3.SSL3;
	///			pop.Connect(nMail.Pop3.StandardSslPortNo);		// over SSL/TLS ̃|[gԍw肵Đڑ
	///			pop.Authenticate("pop3_id", "password");
	///			pop.GetMail(no);
	///			MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}\r\n{2:s}", no, pop.Subject, pop.Body));
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	/// Dim pop As nMail.Pop3 = New nMail.Pop3("mail.example.com")
	/// Try
	/// 	pop.SSL = nMail.Pop3.SSL3
	/// 	pop.Connect(nMail.Pop3.StandardSslPortNo)		' over SSL/TLS ̃|[gԍw肵Đڑ
	/// 	pop.Authenticate("pop3_id", "password")
	///		pop.GetMail(no)
	///		MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}" + ControlChars.CrLf + "{2:s}", no, pop.Subject, pop.Body))
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		pop.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// <para>
	/// w̃[ԍ(ϐ:no)擾AƖ{\BYtt@C z:\temp ɕۑB
	/// text/html p[gt@CɕۑꍇA<see cref="GetMail"/> ̑O <see cref="Options.EnableSaveHtmlFile()"/> ĂłKv܂B
	/// ۑ text/html p[g̃t@C <see cref="HtmlFile"/> Ŏ擾ł܂B
	/// <code lang="cs">
	///	using(nMail.Pop3 pop = new nMail.Pop3("mail.example.com")) {
	///		try {
	///			pop.Connect();
	///			pop.Authenticate("pop3_id", "password");
	///			pop.Path = @"z:\temp";
	///			pop.GetMail(no);
	///			MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}\r\n{2:s}", no, pop.Subject, pop.Body));
	///			string [] file_list = pop.GetFileNameList();
	///			if(file_list.Length == 0)
	///			{
	///				MessageBox.Show("t@C͂܂");
	///			}
	///			else
	///			{
	///				foreach(string name in file_list)
	///				{
	///					MessageBox.Show(String.Format("Ytt@C:{0:s}", name));
	///				}
	///			}
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	/// Dim pop As nMail.Pop3 = New nMail.Pop3("mail.example.com")
	/// Try
	/// 	pop.Connect()
	/// 	pop.Authenticate("pop3_id", "password")
	///		pop.Path = "z:\temp"
	///		pop.GetMail(no)
	///		MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}" + ControlChars.CrLf + "{2:s}", no, pop.Subject, pop.Body))
	///		Dim file_list As String() = pop.GetFileNameList()
	///		If file_list.Length = 0 Then
	///			MessageBox.Show("t@C͂܂")
	///		Else
	///			For Each name As String In file_list
	///				MessageBox.Show(String.Format("Ytt@C:{0:s}", name))
	///			Next fno
	///		End If
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		pop.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// <para>
	///	ꎞx~@\gĎw̃[ԍ(ϐ:no)擾AƖ{\BYtt@C z:\temp ɕۑB
	/// <code lang="cs">
	///	using(nMail.Pop3 pop = new nMail.Pop3("mail.example.com")) {
	///		try {
	///			pop.Connect();
	///			pop.Authenticate("pop3_id", "password");
	///			// ̋x~񐔂𓾂
	///			int count = pop.GetSize(no) / (nMail.Options.SuspendSize * 1024) + 1;
	///			pop.Path = @"z:\temp";
	///			pop.GetMail(no);
	///			pop.Flag = nMail.Pop3.SuspendAttachmentFile;
	///			pop.GetMail(no);
	///			pop.Flag = nMail.Pop3.SuspendNext;
	///			while(pop.ErrorCode == nMail.Pop3.ErrorSuspendAttachmentFile)
	///			{
	///				pop.GetMail(no);
	///				// vOXo[i߂铙̏
	///				Application.DoEvents();
	///			}
	///			MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}\r\n{2:s}", no, pop.Subject, pop.Body));
	///			string [] file_list = pop.GetFileNameList();
	///			if(file_list.Length == 0)
	///			{
	///				MessageBox.Show("t@C͂܂");
	///			}
	///			else
	///			{
	///				foreach(string name in file_list)
	///				{
	///					MessageBox.Show(String.Format("Ytt@C:{0:s}", name));
	///				}
	///			}
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	///	Dim pop As nMail.Pop3 = New nMail.Pop3("mail.example.com")
	///	Try
	///		Dim count As Integer
	///
	///		pop.Connect()
	///		pop.Authenticate("pop3_id", "password")
	///		' ̋x~񐔂𓾂
	///		count = pop.GetSize(no) \ (nMail.Options.SuspendSize * 1024) + 1
	///		pop.Path = "z:\temp"
	///		pop.Flag = nMail.Pop3.SuspendAttachmentFile
	///		pop.GetMail(no)
	///		pop.Flag = nMail.Pop3.SuspendNext
	///		Do While pop.ErrorCode = nMail.Pop3.ErrorSuspendAttachmentFile
	///			pop.GetMail(no)
	///			' vOXo[i߂铙̏
	///			Application.DoEvents()
	///		Loop
	///		MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}" + ControlChars.CrLf + "{2:s}", no, pop.Subject, pop.Body))
	///		Dim file_list As String() = pop.GetFileNameList()
	///		If file_list.Length = 0 Then
	///			MessageBox.Show("t@C͂܂")
	///		Else
	///			For Each name As String In file_list
	///				MessageBox.Show(String.Format("Ytt@C:{0:s}", name))
	///			Next fno
	///		End If
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		pop.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// </example>
	/// </remarks>
	public class Pop3 : IDisposable
	{
		/// <summary>
		/// wb_̈̃TCYłB
		/// </summary>
		protected const int HeaderSize = 32768;
		/// <summary>
		/// pX̃TCYłB
		/// </summary>
		protected const int MaxPath = 32768;
		/// <summary>
		/// g@\pobt@TCYłB
		/// </summary>
		protected const int AttachmentTempSize = 400;
		/// <summary>
		/// \PbgG[͖ڑԂłBl -1 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="Connect"/>Ăяo<see cref="GetMail"/>A</para>
		/// <para>ĂяoAȂ炩̗RŐڑؒfƂ̃G[ƂȂ܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorSocket = -1;
		/// <summary>
		/// F؃G[łBl -2 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="Authenticate"/>ĂяoŔF؂Ɏsꍇ</para>
		/// <para>̃G[ƂȂ܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorAuthenticate = -2;
		/// <summary>
		/// ԍŎw肳ꂽ[݂܂Bl -3 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetMail"/>Ŏw肵ԍ̃[݂ȂƂ̃G[ƂȂ܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorInvalidNo = -3;
		/// <summary>
		/// ^CAEgG[łBl -4 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="Options.Timeout"/>Ŏw肵l蒷ԃT[o牞</para>
		/// <para>ȂꍇÃG[܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorTimeout = -4;
		/// <summary>
		/// Ytt@CJ܂Bl -5 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="Path"/>Ŏw肵tH_ɓYtt@C߂Ȃ</para>
		/// <para>ȂꍇÃG[܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorFileOpen = -5;
		/// <summary>
		/// t@CĂ܂Bl -6 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="Flag"/><see cref="PartialAttachmentFile"/> ݒ肵</para>
		/// <para><see cref="GetMail"/>ĂяoۂɁAT[oɕꂽ[ׂ</para>
		/// <para>ĂȂꍇɂ̃G[܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorPartial = -6;
		/// <summary>
		/// Ytt@CƓ̃t@CtH_ɑ݂܂Bl -7 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="nMail.Options.AlreadyFile"/>  <see cref="nMail.Options.FileAlreadyError"/></para>
		/// <para>ݒ肵A<see cref="Path"/>Ŏw肵tH_ɓYtt@CƓÕt@C</para>
		/// <para>ꍇɂ̃G[܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorFileAlready = -7;
		/// <summary>
		/// mۃG[łBl -9 łB
		/// </summary>
		/// <remarks>
		/// ŕR[hϊ邽߂̃mۂł܂łB
		/// </remarks>
		public const int ErrorMemory = -9;
		/// <summary>
		/// ̑̃G[łBl -10 łB
		/// </summary>
		public const int ErrorEtc = -10;
		/// <summary>
		/// Ytt@CMł܂c肪ԂłBl -20 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="Flag"/><see cref="SuspendAttachmentFile"/>܂</para>
		/// <para><see cref="SuspendNext"/>w肵<see cref="GetMail"/></para>
		/// <para>ĂяoꍇA܂[̎c肪ꍇA<see cref="nMailException.ErrorCode"/></para>
		/// <para>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorSuspendAttachmentFile = -20;
		/// <summary>
		/// Ytt@C݂͑܂B
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetAttachmentFileStatus"/> sAYtt@C݂Ȃꍇ</para>
		/// <para><see cref="PartNo"/> ɐݒ肳܂B</para>
		/// </remarks>
		public const int NoAttachmentFile = -1;
		/// <summary>
		/// Ytt@C݂͑܂AĂ܂B
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetAttachmentFileStatus"/> sAYtt@C݂Ȃꍇ</para>
		/// <para><see cref="PartNo"/> ɐݒ肳܂B</para>
		/// </remarks>
		public const int AttachmentFile = 0;
		/// <summary>
		/// sɐ܂Bl 1 łB
		/// </summary>
		/// <para>e탁\bhԂꍇA<see cref="nMailException.ErrorCode"/>ɐݒ肳lłB</para>
		public const int Success = 1;
		/// <summary>
		/// ꂽYtt@C擾܂B
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		/// </remarks>
		public const int PartialAttachmentFile = 1;
		/// <summary>
		/// [{̂ݎ擾܂B
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		/// </remarks>
		public const int TextOnly = 2;
		/// <summary>
		/// Ytt@CMňꎞx~̈ڂɎw肵܂B
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		/// </remarks>
		public const int SuspendAttachmentFile = 4;
		/// <summary>
		/// Ytt@CMňꎞx~̓ڈȍ~Ɏw肵܂B
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		/// </remarks>
		public const int SuspendNext = 8;
		/// <summary>
		/// UIDL ׂĎ擾܂B
		/// </summary>
		/// <remarks>
		/// <see cref="GetUidl"/>Ŏw肷邱ƂɂđSĂ UIDL 擾ł܂B
		/// </remarks>
		public const int UidlAll = 0;
		/// <summary>
		/// SSLv3 gp܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int SSL3 = 0x1000;
		/// <summary>
		/// TSLv1 gp܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int TLS1 = 0x2000;
		/// <summary>
		/// STARTTLS gp܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int STARTTLS = 0x4000;
		/// <summary>
		/// T[oؖ؂łG[ɂ܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int IgnoreNotTimeValid = 0x0800;
		/// <summary>
		/// [gؖłG[ɂ܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int AllowUnknownCA = 0x0400;
		/// <summary>
		/// POP3 ̕W|[gԍł
		/// </summary>
		public const int StandardPortNo = 110;
		/// <summary>
		/// POP3 over SSL ̃|[gԍł
		/// </summary>
		public const int StandardSslPortNo = 995;

		/// <summary>
		/// POP3 |[gԍłB
		/// </summary>
		protected int _port = 110;
		/// <summary>
		/// \PbgnhłB
		/// </summary>
		protected IntPtr _socket = (IntPtr)ErrorSocket;
		/// <summary>
		/// [łB
		/// </summary>
		protected int _count = -1;
		/// <summary>
		/// [TCYłB
		/// </summary>
		protected int _size = -1;
		/// <summary>
		/// wb_[TCYłB
		/// </summary>
		protected int _header_size = -1;
		/// <summary>
		/// {̃TCYłB
		/// </summary>
		protected int _body_size = -1;
		/// <summary>
		/// [M̐ݒptOłB
		/// </summary>
		protected int _flag = 0;
		/// <summary>
		/// t@CԍłB
		/// </summary>
		protected int _part_no = -1;
		/// <summary>
		/// G[ԍłB
		/// </summary>
		protected int _err = 0;
		/// <summary>
		/// APOP gp邩ǂ̃tOłB
		/// </summary>
		protected bool _apop = false;
		/// <summary>
		/// POP3 T[ołB
		/// </summary>
		protected string _host = "";
		/// <summary>
		/// POP3 [U[łB
		/// </summary>
		protected string _id = "";
		/// <summary>
		/// POP3 pX[hłB
		/// </summary>
		protected string _password = "";
		/// <summary>
		/// Ytt@Cۑp̃pXłB
		/// </summary>
		protected string _path = null;
		/// <summary>
		/// wb_tB[hłB
		/// </summary>
		protected string _field_name = "";
		/// <summary>
		/// {i[obt@łB
		/// </summary>
		protected StringBuilder _body = null;
		/// <summary>
		/// i[obt@łB
		/// </summary>
		protected StringBuilder _subject = null;
		/// <summary>
		/// tۑobt@łB
		/// </summary>
		protected StringBuilder _date = null;
		/// <summary>
		/// oli[obt@łB
		/// </summary>
		protected StringBuilder _from = null;
		/// <summary>
		/// wb_i[obt@łB
		/// </summary>
		protected StringBuilder _header = null;
		/// <summary>
		/// Ytt@Ci[obt@łB
		/// </summary>
		protected StringBuilder _filename = null;
		/// <summary>
		/// Ytt@C̃XgłB
		/// </summary>
		protected string[] _filename_list = null;
		/// <summary>
		/// wb_tB[hei[obt@łB
		/// </summary>
		protected StringBuilder _field = null;
		/// <summary>
		/// t@C ID łB
		/// </summary>
		protected StringBuilder _part_id = null;
		/// <summary>
		/// UIDL i[obt@łB
		/// </summary>
		protected StringBuilder _uidl = null;
		/// <summary>
		/// g@\pobt@łB
		/// </summary>
		protected byte[] _temp = null;
		/// <summary>
		/// Dispose sǂ̃tOłB
		/// </summary>
		private bool _disposed = false;
		/// <summary>
		/// text/html p[gۑt@C̖OłB
		/// </summary>
		protected StringBuilder _html_file = null;
		/// <summary>
		/// SSL ݒtOłB
		/// </summary>
		protected int _ssl = 0;
		/// <summary>
		/// SSL NCAgؖłB
		/// </summary>
		protected string _cert_name = null;
		/// <summary>
		/// message/rfc822 p[gۑt@C̖OłB
		/// </summary>
		protected StringBuilder _rfc822_file = null;

		/// <summary>
		/// <c>Pop3</c>NX̐VKCX^X܂B
		/// </summary>
		public Pop3()
		{
			Init();
		}
		/// <summary>
		/// <c>Pop3</c>NX̐VKCX^X܂B
		/// <param name="host_name">POP3 T[o[</param>
		/// </summary>
		public Pop3(string host_name)
		{
			Init();
			_host = host_name;
		}
		/// <summary>
		/// 
		/// </summary>
		~Pop3()
		{
			Dispose(false);
		}
		/// <summary>
		/// <see cref="Pop3"/>ɂĎgpĂ邷ׂẴ\[X܂B
		/// </summary>
		public void Dispose()
		{
			Dispose(true);
			GC.SuppressFinalize(this);
		}
		/// <summary>
		/// <see cref="Pop3"/>ɂĎgpĂ邷ׂẴ\[X܂B
		/// </summary>
		/// <param name="disposing">
		/// }l[W\[XƃA}l[W\[X̗ꍇ<c>true</c>B
		/// A}l[W\[Xꍇ<c>false</c>B
		/// </param>
		protected virtual void Dispose(bool disposing)
		{
			if(!_disposed) {
				if(disposing)
				{
				}
				if(_socket != (IntPtr)ErrorSocket) {
					Pop3Close(_socket);
					_socket = (IntPtr)ErrorSocket;
				}
				_disposed = true;
			}
		}
		/// <summary>
		/// łB
		/// </summary>
		protected void Init()
		{
			_temp = new byte[AttachmentTempSize];
		}

		[DllImport("nMail.DLL", EntryPoint="NMailPop3ConnectPortNo", CharSet=CharSet.Auto)]
		protected static extern IntPtr Pop3ConnectPortNo(string Host, int Port);

		[DllImport("nMail.DLL", EntryPoint="NMailPop3ConnectSsl", CharSet=CharSet.Auto)]
		protected static extern IntPtr Pop3ConnectSsl(string Host, int Port, int Flag, string Name);

		[DllImport("nMail.DLL", EntryPoint="NMailPop3Close")]
		protected static extern int Pop3Close(IntPtr Socket);

		[DllImport("nMail.DLL", EntryPoint="NMailPop3Authenticate", CharSet=CharSet.Auto)]
		protected static extern int Pop3Authenticate(IntPtr Socket, string Id, string Pass, bool APopFlag);

		[DllImport("nMail.DLL", EntryPoint="NMailPop3GetMailStatus", CharSet=CharSet.Auto)]
		protected static extern int Pop3GetMailStatus(IntPtr Socket, int No, StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, bool SizeFlag);

		[DllImport("nMail.DLL", EntryPoint="NMailPop3GetMailSize")]
		protected static extern int Pop3GetMailSize(IntPtr Socket, int No);

		[DllImport("nMail.DLL", EntryPoint="NMailPop3GetMail", CharSet=CharSet.Auto)]
		protected static extern int Pop3GetMail(IntPtr Socket, int No, StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, StringBuilder Body, string Path, StringBuilder FileName);

		[DllImport("nMail.DLL", EntryPoint="NMailPop3GetMailEx", CharSet=CharSet.Auto)]
		protected static extern int Pop3GetMailEx(IntPtr Socket, int No, StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, StringBuilder Body, string Path, StringBuilder FileName, byte[] Temp, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailPop3DeleteMail")]
		protected static extern int Pop3DeleteMail(IntPtr Socket, int No);

		[DllImport("nMail.DLL", EntryPoint="NMailGetHeaderField", CharSet=CharSet.Auto)]
		protected static extern int Pop3GetHeaderField(StringBuilder Field, string Header, string Name, int Size);

		[DllImport("nMail.DLL", EntryPoint="NMailPop3GetUidl", CharSet=CharSet.Auto)]
		protected static extern int Pop3GetUidl(IntPtr Socket, int No, StringBuilder Id, int Max);

		[DllImport("nMail.DLL", EntryPoint="NMailPop3GetAttachmentFileStatus", CharSet=CharSet.Auto)]
		protected static extern int Pop3GetAttachmentFileStatus(IntPtr Socket, int No, StringBuilder Id, int Max);

		[DllImport("nMail.DLL", EntryPoint="NMailDecodeHeaderField", CharSet=CharSet.Auto)]
		protected static extern int Pop3DecodeHeaderField(StringBuilder Destination, string Source, int Size);

		/// <summary>
		/// wb_i[pobt@̃TCY肵܂B
		/// </summary>
		protected void SetHeaderSize()
		{
			if(_header_size < 0)
			{
				_header_size = Options.HeaderMax;
			}
			if(_header_size <= 0)
			{
				_header_size = HeaderSize;
				Options.HeaderMax = _header_size;
			}
		}
		/// <summary>
		/// POP3 T[oɐڑ܂B
		/// </summary>
		/// <remarks>
		/// POP3 T[oɐڑ܂B
		/// </remarks>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	POP T[o[Ƃ̐ڑɎs܂B
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect()
		{
			if(_port < 0 || _port > 65536) {
				throw new ArgumentOutOfRangeException();
			}
			//_socket = Pop3ConnectPortNo(_host, _port);
			_socket = Pop3ConnectSsl(_host, _port, _ssl, _cert_name);
			if(_socket == (IntPtr)ErrorSocket)
			{
				_err = ErrorSocket;
				_socket = (IntPtr)ErrorSocket;
				throw new nMailException("Connect", _err);
			}
		}
		/// <summary>
		/// POP3 T[oɐڑ܂B
		/// </summary>
		/// <param name="host_name">POP3 T[o[</param>
		/// <remarks>
		/// POP3 T[oɐڑ܂B
		/// </remarks>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	POP T[oƂ̐ڑɎs܂B
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect(string host_name)
		{
			_host = host_name;
			Connect();
		}
		/// <summary>
		/// POP3 T[oɐڑ܂B
		/// </summary>
		/// <param name="host_name">POP3 T[o</param>
		/// <param name="port_no">|[gԍ</param>
		/// <remarks>
		/// POP3 T[oɐڑ܂B
		/// </remarks>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	POP T[oƂ̐ڑɎs܂B
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect(string host_name, int port_no)
		{
			_host = host_name;
			_port = port_no;
			Connect();
		}
		/// <summary>
		/// POP3 T[oɐڑ܂B
		/// </summary>
		/// <param name="port_no">|[gԍ</param>
		/// <remarks>
		/// POP3 T[oɐڑ܂B
		/// </remarks>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	POP T[oƂ̐ڑɎs܂B
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect(int port_no)
		{
			_port = port_no;
			Connect();
		}
		/// <summary>
		/// POP3 T[oƂ̐ڑI܂B
		/// </summary>
		public void Close()
		{
			if(_socket != (IntPtr)ErrorSocket) {
				Pop3Close(_socket);
			}
			_socket = (IntPtr)ErrorSocket;
		}
		/// <summary>
		/// POP3 T[oF؂s܂B
		/// </summary>
		/// <remarks>
		/// POP3 T[oF؂s܂B
		/// </remarks>
		/// <param name="id_str">POP3 [U[ ID</param>
		/// <param name="pass_str">POP3 pX[h</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="FormatException">
		///	ID ̓pX[hɕ񂪓Ă܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Authenticate(string id_str, string pass_str)
		{
			if(id_str == "" || pass_str == "") {
				throw new FormatException();
			}
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_id = id_str;
			_password = pass_str;
			_body_size = -1;
			_count = Pop3Authenticate(_socket, _id, _password, _apop);
			if(_count < 0)
			{
				_err = _count;
				throw new nMailException("Authenticate: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// POP3 T[oF؂s܂B
		/// </summary>
		/// <remarks>
		/// POP3 T[oF؂s܂B
		/// </remarks>
		/// <param name="id_str">POP3 [U[ ID</param>
		/// <param name="pass_str">POP3 pX[h</param>
		/// <param name="apop_flag">APOP gp邩</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="FormatException">
		///	ID ̓pX[hɕ񂪓Ă܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Authenticate(string id_str, string pass_str, bool apop_flag)
		{
			_apop = apop_flag;
			Authenticate(id_str, pass_str);
		}

		/// <summary>
		/// [̃Xe[^X擾܂B
		/// </summary>
		/// <param name="no">[ԍ</param>
		/// <remarks>
		/// <paramref name="no"/>p[^ŃXe[^X擾[ԍw肵܂B
		/// <para><see cref="Subject"/>Ŏ擾ł܂B</para>
		/// <para>t<see cref="DateString"/>Ŏ擾ł܂B</para>
		/// <para>ol<see cref="From"/>Ŏ擾ł܂B</para>
		/// <para>wb_<see cref="Header"/>Ŏ擾ł܂B</para>
		/// <para>Xe[^X擾s̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="ArgumentOutOfRangeException">
		///	[ԍ܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void GetStatus(int no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			if(no <= 0) {
				throw new ArgumentOutOfRangeException();
			}
			SetHeaderSize();
			_subject = new StringBuilder(_header_size);
			_date = new StringBuilder(_header_size);
			_from = new StringBuilder(_header_size);
			_header = new StringBuilder(_header_size);
			_err = Pop3GetMailStatus(_socket, no, _subject, _date, _from, _header, false);
			if(_err < 0)
			{
				throw new nMailException("GetStatus: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// [̃TCY擾܂B
		/// </summary>
		/// <param name="no">[ԍ</param>
		/// <remarks>
		/// <paramref name="no"/>p[^Ń[TCY擾[ԍw肵܂B
		/// <example>
		/// <para>
		/// [ԍ(ϐ:no)̃[TCY擾B
		/// <code lang="cs">
		///	using(nMail.Pop3 pop = new nMail.Pop3("mail.example.com")) {
		///		try {
		///			pop.Connect();
		/// 		pop.Authenticate("pop3_id", "password");
		///			pop.GetSize(no);
		///			MessageBox.Show(String.Format("[ԍ:{0:d},TCY:{1:d}", no, pop.Size));
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		/// Dim pop As nMail.Pop3 = New nMail.Pop3("mail.example.com")
		/// Try
		/// 	pop.Connect()
		/// 	pop.Authenticate("pop3_id", "password")
		///		pop.GetMail(no)
		///		MessageBox.Show(String.Format("[ԍ:{0:d},TCY:{1:d}", no, pop.Size))
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		pop.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="ArgumentOutOfRangeException">
		///	[ԍ܂B
		/// </exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		/// <returns>[TCY</returns>
		public int GetSize(int no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			if(no <= 0) {
				throw new ArgumentOutOfRangeException();
			}
			_size = Pop3GetMailSize(_socket, no);
			if(_size < 0) {
				_err = _size;
				throw new nMailException("GetSize: " + Options.ErrorMessage, _err);
			} else {
				_body_size = _size * 2;
			}
			return _size;
		}

		/// <summary>
		/// [擾܂B
		/// </summary>
		/// <param name="no">[ԍ</param>
		/// <remarks>
		/// <paramref name="no"/>p[^Ń[擾[ԍw肵܂B
		/// <para>Ytt@CۑꍇA<see cref="Path"/>ɕۑtH_w肵Ă܂B</para>
		/// <para>g@\gpꍇA<see cref="Flag"/>Őݒ肵Ă܂B</para>
		/// <para><see cref="Subject"/>Ŏ擾ł܂B</para>
		/// <para>t<see cref="DateString"/>Ŏ擾ł܂B</para>
		/// <para>ol<see cref="From"/>Ŏ擾ł܂B</para>
		/// <para>wb_<see cref="Header"/>Ŏ擾ł܂B</para>
		/// <para>[TCY<see cref="Size"/>Ŏ擾ł܂B</para>
		/// <para>Ytt@C<see cref="FileName"/>Ŏ擾ł܂B</para>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <exception cref="DirectoryNotFoundException">
		///	<see cref="Path"/>Ŏw肵tH_݂܂B
		/// </exception>
		///	<exception cref="ArgumentOutOfRangeException">
		///	[ԍ܂B
		/// </exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void GetMail(int no)
		{
			if(_socket == (IntPtr)ErrorSocket)
			{
				throw new InvalidOperationException();
			}
			if(_path != null)
			{
				if(_path != "" && !Directory.Exists(_path))
				{
					throw new DirectoryNotFoundException(_path);
				}
			}
			if(no <= 0) {
				throw new ArgumentOutOfRangeException();
			}
			if((_flag & SuspendNext) != 0) {
				_err = Pop3GetMailEx(_socket, no, _subject, _date, _from, _header, _body, _path, _filename, _temp, _flag);
			} else {
				SetHeaderSize();
				_subject = new StringBuilder(_header_size);
				_date = new StringBuilder(_header_size);
				_from = new StringBuilder(_header_size);
				_header = new StringBuilder(_header_size);
				Options.FileNameMax = MaxPath;
				_filename = new StringBuilder(MaxPath);
				if(_body_size < 0)
				{
					GetSize(no);
				}
				if(_body_size > 0)
				{
					_body = new StringBuilder(_body_size);
					if(_flag != 0) {
						_err = Pop3GetMailEx(_socket, no, _subject, _date, _from, _header, _body, _path, _filename, _temp, _flag);
					}
					else
					{
						_err = Pop3GetMail(_socket, no, _subject, _date, _from, _header, _body, _path, _filename);
					}
				}
			}
			if(_err != ErrorSuspendAttachmentFile)
			{
				_body_size = -1;
				if(_filename.Length > 0) 
				{
					_filename_list = _filename.ToString().Split(Options.SplitChar);
				} 
				else 
				{
					_filename_list = null;
				}
				if(Options.SaveHtmlFile == Options.SaveHtmlFileOn) {
					GetHeaderField("X-NMAIL-HTML-FILE:");
					_html_file = _field;
				}
				if(Options.SaveRfc822File != Options.SaveRfc822FileOff) {
					GetHeaderField("X-NMAIL-RFC822-FILE:");
					_rfc822_file = _field;
				}
			}
			if(_err < 0 && _err != ErrorSuspendAttachmentFile) {
				throw new nMailException("GetMail: " + Options.ErrorMessage, _err);
			} 
		}
		/// <summary>
		/// [폜܂B
		/// </summary>
		/// <param name="no">[ԍ</param>
		/// <remarks>
		/// <para>[폜s̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
		/// <example>
		/// <para>
		/// w̃[ԍ(ϐ:no)폜B
		/// <code lang="cs">
		///	using(nMail.Pop3 pop = new nMail.Pop3("mail.example.com")) {
		///		try {
		///			pop.Connect();
		/// 		pop.Authenticate("pop3_id", "password");
		///			pop.Delete(no);
		///			MessageBox.Show(String.Format("[ԍ:{0:d}폜", no));
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		/// Dim pop As nMail.Pop3 = New nMail.Pop3("mail.example.com")
		/// Try
		/// 	pop.Connect()
		/// 	pop.Authenticate("pop3_id", "password")
		///		pop.Delete(no)
		///		MessageBox.Show(String.Format("[ԍ:{0:d}폜", no))
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		pop.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="ArgumentOutOfRangeException">
		///	[ԍ܂B
		/// </exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Delete(int no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			if(no <= 0) {
				throw new ArgumentOutOfRangeException();
			}
			_err = Pop3DeleteMail(_socket, no);
			if(_err < 0)
			{
				throw new nMailException("Delete: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// Ytt@C̑݃`FbNs܂B
		/// </summary>
		/// <param name="no">[ԍ</param>
		/// <remarks>
		/// <para>Ytt@C̕<see cref="PartNo"/>Ŏ擾ł܂B</para>
		/// <para><see cref="NoAttachmentFile"/>̏ꍇYtt@C͂܂B</para>
		/// <para><see cref="AttachmentFile"/>̏ꍇĂȂYtt@Ct[łB</para>
		/// <para>1 ȏ̏ꍇĂYtt@CŕԂl̓p[gԍ\܂B</para>
		/// <para>1 ̏ꍇ́A<see cref="Flag"/><see cref="PartialAttachmentFile"/> ݒ肵
		/// <see cref="GetMail"/>ĂяoƓYtt@Cĕۑ\łB</para>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="ArgumentOutOfRangeException">
		///	[ԍ܂B
		/// </exception>
		/// <returns>true œYtt@C</returns>
		public bool GetAttachmentFileStatus(int no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			if(no <= 0) {
				throw new ArgumentOutOfRangeException();
			}
			SetHeaderSize();
			_part_id = new StringBuilder(_header_size);
			_part_no = Pop3GetAttachmentFileStatus(_socket, no, _part_id, _header_size);
			if(_part_no > 0)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		/// <summary>
		/// [ UIDL 擾܂B
		/// </summary>
		/// <param name="no">[ԍ</param>
		/// <remarks>
		/// <para>擾 UIDL <see cref="Uidl"/>Ŏ擾ł܂B</para>
		/// <para><paramref name="no"/><see cref="UidlAll"/>w肷ƁA
		/// POP3 T[oɂ邷ׂẴ[ UIDL 擾܂B</para>
		/// <example>
		/// <para>
		/// w̃[ԍ(ϐ:no) UIDL 擾B
		///	<code lang="cs">
		///	using(nMail.Pop3 pop = new nMail.Pop3("mail.example.com")) {
		///		try {
		///			pop.Connect();
		/// 		pop.Authenticate("pop3_id", "password");
		///			pop.GetUidl(no);
		///			MessageBox.Show("Uidl=" + pop.Uidl);
		/// 	}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		/// Dim pop As nMail.Pop3 = New nMail.Pop3("mail.example.com")
		/// Try
		/// 	pop.Connect()
		/// 	pop.Authenticate("pop3_id", "password")
		///		pop.GetUidl(no)
		///		MessageBox.Show("Uidl=" + pop.Uidl)
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		pop.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void GetUidl(int no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			SetHeaderSize();
			_uidl = new StringBuilder(_header_size);
			_err = Pop3GetUidl(_socket, no, _uidl, _header_size);
			if(_err < 0)
			{
				throw new nMailException("GetUidl: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// [wb_w̃tB[h̓e擾܂B
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <returns>tB[h̓e</returns>
		/// <remarks>
		/// POP3 T[oƂ̐ڑƂ͖֌WɎgpł܂B
		/// <para>wb_́A<see cref="Header"/>Őݒ肵Ă܂B
		/// <see cref="GetMail"/>ŎMɌĂяoꍇA
		/// M[̃wb_gp܂B</para>
		/// <para>擾tB[he<see cref="Field"/>Ŏ擾ł܂B</para>
		/// <example>
		/// <para>
		/// w̃[ԍ(ϐ:no) X-Mailer wb_tB[h擾B
		///	<code lang="cs">
		///	using(nMail.Pop3 pop = new nMail.Pop3("mail.example.com")) {
		///		try {
		///			pop.Connect();
		/// 		pop.Authenticate("pop3_id", "password");
		///			pop.GetMail(no);
		///			MessageBox.Show("X-Mailer:" + pop.GetHeaderField("X-Mailer:"));
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception e)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		/// Dim pop As nMail.Pop3 = New nMail.Pop3("mail.example.com")
		///	Try
		/// 	pop.Connect()
		/// 	pop.Authenticate("pop3_id", "password")
		///		pop.GetMail(no)
		///		MessageBox.Show("X-Mailer:" + pop.GetHeaderField("X-Mailer:"))
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		pop.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		/// <returns>tB[h̓e</returns>
		public string GetHeaderField(string field_name)
		{
			_field_name = field_name;
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			_err = Pop3GetHeaderField(_field, _header.ToString(), _field_name, _header_size);
			if(_err < 0)
			{
				throw new nMailException("GetHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// [wb_w̃tB[h̓e擾܂B
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <param name="header">wb_</param>
		/// <returns>tB[h̓e</returns>
		public string GetHeaderField(string field_name, string header)
		{
			_field_name = field_name;
			_header = new StringBuilder(header);
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			_err = Pop3GetHeaderField(_field, _header.ToString(), _field_name, _header_size);
			if(_err < 0)
			{
				throw new nMailException("GetHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// MIME wb_tB[h̕fR[h܂
		/// </summary>
		/// <param name="field">tB[h̕</param>
		/// <returns>fR[htB[he</returns>
		public string DecodeHeaderField(string field)
		{
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			_err = Pop3DecodeHeaderField(_field, field, _header_size);
			if(_err < 0)
			{
				throw new nMailException("DecodeHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// [wb_w̃wb_tB[h̓e擾A
		/// MIME wb_tB[h̃fR[hsĕԂ܂
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <returns>擾fR[hς݂̃tB[he</returns>
		public string GetDecodeHeaderField(string field_name)
		{
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			String src = GetHeaderField(field_name, _header.ToString());
			_err = Pop3DecodeHeaderField(_field, src, _header_size);
			if(_err < 0)
			{
				throw new nMailException("DecodeHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// [wb_w̃wb_tB[h̓e擾A
		/// MIME wb_tB[h̃fR[hsĕԂ܂
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <param name="header">wb_</param>
		/// <returns>擾fR[hς݂̃tB[he</returns>
		public string GetDecodeHeaderField(string field_name, string header)
		{
			SetHeaderSize();
			_err = Pop3DecodeHeaderField(_field, GetHeaderField(field_name, header), _header_size);
			if(_err < 0)
			{
				throw new nMailException("DecodeHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// Ytt@C̔złB
		/// </summary>
		/// <returns>Ytt@C̔z</returns>
		public string[] GetFileNameList()
		{
			if(_filename_list == null)
			{
				return new string[0];
			}
			else
			{
				return (string[])_filename_list.Clone();
			}
		}

		/// <summary>
		/// POP3 |[gԍłB
		/// </summary>
		/// <value>POP3 |[gԍ</value>
		public int Port {
			get
			{
				return _port;
			}
			set
			{
				_port = value;
			}
		}
		/// <summary>
		/// \PbgnhłB
		/// </summary>
		/// <value>\Pbgnh</value>
		public IntPtr Handle {
			get
			{
				return _socket;
			}
		}
		/// <summary>
		/// POP3 T[õ[łB
		/// </summary>
		/// <value>POP3 T[õ[</value>
		public int Count {
			get
			{
				return _count;
			}
		}
		/// <summary>
		/// [̃TCYłB
		/// </summary>
		/// <value>[̃TCY</value>
		public int Size {
			get
			{
				return _size;
			}
		}
		/// <summary>
		/// POP3 T[ołB
		/// </summary>
		/// <value>POP3 T[o</value>
		public string HostName
		{
			get
			{
				return _host;
			}
			set
			{
				_host = value;
			}
		}
		/// <summary>
		/// POP3 [U[łB
		/// </summary>
		/// <value>POP3 [U[</value>
		public string Id
		{
			get
			{
				return _id;
			}
			set
			{
				_id = value;
			}
		}
		/// <summary>
		/// POP3 pX[hłB
		/// </summary>
		/// <value>POP3 pX[h</value>
		public string Password
		{
			get
			{
				return _password;
			}
			set
			{
				_password = value;
			}
		}
		/// <summary>
		/// Ytt@CۑtH_łB
		/// </summary>
		/// <remarks>
		/// null (VB.Net  nothing) ̏ꍇۑ܂B
		/// </remarks>
		/// <value>Ytt@CۑtH_</value>
		public string Path
		{
			get
			{
				return _path;
			}
			set
			{
				_path = value;
			}
		}
		/// <summary>
		/// [̖{łB
		/// </summary>
		/// <value>[{</value>
		public string Body
		{
			get
			{
				if(_body == null)
				{
					return "";
				}
				else
				{
					return _body.ToString();
				}
			}
		}
		/// <summary>
		/// [̌łB
		/// </summary>
		/// <value>[̌</value>
		public string Subject
		{
			get
			{
				if(_subject == null)
				{
					return "";
				}
				else
				{
					return _subject.ToString();
				}
			}
		}
		/// <summary>
		/// [̑M̕łB
		/// </summary>
		/// <value>[M</value>
		public string DateString
		{
			get
			{
				if(_date == null)
				{
					return "";
				}
				else
				{
					return _date.ToString();
				}
			}
		}
		/// <summary>
		/// [̍olłB
		/// </summary>
		/// <value>[̍ol</value>
		public string From
		{
			get
			{
				if(_from == null)
				{
					return "";
				}
				else
				{
					return _from.ToString();
				}
			}
		}
		/// <summary>
		/// [̃wb_łB
		/// </summary>
		/// <value>[̃wb_</value>
		public string Header
		{
			get
			{
				if(_header == null)
				{
					return "";
				}
				else
				{
					return _header.ToString();
				}
			}
			set
			{
				_header = new StringBuilder(value);
			}
		}
		/// <summary>
		/// Ytt@CłB
		/// </summary>
		/// <remarks>
		/// ̓Ytt@CꍇA"," ŋ؂Ċi[܂B
		/// <see cref="Options.SplitChar"/>ŋ؂蕶ύXł܂B
		/// </remarks>
		/// <value>Ytt@C</value>
		public string FileName
		{
			get
			{
				if(_filename == null)
				{
					return "";
				}
				else
				{
					return _filename.ToString();
				}
			}
		}
		/// <summary>
		/// Ytt@C̔złB
		/// </summary>
		/// <remarks>
		/// ̃vpeB͌݊̂߂ɎcĂ܂B
		///	<see cref="GetFileNameList"/>Ŕz擾Ďgp悤ɂĂB
		/// </remarks>
		/// <value>Ytt@C</value>
		public string[] FileNameList
		{
			get
			{
				return _filename_list;
			}
		}
		/// <summary>
		/// wb_̃tB[hłB
		/// </summary>
		/// <value>wb_̃tB[h</value>
		public string FieldName
		{
			get
			{
				if(_field_name == null)
				{
					return "";
				}
				else
				{
					return _field_name;
				}
			}
		}
		/// <summary>
		/// wb_tB[h̓ełB
		/// </summary>
		/// <value>wb_tB[h̓e</value>
		public string Field
		{
			get
			{
				if(_field == null)
				{
					return "";
				}
				else
				{
					return _field.ToString();
				}
			}
		}
		/// <summary>
		/// Ytt@C̕łB
		/// </summary>
		/// <value>Ytt@C̕</value>
		public int PartNo
		{
			get
			{
				return _part_no;
			}
		}
		/// <summary>
		/// Ytt@C ID łB
		/// </summary>
		/// <value>Ytt@C ID</value>
		public string PartId
		{
			get
			{
				if(_part_id == null)
				{
					return "";
				}
				else
				{
					return _part_id.ToString();
				}
			}
		}
		/// <summary>
		/// [ UIDL łB
		/// </summary>
		/// <value>[ UIDL</value>
		public string Uidl
		{
			get
			{
				if(_uidl == null)
				{
					return "";
				}
				else
				{
					return _uidl.ToString();
				}
			}
		}
		/// <summary>
		/// APOP gp邩ǂ̃tOłB
		/// </summary>
		/// <remarks>
		/// true  APOP gp܂B
		/// </remarks>
		/// <value>APOP gp邩ǂ̃tO</value>
		public bool APop
		{
			get
			{
				return _apop;
			}
			set
			{
				_apop = value;
			}
		}
		/// <summary>
		/// [g@\wtOłB
		/// </summary>
		/// <remarks>
		/// <para><see cref="PartialAttachmentFile"/>ꂽYtt@C擾܂B</para>
		/// <para><see cref="TextOnly"/>[{̂ݎ擾܂B</para>
		/// <para><see cref="SuspendAttachmentFile"/>Ytt@CMňꎞx~̈ڂɎw肵܂B</para>
		/// <para><see cref="SuspendNext"/>Ytt@CMňꎞx~̓ڈȍ~Ɏw肵܂B</para>
		/// </remarks>
		public int Flag
		{
			get
			{
				return _flag;
			}
			set
			{
				_flag = value;
			}
		}
		/// <summary>
		/// G[ԍłB
		/// </summary>
		/// <value>G[ԍ</value>
		public int ErrorCode
		{
			get
			{
				return _err;
			}
		}
		/// <summary>
		/// text/html p[gۑt@C̖OłB
		/// </summary>
		/// <value>t@C</value>
		public string HtmlFile
		{
			get
			{
				if(_html_file == null)
				{
					return "";
				}
				else
				{
					return _html_file.ToString();
				}
			}
		}
		/// <summary>
		/// SSL ݒtOłB
		/// </summary>
		/// <value>SSL ݒtO</value>
		public int SSL {
			get
			{
				return _ssl;
			}
			set
			{
				_ssl = value;
			}
		}
		/// <summary>
		/// SSL NCAgؖłB
		/// </summary>
		/// <remarks>
		/// null ̏ꍇw肵܂B
		/// </remarks>
		/// <value>SSL NCAgؖ</value>
		public string CertName
		{
			get
			{
				return _cert_name;
			}
			set
			{
				_cert_name = value;
			}
		}
		/// <summary>
		/// message/rfc822 p[gۑt@C̖OłB
		/// </summary>
		/// <value>t@C</value>
		public string Rfc822File
		{
			get
			{
				if(_rfc822_file == null)
				{
					return "";
				}
				else
				{
					return _rfc822_file.ToString();
				}
			}
		}

	}

	/// <summary>
	/// SMTP [MNX
	/// </summary>
	/// <example>
	/// <para>
	/// [𑗐MB
	///	<code lang="cs">
	///	using(nMail.Smtp smtp = new nMail.Smtp("mail.example.com")) {
	///		try {
	///			smtp.SendMail("to@example.net", "from@example.com", "eXg", "{s\r\ns");
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	/// Dim smtp As nMail.Smtp = New nMail.Smtp("mail.example.com")
	///	Try
	/// 	smtp.SendMail("to@example.net", "from@example.com", "eXg", "{s" + ControlChars.CrLf + "s")
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		smtp.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// <para>
	/// SMTP AUTH gpă[𑗐MB
	///	<code lang="cs">
	///	using(nMail.Smtp smtp = new nMail.Smtp("mail.example.com")) {
	///		try {
	///			smtp.Connect();
	///			smpt.Authenticate("smtp_id", "password", nMail.Smtp.AuthPlain | nMail.Smtp.AuthCramMd5);
	///			smtp.SendMail("to@example.net", "from@example.com", "eXg", "{s\r\ns");
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	/// Dim smtp As nMail.Smtp = New nMail.Smtp("mail.example.com")
	///	Try
	/// 	smtp.Connect()
	/// 	smtp.Authenticate("smtp_id", "password", nMail.Smtp.AuthPlain Or nMail.Smtp.AuthCramMd5)
	/// 	smtp.SendMail("to@example.net", "from@example.com", "eXg", "{s" + ControlChars.CrLf + "s")
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		smtp.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// <para>
	/// TLS Version 1  SMTP AUTH gpă[𑗐MB
	///	<code lang="cs">
	///	using(nMail.Smtp smtp = new nMail.Smtp("mail.example.com")) {
	///		try {
	///			smtp.SSL = nMail.Smtp.TLS1;
	///			smtp.Connect(nMail.Smtp.StandardSslPortNo);		// over SSL/TLS ̃|[gԍw肵Đڑ
	///			smpt.Authenticate("smtp_id", "password", nMail.Smtp.AuthPlain | nMail.Smtp.AuthCramMd5);
	///			smtp.SendMail("to@example.net", "from@example.com", "eXg", "{s\r\ns");
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	/// Dim smtp As nMail.Smtp = New nMail.Smtp("mail.example.com")
	///	Try
	/// 	smtp.SSL = nMail.Smtp.TLS1
	/// 	smtp.Connect(nMail.Smtp.StandardSslPortNo)		' over SSL/TLS ̃|[gԍw肵Đڑ
	/// 	smtp.Authenticate("smtp_id", "password", nMail.Smtp.AuthPlain Or nMail.Smtp.AuthCramMd5)
	/// 	smtp.SendMail("to@example.net", "from@example.com", "eXg", "{s" + ControlChars.CrLf + "s")
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		smtp.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// <para>
	/// ꎞx~@\gă[𑗐MB
	///	<code lang="cs">
	///	using(nMail.Smtp smtp = new nMail.Smtp("mail.example.com")) {
	///		try {
	///			// Ytt@C̎w
	///			smtp.FileName = @"z:\file.dat";
	///			smtp.Flag = nMail.Smtp.SuspendAttachmentFile;
	///			smtp.Connect();
	///			// ꎞx~@\̂ݎgꍇł Authenticate ̌Ăяo͕KvłB
	///			// Authenticate("", "", AuthNotUse); łB
	///			smtp.Authenticate();
	///			smtp.SendMail("to@example.net", "from@example.com", "eXg", "{s\r\ns");
	///			smtp.Flag = nMail.Smtp.SuspendNext;
	///			while(smtp.ErrorCode == nMail.Smtp.ErrorSuspendAttachmentFile)
	///			{
	///				smtp.SendMail();
	///				// x~̏
	///				Application.DoEvents();
	///			}
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	/// Dim smtp As nMail.Smtp = New nMail.Smtp("mail.example.com")
	///	Try
	///		smtp.FileName = "z:\file.dat"
	/// 	smtp.Flag = nMail.Smtp.SuspendAttachmentFile
	///		smtp.Connect()
	/// 	smtp.Authenticate();
	/// 	smtp.SendMail("to@example.net", "from@example.com", "eXg", "{s" + ControlChars.CrLf + "s")
	///		smtp.Flag = nMail.Smtp.SuspendNext
	///		Do While smtp.ErrorCode = nMail.Smtp.ErrorSuspendAttachmentFile
	///			smtp.SendMail()
	///			' x~̏
	///			Application.DoEvents()
	///		Loop
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		smtp.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// <para>
	/// SMTP AUTH gpAɈꎞx~@\gă[𑗐MB
	///	<code lang="cs">
	///	using(nMail.Smtp smtp = new nMail.Smtp("mail.example.com")) {
	///		try {
	///			// Ytt@C̎w
	///			smtp.FileName = @"z:\file.dat";
	///			smtp.Flag = nMail.Smtp.SuspendAttachmentFile;
	///			smtp.Connect();
	///			smpt.Authenticate("smtp_id", "password", nMail.Smtp.AuthPlain | nMail.Smtp.AuthCramMd5);
	///			smtp.SendMail("to@example.net", "from@example.com", "eXg", "{s\r\ns");
	///			smtp.Flag = nMail.Smtp.SuspendNext;
	///			while(smtp.ErrorCode == nMail.Smtp.ErrorSuspendAttachmentFile)
	///			{
	///				smtp.SendMail();
	///				// x~̏
	///				Application.DoEvents();
	///			}
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	/// Dim smtp As nMail.Smtp = New nMail.Smtp("mail.example.com")
	///	Try
	///		smtp.FileName = "z:\file.dat"
	/// 	smtp.Flag = nMail.Smtp.SuspendAttachmentFile
	///		smtp.Connect()
	///		smpt.Authenticate("smtp_id", "password", nMail.Smtp.AuthPlain Or nMail.Smtp.AuthCramMd5)
	/// 	smtp.SendMail("to@example.net", "from@example.com", "eXg", "{s" + ControlChars.CrLf + "s")
	///		smtp.Flag = nMail.Smtp.SuspendNext
	///		Do While smtp.ErrorCode = nMail.Smtp.ErrorSuspendAttachmentFile
	///			smtp.SendMail()
	///			' x~̏
	///			Application.DoEvents()
	///		Loop
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		smtp.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// </example>
	public class Smtp : IDisposable
	{
		/// <summary>
		/// g@\pobt@̃TCYłB
		/// </summary>
		protected const int AttachmentTempSize = 400;

		/// <summary>
		/// \PbgG[͔ڑԂłBl -1 łB
		/// </summary>
		public const int ErrorSocket = -1;
		/// <summary>
		/// F؎sG[łBl -2 łB
		/// </summary>
		public const int ErrorAuthenticate = -2;
		/// <summary>
		/// ^CAEgG[łBl -4 łB
		/// </summary>
		public const int ErrorTimeout = -4;
		/// <summary>
		/// Ytt@CI[vsG[łBl -5 łB
		/// </summary>
		public const int ErrorFileOpen = -5;
		/// <summary>
		/// T[ow肵F،`ɑΉĂ܂Bl -8 łB
		/// </summary>
		public const int ErrorAuthenticateNoSupport = -8;
		/// <summary>
		/// mۃG[łBl -9 łB
		/// </summary>
		public const int ErrorMemory = -9;
		/// <summary>
		/// ̑̃G[łBl -10 łB
		/// </summary>
		public const int ErrorEtc = -10;
		/// <summary>
		/// [M̈ꎞx~ԂłBl -20 łB
		/// </summary>
		public const int ErrorSuspendAttachmentFile = -20;
		/// <summary>
		/// T[rXpł܂Bl -421 łB
		/// </summary>
		public const int ErrorServiceNotAvaliable = -421;
		/// <summary>
		/// [{bNXgpł܂Bigpjl -450 łB
		/// </summary>
		public const int ErrorMailboxUnavalable = -450;
		/// <summary>
		/// T[oG[łBl -451 łB
		/// </summary>
		public const int ErrorLocal = -451;
		/// <summary>
		/// VXeeʕsG[łBl -452 łB
		/// </summary>
		public const int ErrorInsufficientSystemStorage = -452;
		/// <summary>
		/// R}h̕@G[łBl -500 łB
		/// </summary>
		public const int ErrorSyntax = -500;
		/// <summary>
		/// p[^̕@G[łBl -501 łB
		/// </summary>
		public const int ErrorParameter = -501;
		/// <summary>
		/// R}hłBl -502 łB
		/// </summary>
		public const int ErrorCommandNotImplemented = -502;
		/// <summary>
		/// R}h̃V[PXُłBl -503 łB
		/// </summary>
		public const int ErrorBadSequence =-503;
		/// <summary>
		/// SMTP F؎słBl -535 łB
		/// </summary>
		public const int ErrorSmtpAuthenticate = -535;
		/// <summary>
		/// M悪܂Bl -550 łB
		/// </summary>
		public const int ErrorUserUnkown = -550;
		/// <summary>
		/// [U[݂ȂA]悪܂Bl -551 łB
		/// </summary>
		public const int ErrorUserNotLocal = -551;
		/// <summary>
		/// eʃI[o[G[łBl -552 łB
		/// </summary>
		public const int ErrorExceededStorageAllocation =-552;
		/// <summary>
		/// [{bNX܂Bl -553 łB
		/// </summary>
		public const int ErrorMailboxNameNotAllowed = -553;
		/// <summary>
		/// [h~G[łBl -553 łB
		/// </summary>
		public const int ErrorRelayOperationRejected =-553;
		/// <summary>
		/// gUNVɎs܂Bl -554 łB
		/// </summary>
		public const int ErrorTransactionFailed = -554;
		/// <summary>
		/// MtB[h nMail.DLL Ő܂B
		/// </summary>
		public const int AddDateField = 1;
		/// <summary>
		/// Message-ID tB[h nMail.DLL Ő܂B
		/// </summary>
		public const int AddMessageId = 2;
		/// <summary>
		/// 傫ȃTCY̓Ytt@CMɈU߂܂B
		/// </summary>
		public const int SuspendAttachmentFile = 4;
		/// <summary>
		/// 傫ȃTCY̓Ytt@CMڈȍ~łB
		/// </summary>
		public const int SuspendNext = 8;
		/// <summary>
		/// RFC2231 œYtt@CGR[h܂B
		/// </summary>
		public const int FileNameRfc2231 = 16;
		/// <summary>
		/// UTF-8 Ń[GR[h܂iBASE64ŃGR[h܂j
		/// </summary>
		public const int EncodeUtf8 = 32;
		/// <summary>
		/// HTML [𑗐M܂B
		/// </summary>
		public const int HtmlMail = 64;
		/// <summary>
		/// text/html p[gt@CŎw肵܂B
		/// </summary>
		public const int HtmlUseFile = 128;
		/// <summary>
		/// HTML [̈̃hC݂ multipart ̍\肵܂B
		/// </summary>
		public const int HtmlAutoPart = 256;
		/// <summary>
		/// text/html p[gŎgp摜t@CYtꍇAmultipart/mixed ȂőM܂B
		/// </summary>
		public const int HtmlNoMixedPart = 512;
		/// <summary>
		/// Softbank gьIvViHtmlNoMixedPartƓj
		/// </summary>
		public const int HtmlSoftbank = 512;
		/// <summary>
		/// EMOBILE gьIvViHtmlNoMixedPartƓj
		/// </summary>
		public const int HtmlEmobile = 512;
		/// <summary>
		/// WILLCOM gьIvViHtmlNoMixedPartƓj
		/// </summary>
		public const int HtmlWillcom = 512;
		/// <summary>
		/// text/html p[gŎgp摜t@CYtꍇAmultipart/related ȂőM܂B
		/// </summary>
		public const int HtmlNoRelatedPart = 1024;
		/// <summary>
		/// au gьIvViHtmlNoRelatedPartƓj
		/// </summary>
		public const int HtmlAu = 1024;
		/// <summary>
		/// text/html p[ĝ݁itext/plain p[gȂj HTML [𑗐M܂B
		/// </summary>
		public const int HtmlNoPlainPart = 2048;
		/// <summary>
		/// text/plain p[gŎgp镶 Body Ŏw肵܂B
		/// </summary>
		public const int HtmlSetPlainBody = 4096;
		/// <summary>
		/// łB
		/// </summary>
		public const int Success = 1;
		/// <summary>
		/// SMTP AUTH ͎gp܂B
		/// </summary>
		public const int AuthNotUse = 0;
		/// <summary>
		/// SMTP AUTH PLAIN gp܂B
		/// </summary>
		public const int AuthPlain = 1;
		/// <summary>
		/// SMTP AUTH LOGIN gp܂B
		/// </summary>
		public const int AuthLogin = 2;
		/// <summary>
		/// SMTP AUTH CRAM MD5 gp܂B
		/// </summary>
		public const int AuthCramMd5 = 4;
		/// <summary>
		/// SMTP AUTH DIGEST MD5 gp܂B
		/// </summary>
		public const int AuthDigestMd5 = 8;
		/// <summary>
		/// SSLv3 gp܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int SSL3 = 0x1000;
		/// <summary>
		/// TSLv1 gp܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int TLS1 = 0x2000;
		/// <summary>
		/// STARTTLS gp܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int STARTTLS = 0x4000;
		/// <summary>
		/// T[oؖ؂łG[ɂ܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int IgnoreNotTimeValid = 0x0800;
		/// <summary>
		/// [gؖłG[ɂ܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int AllowUnknownCA = 0x0400;
		/// <summary>
		/// SMTP ̕W|[gԍł
		/// </summary>
		public const int StandardPortNo = 25;
		/// <summary>
		/// SMTP ̃Tu~bV|[gԍł
		/// </summary>
		public const int SubmissionPortNo = 587;
		/// <summary>
		/// SMTP over SSL ̃|[gԍł
		/// </summary>
		public const int StandardSslPortNo = 465;

		/// <summary>
		/// SMTP |[gԍłB
		/// </summary>
		protected int _port = 25;
		/// <summary>
		/// \PbgnhłB
		/// </summary>
		protected IntPtr _socket = (IntPtr)ErrorSocket;
		/// <summary>
		/// [Mg@\̎włB
		/// </summary>
		protected int _flag = 0;
		/// <summary>
		/// G[ԍłB
		/// </summary>
		protected int _err = 0;
		/// <summary>
		/// SMTP AUTH ̔Fؕ@łB
		/// </summary>
		protected int _mode = AuthNotUse;
		/// <summary>
		/// SMTP T[ołB
		/// </summary>
		protected string _host = "";
		/// <summary>
		/// SMTP AUTH [U[łB
		/// </summary>
		protected string _id = "";
		/// <summary>
		/// SMTP AUTH pX[hłB
		/// </summary>
		protected string _password = "";
		/// <summary>
		/// [̈łB
		/// </summary>
		protected string _to = "";
		/// <summary>
		/// [ CC łB
		/// </summary>
		protected string _cc = "";
		/// <summary>
		/// [ BCC łB
		/// </summary>
		protected string _bcc = "";
		/// <summary>
		/// [̍olłB
		/// </summary>
		protected string _from = "";
		/// <summary>
		/// [̌łB
		/// </summary>
		protected string _subject = "";
		/// <summary>
		/// [̖{łB
		/// </summary>
		protected string _body = "";
		/// <summary>
		/// [̒ǉwb_łB
		/// </summary>
		protected string _header = "";
		/// <summary>
		/// [ɓYtt@CłB
		/// </summary>
		protected string _filename = "";
		/// <summary>
		/// Ytt@C̃XgłB
		/// </summary>
		protected string[] _filename_list = null;
		/// <summary>
		/// g@\pobt@łB
		/// </summary>
		protected byte[] _temp = null;
		/// <summary>
		/// Connect() gǂ̃tOłB
		/// </summary>
		protected bool _connect_flag = false;
		/// <summary>
		/// Dispose sǂ̃tOłB
		/// </summary>
		private bool _disposed = false;
		/// <summary>
		/// SSL ݒtOłB
		/// </summary>
		protected int _ssl = 0;
		/// <summary>
		/// SSL NCAgؖłB
		/// </summary>
		protected string _cert_name = null;

		[DllImport("nMail.DLL", EntryPoint="NMailSmtpSendMailPortNo", CharSet=CharSet.Auto)]
		protected static extern int SmtpSendMailPortNo(String HostName, String To, String Cc, String Bcc, String From, String Subject, String Body, String Header, String Path, int Flag, int PortNo);

		[DllImport("nMail.DLL", EntryPoint="NMailSmtpConnect", CharSet=CharSet.Auto)]
		protected static extern IntPtr SmtpConnect(string Host);

		[DllImport("nMail.DLL", EntryPoint="NMailSmtpConnectPortNo", CharSet=CharSet.Auto)]
		protected static extern IntPtr SmtpConnectPortNo(string Host, int PortNo);

		[DllImport("nMail.DLL", EntryPoint="NMailSmtpConnectSsl", CharSet=CharSet.Auto)]
		protected static extern IntPtr SmtpConnectSsl(string Host, int Port, int Flag, string Name);

		[DllImport("nMail.DLL", EntryPoint="NMailSmtpSendMailSsl", CharSet=CharSet.Auto)]
		protected static extern int SmtpSendMailSsl(String HostName, String To, String Cc, String Bcc, String From, String Subject, String Body, String Header, String Path, int Flag, int PortNo, int SslFlag, String Name);

		[DllImport("nMail.DLL", EntryPoint="NMailSmtpAuthenticate", CharSet=CharSet.Auto)]
		protected static extern int SmtpAuthenticate(IntPtr Socket, string HostName, string Id, string Pass, int Mode);

		[DllImport("nMail.DLL", EntryPoint="NMailSmtpSendMailEx", CharSet=CharSet.Auto)]
		protected static extern int SmtpSendMailEx(IntPtr Socket, string To, string Cc, string Bcc, string From, string Subject, String Body, String Header, String Path, byte[] Temp, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailSmtpClose")]
		protected static extern int SmtpClose(IntPtr Socket);

		/// <summary>
		/// <c>Smtp</c>NX̐VKCX^X܂B
		/// </summary>
		public Smtp()
		{
			Init();
		}
		/// <summary>
		/// <c>Smtp</c>NX̐VKCX^X܂B
		/// </summary>
		/// <param name="host_name">SMTP T[o</param>
		public Smtp(string host_name)
		{
			_host = host_name;
			Init();
		}
		/// <summary>
		/// 
		/// </summary>
		~Smtp()
		{
			Dispose(false);
		}
		/// <summary>
		/// <see cref="Smtp"/>ɂĎgpĂ邷ׂẴ\[X܂B
		/// </summary>
		public void Dispose()
		{
			Dispose(true);
			GC.SuppressFinalize(this);
		}
		/// <summary>
		/// łB
		/// </summary>
		protected void Init()
		{
			_temp = new byte[AttachmentTempSize];
		}
		/// <summary>
		/// <see cref="Smtp"/>ɂĎgpĂ邷ׂẴ\[X܂B
		/// </summary>
		/// <param name="disposing">
		/// }l[W\[XƃA}l[W\[X̗ꍇ<c>true</c>B
		/// A}l[W\[Xꍇ<c>false</c>B
		/// </param>
		protected virtual void Dispose(bool disposing)
		{
			if(!_disposed) {
				if(disposing)
				{
				}
				if(_connect_flag && _socket != (IntPtr)ErrorSocket) {
					SmtpClose(_socket);
				}
				_connect_flag = false;
				_socket = (IntPtr)ErrorSocket;
				_disposed = true;
			}
		}
		/// <summary>
		/// [𑗐M܂B
		/// </summary>
		/// <remarks>
		///	ꎞx~@\̓ڈȍ~̌ĂяoŎgp܂B
		/// </remarks>
		/// <exception cref="FileNotFoundException">
		/// <see cref="FileName"/>Őݒ肳Ăt@C݂܂B
		/// </exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void SendMail()
		{
			_filename = "";
			if(_filename_list != null)
			{
				foreach(string name in _filename_list)
				{
					if(!File.Exists(name))
					{
						throw new FileNotFoundException(name);
					}
					_filename = String.Join(Convert.ToString(Options.SplitChar), _filename_list);
				}
			}
			if(_connect_flag)
			{
				_err = SmtpSendMailEx(_socket, _to, _cc, _bcc, _from, _subject, _body, _header, _filename, _temp, _flag);
			}
			else
			{
				_err = SmtpSendMailSsl(_host, _to, _cc, _bcc, _from, _subject, _body, _header, _filename, _flag, _port, _ssl, _cert_name);
			}
			if(_err < 0 && _err != ErrorSuspendAttachmentFile)
			{
				throw new nMailException("SendMail: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// [𑗐M܂B
		/// </summary>
		/// <param name="to_str"></param>
		/// <param name="from_str">ol</param>
		/// <param name="subject_str"></param>
		/// <param name="body_str">{</param>
		/// <remarks>
		/// <paramref name="to_str"/>p[^Ń[̈w肵܂B
		/// <paramref name="from_str"/>p[^ōolw肵܂B
		/// <paramref name="subject_str"/>p[^Ōw肵܂B
		/// <paramref name="body_str"/>p[^Ŗ{w肵܂B
		/// <para>CC w肵ꍇA<see cref="Cc"/>Ɏw肵Ă܂B</para>
		/// <para>BCC w肵ꍇA<see cref="Bcc"/>Ɏw肵Ă܂B</para>
		/// <para>t@CYtꍇA<see cref="FileName"/>Ɏw肵Ă܂B</para>
		/// </remarks>
		/// <exception cref="FileNotFoundException">
		/// <see cref="FileName"/>Őݒ肳Ăt@C݂܂B
		/// </exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void SendMail(string to_str, string from_str, string subject_str, string body_str)
		{
			_to = to_str;
			_from = from_str;
			_subject = subject_str;
			_body = body_str;
			SendMail();
		}
		/// <summary>
		/// SMTP T[oɐڑ܂B
		/// </summary>
		/// <remarks>
		///	SMTP AUTH шꎞx~@\gꍇɎgp܂B
		/// </remarks>
		///	<exception cref="FormatException">
		///	T[oɕ񂪓Ă܂B
		/// </exception>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect()
		{
			if(_host == "") {
				throw new FormatException();
			}
			if(_port < 0 || _port > 65536) {
				throw new ArgumentOutOfRangeException();
			}
			//_socket = SmtpConnectPortNo(_host, _port);
			_socket = SmtpConnectSsl(_host, _port, _ssl, _cert_name);
			if(_socket == (IntPtr)ErrorSocket)
			{
				_err = ErrorSocket;
				_socket = (IntPtr)ErrorSocket;
				throw new nMailException("Connect", _err);
			} else {
				_connect_flag = true;
			}
		}
		/// <summary>
		/// SMTP T[oɐڑ
		/// </summary>
		/// <param name="host_name">SMTP T[o</param>
		/// <remarks>
		///	SMTP AUTH шꎞx~@\gꍇɎgp܂B
		/// </remarks>
		///	<exception cref="FormatException">
		///	T[oɕ񂪓Ă܂B
		/// </exception>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect(string host_name)
		{
			_host = host_name;
			Connect();
		}
		/// <summary>
		/// SMTP T[oɐڑ
		/// </summary>
		/// <param name="host_name">SMTP T[o</param>
		/// <param name="port_no">|[gԍ</param>
		/// <remarks>
		///	SMTP AUTH шꎞx~@\gꍇɎgp܂B
		/// </remarks>
		///	<exception cref="FormatException">
		///	T[oɕ񂪓Ă܂B
		/// </exception>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect(string host_name, int port_no)
		{
			_host = host_name;
			_port = port_no;
			Connect();
		}
		/// <summary>
		/// SMTP T[oɐڑ
		/// </summary>
		/// <param name="port_no">|[gԍ</param>
		/// <remarks>
		///	SMTP AUTH шꎞx~@\gꍇɎgp܂B
		/// </remarks>
		///	<exception cref="FormatException">
		///	T[oɕ񂪓Ă܂B
		/// </exception>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect(int port_no)
		{
			_port = port_no;
			Connect();
		}
		/// <summary>
		/// SMTP T[oƂ̐ڑI
		/// </summary>
		public void Close()
		{
			if(_socket != (IntPtr)ErrorSocket) {
				SmtpClose(_socket);
			}
			_socket = (IntPtr)ErrorSocket;
			_connect_flag = false;
		}
		/// <summary>
		/// SMTP AUTH F
		/// </summary>
		///	<remarks>
		///	ꎞx~@\gꍇ<see cref="Connect"/>̌ɌĂяo܂B
		///	</remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B<see cref="Connect"/>ĂȂAĂяoĂ܂B̃\bhĂяoꍇ(<see cref="Connect"/>ĂяoKv܂BB
		///	</exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Authenticate()
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = SmtpAuthenticate(_socket, _host, _id, _password, _mode);
			if(_err < 0)
			{
				throw new nMailException("Authenticate: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// SMTP AUTH F
		/// </summary>
		/// <param name="id_str">[U[ ID</param>
		/// <param name="pass_str">pX[h</param>
		/// <param name="mode">F،`</param>
		/// <para>F،`̐ݒ\Ȓl͉L̒ʂłB</para>
		/// <para><see cref="AuthPlain"/>  PLAIN gp܂B</para>
		/// <para><see cref="AuthLogin"/>  LOGIN gp܂B</para>
		/// <para><see cref="AuthCramMd5"/> CRAM MD5 gp܂B</para>
		/// <para>AuthNotUse ȊO C#  | AVB.NET ł Or ŕw\łBCRAM MD5LOGINPLAIN ̗D揇ʂŔF؂݂܂B</para>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B<see cref="Connect"/>ĂȂAĂяoĂ܂B̃\bhĂяoꍇ(<see cref="Connect"/>ĂяoKv܂BB
		///	</exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Authenticate(string id_str, string pass_str, int mode)
		{
			_id = id_str;
			_password = pass_str;
			_mode = mode;
			Authenticate();
		}
		/// <summary>
		/// SMTP |[gԍłB
		/// </summary>
		/// <value>SMTP |[gԍ</value>
		public int Port {
			get
			{
				return _port;
			}
			set
			{
				_port = value;
			}
		}
		/// <summary>
		/// \PbgnhłB
		/// </summary>
		/// <value>SMTP \Pbgnh</value>
		public IntPtr Handle {
			get
			{
				return _socket;
			}
		}
		/// <summary>
		/// SMTP T[ołB
		/// </summary>
		/// <value>SMTP T[o</value>
		public string HostName
		{
			get
			{
				return _host;
			}
			set
			{
				_host = value;
			}
		}
		/// <summary>
		/// SMTP AUTH p̃[U[łB
		/// </summary>
		/// <value>SMTP AUTH [U[</value>
		public string Id
		{
			get
			{
				return _id;
			}
			set
			{
				_id = value;
			}
		}
		/// <summary>
		/// SMTP AUTH p̃pX[hłB
		/// </summary>
		/// <value>SMTP AUTH pX[h</value>
		public string Password
		{
			get
			{
				return _password;
			}
			set
			{
				_password = value;
			}
		}
		/// <summary>
		/// [̈łB
		/// </summary>
		/// <remarks>
		/// ̈ɑMꍇA ',' ŋ؂ă[AhXLqĂB
		/// </remarks>
		/// <value>[ </value>
		public string MailTo
		{
			get
			{
				return _to;
			}
			set
			{
				_to = value;
			}
		}
		/// <summary>
		/// [ CC łB
		/// </summary>
		/// <remarks>
		/// ̈ɑMꍇA ',' ŋ؂ă[AhXLqĂB
		/// </remarks>
		/// <value>[ CC</value>
		public string Cc
		{
			get
			{
				return _cc;
			}
			set
			{
				_cc = value;
			}
		}
		/// <summary>
		/// [ BCC łB
		/// </summary>
		/// <remarks>
		/// ̈ɑMꍇA ',' ŋ؂ă[AhXLqĂB
		/// </remarks>
		/// <value>[ BCC</value>
		public string Bcc
		{
			get
			{
				return _bcc;
			}
			set
			{
				_bcc = value;
			}
		}
		/// <summary>
		/// [̍olłB
		/// </summary>
		/// <value>[ol</value>
		public string From
		{
			get
			{
				return _from;
			}
			set
			{
				_from = value;
			}
		}
		/// <summary>
		/// [̌łB
		/// </summary>
		/// <value>[</value>
		public string Subject
		{
			get
			{
				return _subject;
			}
			set
			{
				_subject = value;
			}
		}
		/// <summary>
		/// [̖{łB
		/// </summary>
		/// <value>[{</value>
		public string Body
		{
			get
			{
				return _body;
			}
			set
			{
				_body = value;
			}
		}
		/// <summary>
		/// [̓Ytt@CłB
		/// </summary>
		/// <remarks>
		/// ̓Ytt@C𑗐MꍇA"," ŋ؂܂B
		/// <see cref="Options.SplitChar"/>ŋ؂蕶ύXł܂B
		/// </remarks>
		/// <value>Ytt@C</value>
		public string FileName
		{
			get
			{
				_filename = String.Join(Convert.ToString(Options.SplitChar), _filename_list);
				return _filename;
			}
			set
			{
				_filename = value;
				if(_filename.Length > 0) 
				{
					_filename_list = _filename.ToString().Split(Options.SplitChar);
				} 
				else 
				{
					_filename_list = null;
				}
			}
		}
		/// <summary>
		/// Ytt@C̔złB
		/// </summary>
		/// <value>Ytt@C̔z</value>
		public string[] FileNameList
		{
			get
			{
				return _filename_list;
			}
			set
			{
				_filename_list = value;
			}
		}
		/// <summary>
		/// [̒ǉwb_łB
		/// </summary>
		/// <remarks>
		/// ̃wb_ǉꍇAC# ł '\r\n'AVisual Basic ł ControlChars.CrLf
		/// ŘAĂB
		/// </remarks>
		/// <value>ǉwb_</value>
		public string Header
		{
			get
			{
				return _header;
			}
			set
			{
				_header = value;
			}
		}
		/// <summary>
		/// [M̃IvVwłB
		/// </summary>
		/// <value>MIvV</value>
		/// <remarks>
		/// <para><see cref="AddDateField"/>MtB[h nMail.DLL Ő܂B</para>
		/// <para><see cref="AddMessageId"/>Message-ID tB[h nMail.DLL Ő܂B</para>
		/// <para><see cref="SuspendAttachmentFile"/>Ytt@CMňꎞx~̈ڂɎw肵܂B</para>
		/// <para><see cref="SuspendNext"/>Ytt@CMňꎞx~̓ڈȍ~Ɏw肵܂B</para>
		///	<para><see cref="FileNameRfc2231"/>RFC2231 œYtt@CGR[h܂B</para>
		/// <para><see cref="EncodeUtf8"/>UTF-8 Ń[GR[h܂iBASE64ŃGR[h܂j</para>
		/// <para>C# ̏ꍇ |AVB.NET ̏ꍇ Or ŕ̎w肪\łB SuspendAttachmentFile  SuspendNext ͓Ɏwł܂B</para>
		/// </remarks>
		public int Flag
		{
			get
			{
				return _flag;
			}
			set
			{
				_flag = value;
			}
		}
		/// <summary>
		/// SMTP AUTH ̎ʂłB
		/// </summary>
		/// <remarks>
		/// <see cref="AuthNotUse"/>  SMTP AUTH ͎gp܂B
		/// <see cref="AuthPlain"/>  PLAIN gp܂B
		/// <see cref="AuthLogin"/>  LOGIN gp܂B
		/// <see cref="AuthCramMd5"/> CRAM MD5 gp܂B
		/// <see cref="AuthDigestMd5"/> DIGEST MD5 gp܂B
		/// AuthNotUse ȊO C#  | AVisual Basic ł or ŕݒ\łB
		/// DIGEST MD5CRAM MD5LOGINPLAIN ̏ԂŔF؂݂܂B
		///	ftHgl AuthNotUse łB
		/// </remarks>
		/// <value>M[h</value>
		public int AuthMode
		{
			get
			{
				return _mode;
			}
			set
			{
				_mode = value;
			}
		}
		/// <summary>
		/// [M̃G[ԍłB
		/// </summary>
		/// <value>G[ԍ</value>
		public int ErrorCode
		{
			get
			{
				return _err;
			}
		}
		/// <summary>
		/// SSL ݒtOłB
		/// </summary>
		/// <value>SSL ݒtO</value>
		public int SSL {
			get
			{
				return _ssl;
			}
			set
			{
				_ssl = value;
			}
		}
		/// <summary>
		/// SSL NCAgؖłB
		/// </summary>
		/// <remarks>
		/// null ̏ꍇw肵܂B
		/// </remarks>
		/// <value>SSL NCAgؖ</value>
		public string CertName
		{
			get
			{
				return _cert_name;
			}
			set
			{
				_cert_name = value;
			}
		}

	}
	/// <summary>
	/// Ytt@CۑNX
	/// </summary>
	/// <example>
	/// <para>
	///	ꂽ[f[^ǂݏoAĕۑB
	/// text/html p[gt@CɕۑꍇA<see cref="Options.DisableDecodeBodyText()"/>  <see cref="Options.DisableDecodeBodyAll()"/> Ă񂾌 Pop3.GetMail() Ăяo
	/// 擾wb_і{f[^gpA<see cref="Attachment.Save()"/> ̑O <see cref="Options.EnableDecodeBody()"/>  <see cref="Options.EnableSaveHtmlFile()"/> ĂłKv܂B
	/// <code lang="cs">
	///	using(nMail.Attachment attach = new nMail.Attachment()) {
	///		try {
	///			attach.Path = @"z:\temp";
	///			// count ͕
	///			for(int no = 0 ; no &lt; count ; no++) {
	///				// Read()  header Ƀwb_{"\r\n"{"{"ǂݏo
	///				string header = Read(no)
	///				attach.Add(header);
	///			}
	///			attach.Save();
	///			// I
	///			MessageBox.Show(attach.Path + " ɓYtt@C " + attach.FileName + " ۑ܂B\r\n\r\n:" + attach.Subject + "\r\n{:\r\n" + attach.Body);
	///		}
	///		catch(nMailException nex) {
	///				if(nex.ErrorCode == nMail.Attachment.ErrorFileOpen) {
	///					MessageBox.Show("Ytt@CI[vł܂B");
	///				} else if(nex.ErrorCode == nMail.Attachment.ErrorInvalidNo) {
	///	                MessageBox.Show("ꂽ[̏ԂȂAYȂt@CĂ܂B")
	///				} else if(nex.ErrorCode == nMail.Attachment.ErrorPartial) {
	///					MessageBox.Show("ꂽ[SđĂ܂");
	///				}
	///			} catch(Exception ex) {
	///				MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///			}
	///		}
	///	}
	/// </code>
	/// </para>
	/// <para>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	///	Dim attach As nMail.Attachment = New nMail.Attachment
	///	Try
	///		Dim no As Integer
	///		attach.Path = "z:\temp"
	///		// count ͕
	///		For no = 0 To count - 1
	///			' Read()  header Ƀwb_{ControlChars.CrLf{"{"ǂݏo
	///			string header = Read(no)
	///			attach.Add(header)
	///		Next no
	///		attach.Save()
	///		' I
	///		MessageBox.Show(attach.Path + " ɓYtt@C " + attach.FileName + " ۑ܂B" + ControlChars.CrLf + ControlChars.CrLf + ":" + attach.Subject + ControlChars.CrLf + "{:" + ControlChars.CrLf + attach.Body)
	///	Catch nex As nMail.nMailException
	///		If nex.ErrorCode = nMail.Attachment.ErrorFileOpen Then
	///			MessageBox.Show("Ytt@CI[vł܂B")
	///		ElseIf nex.ErrorCode = nMail.Attachment.ErrorInvalidNo Then
	///			MessageBox.Show("ꂽ[̏ԂȂAYȂt@CĂ܂B")
	///		ElseIf nex.ErrorCode = nMail.Attachment.ErrorPartial Then
	///			MessageBox.Show("ꂽ[SđĂ܂")
	///		End If
	///	Catch ex As Exception
	///		Debug.WriteLine(ex.Message)
	///	Finally
	///		attach.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// </example>
	public class Attachment : IDisposable
	{
		/// <summary>
		/// wb_̈̃TCYłB
		/// </summary>
		protected const int HeaderSize = 32768;
		/// <summary>
		/// pX̃TCYłB
		/// </summary>
		protected const int MaxPath = 32768;
		/// <summary>
		/// Ytt@CWJpobt@̃TCYłB
		/// </summary>
		protected const int AttachmentTempSize = 400;

		/// <summary>
		/// ꂽYtt@C̏Ԃ܂Bl -3 łB
		/// </summary>
		public const int ErrorInvalidNo = -3;
		/// <summary>
		/// Ytt@C쐬ł܂łBl -5 łB
		/// </summary>
		public const int ErrorFileOpen = -5;
		/// <summary>
		/// Ytt@C̓WJIĂ܂Bl -6 łB
		/// </summary>
		public const int ErrorPartial = -6;
		/// <summary>
		/// Ytt@CƓ̃t@CtH_ɑ݂܂Bl -7 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="nMail.Options.AlreadyFile"/>  <see cref="nMail.Options.FileAlreadyError"/></para>
		/// <para>ݒ肵A<see cref="Path"/>Ŏw肵tH_ɓYtt@CƓÕt@C</para>
		/// <para>ꍇɂ̃G[܂B</para>
		/// </remarks>
		public const int ErrorFileAlready = -7;
		/// <summary>
		/// mۃG[łBl -9 łB
		/// </summary>
		public const int ErrorMemory = -9;
		/// <summary>
		/// ̑̃G[łBl -10 łB
		/// </summary>
		public const int ErrorEtc = -10;
		/// <summary>
		/// Ytt@C݂͑܂B
		/// </summary>
		public const int NoAttachmentFile = -1;
		/// <summary>
		/// wb_f[^̃Xg
		/// </summary>
		protected ArrayList _header_list;
		/// <summary>
		/// {f[^̃Xg
		/// </summary>
		protected ArrayList _body_list;

		/// <summary>
		/// wb_[TCYłB
		/// </summary>
		protected int _header_size = -1;
		/// <summary>
		/// G[ԍłB
		/// </summary>
		protected int _err;
		/// <summary>
		/// Ytt@CۑpXłB
		/// </summary>
		protected string _path = "";
		/// <summary>
		/// [̌łB
		/// </summary>
		protected StringBuilder _subject;
		/// <summary>
		/// [̑MłB
		/// </summary>
		protected StringBuilder _date;
		/// <summary>
		/// [̍olłB
		/// </summary>
		protected StringBuilder _from;
		/// <summary>
		/// [̃wb_łB
		/// </summary>
		protected StringBuilder _header;
		/// <summary>
		/// [̖{łB
		/// </summary>
		protected StringBuilder _body;
		/// <summary>
		/// WJYtt@CłB
		/// </summary>
		protected StringBuilder _filename;
		/// <summary>
		/// Ytt@C̃XgłB
		/// </summary>
		protected string[] _filename_list = null;
		/// <summary>
		/// t@C ID łB
		/// </summary>
		protected StringBuilder _id;
		/// <summary>
		/// Ytt@CWJpobt@łB
		/// </summary>
		protected byte[] _temp;
		/// <summary>
		/// WJJnǂ̃tOłB
		/// </summary>
		protected bool _attachment_flag = false;
		/// <summary>
		/// Dispose sǂ̃tOłB
		/// </summary>
		private bool _disposed = false;
		/// <summary>
		/// text/html p[gۑt@C̖OłB
		/// </summary>
		protected StringBuilder _html_file = null;
		/// <summary>
		/// wb_tB[hłB
		/// </summary>
		protected string _field_name = "";
		/// <summary>
		/// wb_tB[hei[obt@łB
		/// </summary>
		protected StringBuilder _field = null;
		/// <summary>
		/// message/rfc822 p[gۑt@C̖OłB
		/// </summary>
		protected StringBuilder _rfc822_file = null;

		[DllImport("nMail.DLL", EntryPoint="NMailAttachmentFileFirst", CharSet=CharSet.Auto)]
		protected static extern int AttachmentFileFirst(byte []Temp, StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, StringBuilder Body, string Path, StringBuilder FileName, string FirstHeader, string FirstBody);

		[DllImport("nMail.DLL", EntryPoint="NMailAttachmentFileNextVB", CharSet=CharSet.Auto)]
		protected static extern int AttachmentFileNextVB(byte []Temp, StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, StringBuilder Body, string Path, StringBuilder FileName, string NextHeader, string NextBody);

		[DllImport("nMail.DLL", EntryPoint="NMailAttachmentFileClose")]
		protected static extern bool AttachmentFileClose(byte []Temp);

		[DllImport("nMail.DLL", EntryPoint="NMailAttachmentFileStatus", CharSet=CharSet.Auto)]
		protected static extern int AttachmentFileStatus(string Header, StringBuilder Id, int Size);

		[DllImport("nMail.DLL", EntryPoint="NMailGetHeaderField", CharSet=CharSet.Auto)]
		protected static extern int Pop3GetHeaderField(StringBuilder Field, string Header, string Name, int Size);

		[DllImport("nMail.DLL", EntryPoint="NMailDecodeHeaderField", CharSet=CharSet.Auto)]
		protected static extern int Pop3DecodeHeaderField(StringBuilder Destination, string Source, int Size);

		/// <summary>
		/// <c>Attachment</c>NX̐VKCX^X܂B
		/// </summary>
		public Attachment()
		{
			_header_list = new ArrayList();
			_body_list = new ArrayList();
			_temp = new byte[AttachmentTempSize];
		}
		/// <summary>
		/// 
		/// </summary>
		~Attachment()
		{
			Dispose(false);
		}
		/// <summary>
		/// <see cref="Attachment"/>ɂĎgpĂ邷ׂẴ\[X܂B
		/// </summary>
		public void Dispose()
		{
			Dispose(true);
			GC.SuppressFinalize(this);
		}
		/// <summary>
		/// <see cref="Attachment"/>ɂĎgpĂ邷ׂẴ\[X܂B
		/// </summary>
		/// <param name="disposing">
		/// }l[W\[XƃA}l[W\[X̗ꍇ<c>true</c>B
		/// A}l[W\[Xꍇ<c>false</c>B
		/// </param>
		protected virtual void Dispose(bool disposing)
		{
			if(!_disposed)
			{
				if(disposing)
				{
				}
				if(_attachment_flag)
				{
					AttachmentFileClose(_temp);
					_attachment_flag = false;
				}
				_disposed = true;
			}
		}
		/// <summary>
		/// Ytt@CWJŎgpĂ\[X܂B
		/// </summary>
		public void Close()
		{
			if(_attachment_flag)
			{
				AttachmentFileClose(_temp);
				_attachment_flag = false;
			}
		}
		/// <summary>
		/// wb_i[pobt@̃TCY肵܂B
		/// </summary>
		protected void SetHeaderSize()
		{
			if(_header_size < 0)
			{
				_header_size = Options.HeaderMax;
			}
			if(_header_size <= 0)
			{
				_header_size = HeaderSize;
				Options.HeaderMax = _header_size;
			}
		}
		/// <summary>
		/// [{̍vTCY擾܂B
		/// </summary>
		/// <returns>[{̍vTCY</returns>
		protected int GetBodySize()
		{
			int size = 0;
			string str;

			for(int no = 0 ; no < _header_list.Count ; no++)
			{
				if(no < _body_list.Count)
				{
					str = (string)_body_list[no];
					size += str.Length;
				}
				str = (string)_header_list[no];
				size += str.Length;
			}
			return size;
		}
		/// <summary>
		/// Ytt@CWJĕۑ܂B
		/// </summary>
		/// <exception cref="FormatException">
		///	<see cref="Add"/>ŌƂȂ镶iwb_,{)ǉĂ܂B
		///	</exception>
		/// <exception cref="DirectoryNotFoundException">
		///	<see cref="Path"/>Ŏw肵tH_݂܂B
		/// </exception>
		/// <exception cref="nMailException">
		///	WJɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Save()
		{
			if(_path != null)
			{
				if(_path != "" && !Directory.Exists(_path))
				{
					throw new DirectoryNotFoundException(_path);
				}
			}
			if(_header_list.Count != _body_list.Count && _body_list.Count > 0)
			{
				throw new FormatException();
			}
			string read_body;
			string read_header;
			string keep_id = "";
			int id_no;

			SetHeaderSize();
			_subject = new StringBuilder(_header_size);
			_date = new StringBuilder(_header_size);
			_from = new StringBuilder(_header_size);
			_header = new StringBuilder(_header_size);
			_body = new StringBuilder(GetBodySize());
			Options.FileNameMax = MaxPath;
			_filename = new StringBuilder(MaxPath);
			for(int no = 0 ; no < _header_list.Count ; no++)
			{
				if(no < _body_list.Count)
				{
					read_body = (string)_body_list[no];
				}
				else
				{
					read_body = "";
				}
				read_header = (string)_header_list[no];
				if(no == 0)
				{
					id_no = GetId(read_header);
					if(id_no > 1) {
						throw new nMailException("Save", ErrorInvalidNo);
					}
					keep_id = PartId;
					_attachment_flag = true;
					_err = AttachmentFileFirst(_temp, _subject, _date, _from, _header, _body, _path, _filename, read_header, read_body);
				}
				else
				{
					if(GetId(read_header) != no + 1 || keep_id != PartId) {
						throw new nMailException("Save", ErrorInvalidNo);
					}
					_err = AttachmentFileNextVB(_temp, _subject, _date, _from, _header, _body, _path, _filename, read_header, read_body);
				}
				if(_err < 0 && _err != ErrorPartial)
				{
					throw new nMailException("Save", _err);
				}
			}
			if(_filename.Length > 0) 
			{
				_filename_list = _filename.ToString().Split(Options.SplitChar);
			} 
			else 
			{
				_filename_list = null;
			}
			if(Options.SaveHtmlFile == Options.SaveHtmlFileOn) {
				_html_file = new StringBuilder(_header_size);
				Pop3GetHeaderField(_html_file, _header.ToString(), "X-NMAIL-HTML-FILE:", _header_size);
			}
			if(Options.SaveRfc822File != Options.SaveRfc822FileOff) {
				_rfc822_file = new StringBuilder(_header_size);
				Pop3GetHeaderField(_rfc822_file, _header.ToString(), "X-NMAIL-RFC822-FILE:", _header_size);
			}
			AttachmentFileClose(_temp);
			_attachment_flag = false;
		}
		/// <summary>
		/// WJƂȂ镪t@Cf[^Xgɒǉ܂B
		/// </summary>
		/// <param name="header_body">wb_[{{̕</param>
		/// <remarks>
		///	wb_Ɩ{̊Ԃɂ͈s̋sKvłB
		/// </remarks>
		public void Add(string header_body)
		{
			_header_list.Add(header_body);
		}
		/// <summary>
		/// WJƂȂ镪t@Cf[^Xgɒǉ܂B
		/// </summary>
		/// <param name="header">wb_[̕</param>
		/// <param name="body">{̕</param>
		public void Add(string header, string body)
		{
			_header_list.Add(header);
			_body_list.Add(body);
		}
		/// <summary>
		/// t@C ID 擾܂B
		/// </summary>
		/// <param name="header">wb_[̕</param>
		/// <returns><see cref="NoAttachmentFile"/>̏ꍇĂȂYtt@Ct[łB
		/// 1 ȏ̏ꍇAt@C̔ԍƂȂ܂B
		/// </returns>
		public int GetId(string header)
		{
			_id = new StringBuilder(header.Length);
			return AttachmentFileStatus(header, _id, header.Length);
		}
		/// <summary>
		/// [wb_w̃tB[h̓e擾܂B
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <returns>tB[h̓e
		/// </returns>
		public string GetHeaderField(string field_name)
		{
			_field_name = field_name;
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			_err = Pop3GetHeaderField(_field, _header.ToString(), _field_name, _header_size);
			if(_err < 0)
			{
				throw new nMailException("GetHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// [wb_w̃tB[h̓e擾܂B
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <param name="header">wb_</param>
		/// <returns>tB[h̓e
		/// </returns>
		public string GetHeaderField(string field_name, string header)
		{
			_field_name = field_name;
			_header = new StringBuilder(header);
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			_err = Pop3GetHeaderField(_field, _header.ToString(), _field_name, _header_size);
			if(_err < 0)
			{
				throw new nMailException("GetHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// MIME wb_tB[h̕fR[h܂
		/// </summary>
		/// <param name="field">tB[h̕</param>
		/// <returns>fR[htB[he</returns>
		public string DecodeHeaderField(string field)
		{
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			_err = Pop3DecodeHeaderField(_field, field, _header_size);
			if(_err < 0)
			{
				throw new nMailException("DecodeHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// [wb_w̃wb_tB[h̓e擾A
		/// MIME wb_tB[h̃fR[hsĕԂ܂
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <returns>擾fR[hς݂̃tB[he</returns>
		public string GetDecodeHeaderField(string field_name)
		{
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			String src = GetHeaderField(field_name, _header.ToString());
			_err = Pop3DecodeHeaderField(_field, src, _header_size);
			if(_err < 0)
			{
				throw new nMailException("DecodeHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// [wb_w̃wb_tB[h̓e擾A
		/// MIME wb_tB[h̃fR[hsĕԂ܂
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <param name="header">wb_</param>
		/// <returns>擾fR[hς݂̃tB[he</returns>
		public string GetDecodeHeaderField(string field_name, string header)
		{
			SetHeaderSize();
			_err = Pop3DecodeHeaderField(_field, GetHeaderField(field_name, header), _header_size);
			if(_err < 0)
			{
				throw new nMailException("DecodeHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// Ytt@C̔złB
		/// </summary>
		///	<remarks>
		/// ̃vpeB͌݊̂߂ɎcĂ܂B
		///	<see cref="GetFileNameList"/>Ŕz擾Ďgp悤ɂĂB
		///	</remarks>
		/// <returns>Ytt@C̔z</returns>
		public string[] GetFileNameList()
		{
			if(_filename_list == null)
			{
				return new string[0];
			}
			else
			{
				return (string[])_filename_list.Clone();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <value>[</value>
		public string Subject
		{
			get
			{
				if(_subject == null)
				{
					return "";
				}
				else
				{
					return _subject.ToString();
				}
			}
		}
		/// <summary>
		/// [̑M̕łB
		/// </summary>
		/// <value>[M</value>
		public string DateString
		{
			get
			{
				if(_date == null)
				{
					return "";
				}
				else
				{
					return _date.ToString();
				}
			}
		}
		/// <summary>
		/// [̍olłB
		/// </summary>
		/// <value>[ol</value>
		public string From
		{
			get
			{
				if(_from == null)
				{
					return "";
				}
				else
				{
					return _from.ToString();
				}
			}
		}
		/// <summary>
		/// [̖{łB
		/// </summary>
		/// <value>[{</value>
		public string Body
		{
			get
			{
				if(_body == null)
				{
					return "";
				}
				else
				{
					return _body.ToString();
				}
			}
		}
		/// <summary>
		/// Ytt@CۑtH_łB
		/// </summary>
		/// <remarks>
		/// null (VB.Net  nothing) ̏ꍇۑ܂B
		/// </remarks>
		/// <value>Ytt@CۑtH_</value>
		public string Path
		{
			get
			{
				return _path;
			}
			set
			{
				_path = value;
			}
		}
		/// <summary>
		/// t@C ID łB
		/// </summary>
		/// <value>t@C ID</value>
		public string PartId
		{
			get
			{
				if(_id == null)
				{
					return "";
				}
				else
				{
					return _id.ToString();
				}
			}
		}
		/// <summary>
		/// Ytt@CłB
		/// </summary>
		/// <remarks>
		/// ̓Ytt@CꍇA"," ŋ؂Ċi[܂B
		/// <see cref="Options.SplitChar"/>ŋ؂蕶ύXł܂B
		/// </remarks>
		/// <value>Ytt@C</value>
		public string FileName
		{
			get
			{
				if(_filename == null)
				{
					return "";
				}
				else
				{
					return _filename.ToString();
				}
			}
		}
		/// <summary>
		/// Ytt@C̔złB
		/// </summary>
		///	<remarks>
		/// ̃vpeB͌݊̂߂ɎcĂ܂B
		///	<see cref="GetFileNameList"/>Ŕz擾Ďgp悤ɂĂB
		///	</remarks>
		/// <value>Ytt@C̔z</value>
		public string[] FileNameList
		{
			get
			{
				return _filename_list;
			}
		}
		/// <summary>
		/// G[ԍ
		/// </summary>
		/// <value>G[ԍ</value>
		public int ErrorCode
		{
			get
			{
				return _err;
			}
		}
		/// <summary>
		/// text/html p[gۑt@C̖OłB
		/// </summary>
		/// <value>t@C</value>
		public string HtmlFile
		{
			get
			{
				if(_html_file == null)
				{
					return "";
				}
				else
				{
					return _html_file.ToString();
				}
			}
		}
		/// <summary>
		/// [̃wb_łB
		/// </summary>
		/// <value>[̃wb_</value>
		public string Header
		{
			get
			{
				if(_header == null)
				{
					return "";
				}
				else
				{
					return _header.ToString();
				}
			}
			set
			{
				_header = new StringBuilder(value);
			}
		}
		/// <summary>
		/// wb_tB[h̓ełB
		/// </summary>
		/// <value>wb_tB[h̓e</value>
		public string Field
		{
			get
			{
				if(_field == null)
				{
					return "";
				}
				else
				{
					return _field.ToString();
				}
			}
		}
		/// <summary>
		/// message/rfc822 p[gۑt@C̖OłB
		/// </summary>
		/// <value>t@C</value>
		public string Rfc822File
		{
			get
			{
				if(_rfc822_file == null)
				{
					return "";
				}
				else
				{
					return _rfc822_file.ToString();
				}
			}
		}
	}
	/// <summary>
	/// nMail.DLL ݒpNX
	/// </summary>
	public class Options
	{
		/// <summary>
		/// <c>Options</c>NX̐VKCX^X܂B
		/// </summary>
		public Options()
		{
		}
		/// <summary>
		/// 
		/// </summary>
		protected const int MessageSize = 32768;

		/// <summary>
		/// IvVF^CAEg
		/// </summary>
		protected const int OptionTimeout = 0;
		/// <summary>
		/// IvVFwb_TCY
		/// </summary>
		protected const int OptionHeaderMax = 1;
		/// <summary>
		/// IvVF{TCY
		/// </summary>
		protected const int OptionBodyMax = 2;
		/// <summary>
		/// IvVF㏑[h
		/// </summary>
		protected const int OptionAlreadyFile = 3;
		/// <summary>
		/// IvVFfobN[h
		/// </summary>
		protected const int OptionDebugMode = 4;
		/// <summary>
		/// IvVFڑ^CAEg
		/// </summary>
		protected const int OptionConnectTimeout = 5;
		/// <summary>
		/// IvVF؂蕶
		/// </summary>
		protected const int OptionSplitChar = 6;
		/// <summary>
		/// IvVFꎞx~TCY
		/// </summary>
		protected const int OptionSuspendSize = 7;
		/// <summary>
		/// IvVFSleep 
		/// </summary>
		protected const int OptionSleepTime = 8;
		/// <summary>
		/// IvVFtB[hTCY
		/// </summary>
		protected const int OptionFieldMax = 9;
		/// <summary>
		/// IvVFtext/html p[gۑ
		/// </summary>
		protected const int OptionSaveHtmlFile = 10;
		/// <summary>
		/// IvVF{̃fR[h
		/// </summary>
		protected const int OptionDecodeBody = 11;
		/// <summary>
		/// IvVFwb_̃fR[h
		/// </summary>
		protected const int OptionDecodeHeader = 12;
		/// <summary>
		/// IvVFYtt@Ci[obt@TCY
		/// </summary>
		protected const int OptionFileNameMax = 13;
		/// <summary>
		/// IvVFYtt@CɎgpłȂu镶
		/// </summary>
		protected const int OptionChangeChar = 14;
		/// <summary>
		/// IvVFYtt@Cu
		/// </summary>
		protected const int OptionChangeCharMode = 15;
		/// <summary>
		/// IvVFmessage/rfc822 p[gۑ
		/// </summary>
		protected const int OptionSaveRfc822File = 16;

		/// <summary>
		/// t@C㏑܂B
		/// </summary>
		public const int FileOverwrite = 0;
		/// <summary>
		/// t@C̖(gq̑O)ɐǉĕۑ܂B
		/// "file.dat" ݂ꍇA"file1.dat" ƂOŕۑ܂B
		/// </summary>
		public const int FileRename = 1;
		/// <summary>
		/// t@C쐬G[Ƃ܂B
		/// </summary>
		public const int FileAlreadyError = 2;

		/// <summary>
		/// G[bZ[W擾܂B
		/// </summary>
		protected const int MessageError = 0;
		/// <summary>
		/// fobOp̃T[oƂ̌M擾܂B
		/// </summary>
		protected const int MessageDebug = 1;

		/// <summary>
		/// fobN[hLłB
		/// </summary>
		public const int DebugStart = 1;
		/// <summary>
		/// fobN[hłB(l)
		/// </summary>
		public const int DebugEnd = 0;

		/// <summary>
		/// ڑ^CAEgLłB
		/// </summary>
		public const int ConnectTimeoutOn = 1;
		/// <summary>
		/// ڑ^CAEgłB(l)
		/// </summary>
		public const int ConnectTimeoutOff = 0;

		/// <summary>
		/// text/html p[gt@Cɕۑ܂B
		/// </summary>
		public const int SaveHtmlFileOn = 1;
		/// <summary>
		/// text/html p[gt@Cɕۑ܂B(l)
		/// </summary>
		public const int SaveHtmlFileOff = 0;

		/// <summary>
		/// {͑SăfR[h܂B(l)
		/// </summary>
		public const int DecodeBodyOn = 0;
		/// <summary>
		/// {͑SăfR[h܂B{̃eLXg iso-2022-jp ̂܂܂ƂȂ܂B
		/// </summary>
		public const int DecodeBodyAllOff = 1;
		/// <summary>
		/// eLXgp[g Content-Transfer-Encoding w̃GR[ĥ݃fR[h܂B
		/// </summary>
		public const int DecodeBodyTextOff = 2;
		/// <summary>
		/// wb_͑SăfR[h܂B(l)
		/// </summary>
		public const int DecodeHeaderOn = 0;
		/// <summary>
		/// wb_͑SăfR[h܂B
		/// </summary>
		public const int DecodeHeaderOff = 1;

		/// <summary>
		/// gpsȕƋ؂蕶u܂B(l)
		/// </summary>
		public const int ChangeSplitChar = 0;
		/// <summary>
		/// pXy[Xu܂B
		/// </summary>
		public const int ChangeHalfSpace = 1;
		/// <summary>
		/// SpXy[Xu܂B
		/// </summary>
		public const int ChangeFullSpace = 2;
		/// <summary>
		/// pESpXy[Xu܂B
		/// </summary>
		public const int ChangeAllSpace = 3;
		/// <summary>
		/// ؂蕶u܂B
		/// </summary>
		public const int ChangeNoSplitChar = 4;

		/// <summary>
		/// message/rfc822 p[g܂Ƃ߂ăt@Cɕۑ܂B
		/// </summary>
		public const int SaveRfc822FileAllOn = 2;
		/// <summary>
		/// message/rfc822 p[g̃eLXgt@Cɕۑ܂B
		/// </summary>
		public const int SaveRfc822FileBodyOn = 1;
		/// <summary>
		/// message/rfc822 p[gt@Cɕۑ܂B
		/// </summary>
		public const int SaveRfc822FileOff = 0;

		[DllImport("nMail.DLL", EntryPoint="NMailGetVersion")]
		protected static extern int GetVersion();

		[DllImport("nMail.DLL", EntryPoint="NMailGetOption")]
		protected static extern int GetOption(int option);

		[DllImport("nMail.DLL", EntryPoint="NMailSetOption")]
		protected static extern int SetOption(int option, int value);

		[DllImport("nMail.DLL", EntryPoint="NMailGetMessage", CharSet=CharSet.Auto)]
		protected static extern void GetMessage(int Type, StringBuilder Message, int Size);

		[DllImport("nMail.DLL", EntryPoint="NMailGetSuspendNumber", CharSet=CharSet.Auto)]
		protected static extern int GetSuspendNumber(string Path);

		/// <summary>
		/// fobN[hJn܂B
		/// </summary>
		/// <remarks>
		/// <see cref="EndDebug"/>Ăяo <see cref="DebugMessage"/>
		/// QƂ邱ƂɂăT[oƂ̌M擾ł܂B
		/// </remarks>
		public static void StartDebug()
		{
			SetOption(OptionDebugMode, DebugStart);
		}

		/// <summary>
		/// fobN[hI܂B
		/// </summary>
		/// <remarks>
		/// Ăяo <see cref="DebugMessage"/> QƂ邱ƂɂăT[o
		/// Ƃ̌M擾ł܂B
		/// </remarks>
		public static void EndDebug()
		{
			SetOption(OptionDebugMode, DebugEnd);
		}

		/// <summary>
		/// ڑ^CAEgݒLɂ܂B
		/// </summary>
		public static void EnableConnectTimeout()
		{
			SetOption(OptionConnectTimeout, ConnectTimeoutOn);
		}

		/// <summary>
		/// ڑ^CAEgݒ𖳌ɂ܂B(l)
		/// </summary>
		public static void DisableConnectTimeout()
		{
			SetOption(OptionConnectTimeout, ConnectTimeoutOff);
		}
		/// <summary>
		/// text/html p[gt@Cɕۑ܂B
		/// </summary>
		public static void EnableSaveHtmlFile()
		{
			SetOption(OptionSaveHtmlFile, SaveHtmlFileOn);
		}
		/// <summary>
		/// text/html p[gt@Cɕۑ܂B(l)
		/// </summary>
		public static void DisableSaveHtmlFile()
		{
			SetOption(OptionSaveHtmlFile, SaveHtmlFileOff);
		}
		/// <summary>
		/// {fR[h܂B(l)
		/// </summary>
		public static void EnableDecodeBody()
		{
			SetOption(OptionDecodeBody, DecodeBodyOn);
		}
		/// <summary>
		/// {fR[h܂B{̃eLXg iso-2022-jp ̂܂܂ƂȂ܂B
		/// </summary>
		public static void DisableDecodeBodyAll()
		{
			SetOption(OptionDecodeBody, DecodeBodyAllOff);
		}
		/// <summary>
		/// eLXgp[g Content-Transfer-Encoding w̃GR[ĥ݃fR[h܂B
		/// </summary>
		public static void DisableDecodeBodyText()
		{
			SetOption(OptionDecodeBody, DecodeBodyTextOff);
		}
		/// <summary>
		/// wb_fR[h܂B(l)
		/// </summary>
		public static void EnableDecodeHeader()
		{
			SetOption(OptionDecodeHeader, DecodeHeaderOn);
		}
		/// <summary>
		/// wb_fR[h܂B
		/// </summary>
		public static void DisableDecodeHeader()
		{
			SetOption(OptionDecodeHeader, DecodeHeaderOff);
		}
		/// <summary>
		/// message/rfc822 p[g܂Ƃ߂ăt@Cɕۑ܂B
		/// </summary>
		public static void EnableSaveRfc822FileAll()
		{
			SetOption(OptionSaveRfc822File, SaveRfc822FileAllOn);
		}
		/// <summary>
		/// message/rfc822 p[g̃eLXgt@Cɕۑ܂B
		/// </summary>
		public static void EnableSaveRfc822FileBody()
		{
			SetOption(OptionSaveRfc822File, SaveRfc822FileBodyOn);
		}
		/// <summary>
		/// message/rfc822 p[gt@Cɕۑ܂Bilj
		/// </summary>
		public static void DisableSaveRfc822File()
		{
			SetOption(OptionSaveRfc822File, SaveRfc822FileOff);
		}
		/// <summary>
		/// w肳ꂽt@CYt[𑗐Mꍇ̋x~񐔂𓾂
		/// </summary>
		/// <param name="file_name">Ytt@C</param>
		/// <exception cref="FileNotFoundException">
		/// file_name Őݒ肳Ăt@C݂܂B
		/// </exception>
		/// <value>w肳ꂽt@CYt[𑗐Mꍇ̋x~񐔂𓾂</value>
		public static int SuspendCount(String file_name)
		{
			if(!File.Exists(file_name)) {
				throw new FileNotFoundException(file_name);
			}
			return GetSuspendNumber(file_name);
		}

		/// <summary>
		/// o[W̐lłB
		/// </summary>
		/// <remarks>
		/// nMail.DLL ̃o[W̐lłB
		/// Version 1.23 ̏ꍇ 123 ƂȂ܂B
		/// </remarks>
		/// <value>o[Wl</value>
		public static int VersionInt
		{
			get
			{
				return GetVersion();
			}
		}
		/// <summary>
		/// o[W̕łB
		/// </summary>
		/// <remarks>
		/// nMail.DLL ̃o[W̕łB
		/// Version 1.23 ̏ꍇ "1.23" ƂȂ܂B
		/// </remarks>
		/// <value>o[W</value>
		public static string Version
		{
			get
			{
				string str;
				int ver = GetVersion();
				str = String.Format("{0:d}.{1:d}", ver / 100, ver % 100);
				return str;
			}
		}
		/// <summary>
		/// G[bZ[WłB
		/// </summary>
		/// <remarks>
		/// G[ɃT[oԂĂG[bZ[WłB
		/// </remarks>
		/// <value>G[bZ[W</value>
		public static string ErrorMessage
		{
			get
			{
				StringBuilder message;
				message = new StringBuilder(MessageSize);
				GetMessage(MessageError, message, MessageSize);
				return message.ToString();
			}
		}
		/// <summary>
		/// fobNpłB
		/// </summary>
		/// <remarks>
		/// <see cref="StartDebug"/>ĂяoɃ[̑MsA
		/// <see cref="EndDebug"/>Ăяoɂ̃vpeBQƂ邱
		/// ɂăT[oƂ̌M擾邱Ƃł܂B
		/// </remarks>
		/// <value>fobNp</value>
		public static string DebugMessage
		{
			get
			{
				StringBuilder message;
				message = new StringBuilder(MessageSize);
				GetMessage(MessageDebug, message, MessageSize);
				return message.ToString();
			}
		}
		/// <summary>
		/// ^CAEglłB
		/// </summary>
		/// <remarks>
		/// ̐ݒl蒷ԃT[o牞ꍇA
		/// ^CAEgG[ƂďԂ܂B
		/// Pʂ ms łB
		/// ڑ̃^CAEg͒ʏ͖łB
		/// LɂꍇA<see cref="EnableConnectTimeout"/>
		/// ĂяoĂB
		/// </remarks>
		/// <value>^CAEgl</value>
		public static int Timeout
		{
			get
			{
				return GetOption(OptionTimeout);
			}
			set
			{
				SetOption(OptionTimeout, value);
			}
		}
		/// <summary>
		/// wb_obt@TCYłB
		/// </summary>
		/// <remarks>
		/// [MYtt@CWJɃwb_f[^i[
		/// obt@̃TCYłB
		/// <see cref="Pop3"/>NXŃ[̎MsꍇA
		/// obt@TCY̐ݒs܂̂ŁÃvpeB
		/// gpKv͂܂B
		/// </remarks>
		/// <value>wb_obt@TCY</value>
		public static int HeaderMax
		{
			get
			{
				return GetOption(OptionHeaderMax);
			}
			set
			{
				SetOption(OptionHeaderMax, value);
			}
		}
		/// <summary>
		/// {obt@TCYłB
		/// </summary>
		/// <remarks>
		/// [MYtt@CWJɃwb_f[^i[
		/// {̃TCYłB
		/// <see cref="Pop3"/>NXŃ[̎MsꍇA
		/// [TCYɉobt@TCY̎ws܂̂ŁA
		/// ̃vpeBgpKv͂܂B
		/// </remarks>
		/// <value>{obt@TCY</value>
		public static int BodyMax
		{
			get
			{
				return GetOption(OptionBodyMax);
			}
			set
			{
				SetOption(OptionBodyMax, value);
			}
		}
		/// <summary>
		/// Ytt@CۑɁAwtH_ɓt@Cꍇ̏@łB
		/// </summary>
		/// <remarks>
		/// <see cref="FileOverwrite"/>t@C㏑܂B
		/// <see cref="FileRename"/>t@C̖(gq̑O)ɐǉĕۑ܂B
		/// <see cref="FileAlreadyError"/>t@C쐬G[Ƃ܂B
		/// </remarks>
		/// <value>Ytt@Cۑ̓t@C@</value>
		public static int AlreadyFile
		{
			get
			{
				return GetOption(OptionAlreadyFile);
			}
			set
			{
				SetOption(OptionAlreadyFile, value);
			}
		}
		/// <summary>
		/// fobN[h
		/// </summary>
		/// <remarks>
		/// <see cref="DebugStart"/>fobN[hLłB
		/// <see cref="DebugEnd"/>fobN[hłB
		/// </remarks>
		/// <value>fobN[h</value>
		public static int DebugMode
		{
			get
			{
				return GetOption(OptionDebugMode);
			}
			set
			{
				SetOption(OptionDebugMode, value);
			}
		}
		/// <summary>
		/// T[oڑ̃^CAEgLǂ̐ݒłB
		/// </summary>
		/// <remarks>
		/// <see cref="ConnectTimeoutOn"/>ڑ^CAEgLłB
		/// <see cref="ConnectTimeoutOff"/>ڑ^CAEgłB
		/// </remarks>
		/// <value>T[oڑLǂ̐ݒl</value>
		public static int ConnectTimeout
		{
			get
			{
				return GetOption(OptionConnectTimeout);
			}
			set
			{
				SetOption(OptionConnectTimeout, value);
			}
		}
		/// <summary>
		/// Ytt@C̋؂蕶łB
		/// </summary>
		/// <remarks>
		/// Ytt@Cꍇ̋؂蕶łB
		///	ftHgl , łB
		/// </remarks>
		/// <value>Ytt@C؂蕶</value>
		public static char SplitChar
		{
			get
			{
				return (char)GetOption(OptionSplitChar);
			}
			set
			{
				SetOption(OptionSplitChar, (int)value);
			}
		}
		/// <summary>
		/// M̍ۂɈU߂f[^TCYłB
		/// </summary>
		/// <remarks>
		/// Ytt@CꍇAŎw肵TCỸf[^
		/// MƁAU߂܂B
		/// </remarks>
		/// <value>M̍ۂɈU߂f[^TCY</value>
		public static int SuspendSize
		{
			get
			{
				return GetOption(OptionSuspendSize);
			}
			set
			{
				SetOption(OptionSuspendSize, value);
			}
		}
		/// <summary>
		/// T[o̕ԓ҂̍ۂɓ Sleep() ̎ԂłB
		/// </summary>
		/// <value>T[o̕ԓ҂̍ۂɓ Sleep() ̎</value>
		public static int SleepTime
		{
			get
			{
				return GetOption(OptionSleepTime);
			}
			set
			{
				SetOption(OptionSleepTime, value);
			}
		}
		/// <summary>
		/// tB[hobt@̃TCYłB
		/// </summary>
		/// <value>tB[hobt@̃TCY</value>
		public static int FieldMax
		{
			get
			{
				return GetOption(OptionFieldMax);
			}
			set
			{
				SetOption(OptionFieldMax, value);
			}
		}
		/// <summary>
		/// HTML [ text/html p[gt@Cۑ邩ǂ̐ݒłB
		/// </summary>
		/// <remarks>
		/// <see cref="SaveHtmlFileOff"/>text/html p[gt@CɕۑȂ(l)
		/// <see cref="SaveHtmlFileOn"/>text/html p[gt@Cɕۑ
		/// Attachment NXg text/html p[gt@CɕۑꍇA
		/// <see cref="DisableDecodeBodyText()"/> ܂ <see cref="DisableDecodeBodyAll()"/> Ăяo <see cref="Pop3.GetMail"/> œǂݏo
		/// {f[^gpA<see cref="Attachment.Save()"/> ̑O <see cref="EnableDecodeBody()"/>
		/// sĂKv܂B
		/// </remarks>
		/// <value>text/html p[gt@Cɕۑ邩ǂ̐ݒl</value>
		public static int SaveHtmlFile
		{
			get
			{
				return GetOption(OptionSaveHtmlFile);
			}
			set
			{
				SetOption(OptionSaveHtmlFile, value);
			}
		}
		/// <summary>
		/// {̃fR[h̐ݒłB
		/// </summary>
		/// <remarks>
		/// <see cref="DecodeBodyOn"/>SăfR[h܂B(l)
		/// <see cref="DecodeBodyAllOff"/>SăfR[h܂B{̃eLXg iso-2022-jp ̂܂܂ƂȂ܂B
		/// <see cref="DecodeBodyTextOff"/>eLXgp[g Content-Transfer-Encoding w̃GR[ĥ݃fR[h܂B
		/// </remarks>
		/// <value>{fR[h邩ǂ̐ݒl</value>
		public static int DecodeBody
		{
			get
			{
				return GetOption(OptionDecodeBody);
			}
			set
			{
				SetOption(OptionDecodeBody, value);
			}
		}
		/// <summary>
		/// wb_̃fR[h̐ݒłB
		/// </summary>
		/// <remarks>
		/// <see cref="DecodeHeaderOn"/>SăfR[h܂B(l)
		/// <see cref="DecodeHeaderOff"/>SăfR[h܂B
		/// </remarks>
		/// <value>wb_fR[h邩ǂ̐ݒl</value>
		public static int DecodeHeader
		{
			get
			{
				return GetOption(OptionDecodeHeader);
			}
			set
			{
				SetOption(OptionDecodeHeader, value);
			}
		}
		/// <summary>
		/// Ytt@Ci[obt@TCYłB
		/// </summary>
		/// <remarks>
		/// Ytt@Ci[obt@̃TCYłB
		/// <see cref="Pop3"/><see cref="Imap4"/>NXŃ[̎MsA
		/// <see cref="Attachment"/>NXœYtt@C̓WJsꍇA
		/// Ńobt@TCY̐ݒs܂̂ŁA
		/// ̃vpeBgpKv͂܂B
		/// </remarks>
		/// <value>Ytt@Ci[obt@TCY</value>
		public static int FileNameMax
		{
			get
			{
				return GetOption(OptionFileNameMax);
			}
			set
			{
				SetOption(OptionFileNameMax, value);
			}
		}
		/// <summary>
		/// Ytt@CɎgpłȂu镶
		/// </summary>
		/// <remarks>
		/// Ytt@CɎgpłȂu镶łB
		/// ftHgl _ łB
		/// </remarks>
		/// <value>u</value>
		public static char ChangeChar
		{
			get
			{
				return (char)GetOption(OptionChangeChar);
			}
			set
			{
				SetOption(OptionChangeChar, (int)value);
			}
		}
		/// <summary>
		/// Ytt@Cu
		/// </summary>
		/// <remarks>
		/// Ytt@CułB
		/// ftHgl<see cref="ChangeSplitChar"/>ŁA
		/// Windows Ńt@CɎgpłȂƁA؂蕶
		/// gpĂ镶u܂B
		/// </remarks>
		/// <value>u</value>
		public static int ChangeCharMode
		{
			get
			{
				return GetOption(OptionChangeCharMode);
			}
			set
			{
				SetOption(OptionChangeCharMode, value);
			}
		}
		/// <summary>
		/// message/rfc822 p[gt@Cɕۑ邩ǂ̐ݒłB
		/// </summary>
		/// <remarks>
		/// <see cref="SaveRfc822FileOff"/>message/rfc822 p[gt@CɕۑȂB(l)
		/// <see cref="SaveRfc822FileBodyOn"/>message/rfc822 p[g̃eLXgt@CɕۑB
		/// <see cref="SaveRfc822FileAllOn"/>message/rfc822 p[gSăt@CɕۑB
		/// SaveRfc822FileAllOn  message/rfc822 p[gSăt@CɕۑꍇA
		/// Attachment NXgēYtt@Coł܂B
		/// </remarks>
		/// <value>message/rfc822 p[gt@Cɕۑ邩ǂ̐ݒl</value>
		public static int SaveRfc822File
		{
			get
			{
				return GetOption(OptionSaveRfc822File);
			}
			set
			{
				SetOption(OptionSaveRfc822File, value);
			}
		}
	}

	/// <summary>
	/// IMAP4rev1 [MNX
	/// </summary>
	/// <remarks>
	/// <example>
	/// <para>
	///	[{bNX("inbox")̎w̃[ԍ(ϐ:no) MIME \擾AeLXgłΖ{\AYtt@Cł z:\temp ɕۑ܂B
	/// <code lang="cs">
	///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
	///		try {
	///			imap.Connect();
	///			imap.Authenticate("imap4_id", "password");
	///			imap.SelectMailBox("inbox");
	///			// MIME \擾
	///			imap.GetMimeStructure(no);
	///			nMail.Imap4.MimeStructureStatus [] list = imap4.GetMimeStructureList()
	///			foreach(nMail.Imap4.MimeStructureStatus mime in list)
	///			{
	///				// eLXgłΖ{擾ĕ\
	///				if(string.Compare(mime.Type, "text", true) == 0 &amp;&amp; string.Compare(mime.SubType, "plain", true) == 0)
	///				{
	///					// {擾
	///					imap.GetMimePart(no, mime.PartNo);
	///					MessageBox.Show(imap.Body);
	///				}
	///				else if(string.Compare(mime.Type, "multipart", true) != 0)
	///				{
	///					// Ytt@Cۑ
	///					imap.SaveMimePart(no, mime.PartNo, @"z:\temp\" + mime.FileName);
	///				}
	///			}
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
	///	Try
	///		imap.Connect()
	///		imap.Authenticate("imap4_id", "password")
	///		imap.SelectMailBox("inbox")
	///		' MIME \擾
	///		imap.GetMimeStructure(no)
	///		Dim list As nMail.Imap4.MimeStructureStatus() = imap4.GetMimeStructureList()
	///		For Each mime As nMail.Imap4.MimeStructureStatus In list
	///			' eLXgłΖ{擾ĕ\
	///			If (String.Compare(mime.Type, "text", True) = 0) And (String.Compare(mime.SubType, "plain", True) = 0) Then
	///				' {擾
	///				imap.GetMimePart(no, mime.PartNo)
	///				MessageBox.Show(imap.Body)
	///			Else If String.Compare(mime.Type, "multipart", true) &lt;&gt; 0 Then
	///				' Ytt@Cۑ
	///				imap.SaveMimePart(no, mime.PartNo, "z:\temp\" + mime.FileName)
	///			End If
	///		Next
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		imap.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// <para>
	/// [{bNX("inbox")̎w̃[ԍ(ϐ:no)擾AƖ{\B
	/// ق Attachment NXœYtt@CWJꍇ text/html p[gt@CɕۑꍇA
	/// <see cref="Options.DisableDecodeBodyText()"/>  <see cref="Options.DisableDecodeBodyAll()"/>Ăł<see cref="GetMail"/>Ŏ擾wb_і{f[^gpKv܂B
	/// <code lang="cs">
	///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
	///		try {
	///			imap.Connect();
	///			imap.Authenticate("imap4_id", "password");
	///		    imap.SelectMailBox("inbox");
	///			imap.GetMail(no);
	///			MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}\r\n{2:s}", no, imap.Subject, imap.Body));
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	/// Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
	/// Try
	/// 	imap.Connect()
	/// 	imap.Authenticate("imap4_id", "password")
	///		imap.SelectMailBox("inbox")
	///		imap.GetMail(no)
	///		MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}" + ControlChars.CrLf + "{2:s}", no, imap.Subject, imap.Body))
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		imap.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// <para>
	/// STARTTLS gpă[{bNX("inbox")̎w̃[ԍ(ϐ:no)擾AƖ{\B
	/// <code lang="cs">
	///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
	///		try {
	///			imap.SSL = nMail.Imap4.STARTTLS;
	///			imap.Connect();				// STARTTLS ̏ꍇʏ IMAP4 |[gԍŐڑ
	///			imap.Authenticate("imap4_id", "password");
	///		    imap.SelectMailBox("inbox");
	///			imap.GetMail(no);
	///			MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}\r\n{2:s}", no, imap.Subject, imap.Body));
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	/// Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
	/// Try
	/// 	imap.SSL = nMail.Imap4.STARTTLS
	/// 	imap.Connect()					' STARTTLS ̏ꍇʏ IMAP4 |[gԍŐڑ
	/// 	imap.Authenticate("imap4_id", "password")
	///		imap.SelectMailBox("inbox")
	///		imap.GetMail(no)
	///		MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}" + ControlChars.CrLf + "{2:s}", no, imap.Subject, imap.Body))
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		imap.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// <para>
	/// [{bNX("inbox")̎w̃[ԍ(ϐ:no)擾AƖ{\BYtt@C z:\temp ɕۑB
	/// text/html p[gt@CɕۑꍇA<see cref="GetMail"/> ̑O <see cref="Options.EnableSaveHtmlFile()"/> ĂłKv܂B
	/// ۑ text/html p[g̃t@C <see cref="HtmlFile"/> Ŏ擾ł܂B
	/// <code lang="cs">
	///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
	///		try {
	///			imap.Connect();
	///			imap.Authenticate("imap4_id", "password");
	///		    imap.SelectMailBox("inbox");
	///			imap.Path = @"z:\temp";
	///			imap.GetMail(no);
	///			MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}\r\n{2:s}", no, imap.Subject, imap.Body));
	///			string [] file_list = imape.GetFileNameList();
	///			if(file_list.Length == 0)
	///			{
	///				MessageBox.Show("t@C͂܂");
	///			}
	///			else
	///			{
	///				foreach(string name in file_list)
	///				{
	///					MessageBox.Show(String.Format("Ytt@C:{0:s}", name));
	///				}
	///			}
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	/// Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
	/// Try
	/// 	imap.Connect()
	/// 	imap.Authenticate("imap4_id", "password")
	///		imap.SelectMailBox("inbox")
	///		imap.Path = "z:\temp"
	///		imap.GetMail(no)
	///		MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}" + ControlChars.CrLf + "{2:s}", no, imap.Subject, imap.Body))
	///		Dim file_list As String() = imap.GetFileNameList()
	///		If file_list.Length = 0 Then
	///			MessageBox.Show("t@C͂܂")
	///		Else
	///			For Each name As String In file_list
	///				MessageBox.Show(String.Format("Ytt@C:{0:s}", name))
	///			Next fno
	///		End If
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		imap.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// <para>
	///	ꎞx~@\gă[{bNX("inbox")̎w̃[ԍ(ϐ:no)擾AƖ{\BYtt@C z:\temp ɕۑB
	/// <code lang="cs">
	///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
	///		try {
	///			imap.Connect();
	///			imap.Authenticate("imap4_id", "password");
	///			imap.SelectMailBox("inbox");
	///			// ̋x~񐔂𓾂
	///			int count = imap.GetSize(no) / (nMail.Options.SuspendSize * 1024) + 1;
	///			imap.Path = @"z:\temp";
	///			imap.GetMail(no);
	///			imap.Flag = nMail.Imap4.SuspendAttachmentFile;
	///			imap.GetMail(no);
	///			imap.Flag = nMail.Imap4.SuspendNext;
	///			while(imap.ErrorCode == nMail.Imap4.ErrorSuspendAttachmentFile)
	///			{
	///				imap.GetMail(no);
	///				// vOXo[i߂铙̏
	///				Application.DoEvents();
	///			}
	///			MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}\r\n{2:s}", no, imap.Subject, imap.Body));
	///			string [] file_list = imape.GetFileNameList();
	///			if(file_list.Length == 0)
	///			{
	///				MessageBox.Show("t@C͂܂");
	///			}
	///			else
	///			{
	///				foreach(string name in file_list)
	///				{
	///					MessageBox.Show(String.Format("Ytt@C:{0:s}", name));
	///				}
	///			}
	///		}
	///		catch(nMail.nMailException nex)
	///		{
	///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
	///		}
	///		catch(Exception ex)
	///		{
	///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
	///		}
	///	}
	/// </code>
	/// <code lang="vbnet">
	///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
	///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
	///	Try
	///		Dim count As Integer
	///
	///		imap.Connect()
	///		imap.Authenticate("imap4_id", "password")
	///		imap.SelectMailBox("inbox");
	///		' ̋x~񐔂𓾂
	///		count = imap.GetSize(no) \ (nMail.Options.SuspendSize * 1024) + 1
	///		imap.Path = "z:\temp"
	///		imap.Flag = nMail.Imap4.SuspendAttachmentFile
	///		imap.GetMail(no)
	///		imap.Flag = nMail.Imap4.SuspendNext
	///		Do While imap.ErrorCode = nMail.Imap4.ErrorSuspendAttachmentFile
	///			imap.GetMail(no)
	///			' vOXo[i߂铙̏
	///			Application.DoEvents()
	///		Loop
	///		MessageBox.Show(String.Format("[ԍ:{0:d} :{1:s}" + ControlChars.CrLf + "{2:s}", no, imap.Subject, imap.Body))
	///		Dim file_list As String() = imap.GetFileNameList()
	///		If file_list.Length = 0 Then
	///			MessageBox.Show("t@C͂܂")
	///		Else
	///			For Each name As String In file_list
	///				MessageBox.Show(String.Format("Ytt@C:{0:s}", name))
	///			Next fno
	///		End If
	///	Catch nex As nMail.nMailException
	///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
	///	Catch ex As Exception
	///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
	///	Finally
	///		imap.Dispose()
	///	End Try
	/// </code>
	/// </para>
	/// </example>
	/// </remarks>
	public class Imap4 : IDisposable
	{
		/// <summary>
		/// wb_̈̃TCYłB
		/// </summary>
		protected const int HeaderSize = 32768;
		/// <summary>
		/// pX̃TCYłB
		/// </summary>
		protected const int MaxPath = 32768;
		/// <summary>
		/// \PbgG[͖ڑԂłBl -1 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="Connect"/>Ăяo<see cref="GetMail"/>A</para>
		/// <para>ĂяoAȂ炩̗RŐڑؒfƂ̃G[ƂȂ܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorSocket = -1;
		/// <summary>
		/// F؃G[łBl -2 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="Authenticate"/>ĂяoŔF؂Ɏsꍇ</para>
		/// <para>̃G[ƂȂ܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorAuthenticate = -2;
		/// <summary>
		/// ԍŎw肳ꂽ[݂܂Bl -3 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetMail"/>Ŏw肵ԍ̃[݂ȂƂ̃G[ƂȂ܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorInvalidNo = -3;
		/// <summary>
		/// ^CAEgG[łBl -4 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="Options.Timeout"/>Ŏw肵l蒷ԃT[o牞</para>
		/// <para>ȂꍇÃG[܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorTimeout = -4;
		/// <summary>
		/// Ytt@CJ܂Bl -5 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="Path"/>Ŏw肵tH_ɓYtt@C߂Ȃ</para>
		/// <para>ȂꍇÃG[܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorFileOpen = -5;
		/// <summary>
		/// Ytt@CƓ̃t@CtH_ɑ݂܂Bl -7 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="nMail.Options.AlreadyFile"/>  <see cref="nMail.Options.FileAlreadyError"/></para>
		/// <para>ݒ肵A<see cref="Path"/>Ŏw肵tH_ɓYtt@CƓÕt@C</para>
		/// <para>ꍇɂ̃G[܂B</para>
		/// <para><see cref="nMailException.ErrorCode"/>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorFileAlready = -7;
		/// <summary>
		/// T[ow肵F،`ɑΉĂ܂Bl -8 łB
		/// </summary>
		public const int ErrorAuthenticateNoSupport = -8;
		/// <summary>
		/// mۃG[łBl -9 łB
		/// </summary>
		/// <remarks>
		/// ŕR[hϊ邽߂̃mۂł܂łB
		/// </remarks>
		public const int ErrorMemory = -9;
		/// <summary>
		/// ̑̃G[łBl -10 łB
		/// </summary>
		public const int ErrorEtc = -10;
		/// <summary>
		/// p[^܂Bl -11 łB
		/// </summary>
		/// <remarks>
		/// p[^܂B
		/// </remarks>
		public const int ErrorInvalidParameter = -11;
		/// <summary>
		/// IMAP4 T[oG[Bl -12 łB
		/// </summary>
		/// <remarks>
		/// IMAP4 T[o NO Ԃ܂B
		/// </remarks>
		public const int ErrorResponseNo = -12;
		/// <summary>
		/// IMAP4 T[oG[Bl -13 łB
		/// </summary>
		/// <remarks>
		/// IMAP4 T[o Bad Ԃ܂B
		/// </remarks>
		public const int ErrorResponseBad = -13;
		/// <summary>
		/// OԂ݂܂Bl -14 łB
		/// </summary>
		public const int ErrorNoNameSpace = -14;
		/// <summary>
		/// Ytt@CMł܂c肪ԂłBl -20 łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="Flag"/><see cref="SuspendAttachmentFile"/>܂</para>
		/// <para><see cref="SuspendNext"/>w肵<see cref="GetMail"/></para>
		/// <para>ĂяoꍇA܂[̎c肪ꍇA<see cref="nMailException.ErrorCode"/></para>
		/// <para>ɐݒ肳܂B</para>
		/// </remarks>
		public const int ErrorSuspendAttachmentFile = -20;
		/// <summary>
		/// Y鍀ڂ܂Bl -21 łB
		/// </summary>
		/// <remarks>
		/// Y鍀ڂ݂͑܂B
		/// </remarks>
		public const int ErrorNoResult = -21;
		/// <summary>
		/// F؂ PLAIN gp܂B
		/// </summary>
		public const int AuthPlain = 1;
		/// <summary>
		/// F؂ LOGIN gp܂B
		/// </summary>
		public const int AuthLogin = 2;
		/// <summary>
		/// F؂ CRAM MD5 gp܂B
		/// </summary>
		public const int AuthCramMd5 = 4;
		/// <summary>
		/// F؂ DIGEST MD5 gp܂B
		/// </summary>
		public const int AuthDigestMd5 = 8;
		/// <summary>
		/// s
		/// </summary>
		/// <para>e탁\bhԂꍇA<see cref="nMailException.ErrorCode"/>ɐݒ肳lłB</para>
		public const int Success = 1;
		/// <summary>
		/// Ytt@CMňꎞx~̈ڂɎw肵܂B
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		/// </remarks>
		public const int SuspendAttachmentFile = 4;
		/// <summary>
		/// Ytt@CMňꎞx~̓ڈȍ~Ɏw肵܂B
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetMail"/>̑OɁA<see cref="Flag"/>ɐݒ肵Ă܂B</para>
		/// </remarks>
		public const int SuspendNext = 8;
		/// <summary>
		/// [ǉɓtB[h nMail.DLL Ő܂B
		/// </summary>
		public const int AddDateField = 1;
		/// <summary>
		/// [ǉMessage-ID tB[h nMail.DLL Ő܂B
		/// </summary>
		public const int AddMessageId = 2;
		/// <summary>
		/// MIME p[gۑň̃pXŃt@Cw肵܂B
		/// </summary>
		private const int MimeSaveAsFile = 0x0800;
		/// <summary>
		/// MIME p[g擾ŊǃtO𗧂Ă܂B
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetMimePart"/>̑OɁA<see cref="MimeFlag"/>ɐݒ肵Ă܂B</para>
		/// </remarks>
		public const int MimePeek = 0x1000;
		/// <summary>
		/// MIME p[g擾ŃfR[h܂B
		/// </summary>
		/// <remarks>
		/// <para><see cref="GetMimePart"/>̑OɁA<see cref="MimeFlag"/>ɐݒ肵Ă܂B</para>
		/// </remarks>
		public const int MimeNoDecode = 0x2000;
		/// <summary>
		/// MIME p[g擾Ńwb_̂ݎ擾܂B
		/// </summary>
		private const int MimeHeader = 0x4000;
		/// <summary>
		/// [ԍł͂Ȃ UID gp܂B
		/// </summary>
		public const int UseUidValue = 0x8000;
		/// <summary>
		/// [{bNXtO@IłȂ[{bNXłB
		/// </summary>
		public const int MailBoxNoSelect = 1;
		/// <summary>
		/// [{bNXtO@q[{bNX쐬ł܂B
		/// </summary>
		public const int MailBoxNoInferious = 2;
		/// <summary>
		/// [{bNXtO@bZ[WǉĂ\܂B
		/// </summary>
		public const int MailBoxMarked = 4;
		/// <summary>
		/// [{bNXtO@bZ[WǉĂ܂B
		/// </summary>
		public const int MailBoxUnMarked = 8;
		/// <summary>
		/// [{bNXtO@q[{bNX݂܂B
		/// </summary>
		public const int MailBoxChildren = 16;
		/// <summary>
		/// [{bNXtO@q[{bNX݂܂B
		/// </summary>
		public const int MailBoxNoChildren = 32;
		/// <summary>
		/// [bZ[WtO@ԐMς݃tOtłB
		/// </summary>
		public const int MessageAnswerd = 1;
		/// <summary>
		/// [bZ[WtO@}[NtłB
		/// </summary>
		public const int MessageDeleted = 2;
		/// <summary>
		/// [bZ[WtO@etOtłB
		/// </summary>
		public const int MessageDraft = 4;
		/// <summary>
		/// [bZ[WtO@dvtOtłB
		/// </summary>
		public const int MessageFlagged = 8;
		/// <summary>
		/// [bZ[WtO@tOtłB
		/// </summary>
		public const int MessageRecent = 16;
		/// <summary>
		/// [bZ[WtO@ǃtOtłB
		/// </summary>
		public const int MessageSeen = 32;
		/// <summary>
		/// [@ԐMς
		/// </summary>
		public const int SearchAnswered = 1;
		/// <summary>
		/// [@ԐMς݂łȂ
		/// </summary>
		public const int SearchUnAnswered = 2;
		/// <summary>
		/// [@}[Nt
		/// </summary>
		public const int SearchDeleted = 3;
		/// <summary>
		/// [@}[NȂ
		/// </summary>
		public const int SearchUnDeleted = 4;
		/// <summary>
		/// [@etO
		/// </summary>
		public const int SearchDraft = 5;
		/// <summary>
		/// [@etOȂ
		/// </summary>
		public const int SearchUnDraft = 6;
		/// <summary>
		/// [@dvtO
		/// </summary>
		public const int SearchFlagged = 7;
		/// <summary>
		/// [@dvtOȂ
		/// </summary>
		public const int SearchUnFlagged = 8;
		/// <summary>
		/// [@tO
		/// </summary>
		public const int SearchRecent = 9;
		/// <summary>
		/// [@tOȂ
		/// </summary>
		public const int SearchUnRecent = 10;
		/// <summary>
		/// [@ǃtO
		/// </summary>
		public const int SearchSeen = 11;
		/// <summary>
		/// [@ǃtOȂ
		/// </summary>
		public const int SearchUnSeen = 12;
		/// <summary>
		/// [@tO肩ǃtOȂ
		/// </summary>
		public const int SearchNew = 13;
		/// <summary>
		/// [@SẴ[
		/// </summary>
		public const int SearchAll = 14;
		/// <summary>
		/// [@w肳ꂽL[[h
		/// </summary>
		public const int SearchKeyword = 15;
		/// <summary>
		/// [@w肳ꂽL[[hȂ
		/// </summary>
		public const int SearchUnKeyword = 16;
		/// <summary>
		/// [@From wb_Ɏw̕񂠂
		/// </summary>
		public const int SearchFrom = 17;
		/// <summary>
		/// [@To wb_Ɏw̕񂠂
		/// </summary>
		public const int SearchTo = 18;
		/// <summary>
		/// [@CC wb_Ɏw̕񂠂
		/// </summary>
		public const int SearchCc = 19;
		/// <summary>
		/// [@BCC wb_Ɏw̕񂠂
		/// </summary>
		public const int SearchBcc = 20;
		/// <summary>
		/// [@SUBJECT wb_Ɏw̕񂠂
		/// </summary>
		public const int SearchSubject = 21;
		/// <summary>
		/// [@DATE wb_w肳ꂽNȑO
		/// </summary>
		public const int SearchSentBefore = 22;
		/// <summary>
		/// [@DATE wb_w肳ꂽN
		/// </summary>
		public const int SearchSentOn = 23;
		/// <summary>
		/// [@DATE wb_w肳ꂽNȍ~
		/// </summary>
		public const int SearchSentSince = 24;
		/// <summary>
		/// [@w肳ꂽNȑOɓ
		/// </summary>
		public const int SearchBefore = 25;
		/// <summary>
		/// [@w肳ꂽNɓ
		/// </summary>
		public const int SearchOn = 26;
		/// <summary>
		/// [@w肳ꂽNȍ~ɓ
		/// </summary>
		public const int SearchSince = 27;
		/// <summary>
		/// [@w肳ꂽwb_tB[hɕ܂ "wb_tB[h "Ǝw肵Ă
		/// </summary>
		public const int SearchHeader = 28;
		/// <summary>
		/// [@{ɕ܂
		/// </summary>
		public const int SearchBody = 29;
		/// <summary>
		/// [@wb_і{ɕ܂
		/// </summary>
		public const int SearchText = 30;
		/// <summary>
		/// [@wTCY傫ȃ[
		/// </summary>
		public const int SearchLager = 31;
		/// <summary>
		/// [@wTCY菬ȃ[
		/// </summary>
		public const int SearchSmaller = 32;
		/// <summary>
		/// [@w UID ̃[
		/// </summary>
		public const int SearchUid = 33;
		/// <summary>
		/// [@𒼐ڎw
		/// </summary>
		public const int SearchCommand = 0x0100;
		/// <summary>
		/// [@ NOT
		/// </summary>
		public const int SearchNot = 0x0200;
		/// <summary>
		/// [@ OR
		/// </summary>
		public const int SearchOr = 0x0400;
		/// <summary>
		/// [@ AND
		/// </summary>
		public const int SearchAnd = 0x0800;
		/// <summary>
		/// [@[N
		/// </summary>
		public const int SearchFirst = 0x1000;
		/// <summary>
		/// [@R}hsシɖ߂
		/// </summary>
		public const int SearchNoWait = 0x2000;
		/// <summary>
		/// [@ʃ`FbN
		/// </summary>
		public const int SearchCheck = 0x4000;
		/// <summary>
		/// lO
		/// </summary>
		private const int NameSpacePersonal = 0;
		/// <summary>
		/// lO
		/// </summary>
		private const int NameSpaceOther = 1;
		/// <summary>
		/// LO
		/// </summary>
		private const int NameSpaceShared = 2;
		/// <summary>
		/// OԐ
		/// </summary>
		private const int NameSpaceMax = 3;
		/// <summary>
		/// lO 擾
		/// </summary>
		private const int NameSpacePersonalCount = 0x1000;
		/// <summary>
		/// lO 擾
		/// </summary>
		private const int NameSpaceOtherCount = 0x2000;
		/// <summary>
		/// LO 擾
		/// </summary>
		private const int NameSpaceSharedCount = 0x3000;
		/// <summary>
		/// lO ʎ擾
		/// </summary>
		private const int NameSpacePersonalNo = 0x0100;
		/// <summary>
		/// lO ʎ擾
		/// </summary>
		private const int NameSpaceOtherNo = 0x0200;
		/// <summary>
		/// LO ʎ擾
		/// </summary>
		private const int NameSpaceSharedNo = 0x0300;
		/// <summary>
		/// [bZ[WtOǉ܂B
		/// </summary>
		private const int AddMessage = 1;
		/// <summary>
		/// [bZ[WtO폜܂B
		/// </summary>
		private const int DeleteMessage = 2;
		/// <summary>
		/// [bZ[WtOu܂B
		/// </summary>
		private const int ReplaceMessage = 3;
		/// <summary>
		/// [{bNX̑bZ[W擾܂B
		/// </summary>
		private const int MailBoxMessage = 1;
		/// <summary>
		/// [{bNX̐VbZ[W擾܂B
		/// </summary>
		private const int MailBoxRecent = 2;
		/// <summary>
		/// [{bNX̐VbZ[W UID 擾܂B
		/// </summary>
		private const int MailBoxNextUid = 3;
		/// <summary>
		/// [{bNX UID Validity l擾܂B
		/// </summary>
		private const int MailBoxUidValidity = 4;
		/// <summary>
		/// [{bNX̖ǃbZ[W擾܂B
		/// </summary>
		private const int MailBoxUnSeen = 5;
		/// <summary>
		/// {fB\ ԍ
		/// </summary>
		private const int ContentPart = 0;
		/// <summary>
		/// {fB\ Content-Type ^Cv
		/// </summary>
		private const int ContentType = 1;
		/// <summary>
		/// {fB\ Content-Type Tu^Cv
		/// </summary>
		private const int ContentSubType = 2;
		/// <summary>
		/// {fB\ Content-Id
		/// </summary>
		private const int ContentId = 3;
		/// <summary>
		/// {fB\ Content-Description
		/// </summary>
		private const int ContentDescription = 4;
		/// <summary>
		/// {fB\ Content-Transfer-Encoding
		/// </summary>
		private const int ContentTransferEncoding = 5;
		/// <summary>
		/// {fB\ t@C
		/// </summary>
		private const int ContentFileName = 6;
		/// <summary>
		/// {fB\ Content-Type ^CvTu^Cv
		/// </summary>
		private const int ContentTypeAndSubType = 7;
		/// <summary>
		/// {fB\ {fBTCY
		/// </summary>
		private const int ContentSize = 8;
		/// <summary>
		/// {fB\ {fBs
		/// </summary>
		private const int ContentLine = 9;
		/// <summary>
		/// {fB\ Content-Type p[^
		/// </summary>
		private const int ContentParameterCount = 10;
		/// <summary>
		/// {fB\ Content-Type p[^
		/// </summary>
		private const int ContentParameter = 11;
		/// <summary>
		/// SMTP 
		/// </summary>
		private const int MakeDateSmtp = 0x00000;
		/// <summary>
		/// IMAP4 
		/// </summary>
		private const int MakeDateImap4 = 0x10000;
		/// <summary>
		/// ݓ
		/// </summary>
		private const int MakeDateNow = 0x20000;
		/// <summary>
		/// ^C][w {
		/// </summary>
		private const int MakeDateTimeZonePlus = 0x40000;
		/// <summary>
		/// ^C][w [
		/// </summary>
		private const int MakeDateTimeZoneMinus = 0x80000;
		/// <summary>
		/// SMTP(RFC2822)擾܂B: "Fri, 9 Jul 2009 15:10:30 +0900
		/// </summary>
		private const int DateTimeSmtp = 0x0000;
		/// <summary>
		/// IMAP4t(RFC2060)擾܂Bp : "09-Jul-2009"
		/// </summary>
		private const int DateImap4 = 0x8000;
		/// <summary>
		/// IMAP4(RFC2060)擾܂BAppendp : "09-Jul-2009 15:10:30"
		/// </summary>
		private const int DateTimeImap4 = 0x8000;
		/// <summary>
		/// ̃obt@TCYłB
		/// </summary>
		private const int DateStringSize = 34;
		/// <summary>
		/// SSLv3 gp܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int SSL3 = 0x1000;
		/// <summary>
		/// TSLv1 gp܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int TLS1 = 0x2000;
		/// <summary>
		/// STARTTLS gp܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int STARTTLS = 0x4000;
		/// <summary>
		/// T[oؖ؂łG[ɂ܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int IgnoreNotTimeValid = 0x0800;
		/// <summary>
		/// [gؖłG[ɂ܂B
		/// </summary>
		/// <remarks>
		/// <see cref="SSL"/>Ŏw肵܂B
		/// </remarks>
		public const int AllowUnknownCA = 0x0400;
		/// <summary>
		/// IMAP4 ̕W|[gԍł
		/// </summary>
		public const int StandardPortNo = 143;
		/// <summary>
		/// IMAP4 over SSL ̃|[gԍł
		/// </summary>
		public const int StandardSslPortNo = 993;

		/// <summary>
		/// IMAP4 |[gԍłB
		/// </summary>
		protected int _port = 143;
		/// <summary>
		/// \PbgnhłB
		/// </summary>
		protected IntPtr _socket = (IntPtr)ErrorSocket;
		/// <summary>
		/// [łB
		/// </summary>
		protected int _count = -1;
		/// <summary>
		/// [TCYłB
		/// </summary>
		protected int _size = -1;
		/// <summary>
		/// wb_[TCYłB
		/// </summary>
		protected int _header_size = -1;
		/// <summary>
		/// {̃TCYłB
		/// </summary>
		protected int _body_size = -1;
		/// <summary>
		/// [M̐ݒptOłB
		/// </summary>
		protected int _flag = 0;
		/// <summary>
		/// [bZ[W̃tOłB
		/// </summary>
		protected int _message_flag = 0;
		/// <summary>
		/// [w肷ۂ UID gp܂B
		/// </summary>
		protected bool _useuid_flag = false;
		/// <summary>
		/// MIME p[g擾͕ۑ̍ۂ̐ݒtOłB
		/// </summary>
		protected int _mime_flag = 0;
		/// <summary>
		/// [w肷ۂ UID gp܂B
		/// </summary>
		protected int _useuid = 0;
		/// <summary>
		/// G[ԍłB
		/// </summary>
		protected int _err = 0;
		/// <summary>
		/// IMAP4 F،`
		/// </summary>
		protected int _mode = AuthLogin;
		/// <summary>
		/// IMAP4 T[ołB
		/// </summary>
		protected string _host = "";
		/// <summary>
		/// IMAP4 [U[łB
		/// </summary>
		protected string _id = "";
		/// <summary>
		/// IMAP4 pX[hłB
		/// </summary>
		protected string _password = "";
		/// <summary>
		/// [{bNXłB
		/// </summary>
		protected string _mailbox = "";
		/// <summary>
		/// Ytt@Cۑp̃pXłB
		/// </summary>
		protected string _path = null;
		/// <summary>
		/// wb_tB[hłB
		/// </summary>
		protected string _field_name = "";
		/// <summary>
		/// {i[obt@łB
		/// </summary>
		protected StringBuilder _body = null;
		/// <summary>
		/// i[obt@łB
		/// </summary>
		protected StringBuilder _subject = null;
		/// <summary>
		/// tۑobt@łB
		/// </summary>
		protected StringBuilder _date = null;
		/// <summary>
		/// oli[obt@łB
		/// </summary>
		protected StringBuilder _from = null;
		/// <summary>
		/// wb_i[obt@łB
		/// </summary>
		protected StringBuilder _header = null;
		/// <summary>
		/// Ytt@Ci[obt@łB
		/// </summary>
		protected StringBuilder _filename = null;
		/// <summary>
		/// Ytt@C̃XgłB
		/// </summary>
		protected string[] _filename_list = null;
		/// <summary>
		/// wb_tB[hei[obt@łB
		/// </summary>
		protected StringBuilder _field = null;
		/// <summary>
		/// UID łB
		/// </summary>
		protected uint _uid = 0;
		/// <summary>
		/// Dispose sǂ̃tOłB
		/// </summary>
		private bool _disposed = false;
		/// <summary>
		/// text/html p[gۑt@C̖OłB
		/// </summary>
		protected StringBuilder _html_file = null;
		/// <summary>
		/// SSL ݒtOłB
		/// </summary>
		protected int _ssl = 0;
		/// <summary>
		/// SSL NCAgؖłB
		/// </summary>
		protected string _cert_name = null;
		/// <summary>
		/// message/rfc822 p[gۑt@C̖OłB
		/// </summary>
		protected StringBuilder _rfc822_file = null;

		/// <summary>
		/// [{bNXłB
		/// </summary>
		/// <remarks>
		/// <see cref="GetMailBoxList"/><see cref="GetMailBoxListSubscribe"/>̌ʂi[\̂łB
		/// </remarks>
		public struct MailBoxStatus
		{
			/// <summary>
			/// [{bNXtOłB
			/// </summary>
			/// <remarks>
			/// <para><see cref="MailBoxNoSelect"/>IłȂ[{bNXł</para>
			/// <para><see cref="MailBoxNoInferious"/>q[{bNX쐬ł܂</para>
			/// <para><see cref="MailBoxMarked"/>bZ[WǉĂ\܂</para>
			/// <para><see cref="MailBoxUnMarked"/>bZ[WǉĂ܂</para>
			/// <para><see cref="MailBoxChildren"/>q[{bNX݂܂</para>
			/// <para><see cref="MailBoxNoChildren"/>q[{bNX݂܂</para>
			/// </remarks>
			public int Flag;
			/// <summary>
			/// [{bNXłB
			/// </summary>
			public string Name;
			/// <summary>
			/// [{bNX؂蕶łB
			/// </summary>
			public char Separate;
		}
		/// <summary>
		/// [{bNX񃊃XgłB
		/// </summary>
		/// <remarks>
		/// <see cref="GetMailBoxList"/><see cref="GetMailBoxListSubscribe"/>sɌʂi[܂B
		/// </remarks>
		protected MailBoxStatus[] _mailbox_list = null;
		/// <summary>
		/// MIME \ Content-Type tB[h̃p[^łB
		/// </summary>
		/// <remarks>
		/// MIME \ Content-Type tB[h̃p[^łB
		/// MIME \ <see cref="MimeStructureStatus"/> Ɋ܂܂܂B
		/// </remarks>
		public struct MimeParameterStatus
		{
			/// <summary>
			/// p[^̂łB
			/// </summary>
			public string Name;
			/// <summary>
			/// p[^̒lłB
			/// </summary>
			public string Value ;
		}
		/// <summary>
		/// MIME \łB
		/// </summary>
		/// <remarks>
		/// <see cref="GetMimeStructure"/>̌ʂi[\̂łB
		/// </remarks>
		public struct MimeStructureStatus
		{
			/// <summary>
			/// MIME p[gԍłB
			/// </summary>
			/// <remarks>
			/// <see cref="GetMimePart"/><see cref="SaveMimePart"/> part_no Ŏw肷lłB
			/// </remarks>
			public int PartNo;
			/// <summary>
			/// MIME \\łB
			/// </summary>
			public string Part;
			/// <summary>
			/// Content-Type tB[h̃^CvłB
			/// </summary>
			public string Type;
			/// <summary>
			/// Content-Type tB[h̃Tu^CvłB
			/// </summary>
			public string SubType;
			/// <summary>
			/// Contetn-ID tB[h̒lłB
			/// </summary>
			public string Id;
			/// <summary>
			/// Content-Description tB[h̒lłB
			/// </summary>
			public string Description;
			/// <summary>
			/// Content-Transfer-Encoding tB[h̒lłB
			/// </summary>
			public string Encoding;
			/// <summary>
			/// Ytt@CłB(fR[hς)
			/// </summary>
			public string FileName;
			/// <summary>
			/// MIME p[g̃TCYłB
			/// </summary>
			public int Size;
			/// <summary>
			/// MIME p[g̍słB^Cv text ̏ꍇ̂ݐl܂B
			/// </summary>
			public int Line;
			/// <summary>
			/// Content-Type ̃p[^XgłB
			/// </summary>
			public MimeParameterStatus[] Parameter;
		}
		/// <summary>
		/// MIME \񃊃XgłB
		/// </summary>
		/// <remarks>
		/// <see cref="GetMimeStructure"/>sɌʂi[܂B
		/// </remarks>
		protected MimeStructureStatus[] _mime_list = null;
		/// <summary>
		/// ʂ̃XgłB
		/// </summary>
		/// <remarks>
		/// <see cref="Search"/>sɌʂi[܂B
		/// </remarks>
		protected uint[] _search_list = null;
		/// <summary>
		/// ŏ̌ǂ̃tOłB
		/// </summary>
		protected bool _search_first_flag = true;
		/// <summary>
		/// OԏłB
		/// </summary>
		/// <remarks>
		/// <see cref="GetNameSpace"/>̌ʂi[\̂łB
		/// </remarks>
		public struct NameSpaceStatus
		{
			/// <summary>
			/// OԂ̃vtBbNXłB
			/// </summary>
			public string Name;
			/// <summary>
			/// OԂ̋؂蕶łB
			/// </summary>
			public char Separate;
		}
		/// <summary>
		/// Oԏ񃊃XgłB
		/// </summary>
		/// <remarks>
		/// <see cref="GetNameSpace"/>sɌʂi[܂B
		/// </remarks>
		protected NameSpaceStatus[][] _namespace_list = new NameSpaceStatus[NameSpaceMax][];

		/// <summary>
		/// <c>Imap4</c>NX̐VKCX^X܂B
		/// </summary>
		public Imap4()
		{
			Init();
		}
		/// <summary>
		/// <c>Imap4</c>NX̐VKCX^X܂B
		/// </summary>
		/// <param name="host_name">IMAP4 T[o[</param>
		public Imap4(string host_name)
		{
			Init();
			_host = host_name;
		}
		/// <summary>
		/// 
		/// </summary>
		~Imap4()
		{
			Dispose(false);
		}
		/// <summary>
		/// <see cref="Imap4"/>ɂĎgpĂ邷ׂẴ\[X܂B
		/// </summary>
		public void Dispose()
		{
			Dispose(true);
			GC.SuppressFinalize(this);
		}
		/// <summary>
		/// <see cref="Imap4"/>ɂĎgpĂ邷ׂẴ\[X܂B
		/// </summary>
		/// <param name="disposing">
		/// }l[W\[XƃA}l[W\[X̗ꍇ<c>true</c>B
		/// A}l[W\[Xꍇ<c>false</c>B
		/// </param>
		protected virtual void Dispose(bool disposing)
		{
			if(!_disposed) {
				if(disposing)
				{
				}
				if(_socket != (IntPtr)ErrorSocket) {
					Imap4Close(_socket);
					_socket = (IntPtr)ErrorSocket;
				}
				_disposed = true;
			}
		}
		/// <summary>
		/// łB
		/// </summary>
		protected void Init()
		{
		}

		[DllImport("nMail.DLL", EntryPoint="NMailImap4ConnectPortNo", CharSet=CharSet.Auto)]
		protected static extern IntPtr Imap4ConnectPortNo(string Host, int Port);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4ConnectSsl", CharSet=CharSet.Auto)]
		protected static extern IntPtr Imap4ConnectSsl(string Host, int Port, int Flag, string Name);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4Close")]
		protected static extern int Imap4Close(IntPtr Socket);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4Authenticate", CharSet=CharSet.Auto)]
		protected static extern int Imap4Authenticate(IntPtr Socket, string Id, string Pass, int Mode);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4SelectMailBox", CharSet=CharSet.Auto)]
		protected static extern int Imap4SelectMailBox(IntPtr Socket, string MailBox, bool ReadOnlyFlag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetMailStatus", CharSet=CharSet.Auto)]
		protected static extern int Imap4GetMailStatus(IntPtr Socket, uint MailNo, StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, ref int MessageFlag, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetMailSize")]
		protected static extern int Imap4GetMailSize(IntPtr Socket, uint MailNo, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetMail", CharSet=CharSet.Auto)]
		protected static extern int Imap4GetMail(IntPtr Socket, uint MailNo, StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, StringBuilder Body, string Path, StringBuilder FileName, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetMailBoxList", CharSet=CharSet.Auto)]
		protected static extern int Imap4GetMailBoxList(IntPtr Socket, string Refer, string MailBox, bool SubscribeFlag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetMailBoxListStatus", CharSet=CharSet.Auto)]
		protected static extern int Imap4GetMailBoxListStatus(IntPtr Socket, int No, ref int MailBoxFlag, StringBuilder Separate, StringBuilder MailBox, int Size);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4DeleteMail")]
		protected static extern int Imap4DeleteMail(IntPtr Socket, uint MailNo, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4ChangeMessageFlag")]
		protected static extern int Imap4ChangeMessageFlag(IntPtr Socket, uint MailNo, int MessageFlag, int Command, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4ExpungeMail")]
		protected static extern int Imap4ExpungeMail(IntPtr Socket);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4CloseMailBox")]
		protected static extern int Imap4CloseMailBox(IntPtr Socket);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4CreateMailBox", CharSet=CharSet.Auto)]
		protected static extern int Imap4CreateMailBox(IntPtr Socket, string MailBox);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4DeleteMailBox", CharSet=CharSet.Auto)]
		protected static extern int Imap4DeleteMailBox(IntPtr Socket, string MailBox);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4RenameMailBox", CharSet=CharSet.Auto)]
		protected static extern int Imap4RenameMailBox(IntPtr Socket, string OldMailBox, string NewMailBox);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4SubscribeMailBox", CharSet=CharSet.Auto)]
		protected static extern int Imap4SubscribeMailBox(IntPtr Socket, string MailBox);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4UnsubscribeMailBox", CharSet=CharSet.Auto)]
		protected static extern int Imap4UnsubscribeMailBox(IntPtr Socket, string MailBox);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetMailBoxStatus", CharSet=CharSet.Auto)]
		protected static extern int Imap4GetMailBoxStatus(IntPtr Socket, string MailBox, int type, ref uint Data);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4CopyMail", CharSet=CharSet.Auto)]
		protected static extern int Imap4CopyMail(IntPtr Socket, uint MailNo, string MailBox, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetUid", CharSet=CharSet.Auto)]
		protected static extern int Imap4GetUid(IntPtr Socket, uint MailNo, ref uint Uid);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4SearchMail", CharSet=CharSet.Auto)]
		protected static extern int Imap4SearchMail(IntPtr Socket, int Type, string Text, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetSearchMailResult", CharSet=CharSet.Auto)]
		protected static extern int Imap4GetSearchMailResult(IntPtr Socket, int No, ref uint MailNo);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4AppendMail", CharSet=CharSet.Auto)]
		protected static extern int Imap4AppendMail(IntPtr Socket, string MailBox, string Header, string Body, string Path, int MessageFlag, string DateString, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailMakeDateString", CharSet=CharSet.Auto)]
		protected static extern int MakeDateString(StringBuilder DateString, int Year, int Month, int Day, int Hour, int Minute, int Second, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetNameSpace")]
		protected static extern int Imap4GetNameSpace(IntPtr Socket);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetNameSpaceStatus", CharSet=CharSet.Auto)]
		protected static extern int Imap4GetNameSpaceStatus(IntPtr Socket, int Type, StringBuilder Separate, StringBuilder Name, int Size);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetMimeStructure")]
		protected static extern int Imap4GetMimeStructure(IntPtr Socket, uint MailNo, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetMimeStructureStatus", CharSet=CharSet.Auto)]
		protected static extern int Imap4GetMimeStructureStatus(IntPtr Socket, int Type, int PartNo, int SubNo, StringBuilder Name, StringBuilder Value, int Size);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4GetMimePart", CharSet=CharSet.Auto)]
		protected static extern int Imap4GetMimePart(IntPtr Socket, uint MailNo, int PartNo, StringBuilder Body, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4SaveMimePart", CharSet=CharSet.Auto)]
		protected static extern int Imap4SaveMimePart(IntPtr Socket, uint MailNo, int PartNo, string Path, StringBuilder FileName, int Flag);

		[DllImport("nMail.DLL", EntryPoint="NMailImap4NoOperation")]
		protected static extern int Imap4NoOperation(IntPtr Socket);

		[DllImport("nMail.DLL", EntryPoint="NMailGetHeaderField", CharSet=CharSet.Auto)]
		protected static extern int Imap4GetHeaderField(StringBuilder Field, string Header, string Name, int Size);

		[DllImport("nMail.DLL", EntryPoint="NMailDecodeHeaderField", CharSet=CharSet.Auto)]
		protected static extern int Imap4DecodeHeaderField(StringBuilder Destination, string Source, int Size);

		/// <summary>
		/// wb_i[pobt@̃TCY肵܂B
		/// </summary>
		protected void SetHeaderSize()
		{
			if(_header_size < 0)
			{
				_header_size = Options.HeaderMax;
			}
			if(_header_size <= 0)
			{
				_header_size = HeaderSize;
				Options.HeaderMax = _header_size;
			}
		}
		/// <summary>
		/// T[oɐڑ肷
		/// </summary>
		/// <returns>true ŃT[oɐڑ</returns>
		public bool IsConnected()
		{
			if(_socket == (IntPtr)ErrorSocket)
			{
				return false;
			}
			else
			{
				return true;
			}
		}
		/// <summary>
		/// IMAP4 T[oɐڑ܂B
		/// </summary>
		/// <remarks>
		/// IMAP4 T[oɐڑ܂B
		/// </remarks>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	IMAP4 T[o[Ƃ̐ڑɎs܂B
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect()
		{
			if(_port < 0 || _port > 65536) {
				throw new ArgumentOutOfRangeException();
			}
			//_socket = Imap4ConnectPortNo(_host, _port);
			_socket = Imap4ConnectSsl(_host, _port, _ssl, _cert_name);
			if(_socket == (IntPtr)ErrorSocket)
			{
				_err = ErrorSocket;
				_socket = (IntPtr)ErrorSocket;
				throw new nMailException("Connect", _err);
			}
		}
		/// <summary>
		/// IMAP4 T[oɐڑ܂B
		/// </summary>
		/// <param name="host_name">IMAP4 T[o[</param>
		/// <remarks>
		/// T[ow肵 IMAP4 T[oɐڑ܂B
		/// </remarks>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	IMAP4 T[oƂ̐ڑɎs܂B
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect(string host_name)
		{
			_host = host_name;
			Connect();
		}
		/// <summary>
		/// IMAP4 T[oɐڑ܂B
		/// </summary>
		/// <param name="host_name">IMAP4 T[o</param>
		/// <param name="port_no">|[gԍ</param>
		/// <remarks>
		/// T[oƃ|[gԍw肵 IMAP4 T[oɐڑ܂B
		/// </remarks>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	IMAP4 T[oƂ̐ڑɎs܂B
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect(string host_name, int port_no)
		{
			_host = host_name;
			_port = port_no;
			Connect();
		}
		/// <summary>
		/// IMAP4 T[oɐڑ܂B
		/// </summary>
		/// <param name="port_no">|[gԍ</param>
		/// <remarks>
		/// |[gԍw肵 IMAP4 T[oɐڑ܂B
		/// </remarks>
		///	<exception cref="ArgumentOutOfRangeException">
		///	|[gԍ܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	IMAP4 T[oƂ̐ڑɎs܂B
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Connect(int port_no)
		{
			_port = port_no;
			Connect();
		}
		/// <summary>
		/// IMAP4 T[oƂ̐ڑI܂B
		/// </summary>
		public void Close()
		{
			if(_socket != (IntPtr)ErrorSocket) {
				Imap4Close(_socket);
			}
			_socket = (IntPtr)ErrorSocket;
		}
		/// <summary>
		/// IMAP4 T[oF؂s܂B
		/// </summary>
		/// <remarks>
		/// ID ƃpX[hw肵 IMAP4 T[oF؂s܂B
		/// </remarks>
		/// <param name="id_str">IMAP4 [U[ ID</param>
		/// <param name="pass_str">IMAP4 pX[h</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="FormatException">
		///	ID ̓pX[hɕ񂪓Ă܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Authenticate(string id_str, string pass_str)
		{
			if(id_str == "" || pass_str == "") {
				throw new FormatException();
			}
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_id = id_str;
			_password = pass_str;
			_body_size = -1;
			_count = Imap4Authenticate(_socket, _id, _password, _mode);
			if(_count < 0)
			{
				_err = _count;
				throw new nMailException("Authenticate: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// IMAP4 T[oF؂s܂B
		/// </summary>
		/// <remarks>
		/// IDApX[hєF،`w肵 IMAP4 T[oF؂s܂B
		/// </remarks>
		/// <param name="id_str">IMAP4 [U[ ID</param>
		/// <param name="pass_str">IMAP4 pX[h</param>
		/// <param name="mode">F،`
		/// <para>F،`̐ݒ\Ȓl͉L̒ʂłB</para>
		/// <para><see cref="AuthLogin"/>  LOGIN gp܂B</para>
		/// <para><see cref="AuthPlain"/>  PLAIN gp܂B</para>
		/// <para><see cref="AuthCramMd5"/> CRAM MD5 gp܂B</para>
		/// <para><see cref="AuthDigestMd5"/> DIGEST MD5 gp܂B</para>
		/// <para>C#  | AVB.NET ł Or ŕw\łB</para>
		/// <para>DIGEST MD5CRAM MD5PLAINLOGIN ̗D揇ʂŔF؂݂܂B</para>
		/// </param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="FormatException">
		///	ID ̓pX[hɕ񂪓Ă܂B
		/// </exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Authenticate(string id_str, string pass_str, int mode)
		{
			_mode = mode;
			Authenticate(id_str, pass_str);
		}

		/// <summary>
		/// wǍς݃[{bNẌꗗ擾܂B
		/// </summary>
		/// <param name="refer">KwʒułB</param>
		/// <param name="mailbox">ChJ[hłB"*" őSāA"%" œKw̃[{bNX܂B</param>
		/// <remarks>
		/// wǍς݃[{bNẌꗗ擾܂Bꗗ<see cref="GetMailBoxStatusList"/> Ŏ擾ł܂BB
		/// <example>
		/// <para>
		///	SĂ̍wǍς݃[{bNẌꗗ\܂B
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			// wǍς݃[{bNXꗗ擾
		///			imap.GetMailBoxListSubscribe("", "*");
		///			nMail.Imap4.MailBoxStatus [] list = imap4.GetMailBoxStatusList()
		///			foreach(nMail.Imap4.MailBoxStatus mailbox in list)
		///			{
		///				MessageBox.Show(string.Format("[{bNX:{0:s} ؂蕶:{1:c} tO:{2:d}", mailbox.Name, mailbox.Separate, mailbox.Flag));
		///			}
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(string.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(string.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		' wǍς݃[{bNXꗗ擾
		///		imap.GetMailBoxListSubscribe("", "*")
		///		Dim list As nMail.Imap4.MailBoxStatus() = imap4.GetMailBoxList()
		///		For Each mailbox As nMail.Imap4.MailBoxStatus In list
		///			MessageBox.Show(String.Format("[{bNX:{0:s} ؂蕶:{1:c} tO:{2:d}", mailbox.Name, mailbox.Separate, mailbox.Flag))
		///		Next
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void GetMailBoxListSubscribe(string refer, string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) 
			{
				throw new InvalidOperationException();
			}
			_err = Imap4GetMailBoxList(_socket, refer, mailbox, true);
			if(_err < 0)
			{
				_mailbox_list = new MailBoxStatus[0];
				throw new nMailException("GetMailBoxListSubscribe: " + Options.ErrorMessage, _err);
			}
			else
			{
				SetHeaderSize();
				_mailbox_list = new MailBoxStatus[_err];
				for(int no = 0 ; no < _err ; no++) 
				{
					StringBuilder separate = new StringBuilder(_header_size);
					StringBuilder name = new StringBuilder(_header_size);
					Imap4GetMailBoxListStatus(_socket, no, ref _mailbox_list[no].Flag, separate, name, _header_size);
					_mailbox_list[no].Name = name.ToString();
					_mailbox_list[no].Separate = separate[0];
				}
			}
		}
		/// <summary>
		/// [{bNẌꗗ擾܂B
		/// </summary>
		/// <remarks>
		/// [{bNẌꗗ擾܂Bꗗ<see cref="GetMailBoxList"/> Ŏ擾ł܂B
		/// <example>
		/// <para>
		///	SẴ[{bNẌꗗ\܂B
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			// [{bNXꗗ擾
		///			imap.GetMailBoxList("", "*");
		///			nMail.Imap4.MailBoxStatus [] list = imap4.GetMailBoxStatusList()
		///			foreach(nMail.Imap4.MailBoxStatus mailbox in list)
		///			{
		///				MessageBox.Show(string.Format("[{bNX:{0:s} ؂蕶:{1:c} tO:{2:d}", mailbox.Name, mailbox.Separate, mailbox.Flag));
		///			}
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(string.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(string.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		' [{bNXꗗ擾
		///		imap.GetMailBoxList("", "*")
		///		Dim list As nMail.Imap4.MailBoxStatus() = imap4.GetMailBoxList()
		///		For Each mailbox As nMail.Imap4.MailBoxStatus In list
		///			MessageBox.Show(String.Format("[{bNX:{0:s} ؂蕶:{1:c} tO:{2:d}", mailbox.Name, mailbox.Separate, mailbox.Flag))
		///		Next
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <param name="refer">KwʒułB</param>
		/// <param name="mailbox">ChJ[hłB"*" őSāA"%" œKw̃[{bNX܂B</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void GetMailBoxList(string refer, string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) 
			{
				throw new InvalidOperationException();
			}
			_err = Imap4GetMailBoxList(_socket, refer, mailbox, false);
			if(_err < 0)
			{
				_mailbox_list = new MailBoxStatus[0];
				throw new nMailException("GetMailBoxList: " + Options.ErrorMessage, _err);
			}
			else
			{
				SetHeaderSize();
				_mailbox_list = new MailBoxStatus[_err];
				for(int no = 0 ; no < _err ; no++) 
				{
					StringBuilder separate = new StringBuilder(_header_size);
					StringBuilder name = new StringBuilder(_header_size);
					Imap4GetMailBoxListStatus(_socket, no, ref _mailbox_list[no].Flag, separate, name, _header_size);
					_mailbox_list[no].Name = name.ToString();
					_mailbox_list[no].Separate = separate[0];
				}
			}
		}
		/// <summary>
		/// [{bNX̃bZ[W擾܂B
		/// </summary>
		/// <remarks>
		/// <paramref name="mailbox"/>p[^ŃbZ[W擾[{bNXw肵܂B
		/// </remarks>
		/// <param name="mailbox">bZ[W擾[{bNXłB</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		/// <returns>bZ[W</returns>
		public int GetMailBoxMessageCount(string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) 
			{
				throw new InvalidOperationException();
			}
			uint data = 0;
			_err = Imap4GetMailBoxStatus(_socket, mailbox, MailBoxMessage, ref data);
			if(_err < 0)
			{
				throw new nMailException("GetMailBoxMessageCount: " + Options.ErrorMessage, _err);
			}
			return (int)data;
		}
		/// <summary>
		/// [{bNX̐VbZ[W擾܂B
		/// </summary>
		/// <remarks>
		/// <paramref name="mailbox"/>p[^ŐVbZ[W擾[{bNXw肵܂B
		/// </remarks>
		/// <param name="mailbox">VbZ[W擾[{bNXłB</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		/// <returns>VbZ[W</returns>
		public int GetMailBoxRecentCount(string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) 
			{
				throw new InvalidOperationException();
			}
			uint data = 0;
			_err = Imap4GetMailBoxStatus(_socket, mailbox, MailBoxRecent, ref data);
			if(_err < 0)
			{
				throw new nMailException("GetMailBoxRecentCount: " + Options.ErrorMessage, _err);
			}
			return (int)data;
		}
		/// <summary>
		/// [{bNX̐VbZ[W UID 擾܂B
		/// </summary>
		/// <remarks>
		/// <paramref name="mailbox"/>p[^ŐVbZ[W UID l擾[{bNXw肵܂B
		/// </remarks>
		/// <param name="mailbox">VbZ[W UID l擾[{bNXłB</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		/// <returns>VbZ[W UID</returns>
		public uint GetMailBoxNextUid(string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) 
			{
				throw new InvalidOperationException();
			}
			uint data = 0;
			_err = Imap4GetMailBoxStatus(_socket, mailbox, MailBoxNextUid, ref data);
			if(_err < 0)
			{
				throw new nMailException("GetMailBoxNextUid: " + Options.ErrorMessage, _err);
			}
			return data;
		}
		/// <summary>
		/// [{bNX UID Validity l擾܂B
		/// </summary>
		/// <remarks>
		/// <paramref name="mailbox"/>p[^ UID Validity l擾[{bNXw肵܂B
		/// </remarks>
		/// <param name="mailbox">UID Validity l擾[{bNXłB</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		/// <returns>[{bNX UID Validity</returns>
		public uint GetMailBoxUidValidity(string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) 
			{
				throw new InvalidOperationException();
			}
			uint data = 0;
			_err = Imap4GetMailBoxStatus(_socket, mailbox, MailBoxUidValidity, ref data);
			if(_err < 0)
			{
				throw new nMailException("GetMailBoxUidValidity: " + Options.ErrorMessage, _err);
			}
			return data;
		}
		/// <summary>
		/// [{bNX̖ǃbZ[W擾܂B
		/// </summary>
		/// <remarks>
		/// <paramref name="mailbox"/>p[^ŖǃbZ[W擾[{bNXw肵܂B
		/// </remarks>
		/// <param name="mailbox">ǃbZ[W擾[{bNXłB</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		/// <returns>ǃbZ[W</returns>
		public int GetMailBoxUnSeen(string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) 
			{
				throw new InvalidOperationException();
			}
			uint data = 0;
			_err = Imap4GetMailBoxStatus(_socket, mailbox, MailBoxUnSeen, ref data);
			if(_err < 0)
			{
				throw new nMailException("GetMailBoxUnSeen: " + Options.ErrorMessage, _err);
			}
			return (int)data;
		}

		/// <summary>
		/// [{bNXI܂B
		/// </summary>
		/// <remarks>
		/// <paramref name="mailbox"/>p[^őI[{bNXw肵܂B
		/// </remarks>
		/// <param name="mailbox">I郁[{bNXłB</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void SelectMailBox(string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_mailbox = mailbox;
			_err = Imap4SelectMailBox(_socket, _mailbox, false);
			if(_err < 0)
			{
				throw new nMailException("SelectMailBox: " + Options.ErrorMessage, _err);
			}
			else
			{
				_count = _err;
			}
		}
		/// <summary>
		/// [{bNXǂݏopőI܂B
		/// </summary>
		/// <remarks>
		/// <paramref name="mailbox"/>p[^œǂݏopőI[{bNXw肵܂B
		/// </remarks>
		/// <param name="mailbox">I郁[{bNXłB</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void SelectMailBoxReadOnly(string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_mailbox = mailbox;
			_err = Imap4SelectMailBox(_socket, _mailbox, true);
			if(_err < 0)
			{
				throw new nMailException("SelectMailBoxReadOnly: " + Options.ErrorMessage, _err);
			}
			else
			{
				_count = _err;
			}
		}

		/// <summary>
		/// [̃Xe[^X擾܂B
		/// </summary>
		/// <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <remarks>
		/// <paramref name="no"/>p[^ŃXe[^X擾[ԍw肵܂B
		/// <para><see cref="Subject"/>Ŏ擾ł܂B</para>
		/// <para>t<see cref="DateString"/>Ŏ擾ł܂B</para>
		/// <para>ol<see cref="From"/>Ŏ擾ł܂B</para>
		/// <para>wb_<see cref="Header"/>Ŏ擾ł܂B</para>
		/// <para>bZ[WtO<see cref="MessageFlag"/>Ŏ擾ł܂B</para>
		/// <para>Xe[^X擾s̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void GetStatus(uint no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			SetHeaderSize();
			_subject = new StringBuilder(_header_size);
			_date = new StringBuilder(_header_size);
			_from = new StringBuilder(_header_size);
			_header = new StringBuilder(_header_size);
			_err = Imap4GetMailStatus(_socket, no, _subject, _date, _from, _header, ref _message_flag, _useuid);
			if(_err < 0)
			{
				throw new nMailException("GetStatus: " + Options.ErrorMessage, _err);
			}
			else
			{
				_size = _err;
				_body_size = _size * 2;
			}
		}
		/// <summary>
		/// [̃TCY擾܂B
		/// </summary>
		/// <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <remarks>
		/// <paramref name="no"/>p[^Ń[TCY擾[ԍw肵܂B
		/// <example>
		/// <para>
		/// [{bNX("inbox")̃[ԍ(ϐ:no)̃[TCY擾B
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		/// 		imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.GetSize(no);
		///			MessageBox.Show(String.Format("[ԍ:{0:d},TCY:{1:d}", no, imap.Size));
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		/// Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		/// Try
		/// 	imap.Connect()
		/// 	imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.GetMail(no)
		///		MessageBox.Show(String.Format("[ԍ:{0:d},TCY:{1:d}", no, imap.Size))
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		/// <returns>[TCY</returns>
		public int GetSize(uint no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_size = Imap4GetMailSize(_socket, no, _useuid);
			if(_size < 0) {
				_err = _size;
				throw new nMailException("GetSize: " + Options.ErrorMessage, _err);
			} else {
				_body_size = _size * 2;
			}
			return _size;
		}

		/// <summary>
		/// [擾܂B
		/// </summary>
		/// <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <remarks>
		/// <paramref name="no"/>p[^Ń[擾[ԍw肵܂B
		/// <para>Ytt@CۑꍇA<see cref="Path"/>ɕۑtH_w肵Ă܂B</para>
		/// <para>g@\gpꍇA<see cref="Flag"/>Őݒ肵Ă܂B</para>
		/// <para><see cref="Subject"/>Ŏ擾ł܂B</para>
		/// <para>t<see cref="DateString"/>Ŏ擾ł܂B</para>
		/// <para>ol<see cref="From"/>Ŏ擾ł܂B</para>
		/// <para>wb_<see cref="Header"/>Ŏ擾ł܂B</para>
		/// <para>[TCY<see cref="Size"/>Ŏ擾ł܂B</para>
		/// <para>Ytt@C<see cref="FileName"/>Ŏ擾ł܂B</para>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <exception cref="DirectoryNotFoundException">
		///	<see cref="Path"/>Ŏw肵tH_݂܂B
		/// </exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void GetMail(uint no)
		{
			if(_socket == (IntPtr)ErrorSocket)
			{
				throw new InvalidOperationException();
			}
			if(_path != null)
			{
				if(_path != "" && !Directory.Exists(_path))
				{
					throw new DirectoryNotFoundException(_path);
				}
			}
			if((_flag & SuspendNext) != 0) {
				_err = Imap4GetMail(_socket, no, _subject, _date, _from, _header, _body, _path, _filename, _flag | _useuid);
			} else {
				SetHeaderSize();
				_subject = new StringBuilder(_header_size);
				_date = new StringBuilder(_header_size);
				_from = new StringBuilder(_header_size);
				_header = new StringBuilder(_header_size);
				Options.FileNameMax = MaxPath;
				_filename = new StringBuilder(MaxPath);
				if(_body_size < 0)
				{
					GetSize(no);
				}
				if(_body_size > 0)
				{
					_body = new StringBuilder(_body_size);
					if(_flag != 0) {
						_err = Imap4GetMail(_socket, no, _subject, _date, _from, _header, _body, _path, _filename, _flag | _useuid);
					}
					else
					{
						_err = Imap4GetMail(_socket, no, _subject, _date, _from, _header, _body, _path, _filename, _flag | _useuid);
					}
				}
			}
			if(_err != ErrorSuspendAttachmentFile)
			{
				_body_size = -1;
				if(_filename.Length > 0) 
				{
					_filename_list = _filename.ToString().Split(Options.SplitChar);
				} 
				else 
				{
					_filename_list = null;
				}
				if(Options.SaveHtmlFile == Options.SaveHtmlFileOn) {
					GetHeaderField("X-NMAIL-HTML-FILE:");
					_html_file = _field;
				}
				if(Options.SaveRfc822File != Options.SaveRfc822FileOff) {
					GetHeaderField("X-NMAIL-RFC822-FILE:");
					_rfc822_file = _field;
				}
			}
			if(_err < 0 && _err != ErrorSuspendAttachmentFile) {
				throw new nMailException("GetMail: " + Options.ErrorMessage, _err);
			} 
		}
		/// <summary>
		/// [̍폜}[Nt܂B
		///	ۂ̍폜<see cref="Expunge"/>\bhĂяoۂɍs܂B
		/// </summary>
		/// <param name="no">폜}[Nt郁[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <remarks>
		/// <para>[폜}[Nts̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
		/// <example>
		/// <para>
		/// [{bNX("inbox")̎w̃[ԍ(ϐ:no)ɍ폜}[NtAۂɍ폜܂B
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		/// 		imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.Delete(no);	// 폜}[Nt
		///			imap.Expunge();		// 폜s
		///			MessageBox.Show(String.Format("[ԍ:{0:d}폜", no));
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		/// Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		/// Try
		/// 	imap.Connect()
		/// 	imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.Delete(no)			' 폜}[Nt
		///		imap.Expunge()			' 폜s
		///		MessageBox.Show(String.Format("[ԍ:{0:d}폜", no))
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Delete(uint no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4DeleteMail(_socket, no, _useuid);
			if(_err < 0)
			{
				throw new nMailException("Delete: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// 폜}[N̂Ă郁[폜܂B
		/// </summary>
		/// <remarks>
		/// <para>폜}[N̂Ă郁[폜܂B</para>
		/// <para>[폜s̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Expunge()
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4ExpungeMail(_socket);
			if(_err < 0)
			{
				throw new nMailException("Expunge: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// [{bNX̑II܂B
		/// </summary>
		/// <remarks>
		/// <para>[{bNX̑II܂B</para>
		/// <para>[{bNX̑IIs̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void CloseMailBox()
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4CloseMailBox(_socket);
			if(_err < 0)
			{
				throw new nMailException("CloseMailBox: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// [bZ[WtOt܂B
		/// </summary>
		/// <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <param name="message_flag">bZ[WtO
		/// <para><see cref="MessageAnswerd"/>ԐMς݃tO</para>
		/// <para><see cref="MessageDeleted"/>}[N</para>
		/// <para><see cref="MessageDraft"/>etO</para>
		/// <para><see cref="MessageFlagged"/>dvtO</para>
		/// <para><see cref="MessageRecent"/>tO</para>
		/// <para><see cref="MessageSeen"/>ǃtO</para>
		/// <para>C#  | AVB.NET ł Or ŕw\łB</para>
		///	</param>
		/// <remarks>
		/// w肵bZ[WtOt܂Bw肵ĂȂtȌԂ͂̂܂܂łB
		/// <para>tOts̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
		/// <example>
		/// <para>
		/// [{bNX("inbox")̎w̃[ԍ(ϐ:no)ɕԐMς݃tOt܂B
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		/// 		imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.AddMessageFlag(no, nMail.Imap4.MessageAnswerd);	// ԐMς݃tOt
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		/// Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		/// Try
		/// 	imap.Connect()
		/// 	imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.AddMessageFlag(no, nMail.Imap4.MessageAnswerd)		' ԐMς݃tOt
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void AddMessageFlag(uint no, int message_flag)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4ChangeMessageFlag(_socket, no, message_flag, AddMessage, _useuid);
			if(_err < 0)
			{
				throw new nMailException("AddMessageFlag: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// [bZ[WtO폜܂B
		/// </summary>
		/// <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <param name="message_flag">bZ[WtO
		/// <para><see cref="MessageAnswerd"/>ԐMς݃tO</para>
		/// <para><see cref="MessageDeleted"/>}[N</para>
		/// <para><see cref="MessageDraft"/>etO</para>
		/// <para><see cref="MessageFlagged"/>dvtO</para>
		/// <para><see cref="MessageRecent"/>tO</para>
		/// <para><see cref="MessageSeen"/>ǃtO</para>
		/// <para>C#  | AVB.NET ł Or ŕw\łB</para>
		///	</param>
		/// <remarks>
		/// w肵bZ[WtO폜܂Bw肵ĂȂtȌԂ͂̂܂܂łB
		/// <para>[bZ[WtOts̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
		/// <example>
		/// <para>
		/// [{bNX("inbox")̎w̃[ԍ(ϐ:no)폜}[NtO폜܂B
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		/// 		imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.DeleteMessageFlag(no, nMail.Imap4.MessageDeleted);	// 폜}[NtO폜
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		/// Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		/// Try
		/// 	imap.Connect()
		/// 	imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.DeleteMessageFlag(no, nMail.Imap4.MessageDeleted)		' 폜}[NtO폜
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void DeleteMessageFlag(uint no, int message_flag)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4ChangeMessageFlag(_socket, no, message_flag, DeleteMessage, _useuid);
			if(_err < 0)
			{
				throw new nMailException("DeleteMessageFlag: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// [bZ[WtOu܂B
		/// </summary>
		/// <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <param name="message_flag">bZ[WtO
		/// <para><see cref="MessageAnswerd"/>ԐMς݃tO</para>
		/// <para><see cref="MessageDeleted"/>}[N</para>
		/// <para><see cref="MessageDraft"/>etO</para>
		/// <para><see cref="MessageFlagged"/>dvtO</para>
		/// <para><see cref="MessageRecent"/>tO</para>
		/// <para><see cref="MessageSeen"/>ǃtO</para>
		/// <para>C#  | AVB.NET ł Or ŕw\łB</para>
		///	</param>
		/// <remarks>
		/// w肵bZ[WtOŒu܂B
		/// <para>[bZ[WtOus̏ꍇ̃G[ԍ<see cref="nMailException.ErrorCode"/>Ŏ擾ł܂B</para>
		/// <example>
		/// <para>
		/// [{bNX("inbox")̎w̃[ԍ(ϐ:no)ǂяdvbZ[WtOtĂԂƂ܂B
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		/// 		imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.ReplaceMessageFlag(no, nMail.Imap4.MessageFlagged | nMail.Imap4.MessageSeen);	// ǂяdvtO
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		/// Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		/// Try
		/// 	imap.Connect()
		/// 	imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.ReplaceMessageFlag(no, nMail.Imap4.MessageFlagged Or nMail.Imap4.MessageSeen)	' ǋyяdvtO
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void ReplaceMessageFlag(uint no, int message_flag)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4ChangeMessageFlag(_socket, no, message_flag, ReplaceMessage, _useuid);
			if(_err < 0)
			{
				throw new nMailException("ReplaceMessageFlag: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// Ytt@C̑݃`FbNs܂B
		/// </summary>
		/// <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <remarks>
		///	Ă郁[ɂĂ͈xMAAttachment NXŌĂB
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <returns>true œYtt@C</returns>
		public bool GetAttachmentFileStatus(uint no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			SetHeaderSize();
			_err = Imap4GetMimeStructure(_socket, no, _useuid);
			if(_err < 0)
			{
				throw new nMailException("GetAttachmentFileStatus: " + Options.ErrorMessage, _err);
			}
			else
			{
				if(_err > 1)
				{
					return true;
				}
				else
				{
					return false;
				}
			}
		}

		/// <summary>
		/// [ UID 擾܂B
		/// </summary>
		/// <param name="no">[ԍ</param>
		/// <remarks>
		/// <para>擾 UID ͕Ԓl <see cref="Uid"/>Ŏ擾ł܂B</para>
		/// <example>
		/// <para>
		/// [{bNX("inbox")̎w̃[ԍ(ϐ:no) UID 擾B
		///	<code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		/// 		imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.GetUid(no);
		///			MessageBox.Show("Uid=" + imap.Uid.ToString());
		/// 	}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		/// Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		/// Try
		/// 	imap.Connect()
		/// 	imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.GetUid(no)
		///		MessageBox.Show("Uid=" + imap.Uid.ToString())
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		/// <returns>[ UID</returns>
		public uint GetUid(uint no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			SetHeaderSize();
			_err = Imap4GetUid(_socket, no, ref _uid);
			if(_err < 0)
			{
				throw new nMailException("GetUid: " + Options.ErrorMessage, _err);
			}
			return _uid;
		}
		/// <summary>
		/// [wb_w̃tB[h̓e擾܂B
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <returns>tB[h̓e</returns>
		/// <remarks>
		/// IMAP4 T[oƂ̐ڑƂ͖֌WɎgpł܂B
		/// <para>wb_́A<see cref="Header"/>Őݒ肵Ă܂B
		/// <see cref="GetMail"/>ŎMɌĂяoꍇA
		/// M[̃wb_gp܂B</para>
		/// <para>擾tB[he<see cref="Field"/>Ŏ擾ł܂B</para>
		/// <example>
		/// <para>
		/// [{bNX("inbox")̎w̃[ԍ(ϐ:no) X-Mailer wb_tB[h擾B
		///	<code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		/// 		imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.GetMail(no);
		///			MessageBox.Show("X-Mailer:" + imap.GetHeaderField("X-Mailer:"));
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception e)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		/// Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Try
		/// 	imap.Connect()
		/// 	imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.GetMail(no)
		///		MessageBox.Show("X-Mailer:" + imap.GetHeaderField("X-Mailer:"))
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		/// <returns>tB[h̓e</returns>
		public string GetHeaderField(string field_name)
		{
			_field_name = field_name;
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			_err = Imap4GetHeaderField(_field, _header.ToString(), _field_name, _header_size);
			if(_err < 0)
			{
				throw new nMailException("GetHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// [wb_w̃tB[h̓e擾܂B
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <param name="header">wb_</param>
		/// <returns>tB[h̓e</returns>
		public string GetHeaderField(string field_name, string header)
		{
			_field_name = field_name;
			_header = new StringBuilder(header);
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			_err = Imap4GetHeaderField(_field, _header.ToString(), _field_name, _header_size);
			if(_err < 0)
			{
				throw new nMailException("GetHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// MIME wb_tB[h̕fR[h܂
		/// </summary>
		/// <param name="field">tB[h̕</param>
		/// <returns>fR[htB[he</returns>
		public string DecodeHeaderField(string field)
		{
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			_err = Imap4DecodeHeaderField(_field, field, _header_size);
			if(_err < 0)
			{
				throw new nMailException("DecodeHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// [wb_w̃wb_tB[h̓e擾A
		/// MIME wb_tB[h̃fR[hsĕԂ܂
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <returns>擾fR[hς݂̃tB[he</returns>
		public string GetDecodeHeaderField(string field_name)
		{
			SetHeaderSize();
			_field = new StringBuilder(_header_size);
			String src = GetHeaderField(field_name, _header.ToString());
			_err = Imap4DecodeHeaderField(_field, src, _header_size);
			if(_err < 0)
			{
				throw new nMailException("DecodeHeaderField", _err);
			}
			return _field.ToString();
		}
		/// <summary>
		/// [wb_w̃wb_tB[h̓e擾A
		/// MIME wb_tB[h̃fR[hsĕԂ܂
		/// </summary>
		/// <param name="field_name">tB[h</param>
		/// <param name="header">wb_</param>
		/// <returns>擾fR[hς݂̃tB[he</returns>
		public string GetDecodeHeaderField(string field_name, string header)
		{
			SetHeaderSize();
			_err = Imap4DecodeHeaderField(_field, GetHeaderField(field_name, header), _header_size);
			if(_err < 0)
			{
				throw new nMailException("DecodeHeaderField", _err);
			}
			return _field.ToString();
		}

		/// <summary>
		/// [{bNX쐬܂B
		/// </summary>
		/// <param name="mailbox">쐬郁[{bNX</param>
		/// <remarks>
		/// [{bNX쐬܂B
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void CreateMailBox(string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4CreateMailBox(_socket, mailbox);
			if(_err < 0)
			{
				throw new nMailException("CreateMailBox: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// [{bNX폜܂B
		/// </summary>
		/// <remarks>
		/// [{bNX폜܂B
		/// </remarks>
		/// <param name="mailbox">폜郁[{bNX</param>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void DeleteMailBox(string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4DeleteMailBox(_socket, mailbox);
			if(_err < 0)
			{
				throw new nMailException("DeleteMailBox: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// [{bNXύX܂B
		/// </summary>
		/// <param name="old_name">ύXÕ[{bNX</param>
		/// <param name="new_name">ύX̃[{bNX</param>
		/// <remarks>
		/// [{bNXύX܂B
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void RenameMailBox(string old_name, string new_name)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4RenameMailBox(_socket, old_name, new_name);
			if(_err < 0)
			{
				throw new nMailException("RenameMailBox: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// [{bNXwǂ܂B
		/// </summary>
		/// <param name="mailbox">wǂ郁[{bNX</param>
		/// <remarks>
		/// [{bNXwǂ܂B
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void SubscribeMailBox(string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4SubscribeMailBox(_socket, mailbox);
			if(_err < 0)
			{
				throw new nMailException("SubscribeMailBox: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// [{bNX̍wǂ܂B
		/// </summary>
		/// <param name="mailbox">wǉ郁[{bNX</param>
		/// <remarks>
		/// [{bNX̍wǂ܂B
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void UnsubscribeMailBox(string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4UnsubscribeMailBox(_socket, mailbox);
			if(_err < 0)
			{
				throw new nMailException("UnsubscribeMailBox: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// [Rs[܂B
		/// </summary>
		/// <param name="no">Rs[郁[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <param name="mailbox">Rs[̃[{bNX</param>
		/// <remarks>
		/// ݑIĂ郁[{bNX̃[w̃[{bNXɃRs[܂B
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Copy(uint no, string mailbox)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4CopyMail(_socket, no, mailbox, _useuid);
			if(_err < 0)
			{
				throw new nMailException("Copy: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// MIME \擾܂B
		/// </summary>
		/// <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <remarks>
		/// <para>MIME \<see cref="GetMimeStructureStatusList"/>Ŏ擾ł܂B</para>
		/// <example>
		/// <para>
		///	[{bNX("inbox")̎w̃[ԍ(ϐ:no) MIME \擾AeLXgłΖ{\AYtt@Cł z:\temp ɕۑ܂B
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			// MIME \擾
		///			imap.GetMimeStructure(no);
		///			nMail.Imap4.MimeStructureStatus [] list = imap4.GetMimeStructureStatusList()
		///			foreach(nMail.Imap4.MimeStructureStatus mime in list)
		///			{
		///				// eLXgłΖ{擾ĕ\
		///				if(string.Compare(mime.Type, "text", true) == 0 &amp;&amp; string.Compare(mime.SubType, "plain", true) == 0)
		///				{
		///					// {擾
		///					imap.GetMimePart(no, mime.PartNo);
		///					MessageBox.Show(imap.Body);
		///				}
		///				else if(string.Compare(mime.Type, "multipart", true) != 0)
		///				{
		///					// Ytt@Cۑ
		///					imap.SaveMimePart(no, mime.PartNo, @"z:\temp\" + mime.FileName);
		///				}
		///			}
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		' MIME \擾
		///		imap.GetMimeStructure(no)
		///		Dim list As nMail.Imap4.MimeStructureStatus() = imap4.GetMimeStructureList()
		///		For Each mime As nMail.Imap4.MimeStructureStatus In list
		///			' eLXgłΖ{擾ĕ\
		///			If (String.Compare(mime.Type, "text", True) = 0) And (String.Compare(mime.SubType, "plain", True) = 0) Then
		///				' {擾
		///				imap.GetMimePart(no, mime.PartNo)
		///				MessageBox.Show(imap.Body)
		///			Else If String.Compare(mime.Type, "multipart", true) &lt;&gt; 0 Then
		///				' Ytt@Cۑ
		///				imap.SaveMimePart(no, mime.PartNo, "z:\temp\" + mime.FileName)
		///			End If
		///		Next
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void GetMimeStructure(uint no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4GetMimeStructure(_socket, no, _flag | _useuid);
			if(_err < 0)
			{
				_mime_list = new MimeStructureStatus[0];
				throw new nMailException("GetMimeStructure: " + Options.ErrorMessage, _err);
			}
			else
			{
				SetHeaderSize();
				_mime_list = new MimeStructureStatus[_err];
				for(int part_no = 0 ; part_no < _err ; part_no++) {
					_mime_list[part_no].PartNo = part_no;
					StringBuilder name = new StringBuilder(_header_size);
					StringBuilder value = new StringBuilder(_header_size);
					Imap4GetMimeStructureStatus(_socket, ContentTypeAndSubType, part_no, 0, name, value, _header_size);
					_mime_list[part_no].Type = name.ToString();
					_mime_list[part_no].SubType = value.ToString();
					Imap4GetMimeStructureStatus(_socket, ContentPart, part_no, 0, name, null, _header_size);
					_mime_list[part_no].Part = name.ToString();
					Imap4GetMimeStructureStatus(_socket, ContentId, part_no, 0, name, null, _header_size);
					_mime_list[part_no].Id = name.ToString();
					Imap4GetMimeStructureStatus(_socket, ContentDescription, part_no, 0, name, null, _header_size);
					_mime_list[part_no].Description = name.ToString();
					Imap4GetMimeStructureStatus(_socket, ContentTransferEncoding, part_no, 0, name, null, _header_size);
					_mime_list[part_no].Encoding = name.ToString();
					Imap4GetMimeStructureStatus(_socket, ContentFileName, part_no, 0, name, null, _header_size);
					_mime_list[part_no].FileName = name.ToString();
					_mime_list[part_no].Size = Imap4GetMimeStructureStatus(_socket, ContentSize, part_no, 0, name, null, _header_size);
					if(_mime_list[part_no].Size < 0)
					{
						_mime_list[part_no].Size = 0;
					}
					_mime_list[part_no].Line = Imap4GetMimeStructureStatus(_socket, ContentLine, part_no, 0, name, null, _header_size);
					if(_mime_list[part_no].Line < 0)
					{
						_mime_list[part_no].Line = 0;
					}
					int param_count = Imap4GetMimeStructureStatus(_socket, ContentParameterCount, part_no, 0, name, null, _header_size);
					if(param_count < 0) {
						param_count = 0;
					}
					_mime_list[part_no].Parameter = new MimeParameterStatus[param_count];
					for(int param_no = 0 ; param_no < param_count ; param_no++) {
						Imap4GetMimeStructureStatus(_socket, ContentParameter, part_no, param_no, name, value, _header_size);
						_mime_list[part_no].Parameter[param_no].Name = name.ToString();
						_mime_list[part_no].Parameter[param_no].Value = value.ToString();
					}
				}
			}
		}

		/// <summary>
		/// MIME p[g擾
		/// </summary>
		/// <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <param name="part_no">MIME p[gԍ</param>
		/// <remarks>
		/// <para>ǃtO𗧂ĂȂꍇAfR[hȂꍇ́A<see cref="MimeFlag"/>Őݒ肵Ă܂B</para>
		/// <para>擾p[g{<see cref="Body"/>Ŏ擾ł܂B</para>
		/// <para>Tv <see cref="GetMimeStructure"/>QƂĂB</para>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void GetMimePart(uint no, int part_no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			int size = _mime_list[part_no].Size;
			if(size < 0)
			{
				GetSize(no);
				size = _size;
			}
			_body = new StringBuilder(size * 2);
			_err = Imap4GetMimePart(_socket, no, part_no, _body, _mime_flag | _useuid);
			if(_err < 0)
			{
				throw new nMailException("GetMimePart: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// MIME p[gwb_擾
		/// </summary>
		/// <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <param name="part_no">MIME p[gԍ</param>
		/// <remarks>
		/// <para>ǃtO𗧂ĂȂꍇAfR[hȂꍇ́A<see cref="MimeFlag"/>Őݒ肵Ă܂B</para>
		/// <para>擾p[gwb_<see cref="Header"/>Ŏ擾ł܂B</para>
		/// <para>Tv <see cref="GetMimeStructure"/>QƂĂB</para>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void GetMimePartHeader(uint no, int part_no)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			int size = _mime_list[part_no].Size;
			if(size < 0)
			{
				GetSize(no);
				size = _size;
			}
			_body = new StringBuilder(size * 2);
			_err = Imap4GetMimePart(_socket, no, part_no, _header, MimeHeader | _mime_flag | _useuid);
			if(_err < 0)
			{
				throw new nMailException("GetMimePartHeader: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// MIME p[gۑ
		/// </summary>
		/// <param name="no">[ԍ(<see cref="UseUid"/> true ̏ꍇ UID)</param>
		/// <param name="part_no">MIME p[gԍ</param>
		/// <param name="path">ۑt@C</param>
		/// <remarks>
		/// <para>ǃtO𗧂ĂȂꍇAfR[hȂꍇ́A<see cref="MimeFlag"/>Őݒ肵Ă܂B</para>
		/// <para>ۑt@C<see cref="FileName"/>Ŏ擾ł܂B</para>
		/// <para>Tv <see cref="GetMimeStructure"/>QƂĂB</para>
		/// <para>Content-Type ̃^Cv "multipart"  MIME p[gw肵ꍇAG[ɂȂ܂̂łӉB</para>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void SaveMimePart(uint no, int part_no, string path)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			Options.FileNameMax = MaxPath;
			_filename = new StringBuilder(MaxPath);
			_err = Imap4SaveMimePart(_socket, no, part_no, path, _filename, MimeSaveAsFile | _mime_flag | _useuid);
			if(_err < 0)
			{
				throw new nMailException("SaveMimePart: " + Options.ErrorMessage, _err);
			}
		}

		/// <summary>
		/// [̌s(L)
		/// </summary>
		/// <param name="type">
		/// <para>̐ݒ\Ȓl͉L̒ʂłB</para>
		/// <para><see cref="SearchKeyword"/>w肳ꂽL[[h</para>
		/// <para><see cref="SearchUnKeyword"/>w肳ꂽL[[hȂ</para>
		/// <para><see cref="SearchFrom"/>From wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchTo"/>To wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchCc"/>CC wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchBcc"/>BCC wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchSubject"/>SUBJECT wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchSentBefore"/>DATE wb_w肳ꂽtȑO</para>
		/// <para><see cref="SearchSentOn"/>DATE wb_w肳ꂽt</para>
		/// <para><see cref="SearchSentSince"/>DATE wb_w肳ꂽtȍ~</para>
		/// <para><see cref="SearchBefore"/>w肳ꂽtȑOɓ</para>
		/// <para><see cref="SearchOn"/>w肳ꂽtɓ</para>
		/// <para><see cref="SearchSince"/>w肳ꂽtȍ~ɓ</para>
		/// <para><see cref="SearchHeader"/>w肳ꂽwb_tB[hɕ܂ "wb_tB[h "Ǝw肵Ă</para>
		/// <para><see cref="SearchBody"/>{ɕ܂</para>
		/// <para><see cref="SearchText"/>wb_і{ɕ܂</para>
		/// <para><see cref="SearchLager"/>wTCY傫ȃ[ TCY͕ɕϊĂ</para>
		/// <para><see cref="SearchSmaller"/>wTCY菬ȃ[ TCY͕ɕϊĂ</para>
		/// <para><see cref="SearchUid"/>w UID ̃[</para>
		/// <para><see cref="SearchCommand"/>𒼐ڎw</para>
		/// <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
		/// </param>
		/// <param name="text"></param>
		/// <remarks>
		///	ʂ <see cref="GetSearchMailResultList"/> Ŏ擾ł܂B
		/// <example>
		/// <para>
		///	[{bNX("inbox")̍ol(From tB[h) support@nanshiki.co.jp ܂܂郁[
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.Search(SearchFrom, "support@nanshiki.co.jp");
		///			uint [] list = imap4.GetSearchMailResultList()
		///			foreach(uint no in list)
		///			{
		///				MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///			}
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.Search(SearchFrom, "support@nanshiki.co.jp")
		///		Dim list As Integer() = imap4.GetSearchMailResultList()
		///		For Each no As Integer In list
		///			MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///		Next
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Search(int type, string text)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			if(_search_first_flag)
			{
				type |= SearchFirst;
				_search_first_flag = false;
			}
			_err = Imap4SearchMail(_socket, type, text, _useuid);
			_search_first_flag = true;
			if(_err < 0)
			{
				_search_list = new uint[0];
				throw new nMailException("Search: " + Options.ErrorMessage, _err);
			}
			else
			{
				_search_list = new uint[_err];
				for(int no = 0 ; no < _err ; no++) {
					Imap4GetSearchMailResult(_socket, no, ref _search_list[no]);
				}
			}
		}
		/// <summary>
		/// [̌s()
		/// </summary>
		/// <param name="type">
		/// <para>̐ݒ\Ȓl͉L̒ʂłB</para>
		/// <para><see cref="SearchAnswered"/>ԐMς</para>
		/// <para><see cref="SearchUnAnswered"/>ԐMς݂łȂ</para>
		/// <para><see cref="SearchDeleted"/>}[N</para>
		/// <para><see cref="SearchUnDeleted"/>}[NȂ</para>
		/// <para><see cref="SearchDraft"/>etO</para>
		/// <para><see cref="SearchUnDraft"/>etOȂ</para>
		/// <para><see cref="SearchFlagged"/>dvtO</para>
		/// <para><see cref="SearchUnFlagged"/>dvtOȂ</para>
		/// <para><see cref="SearchRecent"/>tO</para>
		/// <para><see cref="SearchUnRecent"/>tOȂ</para>
		/// <para><see cref="SearchSeen"/>ǃtO</para>
		/// <para><see cref="SearchUnSeen"/>ǃtOȂ</para>
		/// <para><see cref="SearchNew"/>tO肩ǃtOȂ</para>
		/// <para><see cref="SearchAll"/>SẴ[</para>
		/// <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
		/// </param>
		/// <remarks>
		///	ʂ <see cref="GetSearchMailResultList"/> Ŏ擾ł܂B
		/// <example>
		/// <para>
		///	[{bNX("inbox")̐VK̃[(tOL肩ǃtOȂ)
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.Search(SearchNew);
		///			uint [] list = imap4.GetSearchMailResultList()
		///			foreach(uint no in list)
		///			{
		///				MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///			}
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.Search(SearchNew)
		///		Dim list As Integer() = imap4.GetSearchMailResultList()
		///		For Each no As Integer In list
		///			MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///		Next
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void Search(int type)
		{
			Search(type, null);
		}

		/// <summary>
		/// [̌ AND (L)
		/// </summary>
		/// <param name="type">
		/// <para>̐ݒ\Ȓl͉L̒ʂłB</para>
		/// <para><see cref="SearchKeyword"/>w肳ꂽL[[h</para>
		/// <para><see cref="SearchUnKeyword"/>w肳ꂽL[[hȂ</para>
		/// <para><see cref="SearchFrom"/>From wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchTo"/>To wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchCc"/>CC wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchBcc"/>BCC wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchSubject"/>SUBJECT wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchSentBefore"/>DATE wb_w肳ꂽtȑO</para>
		/// <para><see cref="SearchSentOn"/>DATE wb_w肳ꂽt</para>
		/// <para><see cref="SearchSentSince"/>DATE wb_w肳ꂽtȍ~</para>
		/// <para><see cref="SearchBefore"/>w肳ꂽtȑOɓ</para>
		/// <para><see cref="SearchOn"/>w肳ꂽtɓ</para>
		/// <para><see cref="SearchSince"/>w肳ꂽtȍ~ɓ</para>
		/// <para><see cref="SearchHeader"/>w肳ꂽwb_tB[hɕ܂ "wb_tB[h "Ǝw肵Ă</para>
		/// <para><see cref="SearchBody"/>{ɕ܂</para>
		/// <para><see cref="SearchText"/>wb_і{ɕ܂</para>
		/// <para><see cref="SearchLager"/>wTCY傫ȃ[ TCY͕ɕϊĂ</para>
		/// <para><see cref="SearchSmaller"/>wTCY菬ȃ[ TCY͕ɕϊĂ</para>
		/// <para><see cref="SearchUid"/>w UID ̃[</para>
		/// <para><see cref="SearchCommand"/>𒼐ڎw</para>
		/// <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
		/// </param>
		/// <param name="text"></param>
		/// <remarks>
		///	AND Ōw肵܂B<see cref="Search"/>Ōs܂B
		/// <example>
		/// <para>
		///	[{bNX("inbox")̌"eXg"܂܂Aol(From tB[h) support@nanshiki.co.jp ܂܂郁[
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.AddSearchAnd(SearchSubject, "eXg");
		///			imap.Search(SearchFrom, "support@nanshiki.co.jp");
		///			uint [] list = imap4.GetSearchMailResultList()
		///			foreach(uint no in list)
		///			{
		///				MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///			}
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.AddSearchAnd(SearchSubject, "eXg")
		///		imap.Search(SearchFrom, "support@nanshiki.co.jp")
		///		Dim list As Integer() = imap4.GetSearchMailResultList()
		///		For Each no As Integer In list
		///			MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///		Next
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void AddSearchAnd(int type, string text)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			if(_search_first_flag)
			{
				type |= SearchFirst;
				_search_first_flag = false;
			}
			_err = Imap4SearchMail(_socket, type | SearchAnd, text, _useuid);
			if(_err < 0)
			{
				throw new nMailException("Search: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// [̌ AND ()
		/// </summary>
		/// <param name="type">
		/// <para>̐ݒ\Ȓl͉L̒ʂłB</para>
		/// <para><see cref="SearchAnswered"/>ԐMς</para>
		/// <para><see cref="SearchUnAnswered"/>ԐMς݂łȂ</para>
		/// <para><see cref="SearchDeleted"/>}[N</para>
		/// <para><see cref="SearchUnDeleted"/>}[NȂ</para>
		/// <para><see cref="SearchDraft"/>etO</para>
		/// <para><see cref="SearchUnDraft"/>etOȂ</para>
		/// <para><see cref="SearchFlagged"/>dvtO</para>
		/// <para><see cref="SearchUnFlagged"/>dvtOȂ</para>
		/// <para><see cref="SearchRecent"/>tO</para>
		/// <para><see cref="SearchUnRecent"/>tOȂ</para>
		/// <para><see cref="SearchSeen"/>ǃtO</para>
		/// <para><see cref="SearchUnSeen"/>ǃtOȂ</para>
		/// <para><see cref="SearchNew"/>tO肩ǃtOȂ</para>
		/// <para><see cref="SearchAll"/>SẴ[</para>
		/// <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
		/// </param>
		/// <remarks>
		///	AND Ōw肵܂B<see cref="Search"/>Ōs܂B
		/// <example>
		/// <para>
		///	[{bNX("inbox")̊ǂ̃[ 2009/8/1 ȍ~ɓ[
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.AddSearchAnd(SearchSeen);
		///			imap.Search(SearchSince, MakeDateString(new DateTime(2009, 8, 1));
		///			uint [] list = imap4.GetSearchMailResultList()
		///			foreach(uint no in list)
		///			{
		///				MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///			}
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.AddSearchAnd(SearchSeen)
		///		imap.Search(SearchSince, MakeDateString(new DateTime(2009, 8, 1))
		///		Dim list As Integer() = imap4.GetSearchMailResultList()
		///		For Each no As Integer In list
		///			MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///		Next
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void AddSearchAnd(int type)
		{
			AddSearchAnd(type, null);
		}
		/// <summary>
		/// [̌ OR (L)
		/// </summary>
		/// <param name="type">
		/// <para>̐ݒ\Ȓl͉L̒ʂłB</para>
		/// <para><see cref="SearchKeyword"/>w肳ꂽL[[h</para>
		/// <para><see cref="SearchUnKeyword"/>w肳ꂽL[[hȂ</para>
		/// <para><see cref="SearchFrom"/>From wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchTo"/>To wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchCc"/>CC wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchBcc"/>BCC wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchSubject"/>SUBJECT wb_Ɏw̕񂠂</para>
		/// <para><see cref="SearchSentBefore"/>DATE wb_w肳ꂽtȑO</para>
		/// <para><see cref="SearchSentOn"/>DATE wb_w肳ꂽt</para>
		/// <para><see cref="SearchSentSince"/>DATE wb_w肳ꂽtȍ~</para>
		/// <para><see cref="SearchBefore"/>w肳ꂽtȑOɓ</para>
		/// <para><see cref="SearchOn"/>w肳ꂽtɓ</para>
		/// <para><see cref="SearchSince"/>w肳ꂽtȍ~ɓ</para>
		/// <para><see cref="SearchHeader"/>w肳ꂽwb_tB[hɕ܂ "wb_tB[h "Ǝw肵Ă</para>
		/// <para><see cref="SearchBody"/>{ɕ܂</para>
		/// <para><see cref="SearchText"/>wb_і{ɕ܂</para>
		/// <para><see cref="SearchLager"/>wTCY傫ȃ[ TCY͕ɕϊĂ</para>
		/// <para><see cref="SearchSmaller"/>wTCY菬ȃ[ TCY͕ɕϊĂ</para>
		/// <para><see cref="SearchUid"/>w UID ̃[</para>
		/// <para><see cref="SearchCommand"/>𒼐ڎw</para>
		/// <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
		/// </param>
		/// <param name="text"></param>
		/// <remarks>
		///	OR Ōw肵܂B<see cref="Search"/>Ōs܂B
		/// <example>
		/// <para>
		///	[{bNX("inbox")̌"eXg"܂܂邩A܂͍ol(From tB[h) support@nanshiki.co.jp ܂܂郁[
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.AddSearchOr(SearchSubject, "eXg");
		///			imap.Search(SearchFrom, "support@nanshiki.co.jp");
		///			uint [] list = imap4.GetSearchMailResultList()
		///			foreach(uint no in list)
		///			{
		///				MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///			}
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.AddSearchOr(SearchSubject, "eXg")
		///		imap.Search(SearchFrom, "support@nanshiki.co.jp")
		///		Dim list As Integer() = imap4.GetSearchMailResultList()
		///		For Each no As Integer In list
		///			MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///		Next
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void AddSearchOr(int type, string text)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			if(_search_first_flag)
			{
				type |= SearchFirst;
				_search_first_flag = false;
			}
			_err = Imap4SearchMail(_socket, type | SearchOr, text, _useuid);
			if(_err < 0)
			{
				throw new nMailException("Search: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// [̌ OR ()
		/// </summary>
		/// <param name="type">
		/// <para>̐ݒ\Ȓl͉L̒ʂłB</para>
		/// <para><see cref="SearchAnswered"/>ԐMς</para>
		/// <para><see cref="SearchUnAnswered"/>ԐMς݂łȂ</para>
		/// <para><see cref="SearchDeleted"/>}[N</para>
		/// <para><see cref="SearchUnDeleted"/>}[NȂ</para>
		/// <para><see cref="SearchDraft"/>etO</para>
		/// <para><see cref="SearchUnDraft"/>etOȂ</para>
		/// <para><see cref="SearchFlagged"/>dvtO</para>
		/// <para><see cref="SearchUnFlagged"/>dvtOȂ</para>
		/// <para><see cref="SearchRecent"/>tO</para>
		/// <para><see cref="SearchUnRecent"/>tOȂ</para>
		/// <para><see cref="SearchSeen"/>ǃtO</para>
		/// <para><see cref="SearchUnSeen"/>ǃtOȂ</para>
		/// <para><see cref="SearchNew"/>tO肩ǃtOȂ</para>
		/// <para><see cref="SearchAll"/>SẴ[</para>
		/// <para><see cref="SearchNot"/> NOT (ĽƓ(C# ł | AVB.NET ł Or)w肷Kv܂)</para>
		/// </param>
		/// <remarks>
		///	OR Ōw肵܂B<see cref="Search"/>Ōs܂B
		/// <example>
		/// <para>
		///	[{bNX("inbox")̊ǂ̃[A܂͌"eXg"܂܂郁[
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.AddSearchOr(SearchSeen);
		///			imap.Search(SearchSubject, "eXg");
		///			uint [] list = imap4.GetSearchMailResultList()
		///			foreach(uint no in list)
		///			{
		///				MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///			}
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.AddSearchOr(SearchSeen)
		///		imap.Search(SearchSubject, "eXg")
		///		Dim list As Integer() = imap4.GetSearchMailResultList()
		///		For Each no As Integer In list
		///			MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///		Next
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void AddSearchOr(int type)
		{
			AddSearchOr(type, null);
		}

		/// <summary>
		/// [{bNXɃ[Abv[h܂B
		/// </summary>
		/// <param name="mailbox">Abv[h郁[{bNX</param>
		/// <param name="header">[wb_
		/// <para>Date,Message-ID,Mime-Version,Content-Type,Content-Transfer-Encode tB[h</para>
		/// <para>͎Iɕt܂BDate tB[hɂ͌ݓݒ肳܂B</para>
		/// <para>Date  Message-ID tB[h͈ header ɋLq΂炪D悳܂B</para>
		/// </param>
		/// <param name="body">[{</param>
		/// <param name="message_flag">bZ[WtO
		/// <para><see cref="MessageAnswerd"/>ԐMς݃tO</para>
		/// <para><see cref="MessageDeleted"/>}[N</para>
		/// <para><see cref="MessageDraft"/>etO</para>
		/// <para><see cref="MessageFlagged"/>dvtO</para>
		/// <para><see cref="MessageRecent"/>tO</para>
		/// <para><see cref="MessageSeen"/>ǃtO</para>
		/// <para>C#  | AVB.NET ł Or ŕw\łB</para>
		/// </param>
		/// <param name="path">Ytt@C</param>
		/// <remarks>
		/// <example>
		/// <para>
		///	Mσ[{bNX("sent")Ƀ[ǃtOtŃAbv[hB
		/// subject ɌAfrom ɍolAto ɈAbody Ƀ[{Apath ɓYtt@C̃pXĂ̂ƂB
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		string header;
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			header = "Subject: " + subject + "\r\n";
		///			header += "From: " + from + "\r\n";
		///			header += "To: " + to + "\r\n";
		///			imap.AppendMail("sent", header, body, MessageSeen, path);
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Dim header As String
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		header = "Subject: " + subject + ControlChars.CrLf
		///		header += "From: " + from + ControlChars.CrLf
		///		header += "To: " + to + ControlChars.CrLf
		///		imap.AppendMail("sent", header, body, MessageSeen, path)
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void AppendMail(string mailbox, string header, string body, int message_flag, string path)
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4AppendMail(_socket, mailbox, header, body, path, message_flag, null, AddDateField | AddMessageId);
			if(_err < 0)
			{
				throw new nMailException("AppendMail: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// [{bNXɃ[Abv[h܂B
		/// </summary>
		/// <param name="mailbox">Abv[h郁[{bNX</param>
		/// <param name="header">[wb_
		/// <para>Date,Message-ID,Mime-Version,Content-Type,Content-Transfer-Encode tB[h</para>
		/// <para>͎Iɕt܂BDate tB[hɂ͌ݓݒ肳܂B</para>
		/// <para>Date  Message-ID tB[h͈ header ɋLq΂炪D悳܂B</para>
		/// </param>
		/// <param name="body">[{</param>
		/// <param name="message_flag">bZ[WtO
		/// <para><see cref="MessageAnswerd"/>ԐMς݃tO</para>
		/// <para><see cref="MessageDeleted"/>}[N</para>
		/// <para><see cref="MessageDraft"/>etO</para>
		/// <para><see cref="MessageFlagged"/>dvtO</para>
		/// <para><see cref="MessageRecent"/>tO</para>
		/// <para><see cref="MessageSeen"/>ǃtO</para>
		/// <para>C#  | AVB.NET ł Or ŕw\łB</para>
		/// </param>
		/// <remarks>
		/// <example>
		/// <para>
		///	Mσ[{bNX("sent")Ƀ[ǃtOtŃAbv[hB
		/// subject ɌAfrom ɍolAto ɈAbody Ƀ[{Ă̂ƂB
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		string header;
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			header = "Subject: " + subject + "\r\n";
		///			header += "From: " + from + "\r\n";
		///			header += "To: " + to + "\r\n";
		///			imap.AppendMail("sent", header, body, MessageSeen);
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Dim header As String
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		header = "Subject: " + subject + ControlChars.CrLf
		///		header += "From: " + from + ControlChars.CrLf
		///		header += "To: " + to + ControlChars.CrLf
		///		imap.AppendMail("sent", header, body, MessageSeen)
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void AppendMail(string mailbox, string header, string body, int message_flag)
		{
			AppendMail(mailbox, header, body, message_flag, null);
		}

		/// <summary>
		/// OԂ擾܂B
		/// </summary>
		/// <remarks>
		/// <example>
		/// <para>
		///	OԂ擾A\B
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		string header;
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			imap.GetNameSpace();
		///			nMail.Imap4.NameSpaceStatus [] list = imap.GetNameSpacePersonalStatusList()
		///			foreach(nMail.Imap4.NameSpaceStatus item in list) {
		///				MessageBox.Show(string.Format("lO:{0:s} ؂蕶:{1:c}", item.Name, item.Separate));
		///			}
		///			list = imap.GetNameSpaceOtherStatusList()
		///			foreach(nMail.Imap4.NameSpaceStatus item in list) {
		///				MessageBox.Show(string.Format("lO:{0:s} ؂蕶:{1:c}", item.Name, item.Separate));
		///			}
		///			list = imap.GetNameSpaceSharedStatusList()
		///			foreach(nMail.Imap4.NameSpaceStatus item in list) {
		///				MessageBox.Show(string.Format("LO:{0:s} ؂蕶:{1:c}", item.Name, item.Separate));
		///			}
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Dim header As String
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		imap.GetNameSpace()
		///		Dim list As nMail.Imap4.NameSpaceStatus() = imap.GetNameSpacePersonalStatusList()
		///		For Each item As nMail.Imap4.NameSpaceStatus In list
		///			MessageBox.Show(String.Format("lO:{0:s} ؂蕶:{1:c}", item.Name, item.Separate))
		///		Next
		///		list = imap.GetNameSpaceOtherStatusList()
		///		For Each item As nMail.Imap4.NameSpaceStatus In list
		///			MessageBox.Show(String.Format("lO:{0:s} ؂蕶:{1:c}", item.Name, item.Separate))
		///		Next
		///		list = imap.GetNameSpaceSharedStatusList()
		///		For Each item As nMail.Imap4.NameSpaceStatus In list
		///			MessageBox.Show(String.Format("LO:{0:s} ؂蕶:{1:c}", item.Name, item.Separate))
		///		Next
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <exception cref="InvalidOperationException">
		///	ڑԂł͂܂B(<see cref="Connect"/>ĂȂAĂяoĂ܂B
		///	</exception>
		///	<exception cref="nMailException">
		///	T[oƂ̌MɃG[܂B
		/// <see cref="nMailException.Message"/>ɃG[bZ[WA
		/// <see cref="nMailException.ErrorCode"/>ɃG[R[h܂B
		/// </exception>
		public void GetNameSpace()
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4GetNameSpace(_socket);
			if(_err < 0)
			{
				throw new nMailException("GetNameSpace: " + Options.ErrorMessage, _err);
			}
			else
			{
				int [] c1 = { NameSpacePersonalCount, NameSpaceOtherCount, NameSpaceSharedCount };
				int [] c2 = { NameSpacePersonalNo, NameSpaceOtherNo, NameSpaceSharedNo };
				int no, count;
				SetHeaderSize();
				for(int name_no = 0 ; name_no < NameSpaceMax ; name_no++) {
					count = Imap4GetNameSpaceStatus(_socket, c1[name_no], null, null, 0);
					_namespace_list[name_no] = new NameSpaceStatus[count];
					for(no = 0 ; no < count ; no++) {
						StringBuilder separate = new StringBuilder(_header_size);
						StringBuilder name = new StringBuilder(_header_size);
						if(Imap4GetNameSpaceStatus(_socket, c2[name_no] | no, separate, name, _header_size) == Success)
						{
							_namespace_list[name_no][no].Name = name.ToString();
							_namespace_list[name_no][no].Separate = separate[0];
						}
					}
				}
			}
		}

		/// <summary>
		/// ptw蕶쐬܂B
		/// </summary>
		/// <remarks>
		/// tw蕶쐬܂B
		/// <para>p : "09-Jul-2009"</para>
		/// <example>
		/// <para>
		///	[{bNX("inbox") 2009/8/1 ɓ[
		/// <code lang="cs">
		///	using(nMail.Imap4 imap = new nMail.Imap4("mail.example.com")) {
		///		try {
		///			imap.Connect();
		///			imap.Authenticate("imap4_id", "password");
		///			imap.SelectMailBox("inbox");
		///			imap.Search(SearchOn, MakeSearchDateString(new DateTime(2009, 8, 1));
		///			uint [] list = imap4.GetSearchMailResultList()
		///			foreach(uint no in list)
		///			{
		///				MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///			}
		///		}
		///		catch(nMail.nMailException nex)
		///		{
		///			MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message));
		///		}
		///		catch(Exception ex)
		///		{
		///			MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message));
		///		}
		///	}
		/// </code>
		/// <code lang="vbnet">
		///	' VB.NET 2005 ȍ~̏ꍇAC# Ɠl using gpł܂B
		///	Dim imap As nMail.Imap4 = New nMail.Imap4("mail.example.com")
		///	Try
		///		imap.Connect()
		///		imap.Authenticate("imap4_id", "password")
		///		imap.SelectMailBox("inbox")
		///		imap.Search(SearchOn, MakeSearchDateString(new DateTime(2009, 8, 1))
		///		Dim list As Integer() = imap4.GetSearchMailResultList()
		///		For Each no As Integer In list
		///			MessageBox.Show(String.Format("ʃ[ԍ {0}", no));
		///		Next
		///	Catch nex As nMail.nMailException
		///		MessageBox.Show(String.Format("G[ ԍ:{0:d} bZ[W:{1:s}", nex.ErrorCode, nex.Message))
		///	Catch ex As Exception
		///		MessageBox.Show(String.Format("G[ bZ[W:{0:s}", ex.Message))
		///	Finally
		///		imap.Dispose()
		///	End Try
		/// </code>
		/// </para>
		/// </example>
		/// </remarks>
		/// <returns>쐬tw蕶</returns>
		public string MakeSearchDateString(DateTime tm)
		{
			StringBuilder _datestring = new StringBuilder(DateStringSize);
			MakeDateString(_datestring, tm.Year, tm.Month, tm.Day, tm.Hour, tm.Minute, tm.Second, DateImap4);
			return _datestring.ToString();
		}
		/// <summary>
		/// AppenMailpw蕶쐬܂B
		/// </summary>
		/// <remarks>
		/// w蕶쐬܂B
		/// <para>AppendMailp : "09-Jul-2009 15:10:30"</para>
		/// <para>̂Ƃ AppendMail ŃAbv[hۂ̃T[oIɎwɂ</para>
		/// <para>@Imap4 NX̃\bhł͑ΉĂ܂B</para>
		/// <para>@Date wb_tB[h̒l <see cref="MakeFieldDateString"/> ō쐬ĕt邱Ƃł܂B</para>
		/// </remarks>
		/// <returns>쐬w蕶</returns>
		public string MakeAppendDateString(DateTime tm)
		{
			StringBuilder _datestring = new StringBuilder(DateStringSize);
			MakeDateString(_datestring, tm.Year, tm.Month, tm.Day, tm.Hour, tm.Minute, tm.Second, DateTimeImap4);
			return _datestring.ToString();
		}
		/// <summary>
		/// Date wb_tB[hpw蕶쐬܂B
		/// </summary>
		/// <remarks>
		/// w蕶쐬܂B
		/// <para>Date wb_tB[hp : "Thu, 9 Jul 2009 15:10:30 +09:00"</para>
		/// <para><see cref="AppendMail"/> Ŏw̓ Date wb_tB[htꍇɎgp܂B</para>
		/// </remarks>
		/// <returns>쐬w蕶</returns>
		public string MakeFieldDateString(DateTime tm)
		{
			StringBuilder _datestring = new StringBuilder(DateStringSize);
			MakeDateString(_datestring, tm.Year, tm.Month, tm.Day, tm.Hour, tm.Minute, tm.Second, DateTimeSmtp);
			return _datestring.ToString();
		}
		/// <summary>
		/// Ȃɂs܂
		/// </summary>
		/// <remarks>
		/// T[oƂ̐ڑ^CAEgh~Ɏgp܂B
		/// </remarks>
		public void NoOperation()
		{
			if(_socket == (IntPtr)ErrorSocket) {
				throw new InvalidOperationException();
			}
			_err = Imap4NoOperation(_socket);
			if(_err < 0)
			{
				throw new nMailException("NoOperation: " + Options.ErrorMessage, _err);
			}
		}
		/// <summary>
		/// Ytt@C̔z擾܂B
		/// </summary>
		/// <returns>Ytt@C̔z</returns>
		public string[] GetFileNameList()
		{
			if(_filename_list == null)
			{
				return new string[0];
			}
			else
			{
				return (string[])_filename_list.Clone();
			}
		}
		/// <summary>
		/// [{bNX̔z擾܂B
		/// </summary>
		/// <returns>[{bNX̔z</returns>
		public MailBoxStatus[] GetMailBoxStatusList()
		{
			return (MailBoxStatus[])_mailbox_list.Clone();
		}
		/// <summary>
		/// MIME \̔z擾܂B
		/// </summary>
		/// <returns>MIME \̔z</returns>
		public MimeStructureStatus[] GetMimeStructureStatusList()
		{
			return (MimeStructureStatus[])_mime_list.Clone();
		}
		/// <summary>
		/// ʂ̔z擾܂B
		/// </summary>
		/// <returns>ʂ̔z</returns>
		public uint[] GetSearchMailResultList()
		{
			return (uint[])_search_list.Clone();
		}
		/// <summary>
		/// lOԂ̔z擾܂B
		/// </summary>
		/// <remarks>
		///	<para><see cref="GetNameSpace"/>sɌĂяoKv܂B</para>
		/// </remarks>
		/// <returns>lOԏ̔z</returns>
		public NameSpaceStatus[] GetNameSpacePersonalStatusList()
		{
			return (NameSpaceStatus[])_namespace_list[NameSpacePersonal].Clone();
		}
		/// <summary>
		/// lOԂ̔z擾܂B
		/// </summary>
		/// <remarks>
		///	<para><see cref="GetNameSpace"/>sɌĂяoKv܂B</para>
		/// </remarks>
		/// <returns>lOԏ̔z</returns>
		public NameSpaceStatus[] GetNameSpaceOtherStatusList()
		{
			return (NameSpaceStatus[])_namespace_list[NameSpaceOther].Clone();
		}
		/// <summary>
		/// LOԂ̔z擾܂B
		/// </summary>
		/// <remarks>
		///	<para><see cref="GetNameSpace"/>sɌĂяoKv܂B</para>
		/// </remarks>
		/// <returns>LOԏ̔z</returns>
		public NameSpaceStatus[] GetNameSpaceSharedStatusList()
		{
			return (NameSpaceStatus[])_namespace_list[NameSpaceShared].Clone();
		}

		/// <summary>
		/// IMAP4 |[gԍłB
		/// </summary>
		/// <value>IMAP4 |[gԍ</value>
		public int Port {
			get
			{
				return _port;
			}
			set
			{
				_port = value;
			}
		}
		/// <summary>
		/// \PbgnhłB
		/// </summary>
		/// <value>\Pbgnh</value>
		public IntPtr Handle {
			get
			{
				return _socket;
			}
		}
		/// <summary>
		/// [{bNXɂ郁[łB
		/// </summary>
		/// <value>ݑIĂ郁[{bNXɂ郁[</value>
		public int Count {
			get
			{
				return _count;
			}
		}
		/// <summary>
		/// [̃TCYłB
		/// </summary>
		/// <value>[̃TCY</value>
		public int Size {
			get
			{
				return _size;
			}
		}
		/// <summary>
		/// IMAP4 T[ołB
		/// </summary>
		/// <value>IMAP4 T[o</value>
		public string HostName
		{
			get
			{
				return _host;
			}
			set
			{
				_host = value;
			}
		}
		/// <summary>
		/// IMAP4 [U[łB
		/// </summary>
		/// <value>IMAP4 [U[</value>
		public string Id
		{
			get
			{
				return _id;
			}
			set
			{
				_id = value;
			}
		}
		/// <summary>
		/// IMAP4 pX[hłB
		/// </summary>
		/// <value>IMAP4 pX[h</value>
		public string Password
		{
			get
			{
				return _password;
			}
			set
			{
				_password = value;
			}
		}
		/// <summary>
		/// Ytt@CۑtH_łB
		/// </summary>
		/// <remarks>
		/// null (VB.Net  nothing) ̏ꍇۑ܂B
		/// </remarks>
		/// <value>Ytt@CۑtH_</value>
		public string Path
		{
			get
			{
				return _path;
			}
			set
			{
				_path = value;
			}
		}
		/// <summary>
		/// [̖{łB
		/// </summary>
		/// <value>[{</value>
		public string Body
		{
			get
			{
				if(_body == null)
				{
					return "";
				}
				else
				{
					return _body.ToString();
				}
			}
		}
		/// <summary>
		/// [̌łB
		/// </summary>
		/// <value>[̌</value>
		public string Subject
		{
			get
			{
				if(_subject == null)
				{
					return "";
				}
				else
				{
					return _subject.ToString();
				}
			}
		}
		/// <summary>
		/// [̑M̕łB
		/// </summary>
		/// <value>[M</value>
		public string DateString
		{
			get
			{
				if(_date == null)
				{
					return "";
				}
				else
				{
					return _date.ToString();
				}
			}
		}
		/// <summary>
		/// [̍olłB
		/// </summary>
		/// <value>[̍ol</value>
		public string From
		{
			get
			{
				if(_from == null)
				{
					return "";
				}
				else
				{
					return _from.ToString();
				}
			}
		}
		/// <summary>
		/// [̃wb_łB
		/// </summary>
		/// <value>[̃wb_</value>
		public string Header
		{
			get
			{
				if(_header == null)
				{
					return "";
				}
				else
				{
					return _header.ToString();
				}
			}
			set
			{
				_header = new StringBuilder(value);
			}
		}
		/// <summary>
		/// Ytt@CłB
		/// </summary>
		/// <remarks>
		/// ̓Ytt@CꍇA"," ŋ؂Ċi[܂B
		/// <see cref="Options.SplitChar"/>ŋ؂蕶ύXł܂B
		/// </remarks>
		/// <value>Ytt@C</value>
		public string FileName
		{
			get
			{
				if(_filename == null)
				{
					return "";
				}
				else
				{
					return _filename.ToString();
				}
			}
		}
		/// <summary>
		/// Ytt@C̔złB
		/// </summary>
		///	<remarks>
		/// ̃vpeB͌݊̂߂ɎcĂ܂B
		///	<see cref="GetFileNameList"/>Ŕz擾Ďgp悤ɂĂB
		///	</remarks>
		/// <value>Ytt@C̔z</value>
		public string[] FileNameList
		{
			get
			{
				return _filename_list;
			}
		}
		/// <summary>
		/// [{bNX̔z
		/// </summary>
		///	<remarks>
		///	<see cref="GetMailBoxStatusList"/>Ŕz擾Ďgp̂𐄑E܂B
		///	</remarks>
		/// <value>[{bNX̔z</value>
		public MailBoxStatus[] MailBoxStatusList
		{
			get
			{
				return _mailbox_list;
			}
		}
		/// <summary>
		/// MIME \̔z
		/// </summary>
		///	<remarks>
		///	<see cref="GetMimeStructureStatusList"/>Ŕz擾Ďgp̂𐄑E܂B
		///	</remarks>
		/// <value>MIME \̔z</value>
		public MimeStructureStatus[] MimeStructureStatusList
		{
			get
			{
				return _mime_list;
			}
		}
		/// <summary>
		/// ʂ̔z
		/// </summary>
		///	<remarks>
		///	<see cref="GetSearchMailResultList"/>Ŕz擾Ďgp̂𐄑E܂B
		///	</remarks>
		/// <value>ʂ̔z</value>
		public uint[] SearchMailResultList
		{
			get
			{
				return _search_list;
			}
		}
		/// <summary>
		/// lOԏ̔z
		/// </summary>
		///	<remarks>
		///	<see cref="GetNameSpacePersonalStatusList"/>Ŕz擾Ďgp̂𐄑E܂B
		///	</remarks>
		/// <value>lOԏ̔z</value>
		public NameSpaceStatus[] NameSpacePersonalStatusList
		{
			get
			{
				return _namespace_list[NameSpacePersonal];
			}
		}
		/// <summary>
		/// lOԏ̔z
		/// </summary>
		///	<remarks>
		///	<see cref="GetNameSpaceOtherStatusList"/>Ŕz擾Ďgp̂𐄑E܂B
		///	</remarks>
		/// <value>lOԏ̔z</value>
		public NameSpaceStatus[] NameSpaceOtherStatusList
		{
			get
			{
				return _namespace_list[NameSpaceOther];
			}
		}
		/// <summary>
		/// LOԏ̔z
		/// </summary>
		///	<remarks>
		///	<see cref="GetNameSpaceSharedStatusList"/>Ŕz擾Ďgp̂𐄑E܂B
		///	</remarks>
		/// <value>lOԏ̔z</value>
		public NameSpaceStatus[] NameSpaceSharedStatusList
		{
			get
			{
				return _namespace_list[NameSpaceShared];
			}
		}
		/// <summary>
		/// wb_̃tB[hłB
		/// </summary>
		/// <value>wb_̃tB[h</value>
		public string FieldName
		{
			get
			{
				if(_field_name == null)
				{
					return "";
				}
				else
				{
					return _field_name;
				}
			}
		}
		/// <summary>
		/// wb_tB[h̓ełB
		/// </summary>
		/// <value>wb_tB[h̓e</value>
		public string Field
		{
			get
			{
				if(_field == null)
				{
					return "";
				}
				else
				{
					return _field.ToString();
				}
			}
		}
		/// <summary>
		/// [ UID łB
		/// </summary>
		/// <value>[ UID</value>
		public uint Uid
		{
			get
			{
				return _uid;
			}
		}
		/// <summary>
		/// IMAP4 Fؕ@łB
		/// </summary>
		/// <remarks>
		/// <para><see cref="AuthLogin"/>  LOGIN gp܂B</para>
		/// <para><see cref="AuthPlain"/>  PLAIN gp܂B</para>
		/// <para><see cref="AuthCramMd5"/> CRAM MD5 gp܂B</para>
		/// <para><see cref="AuthDigestMd5"/> DIGEST MD5 gp܂B</para>
		/// <para>C#  | AVisual Basic ł or ŕݒ\łB</para>
		/// <para>DIGEST MD5->CRAM MD5PLAINLOGIN ̏ԂŔF؂݂܂B</para>
		///	<para>ftHgl AuthLogin łB</para>
		/// </remarks>
		/// <value>IMAP4 ̔Fؕ@</value>
		public int AuthMode
		{
			get
			{
				return _mode;
			}
			set
			{
				_mode = value;
			}
		}
		/// <summary>
		/// [g@\wtOłB
		/// </summary>
		/// <remarks>
		/// <para><see cref="SuspendAttachmentFile"/>Ytt@CMňꎞx~̈ڂɎw肵܂B</para>
		/// <para><see cref="SuspendNext"/>Ytt@CMňꎞx~̓ڈȍ~Ɏw肵܂B</para>
		/// </remarks>
		public int Flag
		{
			get
			{
				return _flag;
			}
			set
			{
				_flag = value;
			}
		}
		/// <summary>
		/// MIME p[g擾͕ۑ̐ݒtOłB
		/// </summary>
		/// <remarks>
		/// <para><see cref="MimePeek"/>ǃtO𗧂Ă܂B</para>
		/// <para><see cref="MimeNoDecode"/>fR[h܂B</para>
		/// </remarks>
		public int MimeFlag
		{
			get
			{
				return _mime_flag;
			}
			set
			{
				_mime_flag = value;
			}
		}
		/// <summary>
		/// [bZ[W̃tOłB
		/// </summary>
		/// <remarks>
		/// <para><see cref="MessageAnswerd"/>ԐMς݃tOtĂ܂B</para>
		/// <para><see cref="MessageDeleted"/>}[NtĂ܂B</para>
		/// <para><see cref="MessageDraft"/>etOtĂ܂B</para>
		/// <para><see cref="MessageFlagged"/>dvtOtĂ܂B</para>
		/// <para><see cref="MessageRecent"/>tOtĂ܂B</para>
		/// <para><see cref="MessageSeen"/>ǃtOtĂ܂B</para>
		/// </remarks>
		public int MessageFlag
		{
			get
			{
				return _message_flag;
			}
		}
		/// <summary>
		/// [w肷ۂ UID gp邩ǂ̃tOłB
		/// </summary>
		public bool UseUid
		{
			get
			{
				return _useuid_flag;
			}
			set
			{
				_useuid_flag = value;
				if(_useuid_flag) {
					_useuid = UseUidValue;
				} else {
					_useuid = 0;
				}
			}
		}
		/// <summary>
		/// G[ԍłB
		/// </summary>
		/// <value>G[ԍ</value>
		public int ErrorCode
		{
			get
			{
				return _err;
			}
		}
		/// <summary>
		/// text/html p[gۑt@C̖OłB
		/// </summary>
		/// <value>t@C</value>
		public string HtmlFile
		{
			get
			{
				if(_html_file == null)
				{
					return "";
				}
				else
				{
					return _html_file.ToString();
				}
			}
		}
		/// <summary>
		/// SSL ݒtOłB
		/// </summary>
		/// <value>SSL ݒtO</value>
		public int SSL {
			get
			{
				return _ssl;
			}
			set
			{
				_ssl = value;
			}
		}
		/// <summary>
		/// SSL NCAgؖłB
		/// </summary>
		/// <remarks>
		/// null ̏ꍇw肵܂B
		/// </remarks>
		/// <value>SSL NCAgؖ</value>
		public string CertName
		{
			get
			{
				return _cert_name;
			}
			set
			{
				_cert_name = value;
			}
		}
		/// <summary>
		/// message/rfc822 p[gۑt@C̖OłB
		/// </summary>
		/// <value>t@C</value>
		public string Rfc822File
		{
			get
			{
				if(_rfc822_file == null)
				{
					return "";
				}
				else
				{
					return _rfc822_file.ToString();
				}
			}
		}
	}
}

/**
	DLL 錾

	[DllImport("nMail.DLL", EntryPoint="NMailInitializeWinSock")]
	protected static extern bool NMailInitializeWinSock();

	[DllImport("nMail.DLL", EntryPoint="NMailEndWinSock")]
	protected static extern bool NMailEndWinSock();

	[DllImport("nMail.DLL", EntryPoint="NMailPop3Connect", CharSet=CharSet.Auto)]
	protected static extern int NMailPop3Connect(string Host);

	[DllImport("nMail.DLL", EntryPoint="NMailPop3ConnectPortNo", CharSet=CharSet.Auto)]
	protected static extern int NMailPop3ConnectPortNo(string Host, int Port);

	[DllImport("nMail.DLL", EntryPoint="NMailPop3Authenticate", CharSet=CharSet.Auto)]
	protected static extern int NMailPop3Authenticate(int Socket, string Id, string Pass, bool APopFlag);

	[DllImport("nMail.DLL", EntryPoint="NMailPop3Close")]
	protected static extern int NMailPop3Close(int Socket);

	[DllImport("nMail.DLL", EntryPoint="NMailPop3GetMailStatus", CharSet=CharSet.Auto)]
	protected static extern int NMailPop3GetMailStatus(int Socket, int No, StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, bool SizeFlag);

	[DllImport("nMail.DLL", EntryPoint="NMailPop3GetMailSize")]
	protected static extern int NMailPop3GetMailSize(int Socket, int No);

	[DllImport("nMail.DLL", EntryPoint="NMailPop3GetMail", CharSet=CharSet.Auto)]
	protected static extern int NMailPop3GetMail(int Socket, int No, StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, StringBuilder Body, string Path, StringBuilder FileName);

	[DllImport("nMail.DLL", EntryPoint="NMailPop3GetMailPartial", CharSet=CharSet.Auto)]
	protected static extern int NMailPop3GetMailPartial(int Socket, int No, StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, StringBuilder Body, string Path, StringBuilder FileName);

	[DllImport("nMail.DLL", EntryPoint="NMailPop3GetMailEx", CharSet=CharSet.Auto)]
	protected static extern int NMailPop3GetMailEx(int Socket, int No, StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, StringBuilder Body, string Path, StringBuilder FileName, BYTE Temp[], int Flag);

	[DllImport("nMail.DLL", EntryPoint="NMailPop3DeleteMail")]
	protected static extern int NMailPop3DeleteMail(int Socket, int No);

	[DllImport("nMail.DLL", EntryPoint="NMailPop3GetAttachmentFileStatus"), CHarSet=CharSet.Auto]
	protected static extern int NMailPop3GetAttachmentFileStatus(int Socket, int No, StringBuilder Id, int Max);

	[DllImport("nMail.DLL", EntryPoint="NMailPop3GetUidl"), CHarSet=CharSet.Auto]
	protected static extern int NMailPop3GetUidl(int Socket, int No, StringBuilder Id, int Max);

	[DllImport("nMail.DLL", EntryPoint="NMailSmtpSendMail", CharSet=CharSet.Auto)]
	protected static extern int NMailSmtpSendMail(String HostName, String To, String Cc, String Bcc, String From, String Subject, String Body, String Header, String Path, int Flag);

	[DllImport("nMail.DLL", EntryPoint="NMailSmtpSendMailPortNo", CharSet=CharSet.Auto)]
	protected static extern int NMailSmtpSendMailPortNo(String HostName, String To, String Cc, String Bcc, String From, String Subject, String Body, String Header, String Path, int Flag, int PortNo);

	[DllImport("nMail.DLL", EntryPoint="NMailSmtpConnect", CharSet=CharSet.Auto)]
	protected static extern int NMailSmtpConnect(string Host);

	[DllImport("nMail.DLL", EntryPoint="NMailSmtpConnectPortNo", CharSet=CharSet.Auto)]
	protected static extern int NMailSmtpConnectPortNo(string Host, int PortNo);

	[DllImport("nMail.DLL", EntryPoint="NMailSmtpAuthenticate", CharSet=CharSet.Auto)]
	protected static extern int NMailSmtpAuthenticate(int Socket, string HostName, string Id, string Pass, int Mode);

	[DllImport("nMail.DLL", EntryPoint="NMailSmtpSendMailEx", CharSet=CharSet.Auto)]
	protected static extern int NMailSmtpSendMailEx(int Socket, string To, string Cc, string Bcc, string From, string Subject, String Body, String Header, String Path, BYTE Temp[], int Flag);

	[DllImport("nMail.DLL", EntryPoint="NMailSmtpClose")]
	protected static extern bool NMailSmtpClose(int Socket);

	[DllImport("nMail.DLL", EntryPoint="NMailGetHeaderField"), CharSet=CharSet.Auto]
	protected static extern int NMailGetHeaderField(StringBuilder Field, string Header, string Name, int Size);

	[DllImport("nMail.DLL", EntryPoint="NMailDecodeHeaderField"), CharSet=CharSet.Auto]
	protected static extern int NMailDecodeHeaderField(StringBuilder Destination, string Source, int Size);

	[DllImport("nMail.DLL", EntryPoint="NMailAttachmentFileFirst"), CharSet=CharSet.Auto]
	protected static extern int NMailAttachmentFileFirst(BYTE Temp[], StringBuilder Subject, StringBuilder Date, StringBuilder From, StringBuilder Header, StringBuilder Body, string Path, StringBuilder FileName, string FirstHeader, string FirstBody);

	[DllImport("nMail.DLL", EntryPoint="NMailAttachmentFileNext"), CharSet=CharSet.Auto]
	protected static extern int NMailAttachmentFileNext(BYTE Temp[], string NextHeader, string NextBody);

	[DllImport("nMail.DLL", EntryPoint="NMailAttachmentFileClose")]
	protected static extern bool NMailAttachmentFileClose(BYTE Temp[]);

	[DllImport("nMail.DLL", EntryPoint="NMailAttachmentFileStatus"), CharSet=CharSet.Auto]
	protected static extern int NMailAttachmentFileStatus(string Header, StringBuilder Id, int Size);

	[DllImport("nMail.DLL", EntryPoint="NMailGetVersion")]
	protected static extern int NMailGetVersion();

	[DllImport("nMail.DLL", EntryPoint="NMailGetOption")]
	protected static extern int NMailGetOption(int Option);

	[DllImport("nMail.DLL", EntryPoint="NMailSetOption")]
	protected static extern int NMailSetOption(int Option, int Value);

	[DllImport("nMail.DLL", EntryPoint="NMailGetMessage", CharSet=CharSet.Auto)]
	protected static extern void NMailGetMessage(int Type, StringBuilder Message, int Size);

	[DllImport("nMail.DLL", EntryPoint="NMailGetSuspendNumber", CharSet=CharSet.Auto)]
	protected static extern void NMailGetSuspendNumber(string Path);
**/

