using System;
using System.IO;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using nMail;
using System.Diagnostics;
using System.Runtime.InteropServices;

namespace csimap4
{
	/// <summary>
	/// FormMain ̊Tv̐łB
	/// </summary>
	public class FormMain : System.Windows.Forms.Form
	{
		private System.Windows.Forms.TreeView treeMailBox;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.ListView listMail;
		private System.Windows.Forms.Splitter splitter2;
		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuCreate;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuRedisp;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuExit;
		private System.Windows.Forms.MenuItem menuItem10;
		private System.Windows.Forms.ImageList imageMailbox;
		private System.Windows.Forms.ColumnHeader columnSubject;
		private System.Windows.Forms.ColumnHeader columnFrom;
		private System.Windows.Forms.ColumnHeader columnDate;
		private System.Windows.Forms.MenuItem menuOption;
		private System.Windows.Forms.ListView listAttach;
		private System.Windows.Forms.TextBox textBody;
		private System.Windows.Forms.ColumnHeader columnFlag;
		private System.Windows.Forms.ImageList imageAttach;
		private System.Windows.Forms.ContextMenu contextMail;
		private System.Windows.Forms.ContextMenu contextAttach;
		private System.Windows.Forms.MenuItem menuReply;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuDeleteMail;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuProperty;
		private System.Windows.Forms.MenuItem menuOpenAttach;
		private System.Windows.Forms.MenuItem menuSaveAttach;
		private System.Windows.Forms.ContextMenu contextTree;
		private System.Windows.Forms.MenuItem menuCreateMailBox;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuDeleteMailBox;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.MenuItem menuRenameMailBox;
		private System.Windows.Forms.SaveFileDialog saveFileDialog;
		private System.Windows.Forms.Timer timer;
		private System.Windows.Forms.ColumnHeader columnAttach;
		private System.ComponentModel.IContainer components;

		public FormMain()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormMain));
			this.treeMailBox = new System.Windows.Forms.TreeView();
			this.contextTree = new System.Windows.Forms.ContextMenu();
			this.menuCreateMailBox = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.menuRenameMailBox = new System.Windows.Forms.MenuItem();
			this.menuItem9 = new System.Windows.Forms.MenuItem();
			this.menuDeleteMailBox = new System.Windows.Forms.MenuItem();
			this.imageMailbox = new System.Windows.Forms.ImageList(this.components);
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.listMail = new System.Windows.Forms.ListView();
			this.columnFlag = new System.Windows.Forms.ColumnHeader();
			this.columnAttach = new System.Windows.Forms.ColumnHeader();
			this.columnSubject = new System.Windows.Forms.ColumnHeader();
			this.columnFrom = new System.Windows.Forms.ColumnHeader();
			this.columnDate = new System.Windows.Forms.ColumnHeader();
			this.contextMail = new System.Windows.Forms.ContextMenu();
			this.menuReply = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuDeleteMail = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuProperty = new System.Windows.Forms.MenuItem();
			this.splitter2 = new System.Windows.Forms.Splitter();
			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuCreate = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuRedisp = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuExit = new System.Windows.Forms.MenuItem();
			this.menuItem10 = new System.Windows.Forms.MenuItem();
			this.menuOption = new System.Windows.Forms.MenuItem();
			this.listAttach = new System.Windows.Forms.ListView();
			this.contextAttach = new System.Windows.Forms.ContextMenu();
			this.menuOpenAttach = new System.Windows.Forms.MenuItem();
			this.menuSaveAttach = new System.Windows.Forms.MenuItem();
			this.imageAttach = new System.Windows.Forms.ImageList(this.components);
			this.textBody = new System.Windows.Forms.TextBox();
			this.saveFileDialog = new System.Windows.Forms.SaveFileDialog();
			this.timer = new System.Windows.Forms.Timer(this.components);
			this.SuspendLayout();
			// 
			// treeMailBox
			// 
			this.treeMailBox.AllowDrop = true;
			this.treeMailBox.ContextMenu = this.contextTree;
			this.treeMailBox.Dock = System.Windows.Forms.DockStyle.Left;
			this.treeMailBox.Font = new System.Drawing.Font("lr SVbN", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.treeMailBox.HideSelection = false;
			this.treeMailBox.ImageList = this.imageMailbox;
			this.treeMailBox.LabelEdit = true;
			this.treeMailBox.Location = new System.Drawing.Point(0, 0);
			this.treeMailBox.Name = "treeMailBox";
			this.treeMailBox.ShowRootLines = false;
			this.treeMailBox.Size = new System.Drawing.Size(121, 457);
			this.treeMailBox.TabIndex = 1;
			this.treeMailBox.MouseDown += new System.Windows.Forms.MouseEventHandler(this.treeMailBox_MouseDown);
			this.treeMailBox.DragOver += new System.Windows.Forms.DragEventHandler(this.treeMailBox_DragOver);
			this.treeMailBox.KeyUp += new System.Windows.Forms.KeyEventHandler(this.treeMailBox_KeyUp);
			this.treeMailBox.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.treeMailBox_AfterSelect);
			this.treeMailBox.BeforeSelect += new System.Windows.Forms.TreeViewCancelEventHandler(this.treeMailBox_BeforeSelect);
			this.treeMailBox.AfterLabelEdit += new System.Windows.Forms.NodeLabelEditEventHandler(this.treeMailBox_AfterLabelEdit);
			this.treeMailBox.DragEnter += new System.Windows.Forms.DragEventHandler(this.treeMailBox_DragEnter);
			this.treeMailBox.BeforeLabelEdit += new System.Windows.Forms.NodeLabelEditEventHandler(this.treeMailBox_BeforeLabelEdit);
			this.treeMailBox.DragDrop += new System.Windows.Forms.DragEventHandler(this.treeMailBox_DragDrop);
			// 
			// contextTree
			// 
			this.contextTree.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.menuCreateMailBox,
																						this.menuItem7,
																						this.menuRenameMailBox,
																						this.menuItem9,
																						this.menuDeleteMailBox});
			this.contextTree.Popup += new System.EventHandler(this.contextTree_Popup);
			// 
			// menuCreateMailBox
			// 
			this.menuCreateMailBox.Index = 0;
			this.menuCreateMailBox.Text = "[{bNX̍쐬(&C)";
			this.menuCreateMailBox.Click += new System.EventHandler(this.menuCreateMailBox_Click);
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 1;
			this.menuItem7.Text = "-";
			// 
			// menuRenameMailBox
			// 
			this.menuRenameMailBox.Index = 2;
			this.menuRenameMailBox.Text = "[{bNX̖OύX(&R)";
			this.menuRenameMailBox.Click += new System.EventHandler(this.menuRenameMailBox_Click);
			// 
			// menuItem9
			// 
			this.menuItem9.Index = 3;
			this.menuItem9.Text = "-";
			// 
			// menuDeleteMailBox
			// 
			this.menuDeleteMailBox.Index = 4;
			this.menuDeleteMailBox.Text = "[{bNX̍폜(&D)";
			this.menuDeleteMailBox.Click += new System.EventHandler(this.menuDeleteMailBox_Click);
			// 
			// imageMailbox
			// 
			this.imageMailbox.ImageSize = new System.Drawing.Size(16, 16);
			this.imageMailbox.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageMailbox.ImageStream")));
			this.imageMailbox.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(121, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(3, 457);
			this.splitter1.TabIndex = 2;
			this.splitter1.TabStop = false;
			// 
			// listMail
			// 
			this.listMail.AllowDrop = true;
			this.listMail.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					   this.columnFlag,
																					   this.columnAttach,
																					   this.columnSubject,
																					   this.columnFrom,
																					   this.columnDate});
			this.listMail.ContextMenu = this.contextMail;
			this.listMail.Dock = System.Windows.Forms.DockStyle.Top;
			this.listMail.Font = new System.Drawing.Font("lr SVbN", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.listMail.FullRowSelect = true;
			this.listMail.HideSelection = false;
			this.listMail.Location = new System.Drawing.Point(124, 0);
			this.listMail.MultiSelect = false;
			this.listMail.Name = "listMail";
			this.listMail.Size = new System.Drawing.Size(508, 128);
			this.listMail.TabIndex = 3;
			this.listMail.View = System.Windows.Forms.View.Details;
			this.listMail.ItemDrag += new System.Windows.Forms.ItemDragEventHandler(this.listMail_ItemDrag);
			this.listMail.SelectedIndexChanged += new System.EventHandler(this.listMail_SelectedIndexChanged);
			// 
			// columnFlag
			// 
			this.columnFlag.Text = "";
			this.columnFlag.Width = 18;
			// 
			// columnAttach
			// 
			this.columnAttach.Text = "";
			this.columnAttach.Width = 19;
			// 
			// columnSubject
			// 
			this.columnSubject.Text = "";
			this.columnSubject.Width = 223;
			// 
			// columnFrom
			// 
			this.columnFrom.Text = "ol";
			this.columnFrom.Width = 116;
			// 
			// columnDate
			// 
			this.columnDate.Text = "t";
			this.columnDate.Width = 109;
			// 
			// contextMail
			// 
			this.contextMail.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.menuReply,
																						this.menuItem2,
																						this.menuDeleteMail,
																						this.menuItem3,
																						this.menuProperty});
			this.contextMail.Popup += new System.EventHandler(this.contextMail_Popup);
			// 
			// menuReply
			// 
			this.menuReply.Index = 0;
			this.menuReply.Text = "ԐM(&R)";
			this.menuReply.Click += new System.EventHandler(this.menuReply_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.Text = "-";
			// 
			// menuDeleteMail
			// 
			this.menuDeleteMail.Index = 2;
			this.menuDeleteMail.Text = "폜(&D)";
			this.menuDeleteMail.Click += new System.EventHandler(this.menuDeleteMail_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 3;
			this.menuItem3.Text = "-";
			// 
			// menuProperty
			// 
			this.menuProperty.Index = 4;
			this.menuProperty.Text = "vpeB(&P)";
			this.menuProperty.Click += new System.EventHandler(this.menuProperty_Click);
			// 
			// splitter2
			// 
			this.splitter2.Cursor = System.Windows.Forms.Cursors.HSplit;
			this.splitter2.Dock = System.Windows.Forms.DockStyle.Top;
			this.splitter2.Location = new System.Drawing.Point(124, 128);
			this.splitter2.Name = "splitter2";
			this.splitter2.Size = new System.Drawing.Size(508, 3);
			this.splitter2.TabIndex = 4;
			this.splitter2.TabStop = false;
			// 
			// mainMenu
			// 
			this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.menuItem1,
																					 this.menuItem10});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuCreate,
																					  this.menuItem4,
																					  this.menuRedisp,
																					  this.menuItem6,
																					  this.menuExit});
			this.menuItem1.Text = "t@C(&F)";
			// 
			// menuCreate
			// 
			this.menuCreate.Index = 0;
			this.menuCreate.Text = "쐬(&C)";
			this.menuCreate.Click += new System.EventHandler(this.menuCreate_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 1;
			this.menuItem4.Text = "-";
			// 
			// menuRedisp
			// 
			this.menuRedisp.Index = 2;
			this.menuRedisp.Text = "XV(&R)";
			this.menuRedisp.Click += new System.EventHandler(this.menuRedisp_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 3;
			this.menuItem6.Text = "-";
			// 
			// menuExit
			// 
			this.menuExit.Index = 4;
			this.menuExit.Text = "I(&X)";
			this.menuExit.Click += new System.EventHandler(this.menuExit_Click);
			// 
			// menuItem10
			// 
			this.menuItem10.Index = 1;
			this.menuItem10.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					   this.menuOption});
			this.menuItem10.Text = "ݒ(&O)";
			// 
			// menuOption
			// 
			this.menuOption.Index = 0;
			this.menuOption.Text = "ݒ(&O)";
			this.menuOption.Click += new System.EventHandler(this.menuOption_Click);
			// 
			// listAttach
			// 
			this.listAttach.ContextMenu = this.contextAttach;
			this.listAttach.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.listAttach.Font = new System.Drawing.Font("lr SVbN", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.listAttach.FullRowSelect = true;
			this.listAttach.Location = new System.Drawing.Point(124, 433);
			this.listAttach.MultiSelect = false;
			this.listAttach.Name = "listAttach";
			this.listAttach.Size = new System.Drawing.Size(508, 24);
			this.listAttach.SmallImageList = this.imageAttach;
			this.listAttach.TabIndex = 6;
			this.listAttach.View = System.Windows.Forms.View.SmallIcon;
			this.listAttach.Visible = false;
			this.listAttach.DoubleClick += new System.EventHandler(this.listAttach_DoubleClick);
			// 
			// contextAttach
			// 
			this.contextAttach.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						  this.menuOpenAttach,
																						  this.menuSaveAttach});
			// 
			// menuOpenAttach
			// 
			this.menuOpenAttach.Index = 0;
			this.menuOpenAttach.Text = "J(&O)";
			this.menuOpenAttach.Click += new System.EventHandler(this.menuOpenAttach_Click);
			// 
			// menuSaveAttach
			// 
			this.menuSaveAttach.Index = 1;
			this.menuSaveAttach.Text = "ۑ(&S)";
			this.menuSaveAttach.Click += new System.EventHandler(this.menuSaveAttach_Click);
			// 
			// imageAttach
			// 
			this.imageAttach.ImageSize = new System.Drawing.Size(16, 16);
			this.imageAttach.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// textBody
			// 
			this.textBody.Dock = System.Windows.Forms.DockStyle.Fill;
			this.textBody.Font = new System.Drawing.Font("lr SVbN", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.textBody.Location = new System.Drawing.Point(124, 131);
			this.textBody.Multiline = true;
			this.textBody.Name = "textBody";
			this.textBody.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.textBody.Size = new System.Drawing.Size(508, 302);
			this.textBody.TabIndex = 7;
			this.textBody.Text = "";
			// 
			// saveFileDialog
			// 
			this.saveFileDialog.Filter = "ׂẴt@C|*.*";
			// 
			// timer
			// 
			this.timer.Enabled = true;
			this.timer.Interval = 1000;
			this.timer.Tick += new System.EventHandler(this.timer_Tick);
			// 
			// FormMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(632, 457);
			this.Controls.Add(this.textBody);
			this.Controls.Add(this.listAttach);
			this.Controls.Add(this.splitter2);
			this.Controls.Add(this.listMail);
			this.Controls.Add(this.splitter1);
			this.Controls.Add(this.treeMailBox);
			this.Menu = this.mainMenu;
			this.Name = "FormMain";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "C# (nMail.DLL IMAP4 sample)";
			this.Load += new System.EventHandler(this.FormMain_Load);
			this.Closed += new System.EventHandler(this.FormMain_Closed);
			this.Activated += new System.EventHandler(this.FormMain_Activated);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// AvP[ṼC Gg |CgłB
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new FormMain());
		}

		// [{bNXc[̕ێf[^
		public class TreeNodeData
		{
			public string Path;		// [{bNXtpX
			public char Separate;	// [{bNX؂蕶
			public int Flag;		// [{bNXtO
			public TreeNodeData(string path, char separate, int flag)
			{
				Path = path;
				Separate = separate;
				Flag = flag;
			}
		}

		// [{bNXc[̉摜ԍ
		enum IconImage {
			User,
			Inbox,
			Sent,
			Trash,
			Folder,
			NoSelect
		}
		// [T[o̐ݒ
		public class MailParameter
		{
			public string Smtp;
			public string Imap4;
			public string Address;
			public int SmtpPort;
			public int SmtpAuth;
			public int SmtpSsl;
			public int Imap4Port;
			public int Imap4Auth;
			public int Imap4Ssl;
		}
		private const int ContinueTimerCount = 60*25;
		private const string XmlFileName = "csimap4param.xml"; // [ݒۑt@C
		private string Id = "";				// IMAP4 ID
		private string Password = "";		// IMAP4 pX[h
		private string MailBox = "";		// ݑI𒆂̃[{bNX
		private string TrashMailBox = "";	// S~
		private string SentMailBox = "";	// M
		private bool FirstFlag = true;
		private bool DeleteFlag = false;	// [{bNXō폜H
		private MailParameter MailParam;	// [T[o̐ݒ
		private int TimerCount;
		private nMail.Imap4 imap;					// nMail.DLL IMAP4 NX

		private void FormMain_Load(object sender, System.EventArgs e)
		{
			MailParam = new MailParameter();
			MailParam.Imap4 = "";
			MailParam.Imap4Port = nMail.Imap4.StandardPortNo;
			MailParam.Imap4Ssl = 0;
			MailParam.Imap4Auth = nMail.Imap4.AuthLogin;
			MailParam.Smtp = "";
			MailParam.SmtpPort = nMail.Smtp.StandardPortNo;
			MailParam.SmtpSsl = 0;
			MailParam.SmtpAuth = 0;
			MailParam.Address = "";
			if(File.Exists(XmlFileName))
			{
				System.Xml.Serialization.XmlSerializer serializer = new System.Xml.Serialization.XmlSerializer(typeof(MailParameter));
				FileStream fs = new FileStream(XmlFileName, FileMode.Open);
				MailParam = (MailParameter)serializer.Deserialize(fs);
				fs.Close();
			} 
			// Winsock 
			Winsock.Initialize();
			Options.EnableConnectTimeout();
			// IMAP4
			imap = new nMail.Imap4();
			// UID gp
			imap.UseUid = true;
			// [{bNX
			MailBox = "INBOX";
			TimerCount = 0;
		}

		private void FormMain_Closed(object sender, System.EventArgs e)
		{
			// 폜tÔ[폜
			if(DeleteFlag)
			{
				imap.Expunge();
			}
			// ڑI
			imap.Close();
			// Winsock I
			Winsock.Done();
		}

		// IMAP4 F
		// łɐڑς݂Ȃ炻̂܂ܖ߂
		private bool Authenticate()
		{
			TimerCount = ContinueTimerCount;
			// ڑH
			if(!imap.IsConnected()) {
				try
				{
					imap.SSL = MailParam.Imap4Ssl;
					// ڑ
					imap.Connect(MailParam.Imap4, MailParam.Imap4Port);
					// F
					imap.Authenticate(Id, Password, MailParam.Imap4Auth);
					return true;
				}
				catch(nMail.nMailException nex)
				{
					if(nex.ErrorCode == nMail.Imap4.ErrorAuthenticate) 
					{
						MessageBox.Show(string.Format("F؃G[łB\r\n{0}", nex.Message));
						Id = "";
						Password = "";
					}
					else
					{
						MessageBox.Show(string.Format("T[o[ڑɃG[܂B\r\n{0}", nex.Message));
					}
				}
				catch(Exception ex)
				{
					Debug.WriteLine(ex.Message);
				}
				// G[Ȃ
				imap.Close();
				return false;
			}
			return true;
		}

		//	̂̃[{bNXo^ς݂H
		private TreeNode SearchNode(TreeNode node, string path)
		{
			foreach(TreeNode tn in node.Nodes)
			{
				TreeNode ctn;
				if((ctn = SearchNode(tn, path)) != null)
				{
					return ctn;
				}
				if(tn.Tag != null) 
				{
					TreeNodeData data = (TreeNodeData)tn.Tag;
					if(string.Compare(data.Path, path, true) == 0)
					{
						return tn;
					}
				}
			}
			return null;
		}

		// [{bNXc[ɒǉ
		private void AddTree(string name, char separate, int flag)
		{
			int no;
			TreeNode node, parent_node;
			string path;
			string [] folder = name.Split(separate);

			parent_node = treeMailBox.TopNode;
			treeMailBox.PathSeparator = separate.ToString();
			for(no = 0 ; no < folder.Length ; no++)
			{
				path = string.Join(separate.ToString(), folder, 0, no + 1);
				node = SearchNode(treeMailBox.TopNode, path);
				if(node == null)
				{
					int index;
					string text = folder[no];
					index = (int)IconImage.Folder;
					// IłȂ[{bNX
					if((flag & nMail.Imap4.MailBoxNoSelect) != 0)
					{
						index = (int)IconImage.NoSelect;
					}
					if(no == 0)
					{
						if(string.Compare(text, "inbox", true) == 0)
						{
							text = "M";
							index = (int)IconImage.Inbox;
						}
						else if(string.Compare(text, "sent", true) == 0)
						{
							SentMailBox = text;
							text = "M";
							index = (int)IconImage.Sent;
						}
						else if(string.Compare(text, "trash", true) == 0)
						{
							TrashMailBox = text;
							text = "S~";
							index = (int)IconImage.Trash;
						}
					}
					int insert_no = 0;
					foreach(TreeNode tn in parent_node.Nodes)
					{
						if(index < tn.ImageIndex)
						{
							break;
						}
						insert_no++;
					}
					node = new TreeNode(text, index, index);
					parent_node.Nodes.Insert(insert_no, node);
					node.Tag = new TreeNodeData(path, separate, flag);
					parent_node.Expand();
				}
				parent_node = node;
			}
		}

		// [{bNXc[r[ɕ\
		private bool GetMailBoxTree()
		{
			treeMailBox.Nodes.Clear();
			if(Authenticate())
			{
				try 
				{
					TreeNode add_node = treeMailBox.Nodes.Add(MailParam.Address);
					add_node.ImageIndex = (int)IconImage.User;
					// [{bNXꗗ
					imap.GetMailBoxList("", "*");
					nMail.Imap4.MailBoxStatus [] mailbox_list = imap.GetMailBoxStatusList();
					foreach(nMail.Imap4.MailBoxStatus mailbox in mailbox_list)
					{
						if(treeMailBox.TopNode.Tag == null) {
							treeMailBox.TopNode.Tag = new TreeNodeData("", mailbox.Separate, 0);
						}
						// c[r[ɍڒǉ
						AddTree(mailbox.Name, mailbox.Separate, mailbox.Flag);
					}
					// INBOX I
					treeMailBox.SelectedNode = SearchNode(treeMailBox.TopNode, MailBox);
					return true;
				}
				catch(nMail.nMailException nex)
				{
					MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
				}
				catch(Exception ex)
				{
					Debug.WriteLine(ex.Message);
				}
			}
			return false;
		}

		// ݑI𒆂̃[{bNX̃[ꗗ\
		private void GetMailList()
		{
			// ID ͂Ȃ̓_CAO\
			if(Id == "") 
			{
				if(!InputId()) 
				{
					return;
				}
			}
			// [{bNXꗗ܂\ĂȂ
			// 擾ĕ\
			if(treeMailBox.TopNode == null) 
			{
				if(!GetMailBoxTree())
				{
					return;
				}
			}
			textBody.Text = "";
			listMail.Items.Clear();
			listAttach.Visible = false;
			if(MailBox != "")
			{
				if(Authenticate())
				{
					try 
					{
						if(DeleteFlag)
						{
							// 폜tÔ[폜
							imap.Expunge();
							DeleteFlag = false;
						}
						// [{bNXI
						imap.SelectMailBox(MailBox);
						// [{bNX̍폜}[NȂ[ UID 擾
						imap.Search(nMail.Imap4.SearchUnDeleted);
						uint [] result_list = imap.GetSearchMailResultList();
						foreach(uint uid in result_list)
						{
							// [̃Xe[^X擾
							imap.GetStatus(uid);
							// .NET Framework 2.0 ȍ~łȂƃI[i[h[ʓ|Ȃ悤Ȃ̂ŁA
							// Ƃ肠ǂ""ƕ\邱Ƃ
							string seen = "";
							if((imap.MessageFlag & nMail.Imap4.MessageSeen) == 0)
							{
								seen = "";
							}
							string attach = "";
							if(imap.GetAttachmentFileStatus(uid)) 
							{
								attach = "Y";
							}
							string[] item = { seen, attach, imap.Subject, imap.From, imap.DateString };
							ListViewItem add_item = listMail.Items.Add(new ListViewItem(item));
							// UID ACeɕۑ
							add_item.Tag = uid;
						}
					}
					catch(nMail.nMailException nex)
					{
						MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
					}
					catch(Exception ex)
					{
						Debug.WriteLine(ex.Message);
					}
				}
			}
		}

		// ID ƃpX[h
		private bool InputId()
		{
			FormId form = new FormId();

			form.Id = Id;
			form.Password = Password;
			if(form.ShowDialog() == DialogResult.OK) 
			{
				Id = form.Id;
				Password = form.Password;
				if(Id != "" && Password != "") 
				{
					return true;
				}
			}
			return false;
		}

		// gqɑΉACR擾p API ֘A̐錾
		[DllImport("shell32.dll")]
		private static extern IntPtr SHGetFileInfo(string pszPath, uint dwFileAttributes, ref SHFILEINFO psfi, uint cbSizeFileInfo, uint uFlags);
		private const uint SHGFI_ICON = 0x0100;
		private const uint SHGFI_SMALLICON = 0x0001;
		private const uint SHGFI_USEFILEATTRIBUTES = 0x0010;
		private struct SHFILEINFO
		{
			public IntPtr hIcon;
			public IntPtr iIcon;
			public uint dwAttributes;
			[MarshalAs(UnmanagedType.ByValTStr, SizeConst = 260)]
			public string szDisplayName;
			[MarshalAs(UnmanagedType.ByValTStr, SizeConst = 80)]
			public string szTypeName;
		}; 

		// [ꗗ烁[I
		private void listMail_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(listMail.SelectedItems.Count > 0)
			{
				if(Authenticate()) 
				{
					try 
					{
						textBody.Text = "";
						// UID 擾
						uint uid = (uint)listMail.SelectedItems[0].Tag;
						int count = 0;
						// Ytt@C\Xgr[NA
						listAttach.Items.Clear();
						// Ytt@C̃ACRpC[WXgNA
						imageAttach.Images.Clear();
						// MIME \擾
						imap.GetMimeStructure(uid);
						nMail.Imap4.MimeStructureStatus [] mime_list = imap.GetMimeStructureStatusList();
						foreach(nMail.Imap4.MimeStructureStatus mime in mime_list)
						{
							// eLXgłΖ{ɕ\
							if(string.Compare(mime.Type, "text", true) == 0 && string.Compare(mime.SubType, "plain", true) == 0)
							{
								imap.GetMimePart(uid, mime.PartNo);
								textBody.Text = imap.Body;
							}
							else if(string.Compare(mime.Type, "multipart", true) != 0)
							{
								// Ytt@Cł΁At@CƃACR
								// Ytt@C\Xgr[ɕ\
								string name = mime.FileName;
								// HTML [̖{̂ noname.html ɂȂ̂ŁA
								// Ƃ肠킩₷ȖOɕύX
								if(name == "noname.html") 
								{
									name = "{.html";
								}
								// gqɑΉACR̎擾
								SHFILEINFO sf = new SHFILEINFO();
								SHGetFileInfo(name, 0, ref sf, (uint)Marshal.SizeOf(sf), SHGFI_ICON | SHGFI_SMALLICON | SHGFI_USEFILEATTRIBUTES);
								Icon icon = Icon.FromHandle(sf.hIcon);
								// Ytt@C\Xgr[ɒǉ
								imageAttach.Images.Add(icon);
								ListViewItem add_item = listAttach.Items.Add(name, count++);
								add_item.Tag = mime.PartNo;
							}
						}
						// Ytt@C΃Xgr[\
						listAttach.Visible = false;
						if(listAttach.Items.Count > 0)
						{
							listAttach.Visible = true;
						}
						listMail.SelectedItems[0].SubItems[0].Text = "";
					}
					catch(nMail.nMailException nex)
					{
						MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
					}
					catch(Exception ex)
					{
						Debug.WriteLine(ex.Message);
					}
				}
			}
		}

		private void FormMain_Activated(object sender, System.EventArgs e)
		{
			if(FirstFlag) 
			{
				FirstFlag = false;
				if(MailParam.Imap4 == "" || MailParam.Imap4Port == 0) 
				{
					menuOption_Click(sender, e);
				}
				if(MailParam.Imap4 != "") 
				{
					GetMailList();
				}
			}
		}

		private void menuCreate_Click(object sender, System.EventArgs e)
		{
			// [̍쐬
			FormWrite form = new FormWrite();

			form.HostName = MailParam.Smtp;
			form.From = MailParam.Address;
			form.SSL = MailParam.SmtpSsl;
			form.PortNo = MailParam.SmtpPort;
			form.Auth = MailParam.SmtpAuth;
			form.Id = Id;
			form.Password = Password;
			if(form.ShowDialog() == DialogResult.OK)
			{
				// Mσ[{bNXΑMς݂̃[Abv[h
				AppendSent(form.Subject, MailParam.Address, form.To, form.Body, form.FileName);
			}
		}

		// I
		private void menuExit_Click(object sender, System.EventArgs e)
		{
			Close();
		}

		// [ꗗXV
		private void menuRedisp_Click(object sender, System.EventArgs e)
		{
			GetMailList();
		}

		// [T[o̐ݒ
		private void menuOption_Click(object sender, System.EventArgs e)
		{
			FormOption form = new FormOption();

			form.Imap4 = MailParam.Imap4;
			form.Imap4Port = MailParam.Imap4Port;
			form.Imap4Ssl = MailParam.Imap4Ssl;
			form.Imap4Auth = MailParam.Imap4Auth;
			form.Smtp = MailParam.Smtp;
			form.SmtpPort = MailParam.SmtpPort;
			form.SmtpSsl = MailParam.SmtpSsl;
			form.SmtpAuth = MailParam.SmtpAuth;
			form.Address = MailParam.Address;
			if(form.ShowDialog() == DialogResult.OK) 
			{
				MailParam.Imap4 = form.Imap4;
				MailParam.Imap4Port = form.Imap4Port;
				MailParam.Imap4Ssl = form.Imap4Ssl;
				MailParam.Imap4Auth = form.Imap4Auth;
				MailParam.Smtp = form.Smtp;
				MailParam.SmtpPort = form.SmtpPort;
				MailParam.SmtpSsl = form.SmtpSsl;
				MailParam.SmtpAuth = form.SmtpAuth;
				MailParam.Address = form.Address;

				System.Xml.Serialization.XmlSerializer serializer = new System.Xml.Serialization.XmlSerializer(typeof(MailParameter));
				FileStream fs = new FileStream(XmlFileName, FileMode.Create);
				serializer.Serialize(fs, MailParam);
				fs.Close();
			}
		}

		// [{bNX̑IύX
		private void treeMailBox_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			if(treeMailBox.SelectedNode.Tag != null)
			{
				TreeNodeData data = (TreeNodeData)treeMailBox.SelectedNode.Tag;
				if((data.Flag & nMail.Imap4.MailBoxNoSelect) == 0)
				{
					MailBox = data.Path;
					GetMailList();
				}
			}
		}

		// [ꗗł̃ReLXgj[\Ȍ
		private void contextMail_Popup(object sender, System.EventArgs e)
		{
			// Iꂽ[Ȃ΍폜͕s
			if(listMail.SelectedItems.Count == 0)
			{
				menuDeleteMail.Enabled = false;
				menuReply.Enabled = false;
				menuProperty.Enabled = false;
			}
			else
			{
				menuDeleteMail.Enabled = true;
				menuReply.Enabled = true;
				menuProperty.Enabled = true;
			}
		}

		// Mσ[{bNXΑMς݂̃[Abv[h
		private void AppendSent(string subject, string from, string to, string body, string filename)
		{
			// Mσ[{bNX邩H
			if(SentMailBox != "")
			{
				if(Authenticate())
				{
					try 
					{
						string header;
						header = "Subject: " + subject + "\r\n";
						header += "From: " + from + "\r\n";
						header += "To: " + to + "\r\n";
						imap.AppendMail(SentMailBox, header, body, nMail.Imap4.MessageSeen, filename);
					}
					catch(nMail.nMailException nex)
					{
						MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
					}
					catch(Exception ex)
					{
						Debug.WriteLine(ex.Message);
					}
				}
			}
		}

		// ԐM
		private void menuReply_Click(object sender, System.EventArgs e)
		{
			if(listMail.SelectedItems.Count > 0) 
			{
				FormWrite form = new FormWrite();

				form.HostName = MailParam.Smtp;
				form.From = MailParam.Address;
				form.Subject = "Re:" + listMail.SelectedItems[0].SubItems[1].Text;
				form.To = listMail.SelectedItems[0].SubItems[2].Text;
				form.SSL = MailParam.SmtpSsl;
				form.PortNo = MailParam.SmtpPort;
				form.Auth = MailParam.SmtpAuth;
				form.Id = Id;
				form.Password = Password;
				if(form.ShowDialog() == DialogResult.OK)
				{
					// Mσ[{bNXΑMς݂̃[Abv[h
					AppendSent(form.Subject, MailParam.Address, form.To, form.Body, form.FileName);
				}
			}
		}

		// [̍폜
		private void menuDeleteMail_Click(object sender, System.EventArgs e)
		{
			if(Authenticate())
			{
				try 
				{
					ListViewItem item = listMail.SelectedItems[0];
					uint uid = (uint)item.Tag;
					if(TrashMailBox != "" && MailBox != TrashMailBox)
					{
						imap.Copy(uid, TrashMailBox);
					}
					imap.Delete(uid);
					listMail.Items.Remove(listMail.SelectedItems[0]);
					DeleteFlag = true;
				}
				catch(nMail.nMailException nex)
				{
					MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
				}
				catch(Exception ex)
				{
					Debug.WriteLine(ex.Message);
				}
			}
		}

		// [vpeB\
		private void menuProperty_Click(object sender, System.EventArgs e)
		{
			if(Authenticate()) 
			{
				try 
				{
					// UID 擾
					uint uid = (uint)listMail.SelectedItems[0].Tag;
					imap.GetStatus(uid);
					// MIME \擾
					imap.GetMimeStructure(uid);
					FormProperty form = new FormProperty();
					form.Header = imap.Header;
					nMail.Imap4.MimeStructureStatus [] mime_list = imap.GetMimeStructureStatusList();
					// MIME \̒ǉ
					foreach(nMail.Imap4.MimeStructureStatus mime in mime_list)
					{
						string text;
						text = mime.Type + "/" + mime.SubType + "; ";
						for(int no = 0 ; no < mime.Parameter.Length ; no++)
						{
							text += mime.Parameter[no].Name + "=" + mime.Parameter[no].Value;
							if(no < mime.Parameter.Length - 1)
							{
								text += "; ";
							}
						}
						form.AddTreeItem(mime.Part, text);
					}
					form.ShowDialog();
				}
				catch(nMail.nMailException nex)
				{
					MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
				}
				catch(Exception ex)
				{
					Debug.WriteLine(ex.Message);
				}
			}
		}

		// Ytt@CJ
		private void menuOpenAttach_Click(object sender, System.EventArgs e)
		{
			if(Authenticate()) 
			{
				try 
				{
					uint uid = (uint)listMail.SelectedItems[0].Tag;
					int part_no = (int)listAttach.SelectedItems[0].Tag;
					string path = Path.GetTempPath() + listAttach.SelectedItems[0].Text;
					// Ytt@Ce|tH_ɕۑ
					imap.SaveMimePart(uid, part_no, path);
					// ۑt@CJ
					Process.Start(path);
				}
				catch(nMail.nMailException nex)
				{
					MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
				}
				catch(Exception ex)
				{
					Debug.WriteLine(ex.Message);
				}
			}
		
		}

		// Ytt@Cۑ
		private void menuSaveAttach_Click(object sender, System.EventArgs e)
		{
			if(Authenticate()) 
			{
				try 
				{
					uint uid = (uint)listMail.SelectedItems[0].Tag;
					int part_no = (int)listAttach.SelectedItems[0].Tag;
					saveFileDialog.FileName = listAttach.SelectedItems[0].Text;
					// t@Cۑ_CAO\
					if(saveFileDialog.ShowDialog() == DialogResult.OK)
					{
						// Ytt@Cۑ
						imap.SaveMimePart(uid, part_no, saveFileDialog.FileName);
					}
				}
				catch(nMail.nMailException nex)
				{
					MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
				}
				catch(Exception ex)
				{
					Debug.WriteLine(ex.Message);
				}
			}
		
		}

		// [{bNX쐬
		private void menuCreateMailBox_Click(object sender, System.EventArgs e)
		{
			if(treeMailBox.SelectedNode != null)
			{
				TreeNodeData data = (TreeNodeData)treeMailBox.SelectedNode.Tag;
				// q[{bNX쐬ł邩H
				if((data.Flag & nMail.Imap4.MailBoxNoInferious) == 0)
				{
					FormName form = new FormName();

					// [{bNX̓_CAO\
					if(form.ShowDialog() == DialogResult.OK) 
					{
						if(Authenticate())
						{
							try 
							{
								string path = "";
								if(data.Path != "") {
								 	path = data.Path + data.Separate;
								}
								path += form.MailBox;
								// [{bNX쐬
								imap.CreateMailBox(path);
								// w
								imap.SubscribeMailBox(path);
								int index;
								string text;

								index = (int)IconImage.Folder;
								text = form.MailBox;
								// sent ̏ꍇMσ[{bNXƂĈ
								if(string.Compare(path, "sent", true) == 0)
								{
									SentMailBox = path;
									text = "M";
									index = (int)IconImage.Sent;
								}
								// trash ̏ꍇS~ƂĈ
								else if(string.Compare(text, "trash", true) == 0)
								{
									TrashMailBox = path;
									text = "S~";
									index = (int)IconImage.Trash;
								}
								TreeNode add_node = treeMailBox.SelectedNode.Nodes.Add(text);
								add_node.ImageIndex = index;
								add_node.SelectedImageIndex = index;
								add_node.Tag = new TreeNodeData(path, data.Separate, 0);
								treeMailBox.SelectedNode.Expand();
							}
							catch(nMail.nMailException nex)
							{
								MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
							}
							catch(Exception ex)
							{
								Debug.WriteLine(ex.Message);
							}
						}
					}
				}
			}
		}

		// [{bNX̖OύX
		private void menuRenameMailBox_Click(object sender, System.EventArgs e)
		{
			if(treeMailBox.SelectedNode != null) 
			{
				treeMailBox.SelectedNode.BeginEdit();
			}
		}

		// q[{bNX̍폜
		private void DeleteChildMailBox(TreeNode node)
		{
			foreach(TreeNode tn in node.Nodes)
			{
				DeleteChildMailBox(tn);
				if(tn.Tag != null) 
				{
					TreeNodeData data = (TreeNodeData)tn.Tag;
					// [{bNX폜
					imap.DeleteMailBox(data.Path);
					// wǉ
					imap.UnsubscribeMailBox(data.Path);
				}
			}
		}

		// [{bNX̍폜
		private void menuDeleteMailBox_Click(object sender, System.EventArgs e)
		{
			if(Authenticate())
			{
				try 
				{
					// MAMρAS~͍폜łȂ
					if(treeMailBox.SelectedNode.ImageIndex >= (int)IconImage.Folder)
					{
						// q[{bNXSč폜
						DeleteChildMailBox(treeMailBox.SelectedNode);
						if(treeMailBox.SelectedNode.Tag != null)
						{
							// [{bNX폜
							TreeNodeData data = (TreeNodeData)treeMailBox.SelectedNode.Tag;
							imap.DeleteMailBox(data.Path);
							// wǉ
							imap.UnsubscribeMailBox(data.Path);
							treeMailBox.SelectedNode.Remove();
						}
					}
				}
				catch(nMail.nMailException nex)
				{
					MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
				}
				catch(Exception ex)
				{
					Debug.WriteLine(ex.Message);
				}
			}
		}

		// [{bNXc[r[̃ReLXgj[\Ȍ
		private void contextTree_Popup(object sender, System.EventArgs e)
		{
			bool flag = false;
			TreeNode node = treeMailBox.SelectedNode;
			if(node != null)
			{
				if(node.ImageIndex >= (int)IconImage.Folder) 
				{
					flag = true;
				}
				TreeNodeData data = (TreeNodeData)treeMailBox.SelectedNode.Tag;
				// q[{bNX쐬ł邩H
				if((data.Flag & nMail.Imap4.MailBoxNoInferious) == 0)
				{
					menuCreateMailBox.Enabled = true;
				}
			} 
			else
			{
				menuCreateMailBox.Enabled = false;
			}
			menuDeleteMailBox.Enabled = flag;
			menuRenameMailBox.Enabled = flag;
		}

		// [{bNXOύXJnȌ
		private void treeMailBox_BeforeLabelEdit(object sender, System.Windows.Forms.NodeLabelEditEventArgs e)
		{
			// [AhXƎMAMρAS~͕ύXs
			if(e.Node.ImageIndex != (int)IconImage.User && e.Node.ImageIndex < (int)IconImage.Folder) 
			{
				e.CancelEdit = true;
			}
		}

		private void treeMailBox_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			// F2 L[Ń[{bNXOύXJn
			if(e.KeyCode == Keys.F2 && treeMailBox.SelectedNode != null) 
			{
				treeMailBox.SelectedNode.BeginEdit();
			}
		}

		// q[{bNX̖OύX
		private void ChangeChildString(TreeNode node, string old_mailbox, string new_mailbox)
		{
			foreach(TreeNode tn in node.Nodes)
			{
				if(tn.Tag != null) 
				{
					TreeNodeData data = (TreeNodeData)tn.Tag;
					if(data.Path.StartsWith(old_mailbox))
					{
						string path = new_mailbox + data.Path.Substring(old_mailbox.Length);
						tn.Tag = new TreeNodeData(path, data.Separate, data.Flag);
					}
				}
				ChangeChildString(tn, old_mailbox, new_mailbox);
			}
		}
		private void treeMailBox_AfterLabelEdit(object sender, System.Windows.Forms.NodeLabelEditEventArgs e)
		{
			if(e.Label != null && e.Label != e.Node.Text)
			{
				string new_mailbox, old_mailbox;
				TreeNodeData data = (TreeNodeData)e.Node.Tag;
				// [{bNX擾
				old_mailbox = data.Path;
				// V[{bNX쐬
				string [] folder = data.Path.Split(data.Separate);
				new_mailbox = "";
				if(folder.Length > 1)
				{
					new_mailbox = string.Join(data.Separate.ToString(), folder, 0, folder.Length - 1);
					new_mailbox += data.Separate.ToString();
				}
				new_mailbox += e.Label;
				if(Authenticate()) 
				{
					try 
					{
						// [{bNXύX
						imap.RenameMailBox(old_mailbox, new_mailbox);
						// [{bNXXV
						e.Node.Tag = new TreeNodeData(new_mailbox, data.Separate, data.Flag);
						// q[{bNX̍XV
						ChangeChildString(e.Node, old_mailbox, new_mailbox);
						return;
					}
					catch(nMail.nMailException nex)
					{
						MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
					}
					catch(Exception ex)
					{
						Debug.WriteLine(ex.Message);
					}
					e.CancelEdit = true;
				}
			}
			else
			{
				e.CancelEdit = true;
			}
		}

		// Ytt@C_uNbNŊJ
		private void listAttach_DoubleClick(object sender, System.EventArgs e)
		{
			menuOpenAttach_Click(sender, e);
		}

		// [ꗗ̃hbOhbvJn
		private void listMail_ItemDrag(object sender, System.Windows.Forms.ItemDragEventArgs e)
		{
			if(e.Item != null)
			{
				if(listMail.DoDragDrop((ListViewItem)e.Item, DragDropEffects.Move) == DragDropEffects.Move)
				{
					if(Authenticate())
					{
						try 
						{
							// hbO[폜
							ListViewItem item = (ListViewItem)e.Item;
							uint uid = (uint)item.Tag;
							imap.Delete(uid);
							listMail.Items.Remove(item);
							DeleteFlag = true;
						}
						catch(nMail.nMailException nex)
						{
							MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
						}
						catch(Exception ex)
						{
							Debug.WriteLine(ex.Message);
						}
					}
				}
			}
		}

		// [{bNXc[r[փhbOڂ
		private void treeMailBox_DragEnter(object sender, System.Windows.Forms.DragEventArgs e)
		{
			e.Effect = DragDropEffects.None;	
			if(e.Data.GetDataPresent(typeof(ListViewItem)))
			{
				Point point = treeMailBox.PointToClient(new Point(e.X, e.Y));
				TreeNode node = treeMailBox.GetNodeAt(point);
				if(node != null)
				{
					TreeNodeData data = (TreeNodeData)node.Tag;
					if(node.ImageIndex != (int)IconImage.User && (data.Flag & nMail.Imap4.MailBoxNoSelect) == 0)
					{
						e.Effect = DragDropEffects.Move;
					}
				}
			}
		}

		// [{bNXc[r[ŃhbOڂړ
		private void treeMailBox_DragOver(object sender, System.Windows.Forms.DragEventArgs e)
		{
			e.Effect = DragDropEffects.None;	
			if(e.Data.GetDataPresent(typeof(ListViewItem)))
			{
				Point point = treeMailBox.PointToClient(new Point(e.X, e.Y));
				TreeNode node = treeMailBox.GetNodeAt(point);
				if(node != null)
				{
					TreeNodeData data = (TreeNodeData)node.Tag;
					if(node.ImageIndex != (int)IconImage.User && (data.Flag & nMail.Imap4.MailBoxNoSelect) == 0)
					{
						e.Effect = DragDropEffects.Move;
					}
				}
			}
		}

		// [{bNXc[r[Ńhbvꂽ
		private void treeMailBox_DragDrop(object sender, System.Windows.Forms.DragEventArgs e)
		{
			if(e.Data.GetDataPresent(typeof(ListViewItem)))
			{
				e.Effect = DragDropEffects.None;
				Point point = treeMailBox.PointToClient(new Point(e.X, e.Y));
				TreeNode node = treeMailBox.GetNodeAt(point);
				if(node != null)
				{
					TreeNodeData data = (TreeNodeData)node.Tag;
					if(node.ImageIndex != (int)IconImage.User && (data.Flag & nMail.Imap4.MailBoxNoSelect) == 0)
					{
						ListViewItem item = (ListViewItem)e.Data.GetData(typeof(ListViewItem));
						if(Authenticate())
						{
							try 
							{
								// hbvꂽ[hbv[{bNXɃRs[
								uint uid = (uint)item.Tag;
								imap.Copy(uid, data.Path);
								e.Effect = DragDropEffects.Move;
							}
							catch(nMail.nMailException nex)
							{
								MessageBox.Show(string.Format("G[܂B\r\n{0}", nex.Message));
							}
							catch(Exception ex)
							{
								Debug.WriteLine(ex.Message);
							}
						}
					}
				}
			}
		}

		private void treeMailBox_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			// ENbN̍ۂɃ[{bNX̑IύX
			if(e.Button == MouseButtons.Right)
			{
				Point point = treeMailBox.PointToClient(Cursor.Position);
				treeMailBox.SelectedNode = treeMailBox.GetNodeAt(point);
			}
		}

		private void treeMailBox_BeforeSelect(object sender, System.Windows.Forms.TreeViewCancelEventArgs e)
		{
			if(e.Node != null)
			{
				TreeNodeData data = (TreeNodeData)e.Node.Tag;
				if(data != null && (data.Flag & nMail.Imap4.MailBoxNoSelect) != 0)
				{
					e.Cancel = true;
				}
			}
		}

		private void timer_Tick(object sender, System.EventArgs e)
		{
			if(TimerCount > 0) 
			{
				TimerCount--;
				if(TimerCount == 0 && imap.IsConnected()) 
				{
					// 莞ԒʐM̏ꍇ No Operation R}h𔭍s
					try
					{
						imap.NoOperation();
						TimerCount = ContinueTimerCount;
					}
					catch(nMail.nMailException nex)
					{
						Debug.WriteLine(nex.Message);
						imap.Close();
					}
					catch(Exception ex)
					{
						Debug.WriteLine(ex.Message);
					}
				}
			}
		}
	}
}
