// Option.cpp : t@C
//

#include "stdafx.h"
#include "Vcnetimap4.h"
#include "Option.h"
#include ".\option.h"

#include "nMail.h"


// COption _CAO

IMPLEMENT_DYNAMIC(COption, CDialog)
COption::COption(CWnd* pParent /*=NULL*/)
	: CDialog(COption::IDD, pParent)
	, m_smtp(_T(""))
	, m_imap4(_T(""))
	, m_mail(_T(""))
	, m_auth(0)
	, m_smtp_port(0)
	, m_smtp_ssl(0)
	, m_smtp_auth(0)
	, m_imap4_port(0)
	, m_imap4_ssl(0)
	, m_imap4_auth(0)
{
}

COption::~COption()
{
}

void COption::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_SMTP, m_edit_smtp);
	DDX_Text(pDX, IDC_EDIT_SMTP, m_smtp);
	DDX_Text(pDX, IDC_EDIT_IMAP4, m_imap4);
	DDX_Text(pDX, IDC_EDIT_MAIL, m_mail);
	DDX_Text(pDX, IDC_EDIT_SMTP_PORT, m_smtp_port);
	DDV_MinMaxInt(pDX, m_smtp_port, 0, 65535);
	DDX_CBIndex(pDX, IDC_COMBO_SMTP_SSL, m_smtp_ssl);
	DDX_CBIndex(pDX, IDC_COMBO_SMTP_AUTH, m_smtp_auth);
	DDX_Text(pDX, IDC_EDIT_IMAP4_PORT, m_imap4_port);
	DDV_MinMaxInt(pDX, m_imap4_port, 0, 65535);
	DDX_CBIndex(pDX, IDC_COMBO_IMAP4_SSL, m_imap4_ssl);
	DDX_CBIndex(pDX, IDC_COMBO_IMAP4_AUTH, m_imap4_auth);
}


BEGIN_MESSAGE_MAP(COption, CDialog)
	ON_CBN_SELCHANGE(IDC_COMBO_SMTP_SSL, OnCbnSelchangeComboSmtpSsl)
	ON_CBN_SELCHANGE(IDC_COMBO_IMAP4_SSL, OnCbnSelchangeComboImap4Ssl)
END_MESSAGE_MAP()


// COption bZ[W nh

BOOL COption::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_edit_smtp.SetFocus();

	return FALSE;
}

void COption::SetSsl(int smtp, int imap4)
{
	m_smtp_ssl = 0;
	if(smtp == NMAIL_SSL_SSL3) {
		m_smtp_ssl = 1;
	} else if(smtp == NMAIL_SSL_TLS1) {
		m_smtp_ssl = 2;
	} else if(smtp == NMAIL_SSL_STARTTLS) {
		m_smtp_ssl = 3;
	}
	m_imap4_ssl = 0;
	if(imap4 == NMAIL_SSL_SSL3) {
		m_imap4_ssl = 1;
	} else if(imap4 == NMAIL_SSL_TLS1) {
		m_imap4_ssl = 2;
	} else if(imap4 == NMAIL_SSL_STARTTLS) {
		m_imap4_ssl = 3;
	}
}

void COption::GetSsl(int &smtp, int &imap4)
{
	smtp = 0;
	if(m_smtp_ssl == 1) {
		smtp = NMAIL_SSL_SSL3;
	} else if(m_smtp_ssl == 2) {
		smtp = NMAIL_SSL_TLS1;
	} else if(m_smtp_ssl == 3) {
		smtp = NMAIL_SSL_STARTTLS;
	}
	imap4 = 0;
	if(m_imap4_ssl == 1) {
		imap4 = NMAIL_SSL_SSL3;
	} else if(m_imap4_ssl == 2) {
		imap4 = NMAIL_SSL_TLS1;
	} else if(m_imap4_ssl == 3) {
		imap4 = NMAIL_SSL_STARTTLS;
	}
}

void COption::SetAuth(int smtp, int imap4)
{
	m_smtp_auth = smtp;
	if(m_smtp_auth == NMAIL_SMTP_AUTH_CRAM_MD5) {
		m_smtp_auth = 3;
	}
	m_imap4_auth = imap4 - 1;
	if(m_imap4_auth == 3) {
		m_imap4_auth = 2;
	}
}

void COption::GetAuth(int &smtp, int &imap4)
{
	smtp = m_smtp_auth;
	if(smtp == 3) {
		smtp = NMAIL_SMTP_AUTH_CRAM_MD5;
	}
	imap4 = m_imap4_auth + 1;
	if(imap4 == 3) {
		imap4 = NMAIL_IMAP4_AUTH_CRAM_MD5;
	}
}



void COption::OnCbnSelchangeComboSmtpSsl()
{
	CComboBox *combo = (CComboBox *)GetDlgItem(IDC_COMBO_SMTP_SSL);
	if(combo != NULL) {
		UpdateData(TRUE);
		int sel = combo->GetCurSel();
		if(sel == 0 || sel == 3) {
			m_smtp_port = NMAIL_SMTP_PORT;
		} else {
			m_smtp_port = NMAIL_SMTP_SSL_PORT;
		}
		UpdateData(FALSE);
	}
}

void COption::OnCbnSelchangeComboImap4Ssl()
{
	CComboBox *combo = (CComboBox *)GetDlgItem(IDC_COMBO_IMAP4_SSL);
	if(combo != NULL) {
		UpdateData(TRUE);
		int sel = combo->GetCurSel();
		if(sel == 0 || sel == 3) {
			m_imap4_port = NMAIL_IMAP4_PORT;
		} else {
			m_imap4_port = NMAIL_IMAP4_SSL_PORT;
		}
		UpdateData(FALSE);
	}
}
