// Option.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "vcmail6.h"
#include "Option.h"
#include "nMail.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COption _CAO


COption::COption(CWnd* pParent /*=NULL*/)
	: CDialog(COption::IDD, pParent)
{
	//{{AFX_DATA_INIT(COption)
	m_apop = FALSE;
	m_mail = _T("");
	m_pop3 = _T("");
	m_smtp = _T("");
	m_pop3_ssl = 0;
	m_smtp_ssl = 0;
	m_smtp_auth = 0;
	m_pop3_port = 0;
	m_smtp_port = 0;
	//}}AFX_DATA_INIT
}


void COption::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COption)
	DDX_Control(pDX, IDC_EDIT_SMTP, m_esmtp);
	DDX_Check(pDX, IDC_CHECK_APOP, m_apop);
	DDX_Text(pDX, IDC_EDIT_MAIL, m_mail);
	DDX_Text(pDX, IDC_EDIT_POP3, m_pop3);
	DDX_Text(pDX, IDC_EDIT_SMTP, m_smtp);
	DDX_CBIndex(pDX, IDC_COMBO_POP3_SSL, m_pop3_ssl);
	DDX_CBIndex(pDX, IDC_COMBO_SMTP_SSL, m_smtp_ssl);
	DDX_CBIndex(pDX, IDC_COMBO_SMTP_AUTH, m_smtp_auth);
	DDX_Text(pDX, IDC_EDIT_POP3_PORT, m_pop3_port);
	DDV_MinMaxInt(pDX, m_pop3_port, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_SMTP_PORT, m_smtp_port);
	DDV_MinMaxInt(pDX, m_smtp_port, 0, 65535);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COption, CDialog)
	//{{AFX_MSG_MAP(COption)
	ON_CBN_SELCHANGE(IDC_COMBO_SMTP_SSL, OnSelchangeComboSmtpSsl)
	ON_CBN_SELCHANGE(IDC_COMBO_POP3_SSL, OnSelchangeComboPop3Ssl)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COption bZ[W nh

BOOL COption::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_esmtp.SetFocus();
	
	return FALSE;
}

void COption::OnSelchangeComboSmtpSsl() 
{
	CComboBox *combo = (CComboBox *)GetDlgItem(IDC_COMBO_SMTP_SSL);
	if(combo != NULL) {
		UpdateData(TRUE);
		int sel = combo->GetCurSel();
		if(sel == 0 || sel == 3) {
			m_smtp_port = NMAIL_SMTP_PORT;
		} else {
			m_smtp_port = NMAIL_SMTP_SSL_PORT;
		}
		UpdateData(FALSE);
	}
}

void COption::OnSelchangeComboPop3Ssl() 
{
	CComboBox *combo = (CComboBox *)GetDlgItem(IDC_COMBO_POP3_SSL);
	if(combo != NULL) {
		UpdateData(TRUE);
		int sel = combo->GetCurSel();
		if(sel == 0 || sel == 3) {
			m_pop3_port = NMAIL_POP3_PORT;
		} else {
			m_pop3_port = NMAIL_POP3_SSL_PORT;
		}
		UpdateData(FALSE);
	}
}

void COption::SetSsl(int smtp, int pop3)
{
	m_smtp_ssl = 0;
	if(smtp == NMAIL_SSL_SSL3) {
		m_smtp_ssl = 1;
	} else if(smtp == NMAIL_SSL_TLS1) {
		m_smtp_ssl = 2;
	} else if(smtp == NMAIL_SSL_STARTTLS) {
		m_smtp_ssl = 3;
	}
	m_pop3_ssl = 0;
	if(pop3 == NMAIL_SSL_SSL3) {
		m_pop3_ssl = 1;
	} else if(pop3 == NMAIL_SSL_TLS1) {
		m_pop3_ssl = 2;
	} else if(pop3 == NMAIL_SSL_STARTTLS) {
		m_pop3_ssl = 3;
	}
}

void COption::GetSsl(int &smtp, int &pop3)
{
	smtp = 0;
	if(m_smtp_ssl == 1) {
		smtp = NMAIL_SSL_SSL3;
	} else if(m_smtp_ssl == 2) {
		smtp = NMAIL_SSL_TLS1;
	} else if(m_smtp_ssl == 3) {
		smtp = NMAIL_SSL_STARTTLS;
	}
	pop3 = 0;
	if(m_pop3_ssl == 1) {
		pop3 = NMAIL_SSL_SSL3;
	} else if(m_pop3_ssl == 2) {
		pop3 = NMAIL_SSL_TLS1;
	} else if(m_pop3_ssl == 3) {
		pop3 = NMAIL_SSL_STARTTLS;
	}
}

void COption::SetAuth(int smtp)
{
	m_smtp_auth = smtp;
	if(m_smtp_auth == NMAIL_SMTP_AUTH_CRAM_MD5) {
		m_smtp_auth = 3;
	}
}

void COption::GetAuth(int &smtp)
{
	smtp = m_smtp_auth;
	if(smtp == 3) {
		smtp = NMAIL_SMTP_AUTH_CRAM_MD5;
	}
}

