// --------------------------------------------------------------------------
// ListEx.cpp : Cve[V t@C
// --------------------------------------------------------------------------

#include "stdafx.h"
#include "vc6imap4.h"
#include "ListEx.h"
#include "TreeEx.h"
#include "StrSplit.h"

#include "nMail.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define OFFSET_FIRST	2
#define OFFSET_OTHER	6

/////////////////////////////////////////////////////////////////////////////
// CListEx

CListEx::CListEx()
{
}

CListEx::~CListEx()
{
}


BEGIN_MESSAGE_MAP(CListEx, CListCtrl)
	//{{AFX_MSG_MAP(CListEx)
	ON_NOTIFY_REFLECT(LVN_BEGINDRAG, OnBegindrag)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CListEx bZ[W nh

//
//	XgACe`揈
//
void CListEx::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);
	LPDRAWITEMSTRUCT dis = lpDrawItemStruct;
	TCHAR item_name[MAX_PATH];
	COLORREF text_save, bk_save;
	LVITEM lvi;
	LV_COLUMN lvc;
	ListItemData *item;
	CRect rc_item, rc_all;
	CFont *oldfont, font;
	LOGFONT lf;
	int flag = 0;
	int save_flag = FALSE;

	lvi.mask = LVIF_TEXT | LVIF_STATE;
	lvi.iItem = dis->itemID;
	lvi.iSubItem = 0;
	lvi.pszText = item_name;
	lvi.cchTextMax = sizeof(item_name) - 1;
	lvi.stateMask = 0xFFFF;
	GetItem(&lvi);
	item_name[MAX_PATH - 1] = _T('\0');
	
	GetFont()->GetLogFont(&lf);
	item = reinterpret_cast<ListItemData *>(GetItemData(dis->itemID));
	if(item != NULL) {
		// bZ[WtO̎擾
		if((item->flag & NMAIL_IMAP4_MESSAGE_SEEN) == 0) {
			lf.lfWeight = FW_BOLD;
		}
	}
	font.CreateFontIndirect(&lf);
	oldfont = pDC->SelectObject(&font);

	GetItemRect(dis->itemID, &rc_all, LVIR_BOUNDS);
	// ACeIԂH
	if(lvi.state & LVIS_SELECTED) {
		text_save = pDC->SetTextColor(GetSysColor(COLOR_HIGHLIGHTTEXT));
		bk_save = pDC->SetBkColor(GetSysColor(COLOR_HIGHLIGHT));
		CBrush hi(GetSysColor(COLOR_HIGHLIGHT));
		pDC->FillRect(&rc_all, &hi);
		save_flag = TRUE;
	} else {
		CBrush cw(GetSysColor(COLOR_WINDOW));
		pDC->FillRect(&rc_all, &cw);
	}

	GetItemRect(dis->itemID, &rc_item, LVIR_LABEL);
	::DrawTextEx(lpDrawItemStruct->hDC, item_name, -1, &rc_item, DT_WORD_ELLIPSIS | DT_LEFT | DT_SINGLELINE | DT_NOPREFIX | DT_NOCLIP | DT_VCENTER, NULL);

	lvc.mask = LVCF_FMT | LVCF_WIDTH;
	for(int no = 1;  GetColumn(no, &lvc) ; no++) {
		rc_item.left = rc_item.right;
		rc_item.right += lvc.cx;
		GetItemText(dis->itemID, no, item_name, sizeof(item_name));
		::DrawTextEx(lpDrawItemStruct->hDC, item_name, -1, &rc_item, DT_WORD_ELLIPSIS | DT_LEFT | DT_SINGLELINE | DT_NOPREFIX | DT_NOCLIP | DT_VCENTER, NULL);
	}
	if(save_flag) {
   	    pDC->SetTextColor(text_save);
		pDC->SetBkColor(bk_save);
	}
	pDC->SelectObject(oldfont);
}

//
//	hbOJn
//
void CListEx::OnBegindrag(NMHDR *pNMHDR, LRESULT *pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	HANDLE hGlobal;
	DROPEFFECT result;
	TCHAR *buff;

	hGlobal = GlobalAlloc(GMEM_DDESHARE, (DragDropText.GetLength() + 1) * sizeof(TCHAR));
	if(hGlobal) {
		buff = (TCHAR *)GlobalLock(hGlobal);
		_tcscpy(buff, DragDropText);
		GlobalUnlock(hGlobal);

		CTreeDropTarget::m_swnd = this;
		COleDataSource DataSource;
		DataSource.CacheGlobalData(CF_TEXT, hGlobal);
TRACE(_T("drag\n"));
		result = DataSource.DoDragDrop(DROPEFFECT_MOVE);
TRACE(_T("drop %d\n"), result);
		CTreeDropTarget::m_swnd = NULL;
	}
	*pResult = 0;
}

//
//	f[^j
//
void CListEx::ReleaseAllItemData()
{
	ListItemData *item;

	for(int no = 0 ; no < GetItemCount() ; no++) {
		item = reinterpret_cast<ListItemData *>(GetItemData(no));
		if(item != NULL) {
			delete item;
		}
	}
}

void CListEx::SetListItemData(int no, DWORD uid, int flag, CString header)
{
	ListItemData *item = new ListItemData;
	if(item != NULL) {
		item->uid = uid;
		item->flag = flag;
		item->header = header;
		SetItemData(no, reinterpret_cast<DWORD>(item));
	}
}

DWORD CListEx::GetUid(int no)
{
	ListItemData *item = reinterpret_cast<ListItemData *>(GetItemData(no));
	if(item != NULL) {
		return item->uid;
	}
	return 0;
}

CString CListEx::GetHeader(int no)
{
	ListItemData *item = reinterpret_cast<ListItemData *>(GetItemData(no));
	if(item != NULL) {
		return item->header;
	}
	return _T("");
}

