//
//  service .exe
//
//	 2001/11/6  by takapyu
//
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>

#include "resource.h"

#ifndef ICON_SMALL
#define ICON_SMALL	0
#endif
#ifndef ICON_BIG
#define ICON_BIG	1
#endif

#define END_CLOSE				0
#define END_SYSCOMMAND			1
#define END_SYS_AND_CLOSE		2		// 2002/6/18
#define END_CTRL_BREAK			3		// 2004/8/9

// wb_Ƃ
char *HEADER = "sexe";
char *MUTEX_STRING = "$$sexe$$%s$$";
char *WINDOW_TITLE = "sexe";

// .ini ̃L[
char *KEY_EXE = "exe";
char *KEY_OPTION = "option";
char *KEY_NAME = "name";
char *KEY_DESCRIPTION = "description";
char *KEY_END = "end";
// 2004/8/9
char *KEY_AUTO = "auto";
char *KEY_DESKTOP = "desktop";
// 2009/3/26
char *KEY_RETRY = "retry";

// ʓ|Ȃ̂ŃO[oϐg܂Ă܂B
SERVICE_STATUS_HANDLE service_handle;
BOOL service_flag;					// running serivce
BOOL service_install_flag;			// install service
BOOL service_stop_flag;				// stop service
BOOL nt_flag;						// runnning Windows NT ?

char module_name[MAX_PATH];			// sexe.exe ̃tpX
char execute_path[MAX_PATH];		// sexe.exe ̃tH_
char ini_name[MAX_PATH];			// sexe.ini ̃tpX
char exe_name[MAX_PATH];			// T[rXƂē삳vÕtpX
char option_name[MAX_PATH];			// NIvV
char service_name[MAX_PATH];		// T[rX
char description_name[MAX_PATH];	// 2009/3/26 T[rX
int end_pattern;					// I@
int auto_flag;						// 2004/8/9 N
int desktop_flag;					// 2004/8/9 fXNgbvƂ̑Θb
int retry_flag;						// 2009/3/26 ċN
int shutdown_flag;					// 2009/3/26 Shutdown
HANDLE mutex;						// dNh~p Mutex
DWORD process_id;					// NvÕvZX ID
HINSTANCE h_instance;				// hInstance

// ֐`
BOOL APIENTRY MainFunc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
BOOL send_status_to_scm(int state, int exit_code, int progress);
void service_control_handler(int control);
void service_main(void);
int check_already(void);
int remove_service(void);
int install_service(void);
int restart_service(void);
BOOL check_execute_service(void);
void start_service(void);
void extract_directory(unsigned char *path);
void get_inifile(void);
void set_inifile(void);

//
//	Windows C֐
//
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszArgs, int nWinMode)
{
    MSG msg;
	HWND hMain;

	// sfBNgɂ sexe.exe ̃tpX쐬
	GetModuleFileName(NULL, module_name, sizeof(module_name));
	lstrcpy(execute_path, module_name);
	extract_directory(execute_path);
	lstrcpy(ini_name, execute_path);
	lstrcat(ini_name, "\\sexe.ini");
	// ݒlǂ
	get_inifile();

	// T[rXœ삵Ă邩H
	service_flag = check_execute_service();
	// WindowsNT/2000 ?
	if(nt_flag) {
		// T[rXƂē쒆H
		if(service_flag) {
			// łɓ쒆H
			if(check_already() == FALSE) {
				// T[rXƂċN
				start_service();
			}
		} else {
			// ݒ_CAO\
			h_instance = hInstance;
			hMain = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_DIALOG_SETUP), 
				GetDesktopWindow(), (DLGPROC)MainFunc);
			ShowWindow(hMain, SW_SHOW);
			// Drag&Drop 󂯓鏀
			DragAcceptFiles(hMain, TRUE);
			while(GetMessage(&msg, NULL, 0, 0)) {
				if(!IsDialogMessage(hMain, &msg)) {
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
			}
		}
	} else {
		MessageBox(GetDesktopWindow(), "Windows NT/2000/XP ŋNĂB", "Error", MB_OK);
	}
	return 0;
}

//
//	EChE񋓂ACreateProcess ŋNvZX ID 
//	Ȃ WM_CLOSE 𑗂ďIB
//
BOOL CALLBACK EnumWindowsProc(HWND hWnd, LPARAM lParam)
{
	DWORD Pid, Tid;

	if(GetWindow(hWnd, GW_OWNER) == 0) {
		Tid = GetWindowThreadProcessId(hWnd, &Pid);
		if(Pid == process_id) {
			// 2002/6/18
			if(lParam == END_SYS_AND_CLOSE) {
				SendMessage(hWnd, WM_SYSCOMMAND, SC_CLOSE, 0);
				SendMessage(hWnd, WM_CLOSE, 0, 0);
			} else if(lParam == END_SYSCOMMAND) {
				SendMessage(hWnd, WM_SYSCOMMAND, SC_CLOSE, 0);
			} else {
				SendMessage(hWnd, WM_CLOSE, 0, 0);
			}
		}
	}
	return TRUE;
}

//
//	łɋNς݂ǂ Mutex Ŕ
//
int check_already(void)
{
	SECURITY_DESCRIPTOR sd;
	SECURITY_ATTRIBUTES sa;
	char mutex_name[MAX_PATH];

	wsprintf(mutex_name, MUTEX_STRING, service_name);
	// rp mutex 쐬
	mutex = OpenMutex(MUTEX_ALL_ACCESS, FALSE, mutex_name);
	if(mutex != NULL) {
		if(service_flag != TRUE) {
			MessageBox(GetDesktopWindow(), "łɋNĂ܂B", HEADER, MB_OK);
		}
		return TRUE;
	}
	sa.lpSecurityDescriptor = NULL;
	if(InitializeSecurityDescriptor(&sd, SECURITY_DESCRIPTOR_REVISION)) {
		if(SetSecurityDescriptorDacl(&sd, TRUE, (PACL)NULL, FALSE)) {
			sa.lpSecurityDescriptor = &sd;
		}
	}
	sa.nLength = sizeof(sa);
	sa.bInheritHandle = TRUE;
	mutex = CreateMutex(&sa, FALSE, mutex_name);
	return FALSE;
}

//
//	T[rXԏXV
//
BOOL send_status_to_scm(int state, int exit_code, int progress)
{
	SERVICE_STATUS ss;

	ss.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
	ss.dwCurrentState = state;
	ss.dwControlsAccepted = SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_SHUTDOWN;
	ss.dwWin32ExitCode = exit_code;
	ss.dwServiceSpecificExitCode = 0;
	ss.dwCheckPoint = progress;
	ss.dwWaitHint = 3000;	// 3sec

	return SetServiceStatus(service_handle, &ss);
}

//
//	T[rXv
//
void service_control_handler(int control)
{
	switch(control) {
		case SERVICE_CONTROL_STOP:
		case SERVICE_CONTROL_SHUTDOWN:
			// 2009/3/26
			shutdown_flag = 1;

			send_status_to_scm(SERVICE_STOP_PENDING, 0, 1);
			if(end_pattern == END_CTRL_BREAK) {
				GenerateConsoleCtrlEvent(CTRL_BREAK_EVENT, process_id);
			} else {
				EnumWindows(EnumWindowsProc, end_pattern);
			}
			send_status_to_scm(SERVICE_STOPPED, 0, 0);
			break;
	}
}

//
//	vON
//
BOOL execute_process(char *exe_name, char *option_name, PROCESS_INFORMATION *pi)
{
	STARTUPINFO si;
	char command[MAX_PATH], path[MAX_PATH];
	DWORD create;

	ZeroMemory(pi, sizeof(PROCESS_INFORMATION));
	GetStartupInfo(&si);
	wsprintf(command, "%s %s", exe_name, option_name);
	lstrcpy(path, exe_name);
	extract_directory(path);
	create = CREATE_DEFAULT_ERROR_MODE;
	if(end_pattern == END_CTRL_BREAK) {
		AllocConsole();
		create |= CREATE_NEW_PROCESS_GROUP;
	}
	return CreateProcess(NULL, command, NULL, NULL, FALSE, create, NULL, path, &si, pi);
}

//
//	T[rXC
//
void service_main(void)
{
	PROCESS_INFORMATION pi;

	service_handle = RegisterServiceCtrlHandler(service_name,
	                               (LPHANDLER_FUNCTION)service_control_handler);
	if(service_handle != 0) {
		send_status_to_scm(SERVICE_START_PENDING, 0, 1);

		send_status_to_scm(SERVICE_RUNNING, 0, 0);
		// vONB
		if(execute_process(exe_name, option_name, &pi)) {
			// 2009/3/26
			shutdown_flag = 0;

			process_id = pi.dwProcessId;
			send_status_to_scm(SERVICE_RUNNING, 0, 0);

			// T[rX̏IŔ
			while(1) {
		    	if(WaitForSingleObject(pi.hProcess, 0) != WAIT_TIMEOUT) {
					// 2001/11/9
					CloseHandle(pi.hThread);
					CloseHandle(pi.hProcess);
					// 2009/3/26
					if(!retry_flag || shutdown_flag) {
						break;
					} else {
						if(execute_process(exe_name, option_name, &pi)) {
							process_id = pi.dwProcessId;
						} else {
							break;
						}
					}
				}
				Sleep(100);
			}
		}
		if(end_pattern == END_CTRL_BREAK) {
			FreeConsole();
		}
		CloseHandle(mutex);
	}
	send_status_to_scm(SERVICE_STOPPED, 0, 0);
}

//
//	T[rXJn
//
void start_service(void)
{
	SERVICE_TABLE_ENTRY serviceTable[] = {
		{
			service_name, (LPSERVICE_MAIN_FUNCTION)service_main
		}, {
			NULL, NULL
		}
	};
	StartServiceCtrlDispatcher(serviceTable);
}

//
//	T[rXCXg[
//
int install_service(void)
{
	SC_HANDLE scm, sc;
	int ret;
	DWORD stype, start;
	SERVICE_DESCRIPTION sd;

	ret = FALSE;
	if((scm = OpenSCManager(0, 0, SC_MANAGER_CREATE_SERVICE))) {
		stype = SERVICE_WIN32_OWN_PROCESS;
		if(desktop_flag) {
			stype |= SERVICE_INTERACTIVE_PROCESS;
		}
		if(auto_flag) {
			start = SERVICE_AUTO_START;
		} else {
			start = SERVICE_DEMAND_START;
		}
		if((sc = CreateService(scm, service_name, service_name,
		                       SERVICE_ALL_ACCESS, stype, start,
			                   SERVICE_ERROR_NORMAL,
							   module_name,
							   NULL, NULL, NULL, NULL, NULL))) {
			sd.lpDescription = description_name;
			ChangeServiceConfig2(sc, SERVICE_CONFIG_DESCRIPTION, &sd);

			CloseServiceHandle(sc);
			ret = TRUE;
		}
		CloseServiceHandle(scm);
	}
	return ret;
}

//
//	T[rX폜
//
int remove_service(void)
{
	SC_HANDLE scm, sc;
	SERVICE_STATUS st;
	int ret;

	ret = FALSE;
	if((scm = OpenSCManager(0, 0, SC_MANAGER_CREATE_SERVICE))) {
		if((sc = OpenService(scm, service_name, SERVICE_ALL_ACCESS | DELETE))) {
			if(QueryServiceStatus(sc, &st)) {
				if(st.dwCurrentState != SERVICE_STOPPED) {
					if(ControlService(sc, SERVICE_CONTROL_STOP, &st)) {
						Sleep(500);
					}
				}
			}
			if(DeleteService(sc)) {
				ret = TRUE;
			}
			CloseServiceHandle(sc);
		}
		CloseServiceHandle(scm);
	}
	return ret;
}

//
//	T[rXƂċN
//
int restart_service(void)
{
	SC_HANDLE scm, sc;
	int ret;

	ret = FALSE;
	if((scm = OpenSCManager(0, 0, SC_MANAGER_CREATE_SERVICE))) {
		if((sc = OpenService(scm, service_name, SERVICE_ALL_ACCESS))) {
			if(StartService(sc, 0, NULL)) {
				ret = TRUE;
			}
			CloseServiceHandle(sc);
		}
		CloseServiceHandle(scm);
	}
	return ret;
}

//
//	T[rXƂċN`FbN
//	st@C̃fBNgƁAJgfBNgr
//
BOOL check_execute_service(void)
{
	unsigned char current_path[MAX_PATH];
	OSVERSIONINFO ovi;
	SC_HANDLE scm, sc;
	SERVICE_STATUS st;
	DWORD size;
	LPQUERY_SERVICE_CONFIG qsc;

	nt_flag = FALSE;
	service_install_flag = FALSE;
	service_stop_flag = FALSE;
	ovi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&ovi);
	if(ovi.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		nt_flag = TRUE;
		GetCurrentDirectory(MAX_PATH, current_path);
		// st@C̃pXƃJgpXႤꍇA
		// T[rXƂċNꂽƔB
		// NhCũ[gɂ̃vOuĂA
		// CreateProcess ňႤfBNgŋNƂ܂
		// 悤ȋCB܂vł傤BB
		if(lstrcmpi(execute_path, current_path)) {
			SetCurrentDirectory(execute_path);
			return TRUE;
		}
		// T[rXCXg[`FbN
		if(scm = OpenSCManager(0, 0, SC_MANAGER_CREATE_SERVICE)) {
			if(sc = OpenService(scm, service_name, SERVICE_ALL_ACCESS)) {
				// T[rXCXg[ς
				service_install_flag = TRUE;
				// 2004/8/9
				QueryServiceConfig(sc, 0, 0, &size);
				qsc = (LPQUERY_SERVICE_CONFIG)LocalAlloc(LPTR, size);
				QueryServiceConfig(sc, qsc, size, &size);
				if(qsc->dwStartType == SERVICE_AUTO_START) {
					auto_flag = 1;
				} else if(qsc->dwStartType == SERVICE_DEMAND_START) {
					auto_flag = 0;
				}
				if(qsc->dwServiceType & SERVICE_INTERACTIVE_PROCESS) {
					desktop_flag = 1;
				} else {
					desktop_flag = 0;
				}
				LocalFree(qsc);
				if(QueryServiceStatus(sc, &st)) {
					if(st.dwCurrentState != SERVICE_STOPPED) {
						service_stop_flag = TRUE;
					}
					ControlService(sc, SERVICE_CONTROL_STOP, &st);
					Sleep(500);
				} else {
					MessageBox(GetDesktopWindow(), "T[rX~ł܂B\nT[rX̌̂郆[U[ŃOCĂB", HEADER, MB_OK);
				}
				CloseServiceHandle(sc);
			}
			CloseServiceHandle(scm);
		}
	}
	return FALSE;
}

//
//	ShiftJIS ̊Pbyteڂ`FbN
//
int iskanji(unsigned char ch)
{
    if(((ch >= 0x81) && (ch <= 0x9f))
        || ((ch >= 0xe0) && (ch <= 0xfc))){
        return TRUE;
    }
    return FALSE;
}

//
//	fBNĝݐ؂o
//
void extract_directory(unsigned char *path)
{
	int flag;
	char *pt;

	pt = NULL;
	flag = FALSE;
	while(*path != '\0') {
		if(flag) {
			flag = FALSE;
		} else {
			if(iskanji(*path)) {
				flag = TRUE;
			} else if(*path == '\\') {
				pt = path;
			}
		}
		path++;
	}
	if(pt != NULL) {
		*pt = '\0';
	}
}

//
//	t@Ĉݎo
//
void extract_name_only(char *name, char *path)
{
	int flag;
	char *pt;

	pt = path;
	flag = FALSE;
	while(*path != '\0') {
		if(flag) {
			flag = FALSE;
		} else {
			if(iskanji(*path)) {
				flag = TRUE;
			} else if(*path == '\\' || *path == ':') {
				pt = path + 1;
			}
		}
		path++;
	}
	while(*pt != '\0' && *pt != '.') {
		*name++ = *pt++;
	}
	*name = '\0';
}

char *extract_ext(char *path)
{
	int len;
	char *pt;

	len = lstrlen(path);
	pt = path + len - 1;
	while(pt != path) {
		if(*pt == '.') {
			return pt + 1;
		}
		if(*pt == '\\' || *pt == '/' || *pt == ':') {
			return path + len;
		}
		pt--;
	}
	return pt;
}

//
//	.ini t@Cǂݏo
//
void get_inifile(void)
{
	GetPrivateProfileString(HEADER, KEY_EXE, "", exe_name, MAX_PATH, ini_name);
	GetPrivateProfileString(HEADER, KEY_OPTION, "", option_name, MAX_PATH, ini_name);
	GetPrivateProfileString(HEADER, KEY_NAME, "", service_name, MAX_PATH, ini_name);
	GetPrivateProfileString(HEADER, KEY_DESCRIPTION, "", description_name, MAX_PATH, ini_name);
	// 2002/6/19
	end_pattern = GetPrivateProfileInt(HEADER, KEY_END, END_SYS_AND_CLOSE, ini_name);
	auto_flag = GetPrivateProfileInt(HEADER, KEY_AUTO, 1, ini_name);
	desktop_flag = GetPrivateProfileInt(HEADER, KEY_DESKTOP, 0, ini_name);
	retry_flag = GetPrivateProfileInt(HEADER, KEY_RETRY, 0, ini_name);
}

void WritePrivateProfileInt(char *section, char *name, int no, char *ini_file_path)
{
	char temp[100];

	wsprintf(temp, "%d", no);
	WritePrivateProfileString(section, name, temp, ini_file_path);
}

//
//	.ini t@Cɏ
//
void set_inifile(void)
{
	WritePrivateProfileString(HEADER, KEY_EXE, exe_name, ini_name);
	WritePrivateProfileString(HEADER, KEY_OPTION, option_name, ini_name);
	WritePrivateProfileString(HEADER, KEY_NAME, service_name, ini_name);
	WritePrivateProfileString(HEADER, KEY_DESCRIPTION, description_name, ini_name);
	WritePrivateProfileInt(HEADER, KEY_END, end_pattern, ini_name);
	// 2004/8/9
	WritePrivateProfileInt(HEADER, KEY_AUTO, auto_flag, ini_name);
	WritePrivateProfileInt(HEADER, KEY_DESKTOP, desktop_flag, ini_name);
	WritePrivateProfileInt(HEADER, KEY_RETRY, retry_flag, ini_name);
}

//
//	eXgN
//
void execute_program(HWND hDlg, char *exe_name, char *option_name, int pattern)
{
	PROCESS_INFORMATION pi;
	DWORD count;

	// vONB
	if(execute_process(exe_name, option_name, &pi)) {
		WaitForInputIdle(pi.hProcess,INFINITE);
		SetForegroundWindow(hDlg);
		MessageBox(hDlg, "vON܂B\nnjNbNƃvOI܂B\nIȂꍇA蓮ŃvOIĂB", HEADER, MB_OK);
		process_id = pi.dwProcessId;
		if(pattern == END_CTRL_BREAK) {
			GenerateConsoleCtrlEvent(CTRL_BREAK_EVENT, process_id);
		} else {
			EnumWindows(EnumWindowsProc, pattern);
		}
		count = GetTickCount() + 30 * 1000;
		// vOI^CAEg(30s)Ŕ
		while(count > GetTickCount()) {
	    	if(WaitForSingleObject(pi.hProcess, 0) != WAIT_TIMEOUT) {
				break;
			}
			Sleep(100);
		}
		// 2001/11/9
		CloseHandle(pi.hThread);
		CloseHandle(pi.hProcess);
	}
	if(pattern == END_CTRL_BREAK) {
		FreeConsole();
	}
}

//
//	_CAObZ[W
//
BOOL APIENTRY MainFunc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	HWND h;
	HDROP hDrop;
	OPENFILENAME ofn;
	HICON hicon;
	char temp[MAX_PATH], temp2[MAX_PATH];
	char *ext;

	switch(message) {
	case WM_INITDIALOG:
		// ACRZbg
		if(hicon = LoadIcon(h_instance, MAKEINTRESOURCE(IDI_ICON_SEXE))) {
			SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hicon);
			SendMessage(hDlg, WM_SETICON, ICON_BIG, (LPARAM)hicon);
		}
		// ݒlRg[ɃZbg
		h = GetDlgItem(hDlg, IDC_EDIT_EXE);
		SetWindowText(h, exe_name);
		EnableWindow(h, !service_install_flag);

		h = GetDlgItem(hDlg, IDC_EDIT_OPTION);
		SetWindowText(h, option_name);
		EnableWindow(h, !service_install_flag);

		h = GetDlgItem(hDlg, IDC_EDIT_NAME);
		SetWindowText(h, service_name);
		EnableWindow(h, !service_install_flag);

		h = GetDlgItem(hDlg, IDC_EDIT_DESCRIPTION);
		SetWindowText(h, description_name);
		EnableWindow(h, !service_install_flag);

		h = GetDlgItem(hDlg, IDC_COMBO_END);
		SendMessage(h, CB_ADDSTRING, 0, (DWORD)"WM_CLOSE");
		// 2002/6/18
		SendMessage(h, CB_ADDSTRING, 0, (DWORD)"WM_SYSCOMMAND(SC_CLOSE)");
		SendMessage(h, CB_ADDSTRING, 0, (DWORD)"WM_SYSCOMMANDWM_CLOSE");
		// 2004/8/9
		SendMessage(h, CB_ADDSTRING, 0, (DWORD)"R\[(CTRL_BREAK)");
		SendMessage(h, CB_SETCURSEL, end_pattern, 0);
		EnableWindow(h, !service_install_flag);

		// 2001/11/9
		h = GetDlgItem(hDlg, IDC_BUTTON_EXE);
		EnableWindow(h, !service_install_flag);

		h = GetDlgItem(hDlg, IDC_BUTTON_TEST);
		if(service_install_flag) {
			SetWindowText(h, "폜(&D)");
		}

		// 2004/8/9
		h = GetDlgItem(hDlg, IDC_CHECK_AUTO);
		SendMessage(h, BM_SETCHECK, auto_flag, 0);
		EnableWindow(h, !service_install_flag);

		h = GetDlgItem(hDlg, IDC_CHECK_DESKTOP);
		SendMessage(h, BM_SETCHECK, desktop_flag, 0);
		EnableWindow(h, !service_install_flag);

		h = GetDlgItem(hDlg, IDC_CHECK_RETRY);
		SendMessage(h, BM_SETCHECK, retry_flag, 0);
		EnableWindow(h, !service_install_flag);
		break;

	case WM_COMMAND:
		switch(LOWORD (wParam)) {
		case IDOK:
			// ݒl
			if(!service_install_flag) {
				h = GetDlgItem(hDlg, IDC_EDIT_NAME);
				GetWindowText(h, service_name, MAX_PATH);
				if(service_name[0] == '\0') {
					MessageBox(hDlg, "T[rXݒ肵ĂB", "Error", MB_OK);
					break;
				}
				h = GetDlgItem(hDlg, IDC_EDIT_EXE);
				GetWindowText(h, exe_name, MAX_PATH);
				// 2007/12/14 test
				ext = extract_ext(exe_name);
				if(exe_name[0] == '\0' || (lstrcmpi(ext, "exe") && lstrcmpi(ext, "bat"))) {
					MessageBox(hDlg, "vOݒ肵ĂB", "Error", MB_OK);
					break;
				}

				h = GetDlgItem(hDlg, IDC_EDIT_OPTION);
				GetWindowText(h, option_name, MAX_PATH);

				h = GetDlgItem(hDlg, IDC_EDIT_DESCRIPTION);
				GetWindowText(h, description_name, MAX_PATH);

				h = GetDlgItem(hDlg, IDC_COMBO_END);
				end_pattern = SendMessage(h, CB_GETCURSEL, 0, 0);

				// 2004/8/9
				h = GetDlgItem(hDlg, IDC_CHECK_AUTO);
				auto_flag = SendMessage(h, BM_GETCHECK, 0, 0);

				h = GetDlgItem(hDlg, IDC_CHECK_DESKTOP);
				desktop_flag = SendMessage(h, BM_GETCHECK, 0, 0);

				h = GetDlgItem(hDlg, IDC_CHECK_RETRY);
				retry_flag = SendMessage(h, BM_GETCHECK, 0, 0);

				// ݒlۑ
				set_inifile();

				if(MessageBox(hDlg, "T[rXɓo^܂H", HEADER, MB_YESNO) == IDYES) {
					if(install_service()) {
						// 2001/11/9
						if(MessageBox(hDlg, "T[rXɓo^܂BT[rXƂċN܂H", HEADER, MB_YESNO) == IDYES) {
							restart_service();
						}
					} else {
						MessageBox(hDlg, "T[rXɓo^ł܂łB\nT[rX̌郆[U[ŃOCĎsĂB", HEADER, MB_OK);
					}
				}
			}
			DestroyWindow(hDlg);
			break;

		case IDCANCEL:
			DestroyWindow(hDlg);
			break;

		case IDC_BUTTON_EXE:
			// Qƃ{^ꂽ
			temp[0] = '\0';
			FillMemory(&ofn, sizeof(OPENFILENAME), 0);
			ofn.lStructSize = sizeof(OPENFILENAME);
			ofn.hwndOwner = hDlg;
			ofn.nMaxFile = MAX_PATH;
			ofn.lpstrFile = temp;
			ofn.lpstrFilter = "st@C(*.exe)\0*.exe\0";
			ofn.lpstrTitle = "st@C̑I";
			ofn.Flags = OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_NOCHANGEDIR;
			if(GetOpenFileName(&ofn)) {
				ext = extract_ext(exe_name);
				if(!lstrcmpi(ext, "exe") || !lstrcmp(ext, "bat")) {
					// .exe t@CZbg
					h = GetDlgItem(hDlg, IDC_EDIT_EXE);
					SetWindowText(h, (LPCTSTR)temp);
					// T[rXƂ .exe t@C̖OZbg
					extract_name_only(temp2, temp);
					h = GetDlgItem(hDlg, IDC_EDIT_NAME);
					SetWindowText(h, (LPCTSTR)temp2);
				} else {
					MessageBox(hDlg, "vOt@Ĉݓo^\łB", "Error", MB_OK);
				}
			}
			break;

		case IDC_BUTTON_TEST:
			// T[rXƂăCXg[ς݁H
			if(service_install_flag) {
				if(MessageBox(hDlg, "T[rX폜܂H", HEADER, MB_YESNO) == IDYES) {
					// T[rX폜
					if(remove_service()) {
						MessageBox(hDlg, "T[rX폜܂B", HEADER, MB_OK);

						service_install_flag = FALSE;
						h = GetDlgItem(hDlg, IDC_EDIT_EXE);
						EnableWindow(h, TRUE);

						h = GetDlgItem(hDlg, IDC_EDIT_OPTION);
						EnableWindow(h, TRUE);

						h = GetDlgItem(hDlg, IDC_EDIT_NAME);
						EnableWindow(h, TRUE);

						h = GetDlgItem(hDlg, IDC_EDIT_DESCRIPTION);
						EnableWindow(h, TRUE);

						h = GetDlgItem(hDlg, IDC_COMBO_END);
						EnableWindow(h, TRUE);

						// 2001/11/9
						h = GetDlgItem(hDlg, IDC_BUTTON_EXE);
						EnableWindow(h, TRUE);

						h = GetDlgItem(hDlg, IDC_BUTTON_TEST);
						SetWindowText(h, "eXgN(&T)");

						// 2004/8/9
						h = GetDlgItem(hDlg, IDC_CHECK_AUTO);
						EnableWindow(h, TRUE);

						h = GetDlgItem(hDlg, IDC_CHECK_DESKTOP);
						EnableWindow(h, TRUE);

						h = GetDlgItem(hDlg, IDC_CHECK_RETRY);
						EnableWindow(h, TRUE);
					} else {
						MessageBox(hDlg, "T[rX폜ł܂łB\nT[rX̌郆[U[ŃOCĎsĂB", HEADER, MB_OK);
					}
				}
			} else {
				// eXgN
				h = GetDlgItem(hDlg, IDC_EDIT_EXE);
				GetWindowText(h, temp, MAX_PATH);

				h = GetDlgItem(hDlg, IDC_EDIT_OPTION);
				GetWindowText(h, temp2, MAX_PATH);

				h = GetDlgItem(hDlg, IDC_COMBO_END);
				execute_program(hDlg, temp, temp2, SendMessage(h, CB_GETCURSEL, 0, 0));
			}
			break;
		}
		break;

	case WM_DROPFILES:
		// Drag&Drop Ŏ󂯂t@Co
		hDrop = (HDROP)wParam;
		DragQueryFile(hDrop, 0, temp, MAX_PATH);
		DragFinish(hDrop);
		if(!service_install_flag) {
			if(!lstrcmpi(extract_ext(temp), "exe")) {
				// .exe t@CZbg
				h = GetDlgItem(hDlg, IDC_EDIT_EXE);
				SetWindowText(h, temp);
				// T[rXƂ .exe t@C̖OZbg
				extract_name_only(temp2, temp);
				h = GetDlgItem(hDlg, IDC_EDIT_NAME);
				SetWindowText(h, (LPCTSTR)temp2);
			} else {
				MessageBox(hDlg, "vOt@Ĉݓo^\łB", "Error", MB_OK);
			}
		}
		SetForegroundWindow(hDlg);
		break;

	case WM_DESTROY:
		// 2001/11/9
		if(service_stop_flag) {
			restart_service();
		}
		PostQuitMessage(0);
		break;

	default:
		return FALSE;
	}
	return FALSE;
}

