#include <stdafx.h>

#pragma comment(lib, "crypt32.lib")
#pragma comment(lib, "version.lib")

CString GetString(int id)
{
	CString str;
	str.LoadString(id);
	return str;
}

void WritePrivateProfileInt(CString section, CString key, int data, CString ini)
{
	CString str;
	str.Format(_T("%d"), data);

	WritePrivateProfileString(section, key, str, ini);
}

CString ExtractFileName(CString name)
{
	int start_pos = name.ReverseFind(_T('\\'));
	int end_pos = name.ReverseFind(_T('.'));
	if(end_pos != -1) {
		return name.Mid(start_pos + 1, end_pos - start_pos - 1);
	}
	return name.Mid(start_pos + 1);
}

TCHAR *SkipSpaceTabCrLf(const TCHAR *pt)
{
	while(*pt == _T(' ') || *pt == _T('\t') || *pt == _T('\r')  || *pt == _T('\n')) {
		pt++;
	}
	return (TCHAR *)pt;
}

int HexToInt(TCHAR ch)
{
	if(ch >= _T('0') && ch <= _T('9')) {
		return ch - _T('0');
	} else if(ch >= _T('a') && ch <= _T('f')) {
		return ch - _T('a') + 10;
	} else if(ch >= _T('A') && ch <= _T('F')) {
		return ch - _T('A') + 10;
	}
	return -1;
}

const CString IndentSpace = _T("  ");
const int IndentLength = 2;

CString FormattingJson(const TCHAR *json)
{
	CString result;
	CString indent;
	TCHAR last;
	bool quote_flag = false;

	json = SkipSpaceTabCrLf(json);
	last = 0;
	while(*json != _T('\0')) {
		if(*json == _T('{') || *json == _T('[')) {
			last = *json;
			result += *json++;
			result += _T("\r\n");
			indent += IndentSpace;
			result += indent;
		} else if(*json == _T('}') || *json == _T(']')) {
			if(indent.GetLength() >= 2) {
				indent = indent.Left(indent.GetLength() - 2);
			} else {
				indent.Empty();
			}
			result += _T("\r\n");
			result += indent;
			last = *json;
			result += *json++;
		} else if(*json == _T(',')) {
			last = *json;
			result += *json++;
			result += _T("\r\n");
			result += indent;
		} else if(*json == _T('\\') && *(json + 1) == _T('u')) {
			int data;
			TCHAR code = 0;
			json += 2;
			while((data = HexToInt(*json)) >= 0) {
				code <<= 4;
				code |= data;
				last = *json;
				json++;
			}
			result += code;
		} else {
			if(*json == _T('"') && last != _T('\\')) {
				quote_flag = !quote_flag;
			}
			last = *json;
			result += *json++;
		}
		if(!quote_flag) {
			json = SkipSpaceTabCrLf(json);
		}
	}
	return result;
}

CString EncryptString(CString str)
{
	CString result;

	if(!str.IsEmpty()) {
		DATA_BLOB bin, bout;

		bin.cbData = (str.GetLength() + 1) * sizeof(TCHAR);
		bin.pbData = (unsigned char *)(const TCHAR *)str;
		if(CryptProtectData(&bin, NULL, NULL, NULL, NULL, 0, &bout)) {
			DWORD dst_length;
			if(CryptBinaryToString(bout.pbData, bout.cbData, CRYPT_STRING_BASE64, NULL, &dst_length)) {
				std::vector<TCHAR> dst_buffer(dst_length + 1);
				if(CryptBinaryToString(bout.pbData, bout.cbData, CRYPT_STRING_BASE64, &dst_buffer[0], &dst_length)) {
					result = CString(&dst_buffer[0]);
					// CRYPT_STRING_NOCRLF  Windows XP ŃT|[gĂȂ
					result.Replace(_T("\r\n"), _T(""));
				}
			}
			LocalFree(bout.pbData);
		}
	}
	return result;
}

CString DecryptString(CString str)
{
	CString result;

	if(!str.IsEmpty()) {
		std::vector<TCHAR> src;
		DWORD dst_length;

		if(CryptStringToBinary(str, str.GetLength(), CRYPT_STRING_BASE64, NULL, &dst_length, NULL, NULL)) {
			std::vector<TCHAR> dst_buffer(dst_length + 1);
			if(CryptStringToBinary(str, str.GetLength(), CRYPT_STRING_BASE64, (unsigned char *)&dst_buffer[0], &dst_length, NULL, NULL)) {
				DATA_BLOB bin, bout;
				bin.cbData = dst_length;
				bin.pbData = (unsigned char *)&dst_buffer[0];
				if(CryptUnprotectData(&bin, NULL, NULL, NULL, NULL, 0, &bout)) {
					result = CString((TCHAR *)bout.pbData);
					LocalFree(bout.pbData);
				}
			}
		}
	}
	return result;
}

CString ExtractDirName(CString name)
{
	int pos = name.ReverseFind(_T('\\'));
	if(pos > 0) {
		name = name.Left(pos);
		if(name.GetLength() == 2) {
			if(name[1] == _T(':')) {
				name += _T("\\");
			}
		}
	}
	return name;
}

CString GetHelpFile()
{
	CString name, chm;
    GetModuleFileName(AfxGetApp()->m_hInstance, name.GetBuffer(MAX_PATH), MAX_PATH);
	name.ReleaseBuffer();
	return ExtractDirName(name) + _T("\\OAuth2Tool.chm");
}

int FileExists(CString name)
{
	HANDLE h;
	WIN32_FIND_DATA ffd;

	if((h = FindFirstFile(name, &ffd)) != INVALID_HANDLE_VALUE) {
		FindClose(h);
		int attr = ffd.dwFileAttributes;
		if(attr == 0) attr = FILE_ATTRIBUTE_ARCHIVE;
		return attr;
	}
	return 0;
}

CString GetVersionString()
{
	TCHAR name[MAX_PATH];
    GetModuleFileName(AfxGetApp()->m_hInstance, name, MAX_PATH);
	VOID *pData;
	VS_FIXEDFILEINFO *pFixedFileInfo;

    DWORD size = GetFileVersionInfoSize(name, NULL);
    pData = new TCHAR[size];

	CString str;
    UINT len;
    if(GetFileVersionInfo(name, NULL, size, pData)) {
		VerQueryValue(pData, _T("\\"), (LPVOID *)&pFixedFileInfo, &len);
		str.Format(_T("Version %d.%d.%d.%d"),
		  HIWORD(pFixedFileInfo->dwProductVersionMS),
		  LOWORD(pFixedFileInfo->dwProductVersionMS),
		  HIWORD(pFixedFileInfo->dwProductVersionLS),
		  LOWORD(pFixedFileInfo->dwProductVersionLS));
	}
	delete [] pData;
	return str;
}

