// Token.cpp : t@C
//

#include "stdafx.h"
#include "OAuth2Tool.h"
#include "Token.h"
#include "afxdialogex.h"

#include "nMail.h"
#include "csub.h"

// CToken _CAO

IMPLEMENT_DYNAMIC(CToken, CDialogEx)

CToken::CToken(CWnd* pParent /*=NULL*/)
	: CDialogEx(CToken::IDD, pParent)
{
	m_access_token = _T("");
	m_client_id = _T("");
	m_client_secret = _T("");
	m_header = _T("");
	m_redirect_uri = _T("");
	m_refresh_token = _T("");
	m_auth_uri = _T("");
	m_response = _T("");
	m_response_data = _T("");
	m_token_uri = _T("");
	m_response_ok = _T("");
	m_response_error = _T("");
	m_socket = INVALID_SOCKET;
	m_param = _T("");
	m_scope = _T("");
	m_state = _T("");
	m_code_verifier = _T("");
	m_state_length = STATE_LENGTH;
	m_code_verifier_length = CODE_VERIFIER_LENGTH;
	m_enable_basic = FALSE;
	m_enable_pkce = FALSE;
	m_enable_state = TRUE;
	m_format_json = TRUE;
}

CToken::~CToken()
{
}

void CToken::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	if(!pDX->m_bSaveAndValidate) {
		if(m_format_json) {
			m_response = FormattingJson(m_response_data);
		} else {
			m_response = m_response_data;
		}
	}
	DDX_Control(pDX, IDC_BUTTON_COPY_ACCESS, m_button_copy_access);
	DDX_Control(pDX, IDC_BUTTON_COPY_REFRESH, m_button_copy_refresh);
	DDX_Control(pDX, IDC_BUTTON_GET_ACCESS, m_button_get_access);
	DDX_Control(pDX, IDC_BUTTON_GET_REFRESH, m_button_get_refresh);
	DDX_Control(pDX, IDC_EDIT_ACCESS_TOKEN, m_edit_access_token);
	DDX_Text(pDX, IDC_EDIT_ACCESS_TOKEN, m_access_token);
	DDX_Text(pDX, IDC_EDIT_CLIENT_ID, m_client_id);
	DDX_Text(pDX, IDC_EDIT_CLIENT_SECRET, m_client_secret);
	DDX_Text(pDX, IDC_EDIT_HEADER, m_header);
	DDX_Text(pDX, IDC_EDIT_REDIRECT_URI, m_redirect_uri);
	DDX_Control(pDX, IDC_EDIT_REFRESH_TOKEN, m_edit_refresh_token);
	DDX_Text(pDX, IDC_EDIT_REFRESH_TOKEN, m_refresh_token);
	DDX_Text(pDX, IDC_EDIT_AUTH_URI, m_auth_uri);
	DDX_Text(pDX, IDC_EDIT_RESPONSE, m_response);
	DDX_Text(pDX, IDC_EDIT_TOKEN_URI, m_token_uri);
	DDX_Check(pDX, IDC_CHECK_BASIC, m_enable_basic);
	DDX_Check(pDX, IDC_CHECK_PKCE, m_enable_pkce);
	DDX_Check(pDX, IDC_CHECK_STATE, m_enable_state);
	DDX_Control(pDX, IDC_EDIT_HEADER, m_edit_header);
	DDX_Text(pDX, IDC_EDIT_PARAM, m_param);
	DDX_Text(pDX, IDC_EDIT_SCOPE, m_scope);
	DDX_Check(pDX, IDC_CHECK_JSON, m_format_json);
	DDX_Control(pDX, IDC_EDIT_RESPONSE, m_edit_response);
}


BEGIN_MESSAGE_MAP(CToken, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_GET_REFRESH, &CToken::OnBnClickedButtonGetRefresh)
	ON_BN_CLICKED(IDC_BUTTON_COPY_REFRESH, &CToken::OnBnClickedButtonCopyRefresh)
	ON_BN_CLICKED(IDC_BUTTON_GET_ACCESS, &CToken::OnBnClickedButtonGetAccess)
	ON_BN_CLICKED(IDC_BUTTON_COPY_ACCESS, &CToken::OnBnClickedButtonCopyAccess)
	ON_MESSAGE(WM_GET_CODE, &CToken::OnGetCode)
	ON_BN_CLICKED(IDC_CHECK_JSON, &CToken::OnBnClickedCheckJson)
END_MESSAGE_MAP()


// CToken bZ[W nh[
BOOL CToken::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	m_edit_response.SetMode(CEditEx::modeResponse);
	m_accel = ::LoadAccelerators(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDR_ACCELERATOR_MAIN));

	return TRUE;
}

void CToken::OnBnClickedButtonGetRefresh()
{
	UpdateData(TRUE);

	if(m_client_id.IsEmpty()) {
		AfxMessageBox(GetString(IDS_ERROR_CLIENT_ID));
		return;
	}
	if(m_client_secret.IsEmpty()) {
		AfxMessageBox(GetString(IDS_ERROR_CLIENT_SECRET));
		return;
	}
	if(m_redirect_uri.IsEmpty()) {
		AfxMessageBox(GetString(IDS_ERROR_REDIRECT_URI));
		return;
	}
	if(m_auth_uri.IsEmpty()) {
		AfxMessageBox(GetString(IDS_ERROR_AUTH_URI));
		return;
	}
	if(m_token_uri.IsEmpty()) {
		AfxMessageBox(GetString(IDS_ERROR_TOKEN_URI));
		return;
	}

	if(m_socket == INVALID_SOCKET) {
		m_refresh_token.Empty();
		m_access_token.Empty();
		m_response_data.Empty();
		UpdateData(FALSE);
		if((m_socket = NMailOAuth2StartRedirectServer(m_redirect_uri, m_response_ok, m_response_error, m_hWnd, WM_GET_CODE, 0)) != INVALID_SOCKET) {
			if(m_enable_state) {
				NMailMakeRandomString(m_state.GetBuffer(m_state_length + 1), m_state_length, 0);
				m_state.ReleaseBuffer();
			} else {
				m_state.Empty();
			}
			if(m_enable_pkce) {
				NMailMakeRandomString(m_code_verifier.GetBuffer(m_code_verifier_length + 1), m_code_verifier_length, 0);
				m_code_verifier.ReleaseBuffer();
			} else {
				m_code_verifier.Empty();
			}
			if(NMailOAuth2RequestAuthorize(m_auth_uri, m_client_id, m_redirect_uri, m_scope, m_state, m_code_verifier, m_param, 0) != NMAIL_SUCCESS) {
				AfxMessageBox(GetString(IDS_ERROR_REFRESH_TOKEN));
				NMailOAuth2EndRedirectServer(m_socket);
				m_socket = INVALID_SOCKET;
			} else {
				m_button_get_refresh.SetWindowText(GetString(IDS_BUTTON_STOP));
			}
		} else {
			AfxMessageBox(GetString(IDS_ERROR_REDIRECT_SERVER));
		}
	} else {
		NMailOAuth2EndRedirectServer(m_socket);
		m_socket = INVALID_SOCKET;
		m_button_get_refresh.SetWindowText(GetString(IDS_BUTTON_START));
	}
	CheckEnableControl();
}

void CToken::OnBnClickedButtonCopyRefresh()
{
	m_edit_refresh_token.SetSel(0, -1);
	m_edit_refresh_token.Copy();
	m_edit_refresh_token.SetSel(0, 0);
}

void CToken::OnBnClickedButtonGetAccess()
{
	UpdateData(TRUE);

	int result;
	int flag = m_enable_basic ? NMAIL_OAUTH2_HEADER_CLIENT_ID : 0;
	result = NMailOAuth2GetAccessToken(m_token_uri, m_client_id, m_client_secret, m_refresh_token, NULL, NULL, m_response_data.GetBuffer(TEMP_MAX), TEMP_MAX, flag);
	m_response_data.ReleaseBuffer();
	if(result == NMAIL_SUCCESS) {
		result = NMailJsonGetValue(m_response_data, _T("access_token"), m_access_token.GetBuffer(TEMP_MAX), TEMP_MAX, 0);
		m_access_token.ReleaseBuffer();
	}
	UpdateData(FALSE);
	if(result == NMAIL_SUCCESS) {
		OnBnClickedButtonCopyAccess();
		GetParent()->PostMessage(WM_CHANGE_ACCESS);
	} else {
		CString text = GetString(IDS_ERROR_ACCESS_TOKEN);
		if(result <= NMAIL_ERROR_HTTP_BAD_REQUEST) {
			CString str;
			str.Format(GetString(IDS_ERROR_NO), -result);
			text += str;
		}
		AfxMessageBox(text);
	}
}

void CToken::OnBnClickedButtonCopyAccess()
{
	m_edit_access_token.SetSel(0, -1);
	m_edit_access_token.Copy();
	m_edit_access_token.SetSel(0, 0);
}

LRESULT CToken::OnGetCode(WPARAM wParam, LPARAM lParam)
{
	CString code, state;
	int result;

	UpdateData(TRUE);

	result = NMailOAuth2GetAuthorizeCode(m_socket, code.GetBuffer(TEMP_MAX), TEMP_MAX, state.GetBuffer(TEMP_MAX), TEMP_MAX);
	code.ReleaseBuffer();
	state.ReleaseBuffer();
	UpdateData(FALSE);

	NMailOAuth2EndRedirectServer(m_socket);
	m_socket = INVALID_SOCKET;

	m_button_get_refresh.SetWindowText(GetString(IDS_BUTTON_START));

	if(result == NMAIL_SUCCESS) {
		if(!m_state.IsEmpty() && state != m_state) {
			AfxMessageBox(GetString(IDS_ERROR_STATE_STRING));
		} else {
			int result;
			int flag = m_enable_basic ? NMAIL_OAUTH2_HEADER_CLIENT_ID : 0;
			result = NMailOAuth2GetRefreshToken(m_token_uri, m_client_id, m_client_secret, m_redirect_uri, code, m_code_verifier, m_param, NULL, m_response_data.GetBuffer(TEMP_MAX), TEMP_MAX, flag);
			m_response_data.ReleaseBuffer();
			if(result == NMAIL_SUCCESS) {
				result = NMailJsonGetValue(m_response_data, _T("refresh_token"), m_refresh_token.GetBuffer(TEMP_MAX), TEMP_MAX, 0);
				m_refresh_token.ReleaseBuffer();
				NMailJsonGetValue(m_response_data, _T("access_token"), m_access_token.GetBuffer(TEMP_MAX), TEMP_MAX, 0);
				m_access_token.ReleaseBuffer();
			}
			UpdateData(FALSE);
			if(result == NMAIL_SUCCESS) {
				OnBnClickedButtonCopyRefresh();
				GetParent()->PostMessage(WM_CHANGE_ACCESS);
			} else {
				if(result == NMAIL_ERROR_JSON_NO_VALUE) {
					AfxMessageBox(GetString(IDS_ERROR_LOGOUT_REFRESH_TOKEN));
				} else {
					CString text = GetString(IDS_ERROR_REFRESH_TOKEN);
					if(result <= NMAIL_ERROR_HTTP_BAD_REQUEST) {
						CString str;
						str.Format(GetString(IDS_ERROR_NO), -result);
						text += str;
					}
					AfxMessageBox(text);
				}
			}
		}
	} else {
		AfxMessageBox(GetString(IDS_ERROR_GET_CODE) + _T("\r\n") + code + _T("\r\n") + state);
	}
	CheckEnableControl();

	return FALSE;
}

void CToken::CheckEnableControl()
{
	UpdateData(TRUE);
	if(m_socket == INVALID_SOCKET) {
		m_button_get_refresh.SetWindowText(GetString(IDS_BUTTON_START));
		m_button_get_access.EnableWindow(!m_refresh_token.IsEmpty());
	} else {
		m_button_get_refresh.SetWindowText(GetString(IDS_BUTTON_STOP));
		m_button_get_access.EnableWindow(FALSE);
	}
	m_button_copy_refresh.EnableWindow(!m_refresh_token.IsEmpty());
	m_button_copy_access.EnableWindow(!m_access_token.IsEmpty());
}


BOOL CToken::PreTranslateMessage(MSG* pMsg)
{
	if(m_accel != NULL) {
		if(::TranslateAccelerator(m_hWnd, m_accel, pMsg)) {
			return TRUE;
		}
	}
	if(pMsg->message == WM_KEYDOWN) {
		if(pMsg->wParam == VK_RETURN) {
			CWnd *wnd = GetFocus();
			if(wnd != &m_edit_header && wnd != &m_edit_response) {
				return TRUE;
			}
		} else if(pMsg->wParam == VK_ESCAPE) {
			return TRUE;
		}
	}
	return CDialogEx::PreTranslateMessage(pMsg);
}

void CToken::KeepData()
{
	m_client_id_keep = m_client_id;
	m_client_secret_keep = m_client_secret;
	m_redirect_uri_keep = m_redirect_uri;
	m_scope_keep = m_scope;
	m_param_keep = m_param;
	m_auth_uri_keep = m_auth_uri;
	m_token_uri_keep = m_token_uri;
	m_header_keep = m_header;
	m_refresh_token_keep = m_refresh_token;
	m_access_token_keep = m_access_token;
	m_enable_basic_keep = m_enable_basic;
	m_enable_pkce_keep = m_enable_pkce;
	m_enable_state_keep = m_enable_state;
}

bool CToken::CheckChangeData()
{
	UpdateData(TRUE);
	if(m_client_id_keep != m_client_id) {
		return true;
	}
	if(m_client_secret_keep != m_client_secret) {
		return true;
	}
	if(m_redirect_uri_keep != m_redirect_uri) {
		return true;
	}
	if(m_scope_keep != m_scope) {
		return true;
	}
	if(m_param_keep != m_param) {
		return true;
	}
	if(m_auth_uri_keep != m_auth_uri) {
		return true;
	}
	if(m_token_uri_keep != m_token_uri) {
		return true;
	}
	if(m_header_keep != m_header) {
		return true;
	}
	if(m_refresh_token_keep != m_refresh_token) {
		return true;
	}
	if(m_access_token_keep != m_access_token) {
		return true;
	}
	if(m_enable_basic_keep != m_enable_basic) {
		return true;
	}
	if(m_enable_pkce_keep != m_enable_pkce) {
		return true;
	}
	if(m_enable_state_keep != m_enable_state) {
		return true;
	}
	return false;
}


void CToken::OnBnClickedCheckJson()
{
	UpdateData(TRUE);
	UpdateData(FALSE);
}

