#pragma once

class CSplit
{
private:
	CString m_div;
	CStringArray m_array;
	CString m_dummy;
public:
	CSplit(const TCHAR *str = NULL, const TCHAR *div = NULL)
	{
		m_div = div ? div : _T("");
		if(str) {
			Split(str, m_div);
		}
	}
	void Split(const TCHAR *s, const TCHAR *div = NULL)
	{
		if(div != NULL) {
			m_div = div;
		}
		m_array.SetSize(0);
		if(m_div == _T("")) {
			m_array.SetAtGrow(0, s);
		} else {
			CString cs = s;
			int pos, wide, start, count = 0;
			start = 0;
			wide = 0;
			for(pos = 0 ; pos < cs.GetLength() ; pos++) {
				if(m_div.Find(cs[pos]) != -1) {
					if(wide > 0) {
						m_array.SetAtGrow(count++, cs.Mid(start, wide));
					}
					for( ; pos < cs.GetLength() ; pos++) {
						if(m_div.Find(cs[pos]) == -1) {
							break;
						}
					}
					start = pos;
					wide = 1;
				} else {
					wide++;
				}
			}
			if(wide > 0 && start != cs.GetLength()) {
				m_array.SetAtGrow(count, cs.Mid(start));
			}
		}
	}
	int GetSize(void)
	{
		return (int)m_array.GetSize();
	}
	CString &operator[](int n)
	{
		if(n < 0 || n >= m_array.GetSize()) {
			m_dummy.Empty();
			return m_dummy;
		}
		return m_array[n];
	}
};

