// Rename.cpp : t@C
//

#include "stdafx.h"
#include "OAuth2Tool.h"
#include "Rename.h"
#include "afxdialogex.h"

#include "csub.h"


// CRename _CAO

IMPLEMENT_DYNAMIC(CRename, CDialogEx)

CRename::CRename(CWnd* pParent /*=NULL*/)
	: CDialogEx(CRename::IDD, pParent)
{
	m_new_flag = false;
	m_copy = TRUE;
	m_name = _T("");
}

CRename::~CRename()
{
}

void CRename::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATIC_TEXT, m_static_text);
	DDX_Text(pDX, IDC_EDIT_NAME, m_name);
	DDX_Control(pDX, IDC_CHECK_COPY, m_check_copy);
	DDX_Check(pDX, IDC_CHECK_COPY, m_copy);
}


BEGIN_MESSAGE_MAP(CRename, CDialogEx)
	ON_BN_CLICKED(IDOK, &CRename::OnBnClickedOk)
END_MESSAGE_MAP()


// CRename bZ[W nh[


BOOL CRename::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	if(m_new_flag) {
		SetWindowText(GetString(IDS_TITLE_NEW));
		m_static_text.SetWindowText(GetString(IDS_TEXT_NEW));
		m_check_copy.ShowWindow(SW_SHOW);
	}

	return TRUE;
}


void CRename::OnBnClickedOk()
{
	UpdateData(TRUE);
	if(m_name.IsEmpty()) {
		AfxMessageBox(GetString(IDS_ERROR_NO_NAME));
		return;
	}

	CDialogEx::OnOK();
}
