// Post.cpp : t@C
//

#include "stdafx.h"
#include "OAuth2Tool.h"
#include "Post.h"
#include "afxdialogex.h"

#include "OAuth2ToolDlg.h"

#include "nMail.h"
#include "Split.h"
#include "csub.h"

// CPost _CAO

IMPLEMENT_DYNAMIC(CPost, CDialogEx)

CPost::CPost(CWnd* pParent /*=NULL*/)
	: CDialogEx(CPost::IDD, pParent)
{
	m_access_token = _T("");
	m_header = _T("");
	m_uri = _T("");
	m_response = _T("");
	m_response_data = _T("");
	m_content_type = contentTypeTextJson;
	m_http_type = httpGet;
	m_enable_bearer = TRUE;
	m_format_json = TRUE;
	m_enable_basic = FALSE;
	m_response_header = _T("");
}

CPost::~CPost()
{
}

void CPost::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	if(!pDX->m_bSaveAndValidate) {
		if(m_format_json) {
			m_response = FormattingJson(m_response_data);
		} else {
			m_response = m_response_data;
		}
	} else {
		m_param = GetParam();
	}
	DDX_Control(pDX, IDC_BUTTON_POST, m_button_post);
	DDX_Text(pDX, IDC_EDIT_HEADER, m_header);
	DDX_Text(pDX, IDC_EDIT_POST_URI, m_uri);
	DDX_Text(pDX, IDC_EDIT_RESPONSE, m_response);
	DDX_Check(pDX, IDC_CHECK_BEARER, m_enable_bearer);
	DDX_Check(pDX, IDC_CHECK_JSON, m_format_json);
	DDX_Control(pDX, IDC_EDIT_HEADER, m_edit_header);
	DDX_CBIndex(pDX, IDC_COMBO_CONTENT, m_content_type);
	DDX_CBIndex(pDX, IDC_COMBO_TYPE, m_http_type);
	DDX_Control(pDX, IDC_COMBO_CONTENT, m_combo_content_type);
	DDX_Check(pDX, IDC_CHECK_BASIC, m_enable_basic);
	DDX_Text(pDX, IDC_EDIT_RESPONSE_HEADER, m_response_header);
	DDX_Control(pDX, IDC_LIST_PARAM, m_list_param);
	DDX_Control(pDX, IDC_EDIT_RESPONSE, m_edit_response);
	DDX_Control(pDX, IDC_EDIT_RESPONSE_HEADER, m_edit_response_header);
}


BEGIN_MESSAGE_MAP(CPost, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_POST, &CPost::OnBnClickedButtonPost)
	ON_CBN_SELCHANGE(IDC_COMBO_TYPE, &CPost::OnSelchangeComboType)
	ON_BN_CLICKED(IDC_CHECK_JSON, &CPost::OnClickedCheckJson)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_PARAM, &CPost::OnRclickListParam)
	ON_COMMAND(IDM_PARAM_DELETE, &CPost::OnParamDelete)
	ON_MESSAGE(WM_ADD_URI, &CPost::OnAddUri)
	ON_MESSAGE(WM_CHANGE_URI, &CPost::OnChangeUri)
END_MESSAGE_MAP()


// CPost bZ[W nh[
BOOL CPost::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	CRect rc;
	double w;
	m_list_param.SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP | LVS_EX_GRIDLINES);
	m_list_param.GetClientRect(rc);
	w = rc.right - rc.left - GetSystemMetrics(SM_CXVSCROLL) - GetSystemMetrics(SM_CXEDGE) * 2;
	w /= 100;
	m_list_param.InsertColumn(itemName, GetString(IDS_ITEM_NAME), LVCFMT_LEFT, static_cast<int>((w * 20)));
	m_list_param.InsertColumn(itemValue, GetString(IDS_ITEM_VALUE), LVCFMT_LEFT, static_cast<int>((w * 80)));

	m_edit_response_header.SetMode(CEditEx::modeResponseHeader);
	m_edit_response.SetMode(CEditEx::modeResponsePost);
	m_accel = ::LoadAccelerators(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDR_ACCELERATOR_MAIN));

	CheckEnableControl();

	return TRUE;
}

BOOL CPost::PreTranslateMessage(MSG* pMsg)
{
	if(m_accel != NULL) {
		if(::TranslateAccelerator(m_hWnd, m_accel, pMsg)) {
			return TRUE;
		}
	}
	if(pMsg->message == WM_KEYDOWN) {
		if(pMsg->wParam == VK_RETURN) {
			CWnd *wnd = GetFocus();
			if(wnd != &m_edit_header) {
				return TRUE;
			}
		} else if(pMsg->wParam == VK_ESCAPE) {
			return TRUE;
		}
	}
	return CDialogEx::PreTranslateMessage(pMsg);
}

void CPost::KeepData()
{
	m_name_keep = m_name;
	m_header_keep = m_header;
	m_uri_keep = m_uri;
	m_param_keep = m_param;
	m_enable_basic_keep = m_enable_basic;
	m_enable_bearer_keep = m_enable_bearer;
	m_format_json_keep = m_format_json;
	m_content_type_keep = m_content_type;
	m_http_type_keep = m_http_type;
}

bool CPost::CheckChangeData()
{
	UpdateData(TRUE);

	if(m_param_keep != m_param) {
		return true;
	}
	if(m_header_keep != m_header) {
		return true;
	}
	if(m_name_keep != m_name) {
		return true;
	}
	if(m_uri_keep != m_uri) {
		return true;
	}
	if(m_enable_basic_keep != m_enable_basic) {
		return true;
	}
	if(m_enable_bearer_keep != m_enable_bearer) {
		return true;
	}
	if(m_format_json_keep != m_format_json) {
		return true;
	}
	if(m_content_type_keep != m_content_type) {
		return true;
	}
	if(m_http_type_keep != m_http_type) {
		return true;
	}
	return false;
}

bool CPost::MakeParam(bool display_flag)
{
	CString name, value, str;

	m_param.Empty();
	if(m_list_param.GetItemCount() == 0) {
		if(display_flag) {
			AfxMessageBox(GetString(IDS_ERROR_EMPTY_DATA));
		}
		return false;
	}
	for(int no = 0 ; no < m_list_param.GetItemCount() ; no++) {
		name = m_list_param.GetItemText(no, itemName);
		value = m_list_param.GetItemText(no, itemValue);
		if(name.IsEmpty() && value.IsEmpty()) {
			continue;
		} else if(name.IsEmpty()) {
			if(display_flag) {
				str.Format(GetString(IDS_ERROR_EMPTY_NAME), no + 1);
				AfxMessageBox(str);
				return false;
			}
		} else if(value.IsEmpty()) {
			if(display_flag) {
				str.Format(GetString(IDS_ERROR_EMPTY_VALUE), no + 1);
				AfxMessageBox(str);
				return false;
			}
		}
		if(!m_param.IsEmpty()) {
			m_param += _T("&");
		}
		m_param += name + _T("=") + value;
	}
	return true;
}

bool CPost::MakeJson()
{
	CString name, value, str;

	if(m_list_param.GetItemCount() == 0) {
		AfxMessageBox(GetString(IDS_ERROR_EMPTY_DATA));
		m_param.Empty();
		return false;
	}
	m_param = _T("{");
	for(int no = 0 ; no < m_list_param.GetItemCount() ; no++) {
		name = m_list_param.GetItemText(no, itemName);
		value = m_list_param.GetItemText(no, itemValue);
		if(name.IsEmpty()) {
			str.Format(GetString(IDS_ERROR_EMPTY_NAME), no + 1);
			AfxMessageBox(str);
			return false;
		} else if(value.IsEmpty()) {
			str.Format(GetString(IDS_ERROR_EMPTY_VALUE), no + 1);
			AfxMessageBox(str);
			return false;
		} else {
			m_param += _T("\"") + name + _T("\":");
			bool flag = false;
			for(int pos = 0 ; pos < value.GetLength() ; pos++) {
				if(value[pos] < L'0' || value[pos] > L'9') {
					if(pos == 0 || value[pos] != '.') {
						flag = true;
						break;
					}
				}
			}
			if(flag && value[0] != _T('[') && value[0] != _T('{')) {
				m_param += _T("\"") + value + _T("\",");
			} else {
				m_param += value + _T(",");
			}
		}
	}
	m_param.TrimRight(_T(","));
	m_param += _T("}");

	return true;
}

void CPost::OnBnClickedButtonPost()
{
	int result, flag;
	CString header;
	CString uri;

	UpdateData(TRUE);
	header = m_header;
	if(m_enable_bearer) {
		if(m_header.Find(_T("Authorization:")) != -1) {
			AfxMessageBox(GetString(IDS_ERROR_HEADER_AUTHORIZATION));
			return;
		}
		if(!header.IsEmpty() && header.Right(1) != _T("\n")) {
			header += _T("\r\n");
		}
		header += _T("Authorization: Bearer ") + m_access_token + _T("\r\n");
	}
	flag = 0;
	if(m_http_type == httpGet) {
		flag |= NMAIL_HTTP_GET;
		MakeParam(false);
	} else if(m_http_type == httpDelete) {
		flag |= NMAIL_HTTP_DELETE;
		MakeParam(false);
	} else {
		if(m_http_type == httpPut) {
			flag |= NMAIL_HTTP_PUT;
		}
		if(m_content_type == contentTypeXWwwFormUrlEncoded) {
			flag |= NMAIL_HTTP_POST_X_WWW_FORM_URLENCODE;
			if(!MakeParam(true)) {
				return;
			}
		} else {
			if(!MakeJson()) {
				return;
			}
			if(!header.IsEmpty() && header.Right(1) != _T("\n")) {
				header += _T("\r\n");
			}
			header += _T("Content-Type: application/json\r\n");
		}
	}
	if(m_enable_basic) {
		flag |= NMAIL_HTTP_BASE64_AUTHORIZATION_BASIC;
	}
	m_response.Empty();
	m_response_data.Empty();
	result = NMailHttpGetPost(m_uri, m_param, header, m_response_data.GetBuffer(TEMP_MAX), TEMP_MAX, flag);
	m_response_data.ReleaseBuffer();
	NMailGetMessage(NMAIL_GET_HTTP_HEADER_MESSAGE, m_response_header.GetBuffer(TEMP_MAX), TEMP_MAX);
	m_response_header.ReleaseBuffer();
	if(result < NMAIL_HTTP_OK) {
		CString text = GetString(IDS_ERROR_POST + m_http_type);
		if(result <= NMAIL_ERROR_HTTP_BAD_REQUEST) {
			CString str;
			str.Format(GetString(IDS_ERROR_NO), -result);
			text += str;
		}
		AfxMessageBox(text);
	}
	UpdateData(FALSE);
	CheckEnableControl();
}

CString CPost::GetParam()
{
	MakeParam(false);
	return m_param;
}

void CPost::SetParam(CString param)
{
	CSplit sp(param, _T("&"));
	int count = 0;

	m_param = param;
	m_list_param.DeleteAllItems();
	for(int no = 0 ; no < sp.GetSize() ; no++) {
		CSplit item(sp[no], _T("="));
		if(item.GetSize() == 2) {
			m_list_param.InsertItem(count, item[0]);
			m_list_param.SetItemText(count, 1, item[1]);
			count++;
		} else if(sp[no].Left(1) == _T("=")) {
			m_list_param.InsertItem(count, _T(""));
			m_list_param.SetItemText(count, 1, item[0]);
			count++;
		} else if(sp[no].Right(1) == _T("=")) {
			m_list_param.InsertItem(count, item[0]);
			count++;
		}
	}
}

void CPost::CheckEnableControl()
{
	UpdateData(TRUE);
	m_combo_content_type.EnableWindow(m_http_type == httpPost || m_http_type == httpPut);
}

void CPost::OnSelchangeComboType()
{
	CheckEnableControl();
}


void CPost::OnClickedCheckJson()
{
	UpdateData(TRUE);
	UpdateData(FALSE);
}

void CPost::OnRclickListParam(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);

	if(m_list_param.GetNextItem(-1, LVNI_SELECTED) != -1) {
		CMenu menu;
		menu.LoadMenu(IDR_MENU_POST);
		CMenu *popup = menu.GetSubMenu(0);

		CPoint pt;
		GetCursorPos(&pt);
		popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, this);
	}
	*pResult = 0;
}

void CPost::OnParamDelete()
{
	int no;

	if((no = m_list_param.GetNextItem(-1, LVNI_SELECTED)) != -1) {
		m_list_param.DeleteItem(no);
	}
}

LRESULT CPost::OnAddUri(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);

	CString str = m_edit_response.GetValueString();
	if(m_uri.Right(str.GetLength()) != str) {
		if(m_uri.Right(1) != _T("/")) {
			m_uri += _T("/");
		}
		m_uri += str;
		UpdateData(FALSE);
	}
	return FALSE;
}

LRESULT CPost::OnChangeUri(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);

	CString str = m_edit_response.GetValueString();
	int pos = m_uri.ReverseFind(_T('/'));
	if(pos != -1) {
		m_uri = m_uri.Left(pos);
	}
	if(m_uri.Right(1) != _T("/")) {
		m_uri += _T("/");
	}
	m_uri += str;
	UpdateData(FALSE);

	return FALSE;
}
