// Param.cpp : t@C
//

#include "stdafx.h"
#include "OAuth2Tool.h"
#include "Param.h"
#include "afxdialogex.h"

#include "Split.h"
#include "csub.h"

// CParam _CAO

IMPLEMENT_DYNAMIC(CParam, CDialogEx)

CParam::CParam(CWnd* pParent /*=NULL*/)
	: CDialogEx(CParam::IDD, pParent)
{
	m_init_flag = false;
}

CParam::~CParam()
{
}

void CParam::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_PARAM, m_list_param);
}


BEGIN_MESSAGE_MAP(CParam, CDialogEx)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_PARAM, &CParam::OnRclickListParam)
	ON_COMMAND(IDM_DELETE, &CParam::OnDelete)
	ON_WM_SIZE()
END_MESSAGE_MAP()


// CParam bZ[W nh[


BOOL CParam::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	m_list_param.SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP | LVS_EX_GRIDLINES);
	double w;
	w = rc.right - rc.left - GetSystemMetrics(SM_CXVSCROLL) - GetSystemMetrics(SM_CXEDGE) * 2;
	w /= 100;
	m_list_param.InsertColumn(itemName, GetString(IDS_ITEM_NAME), LVCFMT_LEFT, static_cast<int>((w * 20)));
	m_list_param.InsertColumn(itemValue, GetString(IDS_ITEM_VALUE), LVCFMT_LEFT, static_cast<int>((w * 80)));

	m_init_flag = true;

	return TRUE;
}

void CParam::SetData(CString str)
{
	CSplit sp(str, _T("&"));
	int count = 0;

	m_list_param.DeleteAllItems();
	for(int no = 0 ; no < sp.GetSize() ; no++) {
		CSplit item(sp[no], _T("="));
		if(item.GetSize() == 2) {
			m_list_param.InsertItem(count, item[0]);
			m_list_param.SetItemText(count, 1, item[1]);
			count++;
		} else if(sp[no].Left(1) == _T("=")) {
			m_list_param.InsertItem(count, _T(""));
			m_list_param.SetItemText(count, 1, item[0]);
			count++;
		} else if(sp[no].Right(1) == _T("=")) {
			m_list_param.InsertItem(count, item[0]);
			count++;
		}
	}
}

bool CParam::MakeParamData(bool display_flag)
{
	CString name, value;

	m_data.Empty();
	if(m_list_param.GetItemCount() == 0) {
		if(display_flag) {
			m_error = GetString(IDS_ERROR_EMPTY_DATA);
			return false;
		}
		return true;
	}
	for(int no = 0 ; no < m_list_param.GetItemCount() ; no++) {
		name = m_list_param.GetItemText(no, itemName);
		value = m_list_param.GetItemText(no, itemValue);
		if(name.IsEmpty() && value.IsEmpty()) {
			continue;
		} else if(name.IsEmpty()) {
			if(display_flag) {
				m_error.Format(GetString(IDS_ERROR_EMPTY_NAME), no + 1);
				return false;
			}
		} else if(value.IsEmpty()) {
			if(display_flag) {
				m_error.Format(GetString(IDS_ERROR_EMPTY_VALUE), no + 1);
				return false;
			}
		}
		if(!m_data.IsEmpty()) {
			m_data += _T("&");
		}
		m_data += name + _T("=") + value;
	}
	return true;
}

bool CParam::MakeJsonData()
{
	CString name, value, str;

	if(m_list_param.GetItemCount() == 0) {
		m_error = GetString(IDS_ERROR_EMPTY_DATA);
		m_data.Empty();
		return false;
	}
	m_data = _T("{");
	for(int no = 0 ; no < m_list_param.GetItemCount() ; no++) {
		name = m_list_param.GetItemText(no, itemName);
		value = m_list_param.GetItemText(no, itemValue);
		if(name.IsEmpty()) {
			m_error.Format(GetString(IDS_ERROR_EMPTY_NAME), no + 1);
			return false;
		} else if(value.IsEmpty()) {
			m_error.Format(GetString(IDS_ERROR_EMPTY_VALUE), no + 1);
			return false;
		} else {
			m_data += _T("\"") + name + _T("\":");
			bool flag = false;
			for(int pos = 0 ; pos < value.GetLength() ; pos++) {
				if(!isdigit(value[pos])) {
					if(pos == 0 || value[pos] != '.') {
						flag = true;
						break;
					}
				}
			}
			if(flag && value[0] != _T('[') && value[0] != _T('{')) {
				m_data += _T("\"") + value + _T("\",");
			} else {
				m_data += value + _T(",");
			}
		}
	}
	m_data.TrimRight(_T(","));
	m_data += _T("}");

	return true;
}

CString CParam::GetData()
{
	return m_data;
}

CString CParam::GetErrorMessage()
{
	return m_error;
}


void CParam::OnRclickListParam(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);

	if(m_list_param.GetNextItem(-1, LVNI_SELECTED) != -1) {
		CMenu menu;
		menu.LoadMenu(IDR_MENU_POST);
		CMenu *popup = menu.GetSubMenu(0);

		CPoint pt;
		GetCursorPos(&pt);
		popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, this);
	}

	*pResult = 0;
}


void CParam::OnDelete()
{
	int no;

	if((no = m_list_param.GetNextItem(-1, LVNI_SELECTED)) != -1) {
		m_list_param.DeleteItem(no);
	}
}


void CParam::OnSize(UINT nType, int cx, int cy)
{
	CDialogEx::OnSize(nType, cx, cy);

	if(m_init_flag) {
		CRect rc;
		GetClientRect(rc);
		m_list_param.MoveWindow(rc);

		double w;
		w = rc.right - rc.left - GetSystemMetrics(SM_CXVSCROLL) - GetSystemMetrics(SM_CXEDGE) * 2;
		w /= 100;
		m_list_param.SetColumnWidth(itemName, static_cast<int>((w * 20)));
		m_list_param.SetColumnWidth(itemValue, static_cast<int>((w * 80)));
	}
}

BOOL CParam::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN) {
		if(pMsg->wParam == VK_RETURN || pMsg->wParam == VK_ESCAPE) {
			return TRUE;
		}
	}
	return CDialogEx::PreTranslateMessage(pMsg);
}
