
// OAuth2ToolDlg.h : wb_[ t@C
//

#pragma once

#include "Post.h"
#include "Token.h"

enum {
	pageToken,
	pageApi,

	pageMax
};

// COAuth2ToolDlg _CAO
class COAuth2ToolDlg : public CDialogEx
{
// RXgNV
public:
	COAuth2ToolDlg(CWnd* pParent = NULL);	// WRXgN^[

// _CAO f[^
	enum { IDD = IDD_OAUTH2TOOL_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV T|[g


// 
protected:
	HICON m_hIcon;

	// ꂽAbZ[W蓖Ċ֐
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

	CToken *m_token;
	std::vector<CPost *> m_post;
	CTabCtrl m_tab_page;
	int m_tab_no;
	CString m_ini_file;
	CString m_param_file;
	HACCEL m_accel;
	std::deque<CString> m_file_list;
	CRect m_page_rc;
	unsigned int m_post_count;
	bool m_change_tab_flag;

	void WriteIni();
	void ReadIni();
	void WriteParam();
	bool ReadParam(CString name);
	void ReadJson(CString name);
	void AddFileList(CString file_name);
	bool CheckChangeData();
	void ClearPostPage();
	void RedrawTabPage();
	void SetTabName(int no);

	afx_msg void OnSelchangeTabPage(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnExit();
	afx_msg void OnOpen();
	afx_msg void OnSave();
	virtual BOOL DestroyWindow();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	afx_msg void OnSaveName();
	afx_msg void OnFileList(UINT nID);
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg LRESULT OnChangeAccess(WPARAM wParam, LPARAM lParam);
	afx_msg void OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu);
public:
	afx_msg void OnReadJson();
	afx_msg void OnAbout();
	afx_msg void OnHelp();
	afx_msg void OnUpdateSave(CCmdUI *pCmdUI);
	afx_msg void OnRclickTabPage(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTabDelete();
	afx_msg void OnUpdateTabDelete(CCmdUI *pCmdUI);
	afx_msg void OnTabAdd();
	afx_msg void OnUpdateTabAdd(CCmdUI *pCmdUI);
	afx_msg void OnTabLeft();
	afx_msg void OnTabRename();
	afx_msg void OnTabRight();
	afx_msg void OnUpdateTabRight(CCmdUI *pCmdUI);
	afx_msg void OnUpdateTabLeft(CCmdUI *pCmdUI);
	afx_msg void OnUpdateTabRename(CCmdUI *pCmdUI);
};
