
// OAuth2ToolDlg.cpp : t@C
//

#include "stdafx.h"
#include "OAuth2Tool.h"
#include "OAuth2ToolDlg.h"
#include "afxdialogex.h"

#include "Rename.h"
#include "About.h"
#include "nMail.h"
#include "Split.h"
#include "csub.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#pragma comment (lib, "htmlhelp.lib")

// COAuth2ToolDlg _CAO
#define	FILE_LIST_MAX		10

const CString IniFile = _T("OAuth2Tool.ini");

const CString SectionFile = _T("FILE");
const CString KeyList = _T("LIST");

const CString SectionParamString = _T("[PARAM]\r\n");

const CString SectionParam = _T("PARAM");
const CString KeyMax = _T("MAX");
const CString KeyFile = _T("FILE");
const CString KeyPage = _T("PAGE");

const CString SectionResponse = _T("RESPONSE");
const CString KeyOk = _T("OK");
const CString KeyError = _T("ERROR");

const CString SectionClient = _T("CLIENT");
const CString KeyId = _T("ID");
const CString KeySecret = _T("SECRET");

const CString SectionUri = _T("URI");
const CString KeyRedirect = _T("REDIRECT");
const CString KeyAuth = _T("AUTH");
const CString KeyToken = _T("TOKEN");

const CString SectionLength = _T("LENGTH");
const CString SectionOption = _T("OPTION");
const CString KeyScope = _T("SCOPE");
const CString KeyHeader = _T("HEADER");
const CString KeyParam = _T("PARAM");
const CString KeyState = _T("STATE");
const CString KeyPkce = _T("PKCE");
const CString KeyBasic = _T("BASIC");
const CString KeyFormat = _T("FORMAT");

const CString SectionApi = _T("API");
const CString KeyName = _T("NAME");
const CString KeyUri = _T("URI");
const CString KeyContent = _T("CONTENT");
const CString KeyType = _T("TYPE");
const CString KeyBearer = _T("BEARER");

const CString SectionToken = _T("TOKEN");
const CString KeyRefresh = _T("REFRESH");
const CString KeyAccess = _T("ACCESS");

COAuth2ToolDlg::COAuth2ToolDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(COAuth2ToolDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_change_tab_flag = false;
}

void COAuth2ToolDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_PAGE, m_tab_page);
}

BEGIN_MESSAGE_MAP(COAuth2ToolDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_PAGE, &COAuth2ToolDlg::OnSelchangeTabPage)
	ON_COMMAND(IDM_EXIT, &COAuth2ToolDlg::OnExit)
	ON_COMMAND(IDM_OPEN, &COAuth2ToolDlg::OnOpen)
	ON_COMMAND(IDM_SAVE, &COAuth2ToolDlg::OnSave)
	ON_COMMAND(IDM_SAVE_NAME, &COAuth2ToolDlg::OnSaveName)
	ON_MESSAGE(WM_CHANGE_ACCESS, &COAuth2ToolDlg::OnChangeAccess)
	ON_WM_HELPINFO()
	ON_COMMAND(IDM_READ_JSON, &COAuth2ToolDlg::OnReadJson)
	ON_WM_INITMENUPOPUP()
	ON_COMMAND(IDM_ABOUT, &COAuth2ToolDlg::OnAbout)
	ON_COMMAND(IDM_HELP, &COAuth2ToolDlg::OnHelp)
	ON_COMMAND_RANGE(IDM_FILE_LIST, IDM_FILE_LIST + FILE_LIST_MAX - 1, &COAuth2ToolDlg::OnFileList)
	ON_UPDATE_COMMAND_UI(IDM_SAVE, &COAuth2ToolDlg::OnUpdateSave)
	ON_NOTIFY(NM_RCLICK, IDC_TAB_PAGE, &COAuth2ToolDlg::OnRclickTabPage)
	ON_COMMAND(IDM_TAB_DELETE, &COAuth2ToolDlg::OnTabDelete)
	ON_UPDATE_COMMAND_UI(IDM_TAB_DELETE, &COAuth2ToolDlg::OnUpdateTabDelete)
	ON_COMMAND(IDM_TAB_ADD, &COAuth2ToolDlg::OnTabAdd)
	ON_UPDATE_COMMAND_UI(IDM_TAB_ADD, &COAuth2ToolDlg::OnUpdateTabAdd)
	ON_COMMAND(IDM_TAB_LEFT, &COAuth2ToolDlg::OnTabLeft)
	ON_COMMAND(IDM_TAB_RENAME, &COAuth2ToolDlg::OnTabRename)
	ON_COMMAND(IDM_TAB_RIGHT, &COAuth2ToolDlg::OnTabRight)
	ON_UPDATE_COMMAND_UI(IDM_TAB_RIGHT, &COAuth2ToolDlg::OnUpdateTabRight)
	ON_UPDATE_COMMAND_UI(IDM_TAB_LEFT, &COAuth2ToolDlg::OnUpdateTabLeft)
	ON_UPDATE_COMMAND_UI(IDM_TAB_RENAME, &COAuth2ToolDlg::OnUpdateTabRename)
END_MESSAGE_MAP()


// COAuth2ToolDlg bZ[W nh[

BOOL COAuth2ToolDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

    // Winsock 
    NMailInitializeWinSock();

	m_token = new CToken();
	m_token->Create(CToken::IDD, this);
	m_tab_page.InsertItem(pageToken, GetString(IDS_PAGE_TOKEN));

	CRect rc;
	m_tab_page.GetWindowRect(m_page_rc);
	m_tab_page.AdjustRect(FALSE, m_page_rc);
	ScreenToClient(m_page_rc);
	m_page_rc.left -= 2;
	m_page_rc.bottom++;
	m_token->MoveWindow(m_page_rc);

	ReadIni();

	m_token->KeepData();

	m_accel = ::LoadAccelerators(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDR_ACCELERATOR_MAIN));

	if(m_tab_no >= m_tab_page.GetItemCount()) {
		m_tab_no = pageToken;
	}
	m_tab_page.SetCurSel(m_tab_no);
	OnSelchangeTabPage(0, 0);

	return TRUE;
}

void COAuth2ToolDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this);

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

HCURSOR COAuth2ToolDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void COAuth2ToolDlg::OnSelchangeTabPage(NMHDR *pNMHDR, LRESULT *pResult)
{
	if(pResult) {
		*pResult = 0;
	}
	m_tab_no = m_tab_page.GetCurSel();
	for(std::vector<CPost *>::iterator post = m_post.begin() ; post != m_post.end() ; ++post) {
		(*post)->ShowWindow(SW_HIDE);
	}
	if(m_tab_no == pageToken) {
		m_token->ShowWindow(SW_SHOW);
	} else if(m_tab_no >= pageApi) {
		m_token->ShowWindow(SW_HIDE);
		m_post[m_tab_no - 1]->ShowWindow(SW_SHOW);
	}
}

void COAuth2ToolDlg::OnExit()
{
	OnCancel();
}

bool COAuth2ToolDlg::CheckChangeData()
{
	if(m_token->CheckChangeData()) {
		return true;
	}
	if(m_post_count != m_post.size()) {
		return true;
	}
	for(std::vector<CPost *>::iterator post = m_post.begin() ; post != m_post.end() ; ++post) {
		if((*post)->CheckChangeData()) {
			return true;
		}
	}
	return m_change_tab_flag;
}

void COAuth2ToolDlg::OnOpen()
{
	if(CheckChangeData()) {
		if(AfxMessageBox(GetString(IDS_WANT_TO_SAVE), MB_YESNO) == IDYES) {
			OnSave();
		}
	}
	CFileDialog dlg(TRUE, GetString(IDS_OA2_EXT), m_param_file, OFN_HIDEREADONLY, GetString(IDS_OA2_DIALOG_EXT), this);
	if(dlg.DoModal() == IDOK) {
		if(ReadParam(dlg.GetPathName())) {
			AddFileList(m_param_file);
			RedrawTabPage();
		}
	}
	PostMessage(WM_NCACTIVATE, TRUE);
}

void COAuth2ToolDlg::AddFileList(CString file_name)
{
	if(m_file_list.size() >= FILE_LIST_MAX) {
		m_file_list.pop_back();
	}
	std::deque<CString>::iterator it = std::find(m_file_list.begin(), m_file_list.end(), file_name);
	if(it != m_file_list.end()) {
		m_file_list.erase(it);
	}
	m_file_list.push_front(file_name);
}

void COAuth2ToolDlg::ReadIni()
{
	CString dir, key, str;

	::GetCurrentDirectory(MAX_PATH, dir.GetBuffer(MAX_PATH));
	dir.ReleaseBuffer();
	m_ini_file = dir + _T("\\") + IniFile;
	::GetPrivateProfileString(SectionParam, KeyFile, _T(""), m_param_file.GetBuffer(TEMP_MAX), TEMP_MAX, m_ini_file);
	m_param_file.ReleaseBuffer();

	m_tab_no = ::GetPrivateProfileInt(SectionParam, KeyPage, pageToken, m_ini_file);
	ReadParam(m_param_file);
	if(m_post.size() == 0) {
		CPost *post = new CPost();
		post->Create(CPost::IDD, this);
		m_tab_page.InsertItem(pageApi, GetString(IDS_PAGE_API));
		post->MoveWindow(m_page_rc);
		post->m_name = str;
		post->m_access_token = m_token->m_access_token;
		post->KeepData();
		m_post.push_back(post);
	}
	m_post_count = (unsigned int)m_post.size();

	m_token->m_state_length = ::GetPrivateProfileInt(SectionLength, KeyState, STATE_LENGTH, m_ini_file);
	m_token->m_code_verifier_length = ::GetPrivateProfileInt(SectionLength, KeyPkce, CODE_VERIFIER_LENGTH, m_ini_file);;
	::GetPrivateProfileString(SectionResponse, KeyOk, GetString(IDS_HTML_RESPONSE_OK), m_token->m_response_ok.GetBuffer(TEMP_MAX), TEMP_MAX, m_ini_file);
	m_token->m_response_ok.ReleaseBuffer();
	::GetPrivateProfileString(SectionResponse, KeyError, GetString(IDS_HTML_RESPONSE_ERROR), m_token->m_response_error.GetBuffer(TEMP_MAX), TEMP_MAX, m_ini_file);
	m_token->m_response_error.ReleaseBuffer();
	for(int no = 0 ; no < FILE_LIST_MAX ; no++) {
		key.Format(_T("%s%d"), KeyList, no + 1);
		::GetPrivateProfileString(SectionFile, key, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_ini_file);
		str.ReleaseBuffer();
		if(str.IsEmpty()) {
			break;
		}
		m_file_list.push_back(str);
	}
}

void COAuth2ToolDlg::WriteIni()
{
	CString key, str;
	HANDLE h;

	if((h = CreateFile(m_ini_file, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0)) != INVALID_HANDLE_VALUE) {
		DWORD size;
		unsigned char bom[2] = {0xff, 0xfe};
		WriteFile(h, bom, 2, &size, NULL);
		WriteFile(h, SectionParamString, SectionParamString.GetLength() * sizeof(TCHAR), &size, NULL);
		CloseHandle(h);
	}
	::WritePrivateProfileString(SectionParam, KeyFile, m_param_file, m_ini_file);
	WritePrivateProfileInt(SectionParam, KeyPage, m_tab_no, m_ini_file);
	int no = 1;
	for(std::deque<CString>::iterator name = m_file_list.begin() ; name != m_file_list.end() ; ++name) {
		if(name->IsEmpty()) {
			break;
		}
		key.Format(_T("%s%d"), KeyList, no++);
		::WritePrivateProfileString(SectionFile, key, *name, m_ini_file);
	}
	key.Format(_T("%s%d"), KeyList, no);
	::WritePrivateProfileString(SectionFile, key, _T(""), m_ini_file);

	::WritePrivateProfileString(SectionResponse, KeyOk, m_token->m_response_ok, m_ini_file);
	::WritePrivateProfileString(SectionResponse, KeyError, m_token->m_response_error, m_ini_file);
	WritePrivateProfileInt(SectionLength, KeyState, m_token->m_state_length, m_ini_file);
	WritePrivateProfileInt(SectionLength, KeyPkce, m_token->m_code_verifier_length, m_ini_file);;
}

void COAuth2ToolDlg::ClearPostPage()
{
	for(std::vector<CPost *>::iterator post = m_post.begin() ; post != m_post.end() ; ++post) {
		(*post)->DestroyWindow();
		delete *post;
	}
	m_post.clear();
}

BOOL COAuth2ToolDlg::DestroyWindow()
{
	UpdateData(TRUE);

	if(CheckChangeData()) {
		if(AfxMessageBox(GetString(IDS_WANT_TO_SAVE), MB_YESNO) == IDYES) {
			OnSave();
		}
	}
	WriteIni();

	NMailEndWinSock();

	if(m_token) {
		m_token->DestroyWindow();
		delete m_token;
		m_token = NULL;
	}
	ClearPostPage();

	return CDialogEx::DestroyWindow();
}

void COAuth2ToolDlg::WriteParam()
{
	if(!m_param_file.IsEmpty()) {
		m_token->UpdateData(TRUE);

		::WritePrivateProfileString(SectionClient, KeyId, EncryptString(m_token->m_client_id), m_param_file);
		::WritePrivateProfileString(SectionClient, KeySecret, EncryptString(m_token->m_client_secret), m_param_file);
		::WritePrivateProfileString(SectionUri, KeyRedirect, EncryptString(m_token->m_redirect_uri), m_param_file);
		::WritePrivateProfileString(SectionUri, KeyAuth, EncryptString(m_token->m_auth_uri), m_param_file);
		::WritePrivateProfileString(SectionUri, KeyToken, EncryptString(m_token->m_token_uri), m_param_file);
		::WritePrivateProfileString(SectionOption, KeyHeader, EncryptString(m_token->m_header), m_param_file);
		::WritePrivateProfileString(SectionOption, KeyScope, EncryptString(m_token->m_scope), m_param_file);
		::WritePrivateProfileString(SectionOption, KeyParam, EncryptString(m_token->m_param), m_param_file);
		WritePrivateProfileInt(SectionOption, KeyState, m_token->m_enable_state, m_param_file);
		WritePrivateProfileInt(SectionOption, KeyPkce, m_token->m_enable_pkce, m_param_file);
		WritePrivateProfileInt(SectionOption, KeyBasic, m_token->m_enable_basic, m_param_file);
		WritePrivateProfileInt(SectionOption, KeyFormat, m_token->m_format_json, m_param_file);
		::WritePrivateProfileString(SectionToken, KeyRefresh, EncryptString(m_token->m_refresh_token), m_param_file);
		::WritePrivateProfileString(SectionToken, KeyAccess, EncryptString(m_token->m_access_token), m_param_file);
		m_token->KeepData();

		CString section;
		int no = 1;
		for(std::vector<CPost *>::iterator post = m_post.begin() ; post != m_post.end() ; ++post) {
			(*post)->UpdateData(TRUE);
			section.Format(_T("%s%d"), GetString(IDS_PAGE_API), no);
			::WritePrivateProfileString(section, KeyName, (*post)->m_name, m_param_file);
			::WritePrivateProfileString(section, KeyUri, EncryptString((*post)->m_uri), m_param_file);
			::WritePrivateProfileString(section, KeyHeader, EncryptString((*post)->m_header), m_param_file);
			::WritePrivateProfileString(section, KeyParam, EncryptString((*post)->GetParam()), m_param_file);
			WritePrivateProfileInt(section, KeyBasic, (*post)->m_enable_basic, m_param_file);
			WritePrivateProfileInt(section, KeyBearer, (*post)->m_enable_bearer, m_param_file);
			WritePrivateProfileInt(section, KeyFormat, (*post)->m_format_json, m_param_file);
			WritePrivateProfileInt(section, KeyContent, (*post)->m_content_type, m_param_file);
			WritePrivateProfileInt(section, KeyType, (*post)->m_http_type, m_param_file);
			(*post)->KeepData();
			no++;
		}
		section.Format(_T("%s%d"), GetString(IDS_PAGE_API), no);
		::WritePrivateProfileString(section, KeyName, _T(""), m_param_file);
		SetWindowText(GetString(IDS_TITLE) + _T(" (") + ExtractFileName(m_param_file) + _T(")"));

		m_post_count = (unsigned int)m_post.size();
		m_change_tab_flag = false;
	}
}

bool COAuth2ToolDlg::ReadParam(CString name)
{
	if(!name.IsEmpty() && FileExists(name)) {
		CString str;

		m_param_file = name;

		SetWindowText(GetString(IDS_TITLE) + _T(" (") + ExtractFileName(m_param_file) + _T(")"));

		::GetPrivateProfileString(SectionClient, KeyId, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
		str.ReleaseBuffer();
		m_token->m_client_id = DecryptString(str);
		::GetPrivateProfileString(SectionClient, KeySecret, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
		str.ReleaseBuffer();
		m_token->m_client_secret = DecryptString(str);
		::GetPrivateProfileString(SectionUri, KeyRedirect, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
		str.ReleaseBuffer();
		m_token->m_redirect_uri = DecryptString(str);
		::GetPrivateProfileString(SectionUri, KeyAuth, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
		str.ReleaseBuffer();
		m_token->m_auth_uri = DecryptString(str);
		::GetPrivateProfileString(SectionUri, KeyToken, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
		str.ReleaseBuffer();
		m_token->m_token_uri = DecryptString(str);
		::GetPrivateProfileString(SectionOption, KeyHeader, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
		str.ReleaseBuffer();
		m_token->m_header = DecryptString(str);
		::GetPrivateProfileString(SectionOption, KeyScope, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
		str.ReleaseBuffer();
		m_token->m_scope = DecryptString(str);
		::GetPrivateProfileString(SectionOption, KeyParam, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
		str.ReleaseBuffer();
		m_token->m_param = DecryptString(str);
		m_token->m_enable_state = ::GetPrivateProfileInt(SectionOption, KeyState, TRUE, m_param_file);
		m_token->m_enable_pkce = ::GetPrivateProfileInt(SectionOption, KeyPkce, FALSE, m_param_file);
		m_token->m_enable_basic = ::GetPrivateProfileInt(SectionOption, KeyBasic, FALSE, m_param_file);
		m_token->m_format_json = ::GetPrivateProfileInt(SectionOption, KeyFormat, TRUE, m_param_file);
		::GetPrivateProfileString(SectionToken, KeyRefresh, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
		str.ReleaseBuffer();
		m_token->m_refresh_token = DecryptString(str);
		::GetPrivateProfileString(SectionToken, KeyAccess, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
		str.ReleaseBuffer();
		m_token->m_access_token = DecryptString(str);

		int no = m_tab_page.GetItemCount() - 1;
		while(no > pageToken) {
			m_tab_page.DeleteItem(no);
			no--;
		}
		ClearPostPage();

		CString section;
		no = 1;
		while(1) {
			section.Format(_T("%s%d"), GetString(IDS_PAGE_API), no);
			::GetPrivateProfileString(section, KeyName, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
			str.ReleaseBuffer();
			if(str.IsEmpty()) {
				if(no == 1) {
					str = GetString(IDS_PAGE_API);
				} else {
					break;
				}
			}
			CPost *post = new CPost();
			post->Create(CPost::IDD, this);
			m_tab_page.InsertItem(no, str);
			post->MoveWindow(m_page_rc);
			post->m_name = str;

			post->m_access_token = m_token->m_access_token;
			::GetPrivateProfileString(section, KeyUri, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
			str.ReleaseBuffer();
			post->m_uri = DecryptString(str);
			::GetPrivateProfileString(section, KeyHeader, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
			str.ReleaseBuffer();
			post->m_header = DecryptString(str);
			::GetPrivateProfileString(section, KeyParam, _T(""), str.GetBuffer(TEMP_MAX), TEMP_MAX, m_param_file);
			str.ReleaseBuffer();
			post->SetParam(DecryptString(str));
			post->m_enable_basic = ::GetPrivateProfileInt(section, KeyBasic, FALSE, m_param_file);
			post->m_enable_bearer = ::GetPrivateProfileInt(section, KeyBearer, TRUE, m_param_file);
			post->m_format_json = ::GetPrivateProfileInt(section, KeyFormat, TRUE, m_param_file);
			post->m_content_type = ::GetPrivateProfileInt(section, KeyContent, contentTypeTextJson, m_param_file);
			post->m_http_type = ::GetPrivateProfileInt(section, KeyType, httpGet, m_param_file);

			post->UpdateData(FALSE);
			post->CheckEnableControl();
			post->KeepData();

			m_post.push_back(post);

			no++;
		}
		m_token->UpdateData(FALSE);
		m_token->CheckEnableControl();
		m_token->KeepData();

		return true;
	}
	return false;
}

BOOL COAuth2ToolDlg::PreTranslateMessage(MSG* pMsg)
{
	if(m_accel != NULL) {
		if(::TranslateAccelerator(m_hWnd, m_accel, pMsg)) {
			return TRUE;
		}
	}
	if(pMsg->message == WM_KEYDOWN) {
		if(pMsg->wParam == VK_RETURN || pMsg->wParam == VK_ESCAPE) {
			return TRUE;
		}
	}
	return CDialogEx::PreTranslateMessage(pMsg);
}

LRESULT COAuth2ToolDlg::OnChangeAccess(WPARAM wParam, LPARAM lParam)
{
	for(std::vector<CPost *>::iterator post = m_post.begin() ; post != m_post.end() ; ++post) {
		(*post)->UpdateData(TRUE);
		(*post)->m_access_token = m_token->m_access_token;
		(*post)->UpdateData(FALSE);
	}
	return FALSE;
}

BOOL COAuth2ToolDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	OnHelp();
	return TRUE;
}

void COAuth2ToolDlg::ReadJson(CString name)
{
	CFile fp;
	if(fp.Open(name, CFile::modeRead)) {
		DWORD len = (DWORD)fp.GetLength();
		std::vector<char> buffer(len + 1);
		fp.Read(&buffer[0], len);
		buffer[len] = 0;

		CString json(&buffer[0]);
		CString value;

		m_token->UpdateData(TRUE);

		NMailJsonGetValue(json, _T("client_id"), value.GetBuffer(TEMP_MAX), TEMP_MAX, 0);
		value.ReleaseBuffer();
		m_token->m_client_id = value;

		NMailJsonGetValue(json, _T("client_secret"), value.GetBuffer(TEMP_MAX), TEMP_MAX, 0);
		value.ReleaseBuffer();
		m_token->m_client_secret = value;

		NMailJsonGetValue(json, _T("auth_uri"), value.GetBuffer(TEMP_MAX), TEMP_MAX, 0);
		value.ReleaseBuffer();
		m_token->m_auth_uri = value;

		NMailJsonGetValue(json, _T("token_uri"), value.GetBuffer(TEMP_MAX), TEMP_MAX, 0);
		value.ReleaseBuffer();
		m_token->m_token_uri = value;

		NMailJsonGetValue(json, _T("redirect_uris"), value.GetBuffer(TEMP_MAX), TEMP_MAX, 0);
		value.ReleaseBuffer();
		CSplit sp(value, _T("\",[]"));
		for(int no = 0 ; no < sp.GetSize() ; no++) {
			if(sp[no].Find(_T("http://localhost")) != -1) {
				m_token->m_redirect_uri = sp[no];
				break;
			}
		}

		m_token->UpdateData(FALSE);

		fp.Close();
	}
}

void COAuth2ToolDlg::OnReadJson()
{
	if(m_token->CheckChangeData()) {
		if(AfxMessageBox(GetString(IDS_WANT_TO_SAVE), MB_YESNO) == IDYES) {
			OnSave();
		}
	}
	CFileDialog dlg(TRUE, GetString(IDS_JSON_EXT), _T(""), OFN_HIDEREADONLY, GetString(IDS_JSON_DIALOG_EXT), this);
	if(dlg.DoModal() == IDOK) {
		ReadJson(dlg.GetPathName());
	}
	PostMessage(WM_NCACTIVATE, TRUE);
}

void COAuth2ToolDlg::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu)
{
	CDialog::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);

	CCmdUI cmdUI;
	cmdUI.m_pMenu = pPopupMenu;
	cmdUI.m_nIndexMax = pPopupMenu->GetMenuItemCount();
	for(cmdUI.m_nIndex = 0 ; cmdUI.m_nIndex < (UINT)pPopupMenu->GetMenuItemCount() ; cmdUI.m_nIndex++) {
		cmdUI.m_nID = pPopupMenu->GetMenuItemID(cmdUI.m_nIndex);
		if(!cmdUI.m_nID) {
			continue;
		} else if(cmdUI.m_nID == (UINT)-1) {
			if((cmdUI.m_pSubMenu = pPopupMenu->GetSubMenu(cmdUI.m_nIndex))) {
				if(nIndex == 0) {
					UINT no, count;
					count = cmdUI.m_pSubMenu->GetMenuItemCount();
					for(no = 0 ; no < count ; no++) {
						cmdUI.m_pSubMenu->RemoveMenu(0, MF_BYPOSITION);
					}
					if(m_file_list.size() > 0) {
						CString str;
						no = 0;
						pPopupMenu->EnableMenuItem(cmdUI.m_nIndex, MF_BYPOSITION);
						for(std::deque<CString>::iterator name = m_file_list.begin() ; name != m_file_list.end() ; ++name) {
							str.Format(_T("&%d %s"), no, *name);
							cmdUI.m_pSubMenu->AppendMenu(MF_STRING, IDM_FILE_LIST + no, str);
							no++;
							if(no >= FILE_LIST_MAX) {
								break;
							}
						}
					} else {
						pPopupMenu->EnableMenuItem(cmdUI.m_nIndex, MF_BYPOSITION | MF_GRAYED);
					}
				} else {
					cmdUI.m_nID = cmdUI.m_pSubMenu->GetMenuItemID(0);
					if(!cmdUI.m_pSubMenu || !cmdUI.m_nID || (cmdUI.m_nID == (UINT)-1)) {
						continue;
					}
					cmdUI.DoUpdate(this, FALSE);
				}
			}
		} else {
			cmdUI.m_pSubMenu = NULL;
			cmdUI.DoUpdate(this, cmdUI.m_nID < 0xF000);
		}
	}
}


void COAuth2ToolDlg::OnAbout()
{
	CAbout dlg(this);
	dlg.DoModal();
}


void COAuth2ToolDlg::OnHelp()
{
	::HtmlHelp(NULL, GetHelpFile(), HH_HELP_CONTEXT, m_tab_page.GetCurSel() == pageToken ? HLP_IDH_TOKEN : HLP_IDH_POST);
}

void COAuth2ToolDlg::OnFileList(UINT nID)
{
	nID -= IDM_FILE_LIST;
	if(nID < m_file_list.size()) {
		if(CheckChangeData()) {
			if(AfxMessageBox(GetString(IDS_WANT_TO_SAVE), MB_YESNO) == IDYES) {
				OnSave();
			}
		}
		if(ReadParam(m_file_list[nID])) {
			m_file_list.erase(m_file_list.begin() + nID);
			m_file_list.push_front(m_param_file);
			RedrawTabPage();
		}
	}
}


void COAuth2ToolDlg::OnSave()
{
	if(m_param_file.IsEmpty()) {
		OnSaveName();
	} else {
		WriteParam();
	}
	PostMessage(WM_NCACTIVATE, TRUE);
}

void COAuth2ToolDlg::OnUpdateSave(CCmdUI *pCmdUI)
{
	if(CheckChangeData()) {
		pCmdUI->Enable(TRUE);
	} else {
		pCmdUI->Enable(FALSE);
	}
}

void COAuth2ToolDlg::OnSaveName()
{
	CFileDialog dlg(FALSE, GetString(IDS_OA2_EXT), m_param_file, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, GetString(IDS_OA2_DIALOG_EXT), this);
	if(dlg.DoModal() == IDOK) {
		m_param_file = dlg.GetPathName();
		WriteParam();
		AddFileList(m_param_file);
	}
	PostMessage(WM_NCACTIVATE, TRUE);
}

void COAuth2ToolDlg::OnRclickTabPage(NMHDR *pNMHDR, LRESULT *pResult)
{
	if(m_tab_no >= pageApi) {
		CMenu menu;
		menu.LoadMenu(IDR_MENU_TAB);
		CMenu *popup = menu.GetSubMenu(0);

		CPoint pt;
		GetCursorPos(&pt);
		popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, AfxGetMainWnd());
	}
	*pResult = 0;
}


void COAuth2ToolDlg::OnTabDelete()
{
	if(m_tab_page.GetItemCount() > pageApi) {
		m_tab_no = m_tab_page.GetCurSel();
		if(m_tab_no >= pageApi) {
			CString str;
			str.Format(GetString(IDS_WANT_TO_DELETE), m_post[m_tab_no - 1]->m_name);
			if(AfxMessageBox(str, MB_YESNO) == IDYES) {
				m_tab_page.DeleteItem(m_tab_no);
				m_post[m_tab_no - 1]->DestroyWindow();
				delete m_post[m_tab_no - 1];
				m_post.erase(m_post.begin() + m_tab_no - 1);
				if(m_tab_no >= m_tab_page.GetItemCount()) {
					m_tab_no = m_tab_page.GetItemCount() - 1;
				}
				m_tab_page.SetCurSel(m_tab_no);
				RedrawTabPage();
			}
		}
	}
}

void COAuth2ToolDlg::OnUpdateTabDelete(CCmdUI *pCmdUI)
{
	m_tab_no = m_tab_page.GetCurSel();
	if(m_tab_no >= pageApi && m_tab_page.GetItemCount() > pageApi + 1) {
		pCmdUI->Enable(TRUE);
	} else {
		pCmdUI->Enable(FALSE);
	}
}


void COAuth2ToolDlg::OnTabAdd()
{
	m_tab_no = m_tab_page.GetCurSel();
	if(m_tab_no >= pageApi) {
		CRename dlg(this);
		dlg.m_new_flag = true;
		if(dlg.DoModal() == IDOK) {
			int no = m_tab_no - 1;
			CPost *post = new CPost();
			post->Create(CPost::IDD, this);
			post->MoveWindow(m_page_rc);
			post->m_name = dlg.m_name;
			if(dlg.m_copy) {
				m_post[no]->UpdateData(TRUE);
				post->m_uri = m_post[no]->m_uri;
				post->m_header = m_post[no]->m_header;
				post->SetParam(m_post[no]->GetParam());
				post->m_enable_basic = m_post[no]->m_enable_basic;
				post->m_enable_bearer = m_post[no]->m_enable_bearer;
				post->m_format_json = m_post[no]->m_format_json;
				post->m_content_type = m_post[no]->m_content_type;
				post->m_http_type = m_post[no]->m_http_type;
				post->m_response_data = m_post[no]->m_response_data;
				post->m_access_token = m_token->m_access_token;
				post->UpdateData(FALSE);
				post->KeepData();
			}
			m_tab_page.InsertItem(m_tab_no + 1, dlg.m_name);
			m_post.insert(m_post.begin() + m_tab_no, post);
			m_tab_page.SetCurSel(m_tab_no + 1);
			OnSelchangeTabPage(0, 0);
		}
	}
}


void COAuth2ToolDlg::OnUpdateTabAdd(CCmdUI *pCmdUI)
{
	if(m_tab_page.GetCurSel() >= pageApi) {
		pCmdUI->Enable(TRUE);
	} else {
		pCmdUI->Enable(FALSE);
	}
}


void COAuth2ToolDlg::SetTabName(int no)
{
	TCITEM ti = { 0 };
	ti.mask = TCIF_TEXT;
	ti.pszText = (TCHAR *)(const TCHAR *)m_post[no]->m_name;
	m_tab_page.SetItem(no + 1, &ti);
}

void COAuth2ToolDlg::OnTabRename()
{
	m_tab_no = m_tab_page.GetCurSel();
	if(m_tab_no >= pageApi) {
		int no = m_tab_no - 1;
		CRename dlg(this);
		dlg.m_name = m_post[no]->m_name;
		if(dlg.DoModal() == IDOK) {
			if(dlg.m_name != m_post[no]->m_name) {
				m_post[no]->m_name = dlg.m_name;
				SetTabName(no);
				OnSelchangeTabPage(0, 0);
			}
		}
	}
}

void COAuth2ToolDlg::OnUpdateTabRename(CCmdUI *pCmdUI)
{
	if(m_tab_page.GetCurSel() >= pageApi) {
		pCmdUI->Enable(TRUE);
	} else {
		pCmdUI->Enable(FALSE);
	}
}

void COAuth2ToolDlg::OnTabLeft()
{
	m_tab_no = m_tab_page.GetCurSel();
	if(m_tab_no > pageApi) {
		int no = m_tab_no - 1;
		CPost *post = m_post[no - 1];
		CString name = m_post[no - 1]->m_name;
		m_post[no - 1] = m_post[no];
		m_post[no] = post;
		SetTabName(no - 1);
		SetTabName(no);
		m_tab_no = no;
		m_tab_page.SetCurSel(m_tab_no);
		RedrawTabPage();
		m_change_tab_flag = true;
	}
}

void COAuth2ToolDlg::OnUpdateTabLeft(CCmdUI *pCmdUI)
{
	if(m_tab_page.GetCurSel() > pageApi) {
		pCmdUI->Enable(TRUE);
	} else {
		pCmdUI->Enable(FALSE);
	}
}

void COAuth2ToolDlg::OnTabRight()
{
	m_tab_no = m_tab_page.GetCurSel();
	if(m_tab_no >= pageApi && m_tab_no < m_tab_page.GetItemCount() - 1) {
		int no = m_tab_no - 1;
		CPost *post = m_post[no + 1];
		CString name = m_post[no + 1]->m_name;
		m_post[no + 1] = m_post[no];
		m_post[no] = post;
		SetTabName(no + 1);
		SetTabName(no);
		m_tab_no++;
		m_tab_page.SetCurSel(m_tab_no);
		RedrawTabPage();
		m_change_tab_flag = true;
	}
}


void COAuth2ToolDlg::OnUpdateTabRight(CCmdUI *pCmdUI)
{
	m_tab_no = m_tab_page.GetCurSel();
	if(m_tab_no >= pageApi && m_tab_no < m_tab_page.GetItemCount() - 1) {
		pCmdUI->Enable(TRUE);
	} else {
		pCmdUI->Enable(FALSE);
	}
}


void COAuth2ToolDlg::RedrawTabPage()
{
	m_tab_no = m_tab_page.GetCurSel();
	if(m_tab_no == pageToken) {
		m_token->ShowWindow(SW_HIDE);
		m_token->ShowWindow(SW_SHOW);
	} else if(m_tab_no >= pageApi) {
		m_post[m_tab_no - 1]->ShowWindow(SW_HIDE);
		m_post[m_tab_no - 1]->ShowWindow(SW_SHOW);
	}
}

