#include "stdafx.h"
#include "ListEx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CListEx

CListEx::CListEx()
{
	m_edit = NULL;
	m_row = -1;
	m_col = -1;
}

CListEx::~CListEx()
{
    if(m_edit) {
		delete m_edit;
		m_edit = NULL;
	}
}


BEGIN_MESSAGE_MAP(CListEx, CListCtrl)
	ON_WM_LBUTTONDBLCLK()
    ON_MESSAGE(WM_END_EDIT, OnEndEdit)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CListEx bZ[W nh


void CListEx::DisplayEdit(int row, int col)
{
	m_row = row;
	m_col = col;

	CString str = GetItemText(m_row, m_col);
	CRect rc;
	GetSubItemRect(m_row, m_col, LVIR_LABEL, rc);
	rc.DeflateRect(1, 1);
	if(m_edit) {
		delete m_edit;
	}
	m_edit = new CEditEx();
	m_edit->Create(WS_VISIBLE | ES_AUTOHSCROLL | ES_LEFT, rc, this, 200);
	m_edit->SetLimitText(0);
	CFont *pFont = GetFont();
	m_edit->SetFont(pFont);

	m_edit->SetWindowText(str);
	int pos = str.GetLength();
	m_edit->SetSel(pos, pos);
	m_edit->SetFocus();
}


void CListEx::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	LVHITTESTINFO hi;
	hi.pt = point;
	ListView_SubItemHitTest(m_hWnd, &hi);

	if(hi.iSubItem >= 0) {
		if(hi.iItem == -1 && hi.iSubItem == 0) {
			hi.iItem = GetItemCount();
			InsertItem(hi.iItem, _T(""));
		}
		if(hi.iItem != -1) {
			if(hi.iItem < GetItemCount()) {
				DisplayEdit(hi.iItem, hi.iSubItem);
			}
		}
	}
}

LRESULT CListEx::OnEndEdit(WPARAM wParam, LPARAM lParam)
{
	if(m_row != -1 && m_col != -1) {
		CString str;
		m_edit->GetWindowText(str);
		if(wParam != CEditEx::editCancel) {
			SetItemText(m_row, m_col, str);
		}
		if(m_row == GetItemCount() - 1 && m_col == 0 && str.IsEmpty()) {
			bool flag = true;
			for(int no = 0 ; no < GetHeaderCtrl()->GetItemCount() ; no++) {
				CString item = GetItemText(m_row, no);
				if(!item.IsEmpty()) {
					flag = false;
					break;
				}
			}
			if(flag) {
				DeleteItem(m_row);
			}
		} else if(wParam == CEditEx::editEnter) {
			if(m_col == 0) {
				DisplayEdit(m_row, m_col + 1);
			} else {
				int count = GetItemCount();
				if(m_row < count - 1) {
					DisplayEdit(m_row + 1, 0);
				} else {
					InsertItem(count, _T(""));
					DisplayEdit(count, 0);
				}
			}
			return 0;
		}
	}
	m_row = -1;
	if(m_edit) {
		delete m_edit;
		m_edit = NULL;
	}
	return 0;
}

