#pragma once

// CEditEx
#define	WM_END_EDIT			(WM_APP+0x0101)
#define	WM_ADD_URI			(WM_APP+0x0102)
#define	WM_CHANGE_URI		(WM_APP+0x0103)

class CEditEx : public CEdit
{
	DECLARE_DYNAMIC(CEditEx)

public:
	enum {
		editCancel,
		editEnter,
		editFocus
	};
	enum {
		modeList,
		modeResponse,
		modeResponseHeader,
		modeResponsePost
	};
	CEditEx();
	virtual ~CEditEx();

protected:
	DECLARE_MESSAGE_MAP()
	int m_mode;
	CString m_key;
	CString m_value;

	afx_msg void OnKillFocus(CWnd* pNewWnd);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnCopyAll();
	afx_msg void OnCopyKey();
	afx_msg void OnCopyValue();
	afx_msg void OnAddUri();
	afx_msg void OnChangeUri();
	void CopyClipBoard(CString str);
public:
	void SetMode(int mode);
	CString GetValueString();
};


