#include "stdafx.h"
#include "OAuth2Tool.h"

#include "resource.h"
#include "csub.h"

#include "EditEx.h"


// CEditEx

IMPLEMENT_DYNAMIC(CEditEx, CEdit)

CEditEx::CEditEx()
{
	m_mode = modeList;
}

CEditEx::~CEditEx()
{
}


BEGIN_MESSAGE_MAP(CEditEx, CEdit)
	ON_WM_KILLFOCUS()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(IDM_COPY_ALL, &CEditEx::OnCopyAll)
	ON_COMMAND(IDM_COPY_KEY, &CEditEx::OnCopyKey)
	ON_COMMAND(IDM_COPY_VALUE, &CEditEx::OnCopyValue)
	ON_COMMAND(IDM_ADD_URI, &CEditEx::OnAddUri)
	ON_COMMAND(IDM_CHANGE_URI, &CEditEx::OnChangeUri)
END_MESSAGE_MAP()



// CEditEx bZ[W nh[

BOOL CEditEx::PreTranslateMessage(MSG* pMsg)
{
	if(m_mode == modeList) {
		if(pMsg->message == WM_KEYDOWN) {
			if(pMsg->wParam == VK_RETURN) {
				GetParent()->PostMessage(WM_END_EDIT, editEnter);
				return FALSE;
			} else if(pMsg->wParam == VK_ESCAPE) {
				GetParent()->PostMessage(WM_END_EDIT, editCancel);
				return FALSE;
			}
		}
	}
	return CEdit::PreTranslateMessage(pMsg);
}

void CEditEx::OnKillFocus(CWnd* pNewWnd)
{
	CEdit::OnKillFocus(pNewWnd);
	if(m_mode == modeList) {
		GetParent()->PostMessage(WM_END_EDIT, editFocus);
	}
}

void CEditEx::SetMode(int mode)
{
	m_mode = mode;
}

void CEditEx::OnContextMenu(CWnd* pWnd, CPoint point)
{
	if(m_mode == modeList) {
		CEdit::OnContextMenu(pWnd, point);
	} else {
		CString str;
		GetWindowText(str);
		if(!str.IsEmpty()) {
			CPoint pt = point;

			ScreenToClient(&pt);
			unsigned int len = CharFromPos(pt);

			TCHAR line[TEMP_MAX];
			int pos = GetLine(len >> 16, line, TEMP_MAX);
			bool value_flag = false;
			m_key.Empty();
			m_value.Empty();
			line[pos] = 0;
			while(pos >= 0) {
				if((m_mode == modeResponse || m_mode == modeResponsePost) && line[pos] == _T(':')) {
					m_value = &line[pos + 1];
					m_value.Trim(_T(" \",[]{}"));
					line[pos] = 0;
					value_flag = true;
				}
				pos--;
			}
			m_key = line;
			m_key.Trim(_T(" \",[]{}"));

			CMenu menu;
			menu.LoadMenu(IDR_MENU_RESPONSE);
			CMenu *popup = menu.GetSubMenu(0);
			if(!m_value.IsEmpty()) {
				popup->AppendMenu(MF_SEPARATOR);
				str.Format(GetString(IDS_EDIT_VALUE_COPY), m_value);
				popup->AppendMenu(MF_STRING, IDM_COPY_VALUE, str);
				if(m_mode == modeResponsePost) {
					popup->AppendMenu(MF_SEPARATOR);
					str.Format(GetString(IDS_EDIT_ADD_URI), m_value);
					popup->AppendMenu(MF_STRING, IDM_ADD_URI, str);
					str.Format(GetString(IDS_EDIT_CHANGE_URI), m_value);
					popup->AppendMenu(MF_STRING, IDM_CHANGE_URI, str);
				}
			}
			if(!m_key.IsEmpty()) {
				popup->AppendMenu(MF_SEPARATOR);
				str.Format(GetString(IDS_EDIT_KEY_COPY), m_key);
				popup->AppendMenu(MF_STRING, IDM_COPY_KEY, str);
			}
			popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y, this);
		}
	}
}

void CEditEx::OnCopyAll()
{
	CString str;
	GetWindowText(str);
	CopyClipBoard(str);
}

void CEditEx::OnCopyKey()
{
	CopyClipBoard(m_key);
}

void CEditEx::OnCopyValue()
{
	CopyClipBoard(m_value);
}

void CEditEx::OnAddUri()
{
	GetParent()->PostMessage(WM_ADD_URI);
}

void CEditEx::OnChangeUri()
{
	GetParent()->PostMessage(WM_CHANGE_URI);
}

CString CEditEx::GetValueString()
{
	return m_value;
}

void CEditEx::CopyClipBoard(CString str)
{
	if(OpenClipboard()) {
		DWORD size = (str.GetLength() + 1) * sizeof(TCHAR);
		HGLOBAL hg = GlobalAlloc(GMEM_MOVEABLE, size);
		if(hg != NULL) {
			LPVOID pt = GlobalLock(hg);
			memcpy(pt, str, size);
			GlobalUnlock(hg);
			EmptyClipboard();
			SetClipboardData(CF_UNICODETEXT, hg);
		}
		CloseClipboard();
	}
}
